/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.advertising;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.advertising.AdvertisingData;
import io.streamlayer.sdk.model.advertising.AdvertisingImage;
import io.streamlayer.sdk.model.advertising.AdvertisingType;
import io.streamlayer.sdk.model.advertising.AdvertisingVideo;
import io.streamlayer.sdk.model.sdksettings.SdkOverlayType;
import io.streamlayer.sdk.repository.advertising.AdvertisingDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class AdvertisingDao_Impl
implements AdvertisingDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<AdvertisingData> __insertionAdapterOfAdvertisingData;
    private final Converters __converters;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllAdvertisingSettings;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAdvertisingSettings;

    public AdvertisingDao_Impl(RoomDatabase roomDatabase) {
        SharedSQLiteStatement sharedSQLiteStatement;
        SharedSQLiteStatement sharedSQLiteStatement2;
        EntityInsertionAdapter<AdvertisingData> entityInsertionAdapter;
        Converters converters;
        Converters converters2 = converters;
        converters = new Converters();
        this.__converters = converters2;
        this.__db = roomDatabase;
        converters2 = entityInsertionAdapter;
        entityInsertionAdapter = new EntityInsertionAdapter<AdvertisingData>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `AdvertisingData` (`id`,`parent_id`,`type`,`template_id`,`overlay_type`,`advertising_type`,`frequency`,`enable`,`images`,`videos`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, AdvertisingData advertisingData) {
                long l = advertisingData.getId();
                supportSQLiteStatement.bindLong(1, l);
                if (advertisingData.getParentId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, advertisingData.getParentId());
                }
                if (advertisingData.getType() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, advertisingData.getType());
                }
                if (advertisingData.getTemplateId() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, advertisingData.getTemplateId());
                }
                if (advertisingData.getOverlayType() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, object.AdvertisingDao_Impl.this.__SdkOverlayType_enumToString(advertisingData.getOverlayType()));
                }
                if (advertisingData.getAdvertisingType() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, object.AdvertisingDao_Impl.this.__AdvertisingType_enumToString(advertisingData.getAdvertisingType()));
                }
                l = advertisingData.getFrequency();
                supportSQLiteStatement.bindLong(7, l);
                l = (long)advertisingData.getEnable();
                supportSQLiteStatement.bindLong(8, l);
                String string2 = object.AdvertisingDao_Impl.this.__converters.advertisingImagesToString(advertisingData.getImages());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, string2);
                }
                Object object = object.AdvertisingDao_Impl.this.__converters.advertisingVideosToString(advertisingData.getVideos());
                if (object == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, (String)object);
                }
            }
        };
        this.__insertionAdapterOfAdvertisingData = converters2;
        converters2 = sharedSQLiteStatement2;
        sharedSQLiteStatement2 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM AdvertisingData";
            }
        };
        this.__preparedStmtOfDeleteAllAdvertisingSettings = converters2;
        converters2 = sharedSQLiteStatement;
        sharedSQLiteStatement = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM AdvertisingData WHERE parent_id=?";
            }
        };
        this.__preparedStmtOfDeleteAdvertisingSettings = converters2;
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private String __SdkOverlayType_enumToString(SdkOverlayType sdkOverlayType) {
        if (sdkOverlayType == null) {
            return null;
        }
        switch (8.$SwitchMap$io$streamlayer$sdk$model$sdksettings$SdkOverlayType[sdkOverlayType.ordinal()]) {
            default: {
                throw new IllegalArgumentException("Can't convert enum to string, unknown enum value: " + (Object)((Object)sdkOverlayType));
            }
            case 12: {
                return "WhosWatching";
            }
            case 11: {
                return "Unrecognized";
            }
            case 10: {
                return "Tickets";
            }
            case 9: {
                return "VoiceChat";
            }
            case 8: {
                return "Contests";
            }
            case 7: {
                return "Merchandise";
            }
            case 6: {
                return "Twitter";
            }
            case 5: {
                return "Betting";
            }
            case 4: {
                return "Statistics";
            }
            case 3: {
                return "Messaging";
            }
            case 2: {
                return "Inplay";
            }
            case 1: 
        }
        return "Unset";
    }

    private String __AdvertisingType_enumToString(AdvertisingType advertisingType) {
        if (advertisingType == null) {
            return null;
        }
        switch (8.$SwitchMap$io$streamlayer$sdk$model$advertising$AdvertisingType[advertisingType.ordinal()]) {
            default: {
                throw new IllegalArgumentException("Can't convert enum to string, unknown enum value: " + (Object)((Object)advertisingType));
            }
            case 5: {
                return "UNRECOGNIZED";
            }
            case 4: {
                return "BANNERS";
            }
            case 3: {
                return "INTERSTITIALS";
            }
            case 2: {
                return "SPONSORS";
            }
            case 1: 
        }
        return "UNSET";
    }

    private SdkOverlayType __SdkOverlayType_stringToEnum(String string2) {
        if (string2 == null) {
            return null;
        }
        String string3 = string2;
        string3.hashCode();
        int n = -1;
        switch (string3.hashCode()) {
            default: {
                break;
            }
            case 1898876227: {
                if (!string2.equals("Statistics")) break;
                n = 11;
                break;
            }
            case 1447933663: {
                if (!string2.equals("Betting")) break;
                n = 10;
                break;
            }
            case 984424330: {
                if (!string2.equals("VoiceChat")) break;
                n = 9;
                break;
            }
            case 748307027: {
                if (!string2.equals("Twitter")) break;
                n = 8;
                break;
            }
            case 563959524: {
                if (!string2.equals("Messaging")) break;
                n = 7;
                break;
            }
            case 341675719: {
                if (!string2.equals("Tickets")) break;
                n = 6;
                break;
            }
            case 81890057: {
                if (!string2.equals("Unset")) break;
                n = 5;
                break;
            }
            case -502672897: {
                if (!string2.equals("Contests")) break;
                n = 4;
                break;
            }
            case -986280856: {
                if (!string2.equals("WhosWatching")) break;
                n = 3;
                break;
            }
            case -1579171569: {
                if (!string2.equals("Unrecognized")) break;
                n = 2;
                break;
            }
            case -2053342301: {
                if (!string2.equals("Merchandise")) break;
                n = 1;
                break;
            }
            case -2100008455: {
                if (!string2.equals("Inplay")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                throw new IllegalArgumentException("Can't convert value to enum, unknown value: " + string2);
            }
            case 11: {
                return SdkOverlayType.Statistics;
            }
            case 10: {
                return SdkOverlayType.Betting;
            }
            case 9: {
                return SdkOverlayType.VoiceChat;
            }
            case 8: {
                return SdkOverlayType.Twitter;
            }
            case 7: {
                return SdkOverlayType.Messaging;
            }
            case 6: {
                return SdkOverlayType.Tickets;
            }
            case 5: {
                return SdkOverlayType.Unset;
            }
            case 4: {
                return SdkOverlayType.Contests;
            }
            case 3: {
                return SdkOverlayType.WhosWatching;
            }
            case 2: {
                return SdkOverlayType.Unrecognized;
            }
            case 1: {
                return SdkOverlayType.Merchandise;
            }
            case 0: 
        }
        return SdkOverlayType.Inplay;
    }

    private AdvertisingType __AdvertisingType_stringToEnum(String string2) {
        if (string2 == null) {
            return null;
        }
        String string3 = string2;
        string3.hashCode();
        int n = -1;
        switch (string3.hashCode()) {
            default: {
                break;
            }
            case 573789423: {
                if (!string2.equals("UNRECOGNIZED")) break;
                n = 4;
                break;
            }
            case 387946151: {
                if (!string2.equals("INTERSTITIALS")) break;
                n = 3;
                break;
            }
            case 381022887: {
                if (!string2.equals("BANNERS")) break;
                n = 2;
                break;
            }
            case 80904969: {
                if (!string2.equals("UNSET")) break;
                n = 1;
                break;
            }
            case -1053491047: {
                if (!string2.equals("SPONSORS")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                throw new IllegalArgumentException("Can't convert value to enum, unknown value: " + string2);
            }
            case 4: {
                return AdvertisingType.UNRECOGNIZED;
            }
            case 3: {
                return AdvertisingType.INTERSTITIALS;
            }
            case 2: {
                return AdvertisingType.BANNERS;
            }
            case 1: {
                return AdvertisingType.UNSET;
            }
            case 0: 
        }
        return AdvertisingType.SPONSORS;
    }

    @Override
    public Object saveAdvertisings(final List<AdvertisingData> list, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                Unit unit;
                4 v0 = this;
                v0.AdvertisingDao_Impl.this.__db.beginTransaction();
                try {
                    v0.AdvertisingDao_Impl.this.__insertionAdapterOfAdvertisingData.insert((Iterable)list);
                    v0.AdvertisingDao_Impl.this.__db.setTransactionSuccessful();
                    unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    AdvertisingDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                AdvertisingDao_Impl.this.__db.endTransaction();
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteAllAdvertisingSettings(Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                5 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.AdvertisingDao_Impl.this.__preparedStmtOfDeleteAllAdvertisingSettings.acquire();
                AdvertisingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    5 v2 = this;
                    v2.AdvertisingDao_Impl.this.__db.endTransaction();
                    v2.AdvertisingDao_Impl.this.__preparedStmtOfDeleteAllAdvertisingSettings.release(supportSQLiteStatement);
                    throw throwable;
                }
                v0.AdvertisingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                5 v4 = this;
                v4.AdvertisingDao_Impl.this.__db.endTransaction();
                v4.AdvertisingDao_Impl.this.__preparedStmtOfDeleteAllAdvertisingSettings.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteAdvertisingSettings(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                6 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.AdvertisingDao_Impl.this.__preparedStmtOfDeleteAdvertisingSettings.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                AdvertisingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    6 v2 = this;
                    v2.AdvertisingDao_Impl.this.__db.endTransaction();
                    v2.AdvertisingDao_Impl.this.__preparedStmtOfDeleteAdvertisingSettings.release(supportSQLiteStatement);
                    throw throwable;
                }
                AdvertisingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                6 v4 = this;
                v4.AdvertisingDao_Impl.this.__db.endTransaction();
                v4.AdvertisingDao_Impl.this.__preparedStmtOfDeleteAdvertisingSettings.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object getAdvertisingByOverlay(SdkOverlayType sdkOverlayType, Continuation<? super List<AdvertisingData>> continuation) {
        Callable<List<AdvertisingData>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM AdvertisingData WHERE overlay_type =?", (int)1);
        int n = 1;
        if (sdkOverlayType == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, this.__SdkOverlayType_enumToString(sdkOverlayType));
        }
        sdkOverlayType = DBUtil.createCancellationSignal();
        Callable<List<AdvertisingData>> callable2 = callable;
        callable = new Callable<List<AdvertisingData>>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<AdvertisingData> call() throws Exception {
                ArrayList<AdvertisingData> arrayList;
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                Cursor cursor = DBUtil.query((RoomDatabase)AdvertisingDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                try {
                    n10 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"id");
                    n9 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"parent_id");
                    n8 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"type");
                    n7 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"template_id");
                    n6 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"overlay_type");
                    n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"advertising_type");
                    n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"frequency");
                    n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"enable");
                    n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"images");
                    n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"videos");
                }
                catch (Throwable throwable) {
                    cursor.close();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                ArrayList<AdvertisingData> arrayList2 = arrayList;
                arrayList = new ArrayList<AdvertisingData>(cursor.getCount());
                while (cursor.moveToNext()) {
                    int n11 = cursor.getInt(n10);
                    String string2 = cursor.isNull(n9) ? null : cursor.getString(n9);
                    String string3 = cursor.isNull(n8) ? null : cursor.getString(n8);
                    String string4 = cursor.isNull(n7) ? null : cursor.getString(n7);
                    7 v2 = this;
                    SdkOverlayType sdkOverlayType = v2.AdvertisingDao_Impl.this.__SdkOverlayType_stringToEnum(cursor.getString(n6));
                    AdvertisingType advertisingType = v2.AdvertisingDao_Impl.this.__AdvertisingType_stringToEnum(cursor.getString(n5));
                    int n12 = cursor.getInt(n4);
                    boolean bl = cursor.getInt(n3) != 0;
                    Object object = cursor.isNull(n2) ? null : cursor.getString(n2);
                    object = AdvertisingDao_Impl.this.__converters.stringToAdvertisingImages((String)object);
                    Object object2 = cursor.isNull(n) ? null : cursor.getString(n);
                    object2 = AdvertisingDao_Impl.this.__converters.stringToAdvertisingVideos((String)object2);
                    arrayList2.add(new AdvertisingData(n11, string2, string3, string4, sdkOverlayType, advertisingType, n12, bl, (List<AdvertisingImage>)object, (List<AdvertisingVideo>)object2));
                }
                cursor.close();
                roomSQLiteQuery.release();
                return arrayList2;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)sdkOverlayType, (Callable)callable2, continuation);
    }
}

