/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view.internal.format;

import android.text.TextUtils;
import android.util.LruCache;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.model.social.TweetHashtag;
import io.streamlayer.sdk.model.social.TweetMedia;
import io.streamlayer.sdk.model.social.TweetSymbol;
import io.streamlayer.sdk.model.social.TweetUrl;
import io.streamlayer.sdk.model.social.TweetUserMention;
import io.streamlayer.sdk.twitter.view.internal.format.FormattedMediaEntity;
import io.streamlayer.sdk.twitter.view.internal.format.FormattedText;
import io.streamlayer.sdk.twitter.view.internal.format.FormattedUrlEntity;
import io.streamlayer.sdk.twitter.view.internal.format.HtmlEntities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\nJ/\u0010\u0010\u001a\u00020\b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J#\u0010\u0015\u001a\u00020\b2\n\u0010\u0014\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u0018\u001a\u00020\b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u000bH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0011J\u0015\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0006R\"\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00040\u001a8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006!"}, d2={"Lio/streamlayer/sdk/twitter/view/internal/format/TweetFormatter;", "", "Lio/streamlayer/sdk/model/social/Tweet;", "tweet", "Lio/streamlayer/sdk/twitter/view/internal/format/FormattedText;", "format", "(Lio/streamlayer/sdk/model/social/Tweet;)Lio/streamlayer/sdk/twitter/view/internal/format/FormattedText;", "formattedText", "", "convertEntities", "(Lio/streamlayer/sdk/twitter/view/internal/format/FormattedText;Lio/streamlayer/sdk/model/social/Tweet;)V", "", "Lio/streamlayer/sdk/twitter/view/internal/format/FormattedUrlEntity;", "entities", "", "indices", "adjustIndicesForEscapedChars", "(Ljava/util/List;Ljava/util/List;)V", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "content", "adjustIndicesForSupplementaryChars", "(Ljava/lang/StringBuilder;Lio/streamlayer/sdk/twitter/view/internal/format/FormattedText;)V", "", "adjustEntitiesWithOffsets", "formatTweetText", "Landroid/util/LruCache;", "", "cache", "Landroid/util/LruCache;", "<init>", "()V", "Companion", "sdk_originalRelease"})
public final class TweetFormatter {
    private static final int DEFAULT_CACHE_SIZE = 20;
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final LruCache<Long, FormattedText> cache;

    private final FormattedText format(Tweet tweet) {
        FormattedText formattedText;
        FormattedText formattedText2 = formattedText;
        TweetFormatter tweetFormatter = this;
        formattedText2();
        tweetFormatter.convertEntities(formattedText2, tweet);
        tweetFormatter.format(formattedText2, tweet);
        return formattedText;
    }

    private final void convertEntities(FormattedText formattedText, Tweet object3) {
        for (TweetUrl tweetUrl : ((Tweet)object3).getMetaData().getEntities().getUrls()) {
            formattedText.getUrlEntities().add(FormattedUrlEntity.Companion.from(tweetUrl));
        }
        for (TweetMedia tweetMedia : ((Tweet)object3).getMetaData().getEntities().getMedia()) {
            formattedText.getMediaEntities().add(new FormattedMediaEntity(tweetMedia));
        }
        for (TweetHashtag tweetHashtag : ((Tweet)object3).getMetaData().getEntities().getHashtags()) {
            formattedText.getHashtagEntities().add(FormattedUrlEntity.Companion.from(tweetHashtag));
        }
        for (TweetUserMention tweetUserMention : ((Tweet)object3).getMetaData().getEntities().getUserMentions()) {
            formattedText.getMentionEntities().add(FormattedUrlEntity.Companion.from(tweetUserMention));
        }
        for (TweetSymbol tweetSymbol : ((Tweet)object3).getMetaData().getEntities().getSymbols()) {
            formattedText.getSymbolEntities().add(FormattedUrlEntity.Companion.from(tweetSymbol));
        }
    }

    private final void format(FormattedText formattedText, Tweet list) {
        StringBuilder stringBuilder;
        if (TextUtils.isEmpty((CharSequence)((Tweet)((Object)list)).getText())) {
            return;
        }
        TweetFormatter tweetFormatter = stringBuilder2;
        HtmlEntities.Unescaped unescaped = HtmlEntities.HTML40.unescape(((Tweet)((Object)list)).getText());
        list = unescaped;
        TweetFormatter tweetFormatter2 = stringBuilder2;
        List<FormattedUrlEntity> list2 = list;
        TweetFormatter tweetFormatter3 = stringBuilder2;
        List<FormattedUrlEntity> list3 = list;
        TweetFormatter tweetFormatter4 = stringBuilder2;
        List<FormattedUrlEntity> list4 = list;
        TweetFormatter tweetFormatter5 = stringBuilder2;
        List<FormattedUrlEntity> list5 = list;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(((HtmlEntities.Unescaped)((Object)list)).unescaped);
        list = formattedText.getUrlEntities();
        tweetFormatter5.adjustIndicesForEscapedChars(list, ((HtmlEntities.Unescaped)((Object)list5)).indices);
        list = formattedText.getMediaEntities();
        tweetFormatter4.adjustIndicesForEscapedChars(list, ((HtmlEntities.Unescaped)((Object)list4)).indices);
        list = formattedText.getHashtagEntities();
        tweetFormatter3.adjustIndicesForEscapedChars(list, ((HtmlEntities.Unescaped)((Object)list3)).indices);
        list = formattedText.getMentionEntities();
        tweetFormatter2.adjustIndicesForEscapedChars(list, ((HtmlEntities.Unescaped)((Object)list2)).indices);
        list = formattedText.getSymbolEntities();
        tweetFormatter.adjustIndicesForEscapedChars(list, unescaped.indices);
        tweetFormatter.adjustIndicesForSupplementaryChars(stringBuilder2, formattedText);
        formattedText.setText(stringBuilder2.toString());
    }

    private final void adjustIndicesForEscapedChars(List<? extends FormattedUrlEntity> list, List<int[]> list2) {
        if (list != null && list2 != null && !list2.isEmpty()) {
            int n = list2.size();
            int n2 = 0;
            int n3 = 0;
            for (FormattedUrlEntity formattedUrlEntity : list) {
                int n4 = 0;
                int n5 = n3;
                n3 = n2;
                int n6 = n4;
                n4 = n5;
                while (n2 < n) {
                    int[] nArray = list2.get(n2);
                    int n7 = nArray[0];
                    int n8 = nArray[1];
                    n7 = n8 - n7;
                    if (n8 < formattedUrlEntity.getStart()) {
                        n4 += n7;
                        ++n3;
                    } else if (n8 < formattedUrlEntity.getEnd()) {
                        n6 += n7;
                    }
                    ++n2;
                }
                FormattedUrlEntity formattedUrlEntity2 = formattedUrlEntity;
                n2 = n4 + n6;
                formattedUrlEntity2.setStart(formattedUrlEntity2.getStart() - n2);
                formattedUrlEntity2.setEnd(formattedUrlEntity2.getEnd() - n2);
                int n7 = n3;
                n3 = n4;
                n2 = n7;
            }
            return;
        }
    }

    private final void adjustIndicesForSupplementaryChars(StringBuilder stringBuilder, FormattedText formattedText) {
        ArrayList<Integer> arrayList;
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList = new ArrayList<Integer>();
        int n = stringBuilder.length() - 1;
        for (int j = 0; j < n; ++j) {
            if (!Character.isHighSurrogate(stringBuilder.charAt(j)) || !Character.isLowSurrogate(stringBuilder.charAt(j + 1))) continue;
            arrayList2.add(j);
        }
        this.adjustEntitiesWithOffsets(formattedText.getUrlEntities(), arrayList2);
        this.adjustEntitiesWithOffsets(formattedText.getMediaEntities(), arrayList2);
        this.adjustEntitiesWithOffsets(formattedText.getHashtagEntities(), arrayList2);
        this.adjustEntitiesWithOffsets(formattedText.getMentionEntities(), arrayList2);
        this.adjustEntitiesWithOffsets(formattedText.getSymbolEntities(), arrayList2);
    }

    private final void adjustEntitiesWithOffsets(List<? extends FormattedUrlEntity> object, List<Integer> list) {
        if (object != null && list != null) {
            Iterator<? extends FormattedUrlEntity> iterator = object.iterator();
            while (iterator.hasNext()) {
                object = (FormattedUrlEntity)iterator.next();
                int n = ((FormattedUrlEntity)object).getStart();
                int n2 = 0;
                Iterator<Integer> iterator2 = list.iterator();
                while (iterator2.hasNext() && ((Number)iterator2.next()).intValue() - n2 <= n) {
                    ++n2;
                }
                Object object2 = object;
                ((FormattedUrlEntity)object2).setStart(((FormattedUrlEntity)object2).getStart() + n2);
                ((FormattedUrlEntity)object2).setEnd(((FormattedUrlEntity)object2).getEnd() + n2);
            }
            return;
        }
    }

    public TweetFormatter() {
        LruCache lruCache;
        TweetFormatter tweetFormatter = lruCache;
        lruCache = new LruCache(20);
        v1.cache = tweetFormatter;
    }

    @NotNull
    public final FormattedText formatTweetText(@NotNull Tweet object) {
        Tweet tweet = object;
        Intrinsics.checkNotNullParameter((Object)tweet, (String)"tweet");
        Long l = StringsKt.toLongOrNull((String)tweet.getId());
        long l2 = l != null ? l : 0L;
        FormattedText formattedText = (FormattedText)this.cache.get((Object)l2);
        if (formattedText != null) {
            return formattedText;
        }
        if (!TextUtils.isEmpty((CharSequence)((FormattedText)(object = this.format((Tweet)object))).getText())) {
            this.cache.put((Object)l2, object);
        }
        return object;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lio/streamlayer/sdk/twitter/view/internal/format/TweetFormatter$Companion;", "", "", "DEFAULT_CACHE_SIZE", "I", "<init>", "()V", "sdk_originalRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

