/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.database;

import android.content.Context;
import android.os.Build;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import io.streamlayer.common.data.database.AppDatabase;
import io.streamlayer.sdk.repository.advertising.AdvertisingDao;
import io.streamlayer.sdk.repository.advertising.AdvertisingDao_Impl;
import io.streamlayer.sdk.repository.analytics.AnalyticsDao;
import io.streamlayer.sdk.repository.analytics.AnalyticsDao_Impl;
import io.streamlayer.sdk.repository.messaging.MessagingDao;
import io.streamlayer.sdk.repository.messaging.MessagingDao_Impl;
import io.streamlayer.sdk.repository.notifications.NotificationDao;
import io.streamlayer.sdk.repository.notifications.NotificationDao_Impl;
import io.streamlayer.sdk.repository.phonecontact.PhoneContactDao;
import io.streamlayer.sdk.repository.phonecontact.PhoneContactDao_Impl;
import io.streamlayer.sdk.repository.sports.baseball.BaseballDao;
import io.streamlayer.sdk.repository.sports.baseball.BaseballDao_Impl;
import io.streamlayer.sdk.repository.sports.basketball.BasketballDao;
import io.streamlayer.sdk.repository.sports.basketball.BasketballDao_Impl;
import io.streamlayer.sdk.repository.sports.events.SportEventsDao;
import io.streamlayer.sdk.repository.sports.events.SportEventsDao_Impl;
import io.streamlayer.sdk.repository.sports.hockey.HockeyDao;
import io.streamlayer.sdk.repository.sports.hockey.HockeyDao_Impl;
import io.streamlayer.sdk.repository.tinodecontacts.TinodeContactDao;
import io.streamlayer.sdk.repository.tinodecontacts.TinodeContactDao_Impl;
import io.streamlayer.sdk.repository.watchparty.WatchPartyDao;
import io.streamlayer.sdk.repository.watchparty.WatchPartyDao_Impl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class AppDatabase_Impl
extends AppDatabase {
    private volatile PhoneContactDao _phoneContactDao;
    private volatile TinodeContactDao _tinodeContactDao;
    private volatile NotificationDao _notificationDao;
    private volatile SportEventsDao _sportEventsDao;
    private volatile BasketballDao _basketballDao;
    private volatile BaseballDao _baseballDao;
    private volatile HockeyDao _hockeyDao;
    private volatile MessagingDao _messagingDao;
    private volatile AdvertisingDao _advertisingDao;
    private volatile WatchPartyDao _watchPartyDao;
    private volatile AnalyticsDao _analyticsDao;

    static /* synthetic */ SupportSQLiteDatabase access$602(AppDatabase_Impl appDatabase_Impl, SupportSQLiteDatabase supportSQLiteDatabase) {
        appDatabase_Impl.mDatabase = supportSQLiteDatabase;
        return supportSQLiteDatabase;
    }

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration databaseConfiguration) {
        RoomOpenHelper.Delegate delegate;
        RoomOpenHelper roomOpenHelper;
        DatabaseConfiguration databaseConfiguration2 = databaseConfiguration;
        RoomOpenHelper roomOpenHelper2 = roomOpenHelper;
        RoomOpenHelper.Delegate delegate2 = delegate;
        delegate = new RoomOpenHelper.Delegate(2){

            public void createAllTables(SupportSQLiteDatabase supportSQLiteDatabase) {
                SupportSQLiteDatabase supportSQLiteDatabase2 = supportSQLiteDatabase;
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `PhoneContact` (`contactId` INTEGER NOT NULL, `name` TEXT NOT NULL, `photoUri` TEXT, `contactAccountType` TEXT, `locallyUpdatedAt` INTEGER NOT NULL, `phoneNumbers` TEXT NOT NULL, `emails` TEXT NOT NULL, `tinodeUserId` TEXT, PRIMARY KEY(`contactId`), FOREIGN KEY(`tinodeUserId`) REFERENCES `TinodeContact`(`chatUserId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `TinodeContact` (`chatUserId` TEXT NOT NULL, `externalId` TEXT, `chatName` TEXT, `online` INTEGER NOT NULL, `photoData` TEXT, `privateData` TEXT, PRIMARY KEY(`chatUserId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `Notification` (`dataJson` TEXT, `id` INTEGER PRIMARY KEY AUTOINCREMENT, `title` TEXT, `description` TEXT, `_type` TEXT, `date` INTEGER NOT NULL, `sourceUniqueId` TEXT NOT NULL, `meta` TEXT)");
                supportSQLiteDatabase2.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS `index_Notification_sourceUniqueId` ON `Notification` (`sourceUniqueId`)");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `EventSummaryResponseData` (`eventSummaryResponseDataId` INTEGER NOT NULL, `type` TEXT NOT NULL, PRIMARY KEY(`eventSummaryResponseDataId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `EventSummaryHomeEventTeamCrossRef` (`eventSummaryId` INTEGER NOT NULL, `eventTeamId` INTEGER NOT NULL, PRIMARY KEY(`eventSummaryId`, `eventTeamId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `EventSummaryAwayEventTeamCrossRef` (`eventSummaryId` INTEGER NOT NULL, `eventTeamId` INTEGER NOT NULL, PRIMARY KEY(`eventSummaryId`, `eventTeamId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `EventSummary` (`scheduleDateString` TEXT NOT NULL, `scheduleDate` INTEGER NOT NULL, `eventSummaryId` INTEGER NOT NULL, `scheduled` TEXT NOT NULL, `league` TEXT NOT NULL, `homeScore` INTEGER NOT NULL, `awayScore` INTEGER NOT NULL, `homeTeamId` INTEGER NOT NULL, `awayTeamId` INTEGER NOT NULL, `status` TEXT NOT NULL, `periods` TEXT NOT NULL, `periodsCount` INTEGER NOT NULL, `clock` TEXT NOT NULL, `period` INTEGER NOT NULL, PRIMARY KEY(`eventSummaryId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `EventTeam` (`eventTeamId` INTEGER NOT NULL, `name` TEXT NOT NULL, `alias` TEXT NOT NULL, `logo` TEXT NOT NULL, `colors` TEXT NOT NULL, `isWinner` INTEGER NOT NULL, PRIMARY KEY(`eventTeamId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `BasketballEventSummary` (`basketballEventSummaryId` INTEGER NOT NULL, `performers` TEXT NOT NULL, `homeTeamfieldGoalPercentage` REAL NOT NULL, `homeTeamthreePtsPercentage` REAL NOT NULL, `homeTeamfreeThrowPercentage` REAL NOT NULL, `homeTeamassists` INTEGER NOT NULL, `homeTeamrebounds` INTEGER NOT NULL, `awayTeamfieldGoalPercentage` REAL NOT NULL, `awayTeamthreePtsPercentage` REAL NOT NULL, `awayTeamfreeThrowPercentage` REAL NOT NULL, `awayTeamassists` INTEGER NOT NULL, `awayTeamrebounds` INTEGER NOT NULL, PRIMARY KEY(`basketballEventSummaryId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `BasketballBoxScore` (`basketballBoxScoreId` INTEGER NOT NULL, `homePlayerScores` TEXT NOT NULL, `awayPlayerScore` TEXT NOT NULL, PRIMARY KEY(`basketballBoxScoreId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `BasketballPlayByPlay` (`basketballPlayByPlayId` INTEGER NOT NULL, `statistics` TEXT NOT NULL, PRIMARY KEY(`basketballPlayByPlayId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `EventScheduleData` (`eventScheduleDataId` INTEGER NOT NULL, `type` TEXT NOT NULL, `attributesId` INTEGER NOT NULL, PRIMARY KEY(`eventScheduleDataId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `BasketballTeamStanding` (`id` INTEGER NOT NULL, `teamName` TEXT NOT NULL, `teamIcon` TEXT NOT NULL, `colors` TEXT NOT NULL, `wins` INTEGER NOT NULL, `losses` INTEGER NOT NULL, `percentage` REAL NOT NULL, `gamesBehind` INTEGER NOT NULL, `division` TEXT NOT NULL, `conference` TEXT NOT NULL, `league` TEXT, `streakkind` TEXT NOT NULL, `streaklength` INTEGER NOT NULL, `rankdivision` INTEGER NOT NULL, `rankconference` INTEGER NOT NULL, PRIMARY KEY(`id`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `EventScheduleAttributes` (`eventScheduleAttributesId` INTEGER NOT NULL, `basketballhomeTeamRecord` TEXT, `basketballawayTeamRecord` TEXT, `baseballouts` INTEGER, `baseballinning` INTEGER, `baseballinningDivision` TEXT, `baseballdelayed` INTEGER, `baseballreasonForDelay` TEXT, `baseballtakenBases` INTEGER, `baseballhomeTeamRecord` TEXT, `baseballawayTeamRecord` TEXT, `hockeyhomeTeamRecord` TEXT, `hockeyawayTeamRecord` TEXT, PRIMARY KEY(`eventScheduleAttributesId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `LeagueScheduleDate` (`scheduleLeague` TEXT NOT NULL, `scheduleDate` TEXT NOT NULL, PRIMARY KEY(`scheduleLeague`, `scheduleDate`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `BaseballPlayByPlay` (`baseballPlayByPlayId` INTEGER NOT NULL, `statistics` TEXT NOT NULL, PRIMARY KEY(`baseballPlayByPlayId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `BaseballSummary` (`baseballSummaryId` INTEGER NOT NULL, `awayPitcher` TEXT NOT NULL, `awayTeam` TEXT NOT NULL, `homePitcher` TEXT NOT NULL, `homeTeam` TEXT NOT NULL, PRIMARY KEY(`baseballSummaryId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `BaseballTeamStanding` (`id` INTEGER NOT NULL, `wins` INTEGER NOT NULL, `losses` INTEGER NOT NULL, `percentage` REAL NOT NULL, `gamesBehind` INTEGER NOT NULL, `teamName` TEXT NOT NULL, `teamIcon` TEXT NOT NULL, `colors` TEXT NOT NULL, `division` TEXT NOT NULL, `conference` TEXT NOT NULL, `league` TEXT, `streaklosses` INTEGER NOT NULL, `streakwins` INTEGER NOT NULL, `rankdivision` INTEGER NOT NULL, `rankconference` INTEGER NOT NULL, PRIMARY KEY(`id`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `HockeyTeamStanding` (`id` INTEGER NOT NULL, `teamName` TEXT NOT NULL, `teamIcon` TEXT NOT NULL, `colors` TEXT NOT NULL, `wins` INTEGER NOT NULL, `losses` INTEGER NOT NULL, `percentage` REAL NOT NULL, `gamesBehind` INTEGER NOT NULL, `division` TEXT NOT NULL, `conference` TEXT NOT NULL, `streakkind` TEXT NOT NULL, `streaklength` INTEGER NOT NULL, `rankdivision` INTEGER NOT NULL, `rankconference` INTEGER NOT NULL, PRIMARY KEY(`id`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `HockeyBoxScore` (`hockeyBoxScoreId` INTEGER NOT NULL, `homePlayerScores` TEXT NOT NULL, `awayPlayerScore` TEXT NOT NULL, PRIMARY KEY(`hockeyBoxScoreId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `ChatMessage` (`uuid` TEXT NOT NULL, `chatMessageTopicId` TEXT NOT NULL, `senderUserId` TEXT NOT NULL, `remoteSeqId` INTEGER NOT NULL, `date` INTEGER, `text` TEXT NOT NULL, `type` TEXT NOT NULL, `subtype` TEXT NOT NULL, `replyTo` TEXT NOT NULL, `status` TEXT NOT NULL, PRIMARY KEY(`chatMessageTopicId`, `uuid`))");
                supportSQLiteDatabase2.execSQL("CREATE INDEX IF NOT EXISTS `index_ChatMessage_chatMessageTopicId_uuid_date_text` ON `ChatMessage` (`chatMessageTopicId`, `uuid`, `date`, `text`)");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `Topic` (`watchPartyStreamId` TEXT, `chatId` TEXT NOT NULL, `name` TEXT NOT NULL, `seq` INTEGER NOT NULL, `readSeq` INTEGER NOT NULL, `recvSeq` INTEGER NOT NULL, `updatedAt` INTEGER, `touchedAt` INTEGER, `isWPTopic` INTEGER NOT NULL, `want` TEXT, `given` TEXT, PRIMARY KEY(`chatId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `ChatParticipantCrossRef` (`chatId` TEXT NOT NULL, `chatUserId` TEXT NOT NULL, PRIMARY KEY(`chatId`, `chatUserId`))");
                supportSQLiteDatabase2.execSQL("CREATE INDEX IF NOT EXISTS `index_ChatParticipantCrossRef_chatId_chatUserId` ON `ChatParticipantCrossRef` (`chatId`, `chatUserId`)");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `WatchPartyStatus` (`chatId` TEXT NOT NULL, `participantStatuses` TEXT NOT NULL, `isPrivate` INTEGER NOT NULL, `isParticipated` INTEGER NOT NULL, `type` TEXT NOT NULL, PRIMARY KEY(`chatId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `AnalyticsEvent` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `type` TEXT NOT NULL, `payload` TEXT)");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `WaveMessage` (`chatUserId` TEXT NOT NULL, `userName` TEXT NOT NULL, `userAvatar` TEXT, `sentAt` INTEGER NOT NULL, PRIMARY KEY(`chatUserId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `ChatOwnerCrossRef` (`chatId` TEXT NOT NULL, `chatUserId` TEXT NOT NULL, PRIMARY KEY(`chatId`))");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS `AdvertisingData` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `parent_id` TEXT NOT NULL, `type` TEXT NOT NULL, `template_id` TEXT NOT NULL, `overlay_name` TEXT NOT NULL, `overlay_type` TEXT NOT NULL, `advertising_type` TEXT NOT NULL, `frequency` INTEGER NOT NULL, `enable` INTEGER NOT NULL, `images` TEXT NOT NULL, `videos` TEXT NOT NULL)");
                supportSQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                supportSQLiteDatabase2.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'b7bd1fb9c23bf8d50da477e069a56fd6')");
            }

            public void dropAllTables(SupportSQLiteDatabase supportSQLiteDatabase) {
                SupportSQLiteDatabase supportSQLiteDatabase2 = supportSQLiteDatabase;
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `PhoneContact`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `TinodeContact`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `Notification`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `EventSummaryResponseData`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `EventSummaryHomeEventTeamCrossRef`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `EventSummaryAwayEventTeamCrossRef`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `EventSummary`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `EventTeam`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `BasketballEventSummary`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `BasketballBoxScore`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `BasketballPlayByPlay`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `EventScheduleData`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `BasketballTeamStanding`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `EventScheduleAttributes`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `LeagueScheduleDate`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `BaseballPlayByPlay`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `BaseballSummary`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `BaseballTeamStanding`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `HockeyTeamStanding`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `HockeyBoxScore`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `ChatMessage`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `Topic`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `ChatParticipantCrossRef`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `WatchPartyStatus`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `AnalyticsEvent`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `WaveMessage`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `ChatOwnerCrossRef`");
                supportSQLiteDatabase2.execSQL("DROP TABLE IF EXISTS `AdvertisingData`");
                if (AppDatabase_Impl.this.mCallbacks != null) {
                    int n = AppDatabase_Impl.this.mCallbacks.size();
                    for (int i = 0; i < n; ++i) {
                        ((RoomDatabase.Callback)AppDatabase_Impl.this.mCallbacks.get(i)).onDestructiveMigration(supportSQLiteDatabase);
                    }
                }
            }

            protected void onCreate(SupportSQLiteDatabase supportSQLiteDatabase) {
                if (AppDatabase_Impl.this.mCallbacks != null) {
                    int n = AppDatabase_Impl.this.mCallbacks.size();
                    for (int i = 0; i < n; ++i) {
                        ((RoomDatabase.Callback)AppDatabase_Impl.this.mCallbacks.get(i)).onCreate(supportSQLiteDatabase);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase supportSQLiteDatabase) {
                1 v0 = this;
                AppDatabase_Impl.access$602(AppDatabase_Impl.this, supportSQLiteDatabase);
                supportSQLiteDatabase.execSQL("PRAGMA foreign_keys = ON");
                v0.AppDatabase_Impl.this.internalInitInvalidationTracker(supportSQLiteDatabase);
                if (v0.AppDatabase_Impl.this.mCallbacks != null) {
                    int n = AppDatabase_Impl.this.mCallbacks.size();
                    for (int i = 0; i < n; ++i) {
                        ((RoomDatabase.Callback)AppDatabase_Impl.this.mCallbacks.get(i)).onOpen(supportSQLiteDatabase);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase supportSQLiteDatabase) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)supportSQLiteDatabase);
            }

            public void onPostMigrate(SupportSQLiteDatabase supportSQLiteDatabase) {
            }

            protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase supportSQLiteDatabase) {
                TableInfo tableInfo;
                HashSet hashSet;
                HashSet hashSet2;
                TableInfo.Column column;
                TableInfo.Column column2;
                TableInfo.Column column3;
                TableInfo.Column column4;
                TableInfo.Column column5;
                TableInfo.Column column6;
                TableInfo.Column column7;
                TableInfo.Column column8;
                TableInfo.Column column9;
                TableInfo.Column column10;
                TableInfo.Column column11;
                HashMap<String, TableInfo.Column> hashMap;
                TableInfo tableInfo2;
                HashSet hashSet3;
                HashSet hashSet4;
                TableInfo.Column column12;
                TableInfo.Column column13;
                HashMap<String, TableInfo.Column> hashMap2;
                TableInfo tableInfo3;
                HashSet hashSet5;
                HashSet hashSet6;
                TableInfo.Column column14;
                TableInfo.Column column15;
                TableInfo.Column column16;
                TableInfo.Column column17;
                HashMap<String, TableInfo.Column> hashMap3;
                TableInfo tableInfo4;
                HashSet hashSet7;
                HashSet hashSet8;
                TableInfo.Column column18;
                TableInfo.Column column19;
                TableInfo.Column column20;
                HashMap<String, TableInfo.Column> hashMap4;
                TableInfo tableInfo5;
                HashSet hashSet9;
                HashSet hashSet10;
                TableInfo.Column column21;
                TableInfo.Column column22;
                TableInfo.Column column23;
                TableInfo.Column column24;
                TableInfo.Column column25;
                HashMap<String, TableInfo.Column> hashMap5;
                TableInfo tableInfo6;
                HashSet<TableInfo.Index> hashSet11;
                HashSet hashSet12;
                TableInfo.Column column26;
                TableInfo.Column column27;
                HashMap<String, TableInfo.Column> hashMap6;
                TableInfo tableInfo7;
                HashSet hashSet13;
                HashSet hashSet14;
                TableInfo.Column column28;
                TableInfo.Column column29;
                TableInfo.Column column30;
                TableInfo.Column column31;
                TableInfo.Column column32;
                TableInfo.Column column33;
                TableInfo.Column column34;
                TableInfo.Column column35;
                TableInfo.Column column36;
                TableInfo.Column column37;
                TableInfo.Column column38;
                HashMap<String, TableInfo.Column> hashMap7;
                TableInfo tableInfo8;
                HashSet<TableInfo.Index> hashSet15;
                HashSet hashSet16;
                TableInfo.Column column39;
                TableInfo.Column column40;
                TableInfo.Column column41;
                TableInfo.Column column42;
                TableInfo.Column column43;
                TableInfo.Column column44;
                TableInfo.Column column45;
                TableInfo.Column column46;
                TableInfo.Column column47;
                TableInfo.Column column48;
                HashMap<String, TableInfo.Column> hashMap8;
                TableInfo tableInfo9;
                HashSet hashSet17;
                HashSet hashSet18;
                TableInfo.Column column49;
                TableInfo.Column column50;
                TableInfo.Column column51;
                HashMap<String, TableInfo.Column> hashMap9;
                TableInfo tableInfo10;
                HashSet hashSet19;
                HashSet hashSet20;
                TableInfo.Column column52;
                TableInfo.Column column53;
                TableInfo.Column column54;
                TableInfo.Column column55;
                TableInfo.Column column56;
                TableInfo.Column column57;
                TableInfo.Column column58;
                TableInfo.Column column59;
                TableInfo.Column column60;
                TableInfo.Column column61;
                TableInfo.Column column62;
                TableInfo.Column column63;
                TableInfo.Column column64;
                TableInfo.Column column65;
                HashMap<String, TableInfo.Column> hashMap10;
                TableInfo tableInfo11;
                HashSet hashSet21;
                HashSet hashSet22;
                TableInfo.Column column66;
                TableInfo.Column column67;
                TableInfo.Column column68;
                TableInfo.Column column69;
                TableInfo.Column column70;
                TableInfo.Column column71;
                TableInfo.Column column72;
                TableInfo.Column column73;
                TableInfo.Column column74;
                TableInfo.Column column75;
                TableInfo.Column column76;
                TableInfo.Column column77;
                TableInfo.Column column78;
                TableInfo.Column column79;
                TableInfo.Column column80;
                HashMap<String, TableInfo.Column> hashMap11;
                TableInfo tableInfo12;
                HashSet hashSet23;
                HashSet hashSet24;
                TableInfo.Column column81;
                TableInfo.Column column82;
                TableInfo.Column column83;
                TableInfo.Column column84;
                TableInfo.Column column85;
                HashMap<String, TableInfo.Column> hashMap12;
                TableInfo tableInfo13;
                HashSet hashSet25;
                HashSet hashSet26;
                TableInfo.Column column86;
                TableInfo.Column column87;
                HashMap<String, TableInfo.Column> hashMap13;
                TableInfo tableInfo14;
                HashSet hashSet27;
                HashSet hashSet28;
                TableInfo.Column column88;
                TableInfo.Column column89;
                HashMap<String, TableInfo.Column> hashMap14;
                TableInfo tableInfo15;
                HashSet hashSet29;
                HashSet hashSet30;
                TableInfo.Column column90;
                TableInfo.Column column91;
                TableInfo.Column column92;
                TableInfo.Column column93;
                TableInfo.Column column94;
                TableInfo.Column column95;
                TableInfo.Column column96;
                TableInfo.Column column97;
                TableInfo.Column column98;
                TableInfo.Column column99;
                TableInfo.Column column100;
                TableInfo.Column column101;
                TableInfo.Column column102;
                HashMap<String, TableInfo.Column> hashMap15;
                TableInfo tableInfo16;
                HashSet hashSet31;
                HashSet hashSet32;
                TableInfo.Column column103;
                TableInfo.Column column104;
                TableInfo.Column column105;
                TableInfo.Column column106;
                TableInfo.Column column107;
                TableInfo.Column column108;
                TableInfo.Column column109;
                TableInfo.Column column110;
                TableInfo.Column column111;
                TableInfo.Column column112;
                TableInfo.Column column113;
                TableInfo.Column column114;
                TableInfo.Column column115;
                TableInfo.Column column116;
                TableInfo.Column column117;
                HashMap<String, TableInfo.Column> hashMap16;
                TableInfo tableInfo17;
                HashSet hashSet33;
                HashSet hashSet34;
                TableInfo.Column column118;
                TableInfo.Column column119;
                TableInfo.Column column120;
                HashMap<String, TableInfo.Column> hashMap17;
                TableInfo tableInfo18;
                HashSet hashSet35;
                HashSet hashSet36;
                TableInfo.Column column121;
                TableInfo.Column column122;
                HashMap<String, TableInfo.Column> hashMap18;
                TableInfo tableInfo19;
                HashSet hashSet37;
                HashSet hashSet38;
                TableInfo.Column column123;
                TableInfo.Column column124;
                TableInfo.Column column125;
                HashMap<String, TableInfo.Column> hashMap19;
                TableInfo tableInfo20;
                HashSet hashSet39;
                HashSet hashSet40;
                TableInfo.Column column126;
                TableInfo.Column column127;
                TableInfo.Column column128;
                TableInfo.Column column129;
                TableInfo.Column column130;
                TableInfo.Column column131;
                TableInfo.Column column132;
                TableInfo.Column column133;
                TableInfo.Column column134;
                TableInfo.Column column135;
                TableInfo.Column column136;
                TableInfo.Column column137;
                HashMap<String, TableInfo.Column> hashMap20;
                TableInfo tableInfo21;
                HashSet hashSet41;
                HashSet hashSet42;
                TableInfo.Column column138;
                TableInfo.Column column139;
                TableInfo.Column column140;
                TableInfo.Column column141;
                TableInfo.Column column142;
                TableInfo.Column column143;
                HashMap<String, TableInfo.Column> hashMap21;
                TableInfo tableInfo22;
                HashSet hashSet43;
                HashSet hashSet44;
                TableInfo.Column column144;
                TableInfo.Column column145;
                TableInfo.Column column146;
                TableInfo.Column column147;
                TableInfo.Column column148;
                TableInfo.Column column149;
                TableInfo.Column column150;
                TableInfo.Column column151;
                TableInfo.Column column152;
                TableInfo.Column column153;
                TableInfo.Column column154;
                TableInfo.Column column155;
                TableInfo.Column column156;
                TableInfo.Column column157;
                HashMap<String, TableInfo.Column> hashMap22;
                TableInfo tableInfo23;
                HashSet hashSet45;
                HashSet hashSet46;
                TableInfo.Column column158;
                TableInfo.Column column159;
                HashMap<String, TableInfo.Column> hashMap23;
                TableInfo tableInfo24;
                HashSet hashSet47;
                HashSet hashSet48;
                TableInfo.Column column160;
                TableInfo.Column column161;
                HashMap<String, TableInfo.Column> hashMap24;
                TableInfo tableInfo25;
                HashSet hashSet49;
                HashSet hashSet50;
                TableInfo.Column column162;
                TableInfo.Column column163;
                HashMap<String, TableInfo.Column> hashMap25;
                TableInfo tableInfo26;
                HashSet<TableInfo.Index> hashSet51;
                HashSet hashSet52;
                TableInfo.Column column164;
                TableInfo.Column column165;
                TableInfo.Column column166;
                TableInfo.Column column167;
                TableInfo.Column column168;
                TableInfo.Column column169;
                TableInfo.Column column170;
                TableInfo.Column column171;
                HashMap<String, TableInfo.Column> hashMap26;
                TableInfo tableInfo27;
                HashSet hashSet53;
                HashSet hashSet54;
                TableInfo.Column column172;
                TableInfo.Column column173;
                TableInfo.Column column174;
                TableInfo.Column column175;
                TableInfo.Column column176;
                TableInfo.Column column177;
                HashMap<String, TableInfo.Column> hashMap27;
                TableInfo tableInfo28;
                HashSet hashSet55;
                HashSet<TableInfo.ForeignKey> hashSet56;
                TableInfo.Column column178;
                TableInfo.Column column179;
                TableInfo.Column column180;
                TableInfo.Column column181;
                TableInfo.Column column182;
                TableInfo.Column column183;
                TableInfo.Column column184;
                TableInfo.Column column185;
                HashMap<String, TableInfo.Column> hashMap28;
                Object object = hashMap28;
                Object object2 = column185;
                column185 = new TableInfo.Column("contactId", "INTEGER", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(8).put("contactId", (TableInfo.Column)object2);
                object2 = column184;
                column184 = new TableInfo.Column("name", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("name", object2);
                object2 = column183;
                column183 = new TableInfo.Column("photoUri", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("photoUri", object2);
                object2 = column182;
                column182 = new TableInfo.Column("contactAccountType", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("contactAccountType", object2);
                object2 = column181;
                column181 = new TableInfo.Column("locallyUpdatedAt", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("locallyUpdatedAt", object2);
                object2 = column180;
                column180 = new TableInfo.Column("phoneNumbers", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("phoneNumbers", object2);
                object2 = column179;
                column179 = new TableInfo.Column("emails", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("emails", object2);
                object2 = column178;
                column178 = new TableInfo.Column("tinodeUserId", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("tinodeUserId", object2);
                object2 = hashSet56;
                Collection<String> collection = Arrays.asList("tinodeUserId");
                Object object3 = Arrays.asList("chatUserId");
                new HashSet<TableInfo.ForeignKey>(1).add(new TableInfo.ForeignKey("TinodeContact", "CASCADE", "NO ACTION", collection, object3));
                collection = hashSet55;
                hashSet55 = new HashSet(0);
                object3 = tableInfo28;
                object3("PhoneContact", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"PhoneContact");
                if (!tableInfo28.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "PhoneContact(io.streamlayer.sdk.model.contact.PhoneContact).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap27;
                object2 = column177;
                column177 = new TableInfo.Column("chatUserId", "TEXT", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(6).put("chatUserId", (TableInfo.Column)object2);
                object2 = column176;
                column176 = new TableInfo.Column("externalId", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("externalId", object2);
                object2 = column175;
                column175 = new TableInfo.Column("chatName", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("chatName", object2);
                object2 = column174;
                column174 = new TableInfo.Column("online", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("online", object2);
                object2 = column173;
                column173 = new TableInfo.Column("photoData", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("photoData", object2);
                object2 = column172;
                column172 = new TableInfo.Column("privateData", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("privateData", object2);
                object2 = hashSet54;
                hashSet54 = new HashSet(0);
                collection = hashSet53;
                hashSet53 = new HashSet(0);
                object3 = tableInfo27;
                object3("TinodeContact", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"TinodeContact");
                if (!tableInfo27.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "TinodeContact(io.streamlayer.sdk.model.tinodecontact.TinodeContact).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap26;
                object2 = column171;
                column171 = new TableInfo.Column("dataJson", "TEXT", false, 0, null, 1);
                new HashMap<String, TableInfo.Column>(8).put("dataJson", (TableInfo.Column)object2);
                object2 = column170;
                column170 = new TableInfo.Column("id", "INTEGER", false, 1, null, 1);
                ((HashMap)object).put("id", object2);
                object2 = column169;
                column169 = new TableInfo.Column("title", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("title", object2);
                object2 = column168;
                column168 = new TableInfo.Column("description", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("description", object2);
                object2 = column167;
                column167 = new TableInfo.Column("_type", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("_type", object2);
                object2 = column166;
                column166 = new TableInfo.Column("date", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("date", object2);
                object2 = column165;
                column165 = new TableInfo.Column("sourceUniqueId", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("sourceUniqueId", object2);
                object2 = column164;
                column164 = new TableInfo.Column("meta", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("meta", object2);
                object2 = hashSet52;
                hashSet52 = new HashSet(0);
                collection = hashSet51;
                object3 = Arrays.asList("sourceUniqueId");
                new HashSet<TableInfo.Index>(1).add(new TableInfo.Index("index_Notification_sourceUniqueId", true, (List)object3));
                object3 = tableInfo26;
                object3("Notification", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"Notification");
                if (!tableInfo26.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "Notification(io.streamlayer.sdk.model.notifications.Notification).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap25;
                object2 = column163;
                column163 = new TableInfo.Column("eventSummaryResponseDataId", "INTEGER", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(2).put("eventSummaryResponseDataId", (TableInfo.Column)object2);
                object2 = column162;
                column162 = new TableInfo.Column("type", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("type", object2);
                object2 = hashSet50;
                hashSet50 = new HashSet(0);
                collection = hashSet49;
                hashSet49 = new HashSet(0);
                object3 = tableInfo25;
                object3("EventSummaryResponseData", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"EventSummaryResponseData");
                if (!tableInfo25.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "EventSummaryResponseData(io.streamlayer.sdk.model.sports.EventSummaryResponseData).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap24;
                object2 = column161;
                column161 = new TableInfo.Column("eventSummaryId", "INTEGER", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(2).put("eventSummaryId", (TableInfo.Column)object2);
                object2 = column160;
                column160 = new TableInfo.Column("eventTeamId", "INTEGER", true, 2, null, 1);
                ((HashMap)object).put("eventTeamId", object2);
                object2 = hashSet48;
                hashSet48 = new HashSet(0);
                collection = hashSet47;
                hashSet47 = new HashSet(0);
                object3 = tableInfo24;
                object3("EventSummaryHomeEventTeamCrossRef", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"EventSummaryHomeEventTeamCrossRef");
                if (!tableInfo24.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "EventSummaryHomeEventTeamCrossRef(io.streamlayer.sdk.model.sports.EventSummaryHomeEventTeamCrossRef).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap23;
                object2 = column159;
                column159 = new TableInfo.Column("eventSummaryId", "INTEGER", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(2).put("eventSummaryId", (TableInfo.Column)object2);
                object2 = column158;
                column158 = new TableInfo.Column("eventTeamId", "INTEGER", true, 2, null, 1);
                ((HashMap)object).put("eventTeamId", object2);
                object2 = hashSet46;
                hashSet46 = new HashSet(0);
                collection = hashSet45;
                hashSet45 = new HashSet(0);
                object3 = tableInfo23;
                object3("EventSummaryAwayEventTeamCrossRef", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"EventSummaryAwayEventTeamCrossRef");
                if (!tableInfo23.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "EventSummaryAwayEventTeamCrossRef(io.streamlayer.sdk.model.sports.EventSummaryAwayEventTeamCrossRef).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap22;
                object2 = column157;
                column157 = new TableInfo.Column("scheduleDateString", "TEXT", true, 0, null, 1);
                new HashMap<String, TableInfo.Column>(14).put("scheduleDateString", (TableInfo.Column)object2);
                object2 = column156;
                column156 = new TableInfo.Column("scheduleDate", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("scheduleDate", object2);
                object2 = column155;
                column155 = new TableInfo.Column("eventSummaryId", "INTEGER", true, 1, null, 1);
                ((HashMap)object).put("eventSummaryId", object2);
                object2 = column154;
                column154 = new TableInfo.Column("scheduled", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("scheduled", object2);
                object2 = column153;
                column153 = new TableInfo.Column("league", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("league", object2);
                object2 = column152;
                column152 = new TableInfo.Column("homeScore", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("homeScore", object2);
                object2 = column151;
                column151 = new TableInfo.Column("awayScore", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("awayScore", object2);
                object2 = column150;
                column150 = new TableInfo.Column("homeTeamId", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("homeTeamId", object2);
                object2 = column149;
                column149 = new TableInfo.Column("awayTeamId", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("awayTeamId", object2);
                object2 = column148;
                column148 = new TableInfo.Column("status", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("status", object2);
                object2 = column147;
                column147 = new TableInfo.Column("periods", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("periods", object2);
                object2 = column146;
                column146 = new TableInfo.Column("periodsCount", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("periodsCount", object2);
                object2 = column145;
                column145 = new TableInfo.Column("clock", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("clock", object2);
                object2 = column144;
                column144 = new TableInfo.Column("period", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("period", object2);
                object2 = hashSet44;
                hashSet44 = new HashSet(0);
                collection = hashSet43;
                hashSet43 = new HashSet(0);
                object3 = tableInfo22;
                object3("EventSummary", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"EventSummary");
                if (!tableInfo22.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "EventSummary(io.streamlayer.sdk.model.sports.EventSummary).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap21;
                object2 = column143;
                column143 = new TableInfo.Column("eventTeamId", "INTEGER", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(6).put("eventTeamId", (TableInfo.Column)object2);
                object2 = column142;
                column142 = new TableInfo.Column("name", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("name", object2);
                object2 = column141;
                column141 = new TableInfo.Column("alias", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("alias", object2);
                object2 = column140;
                column140 = new TableInfo.Column("logo", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("logo", object2);
                object2 = column139;
                column139 = new TableInfo.Column("colors", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("colors", object2);
                object2 = column138;
                column138 = new TableInfo.Column("isWinner", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("isWinner", object2);
                object2 = hashSet42;
                hashSet42 = new HashSet(0);
                collection = hashSet41;
                hashSet41 = new HashSet(0);
                object3 = tableInfo21;
                object3("EventTeam", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"EventTeam");
                if (!tableInfo21.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "EventTeam(io.streamlayer.sdk.model.sports.EventTeam).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap20;
                object2 = column137;
                column137 = new TableInfo.Column("basketballEventSummaryId", "INTEGER", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(12).put("basketballEventSummaryId", (TableInfo.Column)object2);
                object2 = column136;
                column136 = new TableInfo.Column("performers", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("performers", object2);
                object2 = column135;
                column135 = new TableInfo.Column("homeTeamfieldGoalPercentage", "REAL", true, 0, null, 1);
                ((HashMap)object).put("homeTeamfieldGoalPercentage", object2);
                object2 = column134;
                column134 = new TableInfo.Column("homeTeamthreePtsPercentage", "REAL", true, 0, null, 1);
                ((HashMap)object).put("homeTeamthreePtsPercentage", object2);
                object2 = column133;
                column133 = new TableInfo.Column("homeTeamfreeThrowPercentage", "REAL", true, 0, null, 1);
                ((HashMap)object).put("homeTeamfreeThrowPercentage", object2);
                object2 = column132;
                column132 = new TableInfo.Column("homeTeamassists", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("homeTeamassists", object2);
                object2 = column131;
                column131 = new TableInfo.Column("homeTeamrebounds", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("homeTeamrebounds", object2);
                object2 = column130;
                column130 = new TableInfo.Column("awayTeamfieldGoalPercentage", "REAL", true, 0, null, 1);
                ((HashMap)object).put("awayTeamfieldGoalPercentage", object2);
                object2 = column129;
                column129 = new TableInfo.Column("awayTeamthreePtsPercentage", "REAL", true, 0, null, 1);
                ((HashMap)object).put("awayTeamthreePtsPercentage", object2);
                object2 = column128;
                column128 = new TableInfo.Column("awayTeamfreeThrowPercentage", "REAL", true, 0, null, 1);
                ((HashMap)object).put("awayTeamfreeThrowPercentage", object2);
                object2 = column127;
                column127 = new TableInfo.Column("awayTeamassists", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("awayTeamassists", object2);
                object2 = column126;
                column126 = new TableInfo.Column("awayTeamrebounds", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("awayTeamrebounds", object2);
                object2 = hashSet40;
                hashSet40 = new HashSet(0);
                collection = hashSet39;
                hashSet39 = new HashSet(0);
                object3 = tableInfo20;
                object3("BasketballEventSummary", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"BasketballEventSummary");
                if (!tableInfo20.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "BasketballEventSummary(io.streamlayer.sdk.model.sports.basketball.BasketballEventSummary).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap19;
                object2 = column125;
                column125 = new TableInfo.Column("basketballBoxScoreId", "INTEGER", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(3).put("basketballBoxScoreId", (TableInfo.Column)object2);
                object2 = column124;
                column124 = new TableInfo.Column("homePlayerScores", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("homePlayerScores", object2);
                object2 = column123;
                column123 = new TableInfo.Column("awayPlayerScore", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("awayPlayerScore", object2);
                object2 = hashSet38;
                hashSet38 = new HashSet(0);
                collection = hashSet37;
                hashSet37 = new HashSet(0);
                object3 = tableInfo19;
                object3("BasketballBoxScore", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"BasketballBoxScore");
                if (!tableInfo19.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "BasketballBoxScore(io.streamlayer.sdk.model.sports.basketball.BasketballBoxScore).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap18;
                object2 = column122;
                column122 = new TableInfo.Column("basketballPlayByPlayId", "INTEGER", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(2).put("basketballPlayByPlayId", (TableInfo.Column)object2);
                object2 = column121;
                column121 = new TableInfo.Column("statistics", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("statistics", object2);
                object2 = hashSet36;
                hashSet36 = new HashSet(0);
                collection = hashSet35;
                hashSet35 = new HashSet(0);
                object3 = tableInfo18;
                object3("BasketballPlayByPlay", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"BasketballPlayByPlay");
                if (!tableInfo18.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "BasketballPlayByPlay(io.streamlayer.sdk.model.sports.basketball.BasketballPlayByPlay).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap17;
                object2 = column120;
                column120 = new TableInfo.Column("eventScheduleDataId", "INTEGER", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(3).put("eventScheduleDataId", (TableInfo.Column)object2);
                object2 = column119;
                column119 = new TableInfo.Column("type", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("type", object2);
                object2 = column118;
                column118 = new TableInfo.Column("attributesId", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("attributesId", object2);
                object2 = hashSet34;
                hashSet34 = new HashSet(0);
                collection = hashSet33;
                hashSet33 = new HashSet(0);
                object3 = tableInfo17;
                object3("EventScheduleData", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"EventScheduleData");
                if (!tableInfo17.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "EventScheduleData(io.streamlayer.sdk.model.sports.EventScheduleData).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap16;
                object2 = column117;
                column117 = new TableInfo.Column("id", "INTEGER", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(15).put("id", (TableInfo.Column)object2);
                object2 = column116;
                column116 = new TableInfo.Column("teamName", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("teamName", object2);
                object2 = column115;
                column115 = new TableInfo.Column("teamIcon", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("teamIcon", object2);
                object2 = column114;
                column114 = new TableInfo.Column("colors", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("colors", object2);
                object2 = column113;
                column113 = new TableInfo.Column("wins", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("wins", object2);
                object2 = column112;
                column112 = new TableInfo.Column("losses", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("losses", object2);
                object2 = column111;
                column111 = new TableInfo.Column("percentage", "REAL", true, 0, null, 1);
                ((HashMap)object).put("percentage", object2);
                object2 = column110;
                column110 = new TableInfo.Column("gamesBehind", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("gamesBehind", object2);
                object2 = column109;
                column109 = new TableInfo.Column("division", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("division", object2);
                object2 = column108;
                column108 = new TableInfo.Column("conference", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("conference", object2);
                object2 = column107;
                column107 = new TableInfo.Column("league", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("league", object2);
                object2 = column106;
                column106 = new TableInfo.Column("streakkind", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("streakkind", object2);
                object2 = column105;
                column105 = new TableInfo.Column("streaklength", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("streaklength", object2);
                object2 = column104;
                column104 = new TableInfo.Column("rankdivision", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("rankdivision", object2);
                object2 = column103;
                column103 = new TableInfo.Column("rankconference", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("rankconference", object2);
                object2 = hashSet32;
                hashSet32 = new HashSet(0);
                collection = hashSet31;
                hashSet31 = new HashSet(0);
                object3 = tableInfo16;
                object3("BasketballTeamStanding", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"BasketballTeamStanding");
                if (!tableInfo16.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "BasketballTeamStanding(io.streamlayer.sdk.model.sports.basketball.BasketballTeamStanding).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap15;
                object2 = column102;
                column102 = new TableInfo.Column("eventScheduleAttributesId", "INTEGER", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(13).put("eventScheduleAttributesId", (TableInfo.Column)object2);
                object2 = column101;
                column101 = new TableInfo.Column("basketballhomeTeamRecord", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("basketballhomeTeamRecord", object2);
                object2 = column100;
                column100 = new TableInfo.Column("basketballawayTeamRecord", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("basketballawayTeamRecord", object2);
                object2 = column99;
                column99 = new TableInfo.Column("baseballouts", "INTEGER", false, 0, null, 1);
                ((HashMap)object).put("baseballouts", object2);
                object2 = column98;
                column98 = new TableInfo.Column("baseballinning", "INTEGER", false, 0, null, 1);
                ((HashMap)object).put("baseballinning", object2);
                object2 = column97;
                column97 = new TableInfo.Column("baseballinningDivision", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("baseballinningDivision", object2);
                object2 = column96;
                column96 = new TableInfo.Column("baseballdelayed", "INTEGER", false, 0, null, 1);
                ((HashMap)object).put("baseballdelayed", object2);
                object2 = column95;
                column95 = new TableInfo.Column("baseballreasonForDelay", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("baseballreasonForDelay", object2);
                object2 = column94;
                column94 = new TableInfo.Column("baseballtakenBases", "INTEGER", false, 0, null, 1);
                ((HashMap)object).put("baseballtakenBases", object2);
                object2 = column93;
                column93 = new TableInfo.Column("baseballhomeTeamRecord", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("baseballhomeTeamRecord", object2);
                object2 = column92;
                column92 = new TableInfo.Column("baseballawayTeamRecord", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("baseballawayTeamRecord", object2);
                object2 = column91;
                column91 = new TableInfo.Column("hockeyhomeTeamRecord", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("hockeyhomeTeamRecord", object2);
                object2 = column90;
                column90 = new TableInfo.Column("hockeyawayTeamRecord", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("hockeyawayTeamRecord", object2);
                object2 = hashSet30;
                hashSet30 = new HashSet(0);
                collection = hashSet29;
                hashSet29 = new HashSet(0);
                object3 = tableInfo15;
                object3("EventScheduleAttributes", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"EventScheduleAttributes");
                if (!tableInfo15.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "EventScheduleAttributes(io.streamlayer.sdk.model.sports.EventScheduleAttributes).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap14;
                object2 = column89;
                column89 = new TableInfo.Column("scheduleLeague", "TEXT", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(2).put("scheduleLeague", (TableInfo.Column)object2);
                object2 = column88;
                column88 = new TableInfo.Column("scheduleDate", "TEXT", true, 2, null, 1);
                ((HashMap)object).put("scheduleDate", object2);
                object2 = hashSet28;
                hashSet28 = new HashSet(0);
                collection = hashSet27;
                hashSet27 = new HashSet(0);
                object3 = tableInfo14;
                object3("LeagueScheduleDate", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"LeagueScheduleDate");
                if (!tableInfo14.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "LeagueScheduleDate(io.streamlayer.sdk.model.sports.LeagueScheduleDate).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap13;
                object2 = column87;
                column87 = new TableInfo.Column("baseballPlayByPlayId", "INTEGER", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(2).put("baseballPlayByPlayId", (TableInfo.Column)object2);
                object2 = column86;
                column86 = new TableInfo.Column("statistics", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("statistics", object2);
                object2 = hashSet26;
                hashSet26 = new HashSet(0);
                collection = hashSet25;
                hashSet25 = new HashSet(0);
                object3 = tableInfo13;
                object3("BaseballPlayByPlay", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"BaseballPlayByPlay");
                if (!tableInfo13.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "BaseballPlayByPlay(io.streamlayer.sdk.model.sports.baseball.BaseballPlayByPlay).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap12;
                object2 = column85;
                column85 = new TableInfo.Column("baseballSummaryId", "INTEGER", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(5).put("baseballSummaryId", (TableInfo.Column)object2);
                object2 = column84;
                column84 = new TableInfo.Column("awayPitcher", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("awayPitcher", object2);
                object2 = column83;
                column83 = new TableInfo.Column("awayTeam", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("awayTeam", object2);
                object2 = column82;
                column82 = new TableInfo.Column("homePitcher", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("homePitcher", object2);
                object2 = column81;
                column81 = new TableInfo.Column("homeTeam", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("homeTeam", object2);
                object2 = hashSet24;
                hashSet24 = new HashSet(0);
                collection = hashSet23;
                hashSet23 = new HashSet(0);
                object3 = tableInfo12;
                object3("BaseballSummary", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"BaseballSummary");
                if (!tableInfo12.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "BaseballSummary(io.streamlayer.sdk.model.sports.baseball.BaseballSummary).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap11;
                object2 = column80;
                column80 = new TableInfo.Column("id", "INTEGER", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(15).put("id", (TableInfo.Column)object2);
                object2 = column79;
                column79 = new TableInfo.Column("wins", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("wins", object2);
                object2 = column78;
                column78 = new TableInfo.Column("losses", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("losses", object2);
                object2 = column77;
                column77 = new TableInfo.Column("percentage", "REAL", true, 0, null, 1);
                ((HashMap)object).put("percentage", object2);
                object2 = column76;
                column76 = new TableInfo.Column("gamesBehind", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("gamesBehind", object2);
                object2 = column75;
                column75 = new TableInfo.Column("teamName", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("teamName", object2);
                object2 = column74;
                column74 = new TableInfo.Column("teamIcon", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("teamIcon", object2);
                object2 = column73;
                column73 = new TableInfo.Column("colors", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("colors", object2);
                object2 = column72;
                column72 = new TableInfo.Column("division", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("division", object2);
                object2 = column71;
                column71 = new TableInfo.Column("conference", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("conference", object2);
                object2 = column70;
                column70 = new TableInfo.Column("league", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("league", object2);
                object2 = column69;
                column69 = new TableInfo.Column("streaklosses", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("streaklosses", object2);
                object2 = column68;
                column68 = new TableInfo.Column("streakwins", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("streakwins", object2);
                object2 = column67;
                column67 = new TableInfo.Column("rankdivision", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("rankdivision", object2);
                object2 = column66;
                column66 = new TableInfo.Column("rankconference", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("rankconference", object2);
                object2 = hashSet22;
                hashSet22 = new HashSet(0);
                collection = hashSet21;
                hashSet21 = new HashSet(0);
                object3 = tableInfo11;
                object3("BaseballTeamStanding", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"BaseballTeamStanding");
                if (!tableInfo11.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "BaseballTeamStanding(io.streamlayer.sdk.model.sports.baseball.BaseballTeamStanding).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap10;
                object2 = column65;
                column65 = new TableInfo.Column("id", "INTEGER", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(14).put("id", (TableInfo.Column)object2);
                object2 = column64;
                column64 = new TableInfo.Column("teamName", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("teamName", object2);
                object2 = column63;
                column63 = new TableInfo.Column("teamIcon", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("teamIcon", object2);
                object2 = column62;
                column62 = new TableInfo.Column("colors", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("colors", object2);
                object2 = column61;
                column61 = new TableInfo.Column("wins", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("wins", object2);
                object2 = column60;
                column60 = new TableInfo.Column("losses", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("losses", object2);
                object2 = column59;
                column59 = new TableInfo.Column("percentage", "REAL", true, 0, null, 1);
                ((HashMap)object).put("percentage", object2);
                object2 = column58;
                column58 = new TableInfo.Column("gamesBehind", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("gamesBehind", object2);
                object2 = column57;
                column57 = new TableInfo.Column("division", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("division", object2);
                object2 = column56;
                column56 = new TableInfo.Column("conference", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("conference", object2);
                object2 = column55;
                column55 = new TableInfo.Column("streakkind", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("streakkind", object2);
                object2 = column54;
                column54 = new TableInfo.Column("streaklength", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("streaklength", object2);
                object2 = column53;
                column53 = new TableInfo.Column("rankdivision", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("rankdivision", object2);
                object2 = column52;
                column52 = new TableInfo.Column("rankconference", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("rankconference", object2);
                object2 = hashSet20;
                hashSet20 = new HashSet(0);
                collection = hashSet19;
                hashSet19 = new HashSet(0);
                object3 = tableInfo10;
                object3("HockeyTeamStanding", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"HockeyTeamStanding");
                if (!tableInfo10.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "HockeyTeamStanding(io.streamlayer.sdk.model.sports.hockey.HockeyTeamStanding).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap9;
                object2 = column51;
                column51 = new TableInfo.Column("hockeyBoxScoreId", "INTEGER", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(3).put("hockeyBoxScoreId", (TableInfo.Column)object2);
                object2 = column50;
                column50 = new TableInfo.Column("homePlayerScores", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("homePlayerScores", object2);
                object2 = column49;
                column49 = new TableInfo.Column("awayPlayerScore", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("awayPlayerScore", object2);
                object2 = hashSet18;
                hashSet18 = new HashSet(0);
                collection = hashSet17;
                hashSet17 = new HashSet(0);
                object3 = tableInfo9;
                object3("HockeyBoxScore", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"HockeyBoxScore");
                if (!tableInfo9.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "HockeyBoxScore(io.streamlayer.sdk.model.sports.hockey.HockeyBoxScore).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap8;
                object2 = column48;
                column48 = new TableInfo.Column("uuid", "TEXT", true, 2, null, 1);
                new HashMap<String, TableInfo.Column>(10).put("uuid", (TableInfo.Column)object2);
                object2 = column47;
                column47 = new TableInfo.Column("chatMessageTopicId", "TEXT", true, 1, null, 1);
                ((HashMap)object).put("chatMessageTopicId", object2);
                object2 = column46;
                column46 = new TableInfo.Column("senderUserId", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("senderUserId", object2);
                object2 = column45;
                column45 = new TableInfo.Column("remoteSeqId", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("remoteSeqId", object2);
                object2 = column44;
                column44 = new TableInfo.Column("date", "INTEGER", false, 0, null, 1);
                ((HashMap)object).put("date", object2);
                object2 = column43;
                column43 = new TableInfo.Column("text", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("text", object2);
                object2 = column42;
                column42 = new TableInfo.Column("type", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("type", object2);
                object2 = column41;
                column41 = new TableInfo.Column("subtype", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("subtype", object2);
                object2 = column40;
                column40 = new TableInfo.Column("replyTo", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("replyTo", object2);
                object2 = column39;
                column39 = new TableInfo.Column("status", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("status", object2);
                object2 = hashSet16;
                hashSet16 = new HashSet(0);
                collection = hashSet15;
                object3 = Arrays.asList("chatMessageTopicId", "uuid", "date", "text");
                new HashSet<TableInfo.Index>(1).add(new TableInfo.Index("index_ChatMessage_chatMessageTopicId_uuid_date_text", false, (List)object3));
                object3 = tableInfo8;
                object3("ChatMessage", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"ChatMessage");
                if (!tableInfo8.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "ChatMessage(io.streamlayer.sdk.model.messaging.ChatMessage).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap7;
                object2 = column38;
                column38 = new TableInfo.Column("watchPartyStreamId", "TEXT", false, 0, null, 1);
                new HashMap<String, TableInfo.Column>(11).put("watchPartyStreamId", (TableInfo.Column)object2);
                object2 = column37;
                column37 = new TableInfo.Column("chatId", "TEXT", true, 1, null, 1);
                ((HashMap)object).put("chatId", object2);
                object2 = column36;
                column36 = new TableInfo.Column("name", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("name", object2);
                object2 = column35;
                column35 = new TableInfo.Column("seq", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("seq", object2);
                object2 = column34;
                column34 = new TableInfo.Column("readSeq", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("readSeq", object2);
                object2 = column33;
                column33 = new TableInfo.Column("recvSeq", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("recvSeq", object2);
                object2 = column32;
                column32 = new TableInfo.Column("updatedAt", "INTEGER", false, 0, null, 1);
                ((HashMap)object).put("updatedAt", object2);
                object2 = column31;
                column31 = new TableInfo.Column("touchedAt", "INTEGER", false, 0, null, 1);
                ((HashMap)object).put("touchedAt", object2);
                object2 = column30;
                column30 = new TableInfo.Column("isWPTopic", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("isWPTopic", object2);
                object2 = column29;
                column29 = new TableInfo.Column("want", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("want", object2);
                object2 = column28;
                column28 = new TableInfo.Column("given", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("given", object2);
                object2 = hashSet14;
                hashSet14 = new HashSet(0);
                collection = hashSet13;
                hashSet13 = new HashSet(0);
                object3 = tableInfo7;
                object3("Topic", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"Topic");
                if (!tableInfo7.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "Topic(io.streamlayer.sdk.model.messaging.Topic).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap6;
                object2 = column27;
                column27 = new TableInfo.Column("chatId", "TEXT", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(2).put("chatId", (TableInfo.Column)object2);
                object2 = column26;
                column26 = new TableInfo.Column("chatUserId", "TEXT", true, 2, null, 1);
                ((HashMap)object).put("chatUserId", object2);
                object2 = hashSet12;
                hashSet12 = new HashSet(0);
                collection = hashSet11;
                object3 = Arrays.asList("chatId", "chatUserId");
                new HashSet<TableInfo.Index>(1).add(new TableInfo.Index("index_ChatParticipantCrossRef_chatId_chatUserId", false, (List)object3));
                object3 = tableInfo6;
                object3("ChatParticipantCrossRef", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"ChatParticipantCrossRef");
                if (!tableInfo6.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "ChatParticipantCrossRef(io.streamlayer.sdk.model.messaging.ChatParticipantCrossRef).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap5;
                object2 = column25;
                column25 = new TableInfo.Column("chatId", "TEXT", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(5).put("chatId", (TableInfo.Column)object2);
                object2 = column24;
                column24 = new TableInfo.Column("participantStatuses", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("participantStatuses", object2);
                object2 = column23;
                column23 = new TableInfo.Column("isPrivate", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("isPrivate", object2);
                object2 = column22;
                column22 = new TableInfo.Column("isParticipated", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("isParticipated", object2);
                object2 = column21;
                column21 = new TableInfo.Column("type", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("type", object2);
                object2 = hashSet10;
                hashSet10 = new HashSet(0);
                collection = hashSet9;
                hashSet9 = new HashSet(0);
                object3 = tableInfo5;
                object3("WatchPartyStatus", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"WatchPartyStatus");
                if (!tableInfo5.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "WatchPartyStatus(io.streamlayer.sdk.model.calls.WatchPartyStatus).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap4;
                object2 = column20;
                column20 = new TableInfo.Column("id", "INTEGER", false, 1, null, 1);
                new HashMap<String, TableInfo.Column>(3).put("id", (TableInfo.Column)object2);
                object2 = column19;
                column19 = new TableInfo.Column("type", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("type", object2);
                object2 = column18;
                column18 = new TableInfo.Column("payload", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("payload", object2);
                object2 = hashSet8;
                hashSet8 = new HashSet(0);
                collection = hashSet7;
                hashSet7 = new HashSet(0);
                object3 = tableInfo4;
                object3("AnalyticsEvent", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"AnalyticsEvent");
                if (!tableInfo4.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "AnalyticsEvent(io.streamlayer.sdk.model.analytics.AnalyticsEvent).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap3;
                object2 = column17;
                column17 = new TableInfo.Column("chatUserId", "TEXT", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(4).put("chatUserId", (TableInfo.Column)object2);
                object2 = column16;
                column16 = new TableInfo.Column("userName", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("userName", object2);
                object2 = column15;
                column15 = new TableInfo.Column("userAvatar", "TEXT", false, 0, null, 1);
                ((HashMap)object).put("userAvatar", object2);
                object2 = column14;
                column14 = new TableInfo.Column("sentAt", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("sentAt", object2);
                object2 = hashSet6;
                hashSet6 = new HashSet(0);
                collection = hashSet5;
                hashSet5 = new HashSet(0);
                object3 = tableInfo3;
                object3("WaveMessage", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"WaveMessage");
                if (!tableInfo3.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "WaveMessage(io.streamlayer.sdk.model.messaging.WaveMessage).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap2;
                object2 = column13;
                column13 = new TableInfo.Column("chatId", "TEXT", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(2).put("chatId", (TableInfo.Column)object2);
                object2 = column12;
                column12 = new TableInfo.Column("chatUserId", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("chatUserId", object2);
                object2 = hashSet4;
                hashSet4 = new HashSet(0);
                collection = hashSet3;
                hashSet3 = new HashSet(0);
                object3 = tableInfo2;
                object3("ChatOwnerCrossRef", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"ChatOwnerCrossRef");
                if (!tableInfo2.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "ChatOwnerCrossRef(io.streamlayer.sdk.model.messaging.ChatOwnerCrossRef).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                object = hashMap;
                object2 = column11;
                column11 = new TableInfo.Column("id", "INTEGER", true, 1, null, 1);
                new HashMap<String, TableInfo.Column>(11).put("id", (TableInfo.Column)object2);
                object2 = column10;
                column10 = new TableInfo.Column("parent_id", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("parent_id", object2);
                object2 = column9;
                column9 = new TableInfo.Column("type", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("type", object2);
                object2 = column8;
                column8 = new TableInfo.Column("template_id", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("template_id", object2);
                object2 = column7;
                column7 = new TableInfo.Column("overlay_name", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("overlay_name", object2);
                object2 = column6;
                column6 = new TableInfo.Column("overlay_type", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("overlay_type", object2);
                object2 = column5;
                column5 = new TableInfo.Column("advertising_type", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("advertising_type", object2);
                object2 = column4;
                column4 = new TableInfo.Column("frequency", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("frequency", object2);
                object2 = column3;
                column3 = new TableInfo.Column("enable", "INTEGER", true, 0, null, 1);
                ((HashMap)object).put("enable", object2);
                object2 = column2;
                column2 = new TableInfo.Column("images", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("images", object2);
                object2 = column;
                column = new TableInfo.Column("videos", "TEXT", true, 0, null, 1);
                ((HashMap)object).put("videos", object2);
                object2 = hashSet2;
                hashSet2 = new HashSet(0);
                collection = hashSet;
                hashSet = new HashSet(0);
                object3 = tableInfo;
                object3("AdvertisingData", (Map)object, (Set)object2, collection);
                object = TableInfo.read((SupportSQLiteDatabase)supportSQLiteDatabase, (String)"AdvertisingData");
                if (!tableInfo.equals(object)) {
                    return new RoomOpenHelper.ValidationResult(false, "AdvertisingData(io.streamlayer.sdk.model.advertising.AdvertisingData).\n Expected:\n" + object3 + "\n Found:\n" + (Object)object);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        };
        roomOpenHelper = new RoomOpenHelper(databaseConfiguration, delegate2, "b7bd1fb9c23bf8d50da477e069a56fd6", "cee1c467a3b4391e37d929fe9178b3e0");
        AppDatabase_Impl appDatabase_Impl = SupportSQLiteOpenHelper.Configuration.builder((Context)databaseConfiguration2.context).name(databaseConfiguration.name).callback((SupportSQLiteOpenHelper.Callback)roomOpenHelper2).build();
        return databaseConfiguration2.sqliteOpenHelperFactory.create((SupportSQLiteOpenHelper.Configuration)appDatabase_Impl);
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap hashMap;
        HashMap hashMap2;
        HashMap hashMap3 = hashMap2;
        hashMap2 = new HashMap(0);
        HashMap hashMap4 = hashMap;
        hashMap = new HashMap(0);
        String[] stringArray = new String[28];
        String[] stringArray2 = stringArray;
        stringArray[0] = "PhoneContact";
        stringArray[1] = "TinodeContact";
        stringArray[2] = "Notification";
        stringArray[3] = "EventSummaryResponseData";
        stringArray[4] = "EventSummaryHomeEventTeamCrossRef";
        stringArray[5] = "EventSummaryAwayEventTeamCrossRef";
        stringArray[6] = "EventSummary";
        stringArray[7] = "EventTeam";
        stringArray[8] = "BasketballEventSummary";
        stringArray[9] = "BasketballBoxScore";
        stringArray[10] = "BasketballPlayByPlay";
        stringArray[11] = "EventScheduleData";
        stringArray[12] = "BasketballTeamStanding";
        stringArray[13] = "EventScheduleAttributes";
        stringArray[14] = "LeagueScheduleDate";
        stringArray[15] = "BaseballPlayByPlay";
        stringArray[16] = "BaseballSummary";
        stringArray[17] = "BaseballTeamStanding";
        stringArray[18] = "HockeyTeamStanding";
        stringArray[19] = "HockeyBoxScore";
        stringArray[20] = "ChatMessage";
        stringArray[21] = "Topic";
        stringArray[22] = "ChatParticipantCrossRef";
        stringArray[23] = "WatchPartyStatus";
        stringArray[24] = "AnalyticsEvent";
        stringArray[25] = "WaveMessage";
        stringArray[26] = "ChatOwnerCrossRef";
        stringArray[27] = "AdvertisingData";
        return new InvalidationTracker((RoomDatabase)this, hashMap3, hashMap4, stringArray2);
    }

    /*
     * Unable to fully structure code
     */
    public void clearAllTables() {
        block6: {
            v0 = this;
            super.assertNotMainThread();
            var1_1 = super.getOpenHelper().getWritableDatabase();
            var2_2 = Build.VERSION.SDK_INT >= 21;
            if (var2_2) ** GOTO lbl8
            try {
                var1_1.execSQL("PRAGMA foreign_keys = FALSE");
lbl8:
                // 2 sources

                super.beginTransaction();
                if (!var2_2) ** GOTO lbl21
            }
            catch (Throwable var3_3) {
                super.endTransaction();
                if (!var2_2) {
                    var1_1.execSQL("PRAGMA foreign_keys = TRUE");
                }
                v1 = var1_1;
                v1.query("PRAGMA wal_checkpoint(FULL)").close();
                if (!v1.inTransaction()) {
                    var1_1.execSQL("VACUUM");
                }
                throw var3_3;
            }
            var1_1.execSQL("PRAGMA defer_foreign_keys = TRUE");
lbl21:
            // 2 sources

            v2 = this;
            v3 = var1_1;
            v3.execSQL("DELETE FROM `PhoneContact`");
            v3.execSQL("DELETE FROM `TinodeContact`");
            v3.execSQL("DELETE FROM `Notification`");
            v3.execSQL("DELETE FROM `EventSummaryResponseData`");
            v3.execSQL("DELETE FROM `EventSummaryHomeEventTeamCrossRef`");
            v3.execSQL("DELETE FROM `EventSummaryAwayEventTeamCrossRef`");
            v3.execSQL("DELETE FROM `EventSummary`");
            v3.execSQL("DELETE FROM `EventTeam`");
            v3.execSQL("DELETE FROM `BasketballEventSummary`");
            v3.execSQL("DELETE FROM `BasketballBoxScore`");
            v3.execSQL("DELETE FROM `BasketballPlayByPlay`");
            v3.execSQL("DELETE FROM `EventScheduleData`");
            v3.execSQL("DELETE FROM `BasketballTeamStanding`");
            v3.execSQL("DELETE FROM `EventScheduleAttributes`");
            v3.execSQL("DELETE FROM `LeagueScheduleDate`");
            v3.execSQL("DELETE FROM `BaseballPlayByPlay`");
            v3.execSQL("DELETE FROM `BaseballSummary`");
            v3.execSQL("DELETE FROM `BaseballTeamStanding`");
            v3.execSQL("DELETE FROM `HockeyTeamStanding`");
            v3.execSQL("DELETE FROM `HockeyBoxScore`");
            v3.execSQL("DELETE FROM `ChatMessage`");
            v3.execSQL("DELETE FROM `Topic`");
            v3.execSQL("DELETE FROM `ChatParticipantCrossRef`");
            v3.execSQL("DELETE FROM `WatchPartyStatus`");
            v3.execSQL("DELETE FROM `AnalyticsEvent`");
            v3.execSQL("DELETE FROM `WaveMessage`");
            v3.execSQL("DELETE FROM `ChatOwnerCrossRef`");
            v3.execSQL("DELETE FROM `AdvertisingData`");
            super.setTransactionSuccessful();
            super.endTransaction();
            if (var2_2) break block6;
            var1_1.execSQL("PRAGMA foreign_keys = TRUE");
        }
        v4 = var1_1;
        v4.query("PRAGMA wal_checkpoint(FULL)").close();
        if (!v4.inTransaction()) {
            var1_1.execSQL("VACUUM");
        }
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap hashMap = new HashMap();
        hashMap.put(PhoneContactDao.class, PhoneContactDao_Impl.getRequiredConverters());
        hashMap.put(TinodeContactDao.class, TinodeContactDao_Impl.getRequiredConverters());
        hashMap.put(NotificationDao.class, NotificationDao_Impl.getRequiredConverters());
        hashMap.put(SportEventsDao.class, SportEventsDao_Impl.getRequiredConverters());
        hashMap.put(BasketballDao.class, BasketballDao_Impl.getRequiredConverters());
        hashMap.put(BaseballDao.class, BaseballDao_Impl.getRequiredConverters());
        hashMap.put(HockeyDao.class, HockeyDao_Impl.getRequiredConverters());
        hashMap.put(MessagingDao.class, MessagingDao_Impl.getRequiredConverters());
        hashMap.put(AdvertisingDao.class, AdvertisingDao_Impl.getRequiredConverters());
        hashMap.put(WatchPartyDao.class, WatchPartyDao_Impl.getRequiredConverters());
        hashMap.put(AnalyticsDao.class, AnalyticsDao_Impl.getRequiredConverters());
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PhoneContactDao phoneContactDao() {
        if (this._phoneContactDao != null) {
            return this._phoneContactDao;
        }
        AppDatabase_Impl appDatabase_Impl = this;
        synchronized (appDatabase_Impl) {
            if (appDatabase_Impl._phoneContactDao == null) {
                this._phoneContactDao = new PhoneContactDao_Impl(this);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this._phoneContactDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TinodeContactDao tinodeContactDao() {
        if (this._tinodeContactDao != null) {
            return this._tinodeContactDao;
        }
        AppDatabase_Impl appDatabase_Impl = this;
        synchronized (appDatabase_Impl) {
            if (appDatabase_Impl._tinodeContactDao == null) {
                this._tinodeContactDao = new TinodeContactDao_Impl(this);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this._tinodeContactDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NotificationDao notificationDao() {
        if (this._notificationDao != null) {
            return this._notificationDao;
        }
        AppDatabase_Impl appDatabase_Impl = this;
        synchronized (appDatabase_Impl) {
            if (appDatabase_Impl._notificationDao == null) {
                this._notificationDao = new NotificationDao_Impl(this);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this._notificationDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SportEventsDao sportEventsDao() {
        if (this._sportEventsDao != null) {
            return this._sportEventsDao;
        }
        AppDatabase_Impl appDatabase_Impl = this;
        synchronized (appDatabase_Impl) {
            if (appDatabase_Impl._sportEventsDao == null) {
                this._sportEventsDao = new SportEventsDao_Impl(this);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this._sportEventsDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BasketballDao basketballDao() {
        if (this._basketballDao != null) {
            return this._basketballDao;
        }
        AppDatabase_Impl appDatabase_Impl = this;
        synchronized (appDatabase_Impl) {
            if (appDatabase_Impl._basketballDao == null) {
                this._basketballDao = new BasketballDao_Impl(this);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this._basketballDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BaseballDao baseballDao() {
        if (this._baseballDao != null) {
            return this._baseballDao;
        }
        AppDatabase_Impl appDatabase_Impl = this;
        synchronized (appDatabase_Impl) {
            if (appDatabase_Impl._baseballDao == null) {
                this._baseballDao = new BaseballDao_Impl(this);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this._baseballDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HockeyDao hockeyDao() {
        if (this._hockeyDao != null) {
            return this._hockeyDao;
        }
        AppDatabase_Impl appDatabase_Impl = this;
        synchronized (appDatabase_Impl) {
            if (appDatabase_Impl._hockeyDao == null) {
                this._hockeyDao = new HockeyDao_Impl(this);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this._hockeyDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MessagingDao messagingDao() {
        if (this._messagingDao != null) {
            return this._messagingDao;
        }
        AppDatabase_Impl appDatabase_Impl = this;
        synchronized (appDatabase_Impl) {
            if (appDatabase_Impl._messagingDao == null) {
                this._messagingDao = new MessagingDao_Impl(this);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this._messagingDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AdvertisingDao advertisingDao() {
        if (this._advertisingDao != null) {
            return this._advertisingDao;
        }
        AppDatabase_Impl appDatabase_Impl = this;
        synchronized (appDatabase_Impl) {
            if (appDatabase_Impl._advertisingDao == null) {
                this._advertisingDao = new AdvertisingDao_Impl(this);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this._advertisingDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WatchPartyDao watchPartyDao() {
        if (this._watchPartyDao != null) {
            return this._watchPartyDao;
        }
        AppDatabase_Impl appDatabase_Impl = this;
        synchronized (appDatabase_Impl) {
            if (appDatabase_Impl._watchPartyDao == null) {
                this._watchPartyDao = new WatchPartyDao_Impl(this);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this._watchPartyDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AnalyticsDao analyticsDao() {
        if (this._analyticsDao != null) {
            return this._analyticsDao;
        }
        AppDatabase_Impl appDatabase_Impl = this;
        synchronized (appDatabase_Impl) {
            if (appDatabase_Impl._analyticsDao == null) {
                this._analyticsDao = new AnalyticsDao_Impl(this);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this._analyticsDao;
        }
    }
}

