/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.messaging;

import com.google.protobuf.ByteString;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageHead;
import io.streamlayer.sdk.model.messaging.ChatMessageHeadPayload;
import io.streamlayer.sdk.model.messaging.ChatMessageKt$WhenMappings;
import io.streamlayer.sdk.model.messaging.ChatMessageRelation;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatMessageUpdate;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pbx.Model;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0013\u0010\u0005\u001a\u00020\u0004*\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0013\u0010\b\u001a\u00020\u0007*\u00020\u0001H\u0000\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0013\u0010\b\u001a\u00020\u0007*\u00020\nH\u0000\u00a2\u0006\u0004\b\b\u0010\u000b\u001a\u001d\u0010\u0002\u001a\u00020\u0001*\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\rH\u0000\u00a2\u0006\u0004\b\u0002\u0010\u000f\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0010H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0011\u001a\u0013\u0010\u0002\u001a\u00020\r*\u00020\u0012H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0013\"\u0016\u0010\u0015\u001a\u00020\u00148\u0000@\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\"\u0016\u0010\u0017\u001a\u00020\u00148\u0000@\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016\"\u0016\u0010\u0018\u001a\u00020\u00148\u0000@\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0016\"\u0016\u0010\u0019\u001a\u00020\u00148\u0000@\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0016\"\u0016\u0010\u001a\u001a\u00020\u00148\u0000@\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0016\"\u0016\u0010\u001b\u001a\u00020\u00148\u0000@\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lio/streamlayer/sdk/model/messaging/ChatMessageRelation;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "toDomain", "(Lio/streamlayer/sdk/model/messaging/ChatMessageRelation;)Lio/streamlayer/sdk/model/messaging/ChatMessage;", "Lio/streamlayer/sdk/model/messaging/ChatMessageUpdate;", "toUpdateEntity", "(Lio/streamlayer/sdk/model/messaging/ChatMessage;)Lio/streamlayer/sdk/model/messaging/ChatMessageUpdate;", "", "isWave", "(Lio/streamlayer/sdk/model/messaging/ChatMessage;)Z", "Lio/streamlayer/sdk/model/messaging/ChatMessageHeadPayload;", "(Lio/streamlayer/sdk/model/messaging/ChatMessageHeadPayload;)Z", "Lpbx/Model$ServerData;", "Lio/streamlayer/sdk/model/messaging/ChatMessageStatus;", "status", "(Lpbx/Model$ServerData;Lio/streamlayer/sdk/model/messaging/ChatMessageStatus;)Lio/streamlayer/sdk/model/messaging/ChatMessage;", "Lpbx/Model$ServerInfo;", "(Lpbx/Model$ServerInfo;)Lio/streamlayer/sdk/model/messaging/ChatMessage;", "Lpbx/Model$InfoNote;", "(Lpbx/Model$InfoNote;)Lio/streamlayer/sdk/model/messaging/ChatMessageStatus;", "", "X_MESSAGE_ID", "Ljava/lang/String;", "X_TYPE", "X_SUBTYPE", "X_REPLY", "WATCH_TYPE", "INVITE_TYPE", "sdk_originalRelease"})
public final class ChatMessageKt {
    @NotNull
    public static final String X_TYPE = "x-slr-type";
    @NotNull
    public static final String X_SUBTYPE = "x-slr-subtype";
    @NotNull
    public static final String X_REPLY = "x-slr-reply";
    @NotNull
    public static final String X_MESSAGE_ID = "x-message-id";
    @NotNull
    public static final String INVITE_TYPE = "invite";
    @NotNull
    public static final String WATCH_TYPE = "watch";

    @NotNull
    public static final ChatMessage toDomain(@NotNull ChatMessageRelation chatMessageRelation) {
        ChatMessageRelation chatMessageRelation2 = chatMessageRelation;
        Intrinsics.checkNotNullParameter((Object)chatMessageRelation2, (String)"$this$toDomain");
        ChatMessage chatMessage = chatMessageRelation2.getMessage();
        chatMessage.setSender(chatMessageRelation.getSenderRelation());
        return chatMessage;
    }

    @NotNull
    public static final ChatMessageUpdate toUpdateEntity(@NotNull ChatMessage object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"$this$toUpdateEntity");
        ChatMessage chatMessage = object;
        object = chatMessage.getTopicId();
        String string2 = chatMessage.getId();
        ChatMessageStatus chatMessageStatus = chatMessage.getStatus();
        return new ChatMessageUpdate((String)object, string2, chatMessageStatus);
    }

    public static final boolean isWave(@NotNull ChatMessage chatMessage) {
        ChatMessage chatMessage2 = chatMessage;
        Intrinsics.checkNotNullParameter((Object)chatMessage2, (String)"$this$isWave");
        return Intrinsics.areEqual((Object)chatMessage2.getType(), (Object)INVITE_TYPE) && Intrinsics.areEqual((Object)chatMessage.getSubtype(), (Object)WATCH_TYPE);
    }

    public static final boolean isWave(@NotNull ChatMessageHeadPayload chatMessageHeadPayload) {
        ChatMessageHeadPayload chatMessageHeadPayload2 = chatMessageHeadPayload;
        Intrinsics.checkNotNullParameter((Object)chatMessageHeadPayload2, (String)"$this$isWave");
        ChatMessageHead chatMessageHead = chatMessageHeadPayload2.getHead();
        return Intrinsics.areEqual((Object)(chatMessageHead != null ? chatMessageHead.getType() : null), (Object)INVITE_TYPE) && Intrinsics.areEqual((Object)chatMessageHeadPayload.getHead().getSubtype(), (Object)WATCH_TYPE);
    }

    @NotNull
    public static final ChatMessage toDomain(@NotNull Model.ServerData object, @NotNull ChatMessageStatus object2) {
        Date date;
        Object object3 = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"$this$toDomain");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"status");
        String string2 = object3.getTopic();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"topic");
        String string3 = object3.getFromUserId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fromUserId");
        int n = object3.getSeqId();
        Object object32 = object3.getContent();
        object32 = object32 != null ? ExtensionsKt.parseUtf8(object32) : null;
        if (object32 == null) {
            object32 = "";
        }
        Date date2 = date;
        date = new Date(object.getTimestamp());
        Object object4 = (ByteString)object.getHeadMap().get(X_TYPE);
        object4 = object4 != null ? ExtensionsKt.parseUtf8(object4) : null;
        if (object4 == null) {
            object4 = "";
        }
        Object object5 = (ByteString)object.getHeadMap().get(X_SUBTYPE);
        object5 = object5 != null ? ExtensionsKt.parseUtf8(object5) : null;
        if (object5 == null) {
            object5 = "";
        }
        Object object6 = (ByteString)object.getHeadMap().get(X_REPLY);
        object6 = object6 != null ? ExtensionsKt.parseUtf8(object6) : null;
        if (object6 == null) {
            object6 = "";
        }
        ChatMessage chatMessage = new ChatMessage(string2, string3, n, date2, (String)object32, (String)object4, (String)object5, (String)object6, (ChatMessageStatus)((Object)object2));
        object = object.getHeadMap();
        if (object != null) {
            LinkedHashMap linkedHashMap;
            object2 = linkedHashMap;
            linkedHashMap = new LinkedHashMap(MapsKt.mapCapacity((int)object.size()));
            for (Map.Entry entry : object.entrySet()) {
                string2 = entry.getKey();
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
                string3 = ExtensionsKt.parseUtf8((ByteString)v);
                if (string3 == null) {
                    string3 = "";
                }
                object2.put(string2, string3);
            }
        } else {
            object2 = null;
        }
        ChatMessage chatMessage2 = chatMessage;
        chatMessage2.setHead((Map<String, String>)object2);
        object = chatMessage2.getHead();
        if (object != null && (object = (String)object.get(X_MESSAGE_ID)) != null) {
            chatMessage.setId((String)object);
        }
        return chatMessage;
    }

    public static /* synthetic */ ChatMessage toDomain$default(Model.ServerData serverData, ChatMessageStatus chatMessageStatus, int n, Object object) {
        if ((n & 1) != 0) {
            chatMessageStatus = ChatMessageStatus.Uninitialized;
        }
        return ChatMessageKt.toDomain(serverData, chatMessageStatus);
    }

    @NotNull
    public static final ChatMessage toDomain(@NotNull Model.ServerInfo object) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)object, (String)"$this$toDomain");
        Model.ServerInfo serverInfo = object;
        object = serverInfo.getTopic();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"topic");
        int n = serverInfo.getSeqId();
        String string2 = serverInfo.getFromUserId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fromUserId");
        Date date2 = date;
        date = new Date(0L);
        Model.InfoNote infoNote = serverInfo.getWhat();
        Intrinsics.checkNotNullExpressionValue((Object)infoNote, (String)"what");
        ChatMessageStatus chatMessageStatus = ChatMessageKt.toDomain(infoNote);
        return new ChatMessage((String)object, string2, n, date2, null, null, null, null, chatMessageStatus, 240, null);
    }

    @NotNull
    public static final ChatMessageStatus toDomain(@NotNull Model.InfoNote infoNote) {
        Intrinsics.checkNotNullParameter((Object)infoNote, (String)"$this$toDomain");
        int n = ChatMessageKt$WhenMappings.$EnumSwitchMapping$0[infoNote.ordinal()];
        return n != 1 ? (n != 2 ? ChatMessageStatus.Uninitialized : ChatMessageStatus.Delivered) : ChatMessageStatus.Read;
    }
}

