/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.messaging;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.collection.ArrayMap;
import androidx.paging.DataSource;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.calls.WatchParty;
import io.streamlayer.sdk.model.calls.WatchPartyParticipantStatus;
import io.streamlayer.sdk.model.calls.WatchPartyRelation;
import io.streamlayer.sdk.model.calls.WatchPartyStatus;
import io.streamlayer.sdk.model.calls.WatchPartyType;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageRelation;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatMessageUpdate;
import io.streamlayer.sdk.model.messaging.ChatOwnerCrossRef;
import io.streamlayer.sdk.model.messaging.ChatParticipantCrossRef;
import io.streamlayer.sdk.model.messaging.ChatRelation;
import io.streamlayer.sdk.model.messaging.Topic;
import io.streamlayer.sdk.model.messaging.WaveMessage;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.messaging.MessagingDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;

public final class MessagingDao_Impl
implements MessagingDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChatMessage> __insertionAdapterOfChatMessage;
    private final Converters __converters;
    private final EntityInsertionAdapter<ChatMessage> __insertionAdapterOfChatMessage_1;
    private final EntityInsertionAdapter<ChatOwnerCrossRef> __insertionAdapterOfChatOwnerCrossRef;
    private final EntityInsertionAdapter<Topic> __insertionAdapterOfTopic;
    private final EntityInsertionAdapter<ChatParticipantCrossRef> __insertionAdapterOfChatParticipantCrossRef;
    private final EntityInsertionAdapter<WaveMessage> __insertionAdapterOfWaveMessage;
    private final EntityDeletionOrUpdateAdapter<ChatMessage> __deletionAdapterOfChatMessage;
    private final EntityDeletionOrUpdateAdapter<WaveMessage> __deletionAdapterOfWaveMessage;
    private final EntityDeletionOrUpdateAdapter<ChatMessageUpdate> __updateAdapterOfChatMessageUpdateAsChatMessage;
    private final SharedSQLiteStatement __preparedStmtOfUpdateChatMessagedByLocalSeq;
    private final SharedSQLiteStatement __preparedStmtOfUpdateChatMessageSeq;
    private final SharedSQLiteStatement __preparedStmtOfUpdateChatMessageRecvSeq;
    private final SharedSQLiteStatement __preparedStmtOfDeleteMessages;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChats;
    private final SharedSQLiteStatement __preparedStmtOfDeleteWaveEvents;

    public MessagingDao_Impl(RoomDatabase roomDatabase) {
        SharedSQLiteStatement sharedSQLiteStatement;
        SharedSQLiteStatement sharedSQLiteStatement2;
        SharedSQLiteStatement sharedSQLiteStatement3;
        SharedSQLiteStatement sharedSQLiteStatement4;
        SharedSQLiteStatement sharedSQLiteStatement5;
        SharedSQLiteStatement sharedSQLiteStatement6;
        EntityDeletionOrUpdateAdapter<ChatMessageUpdate> entityDeletionOrUpdateAdapter;
        EntityDeletionOrUpdateAdapter<WaveMessage> entityDeletionOrUpdateAdapter2;
        EntityDeletionOrUpdateAdapter<ChatMessage> entityDeletionOrUpdateAdapter3;
        EntityInsertionAdapter<WaveMessage> entityInsertionAdapter;
        EntityInsertionAdapter<ChatParticipantCrossRef> entityInsertionAdapter2;
        EntityInsertionAdapter<Topic> entityInsertionAdapter3;
        EntityInsertionAdapter<ChatOwnerCrossRef> entityInsertionAdapter4;
        EntityInsertionAdapter<ChatMessage> entityInsertionAdapter5;
        EntityInsertionAdapter<ChatMessage> entityInsertionAdapter6;
        Converters converters;
        Converters converters2 = converters;
        converters = new Converters();
        this.__converters = converters2;
        this.__db = roomDatabase;
        converters2 = entityInsertionAdapter6;
        entityInsertionAdapter6 = new EntityInsertionAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `ChatMessage` (`uuid`,`chatMessageTopicId`,`senderUserId`,`remoteSeqId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`) VALUES (?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getId());
                }
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatMessage.getTopicId());
                }
                if (chatMessage.getSenderUserId() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, chatMessage.getSenderUserId());
                }
                long l = chatMessage.getSeqId();
                supportSQLiteStatement.bindLong(4, l);
                Long l2 = object.MessagingDao_Impl.this.__converters.dateToString(chatMessage.getDate());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(5, l3);
                }
                if (chatMessage.getText() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, chatMessage.getText());
                }
                if (chatMessage.getType() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, chatMessage.getType());
                }
                if (chatMessage.getSubtype() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, chatMessage.getSubtype());
                }
                if (chatMessage.getReplyTo() == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, chatMessage.getReplyTo());
                }
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessage.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, (String)object);
                }
            }
        };
        this.__insertionAdapterOfChatMessage = converters2;
        converters2 = entityInsertionAdapter5;
        entityInsertionAdapter5 = new EntityInsertionAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatMessage` (`uuid`,`chatMessageTopicId`,`senderUserId`,`remoteSeqId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`) VALUES (?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getId());
                }
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatMessage.getTopicId());
                }
                if (chatMessage.getSenderUserId() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, chatMessage.getSenderUserId());
                }
                long l = chatMessage.getSeqId();
                supportSQLiteStatement.bindLong(4, l);
                Long l2 = object.MessagingDao_Impl.this.__converters.dateToString(chatMessage.getDate());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(5, l3);
                }
                if (chatMessage.getText() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, chatMessage.getText());
                }
                if (chatMessage.getType() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, chatMessage.getType());
                }
                if (chatMessage.getSubtype() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, chatMessage.getSubtype());
                }
                if (chatMessage.getReplyTo() == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, chatMessage.getReplyTo());
                }
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessage.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, (String)object);
                }
            }
        };
        this.__insertionAdapterOfChatMessage_1 = converters2;
        converters2 = entityInsertionAdapter4;
        entityInsertionAdapter4 = new EntityInsertionAdapter<ChatOwnerCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatOwnerCrossRef` (`chatId`,`chatUserId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatOwnerCrossRef chatOwnerCrossRef) {
                if (chatOwnerCrossRef.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatOwnerCrossRef.getChatId());
                }
                if (chatOwnerCrossRef.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatOwnerCrossRef.getChatUserId());
                }
            }
        };
        this.__insertionAdapterOfChatOwnerCrossRef = converters2;
        converters2 = entityInsertionAdapter3;
        entityInsertionAdapter3 = new EntityInsertionAdapter<Topic>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Topic` (`watchPartyStreamId`,`chatId`,`name`,`seq`,`readSeq`,`recvSeq`,`updatedAt`,`touchedAt`,`isWPTopic`,`want`,`given`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Topic topic) {
                if (topic.getWatchPartyStreamId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, topic.getWatchPartyStreamId());
                }
                if (topic.getChatId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, topic.getChatId());
                }
                if (topic.getName() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, topic.getName());
                }
                long l = topic.getSeq();
                supportSQLiteStatement.bindLong(4, l);
                l = topic.getReadSeq();
                supportSQLiteStatement.bindLong(5, l);
                l = topic.getRecvSeq();
                supportSQLiteStatement.bindLong(6, l);
                Long l2 = object.MessagingDao_Impl.this.__converters.dateToString(topic.getUpdatedAt());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(7, l3);
                }
                Object object = object.MessagingDao_Impl.this.__converters.dateToString(topic.getTouchedAt());
                if (object == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    long l4 = (Long)object;
                    supportSQLiteStatement.bindLong(8, l4);
                }
                long l5 = (long)topic.isWPTopic();
                supportSQLiteStatement.bindLong(9, l5);
                object = topic.getAccess();
                if (object != null) {
                    if (((Access)object).getWant() == null) {
                        supportSQLiteStatement.bindNull(10);
                    } else {
                        supportSQLiteStatement.bindString(10, ((Access)object).getWant());
                    }
                    if (((Access)object).getGiven() == null) {
                        supportSQLiteStatement.bindNull(11);
                    } else {
                        supportSQLiteStatement.bindString(11, ((Access)object).getGiven());
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(10);
                    supportSQLiteStatement2.bindNull(11);
                }
            }
        };
        this.__insertionAdapterOfTopic = converters2;
        converters2 = entityInsertionAdapter2;
        entityInsertionAdapter2 = new EntityInsertionAdapter<ChatParticipantCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatParticipantCrossRef` (`chatId`,`chatUserId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatParticipantCrossRef chatParticipantCrossRef) {
                if (chatParticipantCrossRef.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatParticipantCrossRef.getChatId());
                }
                if (chatParticipantCrossRef.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatParticipantCrossRef.getChatUserId());
                }
            }
        };
        this.__insertionAdapterOfChatParticipantCrossRef = converters2;
        converters2 = entityInsertionAdapter;
        entityInsertionAdapter = new EntityInsertionAdapter<WaveMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `WaveMessage` (`chatUserId`,`userName`,`userAvatar`,`sentAt`) VALUES (?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WaveMessage waveMessage) {
                if (waveMessage.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, waveMessage.getChatUserId());
                }
                if (waveMessage.getUserName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, waveMessage.getUserName());
                }
                if (waveMessage.getUserAvatar() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, waveMessage.getUserAvatar());
                }
                Long l = l.MessagingDao_Impl.this.__converters.dateToString(waveMessage.getSentAt());
                if (l == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    long l2 = l;
                    supportSQLiteStatement.bindLong(4, l2);
                }
            }
        };
        this.__insertionAdapterOfWaveMessage = converters2;
        converters2 = entityDeletionOrUpdateAdapter3;
        entityDeletionOrUpdateAdapter3 = new EntityDeletionOrUpdateAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `ChatMessage` WHERE `chatMessageTopicId` = ? AND `uuid` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                if (chatMessage.getId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatMessage.getId());
                }
            }
        };
        this.__deletionAdapterOfChatMessage = converters2;
        converters2 = entityDeletionOrUpdateAdapter2;
        entityDeletionOrUpdateAdapter2 = new EntityDeletionOrUpdateAdapter<WaveMessage>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `WaveMessage` WHERE `chatUserId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WaveMessage waveMessage) {
                if (waveMessage.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, waveMessage.getChatUserId());
                }
            }
        };
        this.__deletionAdapterOfWaveMessage = converters2;
        converters2 = entityDeletionOrUpdateAdapter;
        entityDeletionOrUpdateAdapter = new EntityDeletionOrUpdateAdapter<ChatMessageUpdate>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `ChatMessage` SET `chatMessageTopicId` = ?,`uuid` = ?,`status` = ? WHERE `chatMessageTopicId` = ? AND `uuid` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessageUpdate chatMessageUpdate) {
                if (chatMessageUpdate.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessageUpdate.getTopicId());
                }
                if (chatMessageUpdate.getId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatMessageUpdate.getId());
                }
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessageUpdate.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, (String)object);
                }
                if (chatMessageUpdate.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, chatMessageUpdate.getTopicId());
                }
                if (chatMessageUpdate.getId() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, chatMessageUpdate.getId());
                }
            }
        };
        this.__updateAdapterOfChatMessageUpdateAsChatMessage = converters2;
        converters2 = sharedSQLiteStatement6;
        sharedSQLiteStatement6 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE ChatMessage SET remoteSeqId=?, status=? WHERE ChatMessage.chatMessageTopicId=? AND ChatMessage.uuid=?";
            }
        };
        this.__preparedStmtOfUpdateChatMessagedByLocalSeq = converters2;
        converters2 = sharedSQLiteStatement5;
        sharedSQLiteStatement5 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE Topic SET readSeq=?,seq=?,recvSeq=? WHERE chatId = ?";
            }
        };
        this.__preparedStmtOfUpdateChatMessageSeq = converters2;
        converters2 = sharedSQLiteStatement4;
        sharedSQLiteStatement4 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE Topic SET seq=?,recvSeq=? WHERE chatId = ?";
            }
        };
        this.__preparedStmtOfUpdateChatMessageRecvSeq = converters2;
        converters2 = sharedSQLiteStatement3;
        sharedSQLiteStatement3 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatMessage WHERE chatMessageTopicId = ? AND status = ?";
            }
        };
        this.__preparedStmtOfDeleteMessages = converters2;
        converters2 = sharedSQLiteStatement2;
        sharedSQLiteStatement2 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Topic";
            }
        };
        this.__preparedStmtOfDeleteChats = converters2;
        converters2 = sharedSQLiteStatement;
        sharedSQLiteStatement = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM WaveMessage WHERE sentAt <= ?";
            }
        };
        this.__preparedStmtOfDeleteWaveEvents = converters2;
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact(ArrayMap<String, TinodeContact> arrayMap) {
        int n;
        int n2;
        int n3;
        block31: {
            Set set = arrayMap.keySet();
            if (set.isEmpty()) {
                return;
            }
            if (arrayMap.size() > 999) {
                ArrayMap arrayMap2;
                set = arrayMap2;
                arrayMap2 = new ArrayMap(999);
                int n4 = 0;
                int n5 = arrayMap.size();
                for (int i = 0; i < n5; ++i) {
                    ArrayMap arrayMap3;
                    set.put(arrayMap.keyAt(i), null);
                    if (++n4 != 999) continue;
                    messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)set);
                    arrayMap.putAll((Map)((Object)set));
                    set = arrayMap3;
                    arrayMap3 = new ArrayMap(999);
                    n4 = 0;
                }
                if (n4 > 0) {
                    messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)set);
                    arrayMap.putAll((Map)((Object)set));
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `chatUserId`,`externalId`,`chatName`,`online`,`photoData`,`privateData` FROM `TinodeContact` WHERE `chatUserId` IN (");
            int n6 = set.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n6);
            stringBuilder.append(")");
            RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n6 + 0));
            n3 = 1;
            for (String string2 : set) {
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n3);
                } else {
                    roomSQLiteQuery.bindString(n3, string2);
                }
                ++n3;
            }
            MessagingDao_Impl messagingDao_Impl = DBUtil.query((RoomDatabase)messagingDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n2 = CursorUtil.getColumnIndex((Cursor)messagingDao_Impl, (String)"chatUserId");
            if (n2 != -1) break block31;
            messagingDao_Impl.close();
            return;
        }
        MessagingDao_Impl messagingDao_Impl = messagingDao_Impl;
        MessagingDao_Impl messagingDao_Impl2 = messagingDao_Impl;
        MessagingDao_Impl messagingDao_Impl3 = messagingDao_Impl;
        MessagingDao_Impl messagingDao_Impl4 = messagingDao_Impl;
        MessagingDao_Impl messagingDao_Impl5 = messagingDao_Impl;
        MessagingDao_Impl messagingDao_Impl6 = messagingDao_Impl;
        n3 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"chatUserId");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl4, (String)"externalId");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl5, (String)"chatName");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl6, (String)"online");
        int n10 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl2, (String)"photoData");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl3, (String)"privateData");
        }
        catch (Throwable throwable) {
            messagingDao_Impl.close();
            throw throwable;
        }
        while (true) {
            String string3;
            String string4;
            boolean bl;
            String string5;
            String string6;
            String string7;
            String string8;
            block41: {
                block40: {
                    block39: {
                        block38: {
                            block37: {
                                block36: {
                                    block35: {
                                        block34: {
                                            block33: {
                                                block32: {
                                                    if (!messagingDao_Impl.moveToNext()) break;
                                                    ArrayMap<String, TinodeContact> arrayMap4 = arrayMap;
                                                    string8 = messagingDao_Impl.getString(n2);
                                                    if (!arrayMap4.containsKey((Object)string8)) continue;
                                                    if (!messagingDao_Impl.isNull(n3)) break block32;
                                                    string7 = null;
                                                    break block33;
                                                }
                                                string7 = messagingDao_Impl.getString(n3);
                                            }
                                            if (!messagingDao_Impl.isNull(n7)) break block34;
                                            string6 = null;
                                            break block35;
                                        }
                                        string6 = messagingDao_Impl.getString(n7);
                                    }
                                    if (!messagingDao_Impl.isNull(n8)) break block36;
                                    string5 = null;
                                    break block37;
                                }
                                string5 = messagingDao_Impl.getString(n8);
                            }
                            bl = messagingDao_Impl.getInt(n9) != 0;
                            if (!messagingDao_Impl.isNull(n10)) break block38;
                            string4 = null;
                            break block39;
                        }
                        string4 = messagingDao_Impl.getString(n10);
                    }
                    if (!messagingDao_Impl.isNull(n)) break block40;
                    string3 = null;
                    break block41;
                }
                string3 = messagingDao_Impl.getString(n);
            }
            arrayMap.put((Object)string8, (Object)new TinodeContact(string7, string6, string5, bl, string4, string3));
        }
        messagingDao_Impl.close();
        return;
    }

    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1(ArrayMap<String, ArrayList<TinodeContact>> arrayMap) {
        int n;
        Set set = arrayMap.keySet();
        if (set.isEmpty()) {
            return;
        }
        if (arrayMap.size() > 999) {
            ArrayMap arrayMap2;
            set = arrayMap2;
            arrayMap2 = new ArrayMap(999);
            int n2 = 0;
            int n3 = arrayMap.size();
            for (int i = 0; i < n3; ++i) {
                ArrayMap arrayMap3;
                ArrayMap<String, ArrayList<TinodeContact>> arrayMap4 = arrayMap;
                Object object = arrayMap4.keyAt(i);
                set.put(object, arrayMap4.valueAt(i));
                if (++n2 != 999) continue;
                messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)set);
                set = arrayMap3;
                arrayMap3 = new ArrayMap(999);
                n2 = 0;
            }
            if (n2 > 0) {
                messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)set);
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`externalId` AS `externalId`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`photoData` AS `photoData`,`TinodeContact`.`privateData` AS `privateData`,_junction.`chatId` FROM `ChatParticipantCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        int n4 = set.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n4);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n4 + 0));
        int n5 = 1;
        for (String string2 : set) {
            if (string2 == null) {
                roomSQLiteQuery.bindNull(n5);
            } else {
                roomSQLiteQuery.bindString(n5, string2);
            }
            ++n5;
        }
        MessagingDao_Impl messagingDao_Impl = DBUtil.query((RoomDatabase)messagingDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"chatUserId");
        n5 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"externalId");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"chatName");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"online");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"photoData");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"privateData");
        }
        catch (Throwable throwable) {
            messagingDao_Impl.close();
            throw throwable;
        }
        while (true) {
            String string3;
            String string4;
            boolean bl;
            String string5;
            String string6;
            String string7;
            ArrayList arrayList;
            block38: {
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    block32: {
                                        block31: {
                                            block30: {
                                                block29: {
                                                    if (!messagingDao_Impl.moveToNext()) break;
                                                    arrayList = (ArrayList)arrayMap.get((Object)messagingDao_Impl.getString(6));
                                                    if (arrayList == null) continue;
                                                    if (!messagingDao_Impl.isNull(n6)) break block29;
                                                    string7 = null;
                                                    break block30;
                                                }
                                                string7 = messagingDao_Impl.getString(n6);
                                            }
                                            if (!messagingDao_Impl.isNull(n5)) break block31;
                                            string6 = null;
                                            break block32;
                                        }
                                        string6 = messagingDao_Impl.getString(n5);
                                    }
                                    if (!messagingDao_Impl.isNull(n7)) break block33;
                                    string5 = null;
                                    break block34;
                                }
                                string5 = messagingDao_Impl.getString(n7);
                            }
                            bl = messagingDao_Impl.getInt(n8) != 0;
                            if (!messagingDao_Impl.isNull(n9)) break block35;
                            string4 = null;
                            break block36;
                        }
                        string4 = messagingDao_Impl.getString(n9);
                    }
                    if (!messagingDao_Impl.isNull(n)) break block37;
                    string3 = null;
                    break block38;
                }
                string3 = messagingDao_Impl.getString(n);
            }
            arrayList.add(new TinodeContact(string7, string6, string5, bl, string4, string3));
        }
        messagingDao_Impl.close();
        return;
    }

    private void __fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage(ArrayMap<String, ArrayList<ChatMessage>> arrayMap) {
        int n;
        int n2;
        RoomSQLiteQuery roomSQLiteQuery;
        block45: {
            Set set = arrayMap.keySet();
            if (set.isEmpty()) {
                return;
            }
            if (arrayMap.size() > 999) {
                ArrayMap arrayMap2;
                set = arrayMap2;
                arrayMap2 = new ArrayMap(999);
                int n3 = 0;
                int n4 = arrayMap.size();
                for (int i = 0; i < n4; ++i) {
                    ArrayMap arrayMap3;
                    ArrayMap<String, ArrayList<ChatMessage>> arrayMap4 = arrayMap;
                    Object object = arrayMap4.keyAt(i);
                    set.put(object, arrayMap4.valueAt(i));
                    if (++n3 != 999) continue;
                    this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set);
                    set = arrayMap3;
                    arrayMap3 = new ArrayMap(999);
                    n3 = 0;
                }
                if (n3 > 0) {
                    this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set);
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `uuid`,`chatMessageTopicId`,`senderUserId`,`remoteSeqId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status` FROM `ChatMessage` WHERE `chatMessageTopicId` IN (");
            int n5 = set.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n5);
            stringBuilder.append(")");
            roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n5 + 0));
            n2 = 1;
            for (String string2 : set) {
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, string2);
                }
                ++n2;
            }
            roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n2 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatMessageTopicId");
            if (n2 != -1) break block45;
            roomSQLiteQuery.close();
            return;
        }
        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
        RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery4 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery5 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery6 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery7 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery8 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery9 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery10 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery11 = roomSQLiteQuery2;
        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery2, (String)"uuid");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery9, (String)"chatMessageTopicId");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery10, (String)"senderUserId");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery11, (String)"remoteSeqId");
        int n10 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery7, (String)"date");
        int n11 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery8, (String)"text");
        int n12 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery5, (String)"type");
        int n13 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery6, (String)"subtype");
        int n14 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery3, (String)"replyTo");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery4, (String)"status");
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        while (true) {
            ChatMessage chatMessage;
            String string3;
            ArrayList arrayList;
            block63: {
                block62: {
                    ChatMessage chatMessage2;
                    Object object;
                    String string4;
                    String string5;
                    String string6;
                    String string7;
                    Comparable<Long> comparable;
                    int n15;
                    String string8;
                    block61: {
                        block60: {
                            block59: {
                                block58: {
                                    block57: {
                                        block56: {
                                            block55: {
                                                block54: {
                                                    block53: {
                                                        block52: {
                                                            block51: {
                                                                block50: {
                                                                    block49: {
                                                                        block48: {
                                                                            block47: {
                                                                                block46: {
                                                                                    if (!roomSQLiteQuery.moveToNext()) break;
                                                                                    arrayList = (ArrayList)arrayMap.get((Object)roomSQLiteQuery.getString(n2));
                                                                                    if (arrayList == null) continue;
                                                                                    if (!roomSQLiteQuery.isNull(n7)) break block46;
                                                                                    string3 = null;
                                                                                    break block47;
                                                                                }
                                                                                string3 = roomSQLiteQuery.getString(n7);
                                                                            }
                                                                            if (!roomSQLiteQuery.isNull(n8)) break block48;
                                                                            string8 = null;
                                                                            break block49;
                                                                        }
                                                                        string8 = roomSQLiteQuery.getString(n8);
                                                                    }
                                                                    RoomSQLiteQuery roomSQLiteQuery12 = roomSQLiteQuery;
                                                                    int n16 = n10;
                                                                    n15 = roomSQLiteQuery.getInt(n9);
                                                                    if (!roomSQLiteQuery12.isNull(n16)) break block50;
                                                                    comparable = null;
                                                                    break block51;
                                                                }
                                                                comparable = roomSQLiteQuery.getLong(n10);
                                                            }
                                                            RoomSQLiteQuery roomSQLiteQuery13 = roomSQLiteQuery;
                                                            int n17 = n11;
                                                            comparable = this.__converters.timestampToDate((Long)comparable);
                                                            if (!roomSQLiteQuery13.isNull(n17)) break block52;
                                                            string7 = null;
                                                            break block53;
                                                        }
                                                        string7 = roomSQLiteQuery.getString(n11);
                                                    }
                                                    if (!roomSQLiteQuery.isNull(n12)) break block54;
                                                    string6 = null;
                                                    break block55;
                                                }
                                                string6 = roomSQLiteQuery.getString(n12);
                                            }
                                            if (!roomSQLiteQuery.isNull(n13)) break block56;
                                            string5 = null;
                                            break block57;
                                        }
                                        string5 = roomSQLiteQuery.getString(n13);
                                    }
                                    if (!roomSQLiteQuery.isNull(n14)) break block58;
                                    string4 = null;
                                    break block59;
                                }
                                string4 = roomSQLiteQuery.getString(n14);
                            }
                            if (!roomSQLiteQuery.isNull(n)) break block60;
                            object = null;
                            break block61;
                        }
                        object = roomSQLiteQuery.getString(n);
                    }
                    RoomSQLiteQuery roomSQLiteQuery14 = roomSQLiteQuery;
                    int n18 = n6;
                    object = this.__converters.stringToChatStatus((String)object);
                    chatMessage = chatMessage2;
                    chatMessage2 = new ChatMessage(string3, string8, n15, (Date)comparable, string7, string6, string5, string4, (ChatMessageStatus)((Object)object));
                    if (!roomSQLiteQuery14.isNull(n18)) break block62;
                    string3 = null;
                    break block63;
                }
                string3 = roomSQLiteQuery.getString(n6);
            }
            ChatMessage chatMessage3 = chatMessage;
            chatMessage3.setId(string3);
            arrayList.add(chatMessage3);
        }
        roomSQLiteQuery.close();
        return;
    }

    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_2(ArrayMap<String, TinodeContact> arrayMap) {
        int n;
        Set set = arrayMap.keySet();
        if (set.isEmpty()) {
            return;
        }
        if (arrayMap.size() > 999) {
            ArrayMap arrayMap2;
            set = arrayMap2;
            arrayMap2 = new ArrayMap(999);
            int n2 = 0;
            int n3 = arrayMap.size();
            for (int i = 0; i < n3; ++i) {
                ArrayMap arrayMap3;
                set.put(arrayMap.keyAt(i), null);
                if (++n2 != 999) continue;
                messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_2((ArrayMap<String, TinodeContact>)set);
                arrayMap.putAll((Map)((Object)set));
                set = arrayMap3;
                arrayMap3 = new ArrayMap(999);
                n2 = 0;
            }
            if (n2 > 0) {
                messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_2((ArrayMap<String, TinodeContact>)set);
                arrayMap.putAll((Map)((Object)set));
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`externalId` AS `externalId`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`photoData` AS `photoData`,`TinodeContact`.`privateData` AS `privateData`,_junction.`chatId` FROM `ChatOwnerCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        int n4 = set.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n4);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n4 + 0));
        int n5 = 1;
        for (String string2 : set) {
            if (string2 == null) {
                roomSQLiteQuery.bindNull(n5);
            } else {
                roomSQLiteQuery.bindString(n5, string2);
            }
            ++n5;
        }
        MessagingDao_Impl messagingDao_Impl = DBUtil.query((RoomDatabase)messagingDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"chatUserId");
        n5 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"externalId");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"chatName");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"online");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"photoData");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"privateData");
        }
        catch (Throwable throwable) {
            messagingDao_Impl.close();
            throw throwable;
        }
        while (true) {
            String string3;
            String string4;
            boolean bl;
            String string5;
            String string6;
            String string7;
            String string8;
            block39: {
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    block33: {
                                        block32: {
                                            block31: {
                                                block30: {
                                                    if (!messagingDao_Impl.moveToNext()) break;
                                                    ArrayMap<String, TinodeContact> arrayMap4 = arrayMap;
                                                    string8 = messagingDao_Impl.getString(6);
                                                    if (!arrayMap4.containsKey((Object)string8)) continue;
                                                    if (!messagingDao_Impl.isNull(n6)) break block30;
                                                    string7 = null;
                                                    break block31;
                                                }
                                                string7 = messagingDao_Impl.getString(n6);
                                            }
                                            if (!messagingDao_Impl.isNull(n5)) break block32;
                                            string6 = null;
                                            break block33;
                                        }
                                        string6 = messagingDao_Impl.getString(n5);
                                    }
                                    if (!messagingDao_Impl.isNull(n7)) break block34;
                                    string5 = null;
                                    break block35;
                                }
                                string5 = messagingDao_Impl.getString(n7);
                            }
                            bl = messagingDao_Impl.getInt(n8) != 0;
                            if (!messagingDao_Impl.isNull(n9)) break block36;
                            string4 = null;
                            break block37;
                        }
                        string4 = messagingDao_Impl.getString(n9);
                    }
                    if (!messagingDao_Impl.isNull(n)) break block38;
                    string3 = null;
                    break block39;
                }
                string3 = messagingDao_Impl.getString(n);
            }
            arrayMap.put((Object)string8, (Object)new TinodeContact(string7, string6, string5, bl, string4, string3));
        }
        messagingDao_Impl.close();
        return;
    }

    private WatchPartyType __WatchPartyType_stringToEnum(String string2) {
        if (string2 == null) {
            return null;
        }
        String string3 = string2;
        string3.hashCode();
        if (!string3.equals("PUBLIC")) {
            if (!string2.equals("REGULAR")) {
                throw new IllegalArgumentException("Can't convert value to enum, unknown value: " + string2);
            }
            return WatchPartyType.REGULAR;
        }
        return WatchPartyType.PUBLIC;
    }

    private void __fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus(ArrayMap<String, WatchPartyStatus> arrayMap) {
        int n;
        int n2;
        RoomSQLiteQuery roomSQLiteQuery;
        block27: {
            Set set = arrayMap.keySet();
            if (set.isEmpty()) {
                return;
            }
            if (arrayMap.size() > 999) {
                ArrayMap arrayMap2;
                set = arrayMap2;
                arrayMap2 = new ArrayMap(999);
                int n3 = 0;
                int n4 = arrayMap.size();
                for (int i = 0; i < n4; ++i) {
                    ArrayMap arrayMap3;
                    set.put(arrayMap.keyAt(i), null);
                    if (++n3 != 999) continue;
                    this.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)set);
                    arrayMap.putAll((Map)((Object)set));
                    set = arrayMap3;
                    arrayMap3 = new ArrayMap(999);
                    n3 = 0;
                }
                if (n3 > 0) {
                    this.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)set);
                    arrayMap.putAll((Map)((Object)set));
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `chatId`,`participantStatuses`,`isPrivate`,`isParticipated`,`type` FROM `WatchPartyStatus` WHERE `chatId` IN (");
            int n5 = set.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n5);
            stringBuilder.append(")");
            roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n5 + 0));
            n2 = 1;
            for (String string2 : set) {
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, string2);
                }
                ++n2;
            }
            roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n2 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatId");
            if (n2 != -1) break block27;
            roomSQLiteQuery.close();
            return;
        }
        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
        RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery4 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery5 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery6 = roomSQLiteQuery2;
        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery2, (String)"chatId");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery4, (String)"participantStatuses");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery5, (String)"isPrivate");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery6, (String)"isParticipated");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery3, (String)"type");
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        while (true) {
            Object object;
            String string3;
            Object object2;
            block31: {
                block30: {
                    block29: {
                        block28: {
                            if (!roomSQLiteQuery.moveToNext()) break;
                            ArrayMap<String, WatchPartyStatus> arrayMap4 = arrayMap;
                            object2 = roomSQLiteQuery.getString(n2);
                            if (!arrayMap4.containsKey(object2)) continue;
                            if (!roomSQLiteQuery.isNull(n6)) break block28;
                            string3 = null;
                            break block29;
                        }
                        string3 = roomSQLiteQuery.getString(n6);
                    }
                    if (!roomSQLiteQuery.isNull(n7)) break block30;
                    object = null;
                    break block31;
                }
                object = roomSQLiteQuery.getString(n7);
            }
            RoomSQLiteQuery roomSQLiteQuery7 = roomSQLiteQuery;
            int n10 = n8;
            object = this.__converters.stringToParticipantStatuses((String)object);
            boolean bl = roomSQLiteQuery7.getInt(n10) != 0;
            boolean bl2 = roomSQLiteQuery.getInt(n9) != 0;
            ArrayMap<String, WatchPartyStatus> arrayMap5 = arrayMap;
            String string4 = object2;
            object2 = this.__WatchPartyType_stringToEnum(roomSQLiteQuery.getString(n));
            arrayMap5.put((Object)string4, (Object)new WatchPartyStatus(string3, (List<WatchPartyParticipantStatus>)object, bl, bl2, (WatchPartyType)((Object)object2)));
        }
        roomSQLiteQuery.close();
        return;
    }

    static /* synthetic */ void access$1000(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)arrayMap);
    }

    static /* synthetic */ void access$1100(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)arrayMap);
    }

    static /* synthetic */ void access$1200(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_2((ArrayMap<String, TinodeContact>)arrayMap);
    }

    static /* synthetic */ void access$1300(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)arrayMap);
    }

    @Override
    public long saveChatMessage(ChatMessage chatMessage) {
        long l;
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            l = messagingDao_Impl.__insertionAdapterOfChatMessage.insertAndReturnId((Object)chatMessage);
            MessagingDao_Impl messagingDao_Impl2 = this;
            messagingDao_Impl2.__db.setTransactionSuccessful();
            messagingDao_Impl2.__db.endTransaction();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        return l;
    }

    @Override
    public void saveChatMessages(List<ChatMessage> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatMessage_1.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChatOwner(ChatOwnerCrossRef chatOwnerCrossRef) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatOwnerCrossRef.insert((Object)chatOwnerCrossRef);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void weakSaveChats(List<Topic> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfTopic.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public Object saveTopic(final Topic topic, Continuation<? super Long> continuation) {
        Callable<Long> callable;
        Callable<Long> callable2 = callable;
        callable = new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                Long l;
                16 v0 = this;
                v0.MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    long l2 = v0.MessagingDao_Impl.this.__insertionAdapterOfTopic.insertAndReturnId((Object)topic);
                    MessagingDao_Impl.this.__db.setTransactionSuccessful();
                    l = l2;
                }
                catch (Throwable throwable) {
                    MessagingDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.endTransaction();
                return l;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public void saveChatParticipantCrossRefs(List<ChatParticipantCrossRef> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatParticipantCrossRef.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public Object saveWaveMessage(final WaveMessage waveMessage, Continuation<? super Long> continuation) {
        Callable<Long> callable;
        Callable<Long> callable2 = callable;
        callable = new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                Long l;
                17 v0 = this;
                v0.MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    long l2 = v0.MessagingDao_Impl.this.__insertionAdapterOfWaveMessage.insertAndReturnId((Object)waveMessage);
                    MessagingDao_Impl.this.__db.setTransactionSuccessful();
                    l = l2;
                }
                catch (Throwable throwable) {
                    MessagingDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.endTransaction();
                return l;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public void deleteChatMessage(ChatMessage chatMessage) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__deletionAdapterOfChatMessage.handle((Object)chatMessage);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public Object deleteWaveMessage(final WaveMessage waveMessage, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                18 v0 = this;
                v0.MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    v0.MessagingDao_Impl.this.__deletionAdapterOfWaveMessage.handle((Object)waveMessage);
                }
                catch (Throwable throwable) {
                    MessagingDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                v0.MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                MessagingDao_Impl.this.__db.endTransaction();
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public void updateChatMessage(ChatMessageUpdate chatMessageUpdate) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__updateAdapterOfChatMessageUpdateAsChatMessage.handle((Object)chatMessageUpdate);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChats(List<Topic> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        this.__db.beginTransaction();
        try {
            MessagingDao.DefaultImpls.saveChats(messagingDao_Impl, list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChatParticipants(String string2, List<TinodeContact> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        this.__db.beginTransaction();
        try {
            MessagingDao.DefaultImpls.saveChatParticipants(messagingDao_Impl, string2, list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public Object updateChatMessagedByLocalSeq(final String string2, final String string3, final int n, final ChatMessageStatus chatMessageStatus, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                19 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessagedByLocalSeq.acquire();
                long l = n;
                supportSQLiteStatement.bindLong(1, l);
                int n2 = 2;
                String string22 = v0.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessageStatus);
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, string22);
                }
                n2 = 3;
                string22 = string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, string22);
                }
                n2 = 4;
                string22 = string3;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, string22);
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    19 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessagedByLocalSeq.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                19 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessagedByLocalSeq.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object updateChatMessageSeq(final String string2, final int n, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                20 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageSeq.acquire();
                long l = n;
                supportSQLiteStatement.bindLong(1, l);
                l = n;
                supportSQLiteStatement.bindLong(2, l);
                l = n;
                supportSQLiteStatement.bindLong(3, l);
                int n2 = 4;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, string22);
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    20 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageSeq.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                20 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageSeq.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object updateChatMessageRecvSeq(final String string2, final int n, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                21 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageRecvSeq.acquire();
                long l = n;
                supportSQLiteStatement.bindLong(1, l);
                l = n;
                supportSQLiteStatement.bindLong(2, l);
                int n2 = 3;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, string22);
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    21 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageRecvSeq.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                21 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageRecvSeq.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public void deleteMessages(String string2, ChatMessageStatus object) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = messagingDao_Impl.__preparedStmtOfDeleteMessages.acquire();
        int n = 1;
        if (string2 == null) {
            supportSQLiteStatement.bindNull(n);
        } else {
            supportSQLiteStatement.bindString(n, string2);
        }
        int n2 = 2;
        object = this.__converters.chatStatusToString((ChatMessageStatus)((Object)object));
        if (object == null) {
            supportSQLiteStatement.bindNull(n2);
        } else {
            supportSQLiteStatement.bindString(n2, (String)object);
        }
        MessagingDao_Impl messagingDao_Impl2 = this;
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            MessagingDao_Impl messagingDao_Impl3 = this;
            messagingDao_Impl3.__db.endTransaction();
            messagingDao_Impl3.__preparedStmtOfDeleteMessages.release(supportSQLiteStatement);
            throw throwable;
        }
        messagingDao_Impl2.__db.setTransactionSuccessful();
        messagingDao_Impl2.__db.endTransaction();
        messagingDao_Impl2.__preparedStmtOfDeleteMessages.release(supportSQLiteStatement);
    }

    @Override
    public void deleteChats() {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = messagingDao_Impl.__preparedStmtOfDeleteChats.acquire();
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            MessagingDao_Impl messagingDao_Impl2 = this;
            messagingDao_Impl2.__db.endTransaction();
            messagingDao_Impl2.__preparedStmtOfDeleteChats.release(supportSQLiteStatement);
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
        messagingDao_Impl.__preparedStmtOfDeleteChats.release(supportSQLiteStatement);
    }

    @Override
    public Object deleteWaveEvents(final Date date, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                22 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfDeleteWaveEvents.acquire();
                int n = 1;
                Long l = v0.MessagingDao_Impl.this.__converters.dateToString(date);
                if (l == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindLong(n, l.longValue());
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    22 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfDeleteWaveEvents.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                22 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfDeleteWaveEvents.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasRemoteSeq(String string2, String string3, String string4) {
        void var1_6;
        MessagingDao_Impl messagingDao_Impl2;
        RoomSQLiteQuery roomSQLiteQuery;
        block10: {
            block9: {
                void var2_7;
                void var3_8;
                roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT EXISTS(SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId=? AND ChatMessage.uuid=? AND ChatMessage.senderUserId=?)", (int)3);
                int n = 1;
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n);
                } else {
                    roomSQLiteQuery.bindString(n, string2);
                }
                int bl = 2;
                if (var3_8 == null) {
                    roomSQLiteQuery.bindNull(bl);
                } else {
                    roomSQLiteQuery.bindString(bl, (String)var3_8);
                }
                int n2 = 3;
                if (var2_7 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, (String)var2_7);
                }
                MessagingDao_Impl messagingDao_Impl = messagingDao_Impl2;
                messagingDao_Impl.__db.assertNotSuspendingTransaction();
                messagingDao_Impl2 = DBUtil.query((RoomDatabase)messagingDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                try {
                    if (!messagingDao_Impl2.moveToFirst()) break block9;
                }
                catch (Throwable throwable) {
                    messagingDao_Impl2.close();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                if (messagingDao_Impl2.getInt(0) == 0) break block9;
                boolean bl2 = true;
                break block10;
            }
            boolean bl = false;
        }
        messagingDao_Impl2.close();
        roomSQLiteQuery.release();
        return (boolean)var1_6;
    }

    @Override
    public boolean hasLocalSeq(String string2, int n) {
        boolean bl;
        Cursor cursor;
        RoomSQLiteQuery roomSQLiteQuery;
        block6: {
            block5: {
                roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT EXISTS(SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId=? AND ChatMessage.remoteSeqId=?)", (int)2);
                int n2 = 1;
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, string2);
                }
                MessagingDao_Impl messagingDao_Impl = this;
                long l = n;
                roomSQLiteQuery.bindLong(2, l);
                messagingDao_Impl.__db.assertNotSuspendingTransaction();
                cursor = DBUtil.query((RoomDatabase)messagingDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                try {
                    if (!cursor.moveToFirst()) break block5;
                }
                catch (Throwable throwable) {
                    cursor.close();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                if (cursor.getInt(0) == 0) break block5;
                bl = true;
                break block6;
            }
            bl = false;
        }
        cursor.close();
        roomSQLiteQuery.release();
        return bl;
    }

    @Override
    public Integer getLastRemoteSeqId(String object) {
        RoomSQLiteQuery roomSQLiteQuery;
        block7: {
            block6: {
                roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT ChatMessage.remoteSeqId FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? ORDER BY ChatMessage.remoteSeqId DESC LIMIT 1", (int)1);
                int n = 1;
                if (object == null) {
                    roomSQLiteQuery.bindNull(n);
                } else {
                    roomSQLiteQuery.bindString(n, (String)object);
                }
                MessagingDao_Impl messagingDao_Impl = messagingDao_Impl2;
                messagingDao_Impl.__db.assertNotSuspendingTransaction();
                MessagingDao_Impl messagingDao_Impl2 = DBUtil.query((RoomDatabase)messagingDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                try {
                    if (!messagingDao_Impl2.moveToFirst()) break block6;
                }
                catch (Throwable throwable) {
                    messagingDao_Impl2.close();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                if (messagingDao_Impl2.isNull(0)) break block6;
                object = messagingDao_Impl2.getInt(0);
                break block7;
            }
            object = null;
        }
        messagingDao_Impl2.close();
        roomSQLiteQuery.release();
        return object;
    }

    @Override
    public PagingSource<Integer, ChatMessageRelation> getChatMessagesRelationSource(String string2, List<? extends ChatMessageStatus> object) {
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ");
        stringBuilder.append("?");
        stringBuilder.append(" AND status IN(");
        int n = object.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n);
        stringBuilder.append(") ORDER BY ChatMessage.remoteSeqId DESC");
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n + 1));
        int n2 = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n2);
        } else {
            roomSQLiteQuery.bindString(n2, string2);
        }
        int n3 = 2;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (ChatMessageStatus)((Object)object.next());
            if ((object2 = this.__converters.chatStatusToString((ChatMessageStatus)((Object)object2))) == null) {
                roomSQLiteQuery.bindNull(n3);
            } else {
                roomSQLiteQuery.bindString(n3, (String)object2);
            }
            ++n3;
        }
        return (PagingSource)new DataSource.Factory<Integer, ChatMessageRelation>(){

            public LimitOffsetDataSource<ChatMessageRelation> create() {
                23 v0 = this_;
                23 this_ = v0.MessagingDao_Impl.this.__db;
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                stringArray[0] = "TinodeContact";
                stringArray[1] = "ChatMessage";
                return new LimitOffsetDataSource<ChatMessageRelation>((RoomDatabase)this_, v0.roomSQLiteQuery, true, stringArray2){

                    protected List<ChatMessageRelation> convertRows(Cursor cursor) {
                        ArrayList<ChatMessageRelation> arrayList;
                        ArrayMap arrayMap;
                        Cursor cursor2 = cursor;
                        int n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"uuid");
                        int n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"chatMessageTopicId");
                        int n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"senderUserId");
                        int n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"remoteSeqId");
                        int n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"date");
                        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"text");
                        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"type");
                        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"subtype");
                        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"replyTo");
                        int n10 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"status");
                        ArrayMap arrayMap2 = arrayMap;
                        arrayMap = new ArrayMap();
                        while (cursor.moveToNext()) {
                            arrayMap2.put((Object)cursor.getString(n3), null);
                        }
                        cursor.moveToPosition(-1);
                        MessagingDao_Impl.this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)arrayMap2);
                        ArrayList<ChatMessageRelation> arrayList2 = arrayList;
                        arrayList = new ArrayList<ChatMessageRelation>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            Object object;
                            Object object2;
                            if (cursor.isNull(n) && cursor.isNull(n2) && cursor.isNull(n3) && cursor.isNull(n4) && cursor.isNull(n5) && cursor.isNull(n6) && cursor.isNull(n7) && cursor.isNull(n8) && cursor.isNull(n9) && cursor.isNull(n10)) {
                                object = object2 = null;
                            } else {
                                ChatMessage chatMessage;
                                object2 = cursor.isNull(n2) ? null : cursor.getString(n2);
                                String string2 = cursor.isNull(n3) ? null : cursor.getString(n3);
                                int n11 = cursor.getInt(n4);
                                Comparable<Long> comparable = cursor.isNull(n5) ? null : Long.valueOf(cursor.getLong(n5));
                                comparable = MessagingDao_Impl.this.__converters.timestampToDate((Long)comparable);
                                String string3 = cursor.isNull(n6) ? null : cursor.getString(n6);
                                String string4 = cursor.isNull(n7) ? null : cursor.getString(n7);
                                String string5 = cursor.isNull(n8) ? null : cursor.getString(n8);
                                String string6 = cursor.isNull(n9) ? null : cursor.getString(n9);
                                Object object3 = cursor.isNull(n10) ? null : cursor.getString(n10);
                                object3 = MessagingDao_Impl.this.__converters.stringToChatStatus((String)object3);
                                object = chatMessage;
                                chatMessage = new ChatMessage((String)object2, string2, n11, (Date)comparable, string3, string4, string5, string6, (ChatMessageStatus)((Object)object3));
                                object2 = cursor.isNull(n) ? null : cursor.getString(n);
                                ((ChatMessage)object).setId((String)object2);
                            }
                            object2 = (TinodeContact)arrayMap2.get((Object)cursor.getString(n3));
                            arrayList2.add(new ChatMessageRelation((ChatMessage)object, (TinodeContact)object2));
                        }
                        return arrayList2;
                    }
                };
            }
        }.asPagingSourceFactory().invoke();
    }

    @Override
    public Flow<List<ChatRelation>> getChatsRelation() {
        Callable<List<ChatRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE chatId LIKE 'grp%' AND isWPTopic = 0 ORDER BY Topic.updatedAt DESC", (int)0);
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        stringArray[0] = "ChatParticipantCrossRef";
        stringArray[1] = "TinodeContact";
        stringArray[2] = "ChatMessage";
        stringArray[3] = "Topic";
        Callable<List<ChatRelation>> callable2 = callable;
        callable = new Callable<List<ChatRelation>>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public List<ChatRelation> call() throws Exception {
                v0 = this;
                MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                var4_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                var5_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                var6_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                var7_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                var8_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                var9_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                var10_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"isWPTopic");
                var11_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                var12_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                var13_14 = v1;
                v1 = new ArrayMap();
                var14_15 = v2;
                v2 = new ArrayMap();
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block71: {
                        v3 = var13_14;
                        var15_16 = var1_1.getString(var3_4);
                        if ((ArrayList)v3.get(var15_16) != null) break block71;
                        var13_14.put(var15_16, new ArrayList<E>());
                    }
                    v4 = var14_15;
                    var15_16 = var1_1.getString(var3_4);
                    if ((ArrayList)v4.get(var15_16) != null) continue;
                    var14_15.put(var15_16, new ArrayList<E>());
                    continue;
                }
lbl53:
                // 2 sources

                v5 = this;
                v6 = v5;
                v7 = v5;
                var1_1.moveToPosition(-1);
                MessagingDao_Impl.access$1000(v6.MessagingDao_Impl.this, var13_14);
                MessagingDao_Impl.access$1100(v7.MessagingDao_Impl.this, var14_15);
                var15_16 = v8;
                v8 = new ArrayList<E>(var1_1.getCount());
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block87: {
                        block86: {
                            block85: {
                                block84: {
                                    block83: {
                                        block82: {
                                            block81: {
                                                block80: {
                                                    block79: {
                                                        block78: {
                                                            block77: {
                                                                block76: {
                                                                    block75: {
                                                                        block74: {
                                                                            block73: {
                                                                                block72: {
                                                                                    if (!var1_1.isNull(var2_2)) break block72;
                                                                                    if (!var1_1.isNull(var3_4)) break block72;
                                                                                    if (!var1_1.isNull(var4_5)) break block72;
                                                                                    if (!var1_1.isNull(var5_6)) break block72;
                                                                                    if (!var1_1.isNull(var6_7)) break block72;
                                                                                    if (!var1_1.isNull(var7_8)) break block72;
                                                                                    if (!var1_1.isNull(var8_9)) break block72;
                                                                                    if (!var1_1.isNull(var9_10)) break block72;
                                                                                    if (!var1_1.isNull(var10_11)) break block72;
                                                                                    if (!var1_1.isNull(var11_12)) break block72;
                                                                                    if (!var1_1.isNull(var12_13)) break block72;
                                                                                    var24_25 = var16_17 = null;
                                                                                    ** GOTO lbl184
                                                                                }
                                                                                if (!var1_1.isNull(var3_4)) break block73;
                                                                                var16_17 = null;
                                                                                break block74;
                                                                            }
                                                                            var16_17 = var1_1.getString(var3_4);
                                                                        }
                                                                        if (!var1_1.isNull(var4_5)) break block75;
                                                                        var17_18 = null;
                                                                        break block76;
                                                                    }
                                                                    var17_18 = var1_1.getString(var4_5);
                                                                }
                                                                v9 = var1_1;
                                                                v10 = var8_9;
                                                                v11 = var1_1;
                                                                v12 = var7_8;
                                                                v13 = var1_1;
                                                                v14 = var6_7;
                                                                var18_19 = var1_1.getInt(var5_6);
                                                                var19_20 = v13.getInt(v14);
                                                                var20_21 = v11.getInt(v12);
                                                                if (!v9.isNull(v10)) break block77;
                                                                var21_22 /* !! */  = null;
                                                                break block78;
                                                            }
                                                            var21_22 /* !! */  = var1_1.getLong(var8_9);
                                                        }
                                                        v15 = var1_1;
                                                        v16 = var9_10;
                                                        var21_22 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var21_22 /* !! */ );
                                                        if (!v15.isNull(v16)) break block79;
                                                        var22_23 /* !! */  = null;
                                                        break block80;
                                                    }
                                                    var22_23 /* !! */  = var1_1.getLong(var9_10);
                                                }
                                                v17 = var1_1;
                                                v18 = var10_11;
                                                var22_23 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var22_23 /* !! */ );
                                                var23_24 = v17.getInt(v18) != 0;
                                                if (!var1_1.isNull(var11_12)) break block81;
                                                if (!var1_1.isNull(var12_13)) break block81;
                                                var26_27 = var24_25 = null;
                                                ** GOTO lbl170
                                            }
                                            if (!var1_1.isNull(var11_12)) break block82;
                                            var24_25 = null;
                                            break block83;
                                        }
                                        var24_25 = var1_1.getString(var11_12);
                                    }
                                    if (!var1_1.isNull(var12_13)) break block84;
                                    var25_26 = null;
                                    break block85;
                                }
                                var25_26 = var1_1.getString(var12_13);
                            }
                            var26_27 = v19;
                            v19 = new Access((String)var24_25, var25_26);
lbl170:
                            // 2 sources

                            v20 = var1_1;
                            v21 = var2_2;
                            var24_25 = v22;
                            v22 = new Topic((String)var16_17, (String)var17_18, var18_19, var19_20, var20_21, (Date)var21_22 /* !! */ , (Date)var22_23 /* !! */ , var23_24, (Access)var26_27);
                            if (!v20.isNull(v21)) break block86;
                            var16_17 = null;
                            break block87;
                        }
                        var16_17 = var1_1.getString(var2_2);
                    }
                    var24_25.setWatchPartyStreamId((String)var16_17);
lbl184:
                    // 2 sources

                    var16_17 = (ArrayList)var13_14.get((Object)var1_1.getString(var3_4));
                    if (var16_17 != null) ** GOTO lbl189
                    var16_17 = v23;
                    v23 = new ArrayList<E>();
lbl189:
                    // 2 sources

                    if ((var17_18 = (ArrayList)var14_15.get((Object)var1_1.getString(var3_4))) != null) ** GOTO lbl193
                    var17_18 = v24;
                    v24 = new ArrayList<E>();
lbl193:
                    // 2 sources

                    var15_16.add(new ChatRelation((Topic)var24_25, (List<TinodeContact>)var16_17, (List<ChatMessage>)var17_18));
                    continue;
                }
lbl197:
                // 2 sources

                v25 = var15_16;
                v26 = this;
                v27 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v27.close();
                {
                    catch (Throwable v28) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v28;
                    }
                }
                MessagingDao_Impl.access$100(v26.MessagingDao_Impl.this).endTransaction();
                return v25;
                catch (Throwable var2_3) {
                    var1_1.close();
                    throw var2_3;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Flow<ChatRelation> getChatRelation(String stringArray) {
        Callable<ChatRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE Topic.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[4];
        stringArray = stringArray2;
        stringArray2[0] = "ChatParticipantCrossRef";
        stringArray2[1] = "TinodeContact";
        stringArray2[2] = "ChatMessage";
        stringArray2[3] = "Topic";
        Callable<ChatRelation> callable2 = callable;
        callable = new Callable<ChatRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public ChatRelation call() throws Exception {
                block89: {
                    block71: {
                        block88: {
                            block87: {
                                block86: {
                                    block85: {
                                        block84: {
                                            block83: {
                                                block82: {
                                                    block81: {
                                                        block80: {
                                                            block79: {
                                                                block78: {
                                                                    block77: {
                                                                        block76: {
                                                                            block75: {
                                                                                block74: {
                                                                                    block73: {
                                                                                        block72: {
                                                                                            v0 = this;
                                                                                            MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                                                                                            var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                                                                            var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                                                                                            var3_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                                                                            var4_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                                                                            var5_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                                                                            var6_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                                                                            var7_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                                                                            var8_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                                                                            var9_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                                                                                            var10_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"isWPTopic");
                                                                                            var11_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                                                                                            var12_20 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                                                                                            var13_22 = v1;
                                                                                            v1 = new ArrayMap();
                                                                                            var14_23 = v2;
                                                                                            v2 = new ArrayMap();
                                                                                            ** while (var1_1.moveToNext())
lbl-1000:
                                                                                            // 1 sources

                                                                                            {
                                                                                                block70: {
                                                                                                    v3 = var13_22;
                                                                                                    var15_24 = var1_1.getString(var3_5);
                                                                                                    if ((ArrayList)v3.get((Object)var15_24) != null) break block70;
                                                                                                    var13_22.put((Object)var15_24, new ArrayList<E>());
                                                                                                }
                                                                                                v4 = var14_23;
                                                                                                var15_24 = var1_1.getString(var3_5);
                                                                                                if ((ArrayList)v4.get((Object)var15_24) != null) continue;
                                                                                                var14_23.put((Object)var15_24, new ArrayList<E>());
                                                                                                continue;
                                                                                            }
lbl53:
                                                                                            // 2 sources

                                                                                            v5 = var1_1;
                                                                                            v6 = this;
                                                                                            v7 = v6;
                                                                                            v8 = v6;
                                                                                            var1_1.moveToPosition(-1);
                                                                                            MessagingDao_Impl.access$1000(v7.MessagingDao_Impl.this, var13_22);
                                                                                            MessagingDao_Impl.access$1100(v8.MessagingDao_Impl.this, var14_23);
                                                                                            if (!v5.moveToFirst()) break block71;
                                                                                            if (!var1_1.isNull(var2_2)) break block72;
                                                                                            if (!var1_1.isNull(var3_5)) break block72;
                                                                                            if (!var1_1.isNull(var4_7)) break block72;
                                                                                            if (!var1_1.isNull(var5_10)) break block72;
                                                                                            if (!var1_1.isNull(var6_11)) break block72;
                                                                                            if (!var1_1.isNull(var7_12)) break block72;
                                                                                            if (!var1_1.isNull(var8_13)) break block72;
                                                                                            if (!var1_1.isNull(var9_15)) break block72;
                                                                                            if (!var1_1.isNull((int)var10_17)) break block72;
                                                                                            if (!var1_1.isNull(var11_18)) break block72;
                                                                                            if (!var1_1.isNull(var12_20)) break block72;
                                                                                            var11_19 = var2_3 = null;
                                                                                            ** GOTO lbl182
                                                                                        }
                                                                                        if (!var1_1.isNull(var3_5)) break block73;
                                                                                        var15_24 = null;
                                                                                        break block74;
                                                                                    }
                                                                                    var15_24 = var1_1.getString(var3_5);
                                                                                }
                                                                                if (!var1_1.isNull(var4_7)) break block75;
                                                                                var4_8 = null;
                                                                                break block76;
                                                                            }
                                                                            var4_8 = var1_1.getString(var4_7);
                                                                        }
                                                                        v9 = var1_1;
                                                                        v10 = var8_13;
                                                                        v11 = var1_1;
                                                                        v12 = var7_12;
                                                                        v13 = var1_1;
                                                                        v14 = var6_11;
                                                                        var5_10 = var1_1.getInt(var5_10);
                                                                        var6_11 = v13.getInt(v14);
                                                                        var7_12 = v11.getInt(v12);
                                                                        if (!v9.isNull(v10)) break block77;
                                                                        var8_14 /* !! */  = null;
                                                                        break block78;
                                                                    }
                                                                    var8_14 /* !! */  = var1_1.getLong(var8_13);
                                                                }
                                                                v15 = var1_1;
                                                                v16 = var9_15;
                                                                var8_14 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var8_14 /* !! */ );
                                                                if (!v15.isNull(v16)) break block79;
                                                                var9_16 /* !! */  = null;
                                                                break block80;
                                                            }
                                                            var9_16 /* !! */  = var1_1.getLong(var9_15);
                                                        }
                                                        v17 = var1_1;
                                                        v18 = var10_17;
                                                        var9_16 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var9_16 /* !! */ );
                                                        var10_17 = v17.getInt((int)v18) != 0;
                                                        if (!var1_1.isNull(var11_18)) break block81;
                                                        if (!var1_1.isNull(var12_20)) break block81;
                                                        var16_25 = var11_19 = null;
                                                        ** GOTO lbl168
                                                    }
                                                    if (!var1_1.isNull(var11_18)) break block82;
                                                    var11_19 = null;
                                                    break block83;
                                                }
                                                var11_19 = var1_1.getString(var11_18);
                                            }
                                            if (!var1_1.isNull(var12_20)) break block84;
                                            var12_21 = null;
                                            break block85;
                                        }
                                        var12_21 = var1_1.getString(var12_20);
                                    }
                                    var16_25 = v19;
                                    v19 = new Access((String)var11_19, var12_21);
lbl168:
                                    // 2 sources

                                    v20 = var1_1;
                                    v21 = var2_2;
                                    var11_19 = v22;
                                    v22 = new Topic(var15_24, var4_8, var5_10, var6_11, var7_12, (Date)var8_14 /* !! */ , (Date)var9_16 /* !! */ , var10_17, (Access)var16_25);
                                    if (!v20.isNull(v21)) break block86;
                                    var2_3 = null;
                                    break block87;
                                }
                                var2_3 = var1_1.getString(var2_2);
                            }
                            var11_19.setWatchPartyStreamId((String)var2_3);
lbl182:
                            // 2 sources

                            var2_3 = (ArrayList)var13_22.get((Object)var1_1.getString(var3_5));
                            if (var2_3 != null) ** GOTO lbl187
                            var2_3 = v23;
                            v23 = new ArrayList<E>();
lbl187:
                            // 2 sources

                            if ((var3_6 = (ArrayList)var14_23.get((Object)var1_1.getString(var3_5))) != null) break block88;
                            var3_6 = v24;
                            v24 = new ArrayList<E>();
                        }
                        var4_9 = v25;
                        v25 = new ChatRelation((Topic)var11_19, (List<TinodeContact>)var2_3, var3_6);
                        break block89;
                    }
                    var4_9 = null;
                }
                v26 = var4_9;
                v27 = this;
                v28 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v28.close();
                {
                    catch (Throwable v29) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v29;
                    }
                }
                MessagingDao_Impl.access$100(v27.MessagingDao_Impl.this).endTransaction();
                return v26;
                catch (Throwable var2_4) {
                    var1_1.close();
                    throw var2_4;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Object getTopic(String string2, Continuation<? super Topic> continuation) {
        Callable<Topic> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE Topic.chatId = ?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<Topic> callable2 = callable;
        callable = new Callable<Topic>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public Topic call() throws Exception {
                block54: {
                    block38: {
                        block53: {
                            block52: {
                                block51: {
                                    block50: {
                                        block49: {
                                            block48: {
                                                block47: {
                                                    block46: {
                                                        block45: {
                                                            block44: {
                                                                block43: {
                                                                    block42: {
                                                                        block41: {
                                                                            block40: {
                                                                                block39: {
                                                                                    var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                                                                    try {
                                                                                        var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                                                                                    }
                                                                                    catch (Throwable v0) {
                                                                                        var1_1.close();
                                                                                        roomSQLiteQuery.release();
                                                                                        throw v0;
                                                                                    }
                                                                                    var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                                                                    var4_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                                                                    var5_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                                                                    var6_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                                                                    var7_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                                                                    var8_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                                                                    var9_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                                                                                    var10_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"isWPTopic");
                                                                                    var11_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                                                                                    var12_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                                                                                    if (!var1_1.moveToFirst()) break block38;
                                                                                    if (!var1_1.isNull(var3_4)) break block39;
                                                                                    var3_5 = null;
                                                                                    break block40;
                                                                                }
                                                                                var3_5 = var1_1.getString(var3_4);
                                                                            }
                                                                            if (!var1_1.isNull(var4_6)) break block41;
                                                                            var4_7 = null;
                                                                            break block42;
                                                                        }
                                                                        var4_7 = var1_1.getString(var4_6);
                                                                    }
                                                                    v1 = var1_1;
                                                                    v2 = var8_11;
                                                                    v3 = var1_1;
                                                                    v4 = var7_10;
                                                                    v5 = var1_1;
                                                                    v6 = var6_9;
                                                                    var5_8 = var1_1.getInt(var5_8);
                                                                    var6_9 = v5.getInt(v6);
                                                                    var7_10 = v3.getInt(v4);
                                                                    if (!v1.isNull(v2)) break block43;
                                                                    var8_12 /* !! */  = null;
                                                                    break block44;
                                                                }
                                                                var8_12 /* !! */  = var1_1.getLong(var8_11);
                                                            }
                                                            v7 = var1_1;
                                                            v8 = var9_13;
                                                            var8_12 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var8_12 /* !! */ );
                                                            if (!v7.isNull(v8)) break block45;
                                                            var9_14 /* !! */  = null;
                                                            break block46;
                                                        }
                                                        var9_14 /* !! */  = var1_1.getLong(var9_13);
                                                    }
                                                    v9 = var1_1;
                                                    v10 = var10_15;
                                                    var9_14 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var9_14 /* !! */ );
                                                    var10_15 = v9.getInt((int)v10) != 0;
                                                    if (!var1_1.isNull(var11_16)) break block47;
                                                    if (!var1_1.isNull(var12_18)) break block47;
                                                    var13_20 = var11_17 = null;
                                                    ** GOTO lbl110
                                                }
                                                if (!var1_1.isNull(var11_16)) break block48;
                                                var11_17 = null;
                                                break block49;
                                            }
                                            var11_17 = var1_1.getString(var11_16);
                                        }
                                        if (!var1_1.isNull(var12_18)) break block50;
                                        var12_19 = null;
                                        break block51;
                                    }
                                    var12_19 = var1_1.getString(var12_18);
                                }
                                var13_20 = v11;
                                v11 = new Access((String)var11_17, var12_19);
lbl110:
                                // 2 sources

                                v12 = var1_1;
                                v13 = var2_2;
                                var11_17 = v14;
                                v14 = new Topic(var3_5, var4_7, var5_8, var6_9, var7_10, (Date)var8_12 /* !! */ , (Date)var9_14 /* !! */ , var10_15, (Access)var13_20);
                                if (!v12.isNull(v13)) break block52;
                                var2_3 = null;
                                break block53;
                            }
                            var2_3 = var1_1.getString(var2_2);
                        }
                        var11_17.setWatchPartyStreamId(var2_3);
                        break block54;
                    }
                    var11_17 = null;
                }
                var1_1.close();
                roomSQLiteQuery.release();
                return var11_17;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object isChatExist(String string2, Continuation<? super Boolean> continuation) {
        Callable<Boolean> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT EXISTS(SELECT * FROM Topic WHERE Topic.chatId = ?)", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<Boolean> callable2 = callable;
        callable = new Callable<Boolean>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public Boolean call() throws Exception {
                void var2_10;
                Cursor cursor;
                block12: {
                    block8: {
                        void var2_4;
                        block10: {
                            block9: {
                                cursor = DBUtil.query((RoomDatabase)MessagingDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                try {
                                    if (!cursor.moveToFirst()) break block8;
                                }
                                catch (Throwable throwable) {
                                    cursor.close();
                                    roomSQLiteQuery.release();
                                    throw throwable;
                                }
                                if (!cursor.isNull(0)) break block9;
                                Object var2_2 = null;
                                break block10;
                            }
                            Integer n = cursor.getInt(0);
                        }
                        if (var2_4 != null) {
                            void var2_7;
                            block11: {
                                if (var2_4.intValue() != 0) {
                                    boolean bl = true;
                                    break block11;
                                }
                                boolean bl = false;
                            }
                            Boolean bl = (boolean)var2_7;
                            break block12;
                        }
                    }
                    Object var2_9 = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return var2_10;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Flow<List<WatchPartyRelation>> getWatchPartiesRelation() {
        Callable<List<WatchPartyRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE isWPTopic = 1 ORDER BY Topic.updatedAt DESC", (int)0);
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        stringArray[0] = "ChatOwnerCrossRef";
        stringArray[1] = "TinodeContact";
        stringArray[2] = "WatchPartyStatus";
        stringArray[3] = "ChatParticipantCrossRef";
        stringArray[4] = "ChatMessage";
        stringArray[5] = "Topic";
        Callable<List<WatchPartyRelation>> callable2 = callable;
        callable = new Callable<List<WatchPartyRelation>>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public List<WatchPartyRelation> call() throws Exception {
                v0 = this;
                MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                var4_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                var5_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                var6_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                var7_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                var8_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                var9_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                var10_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"isWPTopic");
                var11_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                var12_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                var13_14 = v1;
                v1 = new ArrayMap();
                var14_15 = v2;
                v2 = new ArrayMap();
                var15_16 = v3;
                v3 = new ArrayMap();
                var16_17 = v4;
                v4 = new ArrayMap();
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block89: {
                        v5 = var15_16;
                        v6 = var1_1;
                        v7 = var3_4;
                        v8 = var14_15;
                        v9 = var1_1;
                        v10 = var3_4;
                        var13_14.put((Object)var1_1.getString(var3_4), null);
                        v8.put((Object)v9.getString(v10), null);
                        var17_18 = v6.getString(v7);
                        if ((ArrayList)v5.get(var17_18) != null) break block89;
                        var15_16.put(var17_18, new ArrayList<E>());
                    }
                    v11 = var16_17;
                    var17_18 = var1_1.getString(var3_4);
                    if ((ArrayList)v11.get(var17_18) != null) continue;
                    var16_17.put(var17_18, new ArrayList<E>());
                    continue;
                }
lbl70:
                // 2 sources

                v12 = this;
                v13 = v12;
                v14 = v12;
                v15 = v12;
                v16 = v12;
                var1_1.moveToPosition(-1);
                MessagingDao_Impl.access$1200(v13.MessagingDao_Impl.this, var13_14);
                MessagingDao_Impl.access$1300(v14.MessagingDao_Impl.this, var14_15);
                MessagingDao_Impl.access$1000(v15.MessagingDao_Impl.this, var15_16);
                MessagingDao_Impl.access$1100(v16.MessagingDao_Impl.this, var16_17);
                var17_18 = v17;
                v17 = new ArrayList<E>(var1_1.getCount());
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block107: {
                        block106: {
                            block105: {
                                block104: {
                                    block103: {
                                        block102: {
                                            block101: {
                                                block100: {
                                                    block99: {
                                                        block98: {
                                                            block97: {
                                                                block96: {
                                                                    block95: {
                                                                        block94: {
                                                                            block93: {
                                                                                block92: {
                                                                                    block91: {
                                                                                        block90: {
                                                                                            if (!var1_1.isNull(var2_2)) break block90;
                                                                                            if (!var1_1.isNull(var3_4)) break block90;
                                                                                            if (!var1_1.isNull(var4_5)) break block90;
                                                                                            if (!var1_1.isNull(var5_6)) break block90;
                                                                                            if (!var1_1.isNull(var6_7)) break block90;
                                                                                            if (!var1_1.isNull(var7_8)) break block90;
                                                                                            if (!var1_1.isNull(var8_9)) break block90;
                                                                                            if (!var1_1.isNull(var9_10)) break block90;
                                                                                            if (!var1_1.isNull(var10_11)) break block90;
                                                                                            if (!var1_1.isNull(var11_12)) break block90;
                                                                                            if (!var1_1.isNull(var12_13)) break block90;
                                                                                            var20_21 = var18_19 = null;
                                                                                            ** GOTO lbl243
                                                                                        }
                                                                                        if (!var1_1.isNull(var2_2)) break block91;
                                                                                        if (!var1_1.isNull(var3_4)) break block91;
                                                                                        if (!var1_1.isNull(var4_5)) break block91;
                                                                                        if (!var1_1.isNull(var5_6)) break block91;
                                                                                        if (!var1_1.isNull(var6_7)) break block91;
                                                                                        if (!var1_1.isNull(var7_8)) break block91;
                                                                                        if (!var1_1.isNull(var8_9)) break block91;
                                                                                        if (!var1_1.isNull(var9_10)) break block91;
                                                                                        if (!var1_1.isNull(var10_11)) break block91;
                                                                                        if (!var1_1.isNull(var11_12)) break block91;
                                                                                        if (!var1_1.isNull(var12_13)) break block91;
                                                                                        var26_29 = var18_19 = null;
                                                                                        ** GOTO lbl230
                                                                                    }
                                                                                    if (!var1_1.isNull(var3_4)) break block92;
                                                                                    var18_19 = null;
                                                                                    break block93;
                                                                                }
                                                                                var18_19 = var1_1.getString(var3_4);
                                                                            }
                                                                            if (!var1_1.isNull(var4_5)) break block94;
                                                                            var19_20 = null;
                                                                            break block95;
                                                                        }
                                                                        var19_20 = var1_1.getString(var4_5);
                                                                    }
                                                                    v18 = var1_1;
                                                                    v19 = var8_9;
                                                                    v20 = var1_1;
                                                                    v21 = var7_8;
                                                                    v22 = var1_1;
                                                                    v23 = var6_7;
                                                                    var20_22 = var1_1.getInt(var5_6);
                                                                    var21_24 = v22.getInt(v23);
                                                                    var22_25 = v20.getInt(v21);
                                                                    if (!v18.isNull(v19)) break block96;
                                                                    var23_26 /* !! */  = null;
                                                                    break block97;
                                                                }
                                                                var23_26 /* !! */  = var1_1.getLong(var8_9);
                                                            }
                                                            v24 = var1_1;
                                                            v25 = var9_10;
                                                            var23_26 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var23_26 /* !! */ );
                                                            if (!v24.isNull(v25)) break block98;
                                                            var24_27 /* !! */  = null;
                                                            break block99;
                                                        }
                                                        var24_27 /* !! */  = var1_1.getLong(var9_10);
                                                    }
                                                    v26 = var1_1;
                                                    v27 = var10_11;
                                                    var24_27 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var24_27 /* !! */ );
                                                    var25_28 = v26.getInt(v27) != 0;
                                                    if (!var1_1.isNull(var11_12)) break block100;
                                                    if (!var1_1.isNull(var12_13)) break block100;
                                                    var28_31 = var26_29 = null;
                                                    ** GOTO lbl216
                                                }
                                                if (!var1_1.isNull(var11_12)) break block101;
                                                var26_29 = null;
                                                break block102;
                                            }
                                            var26_29 = var1_1.getString(var11_12);
                                        }
                                        if (!var1_1.isNull(var12_13)) break block103;
                                        var27_30 = null;
                                        break block104;
                                    }
                                    var27_30 = var1_1.getString(var12_13);
                                }
                                var28_31 = v28;
                                v28 = new Access((String)var26_29, var27_30);
lbl216:
                                // 2 sources

                                v29 = var1_1;
                                v30 = var2_2;
                                var26_29 = v31;
                                v31 = new Topic((String)var18_19, (String)var19_20, var20_22, var21_24, var22_25, (Date)var23_26 /* !! */ , (Date)var24_27 /* !! */ , var25_28, (Access)var28_31);
                                if (!v29.isNull(v30)) break block105;
                                var18_19 = null;
                                break block106;
                            }
                            var18_19 = var1_1.getString(var2_2);
                        }
                        var26_29.setWatchPartyStreamId((String)var18_19);
lbl230:
                        // 2 sources

                        var18_19 = (ArrayList)var15_16.get((Object)var1_1.getString(var3_4));
                        if (var18_19 != null) ** GOTO lbl235
                        var18_19 = v32;
                        v32 = new ArrayList<E>();
lbl235:
                        // 2 sources

                        if ((var19_20 = (ArrayList)var16_17.get((Object)var1_1.getString(var3_4))) != null) break block107;
                        var19_20 = v33;
                        v33 = new ArrayList<E>();
                    }
                    var20_21 = v34;
                    v34 = new ChatRelation((Topic)var26_29, (List<TinodeContact>)var18_19, (List<ChatMessage>)var19_20);
lbl243:
                    // 2 sources

                    v35 = var17_18;
                    v36 = var14_15;
                    v37 = var1_1;
                    v38 = var3_4;
                    var18_19 = (TinodeContact)var13_14.get((Object)var1_1.getString(var3_4));
                    var19_20 = (WatchPartyStatus)v36.get((Object)v37.getString(v38));
                    v35.add(new WatchPartyRelation((ChatRelation)var20_21, (TinodeContact)var18_19, (WatchPartyStatus)var19_20));
                    continue;
                }
lbl255:
                // 2 sources

                v39 = var17_18;
                v40 = this;
                v41 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v41.close();
                {
                    catch (Throwable v42) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v42;
                    }
                }
                MessagingDao_Impl.access$100(v40.MessagingDao_Impl.this).endTransaction();
                return v39;
                catch (Throwable var2_3) {
                    var1_1.close();
                    throw var2_3;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Flow<WatchPartyRelation> observeWatchPartyRelation(String stringArray) {
        Callable<WatchPartyRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE Topic.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[6];
        stringArray = stringArray2;
        stringArray2[0] = "ChatOwnerCrossRef";
        stringArray2[1] = "TinodeContact";
        stringArray2[2] = "WatchPartyStatus";
        stringArray2[3] = "ChatParticipantCrossRef";
        stringArray2[4] = "ChatMessage";
        stringArray2[5] = "Topic";
        Callable<WatchPartyRelation> callable2 = callable;
        callable = new Callable<WatchPartyRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public WatchPartyRelation call() throws Exception {
                block103: {
                    block84: {
                        block102: {
                            block101: {
                                block100: {
                                    block99: {
                                        block98: {
                                            block97: {
                                                block96: {
                                                    block95: {
                                                        block94: {
                                                            block93: {
                                                                block92: {
                                                                    block91: {
                                                                        block90: {
                                                                            block89: {
                                                                                block88: {
                                                                                    block87: {
                                                                                        block86: {
                                                                                            block85: {
                                                                                                var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                                                                                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                                                                                                var3_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                                                                                var4_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                                                                                var5_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                                                                                var6_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                                                                                var7_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                                                                                var8_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                                                                                var9_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                                                                                                var10_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"isWPTopic");
                                                                                                var11_20 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                                                                                                var12_22 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                                                                                                var13_24 = v0;
                                                                                                v0 = new ArrayMap();
                                                                                                var14_25 = v1;
                                                                                                v1 = new ArrayMap();
                                                                                                var15_26 = v2;
                                                                                                v2 = new ArrayMap();
                                                                                                var16_27 = v3;
                                                                                                try {
                                                                                                    v3 = new ArrayMap();
                                                                                                    ** while (var1_1.moveToNext())
                                                                                                }
                                                                                                catch (Throwable v4) {
                                                                                                    var1_1.close();
                                                                                                    throw v4;
                                                                                                }
lbl-1000:
                                                                                                // 1 sources

                                                                                                {
                                                                                                    block83: {
                                                                                                        v5 = var15_26;
                                                                                                        v6 = var1_1;
                                                                                                        v7 = var3_5;
                                                                                                        v8 = var14_25;
                                                                                                        v9 = var1_1;
                                                                                                        v10 = var3_5;
                                                                                                        var13_24.put((Object)var1_1.getString(var3_5), null);
                                                                                                        v8.put((Object)v9.getString(v10), null);
                                                                                                        var17_28 = v6.getString(v7);
                                                                                                        if ((ArrayList)v5.get((Object)var17_28) != null) break block83;
                                                                                                        var15_26.put((Object)var17_28, new ArrayList<E>());
                                                                                                    }
                                                                                                    v11 = var16_27;
                                                                                                    var17_28 = var1_1.getString(var3_5);
                                                                                                    if ((ArrayList)v11.get((Object)var17_28) != null) continue;
                                                                                                    var16_27.put((Object)var17_28, new ArrayList<E>());
                                                                                                    continue;
                                                                                                }
lbl70:
                                                                                                // 2 sources

                                                                                                v12 = var1_1;
                                                                                                v13 = this;
                                                                                                v14 = v13;
                                                                                                v15 = v13;
                                                                                                v16 = v13;
                                                                                                v17 = v13;
                                                                                                var1_1.moveToPosition(-1);
                                                                                                MessagingDao_Impl.access$1200(v14.MessagingDao_Impl.this, var13_24);
                                                                                                MessagingDao_Impl.access$1300(v15.MessagingDao_Impl.this, var14_25);
                                                                                                MessagingDao_Impl.access$1000(v16.MessagingDao_Impl.this, var15_26);
                                                                                                MessagingDao_Impl.access$1100(v17.MessagingDao_Impl.this, var16_27);
                                                                                                if (!v12.moveToFirst()) break block84;
                                                                                                if (!var1_1.isNull(var2_2)) break block85;
                                                                                                if (!var1_1.isNull(var3_5)) break block85;
                                                                                                if (!var1_1.isNull(var4_7)) break block85;
                                                                                                if (!var1_1.isNull(var5_10)) break block85;
                                                                                                if (!var1_1.isNull(var6_11)) break block85;
                                                                                                if (!var1_1.isNull(var7_12)) break block85;
                                                                                                if (!var1_1.isNull(var8_13)) break block85;
                                                                                                if (!var1_1.isNull(var9_15)) break block85;
                                                                                                if (!var1_1.isNull(var10_18)) break block85;
                                                                                                if (!var1_1.isNull(var11_20)) break block85;
                                                                                                if (!var1_1.isNull(var12_22)) break block85;
                                                                                                var4_8 = this = null;
                                                                                                ** GOTO lbl241
                                                                                            }
                                                                                            if (!var1_1.isNull(var2_2)) break block86;
                                                                                            if (!var1_1.isNull(var3_5)) break block86;
                                                                                            if (!var1_1.isNull(var4_7)) break block86;
                                                                                            if (!var1_1.isNull(var5_10)) break block86;
                                                                                            if (!var1_1.isNull(var6_11)) break block86;
                                                                                            if (!var1_1.isNull(var7_12)) break block86;
                                                                                            if (!var1_1.isNull(var8_13)) break block86;
                                                                                            if (!var1_1.isNull(var9_15)) break block86;
                                                                                            if (!var1_1.isNull(var10_18)) break block86;
                                                                                            if (!var1_1.isNull(var11_20)) break block86;
                                                                                            if (!var1_1.isNull(var12_22)) break block86;
                                                                                            var10_19 = this = null;
                                                                                            ** GOTO lbl228
                                                                                        }
                                                                                        if (!var1_1.isNull(var3_5)) break block87;
                                                                                        var17_28 = null;
                                                                                        break block88;
                                                                                    }
                                                                                    var17_28 = var1_1.getString(var3_5);
                                                                                }
                                                                                if (!var1_1.isNull(var4_7)) break block89;
                                                                                var4_9 = null;
                                                                                break block90;
                                                                            }
                                                                            var4_9 = var1_1.getString(var4_7);
                                                                        }
                                                                        v18 = var1_1;
                                                                        v19 = var8_13;
                                                                        v20 = var1_1;
                                                                        v21 = var7_12;
                                                                        v22 = var1_1;
                                                                        v23 = var6_11;
                                                                        var5_10 = var1_1.getInt(var5_10);
                                                                        var6_11 = v22.getInt(v23);
                                                                        var7_12 = v20.getInt(v21);
                                                                        if (!v18.isNull(v19)) break block91;
                                                                        var8_14 /* !! */  = null;
                                                                        break block92;
                                                                    }
                                                                    var8_14 /* !! */  = var1_1.getLong(var8_13);
                                                                }
                                                                v24 = var1_1;
                                                                v25 = var9_15;
                                                                var8_14 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var8_14 /* !! */ );
                                                                if (!v24.isNull(v25)) break block93;
                                                                var9_16 = null;
                                                                break block94;
                                                            }
                                                            var9_16 = var1_1.getLong(var9_15);
                                                        }
                                                        v26 = var1_1;
                                                        v27 = var10_18;
                                                        this = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var9_16);
                                                        var9_17 = v26.getInt(v27) != 0;
                                                        if (!var1_1.isNull(var11_20)) break block95;
                                                        if (!var1_1.isNull(var12_22)) break block95;
                                                        var12_23 = var10_19 = null;
                                                        ** GOTO lbl214
                                                    }
                                                    if (!var1_1.isNull(var11_20)) break block96;
                                                    var10_19 = null;
                                                    break block97;
                                                }
                                                var10_19 = var1_1.getString(var11_20);
                                            }
                                            if (!var1_1.isNull(var12_22)) break block98;
                                            var11_21 = null;
                                            break block99;
                                        }
                                        var11_21 = var1_1.getString(var12_22);
                                    }
                                    var12_23 = v28;
                                    v28 = new Access((String)var10_19, var11_21);
lbl214:
                                    // 2 sources

                                    v29 = var1_1;
                                    v30 = var2_2;
                                    var10_19 = v31;
                                    v31 = new Topic(var17_28, var4_9, var5_10, var6_11, var7_12, (Date)var8_14 /* !! */ , (Date)this, var9_17, (Access)var12_23);
                                    if (!v29.isNull(v30)) break block100;
                                    this = null;
                                    break block101;
                                }
                                this = var1_1.getString(var2_2);
                            }
                            var10_19.setWatchPartyStreamId((String)this);
lbl228:
                            // 2 sources

                            this = (ArrayList)var15_26.get((Object)var1_1.getString(var3_5));
                            if (this != null) ** GOTO lbl233
                            this = v32;
                            v32 = new ArrayList<E>();
lbl233:
                            // 2 sources

                            if ((var2_3 = (ArrayList)var16_27.get((Object)var1_1.getString(var3_5))) != null) break block102;
                            var2_3 = v33;
                            v33 = new ArrayList<E>();
                        }
                        var4_8 = v34;
                        v34 = new ChatRelation((Topic)var10_19, (List<TinodeContact>)this, var2_3);
lbl241:
                        // 2 sources

                        v35 = var14_25;
                        v36 = var1_1;
                        v37 = var3_5;
                        this = (TinodeContact)var13_24.get((Object)var1_1.getString(var3_5));
                        var2_4 = (WatchPartyStatus)v35.get((Object)v36.getString(v37));
                        var3_6 = v38;
                        v38 = new WatchPartyRelation((ChatRelation)var4_8, (TinodeContact)this, var2_4);
                        break block103;
                    }
                    var3_6 = null;
                }
                var1_1.close();
                return var3_6;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Object getWaveByIdAndDate(String string2, Date object, Continuation<? super WaveMessage> continuation) {
        Callable<WaveMessage> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM WaveMessage WHERE chatUserId = ? AND sentAt >= ?", (int)2);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        int n2 = 2;
        object = this.__converters.dateToString((Date)object);
        if (object == null) {
            roomSQLiteQuery.bindNull(n2);
        } else {
            long l = (Long)object;
            roomSQLiteQuery.bindLong(n2, l);
        }
        CancellationSignal cancellationSignal = DBUtil.createCancellationSignal();
        object = callable;
        callable = new Callable<WaveMessage>(){

            @Override
            public WaveMessage call() throws Exception {
                WaveMessage waveMessage;
                Cursor cursor;
                block26: {
                    block17: {
                        WaveMessage waveMessage2;
                        Comparable<Long> comparable;
                        String string2;
                        String string3;
                        String string4;
                        block25: {
                            int n;
                            block24: {
                                block23: {
                                    int n2;
                                    block22: {
                                        block21: {
                                            int n3;
                                            block20: {
                                                block19: {
                                                    int n4;
                                                    block18: {
                                                        cursor = DBUtil.query((RoomDatabase)MessagingDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                                        try {
                                                            n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatUserId");
                                                        }
                                                        catch (Throwable throwable) {
                                                            cursor.close();
                                                            roomSQLiteQuery.release();
                                                            throw throwable;
                                                        }
                                                        n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userName");
                                                        n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userAvatar");
                                                        n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sentAt");
                                                        if (!cursor.moveToFirst()) break block17;
                                                        if (!cursor.isNull(n4)) break block18;
                                                        string4 = null;
                                                        break block19;
                                                    }
                                                    string4 = cursor.getString(n4);
                                                }
                                                if (!cursor.isNull(n3)) break block20;
                                                string3 = null;
                                                break block21;
                                            }
                                            string3 = cursor.getString(n3);
                                        }
                                        if (!cursor.isNull(n2)) break block22;
                                        string2 = null;
                                        break block23;
                                    }
                                    string2 = cursor.getString(n2);
                                }
                                if (!cursor.isNull(n)) break block24;
                                comparable = null;
                                break block25;
                            }
                            comparable = cursor.getLong(n);
                        }
                        comparable = MessagingDao_Impl.this.__converters.timestampToDate((Long)comparable);
                        waveMessage = waveMessage2;
                        waveMessage2 = new WaveMessage(string4, string3, string2, (Date)comparable);
                        break block26;
                    }
                    waveMessage = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return waveMessage;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)cancellationSignal, (Callable)object, continuation);
    }

    @Override
    public void saveOrUpdateChatMessage(ChatMessage chatMessage) {
        MessagingDao.DefaultImpls.saveOrUpdateChatMessage(this, chatMessage);
    }

    @Override
    public PagingSource<Integer, ChatMessageRelation> getChatMessagesSource(String string2, List<? extends ChatMessageStatus> list) {
        return MessagingDao.DefaultImpls.getChatMessagesSource(this, string2, list);
    }

    @Override
    public Flow<List<Topic>> getChats() {
        return MessagingDao.DefaultImpls.getChats(this);
    }

    @Override
    public Flow<Topic> getChat(String string2) {
        return MessagingDao.DefaultImpls.getChat(this, string2);
    }

    @Override
    public Flow<List<WatchParty>> observeWatchParties(Function1<? super WatchPartyRelation, WatchParty> function1) {
        return MessagingDao.DefaultImpls.observeWatchParties(this, function1);
    }
}

