/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.deeplink;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import androidx.appcompat.app.AppCompatActivity;
import com.google.gson.JsonSyntaxException;
import io.streamlayer.sdk.base.StreamLayerBaseFragment;
import io.streamlayer.sdk.base.StreamLayerBaseFragmentKt;
import io.streamlayer.sdk.deeplink.DeepLinkRoute;
import io.streamlayer.sdk.deeplink.ReferralLink;
import io.streamlayer.sdk.model.deeplink.DeepLink;
import io.streamlayer.sdk.model.deeplink.InviteData;
import io.streamlayer.sdk.model.deeplink.Payload;
import io.streamlayer.utils.GsonUtil;
import io.streamlayer.utils.NavigationUtils;
import io.streamlayer.utils.SLRLog;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b#\u0010$J\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J3\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0016\u0010 \u001a\u00020\f8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020\f8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\"\u0010!\u00a8\u0006%"}, d2={"Lio/streamlayer/sdk/deeplink/DeepLinkHandler;", "", "Landroid/content/Intent;", "intent", "Lio/streamlayer/sdk/model/deeplink/DeepLink;", "getDeepLink", "(Landroid/content/Intent;)Lio/streamlayer/sdk/model/deeplink/DeepLink;", "Landroidx/appcompat/app/AppCompatActivity;", "activity", "", "handleDeepLink", "(Landroid/content/Intent;Landroidx/appcompat/app/AppCompatActivity;)Z", "", "json", "Lio/streamlayer/sdk/model/deeplink/InviteData;", "getInvite", "(Ljava/lang/String;)Lio/streamlayer/sdk/model/deeplink/InviteData;", "data", "Landroid/content/Context;", "context", "", "handleInvite", "(Lio/streamlayer/sdk/model/deeplink/InviteData;Landroid/content/Context;)V", "Lio/streamlayer/sdk/deeplink/DeepLinkRoute;", "route", "Landroid/net/Uri;", "destinationUri", "Lio/streamlayer/sdk/model/deeplink/Payload;", "payload", "buildDeepLinkIntent$sdk_originalRelease", "(Landroid/content/Context;Lio/streamlayer/sdk/deeplink/DeepLinkRoute;Landroid/net/Uri;Lio/streamlayer/sdk/model/deeplink/Payload;)Landroid/content/Intent;", "buildDeepLinkIntent", "DEEP_LINK_PAYLOAD_DATA", "Ljava/lang/String;", "DEEP_LINK_NAV_GRAPH_DATA", "<init>", "()V", "sdk_originalRelease"})
public final class DeepLinkHandler {
    private static final String DEEP_LINK_NAV_GRAPH_DATA = "deep_link_graph_data";
    private static final String DEEP_LINK_PAYLOAD_DATA = "deep_link_payload_data";
    @NotNull
    public static final DeepLinkHandler INSTANCE = new DeepLinkHandler();

    private final DeepLink getDeepLink(Intent intent) {
        DeepLink deepLink;
        DeepLinkHandler deepLinkHandler = (Uri)intent.getParcelableExtra(DEEP_LINK_NAV_GRAPH_DATA);
        if (deepLinkHandler != null) {
            DeepLink deepLink2;
            deepLink = deepLink2;
            deepLink2 = new DeepLink((Uri)deepLinkHandler, (Payload)intent.getSerializableExtra(DEEP_LINK_PAYLOAD_DATA));
        } else {
            deepLink = null;
        }
        return deepLink;
    }

    private DeepLinkHandler() {
    }

    public final boolean handleDeepLink(@NotNull Intent intent, @NotNull AppCompatActivity object) {
        boolean bl;
        block2: {
            block0: {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                    Intrinsics.checkNotNullParameter((Object)object, (String)"activity");
                    Object object2 = intent.getData();
                    if (!Intrinsics.areEqual((Object)(object2 != null ? object2.getScheme() : null), (Object)"streamlayer")) break block0;
                    object2 = StreamLayerBaseFragmentKt.findStreamLayerFragment((AppCompatActivity)object);
                    if (object2 == null) break block1;
                    object = INSTANCE.getDeepLink(intent);
                    if (object == null) break block0;
                    SLRLog.INSTANCE.i("DeepLinkHandler", "processDeepLink " + ((DeepLink)object).getUri() + ' ' + ((DeepLink)object).getPayload());
                    ((StreamLayerBaseFragment)object2).processDeepLink$sdk_originalRelease((DeepLink)object);
                    intent.setData(null);
                    bl = true;
                    break block2;
                }
                throw new IllegalStateException("StreamLayerFragment or StreamLayerLiteFragment are not found! Please add android:tag=\"StreamLayerFragment\" to your FragmentContainerView");
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final InviteData getInvite(@NotNull String string2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"json");
        try {
            object = ((ReferralLink)GsonUtil.INSTANCE.getDefaultGson().fromJson(string2, ReferralLink.class)).getData();
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            object = null;
        }
        return object;
    }

    public final void handleInvite(@NotNull InviteData inviteData, @NotNull Context object) {
        Payload.Invite invite2;
        Context context = object;
        DeepLinkHandler deepLinkHandler = object2;
        Context context2 = object;
        Intrinsics.checkNotNullParameter((Object)inviteData, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        SLRLog.INSTANCE.i("DeepLinkHandler", "handleReferralLink link=" + inviteData);
        Object object2 = DeepLinkRoute.INVITE;
        object = invite2;
        invite2 = new Payload.Invite(inviteData);
        context.startActivity(deepLinkHandler.buildDeepLinkIntent$sdk_originalRelease(context2, (DeepLinkRoute)((Object)object2), NavigationUtils.INSTANCE.buildInviteDeepLink(), (Payload)object));
    }

    @NotNull
    public final Intent buildDeepLinkIntent$sdk_originalRelease(@NotNull Context context, @NotNull DeepLinkRoute deepLinkRoute, @Nullable Uri uri, @Nullable Payload payload) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)deepLinkRoute), (String)"route");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("streamlayer://" + context.getPackageName() + deepLinkRoute.getValue())));
        intent.putExtra(DEEP_LINK_NAV_GRAPH_DATA, (Parcelable)uri);
        intent.putExtra(DEEP_LINK_PAYLOAD_DATA, (Serializable)payload);
        return intent;
    }
}

