/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.messaging.chat;

import android.content.Context;
import androidx.arch.core.util.Function;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.paging.CachedPagingDataKt;
import androidx.paging.PagingData;
import io.streamlayer.common.dispatcher.CoroutineDispatcherProvider;
import io.streamlayer.common.mvvm.BaseViewModel;
import io.streamlayer.common.mvvm.Event;
import io.streamlayer.common.mvvm.ViewEvent;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.mvvm.basemodels.ResourceStateKt;
import io.streamlayer.common.network.NetworkConnectionLiveData;
import io.streamlayer.common.scheduler.SchedulerProvider;
import io.streamlayer.common.session.Session;
import io.streamlayer.sdk.messaging.ChatInviteViewModel;
import io.streamlayer.sdk.messaging.MessagingExtensionsKt;
import io.streamlayer.sdk.messaging.chat.AwaitFriends;
import io.streamlayer.sdk.messaging.chat.ChatViewModel;
import io.streamlayer.sdk.messaging.chat.ChatViewModel$special$;
import io.streamlayer.sdk.messaging.chat.HideParticipantsOverlay;
import io.streamlayer.sdk.model.analytics.CommonKind;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.Topic;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.analytics.AnalyticsRepo;
import io.streamlayer.sdk.repository.messaging.MessagingRepo;
import io.streamlayer.sdk.usecases.ChatInviteUseCase;
import io.streamlayer.sdk.usecases.ChatMessagesUseCase;
import io.streamlayer.utils.ExtensionsKt;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BI\b\u0007\u0012\u0006\u0010X\u001a\u00020W\u0012\u0006\u0010S\u001a\u00020R\u0012\u0006\u0010A\u001a\u00020@\u0012\u0006\u0010D\u001a\u00020C\u0012\u0006\u0010-\u001a\u00020,\u0012\u0006\u0010>\u001a\u00020=\u0012\u0006\u0010Z\u001a\u00020Y\u0012\u0006\u0010\\\u001a\u00020[\u00a2\u0006\u0004\b]\u0010^J\u001f\u0010\u0006\u001a\u00020\u00052\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\rJ\u0015\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u001b\u0010\u0016\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0007J\r\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001c\u0010\tR\u0016\u0010\u000b\u001a\u00020\n8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001dR%\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001f0\u001e8\u0006@\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R.\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100%0$8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0016\u0010-\u001a\u00020,8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\"\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002000\u001f0/8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R(\u00103\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001f0/8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00102R+\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001f0\u001e8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010!\u001a\u0004\b4\u0010#R%\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001f0\u001e8\u0006@\u0006\u00a2\u0006\f\n\u0004\b5\u0010!\u001a\u0004\b6\u0010#R\u001c\u00109\u001a\b\u0012\u0004\u0012\u000208078\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R%\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002000\u001f0\u001e8\u0006@\u0006\u00a2\u0006\f\n\u0004\b;\u0010!\u001a\u0004\b<\u0010#R\u0016\u0010>\u001a\u00020=8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0016\u0010A\u001a\u00020@8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u0016\u0010D\u001a\u00020C8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010ER.\u0010F\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100%0$8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\bF\u0010'\u001a\u0004\bG\u0010)\"\u0004\bH\u0010+R%\u0010I\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001f0\u001e8\u0006@\u0006\u00a2\u0006\f\n\u0004\bI\u0010!\u001a\u0004\bJ\u0010#R%\u0010L\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002080K0$8\u0006@\u0006\u00a2\u0006\f\n\u0004\bL\u0010'\u001a\u0004\bM\u0010)R\"\u0010N\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001f0/8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bN\u00102R\u0016\u0010P\u001a\u00020O8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u0016\u0010S\u001a\u00020R8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bS\u0010TR\u001f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00170\u001e8\u0006@\u0006\u00a2\u0006\f\n\u0004\bU\u0010!\u001a\u0004\bV\u0010#\u00a8\u0006_"}, d2={"Lio/streamlayer/sdk/messaging/chat/ChatViewModel;", "Lio/streamlayer/sdk/messaging/ChatInviteViewModel;", "", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "participants", "", "checkParticipants", "(Ljava/util/List;)V", "observeActiveCall", "()V", "", "chatId", "init", "(Ljava/lang/String;)V", "text", "sendMessage", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "message", "resendMessage", "(Lio/streamlayer/sdk/model/messaging/ChatMessage;)V", "removeMessage", "messages", "messageRead", "", "isMuted", "()Z", "setMuted", "(Z)V", "hideParticipantsLayout", "Ljava/lang/String;", "Landroidx/lifecycle/LiveData;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "showCallButton", "Landroidx/lifecycle/LiveData;", "getShowCallButton", "()Landroidx/lifecycle/LiveData;", "Lkotlinx/coroutines/flow/Flow;", "Landroidx/paging/PagingData;", "chatMessages", "Lkotlinx/coroutines/flow/Flow;", "getChatMessages", "()Lkotlinx/coroutines/flow/Flow;", "setChatMessages", "(Lkotlinx/coroutines/flow/Flow;)V", "Lio/streamlayer/common/dispatcher/CoroutineDispatcherProvider;", "dispatcherProvider", "Lio/streamlayer/common/dispatcher/CoroutineDispatcherProvider;", "Landroidx/lifecycle/MutableLiveData;", "Lio/streamlayer/sdk/model/messaging/Topic;", "_chat", "Landroidx/lifecycle/MutableLiveData;", "_participants", "getParticipants", "hasMessages", "getHasMessages", "Lkotlinx/coroutines/channels/Channel;", "Lio/streamlayer/common/mvvm/ViewEvent;", "viewEventsChannel", "Lkotlinx/coroutines/channels/Channel;", "topic", "getTopic", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "analyticsRepo", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "Lio/streamlayer/common/session/Session;", "session", "Lio/streamlayer/common/session/Session;", "Lio/streamlayer/sdk/usecases/ChatMessagesUseCase;", "chatMessagesUseCase", "Lio/streamlayer/sdk/usecases/ChatMessagesUseCase;", "failedChatMessages", "getFailedChatMessages", "setFailedChatMessages", "loading", "getLoading", "Lio/streamlayer/common/mvvm/Event;", "viewEvents", "getViewEvents", "_showCallButton", "Lio/streamlayer/common/network/NetworkConnectionLiveData;", "_networkConnectionLiveData", "Lio/streamlayer/common/network/NetworkConnectionLiveData;", "Lio/streamlayer/sdk/repository/messaging/MessagingRepo;", "repo", "Lio/streamlayer/sdk/repository/messaging/MessagingRepo;", "networkConnectionLiveData", "getNetworkConnectionLiveData", "Lio/streamlayer/common/scheduler/SchedulerProvider;", "schedulers", "Landroid/content/Context;", "context", "Lio/streamlayer/sdk/usecases/ChatInviteUseCase;", "chatInviteUseCase", "<init>", "(Lio/streamlayer/common/scheduler/SchedulerProvider;Lio/streamlayer/sdk/repository/messaging/MessagingRepo;Lio/streamlayer/common/session/Session;Lio/streamlayer/sdk/usecases/ChatMessagesUseCase;Lio/streamlayer/common/dispatcher/CoroutineDispatcherProvider;Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;Landroid/content/Context;Lio/streamlayer/sdk/usecases/ChatInviteUseCase;)V", "sdk_originalRelease"})
public final class ChatViewModel
extends ChatInviteViewModel {
    @NotNull
    private final MessagingRepo repo;
    @NotNull
    private final Session session;
    @NotNull
    private final ChatMessagesUseCase chatMessagesUseCase;
    @NotNull
    private final CoroutineDispatcherProvider dispatcherProvider;
    @NotNull
    private final AnalyticsRepo analyticsRepo;
    private String chatId;
    public Flow<PagingData<ChatMessage>> chatMessages;
    public Flow<PagingData<ChatMessage>> failedChatMessages;
    @NotNull
    private final NetworkConnectionLiveData _networkConnectionLiveData;
    @NotNull
    private final LiveData<Boolean> networkConnectionLiveData;
    @NotNull
    private final MutableLiveData<ResourceState<Topic>> _chat;
    @NotNull
    private final LiveData<ResourceState<Topic>> topic;
    @NotNull
    private final LiveData<ResourceState<Boolean>> hasMessages;
    @NotNull
    private final MutableLiveData<ResourceState<List<TinodeContact>>> _participants;
    @NotNull
    private final LiveData<ResourceState<List<TinodeContact>>> participants;
    @NotNull
    private final LiveData<ResourceState<Boolean>> loading;
    @NotNull
    private final Channel<ViewEvent> viewEventsChannel;
    @NotNull
    private final Flow<Event<ViewEvent>> viewEvents;
    @NotNull
    private final MutableLiveData<ResourceState<Boolean>> _showCallButton;
    @NotNull
    private final LiveData<ResourceState<Boolean>> showCallButton;

    @Inject
    public ChatViewModel(@NotNull SchedulerProvider schedulerProvider, @NotNull MessagingRepo messagingRepo, @NotNull Session session, @NotNull ChatMessagesUseCase chatMessagesUseCase, @NotNull CoroutineDispatcherProvider coroutineDispatcherProvider, @NotNull AnalyticsRepo analyticsRepo, @NotNull Context context, @NotNull ChatInviteUseCase chatInviteUseCase) {
        MutableLiveData mutableLiveData;
        MutableLiveData mutableLiveData2;
        MutableLiveData mutableLiveData3;
        ChatViewModel chatViewModel2 = chatViewModel5;
        ChatViewModel chatViewModel3 = chatViewModel5;
        ChatViewModel chatViewModel4 = chatViewModel5;
        ChatInviteUseCase chatInviteUseCase2 = chatInviteUseCase;
        Intrinsics.checkNotNullParameter((Object)schedulerProvider, (String)"schedulers");
        Intrinsics.checkNotNullParameter((Object)messagingRepo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)chatMessagesUseCase, (String)"chatMessagesUseCase");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcherProvider, (String)"dispatcherProvider");
        Intrinsics.checkNotNullParameter((Object)analyticsRepo, (String)"analyticsRepo");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)chatInviteUseCase2, (String)"chatInviteUseCase");
        super(chatInviteUseCase2, session, coroutineDispatcherProvider, schedulerProvider);
        chatViewModel5.repo = messagingRepo;
        chatViewModel5.session = session;
        chatViewModel5.chatMessagesUseCase = chatMessagesUseCase;
        chatViewModel5.dispatcherProvider = coroutineDispatcherProvider;
        chatViewModel4.analyticsRepo = analyticsRepo;
        chatViewModel5._networkConnectionLiveData = new NetworkConnectionLiveData(context);
        LiveData liveData = Transformations.distinctUntilChanged((LiveData)chatViewModel5._networkConnectionLiveData);
        Intrinsics.checkNotNullExpressionValue((Object)liveData, (String)"Transformations.distinctUntilChanged(this)");
        chatViewModel4.networkConnectionLiveData = liveData;
        schedulerProvider = mutableLiveData3;
        chatViewModel4._chat = new MutableLiveData();
        chatViewModel4.topic = schedulerProvider;
        LiveData liveData2 = Transformations.distinctUntilChanged(chatMessagesUseCase.getHasMessages());
        Intrinsics.checkNotNullExpressionValue((Object)liveData2, (String)"Transformations.distinctUntilChanged(this)");
        LiveData liveData3 = Transformations.map((LiveData)liveData2, new Function<Boolean, ResourceState<? extends Boolean>>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object apply(Object object) {
                return ResourceState.Companion.success((Boolean)object);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)liveData3, (String)"Transformations.map(this) { transform(it) }");
        chatViewModel3.hasMessages = liveData3;
        schedulerProvider = mutableLiveData2;
        chatViewModel3._participants = new MutableLiveData();
        chatViewModel3.participants = schedulerProvider;
        LiveData liveData4 = Transformations.map(chatMessagesUseCase.getLoadingLiveData(), new Function<Boolean, ResourceState<? extends Boolean>>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object apply(Object object) {
                return ResourceState.Companion.success((Boolean)object);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)liveData4, (String)"Transformations.map(this) { transform(it) }");
        chatViewModel2.loading = liveData4;
        chatViewModel5.viewEventsChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        ChatViewModel chatViewModel5 = FlowKt.receiveAsFlow((ReceiveChannel)chatViewModel5.viewEventsChannel);
        chatViewModel2.viewEvents = new Flow<Event<? extends ViewEvent>>((Flow)chatViewModel5){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            {
                this.$this_unsafeTransform$inlined = flow;
            }

            @Nullable
            public Object collect(@NotNull FlowCollector flowCollector, @NotNull Continuation continuation) {
                if ((this = this.$this_unsafeTransform$inlined.collect((FlowCollector)new FlowCollector<ViewEvent>(flowCollector, this){
                    final /* synthetic */ FlowCollector $this_unsafeFlow$inlined;
                    final /* synthetic */ special$$inlined$map$3 this$0;
                    {
                        this.$this_unsafeFlow$inlined = flowCollector;
                        this.this$0 = var2_2;
                    }

                    /*
                     * Unable to fully structure code
                     * Could not resolve type clashes
                     */
                    @Nullable
                    public Object emit(Object var1_1, @NotNull Continuation var2_2) {
                        if (!(var2_2 /* !! */  instanceof special$$inlined$map$3$2$1)) ** GOTO lbl-1000
                        var3_3 = var2_2 /* !! */ ;
                        var4_4 = var3_3.label;
                        if ((var4_4 & -2147483648) != 0) {
                            var3_3.label = var4_4 - -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            var3_3 = v0;
                            v0 = new ContinuationImpl(this, var2_2 /* !! */ ){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ special$$inlined$map$3$2 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(continuation);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    special$$inlined$map$3$2$1 v0 = this;
                                    v0.result = object;
                                    v0.label |= Integer.MIN_VALUE;
                                    return v0.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        v1 = var3_3;
                        var2_2 /* !! */  = v1.result;
                        var4_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        var5_6 = v1.label;
                        if (var5_6 == 0) ** GOTO lbl18
                        if (var5_6 == 1) {
                            ResultKt.throwOnFailure((Object)var2_2 /* !! */ );
                        } else {
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
lbl18:
                            // 1 sources

                            ResultKt.throwOnFailure((Object)var2_2 /* !! */ );
                            this = (ViewEvent)var1_1;
                            var1_1 = v2;
                            v2 = new Event<Object>(this);
                            var3_3.label = 1;
                            if (this.$this_unsafeFlow$inlined.emit(var1_1, (Continuation)var3_3) == var4_5) {
                                return var4_5;
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }, continuation)) == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return this;
                }
                return Unit.INSTANCE;
            }
        };
        chatViewModel5 = mutableLiveData;
        chatViewModel2._showCallButton = new MutableLiveData();
        chatViewModel2.showCallButton = chatViewModel5;
    }

    private final void checkParticipants(List<TinodeContact> list) {
        if (!(list == null || list.isEmpty()) && list.size() == 1) {
            this.viewEventsChannel.offer((Object)AwaitFriends.INSTANCE);
        }
    }

    private final void observeActiveCall() {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        String string2 = this.session.getActiveWpId();
        if (string2 == null) {
            this._showCallButton.postValue(ResourceState.Companion.success(Boolean.TRUE));
            return;
        }
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, string2, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ChatViewModel this$0;
            final /* synthetic */ String $activeCallId;
            {
                this.this$0 = chatViewModel2;
                this.$activeCallId = string2;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2;
                Object object3;
                block5: {
                    Deferred deferred;
                    Object object4;
                    Object object5;
                    block6: {
                        Function2<CoroutineScope, Continuation<? super ResourceState<? extends List<? extends TinodeContact>>>, Object> function2;
                        Function2<CoroutineScope, Continuation<? super ResourceState<? extends List<? extends TinodeContact>>>, Object> function22;
                        block2: {
                            block3: {
                                block4: {
                                    object5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    int n = object4.label;
                                    if (n == 0) break block2;
                                    if (n == 1) break block3;
                                    if (n != 2) break block4;
                                    observeActiveCall.1 v0 = object4;
                                    object4 = v0.L$2;
                                    object5 = (ResourceState.Companion)v0.L$1;
                                    object3 = (MutableLiveData)v0.L$0;
                                    ResultKt.throwOnFailure((Object)object);
                                    Object object6 = object;
                                    ResourceState.Companion companion = object3;
                                    object = object4;
                                    object3 = object5;
                                    object2 = companion;
                                    object4 = object6;
                                    break block5;
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                            observeActiveCall.1 v3 = object4;
                            object3 = (ResourceState.Companion)v3.L$2;
                            object2 = (MutableLiveData)v3.L$1;
                            deferred = (Deferred)v3.L$0;
                            ResultKt.throwOnFailure((Object)object);
                            break block6;
                        }
                        ResultKt.throwOnFailure((Object)object);
                        object = (CoroutineScope)object4.L$0;
                        object3 = function22;
                        observeActiveCall.1 v5 = object4;
                        object2 = v5.this$0;
                        function22 = new Function2<CoroutineScope, Continuation<? super ResourceState<? extends List<? extends TinodeContact>>>, Object>((ChatViewModel)((Object)object2), v5.$activeCallId, null){
                            int label;
                            final /* synthetic */ ChatViewModel this$0;
                            final /* synthetic */ String $activeCallId;
                            {
                                this.this$0 = chatViewModel2;
                                this.$activeCallId = string2;
                                super(2, continuation);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                int n = this.label;
                                if (n != 0) {
                                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    ResultKt.throwOnFailure((Object)object);
                                    return object;
                                } else {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    object = FlowKt.firstOrNull((Flow)ExtensionsKt.catchDefault$default(ChatViewModel.access$getRepo$p(this.this$0).getParticipants(this.$activeCallId), "ChatViewModel", null, 2, null), (Continuation)this);
                                    if (object != object2) return object;
                                    return object2;
                                }
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                                observeActiveCall.callParticipants.1 v0 = object2;
                                Object object2 = v0.this$0;
                                return new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super ResourceState<? extends List<TinodeContact>>> continuation) {
                                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                            }
                        };
                        Deferred deferred2 = BuildersKt.async$default((CoroutineScope)object, null, null, (Function2)object3, (int)3, null);
                        Object object7 = object;
                        object = function2;
                        function2 = new Function2<CoroutineScope, Continuation<? super ResourceState<? extends List<? extends TinodeContact>>>, Object>(object4.this$0, null){
                            int label;
                            final /* synthetic */ ChatViewModel this$0;
                            {
                                this.this$0 = chatViewModel2;
                                super(2, continuation);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                int n = this.label;
                                if (n == 0) {
                                    observeActiveCall.chatParticipants.1 v0 = this;
                                    ResultKt.throwOnFailure((Object)object);
                                    object = ChatViewModel.access$getRepo$p(v0.this$0);
                                    String string2 = ChatViewModel.access$getChatId$p(v0.this$0);
                                    if (string2 != null) {
                                        this.label = 1;
                                        if ((object = FlowKt.firstOrNull((Flow)ExtensionsKt.catchDefault$default(object.getParticipants(string2), "ChatViewModel", null, 2, null), (Continuation)this)) != object2) return object;
                                        return object2;
                                    }
                                } else {
                                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    ResultKt.throwOnFailure((Object)object);
                                    return object;
                                }
                                Intrinsics.throwUninitializedPropertyAccessException((String)"chatId");
                                throw null;
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                                return new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super ResourceState<? extends List<TinodeContact>>> continuation) {
                                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                            }
                        };
                        deferred = BuildersKt.async$default((CoroutineScope)object7, null, null, (Function2)object, (int)3, null);
                        object2 = ChatViewModel.access$get_showCallButton$p(object4.this$0);
                        object3 = ResourceState.Companion;
                        object4.L$0 = deferred;
                        object4.L$1 = object2;
                        object4.L$2 = object3;
                        object4.label = 1;
                        object = deferred2.await((Continuation)object4);
                        if (object == object5) {
                            return object5;
                        }
                    }
                    Object object8 = object4;
                    object8.L$0 = object2;
                    object8.L$1 = object3;
                    object8.L$2 = object;
                    object8.label = 2;
                    object4 = deferred.await((Continuation)object4);
                    if (object4 == object5) {
                        return object5;
                    }
                }
                object2.postValue(((ResourceState.Companion)object3).success(Boxing.boxBoolean((boolean)(Intrinsics.areEqual((Object)object, (Object)object4) ^ true))));
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                observeActiveCall.1 v0 = object2;
                Object object2 = v0.this$0;
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)function22, (int)3, null);
    }

    public static final /* synthetic */ MessagingRepo access$getRepo$p(ChatViewModel chatViewModel2) {
        return chatViewModel2.repo;
    }

    public static final /* synthetic */ MutableLiveData access$get_chat$p(ChatViewModel chatViewModel2) {
        return chatViewModel2._chat;
    }

    public static final /* synthetic */ Session access$getSession$p(ChatViewModel chatViewModel2) {
        return chatViewModel2.session;
    }

    public static final /* synthetic */ MutableLiveData access$get_participants$p(ChatViewModel chatViewModel2) {
        return chatViewModel2._participants;
    }

    public static final /* synthetic */ void access$checkParticipants(ChatViewModel chatViewModel2, List list) {
        chatViewModel2.checkParticipants(list);
    }

    public static final /* synthetic */ AnalyticsRepo access$getAnalyticsRepo$p(ChatViewModel chatViewModel2) {
        return chatViewModel2.analyticsRepo;
    }

    public static final /* synthetic */ String access$getChatId$p(ChatViewModel chatViewModel2) {
        return chatViewModel2.chatId;
    }

    public static final /* synthetic */ MutableLiveData access$get_showCallButton$p(ChatViewModel chatViewModel2) {
        return chatViewModel2._showCallButton;
    }

    @NotNull
    public final Flow<PagingData<ChatMessage>> getChatMessages() {
        Flow<PagingData<ChatMessage>> flow = flow.chatMessages;
        if (flow != null) {
            return flow;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"chatMessages");
        throw null;
    }

    public final void setChatMessages(@NotNull Flow<PagingData<ChatMessage>> flow) {
        Intrinsics.checkNotNullParameter(flow, (String)"<set-?>");
        this.chatMessages = flow;
    }

    @NotNull
    public final Flow<PagingData<ChatMessage>> getFailedChatMessages() {
        Flow<PagingData<ChatMessage>> flow = flow.failedChatMessages;
        if (flow != null) {
            return flow;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"failedChatMessages");
        throw null;
    }

    public final void setFailedChatMessages(@NotNull Flow<PagingData<ChatMessage>> flow) {
        Intrinsics.checkNotNullParameter(flow, (String)"<set-?>");
        this.failedChatMessages = flow;
    }

    @NotNull
    public final LiveData<Boolean> getNetworkConnectionLiveData() {
        return this.networkConnectionLiveData;
    }

    @NotNull
    public final LiveData<ResourceState<Topic>> getTopic() {
        return this.topic;
    }

    @NotNull
    public final LiveData<ResourceState<Boolean>> getHasMessages() {
        return this.hasMessages;
    }

    @NotNull
    public final LiveData<ResourceState<List<TinodeContact>>> getParticipants() {
        return this.participants;
    }

    @NotNull
    public final LiveData<ResourceState<Boolean>> getLoading() {
        return this.loading;
    }

    @NotNull
    public final Flow<Event<ViewEvent>> getViewEvents() {
        return this.viewEvents;
    }

    @NotNull
    public final LiveData<ResourceState<Boolean>> getShowCallButton() {
        return this.showCallButton;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void init(@NotNull String object) {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"chatId");
        String string2 = this.chatId;
        if (string2 != null) {
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"chatId");
                throw null;
            }
            if (Intrinsics.areEqual((Object)string2, (Object)object)) {
                object = (ResourceState)this._chat.getValue();
                object = object == null || (object = (Topic)((ResourceState)object).getData()) == null ? null : ((Topic)object).getParticipants();
                this.checkParticipants((List<TinodeContact>)object);
                return;
            }
        }
        ChatViewModel chatViewModel2 = this;
        chatViewModel2.chatId = object;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (String)object, null){
            int label;
            final /* synthetic */ ChatViewModel this$0;
            final /* synthetic */ String $chatId;
            {
                this.this$0 = chatViewModel2;
                this.$chatId = string2;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    ResultKt.throwOnFailure((Object)object);
                    return Unit.INSTANCE;
                } else {
                    FlowCollector<ResourceState<? extends Topic>> flowCollector;
                    Ref.ObjectRef objectRef;
                    ResultKt.throwOnFailure((Object)object);
                    object = objectRef;
                    objectRef = new Ref.ObjectRef();
                    ChatViewModel chatViewModel2 = this.this$0;
                    FlowCollector<ResourceState<? extends Topic>> flowCollector2 = flowCollector;
                    flowCollector = new FlowCollector<ResourceState<? extends Topic>>(chatViewModel2, (Ref.ObjectRef)object){
                        final /* synthetic */ ChatViewModel this$0;
                        final /* synthetic */ Ref.ObjectRef $isGroup$inlined;
                        {
                            this.this$0 = chatViewModel2;
                            this.$isGroup$inlined = objectRef;
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled aggressive block sorting
                         */
                        @Nullable
                        public Object emit(Object object, @NotNull Continuation object2) {
                            ResourceState resourceState = (ResourceState)object;
                            ChatViewModel.access$get_chat$p(analyticsRepo.this$0).postValue((Object)resourceState);
                            ResourceState<List<? extends TinodeContact>> resourceState2 = ResourceStateKt.mapValue(resourceState, new Function1<Topic, List<? extends TinodeContact>>(analyticsRepo.this$0){
                                final /* synthetic */ ChatViewModel this$0;
                                {
                                    this.this$0 = chatViewModel2;
                                    super(1);
                                }

                                @Nullable
                                public final List<TinodeContact> invoke(@Nullable Topic topic) {
                                    return topic == null ? null : MessagingExtensionsKt.participantsWithoutUser(topic, ChatViewModel.access$getSession$p(this.this$0).getTinodeUserId());
                                }
                            });
                            ChatViewModel.access$get_participants$p(analyticsRepo.this$0).postValue(resourceState2);
                            Object object3 = resourceState2.getData();
                            boolean bl = (object3 == null || (object3 = Boxing.boxInt((int)object3.size())) == null ? 0 : (Integer)object3) + 1 > 2;
                            ChatViewModel chatViewModel2 = analyticsRepo.this$0;
                            Object object4 = (Topic)resourceState.getData();
                            object4 = object4 == null ? null : ((Topic)object4).getParticipants();
                            ChatViewModel.access$checkParticipants(chatViewModel2, (List)object4);
                            if (!Intrinsics.areEqual((Object)analyticsRepo.$isGroup$inlined.element, (Object)Boxing.boxBoolean((boolean)bl))) {
                                void var1_6;
                                analyticsRepo.$isGroup$inlined.element = Boxing.boxBoolean((boolean)bl);
                                AnalyticsRepo analyticsRepo = ChatViewModel.access$getAnalyticsRepo$p(analyticsRepo.this$0);
                                if (bl) {
                                    CommonKind commonKind = CommonKind.GROUP_CONVERSATION_OPENED;
                                } else {
                                    CommonKind commonKind = CommonKind.CONVERSATION_OPENED;
                                }
                                AnalyticsRepo.DefaultImpls.triggerConversationEvent$default(analyticsRepo, (CommonKind)var1_6, null, null, 6, null);
                            }
                            return Unit.INSTANCE;
                        }
                    };
                    this.label = 1;
                    if (ExtensionsKt.catchDefault$default(ChatViewModel.access$getRepo$p(this.this$0).getChat(this.$chatId), "ChatViewModel", null, 2, null).collect((FlowCollector)flowCollector2, (Continuation)this) != object2) return Unit.INSTANCE;
                    return object2;
                }
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                init.2 v0 = object2;
                Object object2 = v0.this$0;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)chatViewModel2), (CoroutineContext)this.dispatcherProvider.getDefault(), null, (Function2)function22, (int)2, null);
        chatViewModel2.setChatMessages((Flow<PagingData<ChatMessage>>)CachedPagingDataKt.cachedIn((Flow)FlowKt.flowOn(chatViewModel2.chatMessagesUseCase.paginatedMessagesSource((String)object), (CoroutineContext)this.dispatcherProvider.getIo()), (CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this)));
        chatViewModel2.setFailedChatMessages((Flow<PagingData<ChatMessage>>)CachedPagingDataKt.cachedIn((Flow)FlowKt.flowOn(chatViewModel2.chatMessagesUseCase.paginateFailedMessagesSource((String)object), (CoroutineContext)this.dispatcherProvider.getIo()), (CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this)));
        chatViewModel2.observeActiveCall();
    }

    public final void sendMessage(@NotNull String string2) {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"text");
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, string2, null){
            int label;
            final /* synthetic */ ChatViewModel this$0;
            final /* synthetic */ String $text;
            {
                this.this$0 = chatViewModel2;
                this.$text = string2;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n == 0) {
                    sendMessage.1 v0 = this;
                    ResultKt.throwOnFailure((Object)object);
                    object = ChatViewModel.access$getRepo$p(v0.this$0);
                    String string2 = ChatViewModel.access$getChatId$p(v0.this$0);
                    if (string2 != null) {
                        Object object3 = object;
                        object = this.$text;
                        this.label = 1;
                        if (object3.sendMessage(string2, (String)object, (Continuation<? super ResourceState<Boolean>>)this) != object2) return Unit.INSTANCE;
                        return object2;
                    }
                } else {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    ResultKt.throwOnFailure((Object)object);
                    return Unit.INSTANCE;
                }
                Intrinsics.throwUninitializedPropertyAccessException((String)"chatId");
                throw null;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                sendMessage.1 v0 = object2;
                Object object2 = v0.this$0;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)this.dispatcherProvider.getIo(), null, (Function2)function22, (int)2, null);
    }

    public final void resendMessage(@NotNull ChatMessage chatMessage) {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"message");
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, chatMessage, null){
            int label;
            final /* synthetic */ ChatViewModel this$0;
            final /* synthetic */ ChatMessage $message;
            {
                this.this$0 = chatViewModel2;
                this.$message = chatMessage;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    ResultKt.throwOnFailure((Object)object);
                    return Unit.INSTANCE;
                } else {
                    ResultKt.throwOnFailure((Object)object);
                    object = this.$message;
                    this.label = 1;
                    if (ChatViewModel.access$getRepo$p(this.this$0).resendMessage((ChatMessage)object, (Continuation<? super ResourceState<Boolean>>)this) != object2) return Unit.INSTANCE;
                    return object2;
                }
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                resendMessage.1 v0 = object2;
                Object object2 = v0.this$0;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)this.dispatcherProvider.getIo(), null, (Function2)function22, (int)2, null);
    }

    public final void removeMessage(@NotNull ChatMessage chatMessage) {
        Function0<Unit> function0;
        ChatViewModel chatViewModel2 = this;
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"message");
        MutableLiveData<ResourceState<Topic>> mutableLiveData = chatViewModel2._chat;
        Function0<Unit> function02 = function0;
        function0 = new Function0<Unit>(this, chatMessage){
            final /* synthetic */ ChatViewModel this$0;
            final /* synthetic */ ChatMessage $message;
            {
                this.this$0 = chatViewModel2;
                this.$message = chatMessage;
                super(0);
            }

            public final void invoke() {
                ChatViewModel.access$getRepo$p(this.this$0).deleteMessage(this.$message);
            }
        };
        BaseViewModel.completableCallFromAction$default(chatViewModel2, mutableLiveData, (Function0)function02, null, null, null, 28, null);
    }

    public final void messageRead(@NotNull List<ChatMessage> object) {
        Object var2_2;
        block2: {
            Iterator iterator = object;
            Intrinsics.checkNotNullParameter((Object)iterator, (String)"messages");
            object = iterator.iterator();
            while (object.hasNext()) {
                Object t = object.next();
                var2_2 = t;
                if (!(((ChatMessage)t).getStatus() == ChatMessageStatus.Success)) continue;
                break block2;
            }
            var2_2 = null;
        }
        object = var2_2;
        if (object != null) {
            this.repo.messageRead((ChatMessage)object);
        }
    }

    public final boolean isMuted() {
        ChatViewModel chatViewModel2 = session;
        Session session = chatViewModel2.session;
        String string2 = chatViewModel2.chatId;
        if (string2 != null) {
            return session.isTopicMuted(string2);
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"chatId");
        throw null;
    }

    public final void setMuted(boolean bl) {
        ChatViewModel chatViewModel2 = session;
        Session session = chatViewModel2.session;
        String string2 = chatViewModel2.chatId;
        if (string2 != null) {
            session.setTopicMuted(bl, string2);
            return;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"chatId");
        throw null;
    }

    public final void hideParticipantsLayout() {
        this.viewEventsChannel.offer((Object)HideParticipantsOverlay.INSTANCE);
    }
}

