/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.messaging;

import androidx.room.Embedded;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatType;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0081\b\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0018\u001a\u00020\u0006\u0012\u0006\u0010\u0019\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u001a\u001a\u00020\n\u0012\b\b\u0002\u0010\u001b\u001a\u00020\n\u0012\b\b\u0002\u0010\u001c\u001a\u00020\n\u0012\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u001f\u001a\u00020\u0003\u0012\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\bL\u0010MJ\u001a\u0010\u0004\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0007\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\bJ\u0010\u0010\u000b\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\fJ\u0010\u0010\u000e\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017Jp\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0018\u001a\u00020\u00062\b\b\u0002\u0010\u0019\u001a\u00020\u00062\b\b\u0002\u0010\u001a\u001a\u00020\n2\b\b\u0002\u0010\u001b\u001a\u00020\n2\b\b\u0002\u0010\u001c\u001a\u00020\n2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u001f\u001a\u00020\u00032\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0015H\u00c6\u0001\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010#\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b#\u0010\bJ\u0010\u0010$\u001a\u00020\nH\u00d6\u0001\u00a2\u0006\u0004\b$\u0010\fR\u0013\u0010%\u001a\u00020\u00038F@\u0006\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0014R\u001c\u0010\u0018\u001a\u00020\u00068\u0006@\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010&\u001a\u0004\b'\u0010\bR(\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R$\u00100\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b0\u0010&\u001a\u0004\b1\u0010\b\"\u0004\b2\u00103R\u0019\u0010\u0019\u001a\u00020\u00068\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010&\u001a\u0004\b4\u0010\bR\"\u0010\u001a\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u00105\u001a\u0004\b6\u0010\f\"\u0004\b7\u00108R\u0019\u0010\u001f\u001a\u00020\u00038\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001f\u00109\u001a\u0004\b\u001f\u0010\u0014R\u0013\u0010=\u001a\u00020:8F@\u0006\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u001b\u0010\u001d\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010>\u001a\u0004\b?\u0010\u0011R$\u0010A\u001a\u0004\u0018\u00010@8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bA\u0010B\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u001e\u0010 \u001a\u0004\u0018\u00010\u00158\u0006@\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b \u0010G\u001a\u0004\bH\u0010\u0017R\u001b\u0010\u001e\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010>\u001a\u0004\bI\u0010\u0011R\u0019\u0010\u001c\u001a\u00020\n8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001c\u00105\u001a\u0004\bJ\u0010\fR\u0019\u0010\u001b\u001a\u00020\n8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001b\u00105\u001a\u0004\bK\u0010\f\u00a8\u0006N"}, d2={"Lio/streamlayer/sdk/model/messaging/Topic;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "component1", "()Ljava/lang/String;", "component2", "", "component3", "()I", "component4", "component5", "Ljava/util/Date;", "component6", "()Ljava/util/Date;", "component7", "component8", "()Z", "Lio/streamlayer/sdk/model/messaging/Access;", "component9", "()Lio/streamlayer/sdk/model/messaging/Access;", "chatId", "name", "seq", "readSeq", "recvSeq", "updatedAt", "touchedAt", "isWPTopic", "access", "copy", "(Ljava/lang/String;Ljava/lang/String;IIILjava/util/Date;Ljava/util/Date;ZLio/streamlayer/sdk/model/messaging/Access;)Lio/streamlayer/sdk/model/messaging/Topic;", "toString", "hashCode", "isOwner", "Ljava/lang/String;", "getChatId", "", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "participants", "Ljava/util/List;", "getParticipants", "()Ljava/util/List;", "setParticipants", "(Ljava/util/List;)V", "watchPartyStreamId", "getWatchPartyStreamId", "setWatchPartyStreamId", "(Ljava/lang/String;)V", "getName", "I", "getSeq", "setSeq", "(I)V", "Z", "Lio/streamlayer/sdk/model/messaging/ChatType;", "getChatType", "()Lio/streamlayer/sdk/model/messaging/ChatType;", "chatType", "Ljava/util/Date;", "getUpdatedAt", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "lastMessage", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "getLastMessage", "()Lio/streamlayer/sdk/model/messaging/ChatMessage;", "setLastMessage", "(Lio/streamlayer/sdk/model/messaging/ChatMessage;)V", "Lio/streamlayer/sdk/model/messaging/Access;", "getAccess", "getTouchedAt", "getRecvSeq", "getReadSeq", "<init>", "(Ljava/lang/String;Ljava/lang/String;IIILjava/util/Date;Ljava/util/Date;ZLio/streamlayer/sdk/model/messaging/Access;)V", "sdk_originalRelease"})
@Entity
public final class Topic {
    @PrimaryKey
    @NotNull
    private final String chatId;
    @NotNull
    private final String name;
    private int seq;
    private final int readSeq;
    private final int recvSeq;
    @Nullable
    private final Date updatedAt;
    @Nullable
    private final Date touchedAt;
    private final boolean isWPTopic;
    @Embedded
    @Nullable
    private final Access access;
    @Nullable
    private String watchPartyStreamId;
    @Ignore
    @NotNull
    private List<TinodeContact> participants;
    @Ignore
    @Nullable
    private ChatMessage lastMessage;

    public Topic(@NotNull String string2, @NotNull String string3, int n, int n2, int n3, @Nullable Date date, @Nullable Date date2, boolean bl, @Nullable Access access) {
        Topic topic = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"name");
        this.chatId = string2;
        this.name = string3;
        this.seq = n;
        this.readSeq = n2;
        this.recvSeq = n3;
        this.updatedAt = date;
        this.touchedAt = date2;
        this.isWPTopic = bl;
        topic.access = access;
        topic.participants = CollectionsKt.emptyList();
    }

    public /* synthetic */ Topic(String string2, String string3, int n, int n2, int n3, Date date, Date date2, boolean bl, Access access, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x20) != 0) {
            date = null;
        }
        if ((n4 & 0x40) != 0) {
            date2 = null;
        }
        if ((n4 & 0x100) != 0) {
            access = null;
        }
        this(string2, string3, n, n2, n3, date, date2, bl, access);
    }

    public static /* synthetic */ Topic copy$default(Topic topic, String string2, String string3, int n, int n2, int n3, Date date, Date date2, boolean bl, Access access, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string2 = topic.chatId;
        }
        if ((n4 & 2) != 0) {
            string3 = topic.name;
        }
        if ((n4 & 4) != 0) {
            n = topic.seq;
        }
        if ((n4 & 8) != 0) {
            n2 = topic.readSeq;
        }
        if ((n4 & 0x10) != 0) {
            n3 = topic.recvSeq;
        }
        if ((n4 & 0x20) != 0) {
            date = topic.updatedAt;
        }
        if ((n4 & 0x40) != 0) {
            date2 = topic.touchedAt;
        }
        if ((n4 & 0x80) != 0) {
            bl = topic.isWPTopic;
        }
        if ((n4 & 0x100) != 0) {
            access = topic.access;
        }
        return topic.copy(string2, string3, n, n2, n3, date, date2, bl, access);
    }

    @NotNull
    public final String getChatId() {
        return this.chatId;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getSeq() {
        return this.seq;
    }

    public final void setSeq(int n) {
        this.seq = n;
    }

    public final int getReadSeq() {
        return this.readSeq;
    }

    public final int getRecvSeq() {
        return this.recvSeq;
    }

    @Nullable
    public final Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Nullable
    public final Date getTouchedAt() {
        return this.touchedAt;
    }

    public final boolean isWPTopic() {
        return this.isWPTopic;
    }

    @Nullable
    public final Access getAccess() {
        return this.access;
    }

    @Nullable
    public final String getWatchPartyStreamId() {
        return this.watchPartyStreamId;
    }

    public final void setWatchPartyStreamId(@Nullable String string2) {
        this.watchPartyStreamId = string2;
    }

    @NotNull
    public final ChatType getChatType() {
        return StringsKt.startsWith$default((String)this.chatId, (String)"usr", (boolean)false, (int)2, null) ? ChatType.P2P : (StringsKt.startsWith$default((String)this.chatId, (String)"grp", (boolean)false, (int)2, null) ? ChatType.Group : ChatType.Unknown);
    }

    public final boolean isOwner() {
        Access access = ((Topic)((Object)access)).access;
        return Intrinsics.areEqual(access == null ? null : Boolean.valueOf(StringsKt.contains$default((CharSequence)access.getGiven(), (CharSequence)"O", (boolean)false, (int)2, null)), (Object)Boolean.TRUE);
    }

    @NotNull
    public final List<TinodeContact> getParticipants() {
        return this.participants;
    }

    public final void setParticipants(@NotNull List<TinodeContact> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.participants = list;
    }

    @Nullable
    public final ChatMessage getLastMessage() {
        return this.lastMessage;
    }

    public final void setLastMessage(@Nullable ChatMessage chatMessage) {
        this.lastMessage = chatMessage;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object object) {
        void var1_10;
        void var0_4;
        void var1_5;
        if (!(var1_5 instanceof Topic)) return false;
        Topic topic = (Topic)var1_5;
        if (!Intrinsics.areEqual((Object)this.name, (Object)topic.name)) return false;
        if (!Intrinsics.areEqual((Object)this.chatId, (Object)topic.chatId)) return false;
        if (this.seq != topic.seq) return false;
        if (this.readSeq != topic.readSeq) return false;
        if (this.recvSeq != topic.recvSeq) return false;
        Object object2 = this.lastMessage;
        object2 = object2 == null ? null : Integer.valueOf(((ChatMessage)object2).getSeqId());
        Object object3 = topic.lastMessage;
        object3 = object3 == null ? null : Integer.valueOf(((ChatMessage)object3).getSeqId());
        if (!Intrinsics.areEqual((Object)object2, (Object)object3)) return false;
        ChatMessage chatMessage = this.lastMessage;
        if (chatMessage == null) {
            Object var0_2 = null;
        } else {
            ChatMessageStatus chatMessageStatus = chatMessage.getStatus();
        }
        ChatMessage chatMessage2 = topic.lastMessage;
        if (chatMessage2 == null) {
            Object var1_8 = null;
        } else {
            ChatMessageStatus chatMessageStatus = chatMessage2.getStatus();
        }
        if (var0_4 != var1_10) return false;
        return true;
    }

    @NotNull
    public final String component1() {
        return this.chatId;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    public final int component3() {
        return this.seq;
    }

    public final int component4() {
        return this.readSeq;
    }

    public final int component5() {
        return this.recvSeq;
    }

    @Nullable
    public final Date component6() {
        return this.updatedAt;
    }

    @Nullable
    public final Date component7() {
        return this.touchedAt;
    }

    public final boolean component8() {
        return this.isWPTopic;
    }

    @Nullable
    public final Access component9() {
        return this.access;
    }

    @NotNull
    public final Topic copy(@NotNull String string2, @NotNull String string3, int n, int n2, int n3, @Nullable Date date, @Nullable Date date2, boolean bl, @Nullable Access access) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"name");
        return new Topic(string2, string3, n, n2, n3, date, date2, bl, access);
    }

    @NotNull
    public String toString() {
        return "Topic(chatId=" + this.chatId + ", name=" + this.name + ", seq=" + this.seq + ", readSeq=" + this.readSeq + ", recvSeq=" + this.recvSeq + ", updatedAt=" + this.updatedAt + ", touchedAt=" + this.touchedAt + ", isWPTopic=" + this.isWPTopic + ", access=" + this.access + ')';
    }

    public int hashCode() {
        Topic topic = this;
        int n = ((((topic.chatId.hashCode() * 31 + this.name.hashCode()) * 31 + Integer.hashCode(this.seq)) * 31 + Integer.hashCode(this.readSeq)) * 31 + Integer.hashCode(this.recvSeq)) * 31;
        Date date = topic.updatedAt;
        int n2 = date == null ? 0 : date.hashCode();
        n = (n + n2) * 31;
        Date date2 = this.touchedAt;
        int n3 = date2 == null ? 0 : date2.hashCode();
        n = (n + n3) * 31;
        boolean bl = this.isWPTopic;
        n3 = bl ? 1 : 0;
        if (bl) {
            n3 = 1;
        }
        int n4 = (n + n3) * 31;
        Access access = this.access;
        int n5 = access == null ? 0 : access.hashCode();
        return n4 + n5;
    }
}

