/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.grpc;

import android.content.Context;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.android.AndroidChannelBuilder;
import io.streamlayer.common.data.grpc.GrpcInterceptor;
import io.streamlayer.common.session.Session;
import io.streamlayer.sdk.model.sdksettings.OrganizationSettings;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0016\u0010\u0006\u001a\u00020\u00058\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0016\u0010\t\u001a\u00020\b8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0018\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0013\u0010\u0010\u001a\u00020\u000b8F@\u0006\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0012\u001a\u00020\u00118\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lio/streamlayer/common/data/grpc/ChatGrpcService;", "", "", "shutDownChannel", "()V", "Lio/streamlayer/common/session/Session;", "session", "Lio/streamlayer/common/session/Session;", "Landroid/content/Context;", "context", "Landroid/content/Context;", "Lio/grpc/ManagedChannel;", "_managedChannel", "Lio/grpc/ManagedChannel;", "getManagedChannel", "()Lio/grpc/ManagedChannel;", "managedChannel", "Lio/streamlayer/common/data/grpc/GrpcInterceptor;", "interceptor", "Lio/streamlayer/common/data/grpc/GrpcInterceptor;", "<init>", "(Lio/streamlayer/common/data/grpc/GrpcInterceptor;Lio/streamlayer/common/session/Session;Landroid/content/Context;)V", "sdk_originalRelease"})
public final class ChatGrpcService {
    @NotNull
    private final GrpcInterceptor interceptor;
    @NotNull
    private final Session session;
    @NotNull
    private final Context context;
    @Nullable
    private ManagedChannel _managedChannel;

    public ChatGrpcService(@NotNull GrpcInterceptor grpcInterceptor, @NotNull Session session, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)grpcInterceptor, (String)"interceptor");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.interceptor = grpcInterceptor;
        this.session = session;
        this.context = context;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final ManagedChannel getManagedChannel() {
        void var1_6;
        ManagedChannel managedChannel2 = this._managedChannel;
        if (managedChannel2 == null) {
            OrganizationSettings organizationSettings = this.session.getOrganizationSettings();
            if (organizationSettings == null) throw new RuntimeException("Organization Settings null");
            String string = organizationSettings.getTinodeHost();
            if (string == null) throw new RuntimeException("Tinode host null");
            int n = 443;
            if (StringsKt.contains$default((CharSequence)organizationSettings.getTinodeHost(), (CharSequence)":", (boolean)false, (int)2, null)) {
                List list = StringsKt.split$default((CharSequence)organizationSettings.getTinodeHost(), (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                string = (String)list.get(0);
                n = Integer.parseInt((String)list.get(1));
            }
            TimeUnit timeUnit2 = TimeUnit.SECONDS;
            timeUnit2 = TimeUnit.HOURS;
            ManagedChannel managedChannel3 = ((AndroidChannelBuilder)((AndroidChannelBuilder)((AndroidChannelBuilder)((AndroidChannelBuilder)((AndroidChannelBuilder)((AndroidChannelBuilder)AndroidChannelBuilder.forAddress((String)string, (int)n).context(this.context).keepAliveWithoutCalls(true)).keepAliveTime(5L, timeUnit)).keepAliveTimeout(10L, timeUnit)).idleTimeout(24L, timeUnit2)).intercept(new ClientInterceptor[]{this.interceptor})).enableRetry()).build();
            Intrinsics.checkNotNullExpressionValue((Object)managedChannel3, (String)"run {\n                val organizationSettings: OrganizationSettings =\n                    session.getOrganizationSettings() ?: throw RuntimeException(\"Organization Settings null\")\n                var host: String = organizationSettings.tinodeHost ?: throw RuntimeException(\"Tinode host null\")\n                var port = 443\n                if (organizationSettings.tinodeHost.contains(\":\")) {\n                    val split = organizationSettings.tinodeHost.split(\":\")\n                    host = split[0]\n                    port = split[1].toInt()\n                }\n                AndroidChannelBuilder\n                    .forAddress(host, port)\n                    .context(context)\n                    .keepAliveWithoutCalls(true)\n                    .keepAliveTime(5, TimeUnit.SECONDS)\n                    .keepAliveTimeout(10, TimeUnit.SECONDS)\n                    .idleTimeout(24, TimeUnit.HOURS)\n                    .intercept(interceptor)\n                    .enableRetry()\n                    .build()\n            }");
        }
        this._managedChannel = var1_6;
        return var1_6;
    }

    public final void shutDownChannel() {
        ManagedChannel managedChannel2 = this._managedChannel;
        if (managedChannel2 != null) {
            managedChannel2.shutdown();
        }
        this._managedChannel = null;
    }
}

