/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.identifier;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\b\u0007\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0004J\r\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0004R\u0016\u0010\b\u001a\u00020\u00078\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lio/streamlayer/common/data/identifier/DeviceInfoManager;", "", "", "getId", "()Ljava/lang/String;", "getOsVersion", "getName", "Landroid/content/SharedPreferences;", "prefs", "Landroid/content/SharedPreferences;", "Landroid/content/Context;", "context", "<init>", "(Landroid/content/Context;)V", "Companion", "sdk_originalRelease"})
public final class DeviceInfoManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String KEY_DEVICE_UUID = "device_uuid";
    @NotNull
    private static final String ANDROID_OS = "android";
    @NotNull
    private static final String UNKNOWN = "Unknown";
    @NotNull
    private final SharedPreferences prefs;

    @Inject
    public DeviceInfoManager(@NotNull Context context) {
        DeviceInfoManager deviceInfoManager = deviceInfoManager2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DeviceInfoManager deviceInfoManager2 = context.getSharedPreferences("io.streamlayer.sdk_device_id", 0);
        Intrinsics.checkNotNullExpressionValue((Object)deviceInfoManager2, (String)"context.getSharedPreferences(BuildConfig.LIBRARY_PACKAGE_NAME + \"_device_id\", Context.MODE_PRIVATE)");
        deviceInfoManager.prefs = deviceInfoManager2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final String getId() {
        String string = this.prefs.getString(KEY_DEVICE_UUID, null);
        if (string != null) return string;
        DeviceInfoManager deviceInfoManager = this;
        synchronized (deviceInfoManager) {
            string = deviceInfoManager.prefs.getString(KEY_DEVICE_UUID, null);
            if (string != null) return string;
            DeviceInfoManager deviceInfoManager2 = this;
            string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
            deviceInfoManager2.prefs.edit().putString(KEY_DEVICE_UUID, string).apply();
            // ** MonitorExit[this] (shouldn't be in output)
            return string;
        }
    }

    @NotNull
    public final String getOsVersion() {
        return Intrinsics.stringPlus((String)"android ", (Object)Build.VERSION.RELEASE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final String getName() {
        Object object = Build.MANUFACTURER;
        if (object == null) {
            return UNKNOWN;
        }
        object = new StringBuilder().append((String)object).append('/');
        String string = Build.MODEL;
        if (string == null) {
            string = UNKNOWN;
        }
        if ((object = ((StringBuilder)object).append(string).toString()) != null) return object;
        return UNKNOWN;
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0016\u0010\u0005\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0004R\u0016\u0010\u0006\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0004\u00a8\u0006\t"}, d2={"Lio/streamlayer/common/data/identifier/DeviceInfoManager$Companion;", "", "", "ANDROID_OS", "Ljava/lang/String;", "KEY_DEVICE_UUID", "UNKNOWN", "<init>", "()V", "sdk_originalRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

