/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.calls.call.view.minified.texture;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.TextureView;
import io.streamlayer.sdk.calls.call.view.minified.texture.TextureEglRenderer;
import io.streamlayer.utils.SLRLog;
import org.webrtc.EglBase;
import org.webrtc.EglRenderer;
import org.webrtc.GlRectDrawer;
import org.webrtc.RendererCommon;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

public class TextureViewRenderer
extends TextureView
implements VideoSink,
RendererCommon.RendererEvents {
    private static final String TAG = "TextureViewRenderer";
    private final String resourceName;
    private final RendererCommon.VideoLayoutMeasure videoLayoutMeasure;
    private final TextureEglRenderer eglRenderer;
    private RendererCommon.RendererEvents rendererEvents;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;

    public TextureViewRenderer(Context object) {
        TextureEglRenderer textureEglRenderer;
        RendererCommon.VideoLayoutMeasure videoLayoutMeasure;
        TextureViewRenderer textureViewRenderer = object2;
        super(object);
        Object object2 = videoLayoutMeasure;
        videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
        textureViewRenderer.videoLayoutMeasure = object2;
        object2 = textureViewRenderer.getResourceName();
        textureViewRenderer.resourceName = object2;
        object = textureEglRenderer;
        textureEglRenderer = new TextureEglRenderer((String)object2);
        textureViewRenderer.eglRenderer = object;
        textureViewRenderer.setSurfaceTextureListener((TextureView.SurfaceTextureListener)object);
    }

    public TextureViewRenderer(Context object, AttributeSet attributeSet) {
        TextureEglRenderer textureEglRenderer;
        RendererCommon.VideoLayoutMeasure videoLayoutMeasure;
        TextureViewRenderer textureViewRenderer = object2;
        super(object, attributeSet);
        Object object2 = videoLayoutMeasure;
        videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
        textureViewRenderer.videoLayoutMeasure = object2;
        object2 = textureViewRenderer.getResourceName();
        textureViewRenderer.resourceName = object2;
        object = textureEglRenderer;
        textureEglRenderer = new TextureEglRenderer((String)object2);
        textureViewRenderer.eglRenderer = object;
        textureViewRenderer.setSurfaceTextureListener((TextureView.SurfaceTextureListener)object);
    }

    private String getResourceName() {
        try {
            return this.getResources().getResourceEntryName(this.getId()) + ": ";
        }
        catch (Resources.NotFoundException notFoundException) {
            return "";
        }
    }

    private void logD(String string2) {
        SLRLog.INSTANCE.d(TAG, this.resourceName + string2);
    }

    private void postOrRun(Runnable runnable) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            this.post(runnable);
        }
    }

    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents) {
        GlRectDrawer glRectDrawer;
        TextureViewRenderer textureViewRenderer = object;
        Object object = EglBase.CONFIG_PLAIN;
        GlRectDrawer glRectDrawer2 = glRectDrawer;
        glRectDrawer = new GlRectDrawer();
        textureViewRenderer.init(context, rendererEvents, (int[])object, (RendererCommon.GlDrawer)glRectDrawer2);
    }

    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = rendererEvents;
        this.rotatedFrameWidth = 0;
        this.rotatedFrameHeight = 0;
        this.eglRenderer.init(context, this, nArray, glDrawer);
    }

    public void release() {
        this.eglRenderer.release();
    }

    public void addFrameListener(EglRenderer.FrameListener frameListener, float f, RendererCommon.GlDrawer glDrawer) {
        this.eglRenderer.addFrameListener(frameListener, f, glDrawer);
    }

    public void addFrameListener(EglRenderer.FrameListener frameListener, float f) {
        this.eglRenderer.addFrameListener(frameListener, f);
    }

    public void removeFrameListener(EglRenderer.FrameListener frameListener) {
        this.eglRenderer.removeFrameListener(frameListener);
    }

    public void setMirror(boolean bl) {
        this.eglRenderer.setMirror(bl);
    }

    public void setScalingType(RendererCommon.ScalingType scalingType) {
        TextureViewRenderer textureViewRenderer = this;
        ThreadUtils.checkIsOnMainThread();
        textureViewRenderer.videoLayoutMeasure.setScalingType(scalingType);
        textureViewRenderer.requestLayout();
    }

    public void setScalingType(RendererCommon.ScalingType scalingType, RendererCommon.ScalingType scalingType2) {
        TextureViewRenderer textureViewRenderer = this;
        ThreadUtils.checkIsOnMainThread();
        textureViewRenderer.videoLayoutMeasure.setScalingType(scalingType, scalingType2);
        textureViewRenderer.requestLayout();
    }

    public void setFpsReduction(float f) {
        this.eglRenderer.setFpsReduction(f);
    }

    public void disableFpsReduction() {
        this.eglRenderer.disableFpsReduction();
    }

    public void pauseVideo() {
        this.eglRenderer.pauseVideo();
    }

    public void onFrame(VideoFrame videoFrame) {
        this.eglRenderer.onFrame(videoFrame);
    }

    protected void onMeasure(int n, int n2) {
        TextureViewRenderer textureViewRenderer = this;
        ThreadUtils.checkIsOnMainThread();
        int n3 = n;
        TextureViewRenderer textureViewRenderer2 = this;
        int n4 = textureViewRenderer2.rotatedFrameWidth;
        n = textureViewRenderer2.rotatedFrameHeight;
        Point point = textureViewRenderer.videoLayoutMeasure.measure(n3, n2, n4, n);
        n = point.x;
        textureViewRenderer.setMeasuredDimension(n, point.y);
        textureViewRenderer.logD("onMeasure(). New size: " + point.x + "x" + point.y);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.setLayoutAspectRatio((float)(n3 - n) / (float)(n4 - n2));
    }

    public void clearImage() {
        this.eglRenderer.clearImage();
    }

    public void onFirstFrameRendered() {
        TextureViewRenderer textureViewRenderer = textureViewRenderer.rendererEvents;
        if (textureViewRenderer != null) {
            textureViewRenderer.onFirstFrameRendered();
        }
    }

    public void onFrameResolutionChanged(int n, int n2, int n3) {
        RendererCommon.RendererEvents rendererEvents = this.rendererEvents;
        if (rendererEvents != null) {
            rendererEvents.onFrameResolutionChanged(n, n2, n3);
        }
        int n4 = n3 != 0 && n3 != 180 ? n2 : n;
        if (n3 != 0 && n3 != 180) {
            n2 = n;
        }
        TextureViewRenderer textureViewRenderer = this;
        textureViewRenderer.postOrRun(() -> {
            this.rotatedFrameWidth = n4;
            this.rotatedFrameHeight = n2;
            this.requestLayout();
        });
    }
}

