/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.messaging.chats;

import android.content.Context;
import android.graphics.Typeface;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.textview.MaterialTextView;
import io.streamlayer.common.recyclerview.GenericAdapter;
import io.streamlayer.common.views.SLRNotificationBadge;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.messaging.chats.Chat;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J!\u0010\u0006\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\n\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lio/streamlayer/sdk/messaging/chats/MessagingChatsAdapter;", "Lio/streamlayer/common/recyclerview/GenericAdapter;", "Lio/streamlayer/sdk/messaging/chats/Chat;", "Lkotlin/Function1;", "", "listener", "setOnChatSelectedListener", "(Lkotlin/jvm/functions/Function1;)V", "", "listItems", "setItems", "(Ljava/util/List;)V", "", "viewType", "getLayoutId", "(I)I", "Landroid/view/View;", "view", "Lio/streamlayer/common/recyclerview/GenericAdapter$GenericViewHolder;", "getViewHolder", "(Landroid/view/View;I)Lio/streamlayer/common/recyclerview/GenericAdapter$GenericViewHolder;", "onChatSelectedListener", "Lkotlin/jvm/functions/Function1;", "<init>", "()V", "ChatsDiffCallback", "ViewHolder", "sdk_originalRelease"})
public final class MessagingChatsAdapter
extends GenericAdapter<Chat> {
    @Nullable
    private Function1<? super Chat, Unit> onChatSelectedListener;

    public final void setOnChatSelectedListener(@NotNull Function1<? super Chat, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"listener");
        this.onChatSelectedListener = function1;
    }

    @Override
    public void setItems(@NotNull List<Chat> list) {
        Intrinsics.checkNotNullParameter(list, (String)"listItems");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new ChatsDiffCallback(this.getListItems(), list));
        MessagingChatsAdapter messagingChatsAdapter = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(ChatsDiffCallback(this.listItems, listItems))");
        messagingChatsAdapter.getListItems().clear();
        messagingChatsAdapter.getListItems().addAll(list);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)messagingChatsAdapter);
    }

    @Override
    protected int getLayoutId(int n) {
        return R.layout.slr_item_messaging_chat;
    }

    @Override
    @NotNull
    protected GenericAdapter.GenericViewHolder<Chat> getViewHolder(@NotNull View view2, int n) {
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        return new ViewHolder(this, view2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lio/streamlayer/sdk/messaging/chats/MessagingChatsAdapter$ViewHolder;", "Lio/streamlayer/common/recyclerview/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/messaging/chats/Chat;", "data", "", "bind", "(Lio/streamlayer/sdk/messaging/chats/Chat;)V", "Landroid/view/View;", "itemView", "<init>", "(Lio/streamlayer/sdk/messaging/chats/MessagingChatsAdapter;Landroid/view/View;)V", "sdk_originalRelease"})
    public final class ViewHolder
    extends GenericAdapter.GenericViewHolder<Chat> {
        final /* synthetic */ MessagingChatsAdapter this$0;

        public ViewHolder(@NotNull MessagingChatsAdapter messagingChatsAdapter, View view2) {
            ViewHolder viewHolder = this;
            Intrinsics.checkNotNullParameter((Object)((Object)messagingChatsAdapter), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            this.this$0 = messagingChatsAdapter;
            super(view2);
            view2.setOnClickListener(arg_0 -> ViewHolder._init_$lambda-0(messagingChatsAdapter, viewHolder, arg_0));
        }

        private static final void _init_$lambda-0(MessagingChatsAdapter messagingChatsAdapter, ViewHolder viewHolder, View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)messagingChatsAdapter), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"this$1");
            view2 = messagingChatsAdapter.onChatSelectedListener;
            if (view2 != null) {
                view2.invoke(messagingChatsAdapter.getItem(viewHolder.getLayoutPosition()));
            }
        }

        @Override
        public void bind(@NotNull Chat chat) {
            Intrinsics.checkNotNullParameter((Object)chat, (String)"data");
            AppCompatImageView appCompatImageView = (AppCompatImageView)viewHolder.itemView.findViewById(R.id.chatAvatar);
            String string2 = chat.getChatAvatar();
            if (!(string2 == null || string2.length() == 0)) {
                ((AppCompatImageView)viewHolder.itemView.findViewById(R.id.chatAvatar)).setBackground(null);
                if (StringsKt.contains$default((CharSequence)chat.getChatAvatar(), (CharSequence)"http", (boolean)false, (int)2, null)) {
                    Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"");
                    ProfileExtensionsKt.loadUserAvatar$default((ImageView)appCompatImageView, chat.getChatAvatar(), null, null, 4, null);
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"");
                    ProfileExtensionsKt.loadUserAvatar$default((ImageView)appCompatImageView, null, chat.getChatAvatar(), null, 4, null);
                }
            } else {
                appCompatImageView.setBackgroundResource(R.drawable.slr_shape_circle);
                appCompatImageView.setImageResource(chat.getChatResId());
            }
            ViewHolder viewHolder = viewHolder.itemView;
            if (chat.isEmptyChat()) {
                ViewHolder viewHolder2 = viewHolder;
                ((MaterialTextView)viewHolder2.findViewById(R.id.chatName)).setText(R.string.slr_messaging_chat_await_friends);
                ((MaterialTextView)viewHolder2.findViewById(R.id.chatMessage)).setText(R.string.slr_messaging_chat_link_shared);
            } else {
                ViewHolder viewHolder3 = viewHolder;
                ((MaterialTextView)viewHolder3.findViewById(R.id.chatName)).setText((CharSequence)chat.getChatName());
                ((MaterialTextView)viewHolder3.findViewById(R.id.chatMessage)).setText((CharSequence)chat.getLastMessage());
            }
            ((MaterialTextView)viewHolder.findViewById(R.id.chatTime)).setText((CharSequence)chat.getChatTime());
            if (chat.getUnreadMessages() > 0) {
                ViewHolder viewHolder4 = viewHolder;
                ((SLRNotificationBadge)viewHolder4.findViewById(R.id.chatUnreadCount)).show(chat.getUnreadMessages());
                ((MaterialTextView)viewHolder4.findViewById(R.id.chatMessage)).setTypeface(Typeface.create((String)"sans-serif-medium", (int)0));
                ((MaterialTextView)viewHolder4.findViewById(R.id.chatMessage)).setTextColor(ContextCompat.getColor((Context)viewHolder.getContext(), (int)R.color.slr_white));
            } else {
                ViewHolder viewHolder5 = viewHolder;
                ((SLRNotificationBadge)viewHolder5.findViewById(R.id.chatUnreadCount)).hide();
                ((MaterialTextView)viewHolder5.findViewById(R.id.chatMessage)).setTypeface(Typeface.create((String)"sans-serif", (int)0));
                ((MaterialTextView)viewHolder5.findViewById(R.id.chatMessage)).setTextColor(ContextCompat.getColor((Context)viewHolder.getContext(), (int)R.color.slr_gray900));
            }
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\u001f\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0007R\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lio/streamlayer/sdk/messaging/chats/MessagingChatsAdapter$ChatsDiffCallback;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "", "oldItemPosition", "newItemPosition", "", "areItemsTheSame", "(II)Z", "getOldListSize", "()I", "getNewListSize", "areContentsTheSame", "", "Lio/streamlayer/sdk/messaging/chats/Chat;", "newItems", "Ljava/util/List;", "oldItems", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "sdk_originalRelease"})
    private static final class ChatsDiffCallback
    extends DiffUtil.Callback {
        @NotNull
        private final List<Chat> oldItems;
        @NotNull
        private final List<Chat> newItems;

        public ChatsDiffCallback(@NotNull List<Chat> list, @NotNull List<Chat> list2) {
            Intrinsics.checkNotNullParameter(list, (String)"oldItems");
            Intrinsics.checkNotNullParameter(list2, (String)"newItems");
            this.oldItems = list;
            this.newItems = list2;
        }

        public boolean areItemsTheSame(int n, int n2) {
            return Intrinsics.areEqual((Object)this.oldItems.get(n).getChatId(), (Object)this.newItems.get(n2).getChatId());
        }

        public int getOldListSize() {
            return this.oldItems.size();
        }

        public int getNewListSize() {
            return this.newItems.size();
        }

        public boolean areContentsTheSame(int n, int n2) {
            return Intrinsics.areEqual((Object)this.oldItems.get(n), (Object)this.newItems.get(n2));
        }
    }
}

