/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.sports;

import androidx.room.ColumnInfo;
import androidx.room.Embedded;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import io.streamlayer.sdk.model.sports.EventPeriod;
import io.streamlayer.sdk.model.sports.EventStatus;
import io.streamlayer.sdk.model.sports.EventTeam;
import io.streamlayer.sdk.model.sports.EventTime;
import io.streamlayer.utils.DateUtil;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0081\b\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u001a\u001a\u00020\u0002\u0012\u0006\u0010\u001b\u001a\u00020\u0005\u0012\u0006\u0010\u001c\u001a\u00020\u0005\u0012\u0006\u0010\u001d\u001a\u00020\t\u0012\u0006\u0010\u001e\u001a\u00020\t\u0012\u0006\u0010\u001f\u001a\u00020\r\u0012\u0006\u0010 \u001a\u00020\u0002\u0012\u0006\u0010!\u001a\u00020\u0002\u0012\u0006\u0010\"\u001a\u00020\u0012\u0012\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0006\u0010$\u001a\u00020\t\u00a2\u0006\u0004\bU\u0010VBg\b\u0016\u0012\u0006\u0010\u001a\u001a\u00020\u0002\u0012\u0006\u0010\u001b\u001a\u00020\u0005\u0012\u0006\u0010\u001c\u001a\u00020\u0005\u0012\u0006\u0010\u001d\u001a\u00020\t\u0012\u0006\u0010\u001e\u001a\u00020\t\u0012\u0006\u0010\u001f\u001a\u00020\r\u0012\u0006\u00108\u001a\u000207\u0012\u0006\u0010Q\u001a\u000207\u0012\u0006\u0010\"\u001a\u00020\u0012\u0012\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0006\u0010$\u001a\u00020\t\u00a2\u0006\u0004\bU\u0010WJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0007J\u0010\u0010\n\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\rH\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u0012H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u000bJ\u0084\u0001\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u001a\u001a\u00020\u00022\b\b\u0002\u0010\u001b\u001a\u00020\u00052\b\b\u0002\u0010\u001c\u001a\u00020\u00052\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u001e\u001a\u00020\t2\b\b\u0002\u0010\u001f\u001a\u00020\r2\b\b\u0002\u0010 \u001a\u00020\u00022\b\b\u0002\u0010!\u001a\u00020\u00022\b\b\u0002\u0010\"\u001a\u00020\u00122\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\b\u0002\u0010$\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010'\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b'\u0010\u0007J\u0010\u0010(\u001a\u00020\tH\u00d6\u0001\u00a2\u0006\u0004\b(\u0010\u000bJ\u001a\u0010+\u001a\u00020*2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b+\u0010,R\u0019\u0010\u001b\u001a\u00020\u00058\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010-\u001a\u0004\b.\u0010\u0007R\u0013\u00100\u001a\u00020\u00058F@\u0006\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0007R\u0019\u0010\u001e\u001a\u00020\t8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001e\u00101\u001a\u0004\b2\u0010\u000bR\u001c\u0010\u001f\u001a\u00020\r8\u0006@\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001f\u00103\u001a\u0004\b4\u0010\u000fR\u0019\u0010 \u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b \u00105\u001a\u0004\b6\u0010\u0004R\"\u00108\u001a\u0002078\u0006@\u0006X\u0087.\u00a2\u0006\u0012\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001c\u0010\u001a\u001a\u00020\u00028\u0006@\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001a\u00105\u001a\u0004\b>\u0010\u0004R\u0019\u0010\u001d\u001a\u00020\t8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001d\u00101\u001a\u0004\b?\u0010\u000bR\u0019\u0010!\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b!\u00105\u001a\u0004\b@\u0010\u0004R\"\u0010A\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u0012\n\u0004\bA\u0010-\u001a\u0004\bB\u0010\u0007\"\u0004\bC\u0010DR\"\u0010F\u001a\u00020E8\u0006@\u0006X\u0087.\u00a2\u0006\u0012\n\u0004\bF\u0010G\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u0019\u0010\u001c\u001a\u00020\u00058\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010-\u001a\u0004\bL\u0010\u0007R\u0019\u0010\"\u001a\u00020\u00128\u0006@\u0006\u00a2\u0006\f\n\u0004\b\"\u0010M\u001a\u0004\bN\u0010\u0014R\u001f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158\u0006@\u0006\u00a2\u0006\f\n\u0004\b#\u0010O\u001a\u0004\bP\u0010\u0018R\"\u0010Q\u001a\u0002078\u0006@\u0006X\u0087.\u00a2\u0006\u0012\n\u0004\bQ\u00109\u001a\u0004\bR\u0010;\"\u0004\bS\u0010=R\u0019\u0010$\u001a\u00020\t8\u0006@\u0006\u00a2\u0006\f\n\u0004\b$\u00101\u001a\u0004\bT\u0010\u000b\u00a8\u0006X"}, d2={"Lio/streamlayer/sdk/model/sports/EventSummary;", "", "", "component1", "()J", "", "component2", "()Ljava/lang/String;", "component3", "", "component4", "()I", "component5", "Lio/streamlayer/sdk/model/sports/EventTime;", "component6", "()Lio/streamlayer/sdk/model/sports/EventTime;", "component7", "component8", "Lio/streamlayer/sdk/model/sports/EventStatus;", "component9", "()Lio/streamlayer/sdk/model/sports/EventStatus;", "", "Lio/streamlayer/sdk/model/sports/EventPeriod;", "component10", "()Ljava/util/List;", "component11", "id", "scheduled", "league", "homeScore", "awayScore", "eventTime", "homeTeamId", "awayTeamId", "status", "periods", "periodsCount", "copy", "(JLjava/lang/String;Ljava/lang/String;IILio/streamlayer/sdk/model/sports/EventTime;JJLio/streamlayer/sdk/model/sports/EventStatus;Ljava/util/List;I)Lio/streamlayer/sdk/model/sports/EventSummary;", "toString", "hashCode", "other", "", "equals", "(Ljava/lang/Object;)Z", "Ljava/lang/String;", "getScheduled", "getShortGameInfo", "shortGameInfo", "I", "getAwayScore", "Lio/streamlayer/sdk/model/sports/EventTime;", "getEventTime", "J", "getHomeTeamId", "Lio/streamlayer/sdk/model/sports/EventTeam;", "homeTeam", "Lio/streamlayer/sdk/model/sports/EventTeam;", "getHomeTeam", "()Lio/streamlayer/sdk/model/sports/EventTeam;", "setHomeTeam", "(Lio/streamlayer/sdk/model/sports/EventTeam;)V", "getId", "getHomeScore", "getAwayTeamId", "scheduledDateString", "getScheduledDateString", "setScheduledDateString", "(Ljava/lang/String;)V", "Ljava/util/Date;", "scheduleDate", "Ljava/util/Date;", "getScheduleDate", "()Ljava/util/Date;", "setScheduleDate", "(Ljava/util/Date;)V", "getLeague", "Lio/streamlayer/sdk/model/sports/EventStatus;", "getStatus", "Ljava/util/List;", "getPeriods", "awayTeam", "getAwayTeam", "setAwayTeam", "getPeriodsCount", "<init>", "(JLjava/lang/String;Ljava/lang/String;IILio/streamlayer/sdk/model/sports/EventTime;JJLio/streamlayer/sdk/model/sports/EventStatus;Ljava/util/List;I)V", "(JLjava/lang/String;Ljava/lang/String;IILio/streamlayer/sdk/model/sports/EventTime;Lio/streamlayer/sdk/model/sports/EventTeam;Lio/streamlayer/sdk/model/sports/EventTeam;Lio/streamlayer/sdk/model/sports/EventStatus;Ljava/util/List;I)V", "sdk_originalRelease"})
@Entity
public final class EventSummary {
    @PrimaryKey
    @ColumnInfo(name="eventSummaryId")
    private final long id;
    @NotNull
    private final String scheduled;
    @NotNull
    private final String league;
    private final int homeScore;
    private final int awayScore;
    @Embedded
    @NotNull
    private final EventTime eventTime;
    private final long homeTeamId;
    private final long awayTeamId;
    @NotNull
    private final EventStatus status;
    @NotNull
    private final List<EventPeriod> periods;
    private final int periodsCount;
    @ColumnInfo(name="scheduleDateString")
    public String scheduledDateString;
    @ColumnInfo(name="scheduleDate")
    public Date scheduleDate;
    @Ignore
    public EventTeam homeTeam;
    @Ignore
    public EventTeam awayTeam;

    public EventSummary(long l, @NotNull String string2, @NotNull String string3, int n, int n2, @NotNull EventTime eventTime, long l2, long l3, @NotNull EventStatus eventStatus, @NotNull List<EventPeriod> list, int n3) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"scheduled");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"league");
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        Intrinsics.checkNotNullParameter((Object)((Object)eventStatus), (String)"status");
        Intrinsics.checkNotNullParameter(list, (String)"periods");
        this.id = l;
        this.scheduled = string2;
        this.league = string3;
        this.homeScore = n;
        this.awayScore = n2;
        this.eventTime = eventTime;
        this.homeTeamId = l2;
        this.awayTeamId = l3;
        this.status = eventStatus;
        this.periods = list;
        this.periodsCount = n3;
    }

    public EventSummary(long l, @NotNull String string2, @NotNull String string3, int n, int n2, @NotNull EventTime eventTime, @NotNull EventTeam eventTeam, @NotNull EventTeam eventTeam2, @NotNull EventStatus eventStatus, @NotNull List<EventPeriod> list, int n3) {
        EventSummary eventSummary = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"scheduled");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"league");
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        Intrinsics.checkNotNullParameter((Object)eventTeam, (String)"homeTeam");
        Intrinsics.checkNotNullParameter((Object)eventTeam2, (String)"awayTeam");
        Intrinsics.checkNotNullParameter((Object)((Object)eventStatus), (String)"status");
        Intrinsics.checkNotNullParameter(list, (String)"periods");
        long l2 = eventTeam.getId();
        long l3 = eventTeam2.getId();
        eventSummary(l, string2, string3, n, n2, eventTime, l2, l3, eventStatus, list, n3);
        eventSummary.setHomeTeam(eventTeam);
        eventSummary.setAwayTeam(eventTeam2);
        DateUtil dateUtil = DateUtil.INSTANCE;
        Date date = dateUtil.fromString(string2);
        if (date == null) {
            Date date2;
            date = date2;
            date2 = new Date(0L);
        }
        EventSummary eventSummary2 = this;
        eventSummary2.setScheduleDate(date);
        this.setScheduledDateString(dateUtil.toDateString(eventSummary2.getScheduleDate()));
    }

    public static /* synthetic */ EventSummary copy$default(EventSummary eventSummary, long l, String string2, String string3, int n, int n2, EventTime eventTime, long l2, long l3, EventStatus eventStatus, List list, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            l = eventSummary.id;
        }
        if ((n4 & 2) != 0) {
            string2 = eventSummary.scheduled;
        }
        if ((n4 & 4) != 0) {
            string3 = eventSummary.league;
        }
        if ((n4 & 8) != 0) {
            n = eventSummary.homeScore;
        }
        if ((n4 & 0x10) != 0) {
            n2 = eventSummary.awayScore;
        }
        if ((n4 & 0x20) != 0) {
            eventTime = eventSummary.eventTime;
        }
        if ((n4 & 0x40) != 0) {
            l2 = eventSummary.homeTeamId;
        }
        if ((n4 & 0x80) != 0) {
            l3 = eventSummary.awayTeamId;
        }
        if ((n4 & 0x100) != 0) {
            eventStatus = eventSummary.status;
        }
        if ((n4 & 0x200) != 0) {
            list = eventSummary.periods;
        }
        if ((n4 & 0x400) != 0) {
            n3 = eventSummary.periodsCount;
        }
        return eventSummary.copy(l, string2, string3, n, n2, eventTime, l2, l3, eventStatus, list, n3);
    }

    public final long getId() {
        return this.id;
    }

    @NotNull
    public final String getScheduled() {
        return this.scheduled;
    }

    @NotNull
    public final String getLeague() {
        return this.league;
    }

    public final int getHomeScore() {
        return this.homeScore;
    }

    public final int getAwayScore() {
        return this.awayScore;
    }

    @NotNull
    public final EventTime getEventTime() {
        return this.eventTime;
    }

    public final long getHomeTeamId() {
        return this.homeTeamId;
    }

    public final long getAwayTeamId() {
        return this.awayTeamId;
    }

    @NotNull
    public final EventStatus getStatus() {
        return this.status;
    }

    @NotNull
    public final List<EventPeriod> getPeriods() {
        return this.periods;
    }

    public final int getPeriodsCount() {
        return this.periodsCount;
    }

    @NotNull
    public final String getScheduledDateString() {
        String string2 = ((EventSummary)((Object)string2)).scheduledDateString;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scheduledDateString");
        throw null;
    }

    public final void setScheduledDateString(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.scheduledDateString = string2;
    }

    @NotNull
    public final Date getScheduleDate() {
        Date date = ((EventSummary)((Object)date)).scheduleDate;
        if (date != null) {
            return date;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scheduleDate");
        throw null;
    }

    public final void setScheduleDate(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"<set-?>");
        this.scheduleDate = date;
    }

    @NotNull
    public final EventTeam getHomeTeam() {
        EventTeam eventTeam = ((EventSummary)((Object)eventTeam)).homeTeam;
        if (eventTeam != null) {
            return eventTeam;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"homeTeam");
        throw null;
    }

    public final void setHomeTeam(@NotNull EventTeam eventTeam) {
        Intrinsics.checkNotNullParameter((Object)eventTeam, (String)"<set-?>");
        this.homeTeam = eventTeam;
    }

    @NotNull
    public final EventTeam getAwayTeam() {
        EventTeam eventTeam = ((EventSummary)((Object)eventTeam)).awayTeam;
        if (eventTeam != null) {
            return eventTeam;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"awayTeam");
        throw null;
    }

    public final void setAwayTeam(@NotNull EventTeam eventTeam) {
        Intrinsics.checkNotNullParameter((Object)eventTeam, (String)"<set-?>");
        this.awayTeam = eventTeam;
    }

    @NotNull
    public final String getShortGameInfo() {
        String string2 = ((EventSummary)((Object)string2)).league + ' ' + ((EventSummary)((Object)string2)).getHomeTeam().getAlias() + " VS " + ((EventSummary)((Object)string2)).getAwayTeam().getAlias();
        if (string2 != null) {
            String string3 = string2.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
            return string3;
        }
        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
    }

    public final long component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.scheduled;
    }

    @NotNull
    public final String component3() {
        return this.league;
    }

    public final int component4() {
        return this.homeScore;
    }

    public final int component5() {
        return this.awayScore;
    }

    @NotNull
    public final EventTime component6() {
        return this.eventTime;
    }

    public final long component7() {
        return this.homeTeamId;
    }

    public final long component8() {
        return this.awayTeamId;
    }

    @NotNull
    public final EventStatus component9() {
        return this.status;
    }

    @NotNull
    public final List<EventPeriod> component10() {
        return this.periods;
    }

    public final int component11() {
        return this.periodsCount;
    }

    @NotNull
    public final EventSummary copy(long l, @NotNull String string2, @NotNull String string3, int n, int n2, @NotNull EventTime eventTime, long l2, long l3, @NotNull EventStatus eventStatus, @NotNull List<EventPeriod> list, int n3) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"scheduled");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"league");
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        Intrinsics.checkNotNullParameter((Object)((Object)eventStatus), (String)"status");
        Intrinsics.checkNotNullParameter(list, (String)"periods");
        return new EventSummary(l, string2, string3, n, n2, eventTime, l2, l3, eventStatus, list, n3);
    }

    @NotNull
    public String toString() {
        return "EventSummary(id=" + this.id + ", scheduled=" + this.scheduled + ", league=" + this.league + ", homeScore=" + this.homeScore + ", awayScore=" + this.awayScore + ", eventTime=" + this.eventTime + ", homeTeamId=" + this.homeTeamId + ", awayTeamId=" + this.awayTeamId + ", status=" + (Object)((Object)this.status) + ", periods=" + this.periods + ", periodsCount=" + this.periodsCount + ')';
    }

    public int hashCode() {
        return (((((((((Long.hashCode(this.id) * 31 + this.scheduled.hashCode()) * 31 + this.league.hashCode()) * 31 + Integer.hashCode(this.homeScore)) * 31 + Integer.hashCode(this.awayScore)) * 31 + this.eventTime.hashCode()) * 31 + Long.hashCode(this.homeTeamId)) * 31 + Long.hashCode(this.awayTeamId)) * 31 + this.status.hashCode()) * 31 + ((Object)this.periods).hashCode()) * 31 + Integer.hashCode(this.periodsCount);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EventSummary)) {
            return false;
        }
        object = (EventSummary)object;
        if (this.id != ((EventSummary)object).id) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scheduled, (Object)((EventSummary)object).scheduled)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.league, (Object)((EventSummary)object).league)) {
            return false;
        }
        if (this.homeScore != ((EventSummary)object).homeScore) {
            return false;
        }
        if (this.awayScore != ((EventSummary)object).awayScore) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.eventTime, (Object)((EventSummary)object).eventTime)) {
            return false;
        }
        if (this.homeTeamId != ((EventSummary)object).homeTeamId) {
            return false;
        }
        if (this.awayTeamId != ((EventSummary)object).awayTeamId) {
            return false;
        }
        if (this.status != ((EventSummary)object).status) {
            return false;
        }
        if (!Intrinsics.areEqual(this.periods, ((EventSummary)object).periods)) {
            return false;
        }
        return this.periodsCount == ((EventSummary)object).periodsCount;
    }
}

