/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view.internal.media;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import io.streamlayer.common.media.MediaProvider;
import io.streamlayer.sdk.VideoPlayer;
import io.streamlayer.sdk.VideoPlayerProvider;
import io.streamlayer.sdk.VideoPlayerView;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideo;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideoComponent;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideoPlayerCache;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0007\u0012\u0006\u0010&\u001a\u00020%\u0012\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b(\u0010)J$\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0096\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000b\u001a\u00020\nH\u0096\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0003H\u0096\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u0016\u0010\fR\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010 \u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010\u000eR\u0016\u0010&\u001a\u00020%8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006*"}, d2={"Lio/streamlayer/sdk/twitter/view/internal/media/TweetPlayerViewModel;", "Landroidx/lifecycle/ViewModel;", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoPlayerCache;", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;", "video", "", "forceCreate", "Lio/streamlayer/sdk/VideoPlayer;", "getPlayer", "(Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;Z)Lio/streamlayer/sdk/VideoPlayer;", "", "release", "()V", "releasePlayer", "(Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;)V", "Landroid/content/Context;", "context", "Lio/streamlayer/sdk/VideoPlayerView$Type;", "type", "Lio/streamlayer/sdk/VideoPlayerView;", "getVideoPlayerView", "(Landroid/content/Context;Lio/streamlayer/sdk/VideoPlayerView$Type;)Lio/streamlayer/sdk/VideoPlayerView;", "onCleared", "Lio/streamlayer/common/media/MediaProvider;", "mediaProvider", "Lio/streamlayer/common/media/MediaProvider;", "releaseOnCleared", "Z", "getReleaseOnCleared", "()Z", "setReleaseOnCleared", "(Z)V", "tweetVideo", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;", "getTweetVideo", "()Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;", "setTweetVideo", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoComponent;", "tweetVideoComponent", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoComponent;", "<init>", "(Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoComponent;Lio/streamlayer/common/media/MediaProvider;)V", "sdk_originalRelease"})
public final class TweetPlayerViewModel
extends ViewModel
implements TweetVideoPlayerCache {
    @NotNull
    private final TweetVideoComponent tweetVideoComponent;
    @NotNull
    private MediaProvider mediaProvider;
    private boolean releaseOnCleared;
    @Nullable
    private TweetVideo tweetVideo;

    @Inject
    public TweetPlayerViewModel(@NotNull TweetVideoComponent tweetVideoComponent, @NotNull MediaProvider mediaProvider) {
        Intrinsics.checkNotNullParameter((Object)tweetVideoComponent, (String)"tweetVideoComponent");
        Intrinsics.checkNotNullParameter((Object)mediaProvider, (String)"mediaProvider");
        this.tweetVideoComponent = tweetVideoComponent;
        this.mediaProvider = mediaProvider;
        this.releaseOnCleared = true;
    }

    @Override
    @Nullable
    public VideoPlayer getPlayer(@NotNull TweetVideo tweetVideo, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)tweetVideo, (String)"video");
        return this.tweetVideoComponent.getPlayer(tweetVideo, bl);
    }

    @Override
    public void release() {
        this.tweetVideoComponent.release();
    }

    @Override
    public void releasePlayer(@NotNull TweetVideo tweetVideo) {
        Intrinsics.checkNotNullParameter((Object)tweetVideo, (String)"video");
        this.tweetVideoComponent.releasePlayer(tweetVideo);
    }

    public final boolean getReleaseOnCleared() {
        return this.releaseOnCleared;
    }

    public final void setReleaseOnCleared(boolean bl) {
        this.releaseOnCleared = bl;
    }

    @Nullable
    public final TweetVideo getTweetVideo() {
        return this.tweetVideo;
    }

    public final void setTweetVideo(@Nullable TweetVideo tweetVideo) {
        this.tweetVideo = tweetVideo;
    }

    @Nullable
    public final VideoPlayerView getVideoPlayerView(@NotNull Context context, @NotNull VideoPlayerView.Type type2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        VideoPlayerProvider videoPlayerProvider = ((TweetPlayerViewModel)((Object)videoPlayerProvider)).mediaProvider.getVideoPlayerProvider();
        return videoPlayerProvider == null ? null : videoPlayerProvider.getVideoPlayerView(context, type2);
    }

    protected void onCleared() {
        TweetPlayerViewModel tweetPlayerViewModel = this;
        super.onCleared();
        if (tweetPlayerViewModel.releaseOnCleared) {
            this.release();
        }
    }
}

