/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.utils;

import android.content.Context;
import android.view.View;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.viewbinding.ViewBinding;
import io.streamlayer.utils.FragmentViewBindingDelegate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a'\u0010\u0005\u001a\u00020\u0004*\u00020\u00002\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001\"\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001b\u0010\t\u001a\u00020\b*\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a7\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010\"\b\b\u0000\u0010\f*\u00020\u000b*\u00020\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000\rH\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Landroidx/fragment/app/Fragment;", "", "", "permissions", "", "checkSelfPermission", "(Landroidx/fragment/app/Fragment;[Ljava/lang/String;)Z", "on", "", "keepOnScreen", "(Landroidx/fragment/app/Fragment;Z)V", "Landroidx/viewbinding/ViewBinding;", "T", "Lkotlin/Function1;", "Landroid/view/View;", "viewBindingFactory", "Lio/streamlayer/utils/FragmentViewBindingDelegate;", "bindingDelegate", "(Landroidx/fragment/app/Fragment;Lkotlin/jvm/functions/Function1;)Lio/streamlayer/utils/FragmentViewBindingDelegate;", "sdk_originalRelease"})
public final class FragmentExtensionsKt {
    public static final boolean checkSelfPermission(@NotNull Fragment fragment, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"permissions");
        for (String string2 : stringArray) {
            if (ContextCompat.checkSelfPermission((Context)fragment.requireContext(), (String)string2) != -1) continue;
            return false;
        }
        return true;
    }

    public static final void keepOnScreen(@NotNull Fragment fragment, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"<this>");
        if (bl) {
            fragment.requireActivity().getWindow().addFlags(128);
        } else {
            fragment.requireActivity().getWindow().clearFlags(128);
        }
    }

    @NotNull
    public static final <T extends ViewBinding> FragmentViewBindingDelegate<T> bindingDelegate(@NotNull Fragment fragment, @NotNull Function1<? super View, ? extends T> function1) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"<this>");
        Intrinsics.checkNotNullParameter(function1, (String)"viewBindingFactory");
        return new FragmentViewBindingDelegate<T>(fragment, function1);
    }
}

