/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.voximplant;

import com.voximplant.sdk.call.CallSettings;
import com.voximplant.sdk.call.ICall;
import com.voximplant.sdk.call.ICallListener;
import com.voximplant.sdk.call.IQualityIssueListener;
import com.voximplant.sdk.call.VideoCodec;
import com.voximplant.sdk.call.VideoFlags;
import com.voximplant.sdk.client.AuthParams;
import com.voximplant.sdk.client.ClientState;
import com.voximplant.sdk.client.IClient;
import com.voximplant.sdk.client.IClientLoginListener;
import com.voximplant.sdk.client.IClientSessionListener;
import com.voximplant.sdk.client.LoginError;
import io.streamlayer.common.data.voximplant.AuthError;
import io.streamlayer.common.data.voximplant.VoximplantClientListener;
import io.streamlayer.common.data.voximplant.VoximplantClientManagerKt;
import io.streamlayer.sdk.model.auth.VoximplantUser;
import io.streamlayer.utils.SLRLog;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0007\u0012\u0006\u0010=\u001a\u00020<\u00a2\u0006\u0004\bF\u0010GJ\u000f\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u0005J'\u0010\u000e\u001a\u00020\u00032\u0018\b\u0002\u0010\r\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0005J\u0019\u0010\u0013\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0005J!\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b \u0010\u0014J\u0017\u0010!\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b!\u0010\u001eJ\u0017\u0010\"\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\"\u0010#J3\u0010,\u001a\u0004\u0018\u00010+2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010&\u001a\u00020%2\b\u0010(\u001a\u0004\u0018\u00010'2\b\u0010*\u001a\u0004\u0018\u00010)\u00a2\u0006\u0004\b,\u0010-J\u001f\u0010/\u001a\u00020\u00032\u0006\u0010.\u001a\u00020+2\b\u0010(\u001a\u0004\u0018\u00010'\u00a2\u0006\u0004\b/\u00100R\u0018\u00101\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102R\u001c\u00104\u001a\b\u0012\u0004\u0012\u00020\u0011038\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R$\u0010(\u001a\u0004\u0018\u0001068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u00107\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0019\u0010=\u001a\u00020<8\u0006@\u0006\u00a2\u0006\f\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@R2\u0010A\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bA\u0010B\u001a\u0004\bC\u0010D\"\u0004\bE\u0010\u000f\u00a8\u0006H"}, d2={"Lio/streamlayer/common/data/voximplant/VoximplantClientManager;", "Lcom/voximplant/sdk/client/IClientSessionListener;", "Lcom/voximplant/sdk/client/IClientLoginListener;", "", "internalLogin", "()V", "Lio/streamlayer/sdk/model/auth/VoximplantUser;", "user", "login", "(Lio/streamlayer/sdk/model/auth/VoximplantUser;)V", "logout", "Lkotlin/Function1;", "Lio/streamlayer/common/data/voximplant/AuthError;", "completion", "connect", "(Lkotlin/jvm/functions/Function1;)V", "onConnectionEstablished", "", "p0", "onConnectionFailed", "(Ljava/lang/String;)V", "onConnectionClosed", "displayName", "Lcom/voximplant/sdk/client/AuthParams;", "authParams", "onLoginSuccessful", "(Ljava/lang/String;Lcom/voximplant/sdk/client/AuthParams;)V", "Lcom/voximplant/sdk/client/LoginError;", "reason", "onLoginFailed", "(Lcom/voximplant/sdk/client/LoginError;)V", "key", "onOneTimeKeyGenerated", "onRefreshTokenFailed", "onRefreshTokenSuccess", "(Lcom/voximplant/sdk/client/AuthParams;)V", "topicId", "", "isVideoEnabled", "Lcom/voximplant/sdk/call/ICallListener;", "listener", "Lcom/voximplant/sdk/call/IQualityIssueListener;", "qualityListener", "Lcom/voximplant/sdk/call/ICall;", "createCall", "(Ljava/lang/String;ZLcom/voximplant/sdk/call/ICallListener;Lcom/voximplant/sdk/call/IQualityIssueListener;)Lcom/voximplant/sdk/call/ICall;", "call", "endCall", "(Lcom/voximplant/sdk/call/ICall;Lcom/voximplant/sdk/call/ICallListener;)V", "voximplantUser", "Lio/streamlayer/sdk/model/auth/VoximplantUser;", "", "servers", "Ljava/util/List;", "Lio/streamlayer/common/data/voximplant/VoximplantClientListener;", "Lio/streamlayer/common/data/voximplant/VoximplantClientListener;", "getListener", "()Lio/streamlayer/common/data/voximplant/VoximplantClientListener;", "setListener", "(Lio/streamlayer/common/data/voximplant/VoximplantClientListener;)V", "Lcom/voximplant/sdk/client/IClient;", "client", "Lcom/voximplant/sdk/client/IClient;", "getClient", "()Lcom/voximplant/sdk/client/IClient;", "reconnectCompletion", "Lkotlin/jvm/functions/Function1;", "getReconnectCompletion", "()Lkotlin/jvm/functions/Function1;", "setReconnectCompletion", "<init>", "(Lcom/voximplant/sdk/client/IClient;)V", "sdk_originalRelease"})
public final class VoximplantClientManager
implements IClientSessionListener,
IClientLoginListener {
    private VoximplantUser voximplantUser;
    private final List<String> servers;
    @Nullable
    private Function1<? super AuthError, Unit> reconnectCompletion;
    @Nullable
    private VoximplantClientListener listener;
    @NotNull
    private final IClient client;

    public static /* synthetic */ void connect$default(VoximplantClientManager voximplantClientManager, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        voximplantClientManager.connect((Function1<? super AuthError, Unit>)function1);
    }

    private final void internalLogin() {
        block8: {
            SLRLog.INSTANCE.i("VoximplantClientManager", "internalLogin " + ((VoximplantClientManager)object).client.getClientState());
            if (((VoximplantClientManager)object).client.getClientState() == ClientState.DISCONNECTED) {
                IClient iClient = ((VoximplantClientManager)object).client;
                boolean bl = false;
                try {
                    iClient.connect(bl, ((VoximplantClientManager)object).servers);
                }
                catch (IllegalStateException illegalStateException) {
                    VoximplantClientListener voximplantClientListener2 = ((VoximplantClientManager)object).listener;
                    if (voximplantClientListener2 == null) break block8;
                    voximplantClientListener2.onConnectionFailed(AuthError.NetworkIssues);
                }
            }
        }
        if (((VoximplantClientManager)object).client.getClientState() == ClientState.CONNECTED) {
            Object object;
            VoximplantUser voximplantUser = ((VoximplantClientManager)object).voximplantUser;
            if (voximplantUser != null) {
                VoximplantUser voximplantUser2 = voximplantUser;
                object = voximplantUser2.getUsername();
                ((VoximplantClientManager)object).client.login((String)object, voximplantUser2.getPassword());
            } else {
                object = ((VoximplantClientManager)object).listener;
                if (object != null) {
                    object.onLoginFailed(AuthError.InvalidUsername);
                }
            }
        }
    }

    @Inject
    public VoximplantClientManager(@NotNull IClient object) {
        ArrayList arrayList;
        IClient iClient = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"client");
        this.client = object;
        object = arrayList;
        arrayList = new ArrayList();
        this.servers = object;
        iClient.setClientLoginListener((IClientLoginListener)this);
        iClient.setClientSessionListener((IClientSessionListener)this);
    }

    @Nullable
    public final Function1<AuthError, Unit> getReconnectCompletion() {
        return this.reconnectCompletion;
    }

    public final void setReconnectCompletion(@Nullable Function1<? super AuthError, Unit> function1) {
        this.reconnectCompletion = function1;
    }

    @Nullable
    public final VoximplantClientListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable VoximplantClientListener voximplantClientListener2) {
        this.listener = voximplantClientListener2;
    }

    public final void login(@NotNull VoximplantUser voximplantUser) {
        VoximplantUser voximplantUser2 = voximplantUser;
        Intrinsics.checkNotNullParameter((Object)voximplantUser2, (String)"user");
        SLRLog.INSTANCE.i("VoximplantClientManager", "login " + this.client.getClientState());
        this.voximplantUser = voximplantUser2;
        this.internalLogin();
    }

    public final void logout() {
        SLRLog.INSTANCE.i("VoximplantClientManager", "logout " + this.client.getClientState());
        if (this.client.getClientState() == ClientState.LOGGED_IN) {
            this.client.disconnect();
        }
        this.voximplantUser = null;
    }

    public final void connect(@Nullable Function1<? super AuthError, Unit> function1) {
        SLRLog.INSTANCE.i("VoximplantClientManager", "connect " + this.client.getClientState());
        if (this.client.getClientState() == ClientState.LOGGED_IN) {
            if (function1 != null) {
                Unit cfr_ignored_0 = (Unit)function1.invoke(null);
            }
            return;
        }
        this.reconnectCompletion = function1;
        this.internalLogin();
    }

    public void onConnectionEstablished() {
        this.internalLogin();
    }

    public void onConnectionFailed(@Nullable String function1) {
        SLRLog.INSTANCE.i("VoximplantClientManager", "onConnectionFailed " + (String)function1);
        function1 = this.listener;
        if (function1 != null) {
            function1.onConnectionFailed(AuthError.NetworkIssues);
        }
        if ((function1 = this.reconnectCompletion) != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)AuthError.NetworkIssues);
        }
        this.reconnectCompletion = null;
    }

    public void onConnectionClosed() {
        SLRLog.INSTANCE.i("VoximplantClientManager", "onConnectionClosed");
        Function1<? super AuthError, Unit> function1 = this.listener;
        if (function1 != null) {
            function1.onConnectionClosed();
        }
        if ((function1 = this.reconnectCompletion) != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)AuthError.NetworkIssues);
        }
        this.reconnectCompletion = null;
    }

    public void onLoginSuccessful(@NotNull String function1, @Nullable AuthParams object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"displayName");
        SLRLog.INSTANCE.i("VoximplantClientManager", "onLoginSuccessful " + (String)function1);
        object = this.listener;
        if (object != null) {
            object.onLoginSuccess((String)function1);
        }
        if ((function1 = this.reconnectCompletion) != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke(null);
        }
        this.reconnectCompletion = null;
    }

    public void onLoginFailed(@NotNull LoginError object) {
        LoginError loginError = object;
        Intrinsics.checkNotNullParameter((Object)loginError, (String)"reason");
        object = VoximplantClientManagerKt.access$makeAuthError(loginError);
        SLRLog.INSTANCE.i("VoximplantClientManager", "onLoginFailed " + object);
        Function1<? super AuthError, Unit> function1 = this.listener;
        if (function1 != null) {
            function1.onLoginFailed((AuthError)((Object)object));
        }
        if ((function1 = this.reconnectCompletion) != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke(object);
        }
        this.reconnectCompletion = null;
    }

    public void onOneTimeKeyGenerated(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"key");
    }

    public void onRefreshTokenFailed(@NotNull LoginError loginError) {
        Intrinsics.checkNotNullParameter((Object)loginError, (String)"reason");
    }

    public void onRefreshTokenSuccess(@NotNull AuthParams authParams) {
        Intrinsics.checkNotNullParameter((Object)authParams, (String)"authParams");
    }

    @Nullable
    public final ICall createCall(@NotNull String string2, boolean bl, @Nullable ICallListener iCallListener, @Nullable IQualityIssueListener iQualityIssueListener) {
        CallSettings callSettings;
        VoximplantClientManager voximplantClientManager = voximplantClientManager2;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        SLRLog.INSTANCE.i("VoximplantClientManager", "createCall " + string2);
        VoximplantClientManager voximplantClientManager2 = callSettings;
        new CallSettings().videoFlags = new VideoFlags(true, bl);
        new CallSettings().preferredVideoCodec = VideoCodec.AUTO;
        voximplantClientManager2 = voximplantClientManager.client.callConference("conf_" + string2, (CallSettings)voximplantClientManager2);
        if (voximplantClientManager2 != null) {
            VoximplantClientManager voximplantClientManager3 = voximplantClientManager2;
            voximplantClientManager3.addCallListener(iCallListener);
            voximplantClientManager3.setQualityIssueListener(iQualityIssueListener);
            voximplantClientManager3.start();
        }
        return voximplantClientManager2;
    }

    public final void endCall(@NotNull ICall iCall, @Nullable ICallListener iCallListener) {
        Intrinsics.checkNotNullParameter((Object)iCall, (String)"call");
        if (iCallListener != null) {
            iCall.removeCallListener(iCallListener);
        }
        ICall iCall2 = iCall;
        iCall2.setQualityIssueListener(null);
        iCall2.hangup(null);
    }

    @NotNull
    public final IClient getClient() {
        return this.client;
    }
}

