/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.sports.basketball;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.reactivex.Observable;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.sports.basketball.BasketballBoxScore;
import io.streamlayer.sdk.model.sports.basketball.BasketballEventSummary;
import io.streamlayer.sdk.model.sports.basketball.BasketballPlayByPlay;
import io.streamlayer.sdk.model.sports.basketball.BasketballPlayByPlayStatistics;
import io.streamlayer.sdk.model.sports.basketball.BasketballStandings;
import io.streamlayer.sdk.model.sports.basketball.BasketballSummary;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamRank;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamStanding;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamStreak;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamSummary;
import io.streamlayer.sdk.model.sports.basketball.PlayerScores;
import io.streamlayer.sdk.repository.sports.basketball.BasketballDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class BasketballDao_Impl
implements BasketballDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<BasketballEventSummary> __insertionAdapterOfBasketballEventSummary;
    private final Converters __converters;
    private final EntityInsertionAdapter<BasketballBoxScore> __insertionAdapterOfBasketballBoxScore;
    private final EntityInsertionAdapter<BasketballPlayByPlay> __insertionAdapterOfBasketballPlayByPlay;
    private final EntityInsertionAdapter<BasketballTeamStanding> __insertionAdapterOfBasketballTeamStanding;
    private final EntityDeletionOrUpdateAdapter<BasketballEventSummary> __deletionAdapterOfBasketballEventSummary;
    private final EntityDeletionOrUpdateAdapter<BasketballBoxScore> __deletionAdapterOfBasketballBoxScore;
    private final EntityDeletionOrUpdateAdapter<BasketballPlayByPlay> __deletionAdapterOfBasketballPlayByPlay;
    private final EntityDeletionOrUpdateAdapter<BasketballEventSummary> __updateAdapterOfBasketballEventSummary;
    private final EntityDeletionOrUpdateAdapter<BasketballBoxScore> __updateAdapterOfBasketballBoxScore;
    private final EntityDeletionOrUpdateAdapter<BasketballPlayByPlay> __updateAdapterOfBasketballPlayByPlay;
    private final EntityDeletionOrUpdateAdapter<BasketballTeamStanding> __updateAdapterOfBasketballTeamStanding;
    private final SharedSQLiteStatement __preparedStmtOfDeleteBasketballStandings;

    public BasketballDao_Impl(RoomDatabase roomDatabase) {
        SharedSQLiteStatement sharedSQLiteStatement;
        EntityDeletionOrUpdateAdapter<BasketballTeamStanding> entityDeletionOrUpdateAdapter;
        EntityDeletionOrUpdateAdapter<BasketballPlayByPlay> entityDeletionOrUpdateAdapter2;
        EntityDeletionOrUpdateAdapter<BasketballBoxScore> entityDeletionOrUpdateAdapter3;
        EntityDeletionOrUpdateAdapter<BasketballEventSummary> entityDeletionOrUpdateAdapter4;
        EntityDeletionOrUpdateAdapter<BasketballPlayByPlay> entityDeletionOrUpdateAdapter5;
        EntityDeletionOrUpdateAdapter<BasketballBoxScore> entityDeletionOrUpdateAdapter6;
        EntityDeletionOrUpdateAdapter<BasketballEventSummary> entityDeletionOrUpdateAdapter7;
        EntityInsertionAdapter<BasketballTeamStanding> entityInsertionAdapter;
        EntityInsertionAdapter<BasketballPlayByPlay> entityInsertionAdapter2;
        EntityInsertionAdapter<BasketballBoxScore> entityInsertionAdapter3;
        EntityInsertionAdapter<BasketballEventSummary> entityInsertionAdapter4;
        Converters converters;
        Converters converters2 = converters;
        converters = new Converters();
        this.__converters = converters2;
        this.__db = roomDatabase;
        converters2 = entityInsertionAdapter4;
        entityInsertionAdapter4 = new EntityInsertionAdapter<BasketballEventSummary>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `BasketballEventSummary` (`basketballEventSummaryId`,`performers`,`homeTeamfieldGoalPercentage`,`homeTeamthreePtsPercentage`,`homeTeamfreeThrowPercentage`,`homeTeamassists`,`homeTeamrebounds`,`awayTeamfieldGoalPercentage`,`awayTeamthreePtsPercentage`,`awayTeamfreeThrowPercentage`,`awayTeamassists`,`awayTeamrebounds`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballEventSummary object) {
                long l = ((BasketballEventSummary)object).getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object2 = object2.BasketballDao_Impl.this.__converters.basketballPerfomersToString(((BasketballEventSummary)object).getPerformers());
                if (object2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object2);
                }
                object2 = ((BasketballEventSummary)object).getSummary();
                if (object2 != null) {
                    object = ((BasketballSummary)object2).getHomeTeamStatistics();
                    if (object != null) {
                        double d = ((BasketballTeamSummary)object).getFieldGoalPercentage();
                        supportSQLiteStatement.bindDouble(3, d);
                        d = ((BasketballTeamSummary)object).getThreePtsPercentage();
                        supportSQLiteStatement.bindDouble(4, d);
                        d = ((BasketballTeamSummary)object).getFreeThrowPercentage();
                        supportSQLiteStatement.bindDouble(5, d);
                        long l2 = ((BasketballTeamSummary)object).getAssists();
                        supportSQLiteStatement.bindLong(6, l2);
                        l2 = ((BasketballTeamSummary)object).getRebounds();
                        supportSQLiteStatement.bindLong(7, l2);
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                        supportSQLiteStatement2.bindNull(3);
                        supportSQLiteStatement2.bindNull(4);
                        supportSQLiteStatement2.bindNull(5);
                        supportSQLiteStatement2.bindNull(6);
                        supportSQLiteStatement2.bindNull(7);
                    }
                    object2 = ((BasketballSummary)object2).getAwayTeamStatistics();
                    if (object2 != null) {
                        double d = ((BasketballTeamSummary)object2).getFieldGoalPercentage();
                        supportSQLiteStatement.bindDouble(8, d);
                        d = ((BasketballTeamSummary)object2).getThreePtsPercentage();
                        supportSQLiteStatement.bindDouble(9, d);
                        d = ((BasketballTeamSummary)object2).getFreeThrowPercentage();
                        supportSQLiteStatement.bindDouble(10, d);
                        long l3 = ((BasketballTeamSummary)object2).getAssists();
                        supportSQLiteStatement.bindLong(11, l3);
                        l3 = ((BasketballTeamSummary)object2).getRebounds();
                        supportSQLiteStatement.bindLong(12, l3);
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                        supportSQLiteStatement3.bindNull(8);
                        supportSQLiteStatement3.bindNull(9);
                        supportSQLiteStatement3.bindNull(10);
                        supportSQLiteStatement3.bindNull(11);
                        supportSQLiteStatement3.bindNull(12);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement4 = supportSQLiteStatement;
                    supportSQLiteStatement4.bindNull(3);
                    supportSQLiteStatement4.bindNull(4);
                    supportSQLiteStatement4.bindNull(5);
                    supportSQLiteStatement4.bindNull(6);
                    supportSQLiteStatement4.bindNull(7);
                    supportSQLiteStatement4.bindNull(8);
                    supportSQLiteStatement4.bindNull(9);
                    supportSQLiteStatement4.bindNull(10);
                    supportSQLiteStatement4.bindNull(11);
                    supportSQLiteStatement4.bindNull(12);
                }
            }
        };
        this.__insertionAdapterOfBasketballEventSummary = converters2;
        converters2 = entityInsertionAdapter3;
        entityInsertionAdapter3 = new EntityInsertionAdapter<BasketballBoxScore>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `BasketballBoxScore` (`basketballBoxScoreId`,`homePlayerScores`,`awayPlayerScore`) VALUES (?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballBoxScore basketballBoxScore) {
                long l = basketballBoxScore.getId();
                supportSQLiteStatement.bindLong(1, l);
                String string2 = object.BasketballDao_Impl.this.__converters.playerScoresToString(basketballBoxScore.getHomePlayerScores());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, string2);
                }
                Object object = object.BasketballDao_Impl.this.__converters.playerScoresToString(basketballBoxScore.getAwayPlayerScore());
                if (object == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, (String)object);
                }
            }
        };
        this.__insertionAdapterOfBasketballBoxScore = converters2;
        converters2 = entityInsertionAdapter2;
        entityInsertionAdapter2 = new EntityInsertionAdapter<BasketballPlayByPlay>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `BasketballPlayByPlay` (`basketballPlayByPlayId`,`statistics`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballPlayByPlay basketballPlayByPlay) {
                long l = basketballPlayByPlay.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.BasketballDao_Impl.this.__converters.playByPlayStatisticsToString(basketballPlayByPlay.getStatistics());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
            }
        };
        this.__insertionAdapterOfBasketballPlayByPlay = converters2;
        converters2 = entityInsertionAdapter;
        entityInsertionAdapter = new EntityInsertionAdapter<BasketballTeamStanding>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `BasketballTeamStanding` (`id`,`teamName`,`teamIcon`,`colors`,`wins`,`losses`,`percentage`,`gamesBehind`,`division`,`conference`,`league`,`streakkind`,`streaklength`,`rankdivision`,`rankconference`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballTeamStanding basketballTeamStanding) {
                long l = basketballTeamStanding.getId();
                supportSQLiteStatement.bindLong(1, l);
                if (basketballTeamStanding.getTeamName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, basketballTeamStanding.getTeamName());
                }
                if (basketballTeamStanding.getTeamIcon() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, basketballTeamStanding.getTeamIcon());
                }
                Object object = object.BasketballDao_Impl.this.__converters.stringListToString(basketballTeamStanding.getColors());
                if (object == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, (String)object);
                }
                l = basketballTeamStanding.getWins();
                supportSQLiteStatement.bindLong(5, l);
                l = basketballTeamStanding.getLosses();
                supportSQLiteStatement.bindLong(6, l);
                double d = basketballTeamStanding.getPercentage();
                supportSQLiteStatement.bindDouble(7, d);
                long l2 = basketballTeamStanding.getGamesBehind();
                supportSQLiteStatement.bindLong(8, l2);
                if (basketballTeamStanding.getDivision() == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, basketballTeamStanding.getDivision());
                }
                if (basketballTeamStanding.getConference() == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, basketballTeamStanding.getConference());
                }
                if (basketballTeamStanding.getLeague() == null) {
                    supportSQLiteStatement.bindNull(11);
                } else {
                    supportSQLiteStatement.bindString(11, basketballTeamStanding.getLeague());
                }
                object = basketballTeamStanding.getStreak();
                if (object != null) {
                    if (((BasketballTeamStreak)object).getKind() == null) {
                        supportSQLiteStatement.bindNull(12);
                    } else {
                        supportSQLiteStatement.bindString(12, ((BasketballTeamStreak)object).getKind());
                    }
                    l2 = ((BasketballTeamStreak)object).getLength();
                    supportSQLiteStatement.bindLong(13, l2);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(12);
                    supportSQLiteStatement2.bindNull(13);
                }
                object = basketballTeamStanding.getRank();
                if (object != null) {
                    long l3 = ((BasketballTeamRank)object).getDivision();
                    supportSQLiteStatement.bindLong(14, l3);
                    l3 = ((BasketballTeamRank)object).getConference();
                    supportSQLiteStatement.bindLong(15, l3);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                    supportSQLiteStatement3.bindNull(14);
                    supportSQLiteStatement3.bindNull(15);
                }
            }
        };
        this.__insertionAdapterOfBasketballTeamStanding = converters2;
        converters2 = entityDeletionOrUpdateAdapter7;
        entityDeletionOrUpdateAdapter7 = new EntityDeletionOrUpdateAdapter<BasketballEventSummary>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `BasketballEventSummary` WHERE `basketballEventSummaryId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballEventSummary basketballEventSummary) {
                long l = basketballEventSummary.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        this.__deletionAdapterOfBasketballEventSummary = converters2;
        converters2 = entityDeletionOrUpdateAdapter6;
        entityDeletionOrUpdateAdapter6 = new EntityDeletionOrUpdateAdapter<BasketballBoxScore>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `BasketballBoxScore` WHERE `basketballBoxScoreId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballBoxScore basketballBoxScore) {
                long l = basketballBoxScore.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        this.__deletionAdapterOfBasketballBoxScore = converters2;
        converters2 = entityDeletionOrUpdateAdapter5;
        entityDeletionOrUpdateAdapter5 = new EntityDeletionOrUpdateAdapter<BasketballPlayByPlay>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `BasketballPlayByPlay` WHERE `basketballPlayByPlayId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballPlayByPlay basketballPlayByPlay) {
                long l = basketballPlayByPlay.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        this.__deletionAdapterOfBasketballPlayByPlay = converters2;
        converters2 = entityDeletionOrUpdateAdapter4;
        entityDeletionOrUpdateAdapter4 = new EntityDeletionOrUpdateAdapter<BasketballEventSummary>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `BasketballEventSummary` SET `basketballEventSummaryId` = ?,`performers` = ?,`homeTeamfieldGoalPercentage` = ?,`homeTeamthreePtsPercentage` = ?,`homeTeamfreeThrowPercentage` = ?,`homeTeamassists` = ?,`homeTeamrebounds` = ?,`awayTeamfieldGoalPercentage` = ?,`awayTeamthreePtsPercentage` = ?,`awayTeamfreeThrowPercentage` = ?,`awayTeamassists` = ?,`awayTeamrebounds` = ? WHERE `basketballEventSummaryId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballEventSummary basketballEventSummary) {
                long l = basketballEventSummary.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.BasketballDao_Impl.this.__converters.basketballPerfomersToString(basketballEventSummary.getPerformers());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
                object = basketballEventSummary.getSummary();
                if (object != null) {
                    BasketballTeamSummary basketballTeamSummary = ((BasketballSummary)object).getHomeTeamStatistics();
                    if (basketballTeamSummary != null) {
                        double d = basketballTeamSummary.getFieldGoalPercentage();
                        supportSQLiteStatement.bindDouble(3, d);
                        d = basketballTeamSummary.getThreePtsPercentage();
                        supportSQLiteStatement.bindDouble(4, d);
                        d = basketballTeamSummary.getFreeThrowPercentage();
                        supportSQLiteStatement.bindDouble(5, d);
                        long l2 = basketballTeamSummary.getAssists();
                        supportSQLiteStatement.bindLong(6, l2);
                        l2 = basketballTeamSummary.getRebounds();
                        supportSQLiteStatement.bindLong(7, l2);
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                        supportSQLiteStatement2.bindNull(3);
                        supportSQLiteStatement2.bindNull(4);
                        supportSQLiteStatement2.bindNull(5);
                        supportSQLiteStatement2.bindNull(6);
                        supportSQLiteStatement2.bindNull(7);
                    }
                    object = ((BasketballSummary)object).getAwayTeamStatistics();
                    if (object != null) {
                        double d = ((BasketballTeamSummary)object).getFieldGoalPercentage();
                        supportSQLiteStatement.bindDouble(8, d);
                        d = ((BasketballTeamSummary)object).getThreePtsPercentage();
                        supportSQLiteStatement.bindDouble(9, d);
                        d = ((BasketballTeamSummary)object).getFreeThrowPercentage();
                        supportSQLiteStatement.bindDouble(10, d);
                        long l3 = ((BasketballTeamSummary)object).getAssists();
                        supportSQLiteStatement.bindLong(11, l3);
                        l3 = ((BasketballTeamSummary)object).getRebounds();
                        supportSQLiteStatement.bindLong(12, l3);
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                        supportSQLiteStatement3.bindNull(8);
                        supportSQLiteStatement3.bindNull(9);
                        supportSQLiteStatement3.bindNull(10);
                        supportSQLiteStatement3.bindNull(11);
                        supportSQLiteStatement3.bindNull(12);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement4 = supportSQLiteStatement;
                    supportSQLiteStatement4.bindNull(3);
                    supportSQLiteStatement4.bindNull(4);
                    supportSQLiteStatement4.bindNull(5);
                    supportSQLiteStatement4.bindNull(6);
                    supportSQLiteStatement4.bindNull(7);
                    supportSQLiteStatement4.bindNull(8);
                    supportSQLiteStatement4.bindNull(9);
                    supportSQLiteStatement4.bindNull(10);
                    supportSQLiteStatement4.bindNull(11);
                    supportSQLiteStatement4.bindNull(12);
                }
                long l4 = basketballEventSummary.getId();
                supportSQLiteStatement.bindLong(13, l4);
            }
        };
        this.__updateAdapterOfBasketballEventSummary = converters2;
        converters2 = entityDeletionOrUpdateAdapter3;
        entityDeletionOrUpdateAdapter3 = new EntityDeletionOrUpdateAdapter<BasketballBoxScore>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `BasketballBoxScore` SET `basketballBoxScoreId` = ?,`homePlayerScores` = ?,`awayPlayerScore` = ? WHERE `basketballBoxScoreId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballBoxScore basketballBoxScore) {
                long l = basketballBoxScore.getId();
                supportSQLiteStatement.bindLong(1, l);
                String string2 = object.BasketballDao_Impl.this.__converters.playerScoresToString(basketballBoxScore.getHomePlayerScores());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, string2);
                }
                Object object = object.BasketballDao_Impl.this.__converters.playerScoresToString(basketballBoxScore.getAwayPlayerScore());
                if (object == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, (String)object);
                }
                long l2 = basketballBoxScore.getId();
                supportSQLiteStatement.bindLong(4, l2);
            }
        };
        this.__updateAdapterOfBasketballBoxScore = converters2;
        converters2 = entityDeletionOrUpdateAdapter2;
        entityDeletionOrUpdateAdapter2 = new EntityDeletionOrUpdateAdapter<BasketballPlayByPlay>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `BasketballPlayByPlay` SET `basketballPlayByPlayId` = ?,`statistics` = ? WHERE `basketballPlayByPlayId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballPlayByPlay basketballPlayByPlay) {
                long l = basketballPlayByPlay.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.BasketballDao_Impl.this.__converters.playByPlayStatisticsToString(basketballPlayByPlay.getStatistics());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
                long l2 = basketballPlayByPlay.getId();
                supportSQLiteStatement.bindLong(3, l2);
            }
        };
        this.__updateAdapterOfBasketballPlayByPlay = converters2;
        converters2 = entityDeletionOrUpdateAdapter;
        entityDeletionOrUpdateAdapter = new EntityDeletionOrUpdateAdapter<BasketballTeamStanding>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `BasketballTeamStanding` SET `id` = ?,`teamName` = ?,`teamIcon` = ?,`colors` = ?,`wins` = ?,`losses` = ?,`percentage` = ?,`gamesBehind` = ?,`division` = ?,`conference` = ?,`league` = ?,`streakkind` = ?,`streaklength` = ?,`rankdivision` = ?,`rankconference` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballTeamStanding basketballTeamStanding) {
                long l = basketballTeamStanding.getId();
                supportSQLiteStatement.bindLong(1, l);
                if (basketballTeamStanding.getTeamName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, basketballTeamStanding.getTeamName());
                }
                if (basketballTeamStanding.getTeamIcon() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, basketballTeamStanding.getTeamIcon());
                }
                Object object = object.BasketballDao_Impl.this.__converters.stringListToString(basketballTeamStanding.getColors());
                if (object == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, (String)object);
                }
                l = basketballTeamStanding.getWins();
                supportSQLiteStatement.bindLong(5, l);
                l = basketballTeamStanding.getLosses();
                supportSQLiteStatement.bindLong(6, l);
                double d = basketballTeamStanding.getPercentage();
                supportSQLiteStatement.bindDouble(7, d);
                long l2 = basketballTeamStanding.getGamesBehind();
                supportSQLiteStatement.bindLong(8, l2);
                if (basketballTeamStanding.getDivision() == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, basketballTeamStanding.getDivision());
                }
                if (basketballTeamStanding.getConference() == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, basketballTeamStanding.getConference());
                }
                if (basketballTeamStanding.getLeague() == null) {
                    supportSQLiteStatement.bindNull(11);
                } else {
                    supportSQLiteStatement.bindString(11, basketballTeamStanding.getLeague());
                }
                object = basketballTeamStanding.getStreak();
                if (object != null) {
                    if (((BasketballTeamStreak)object).getKind() == null) {
                        supportSQLiteStatement.bindNull(12);
                    } else {
                        supportSQLiteStatement.bindString(12, ((BasketballTeamStreak)object).getKind());
                    }
                    l2 = ((BasketballTeamStreak)object).getLength();
                    supportSQLiteStatement.bindLong(13, l2);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(12);
                    supportSQLiteStatement2.bindNull(13);
                }
                object = basketballTeamStanding.getRank();
                if (object != null) {
                    l2 = ((BasketballTeamRank)object).getDivision();
                    supportSQLiteStatement.bindLong(14, l2);
                    l2 = ((BasketballTeamRank)object).getConference();
                    supportSQLiteStatement.bindLong(15, l2);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                    supportSQLiteStatement3.bindNull(14);
                    supportSQLiteStatement3.bindNull(15);
                }
                long l3 = basketballTeamStanding.getId();
                supportSQLiteStatement.bindLong(16, l3);
            }
        };
        this.__updateAdapterOfBasketballTeamStanding = converters2;
        converters2 = sharedSQLiteStatement;
        sharedSQLiteStatement = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM BasketballTeamStanding WHERE BasketballTeamStanding.league = ?";
            }
        };
        this.__preparedStmtOfDeleteBasketballStandings = converters2;
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    @Override
    public void saveBasketballSummary(BasketballEventSummary basketballEventSummary) {
        BasketballDao_Impl basketballDao_Impl = this;
        basketballDao_Impl.__db.assertNotSuspendingTransaction();
        basketballDao_Impl.__db.beginTransaction();
        try {
            basketballDao_Impl.__insertionAdapterOfBasketballEventSummary.insert((Object)basketballEventSummary);
            basketballDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        basketballDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveBasketballBoxScore(BasketballBoxScore basketballBoxScore) {
        BasketballDao_Impl basketballDao_Impl = this;
        basketballDao_Impl.__db.assertNotSuspendingTransaction();
        basketballDao_Impl.__db.beginTransaction();
        try {
            basketballDao_Impl.__insertionAdapterOfBasketballBoxScore.insert((Object)basketballBoxScore);
            basketballDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        basketballDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveBasketballPlayByPlay(BasketballPlayByPlay basketballPlayByPlay) {
        BasketballDao_Impl basketballDao_Impl = this;
        basketballDao_Impl.__db.assertNotSuspendingTransaction();
        basketballDao_Impl.__db.beginTransaction();
        try {
            basketballDao_Impl.__insertionAdapterOfBasketballPlayByPlay.insert((Object)basketballPlayByPlay);
            basketballDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        basketballDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveBasketballTeamStandings(List<BasketballTeamStanding> list) {
        BasketballDao_Impl basketballDao_Impl = this;
        basketballDao_Impl.__db.assertNotSuspendingTransaction();
        basketballDao_Impl.__db.beginTransaction();
        try {
            basketballDao_Impl.__insertionAdapterOfBasketballTeamStanding.insert(list);
            basketballDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        basketballDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteBasketballSummary(BasketballEventSummary basketballEventSummary) {
        BasketballDao_Impl basketballDao_Impl = this;
        basketballDao_Impl.__db.assertNotSuspendingTransaction();
        basketballDao_Impl.__db.beginTransaction();
        try {
            basketballDao_Impl.__deletionAdapterOfBasketballEventSummary.handle((Object)basketballEventSummary);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        basketballDao_Impl.__db.setTransactionSuccessful();
        basketballDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteBasketballBoxScore(BasketballBoxScore basketballBoxScore) {
        BasketballDao_Impl basketballDao_Impl = this;
        basketballDao_Impl.__db.assertNotSuspendingTransaction();
        basketballDao_Impl.__db.beginTransaction();
        try {
            basketballDao_Impl.__deletionAdapterOfBasketballBoxScore.handle((Object)basketballBoxScore);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        basketballDao_Impl.__db.setTransactionSuccessful();
        basketballDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteBasketballPlayByPlay(BasketballPlayByPlay basketballPlayByPlay) {
        BasketballDao_Impl basketballDao_Impl = this;
        basketballDao_Impl.__db.assertNotSuspendingTransaction();
        basketballDao_Impl.__db.beginTransaction();
        try {
            basketballDao_Impl.__deletionAdapterOfBasketballPlayByPlay.handle((Object)basketballPlayByPlay);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        basketballDao_Impl.__db.setTransactionSuccessful();
        basketballDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateBasketballSummary(BasketballEventSummary basketballEventSummary) {
        BasketballDao_Impl basketballDao_Impl = this;
        basketballDao_Impl.__db.assertNotSuspendingTransaction();
        basketballDao_Impl.__db.beginTransaction();
        try {
            basketballDao_Impl.__updateAdapterOfBasketballEventSummary.handle((Object)basketballEventSummary);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        basketballDao_Impl.__db.setTransactionSuccessful();
        basketballDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateBasketballBoxScore(BasketballBoxScore basketballBoxScore) {
        BasketballDao_Impl basketballDao_Impl = this;
        basketballDao_Impl.__db.assertNotSuspendingTransaction();
        basketballDao_Impl.__db.beginTransaction();
        try {
            basketballDao_Impl.__updateAdapterOfBasketballBoxScore.handle((Object)basketballBoxScore);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        basketballDao_Impl.__db.setTransactionSuccessful();
        basketballDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateBasketballPlayByPlay(BasketballPlayByPlay basketballPlayByPlay) {
        BasketballDao_Impl basketballDao_Impl = this;
        basketballDao_Impl.__db.assertNotSuspendingTransaction();
        basketballDao_Impl.__db.beginTransaction();
        try {
            basketballDao_Impl.__updateAdapterOfBasketballPlayByPlay.handle((Object)basketballPlayByPlay);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        basketballDao_Impl.__db.setTransactionSuccessful();
        basketballDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateBasketballTeamStandings(List<BasketballTeamStanding> list) {
        BasketballDao_Impl basketballDao_Impl = this;
        basketballDao_Impl.__db.assertNotSuspendingTransaction();
        basketballDao_Impl.__db.beginTransaction();
        try {
            basketballDao_Impl.__updateAdapterOfBasketballTeamStanding.handleMultiple(list);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        basketballDao_Impl.__db.setTransactionSuccessful();
        basketballDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteBasketballStandings(String string2) {
        BasketballDao_Impl basketballDao_Impl = this;
        basketballDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = basketballDao_Impl.__preparedStmtOfDeleteBasketballStandings.acquire();
        int n = 1;
        if (string2 == null) {
            supportSQLiteStatement.bindNull(n);
        } else {
            supportSQLiteStatement.bindString(n, string2);
        }
        BasketballDao_Impl basketballDao_Impl2 = this;
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            BasketballDao_Impl basketballDao_Impl3 = this;
            basketballDao_Impl3.__db.endTransaction();
            basketballDao_Impl3.__preparedStmtOfDeleteBasketballStandings.release(supportSQLiteStatement);
            throw throwable;
        }
        basketballDao_Impl2.__db.setTransactionSuccessful();
        basketballDao_Impl2.__db.endTransaction();
        basketballDao_Impl2.__preparedStmtOfDeleteBasketballStandings.release(supportSQLiteStatement);
    }

    @Override
    public Observable<BasketballEventSummary> getBasketballSummary(long l) {
        Callable<BasketballEventSummary> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM BasketballEventSummary WHERE BasketballEventSummary.basketballEventSummaryId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "BasketballEventSummary";
        Callable<BasketballEventSummary> callable2 = callable;
        callable = new Callable<BasketballEventSummary>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public BasketballEventSummary call() throws Exception {
                block61: {
                    block53: {
                        block57: {
                            block60: {
                                block59: {
                                    block58: {
                                        block56: {
                                            block55: {
                                                block54: {
                                                    var1_1 = DBUtil.query((RoomDatabase)BasketballDao_Impl.access$100(BasketballDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                                    try {
                                                        var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"basketballEventSummaryId");
                                                    }
                                                    catch (Throwable v0) {
                                                        var1_1.close();
                                                        throw v0;
                                                    }
                                                    var3_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"performers");
                                                    var4_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamfieldGoalPercentage");
                                                    var5_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamthreePtsPercentage");
                                                    var6_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamfreeThrowPercentage");
                                                    var7_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamassists");
                                                    var8_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamrebounds");
                                                    var9_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamfieldGoalPercentage");
                                                    var10_19 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamthreePtsPercentage");
                                                    var11_21 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamfreeThrowPercentage");
                                                    var12_22 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamassists");
                                                    var13_23 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamrebounds");
                                                    if (!var1_1.moveToFirst()) break block53;
                                                    v1 = var1_1;
                                                    v2 = var3_7;
                                                    var14_24 = var1_1.getLong(var2_2);
                                                    if (!v1.isNull(v2)) break block54;
                                                    var2_3 = null;
                                                    break block55;
                                                }
                                                var2_3 = var1_1.getString(var3_7);
                                            }
                                            v3 = var1_1;
                                            v4 = var4_9;
                                            this = BasketballDao_Impl.access$000(BasketballDao_Impl.this).stringToBasketballPerformers((String)var2_3);
                                            if (!v3.isNull(v4)) break block56;
                                            if (!var1_1.isNull(var5_12)) break block56;
                                            if (!var1_1.isNull(var6_13)) break block56;
                                            if (!var1_1.isNull(var7_16)) break block56;
                                            if (!var1_1.isNull(var8_17)) break block56;
                                            if (!var1_1.isNull(var9_18)) break block56;
                                            if (!var1_1.isNull(var10_19)) break block56;
                                            if (!var1_1.isNull(var11_21)) break block56;
                                            if (!var1_1.isNull(var12_22)) break block56;
                                            if (!var1_1.isNull(var13_23)) break block56;
                                            var2_3 = null;
                                            break block57;
                                        }
                                        if (!var1_1.isNull(var4_9)) break block58;
                                        if (!var1_1.isNull(var5_12)) break block58;
                                        if (!var1_1.isNull(var6_13)) break block58;
                                        if (!var1_1.isNull(var7_16)) break block58;
                                        if (!var1_1.isNull(var8_17)) break block58;
                                        var17_25 = var2_3 = null;
                                        ** GOTO lbl104
                                    }
                                    v5 = var1_1;
                                    v6 = var8_17;
                                    v7 = var1_1;
                                    v8 = var7_16;
                                    v9 = var1_1;
                                    v10 = var6_13;
                                    v11 = var1_1;
                                    v12 = var5_12;
                                    var2_4 = var1_1.getDouble(var4_9);
                                    var4_10 = v11.getDouble(v12);
                                    var6_14 = v9.getDouble(v10);
                                    var8_17 = v7.getInt(v8);
                                    var16_26 = v5.getInt(v6);
                                    var17_25 = v13;
                                    v13 = new BasketballTeamSummary(var2_4, var4_10, var6_14, var8_17, var16_26);
lbl104:
                                    // 2 sources

                                    if (!var1_1.isNull(var9_18)) break block59;
                                    if (!var1_1.isNull(var10_19)) break block59;
                                    if (!var1_1.isNull(var11_21)) break block59;
                                    if (!var1_1.isNull(var12_22)) break block59;
                                    if (!var1_1.isNull(var13_23)) break block59;
                                    var10_20 = var2_5 = null;
                                    break block60;
                                }
                                v14 = var1_1;
                                v15 = var13_23;
                                v16 = var1_1;
                                v17 = var12_22;
                                v18 = var1_1;
                                v19 = var11_21;
                                v20 = var1_1;
                                v21 = var10_19;
                                var2_6 = var1_1.getDouble(var9_18);
                                var4_11 = v20.getDouble(v21);
                                var6_15 = v18.getDouble(v19);
                                var8_17 = v16.getInt(v17);
                                var9_18 = v14.getInt(v15);
                                var10_20 = v22;
                                v22 = new BasketballTeamSummary(var2_6, var4_11, var6_15, var8_17, var9_18);
                            }
                            var2_3 = v23;
                            v23 = new BasketballSummary((BasketballTeamSummary)var17_25, var10_20);
                        }
                        var3_8 = v24;
                        v24 = new BasketballEventSummary(var14_24, (BasketballSummary)var2_3, this);
                        break block61;
                    }
                    var3_8 = null;
                }
                var1_1.close();
                return var3_8;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<BasketballBoxScore> getBasketballBoxScore(long l) {
        Callable<BasketballBoxScore> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM BasketballBoxScore WHERE BasketballBoxScore.basketballBoxScoreId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "BasketballBoxScore";
        Callable<BasketballBoxScore> callable2 = callable;
        callable = new Callable<BasketballBoxScore>(){

            @Override
            public BasketballBoxScore call() throws Exception {
                Object object;
                Cursor cursor;
                block19: {
                    block14: {
                        BasketballBoxScore basketballBoxScore;
                        Object object2;
                        long l;
                        block18: {
                            int n;
                            block17: {
                                block16: {
                                    int n2;
                                    block15: {
                                        int n3;
                                        cursor = DBUtil.query((RoomDatabase)list.BasketballDao_Impl.this.__db, (SupportSQLiteQuery)list.roomSQLiteQuery, (boolean)false, null);
                                        try {
                                            n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"basketballBoxScoreId");
                                        }
                                        catch (Throwable throwable) {
                                            cursor.close();
                                            throw throwable;
                                        }
                                        n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"homePlayerScores");
                                        n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"awayPlayerScore");
                                        if (!cursor.moveToFirst()) break block14;
                                        Cursor cursor2 = cursor;
                                        int n4 = n2;
                                        l = cursor.getLong(n3);
                                        if (!cursor2.isNull(n4)) break block15;
                                        object2 = null;
                                        break block16;
                                    }
                                    object2 = cursor.getString(n2);
                                }
                                Cursor cursor3 = cursor;
                                int n5 = n;
                                object2 = list.BasketballDao_Impl.this.__converters.stringToPlayerScores((String)object2);
                                if (!cursor3.isNull(n5)) break block17;
                                object = null;
                                break block18;
                            }
                            object = cursor.getString(n);
                        }
                        List<PlayerScores> list = list.BasketballDao_Impl.this.__converters.stringToPlayerScores((String)object);
                        object = basketballBoxScore;
                        basketballBoxScore = new BasketballBoxScore(l, (List<PlayerScores>)object2, list);
                        break block19;
                    }
                    object = null;
                }
                cursor.close();
                return object;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<BasketballPlayByPlay> getBasketballPlayByPlay(long l) {
        Callable<BasketballPlayByPlay> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM BasketballPlayByPlay WHERE BasketballPlayByPlay.basketballPlayByPlayId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "BasketballPlayByPlay";
        Callable<BasketballPlayByPlay> callable2 = callable;
        callable = new Callable<BasketballPlayByPlay>(){

            @Override
            public BasketballPlayByPlay call() throws Exception {
                Object object;
                Cursor cursor;
                block13: {
                    block10: {
                        BasketballPlayByPlay basketballPlayByPlay;
                        long l;
                        block12: {
                            int n;
                            block11: {
                                int n2;
                                cursor = DBUtil.query((RoomDatabase)list.BasketballDao_Impl.this.__db, (SupportSQLiteQuery)list.roomSQLiteQuery, (boolean)false, null);
                                try {
                                    n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"basketballPlayByPlayId");
                                }
                                catch (Throwable throwable) {
                                    cursor.close();
                                    throw throwable;
                                }
                                n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statistics");
                                if (!cursor.moveToFirst()) break block10;
                                Cursor cursor2 = cursor;
                                int n3 = n;
                                l = cursor.getLong(n2);
                                if (!cursor2.isNull(n3)) break block11;
                                object = null;
                                break block12;
                            }
                            object = cursor.getString(n);
                        }
                        List<BasketballPlayByPlayStatistics> list = list.BasketballDao_Impl.this.__converters.stringToPlayByPlayStatistics((String)object);
                        object = basketballPlayByPlay;
                        basketballPlayByPlay = new BasketballPlayByPlay(l, list);
                        break block13;
                    }
                    object = null;
                }
                cursor.close();
                return object;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<List<BasketballTeamStanding>> getBasketballTeamStandings(String stringArray) {
        Callable<List<BasketballTeamStanding>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM BasketballTeamStanding WHERE BasketballTeamStanding.league = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[1];
        stringArray = stringArray2;
        stringArray2[0] = "BasketballTeamStanding";
        Callable<List<BasketballTeamStanding>> callable2 = callable;
        callable = new Callable<List<BasketballTeamStanding>>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public List<BasketballTeamStanding> call() throws Exception {
                var1_1 = DBUtil.query((RoomDatabase)BasketballDao_Impl.access$100(BasketballDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"id");
                var3_3 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"teamName");
                var4_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"teamIcon");
                var5_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"colors");
                var6_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"wins");
                var7_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"losses");
                var8_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"percentage");
                var9_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"gamesBehind");
                var10_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"division");
                var11_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"conference");
                var12_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"league");
                var13_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"streakkind");
                var14_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"streaklength");
                var15_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"rankdivision");
                var16_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"rankconference");
                var17_17 = v0;
                try {
                    v0 = new ArrayList<BasketballTeamStanding>(var1_1.getCount());
                    ** while (var1_1.moveToNext())
                }
                catch (Throwable v1) {
                    var1_1.close();
                    throw v1;
                }
lbl-1000:
                // 1 sources

                {
                    block64: {
                        block63: {
                            block62: {
                                block61: {
                                    block60: {
                                        block59: {
                                            block58: {
                                                block57: {
                                                    block56: {
                                                        block55: {
                                                            block54: {
                                                                block53: {
                                                                    block52: {
                                                                        block51: {
                                                                            block50: {
                                                                                block49: {
                                                                                    v2 = var1_1;
                                                                                    v3 = var3_3;
                                                                                    var18_18 = var1_1.getLong(var2_2);
                                                                                    if (!v2.isNull(v3)) break block49;
                                                                                    var20_19 = null;
                                                                                    break block50;
                                                                                }
                                                                                var20_19 = var1_1.getString(var3_3);
                                                                            }
                                                                            if (!var1_1.isNull(var4_4)) break block51;
                                                                            var21_20 = null;
                                                                            break block52;
                                                                        }
                                                                        var21_20 = var1_1.getString(var4_4);
                                                                    }
                                                                    if (!var1_1.isNull(var5_5)) break block53;
                                                                    var22_21 = null;
                                                                    break block54;
                                                                }
                                                                var22_21 = var1_1.getString(var5_5);
                                                            }
                                                            v4 = var1_1;
                                                            v5 = var10_10;
                                                            v6 = var1_1;
                                                            v7 = var9_9;
                                                            v8 = var1_1;
                                                            v9 = var8_8;
                                                            v10 = var1_1;
                                                            v11 = var7_7;
                                                            v12 = var1_1;
                                                            v13 = var6_6;
                                                            var22_21 = BasketballDao_Impl.access$000(BasketballDao_Impl.this).stringToStringList((String)var22_21);
                                                            var23_22 = v12.getInt(v13);
                                                            var24_23 = v10.getInt(v11);
                                                            var25_24 = v8.getDouble(v9);
                                                            var27_25 = v6.getInt(v7);
                                                            if (!v4.isNull(v5)) break block55;
                                                            var28_26 = null;
                                                            break block56;
                                                        }
                                                        var28_26 = var1_1.getString(var10_10);
                                                    }
                                                    if (!var1_1.isNull(var11_11)) break block57;
                                                    var29_27 = null;
                                                    break block58;
                                                }
                                                var29_27 = var1_1.getString(var11_11);
                                            }
                                            if (!var1_1.isNull(var12_12)) break block59;
                                            var30_28 = null;
                                            break block60;
                                        }
                                        var30_28 = var1_1.getString(var12_12);
                                    }
                                    if (!var1_1.isNull(var13_13)) break block61;
                                    if (!var1_1.isNull(var14_14)) break block61;
                                    var31_29 = null;
                                    var33_32 = var31_29;
                                    ** GOTO lbl132
                                }
                                if (!var1_1.isNull(var13_13)) break block62;
                                var31_29 = null;
                                break block63;
                            }
                            var31_29 = var1_1.getString(var13_13);
                        }
                        var32_31 = var1_1.getInt(var14_14);
                        var33_32 = v14;
                        v14 = new BasketballTeamStreak(var31_29, var32_31);
lbl132:
                        // 2 sources

                        if (!var1_1.isNull(var15_15)) break block64;
                        if (!var1_1.isNull(var16_16)) break block64;
                        var31_29 = null;
                        var34_33 = var31_29;
                        ** GOTO lbl148
                    }
                    v15 = var1_1;
                    v16 = var16_16;
                    var31_30 = var1_1.getInt(var15_15);
                    var32_31 = v15.getInt(v16);
                    var34_33 = v17;
                    v17 = new BasketballTeamRank(var31_30, var32_31);
lbl148:
                    // 2 sources

                    var17_17.add(new BasketballTeamStanding(var18_18, var20_19, var21_20, (List<String>)var22_21, var23_22, var24_23, var25_24, var27_25, (BasketballTeamStreak)var33_32, (BasketballTeamRank)var34_33, var28_26, var29_27, var30_28));
                    continue;
                }
lbl151:
                // 1 sources

                var1_1.close();
                return var17_17;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Observable<BasketballStandings> getBasketballStandings(String string2) {
        return BasketballDao.DefaultImpls.getBasketballStandings(this, string2);
    }
}

