/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.bumptech.glide.Glide;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.common.views.AspectRatioRoundedFrameLayout;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.VideoPlayerView;
import io.streamlayer.sdk.databinding.SlrTweetViewBinding;
import io.streamlayer.sdk.model.analytics.InteractionActionType;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.model.social.TweetMedia;
import io.streamlayer.sdk.twitter.view.TweetPhotoView;
import io.streamlayer.sdk.twitter.view.TweetVideoView;
import io.streamlayer.sdk.twitter.view.TweetView;
import io.streamlayer.sdk.twitter.view.TweetView$setMedia$;
import io.streamlayer.sdk.twitter.view.internal.format.TweetDateUtils;
import io.streamlayer.sdk.twitter.view.internal.format.TweetFormatter;
import io.streamlayer.sdk.twitter.view.internal.format.TweetLinkifier;
import io.streamlayer.sdk.twitter.view.internal.media.Input;
import io.streamlayer.sdk.twitter.view.internal.media.TweetMediaUtils;
import io.streamlayer.sdk.twitter.view.internal.media.TweetPhotoActivity;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideo;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideoController;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideoPlayerView;
import io.streamlayer.utils.DateUtil;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0018\u001a\u00020\u0015\u0012\n\b\u0002\u0010<\u001a\u0004\u0018\u00010;\u0012\b\b\u0002\u0010=\u001a\u00020 \u00a2\u0006\u0004\b>\u0010?J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u001f\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\f\u0010\u0006J\u0017\u0010\r\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\r\u0010\u0006J!\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011JA\u0010\u001a\u001a\u00028\u0000\"\n\b\u0000\u0010\u0013\u0018\u0001*\u00020\u00122#\b\u0004\u0010\u0019\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00028\u00000\u0014H\u0082\b\u00a2\u0006\u0004\b\u001a\u0010\u001bJ'\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010\u001e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020 8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R$\u0010$\u001a\u0004\u0018\u00010#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0016\u0010+\u001a\u00020*8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,RA\u0010.\u001a!\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0006\u0012\u0004\u0018\u00010-\u0018\u00010\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103RE\u00107\u001a%\u0012\u0013\u0012\u001104\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(5\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0014j\u0004\u0018\u0001`68\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b7\u0010/\u001a\u0004\b8\u00101\"\u0004\b9\u00103R\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010:\u00a8\u0006@"}, d2={"Lio/streamlayer/sdk/twitter/view/TweetView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "Lio/streamlayer/sdk/model/social/Tweet;", "tweet", "", "setName", "(Lio/streamlayer/sdk/model/social/Tweet;)V", "setScreenName", "Lio/streamlayer/sdk/twitter/view/internal/format/TweetFormatter;", "tweetFormatter", "setText", "(Lio/streamlayer/sdk/model/social/Tweet;Lio/streamlayer/sdk/twitter/view/internal/format/TweetFormatter;)V", "setProfilePhotoView", "setTimestamp", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;", "video", "setMedia", "(Lio/streamlayer/sdk/model/social/Tweet;Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;)V", "Landroid/view/View;", "V", "Lkotlin/Function1;", "Landroid/content/Context;", "Lkotlin/ParameterName;", "name", "context", "viewBuilder", "getMediaView", "(Lkotlin/jvm/functions/Function1;)Landroid/view/View;", "showTweet", "(Lio/streamlayer/sdk/model/social/Tweet;Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;Lio/streamlayer/sdk/twitter/view/internal/format/TweetFormatter;)V", "release", "()V", "", "mediaBgColor", "I", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoController;", "videoController", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoController;", "getVideoController", "()Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoController;", "setVideoController", "(Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoController;)V", "Lio/streamlayer/sdk/databinding/SlrTweetViewBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrTweetViewBinding;", "Lio/streamlayer/sdk/VideoPlayerView;", "videoPlayerViewBuilder", "Lkotlin/jvm/functions/Function1;", "getVideoPlayerViewBuilder", "()Lkotlin/jvm/functions/Function1;", "setVideoPlayerViewBuilder", "(Lkotlin/jvm/functions/Function1;)V", "Lio/streamlayer/sdk/model/analytics/InteractionActionType;", "actionType", "Lio/streamlayer/sdk/repository/analytics/InteractionListener;", "interactionListener", "getInteractionListener", "setInteractionListener", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;", "Landroid/util/AttributeSet;", "attrs", "defStyleAttr", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "sdk_originalRelease"})
public final class TweetView
extends ConstraintLayout {
    private final SlrTweetViewBinding binding;
    private final int mediaBgColor;
    @Nullable
    private Function1<? super InteractionActionType, Unit> interactionListener;
    @Nullable
    private TweetVideoController videoController;
    @Nullable
    private Function1<? super Context, ? extends VideoPlayerView> videoPlayerViewBuilder;
    private TweetVideo video;
    private HashMap _$_findViewCache;

    private final void setName(Tweet tweet) {
        AppCompatTextView appCompatTextView = this.binding.slrFullNameView;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"binding.slrFullNameView");
        appCompatTextView.setText((CharSequence)tweet.getMetaData().getAccount());
    }

    private final void setScreenName(Tweet object) {
        object = ((Tweet)object).getMetaData().getAccount();
        TweetView tweetView = tweetView.binding.slrAuthorView;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)tweetView), (String)"binding.slrAuthorView");
        if (object.length() > 0) {
            if (((String)object).charAt(0) != '@') {
                object = '@' + (String)object;
            }
        } else {
            object = "";
        }
        tweetView.setText((CharSequence)object);
    }

    private final void setText(Tweet object, TweetFormatter tweetFormatter) {
        object = TweetLinkifier.INSTANCE.linkifyUrls(tweetFormatter.formatTweetText((Tweet)object));
        TweetView tweetView = tweetView2;
        AppCompatTextView appCompatTextView = tweetView.binding.slrContentView;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"binding.slrContentView");
        appCompatTextView.setText((CharSequence)object);
        TweetView tweetView2 = tweetView.binding.slrContentView;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)tweetView2), (String)"binding.slrContentView");
        boolean bl = object == null || object.length() == 0;
        ExtensionsKt.visibleIf((View)tweetView2, bl ^ true);
    }

    private final void setProfilePhotoView(Tweet tweet) {
        AppCompatImageView appCompatImageView = this.binding.slrAvatarView;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"binding.slrAvatarView");
        Glide.with((Context)appCompatImageView.getContext()).load(StringsKt.replace$default((String)tweet.getMetaData().getAccountImage(), (String)"_normal", (String)"_reasonably_small", (boolean)false, (int)4, null)).into((ImageView)this.binding.slrAvatarView);
    }

    private final void setTimestamp(Tweet object) {
        DateUtil dateUtil;
        if (((Tweet)object).getDate() != null && TweetDateUtils.isValidTimestamp((dateUtil = DateUtil.INSTANCE).fromDateToTwitterString(((Tweet)object).getDate()))) {
            long l = TweetDateUtils.apiTimeToLong(dateUtil.fromDateToTwitterString(((Tweet)object).getDate()));
            object = TweetDateUtils.dotPrefix(TweetDateUtils.getRelativeTimeString(this.getResources(), System.currentTimeMillis(), l));
        } else {
            object = "";
        }
        AppCompatTextView appCompatTextView = this.binding.slrTimestampView;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"binding.slrTimestampView");
        appCompatTextView.setText((CharSequence)object);
    }

    private final void setMedia(Tweet object, TweetVideo object2) {
        ((TweetView)((Object)tweetVideoController2)).release();
        if (object2 != null) {
            Function1<TweetVideo, Long> function1;
            Object object3;
            Function0<TweetVideoView> function0;
            TweetView tweetView = tweetVideoController2;
            AspectRatioRoundedFrameLayout aspectRatioRoundedFrameLayout = tweetView.binding.slrMediaContainer;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)aspectRatioRoundedFrameLayout), (String)"binding.slrMediaContainer");
            ExtensionsKt.visible((View)aspectRatioRoundedFrameLayout);
            object = function0;
            TweetView tweetView2 = tweetVideoController2;
            function0 = new Function0<TweetVideoView>(tweetView2, tweetView2){
                final /* synthetic */ TweetView this$0$inline_fun;
                final /* synthetic */ TweetView this$0;
                {
                    this.this$0$inline_fun = tweetView;
                    this.this$0 = tweetView2;
                    super(0);
                }

                @NotNull
                public final TweetVideoView invoke() {
                    TweetVideoView tweetVideoView;
                    TweetVideoView tweetVideoView2;
                    setMedia$$inlined$getMediaView$1 v0 = this;
                    TweetView.access$getBinding$p((TweetView)v0.this$0$inline_fun).slrMediaContainer.removeAllViews();
                    Intrinsics.checkNotNullExpressionValue((Object)v0.this$0$inline_fun.getContext(), (String)"context");
                    TweetVideoView tweetVideoView3 = tweetVideoView2 = tweetVideoView;
                    Context context = this.this$0.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    tweetVideoView3(context, null, 0, 6, null);
                    tweetVideoView3.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                    TweetView.access$getBinding$p((TweetView)this.this$0$inline_fun).slrMediaContainer.addView((View)tweetVideoView2);
                    return tweetVideoView;
                }
            };
            AspectRatioRoundedFrameLayout aspectRatioRoundedFrameLayout2 = ((TweetView)tweetView).binding.slrMediaContainer;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)aspectRatioRoundedFrameLayout2), (String)"binding.slrMediaContainer");
            if (aspectRatioRoundedFrameLayout2.getChildCount() == 1) {
                object3 = ((TweetView)((Object)tweetVideoController2)).binding.slrMediaContainer.getChildAt(0);
                if (!(object3 instanceof TweetVideoView)) {
                    object3 = (View)object.invoke();
                }
            } else {
                object3 = (View)object.invoke();
            }
            object = (TweetVideoView)object3;
            object3 = ((TweetView)((Object)tweetVideoController2)).videoPlayerViewBuilder;
            if (object3 != null) {
                Context context = tweetVideoController2.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                object3 = (VideoPlayerView)object3.invoke((Object)context);
                if (object3 != null) {
                    ((TweetVideoView)object).setVideoPlayerView((VideoPlayerView)object3);
                }
            }
            Object object4 = object;
            object4.setBackgroundColor(((TweetView)((Object)tweetVideoController2)).mediaBgColor);
            ((TweetVideoView)object4).setOnPlayClicked(new Function0<Unit>((TweetView)((Object)tweetVideoController2), (TweetVideo)object2, (TweetVideoView)object){
                final /* synthetic */ TweetView this$0;
                final /* synthetic */ TweetVideo $video;
                final /* synthetic */ TweetVideoView $videoView;
                {
                    this.this$0 = tweetView;
                    this.$video = tweetVideo;
                    this.$videoView = tweetVideoView;
                    super(0);
                }

                public final void invoke() {
                    Object object = object2.this$0.getInteractionListener();
                    if (object != null) {
                        Unit cfr_ignored_0 = (Unit)object.invoke((Object)((Object)InteractionActionType.TAP));
                    }
                    if ((object = object2.this$0.getVideoController()) != null) {
                        setMedia.2 v0 = object2;
                        Object object2 = v0.$video;
                        object.play((TweetVideo)object2, v0.$videoView);
                    }
                }
            });
            ((TweetVideoView)object4).setOnPauseClicked(new Function0<Unit>((TweetView)((Object)tweetVideoController2), (TweetVideo)object2){
                final /* synthetic */ TweetView this$0;
                final /* synthetic */ TweetVideo $video;
                {
                    this.this$0 = tweetView;
                    this.$video = tweetVideo;
                    super(0);
                }

                public final void invoke() {
                    Object object = this.this$0.getInteractionListener();
                    if (object != null) {
                        Unit cfr_ignored_0 = (Unit)object.invoke((Object)((Object)InteractionActionType.TAP));
                    }
                    if ((object = this.this$0.getVideoController()) != null) {
                        object.pause(this.$video, false);
                    }
                }
            });
            ((TweetVideoView)object4).setOnZoomClicked(new Function0<Unit>((TweetView)((Object)tweetVideoController2), (TweetVideo)object2){
                final /* synthetic */ TweetView this$0;
                final /* synthetic */ TweetVideo $video;
                {
                    this.this$0 = tweetView;
                    this.$video = tweetVideo;
                    super(0);
                }

                public final void invoke() {
                    Object object = this.this$0.getInteractionListener();
                    if (object != null) {
                        Unit cfr_ignored_0 = (Unit)object.invoke((Object)((Object)InteractionActionType.TAP));
                    }
                    if ((object = this.this$0.getVideoController()) != null) {
                        object.zoom(this.$video);
                    }
                }
            });
            object3 = function1;
            function1 = new Function1<TweetVideo, Long>((TweetView)((Object)tweetVideoController2)){
                final /* synthetic */ TweetView this$0;
                {
                    this.this$0 = tweetView;
                    super(1);
                }

                public final long invoke(@NotNull TweetVideo tweetVideo) {
                    Intrinsics.checkNotNullParameter((Object)tweetVideo, (String)"it");
                    TweetVideoController tweetVideoController2 = tweetVideoController2.this$0.getVideoController();
                    return tweetVideoController2 != null ? tweetVideoController2.getRemainedDuration(tweetVideo) : 0L;
                }
            };
            ((TweetVideoView)object).setMediaEntity((TweetVideo)object2, (Function1<? super TweetVideo, Long>)object3);
            TweetVideoController tweetVideoController2 = ((TweetView)((Object)tweetVideoController2)).videoController;
            if (tweetVideoController2 != null) {
                tweetVideoController2.playerViewAttached((TweetVideo)object2, (TweetVideoPlayerView)object);
            }
        } else if (TweetMediaUtils.hasPhoto((Tweet)object)) {
            View view2;
            Function0<TweetPhotoView> function0;
            TweetView tweetView = tweetVideoController2;
            object = TweetMediaUtils.getPhotoEntities((Tweet)object);
            AspectRatioRoundedFrameLayout aspectRatioRoundedFrameLayout = tweetView.binding.slrMediaContainer;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)aspectRatioRoundedFrameLayout), (String)"binding.slrMediaContainer");
            ExtensionsKt.visible((View)aspectRatioRoundedFrameLayout);
            object2 = function0;
            TweetView tweetView3 = tweetVideoController2;
            function0 = new Function0<TweetPhotoView>(tweetView3, tweetView3){
                final /* synthetic */ TweetView this$0$inline_fun;
                final /* synthetic */ TweetView this$0;
                {
                    this.this$0$inline_fun = tweetView;
                    this.this$0 = tweetView2;
                    super(0);
                }

                @NotNull
                public final TweetPhotoView invoke() {
                    TweetPhotoView tweetPhotoView;
                    TweetPhotoView tweetPhotoView2;
                    setMedia$$inlined$getMediaView$2 v0 = this;
                    TweetView.access$getBinding$p((TweetView)v0.this$0$inline_fun).slrMediaContainer.removeAllViews();
                    Intrinsics.checkNotNullExpressionValue((Object)v0.this$0$inline_fun.getContext(), (String)"context");
                    TweetPhotoView tweetPhotoView3 = tweetPhotoView2 = tweetPhotoView;
                    Context context = this.this$0.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    tweetPhotoView3(context, null, 0, 6, null);
                    tweetPhotoView3.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                    TweetView.access$getBinding$p((TweetView)this.this$0$inline_fun).slrMediaContainer.addView((View)tweetPhotoView2);
                    return tweetPhotoView;
                }
            };
            AspectRatioRoundedFrameLayout aspectRatioRoundedFrameLayout3 = ((TweetView)tweetView).binding.slrMediaContainer;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)aspectRatioRoundedFrameLayout3), (String)"binding.slrMediaContainer");
            if (aspectRatioRoundedFrameLayout3.getChildCount() == 1) {
                view2 = ((TweetView)((Object)tweetVideoController2)).binding.slrMediaContainer.getChildAt(0);
                if (!(view2 instanceof TweetPhotoView)) {
                    view2 = (View)object2.invoke();
                }
            } else {
                view2 = (View)object2.invoke();
            }
            object2 = (TweetPhotoView)view2;
            Object object5 = object;
            Object object6 = object2;
            object6.setBackgroundColor(((TweetView)((Object)tweetVideoController2)).mediaBgColor);
            ((TweetPhotoView)((Object)object6)).setOnPhotoClicked((Function1<? super Input, Unit>)new Function1<Input, Unit>((TweetView)((Object)tweetVideoController2)){
                final /* synthetic */ TweetView this$0;
                {
                    this.this$0 = tweetView;
                    super(1);
                }

                public final void invoke(@NotNull Input input) {
                    Intrinsics.checkNotNullParameter((Object)input, (String)"it");
                    Function1<InteractionActionType, Unit> function1 = this.this$0.getInteractionListener();
                    if (function1 != null) {
                        Unit cfr_ignored_0 = (Unit)function1.invoke((Object)((Object)InteractionActionType.TAP));
                    }
                    Context context = this.this$0.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    TweetPhotoActivity.Companion.start(context, input);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"mediaEntities");
            ((TweetPhotoView)((Object)object2)).setMedia((List<TweetMedia>)object5);
        } else {
            AspectRatioRoundedFrameLayout aspectRatioRoundedFrameLayout = ((TweetView)((Object)tweetVideoController2)).binding.slrMediaContainer;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)aspectRatioRoundedFrameLayout), (String)"binding.slrMediaContainer");
            ExtensionsKt.gone((View)aspectRatioRoundedFrameLayout);
        }
    }

    private final /* synthetic */ <V extends View> V getMediaView(Function1<? super Context, ? extends V> viewBuilder) {
        View view2;
        boolean $i$f$getMediaView = false;
        Function0 addView2 = new Function0<V>(this, viewBuilder){
            final /* synthetic */ TweetView this$0;
            final /* synthetic */ Function1 $viewBuilder;
            {
                this.this$0 = tweetView;
                this.$viewBuilder = function1;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final V invoke() {
                void var1_1;
                TweetView.access$getBinding$p((TweetView)this.this$0).slrMediaContainer.removeAllViews();
                Context context = this.this$0.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                View view2 = (View)this.$viewBuilder.invoke((Object)context);
                view2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                TweetView.access$getBinding$p((TweetView)this.this$0).slrMediaContainer.addView(view2);
                return var1_1;
            }
        };
        AspectRatioRoundedFrameLayout aspectRatioRoundedFrameLayout = ((TweetView)this).binding.slrMediaContainer;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)aspectRatioRoundedFrameLayout), (String)"binding.slrMediaContainer");
        if (aspectRatioRoundedFrameLayout.getChildCount() == 1) {
            View view3 = ((TweetView)this).binding.slrMediaContainer.getChildAt(0);
            Intrinsics.reifiedOperationMarker((int)3, (String)"V");
            view2 = view3 instanceof View ? view3 : (View)addView2.invoke();
        } else {
            view2 = (View)addView2.invoke();
        }
        return (V)view2;
    }

    @JvmOverloads
    public TweetView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        int n2;
        TweetView tweetView = object;
        TweetView tweetView2 = object;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n);
        Object object = SlrTweetViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)object);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SlrTweetViewBinding.infl\u2026ater.from(context), this)");
        tweetView2.binding = object;
        tweetView.mediaBgColor = n2 = ContextCompat.getColor((Context)context, (int)R.color.slr_tweet_media);
        Object object2 = object;
        ((SlrTweetViewBinding)object2).slrAvatarContainer.setCornerRadius(ExtensionsKt.getDp(4.0f));
        ((SlrTweetViewBinding)object2).slrAvatarView.setBackgroundColor(n2);
        ((SlrTweetViewBinding)object2).slrMediaContainer.setAspectRatio(1.7777777777777777);
        ((SlrTweetViewBinding)object2).slrMediaContainer.setCornerRadius(ExtensionsKt.getDp(4.0f));
    }

    public /* synthetic */ TweetView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public TweetView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public TweetView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    @Nullable
    public final Function1<InteractionActionType, Unit> getInteractionListener() {
        return this.interactionListener;
    }

    public final void setInteractionListener(@Nullable Function1<? super InteractionActionType, Unit> function1) {
        this.interactionListener = function1;
    }

    @Nullable
    public final TweetVideoController getVideoController() {
        return this.videoController;
    }

    public final void setVideoController(@Nullable TweetVideoController tweetVideoController2) {
        this.videoController = tweetVideoController2;
    }

    @Nullable
    public final Function1<Context, VideoPlayerView> getVideoPlayerViewBuilder() {
        return this.videoPlayerViewBuilder;
    }

    public final void setVideoPlayerViewBuilder(@Nullable Function1<? super Context, ? extends VideoPlayerView> function1) {
        this.videoPlayerViewBuilder = function1;
    }

    public final void showTweet(@NotNull Tweet tweet, @Nullable TweetVideo tweetVideo, @NotNull TweetFormatter tweetFormatter) {
        TweetView tweetView = this;
        Intrinsics.checkNotNullParameter((Object)tweet, (String)"tweet");
        Intrinsics.checkNotNullParameter((Object)tweetFormatter, (String)"tweetFormatter");
        tweetView.setProfilePhotoView(tweet);
        tweetView.setName(tweet);
        tweetView.setScreenName(tweet);
        tweetView.setTimestamp(tweet);
        tweetView.setText(tweet, tweetFormatter);
        tweetView.setMedia(tweet, tweetVideo);
        tweetView.video = tweetVideo;
    }

    public final void release() {
        TweetVideo tweetVideo = ((TweetView)((Object)this)).video;
        if (tweetVideo != null && (this = ((TweetView)((Object)this)).videoController) != null) {
            this.pause(tweetVideo, true);
        }
    }

    public View _$_findCachedViewById(int n) {
        View view2;
        if (this._$_findViewCache == null) {
            View view3;
            view2 = view3;
            view3 = new HashMap();
            this._$_findViewCache = view2;
        }
        if ((view2 = (View)this._$_findViewCache.get(n)) == null) {
            TweetView tweetView = this;
            view2 = tweetView.findViewById(n);
            tweetView._$_findViewCache.put(n, view2);
        }
        return view2;
    }

    public void _$_clearFindViewByIdCache() {
        HashMap hashMap = ((TweetView)((Object)hashMap))._$_findViewCache;
        if (hashMap != null) {
            hashMap.clear();
        }
    }
}

