/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import io.streamlayer.utils.SLRLog;
import io.streamlayer.utils.ViewExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u0015\u0010\u0002\u001a\u00020\u0001*\u0004\u0018\u00010\u0000H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0015\u0010\u0004\u001a\u00020\u0001*\u0004\u0018\u00010\u0000H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0003\u001a\u001d\u0010\u0007\u001a\u00020\u0001*\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a'\u0010\f\u001a\u00020\u0001*\u00020\t2\u0012\b\u0002\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\nH\u0000\u00a2\u0006\u0004\b\f\u0010\r\u001a\u001d\u0010\u0011\u001a\u00020\u0001*\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u000fH\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Landroid/view/View;", "", "hideKeyboard", "(Landroid/view/View;)V", "showKeyboard", "", "durationMs", "hapticTouch", "(Landroid/view/View;J)V", "Landroid/widget/EditText;", "Lkotlin/Function0;", "block", "defaultActionListener", "(Landroid/widget/EditText;Lkotlin/jvm/functions/Function0;)V", "Landroid/widget/ProgressBar;", "", "color", "setIndeterminateTintCompat", "(Landroid/widget/ProgressBar;I)V", "sdk_originalRelease"})
public final class ViewExtensionsKt {
    public static final void hideKeyboard(@Nullable View view2) {
        if (view2 != null) {
            Context context = view2.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            InputMethodManager inputMethodManager = (InputMethodManager)ContextCompat.getSystemService((Context)context, InputMethodManager.class);
            if (inputMethodManager != null) {
                inputMethodManager.hideSoftInputFromWindow(view2.getWindowToken(), 0);
            }
        }
    }

    public static final void showKeyboard(@Nullable View view2) {
        if (view2 != null && view2.requestFocus()) {
            Context context = view2.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            InputMethodManager inputMethodManager = (InputMethodManager)ContextCompat.getSystemService((Context)context, InputMethodManager.class);
            if (inputMethodManager != null) {
                inputMethodManager.showSoftInput(view2, 0);
            }
        }
    }

    public static final void hapticTouch(@NotNull View object, long l) {
        View view2 = object;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"$this$hapticTouch");
        object = view2.getContext().getSystemService("vibrator");
        if (object != null) {
            object = (Vibrator)object;
            if (Build.VERSION.SDK_INT >= 26) {
                try {
                    object.vibrate(VibrationEffect.createOneShot((long)l, (int)100));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    SLRLog.INSTANCE.d("Vibrator", "Failed to create VibrationEffect");
                }
            } else {
                object.vibrate(l);
            }
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type android.os.Vibrator");
    }

    public static /* synthetic */ void hapticTouch$default(View view2, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 100L;
        }
        ViewExtensionsKt.hapticTouch(view2, l);
    }

    public static final void defaultActionListener(@NotNull EditText editText, @Nullable Function0<Unit> function0) {
        TextView.OnEditorActionListener onEditorActionListener;
        EditText editText2 = editText;
        Intrinsics.checkNotNullParameter((Object)editText2, (String)"$this$defaultActionListener");
        TextView.OnEditorActionListener onEditorActionListener2 = onEditorActionListener;
        onEditorActionListener = new TextView.OnEditorActionListener(editText, function0){
            final /* synthetic */ EditText $this_defaultActionListener;
            final /* synthetic */ Function0 $block;
            {
                this.$this_defaultActionListener = editText;
                this.$block = function0;
            }

            public final boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
                if (CollectionsKt.listOf((Object[])new Integer[]{6, 2, 5, 3, 4}).contains(n)) {
                    defaultActionListener.1 v0 = this_;
                    ViewExtensionsKt.hideKeyboard((View)v0.$this_defaultActionListener);
                    v0.$this_defaultActionListener.clearFocus();
                    defaultActionListener.1 this_ = v0.$block;
                    if (this_ != null) {
                        Unit cfr_ignored_0 = (Unit)this_.invoke();
                    }
                    return true;
                }
                return false;
            }
        };
        editText2.setOnEditorActionListener(onEditorActionListener2);
    }

    public static /* synthetic */ void defaultActionListener$default(EditText editText, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = null;
        }
        ViewExtensionsKt.defaultActionListener(editText, (Function0<Unit>)function0);
    }

    public static final void setIndeterminateTintCompat(@NotNull ProgressBar progressBar, @ColorInt int n) {
        Intrinsics.checkNotNullParameter((Object)progressBar, (String)"$this$setIndeterminateTintCompat");
        if (Build.VERSION.SDK_INT < 21) {
            ProgressBar progressBar2 = progressBar;
            Drawable drawable2 = DrawableCompat.wrap((Drawable)progressBar2.getIndeterminateDrawable());
            DrawableCompat.setTint((Drawable)drawable2, (int)n);
            progressBar2.setIndeterminateDrawable(DrawableCompat.unwrap((Drawable)drawable2));
            progressBar.setProgressTintList(ColorStateList.valueOf((int)n));
        } else {
            progressBar.setIndeterminateTintList(ColorStateList.valueOf((int)n));
            progressBar.setProgressTintList(ColorStateList.valueOf((int)n));
        }
    }
}

