/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.sports.events;

import android.database.Cursor;
import androidx.collection.LongSparseArray;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.sports.EventPeriod;
import io.streamlayer.sdk.model.sports.EventScheduleAttributes;
import io.streamlayer.sdk.model.sports.EventScheduleAttributesRelation;
import io.streamlayer.sdk.model.sports.EventScheduleData;
import io.streamlayer.sdk.model.sports.EventScheduleDataRelation;
import io.streamlayer.sdk.model.sports.EventStatus;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.sdk.model.sports.EventSummaryAwayEventTeamCrossRef;
import io.streamlayer.sdk.model.sports.EventSummaryHomeEventTeamCrossRef;
import io.streamlayer.sdk.model.sports.EventSummaryRelation;
import io.streamlayer.sdk.model.sports.EventSummaryResponseData;
import io.streamlayer.sdk.model.sports.EventSummaryResponseDataRelation;
import io.streamlayer.sdk.model.sports.EventTeam;
import io.streamlayer.sdk.model.sports.EventTime;
import io.streamlayer.sdk.model.sports.EventType;
import io.streamlayer.sdk.model.sports.LeagueScheduleDate;
import io.streamlayer.sdk.model.sports.TeamRecord;
import io.streamlayer.sdk.model.sports.baseball.BaseballEventScore;
import io.streamlayer.sdk.model.sports.basketball.BasketballBoxScore;
import io.streamlayer.sdk.model.sports.basketball.BasketballEventScore;
import io.streamlayer.sdk.model.sports.basketball.BasketballEventSummary;
import io.streamlayer.sdk.model.sports.basketball.BasketballPerformers;
import io.streamlayer.sdk.model.sports.basketball.BasketballPlayByPlay;
import io.streamlayer.sdk.model.sports.basketball.BasketballPlayByPlayStatistics;
import io.streamlayer.sdk.model.sports.basketball.BasketballStandings;
import io.streamlayer.sdk.model.sports.basketball.BasketballSummary;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamRank;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamStanding;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamStreak;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamSummary;
import io.streamlayer.sdk.model.sports.basketball.PlayerScores;
import io.streamlayer.sdk.model.sports.hockey.HockeyEventScore;
import io.streamlayer.sdk.repository.sports.events.SportEventsDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import kotlinx.coroutines.flow.Flow;

public final class SportEventsDao_Impl
implements SportEventsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EventSummaryResponseData> __insertionAdapterOfEventSummaryResponseData;
    private final Converters __converters;
    private final EntityInsertionAdapter<EventTeam> __insertionAdapterOfEventTeam;
    private final EntityInsertionAdapter<EventSummary> __insertionAdapterOfEventSummary;
    private final EntityInsertionAdapter<EventSummaryHomeEventTeamCrossRef> __insertionAdapterOfEventSummaryHomeEventTeamCrossRef;
    private final EntityInsertionAdapter<EventSummaryAwayEventTeamCrossRef> __insertionAdapterOfEventSummaryAwayEventTeamCrossRef;
    private final EntityInsertionAdapter<EventScheduleData> __insertionAdapterOfEventScheduleData;
    private final EntityInsertionAdapter<EventScheduleAttributes> __insertionAdapterOfEventScheduleAttributes;
    private final EntityInsertionAdapter<LeagueScheduleDate> __insertionAdapterOfLeagueScheduleDate;
    private final EntityInsertionAdapter<BasketballEventSummary> __insertionAdapterOfBasketballEventSummary;
    private final EntityInsertionAdapter<BasketballBoxScore> __insertionAdapterOfBasketballBoxScore;
    private final EntityInsertionAdapter<BasketballPlayByPlay> __insertionAdapterOfBasketballPlayByPlay;
    private final EntityInsertionAdapter<BasketballTeamStanding> __insertionAdapterOfBasketballTeamStanding;
    private final EntityDeletionOrUpdateAdapter<EventSummaryResponseData> __deletionAdapterOfEventSummaryResponseData;
    private final EntityDeletionOrUpdateAdapter<EventTeam> __deletionAdapterOfEventTeam;
    private final EntityDeletionOrUpdateAdapter<EventSummary> __deletionAdapterOfEventSummary;
    private final EntityDeletionOrUpdateAdapter<BasketballEventSummary> __deletionAdapterOfBasketballEventSummary;
    private final EntityDeletionOrUpdateAdapter<BasketballBoxScore> __deletionAdapterOfBasketballBoxScore;
    private final EntityDeletionOrUpdateAdapter<BasketballPlayByPlay> __deletionAdapterOfBasketballPlayByPlay;
    private final EntityDeletionOrUpdateAdapter<EventSummaryResponseData> __updateAdapterOfEventSummaryResponseData;
    private final EntityDeletionOrUpdateAdapter<EventTeam> __updateAdapterOfEventTeam;
    private final EntityDeletionOrUpdateAdapter<EventSummary> __updateAdapterOfEventSummary;
    private final EntityDeletionOrUpdateAdapter<BasketballEventSummary> __updateAdapterOfBasketballEventSummary;
    private final EntityDeletionOrUpdateAdapter<BasketballBoxScore> __updateAdapterOfBasketballBoxScore;
    private final EntityDeletionOrUpdateAdapter<BasketballPlayByPlay> __updateAdapterOfBasketballPlayByPlay;
    private final EntityDeletionOrUpdateAdapter<BasketballTeamStanding> __updateAdapterOfBasketballTeamStanding;
    private final SharedSQLiteStatement __preparedStmtOfDeleteEventSchedules;
    private final SharedSQLiteStatement __preparedStmtOfDeleteScheduleDates;
    private final SharedSQLiteStatement __preparedStmtOfDeleteBasketballStandings;

    public SportEventsDao_Impl(RoomDatabase roomDatabase) {
        SharedSQLiteStatement sharedSQLiteStatement;
        SharedSQLiteStatement sharedSQLiteStatement2;
        SharedSQLiteStatement sharedSQLiteStatement3;
        EntityDeletionOrUpdateAdapter<BasketballTeamStanding> entityDeletionOrUpdateAdapter;
        EntityDeletionOrUpdateAdapter<BasketballPlayByPlay> entityDeletionOrUpdateAdapter2;
        EntityDeletionOrUpdateAdapter<BasketballBoxScore> entityDeletionOrUpdateAdapter3;
        EntityDeletionOrUpdateAdapter<BasketballEventSummary> entityDeletionOrUpdateAdapter4;
        EntityDeletionOrUpdateAdapter<EventSummary> entityDeletionOrUpdateAdapter5;
        EntityDeletionOrUpdateAdapter<EventTeam> entityDeletionOrUpdateAdapter6;
        EntityDeletionOrUpdateAdapter<EventSummaryResponseData> entityDeletionOrUpdateAdapter7;
        EntityDeletionOrUpdateAdapter<BasketballPlayByPlay> entityDeletionOrUpdateAdapter8;
        EntityDeletionOrUpdateAdapter<BasketballBoxScore> entityDeletionOrUpdateAdapter9;
        EntityDeletionOrUpdateAdapter<BasketballEventSummary> entityDeletionOrUpdateAdapter10;
        EntityDeletionOrUpdateAdapter<EventSummary> entityDeletionOrUpdateAdapter11;
        EntityDeletionOrUpdateAdapter<EventTeam> entityDeletionOrUpdateAdapter12;
        EntityDeletionOrUpdateAdapter<EventSummaryResponseData> entityDeletionOrUpdateAdapter13;
        EntityInsertionAdapter<BasketballTeamStanding> entityInsertionAdapter;
        EntityInsertionAdapter<BasketballPlayByPlay> entityInsertionAdapter2;
        EntityInsertionAdapter<BasketballBoxScore> entityInsertionAdapter3;
        EntityInsertionAdapter<BasketballEventSummary> entityInsertionAdapter4;
        EntityInsertionAdapter<LeagueScheduleDate> entityInsertionAdapter5;
        EntityInsertionAdapter<EventScheduleAttributes> entityInsertionAdapter6;
        EntityInsertionAdapter<EventScheduleData> entityInsertionAdapter7;
        EntityInsertionAdapter<EventSummaryAwayEventTeamCrossRef> entityInsertionAdapter8;
        EntityInsertionAdapter<EventSummaryHomeEventTeamCrossRef> entityInsertionAdapter9;
        EntityInsertionAdapter<EventSummary> entityInsertionAdapter10;
        EntityInsertionAdapter<EventTeam> entityInsertionAdapter11;
        EntityInsertionAdapter<EventSummaryResponseData> entityInsertionAdapter12;
        Converters converters;
        Converters converters2 = converters;
        converters = new Converters();
        this.__converters = converters2;
        this.__db = roomDatabase;
        converters2 = entityInsertionAdapter12;
        entityInsertionAdapter12 = new EntityInsertionAdapter<EventSummaryResponseData>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `EventSummaryResponseData` (`eventSummaryResponseDataId`,`type`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummaryResponseData eventSummaryResponseData) {
                long l = eventSummaryResponseData.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.SportEventsDao_Impl.this.__converters.eventTypeToString(eventSummaryResponseData.getType());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
            }
        };
        this.__insertionAdapterOfEventSummaryResponseData = converters2;
        converters2 = entityInsertionAdapter11;
        entityInsertionAdapter11 = new EntityInsertionAdapter<EventTeam>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `EventTeam` (`eventTeamId`,`name`,`alias`,`logo`,`colors`,`isWinner`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventTeam eventTeam) {
                long l = eventTeam.getId();
                supportSQLiteStatement.bindLong(1, l);
                if (eventTeam.getName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, eventTeam.getName());
                }
                if (eventTeam.getAlias() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, eventTeam.getAlias());
                }
                if (eventTeam.getLogo() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, eventTeam.getLogo());
                }
                Object object = object.SportEventsDao_Impl.this.__converters.stringListToString(eventTeam.getColors());
                if (object == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, (String)object);
                }
                long l2 = (long)eventTeam.isWinner();
                supportSQLiteStatement.bindLong(6, l2);
            }
        };
        this.__insertionAdapterOfEventTeam = converters2;
        converters2 = entityInsertionAdapter10;
        entityInsertionAdapter10 = new EntityInsertionAdapter<EventSummary>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `EventSummary` (`scheduleDateString`,`scheduleDate`,`eventSummaryId`,`scheduled`,`league`,`homeScore`,`awayScore`,`homeTeamId`,`awayTeamId`,`status`,`periods`,`periodsCount`,`clock`,`period`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummary eventSummary) {
                Object object = eventSummary.scheduledDateString;
                if (object == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, (String)object);
                }
                object = object2.SportEventsDao_Impl.this.__converters.dateToString(eventSummary.scheduleDate);
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    long l = (Long)object;
                    supportSQLiteStatement.bindLong(2, l);
                }
                long l = eventSummary.getId();
                supportSQLiteStatement.bindLong(3, l);
                if (eventSummary.getScheduled() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, eventSummary.getScheduled());
                }
                if (eventSummary.getLeague() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, eventSummary.getLeague());
                }
                l = eventSummary.getHomeScore();
                supportSQLiteStatement.bindLong(6, l);
                l = eventSummary.getAwayScore();
                supportSQLiteStatement.bindLong(7, l);
                l = eventSummary.getHomeTeamId();
                supportSQLiteStatement.bindLong(8, l);
                l = eventSummary.getAwayTeamId();
                supportSQLiteStatement.bindLong(9, l);
                String string2 = object2.SportEventsDao_Impl.this.__converters.eventStatusToString(eventSummary.getStatus());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, string2);
                }
                Object object2 = object2.SportEventsDao_Impl.this.__converters.eventPeriodsToString(eventSummary.getPeriods());
                if (object2 == null) {
                    supportSQLiteStatement.bindNull(11);
                } else {
                    supportSQLiteStatement.bindString(11, (String)object2);
                }
                long l2 = eventSummary.getPeriodsCount();
                supportSQLiteStatement.bindLong(12, l2);
                object2 = eventSummary.getEventTime();
                if (object2 != null) {
                    if (((EventTime)object2).getClock() == null) {
                        supportSQLiteStatement.bindNull(13);
                    } else {
                        supportSQLiteStatement.bindString(13, ((EventTime)object2).getClock());
                    }
                    long l3 = ((EventTime)object2).getPeriod();
                    supportSQLiteStatement.bindLong(14, l3);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(13);
                    supportSQLiteStatement2.bindNull(14);
                }
            }
        };
        this.__insertionAdapterOfEventSummary = converters2;
        converters2 = entityInsertionAdapter9;
        entityInsertionAdapter9 = new EntityInsertionAdapter<EventSummaryHomeEventTeamCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `EventSummaryHomeEventTeamCrossRef` (`eventSummaryId`,`eventTeamId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummaryHomeEventTeamCrossRef eventSummaryHomeEventTeamCrossRef) {
                long l = eventSummaryHomeEventTeamCrossRef.getEventSummaryId();
                supportSQLiteStatement.bindLong(1, l);
                l = eventSummaryHomeEventTeamCrossRef.getEventTeamId();
                supportSQLiteStatement.bindLong(2, l);
            }
        };
        this.__insertionAdapterOfEventSummaryHomeEventTeamCrossRef = converters2;
        converters2 = entityInsertionAdapter8;
        entityInsertionAdapter8 = new EntityInsertionAdapter<EventSummaryAwayEventTeamCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `EventSummaryAwayEventTeamCrossRef` (`eventSummaryId`,`eventTeamId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummaryAwayEventTeamCrossRef eventSummaryAwayEventTeamCrossRef) {
                long l = eventSummaryAwayEventTeamCrossRef.getEventSummaryId();
                supportSQLiteStatement.bindLong(1, l);
                l = eventSummaryAwayEventTeamCrossRef.getEventTeamId();
                supportSQLiteStatement.bindLong(2, l);
            }
        };
        this.__insertionAdapterOfEventSummaryAwayEventTeamCrossRef = converters2;
        converters2 = entityInsertionAdapter7;
        entityInsertionAdapter7 = new EntityInsertionAdapter<EventScheduleData>(roomDatabase){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `EventScheduleData` (`eventScheduleDataId`,`type`,`attributesId`) VALUES (?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventScheduleData eventScheduleData) {
                long l = eventScheduleData.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.SportEventsDao_Impl.this.__converters.eventTypeToString(eventScheduleData.getType());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
                long l2 = eventScheduleData.getAttributesId();
                supportSQLiteStatement.bindLong(3, l2);
            }
        };
        this.__insertionAdapterOfEventScheduleData = converters2;
        converters2 = entityInsertionAdapter6;
        entityInsertionAdapter6 = new EntityInsertionAdapter<EventScheduleAttributes>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `EventScheduleAttributes` (`eventScheduleAttributesId`,`basketballhomeTeamRecord`,`basketballawayTeamRecord`,`baseballouts`,`baseballinning`,`baseballinningDivision`,`baseballdelayed`,`baseballreasonForDelay`,`baseballtakenBases`,`baseballhomeTeamRecord`,`baseballawayTeamRecord`,`hockeyhomeTeamRecord`,`hockeyawayTeamRecord`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventScheduleAttributes object) {
                long l = ((EventScheduleAttributes)object).getSummaryId();
                supportSQLiteStatement.bindLong(1, l);
                Object object2 = ((EventScheduleAttributes)object).getBasketballScore();
                if (object2 != null) {
                    String string2 = object3.SportEventsDao_Impl.this.__converters.teamRecordToString(((BasketballEventScore)object2).getHomeTeamRecord());
                    if (string2 == null) {
                        supportSQLiteStatement.bindNull(2);
                    } else {
                        supportSQLiteStatement.bindString(2, string2);
                    }
                    object2 = object3.SportEventsDao_Impl.this.__converters.teamRecordToString(((BasketballEventScore)object2).getAwayTeamRecord());
                    if (object2 == null) {
                        supportSQLiteStatement.bindNull(3);
                    } else {
                        supportSQLiteStatement.bindString(3, (String)object2);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(2);
                    supportSQLiteStatement2.bindNull(3);
                }
                object2 = ((EventScheduleAttributes)object).getBaseballEventScore();
                if (object2 != null) {
                    long l2 = ((BaseballEventScore)object2).getOuts();
                    supportSQLiteStatement.bindLong(4, l2);
                    l2 = ((BaseballEventScore)object2).getInning();
                    supportSQLiteStatement.bindLong(5, l2);
                    if (((BaseballEventScore)object2).getInningDivision() == null) {
                        supportSQLiteStatement.bindNull(6);
                    } else {
                        supportSQLiteStatement.bindString(6, ((BaseballEventScore)object2).getInningDivision());
                    }
                    l2 = (long)((BaseballEventScore)object2).getDelayed();
                    supportSQLiteStatement.bindLong(7, l2);
                    if (((BaseballEventScore)object2).getReasonForDelay() == null) {
                        supportSQLiteStatement.bindNull(8);
                    } else {
                        supportSQLiteStatement.bindString(8, ((BaseballEventScore)object2).getReasonForDelay());
                    }
                    l2 = ((BaseballEventScore)object2).getTakenBases();
                    supportSQLiteStatement.bindLong(9, l2);
                    String string3 = object3.SportEventsDao_Impl.this.__converters.teamRecordToString(((BaseballEventScore)object2).getHomeTeamRecord());
                    if (string3 == null) {
                        supportSQLiteStatement.bindNull(10);
                    } else {
                        supportSQLiteStatement.bindString(10, string3);
                    }
                    object2 = object3.SportEventsDao_Impl.this.__converters.teamRecordToString(((BaseballEventScore)object2).getAwayTeamRecord());
                    if (object2 == null) {
                        supportSQLiteStatement.bindNull(11);
                    } else {
                        supportSQLiteStatement.bindString(11, (String)object2);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                    supportSQLiteStatement3.bindNull(4);
                    supportSQLiteStatement3.bindNull(5);
                    supportSQLiteStatement3.bindNull(6);
                    supportSQLiteStatement3.bindNull(7);
                    supportSQLiteStatement3.bindNull(8);
                    supportSQLiteStatement3.bindNull(9);
                    supportSQLiteStatement3.bindNull(10);
                    supportSQLiteStatement3.bindNull(11);
                }
                object = ((EventScheduleAttributes)object).getHockeyEventScore();
                if (object != null) {
                    object2 = object3.SportEventsDao_Impl.this.__converters.teamRecordToString(((HockeyEventScore)object).getHomeTeamRecord());
                    if (object2 == null) {
                        supportSQLiteStatement.bindNull(12);
                    } else {
                        supportSQLiteStatement.bindString(12, (String)object2);
                    }
                    Object object3 = object3.SportEventsDao_Impl.this.__converters.teamRecordToString(((HockeyEventScore)object).getAwayTeamRecord());
                    if (object3 == null) {
                        supportSQLiteStatement.bindNull(13);
                    } else {
                        supportSQLiteStatement.bindString(13, (String)object3);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement4 = supportSQLiteStatement;
                    supportSQLiteStatement4.bindNull(12);
                    supportSQLiteStatement4.bindNull(13);
                }
            }
        };
        this.__insertionAdapterOfEventScheduleAttributes = converters2;
        converters2 = entityInsertionAdapter5;
        entityInsertionAdapter5 = new EntityInsertionAdapter<LeagueScheduleDate>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `LeagueScheduleDate` (`scheduleLeague`,`scheduleDate`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, LeagueScheduleDate leagueScheduleDate) {
                if (leagueScheduleDate.getScheduleLeague() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, leagueScheduleDate.getScheduleLeague());
                }
                if (leagueScheduleDate.getScheduleDate() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, leagueScheduleDate.getScheduleDate());
                }
            }
        };
        this.__insertionAdapterOfLeagueScheduleDate = converters2;
        converters2 = entityInsertionAdapter4;
        entityInsertionAdapter4 = new EntityInsertionAdapter<BasketballEventSummary>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `BasketballEventSummary` (`basketballEventSummaryId`,`performers`,`homeTeamfieldGoalPercentage`,`homeTeamthreePtsPercentage`,`homeTeamfreeThrowPercentage`,`homeTeamassists`,`homeTeamrebounds`,`awayTeamfieldGoalPercentage`,`awayTeamthreePtsPercentage`,`awayTeamfreeThrowPercentage`,`awayTeamassists`,`awayTeamrebounds`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballEventSummary object) {
                long l = ((BasketballEventSummary)object).getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object2 = object2.SportEventsDao_Impl.this.__converters.basketballPerfomersToString(((BasketballEventSummary)object).getPerformers());
                if (object2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object2);
                }
                object2 = ((BasketballEventSummary)object).getSummary();
                if (object2 != null) {
                    object = ((BasketballSummary)object2).getHomeTeamStatistics();
                    if (object != null) {
                        double d = ((BasketballTeamSummary)object).getFieldGoalPercentage();
                        supportSQLiteStatement.bindDouble(3, d);
                        d = ((BasketballTeamSummary)object).getThreePtsPercentage();
                        supportSQLiteStatement.bindDouble(4, d);
                        d = ((BasketballTeamSummary)object).getFreeThrowPercentage();
                        supportSQLiteStatement.bindDouble(5, d);
                        long l2 = ((BasketballTeamSummary)object).getAssists();
                        supportSQLiteStatement.bindLong(6, l2);
                        l2 = ((BasketballTeamSummary)object).getRebounds();
                        supportSQLiteStatement.bindLong(7, l2);
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                        supportSQLiteStatement2.bindNull(3);
                        supportSQLiteStatement2.bindNull(4);
                        supportSQLiteStatement2.bindNull(5);
                        supportSQLiteStatement2.bindNull(6);
                        supportSQLiteStatement2.bindNull(7);
                    }
                    object2 = ((BasketballSummary)object2).getAwayTeamStatistics();
                    if (object2 != null) {
                        double d = ((BasketballTeamSummary)object2).getFieldGoalPercentage();
                        supportSQLiteStatement.bindDouble(8, d);
                        d = ((BasketballTeamSummary)object2).getThreePtsPercentage();
                        supportSQLiteStatement.bindDouble(9, d);
                        d = ((BasketballTeamSummary)object2).getFreeThrowPercentage();
                        supportSQLiteStatement.bindDouble(10, d);
                        long l3 = ((BasketballTeamSummary)object2).getAssists();
                        supportSQLiteStatement.bindLong(11, l3);
                        l3 = ((BasketballTeamSummary)object2).getRebounds();
                        supportSQLiteStatement.bindLong(12, l3);
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                        supportSQLiteStatement3.bindNull(8);
                        supportSQLiteStatement3.bindNull(9);
                        supportSQLiteStatement3.bindNull(10);
                        supportSQLiteStatement3.bindNull(11);
                        supportSQLiteStatement3.bindNull(12);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement4 = supportSQLiteStatement;
                    supportSQLiteStatement4.bindNull(3);
                    supportSQLiteStatement4.bindNull(4);
                    supportSQLiteStatement4.bindNull(5);
                    supportSQLiteStatement4.bindNull(6);
                    supportSQLiteStatement4.bindNull(7);
                    supportSQLiteStatement4.bindNull(8);
                    supportSQLiteStatement4.bindNull(9);
                    supportSQLiteStatement4.bindNull(10);
                    supportSQLiteStatement4.bindNull(11);
                    supportSQLiteStatement4.bindNull(12);
                }
            }
        };
        this.__insertionAdapterOfBasketballEventSummary = converters2;
        converters2 = entityInsertionAdapter3;
        entityInsertionAdapter3 = new EntityInsertionAdapter<BasketballBoxScore>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `BasketballBoxScore` (`basketballBoxScoreId`,`homePlayerScores`,`awayPlayerScore`) VALUES (?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballBoxScore basketballBoxScore) {
                long l = basketballBoxScore.getId();
                supportSQLiteStatement.bindLong(1, l);
                String string2 = object.SportEventsDao_Impl.this.__converters.playerScoresToString(basketballBoxScore.getHomePlayerScores());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, string2);
                }
                Object object = object.SportEventsDao_Impl.this.__converters.playerScoresToString(basketballBoxScore.getAwayPlayerScore());
                if (object == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, (String)object);
                }
            }
        };
        this.__insertionAdapterOfBasketballBoxScore = converters2;
        converters2 = entityInsertionAdapter2;
        entityInsertionAdapter2 = new EntityInsertionAdapter<BasketballPlayByPlay>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `BasketballPlayByPlay` (`basketballPlayByPlayId`,`statistics`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballPlayByPlay basketballPlayByPlay) {
                long l = basketballPlayByPlay.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.SportEventsDao_Impl.this.__converters.playByPlayStatisticsToString(basketballPlayByPlay.getStatistics());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
            }
        };
        this.__insertionAdapterOfBasketballPlayByPlay = converters2;
        converters2 = entityInsertionAdapter;
        entityInsertionAdapter = new EntityInsertionAdapter<BasketballTeamStanding>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `BasketballTeamStanding` (`id`,`teamName`,`teamIcon`,`colors`,`wins`,`losses`,`percentage`,`gamesBehind`,`division`,`conference`,`league`,`streakkind`,`streaklength`,`rankdivision`,`rankconference`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballTeamStanding basketballTeamStanding) {
                long l = basketballTeamStanding.getId();
                supportSQLiteStatement.bindLong(1, l);
                if (basketballTeamStanding.getTeamName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, basketballTeamStanding.getTeamName());
                }
                if (basketballTeamStanding.getTeamIcon() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, basketballTeamStanding.getTeamIcon());
                }
                Object object = object.SportEventsDao_Impl.this.__converters.stringListToString(basketballTeamStanding.getColors());
                if (object == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, (String)object);
                }
                l = basketballTeamStanding.getWins();
                supportSQLiteStatement.bindLong(5, l);
                l = basketballTeamStanding.getLosses();
                supportSQLiteStatement.bindLong(6, l);
                double d = basketballTeamStanding.getPercentage();
                supportSQLiteStatement.bindDouble(7, d);
                long l2 = basketballTeamStanding.getGamesBehind();
                supportSQLiteStatement.bindLong(8, l2);
                if (basketballTeamStanding.getDivision() == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, basketballTeamStanding.getDivision());
                }
                if (basketballTeamStanding.getConference() == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, basketballTeamStanding.getConference());
                }
                if (basketballTeamStanding.getLeague() == null) {
                    supportSQLiteStatement.bindNull(11);
                } else {
                    supportSQLiteStatement.bindString(11, basketballTeamStanding.getLeague());
                }
                object = basketballTeamStanding.getStreak();
                if (object != null) {
                    if (((BasketballTeamStreak)object).getKind() == null) {
                        supportSQLiteStatement.bindNull(12);
                    } else {
                        supportSQLiteStatement.bindString(12, ((BasketballTeamStreak)object).getKind());
                    }
                    l2 = ((BasketballTeamStreak)object).getLength();
                    supportSQLiteStatement.bindLong(13, l2);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(12);
                    supportSQLiteStatement2.bindNull(13);
                }
                object = basketballTeamStanding.getRank();
                if (object != null) {
                    long l3 = ((BasketballTeamRank)object).getDivision();
                    supportSQLiteStatement.bindLong(14, l3);
                    l3 = ((BasketballTeamRank)object).getConference();
                    supportSQLiteStatement.bindLong(15, l3);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                    supportSQLiteStatement3.bindNull(14);
                    supportSQLiteStatement3.bindNull(15);
                }
            }
        };
        this.__insertionAdapterOfBasketballTeamStanding = converters2;
        converters2 = entityDeletionOrUpdateAdapter13;
        entityDeletionOrUpdateAdapter13 = new EntityDeletionOrUpdateAdapter<EventSummaryResponseData>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `EventSummaryResponseData` WHERE `eventSummaryResponseDataId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummaryResponseData eventSummaryResponseData) {
                long l = eventSummaryResponseData.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        this.__deletionAdapterOfEventSummaryResponseData = converters2;
        converters2 = entityDeletionOrUpdateAdapter12;
        entityDeletionOrUpdateAdapter12 = new EntityDeletionOrUpdateAdapter<EventTeam>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `EventTeam` WHERE `eventTeamId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventTeam eventTeam) {
                long l = eventTeam.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        this.__deletionAdapterOfEventTeam = converters2;
        converters2 = entityDeletionOrUpdateAdapter11;
        entityDeletionOrUpdateAdapter11 = new EntityDeletionOrUpdateAdapter<EventSummary>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `EventSummary` WHERE `eventSummaryId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummary eventSummary) {
                long l = eventSummary.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        this.__deletionAdapterOfEventSummary = converters2;
        converters2 = entityDeletionOrUpdateAdapter10;
        entityDeletionOrUpdateAdapter10 = new EntityDeletionOrUpdateAdapter<BasketballEventSummary>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `BasketballEventSummary` WHERE `basketballEventSummaryId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballEventSummary basketballEventSummary) {
                long l = basketballEventSummary.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        this.__deletionAdapterOfBasketballEventSummary = converters2;
        converters2 = entityDeletionOrUpdateAdapter9;
        entityDeletionOrUpdateAdapter9 = new EntityDeletionOrUpdateAdapter<BasketballBoxScore>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `BasketballBoxScore` WHERE `basketballBoxScoreId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballBoxScore basketballBoxScore) {
                long l = basketballBoxScore.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        this.__deletionAdapterOfBasketballBoxScore = converters2;
        converters2 = entityDeletionOrUpdateAdapter8;
        entityDeletionOrUpdateAdapter8 = new EntityDeletionOrUpdateAdapter<BasketballPlayByPlay>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `BasketballPlayByPlay` WHERE `basketballPlayByPlayId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballPlayByPlay basketballPlayByPlay) {
                long l = basketballPlayByPlay.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        this.__deletionAdapterOfBasketballPlayByPlay = converters2;
        converters2 = entityDeletionOrUpdateAdapter7;
        entityDeletionOrUpdateAdapter7 = new EntityDeletionOrUpdateAdapter<EventSummaryResponseData>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `EventSummaryResponseData` SET `eventSummaryResponseDataId` = ?,`type` = ? WHERE `eventSummaryResponseDataId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummaryResponseData eventSummaryResponseData) {
                long l = eventSummaryResponseData.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.SportEventsDao_Impl.this.__converters.eventTypeToString(eventSummaryResponseData.getType());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
                long l2 = eventSummaryResponseData.getId();
                supportSQLiteStatement.bindLong(3, l2);
            }
        };
        this.__updateAdapterOfEventSummaryResponseData = converters2;
        converters2 = entityDeletionOrUpdateAdapter6;
        entityDeletionOrUpdateAdapter6 = new EntityDeletionOrUpdateAdapter<EventTeam>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `EventTeam` SET `eventTeamId` = ?,`name` = ?,`alias` = ?,`logo` = ?,`colors` = ?,`isWinner` = ? WHERE `eventTeamId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventTeam eventTeam) {
                long l = eventTeam.getId();
                supportSQLiteStatement.bindLong(1, l);
                if (eventTeam.getName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, eventTeam.getName());
                }
                if (eventTeam.getAlias() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, eventTeam.getAlias());
                }
                if (eventTeam.getLogo() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, eventTeam.getLogo());
                }
                Object object = object.SportEventsDao_Impl.this.__converters.stringListToString(eventTeam.getColors());
                if (object == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, (String)object);
                }
                long l2 = (long)eventTeam.isWinner();
                supportSQLiteStatement.bindLong(6, l2);
                l2 = eventTeam.getId();
                supportSQLiteStatement.bindLong(7, l2);
            }
        };
        this.__updateAdapterOfEventTeam = converters2;
        converters2 = entityDeletionOrUpdateAdapter5;
        entityDeletionOrUpdateAdapter5 = new EntityDeletionOrUpdateAdapter<EventSummary>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `EventSummary` SET `scheduleDateString` = ?,`scheduleDate` = ?,`eventSummaryId` = ?,`scheduled` = ?,`league` = ?,`homeScore` = ?,`awayScore` = ?,`homeTeamId` = ?,`awayTeamId` = ?,`status` = ?,`periods` = ?,`periodsCount` = ?,`clock` = ?,`period` = ? WHERE `eventSummaryId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummary eventSummary) {
                Object object = eventSummary.scheduledDateString;
                if (object == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, (String)object);
                }
                object = object2.SportEventsDao_Impl.this.__converters.dateToString(eventSummary.scheduleDate);
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    long l = (Long)object;
                    supportSQLiteStatement.bindLong(2, l);
                }
                long l = eventSummary.getId();
                supportSQLiteStatement.bindLong(3, l);
                if (eventSummary.getScheduled() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, eventSummary.getScheduled());
                }
                if (eventSummary.getLeague() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, eventSummary.getLeague());
                }
                l = eventSummary.getHomeScore();
                supportSQLiteStatement.bindLong(6, l);
                l = eventSummary.getAwayScore();
                supportSQLiteStatement.bindLong(7, l);
                l = eventSummary.getHomeTeamId();
                supportSQLiteStatement.bindLong(8, l);
                l = eventSummary.getAwayTeamId();
                supportSQLiteStatement.bindLong(9, l);
                String string2 = object2.SportEventsDao_Impl.this.__converters.eventStatusToString(eventSummary.getStatus());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, string2);
                }
                Object object2 = object2.SportEventsDao_Impl.this.__converters.eventPeriodsToString(eventSummary.getPeriods());
                if (object2 == null) {
                    supportSQLiteStatement.bindNull(11);
                } else {
                    supportSQLiteStatement.bindString(11, (String)object2);
                }
                long l2 = eventSummary.getPeriodsCount();
                supportSQLiteStatement.bindLong(12, l2);
                object2 = eventSummary.getEventTime();
                if (object2 != null) {
                    if (((EventTime)object2).getClock() == null) {
                        supportSQLiteStatement.bindNull(13);
                    } else {
                        supportSQLiteStatement.bindString(13, ((EventTime)object2).getClock());
                    }
                    l2 = ((EventTime)object2).getPeriod();
                    supportSQLiteStatement.bindLong(14, l2);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(13);
                    supportSQLiteStatement2.bindNull(14);
                }
                long l3 = eventSummary.getId();
                supportSQLiteStatement.bindLong(15, l3);
            }
        };
        this.__updateAdapterOfEventSummary = converters2;
        converters2 = entityDeletionOrUpdateAdapter4;
        entityDeletionOrUpdateAdapter4 = new EntityDeletionOrUpdateAdapter<BasketballEventSummary>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `BasketballEventSummary` SET `basketballEventSummaryId` = ?,`performers` = ?,`homeTeamfieldGoalPercentage` = ?,`homeTeamthreePtsPercentage` = ?,`homeTeamfreeThrowPercentage` = ?,`homeTeamassists` = ?,`homeTeamrebounds` = ?,`awayTeamfieldGoalPercentage` = ?,`awayTeamthreePtsPercentage` = ?,`awayTeamfreeThrowPercentage` = ?,`awayTeamassists` = ?,`awayTeamrebounds` = ? WHERE `basketballEventSummaryId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballEventSummary basketballEventSummary) {
                long l = basketballEventSummary.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.SportEventsDao_Impl.this.__converters.basketballPerfomersToString(basketballEventSummary.getPerformers());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
                object = basketballEventSummary.getSummary();
                if (object != null) {
                    BasketballTeamSummary basketballTeamSummary = ((BasketballSummary)object).getHomeTeamStatistics();
                    if (basketballTeamSummary != null) {
                        double d = basketballTeamSummary.getFieldGoalPercentage();
                        supportSQLiteStatement.bindDouble(3, d);
                        d = basketballTeamSummary.getThreePtsPercentage();
                        supportSQLiteStatement.bindDouble(4, d);
                        d = basketballTeamSummary.getFreeThrowPercentage();
                        supportSQLiteStatement.bindDouble(5, d);
                        long l2 = basketballTeamSummary.getAssists();
                        supportSQLiteStatement.bindLong(6, l2);
                        l2 = basketballTeamSummary.getRebounds();
                        supportSQLiteStatement.bindLong(7, l2);
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                        supportSQLiteStatement2.bindNull(3);
                        supportSQLiteStatement2.bindNull(4);
                        supportSQLiteStatement2.bindNull(5);
                        supportSQLiteStatement2.bindNull(6);
                        supportSQLiteStatement2.bindNull(7);
                    }
                    object = ((BasketballSummary)object).getAwayTeamStatistics();
                    if (object != null) {
                        double d = ((BasketballTeamSummary)object).getFieldGoalPercentage();
                        supportSQLiteStatement.bindDouble(8, d);
                        d = ((BasketballTeamSummary)object).getThreePtsPercentage();
                        supportSQLiteStatement.bindDouble(9, d);
                        d = ((BasketballTeamSummary)object).getFreeThrowPercentage();
                        supportSQLiteStatement.bindDouble(10, d);
                        long l3 = ((BasketballTeamSummary)object).getAssists();
                        supportSQLiteStatement.bindLong(11, l3);
                        l3 = ((BasketballTeamSummary)object).getRebounds();
                        supportSQLiteStatement.bindLong(12, l3);
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                        supportSQLiteStatement3.bindNull(8);
                        supportSQLiteStatement3.bindNull(9);
                        supportSQLiteStatement3.bindNull(10);
                        supportSQLiteStatement3.bindNull(11);
                        supportSQLiteStatement3.bindNull(12);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement4 = supportSQLiteStatement;
                    supportSQLiteStatement4.bindNull(3);
                    supportSQLiteStatement4.bindNull(4);
                    supportSQLiteStatement4.bindNull(5);
                    supportSQLiteStatement4.bindNull(6);
                    supportSQLiteStatement4.bindNull(7);
                    supportSQLiteStatement4.bindNull(8);
                    supportSQLiteStatement4.bindNull(9);
                    supportSQLiteStatement4.bindNull(10);
                    supportSQLiteStatement4.bindNull(11);
                    supportSQLiteStatement4.bindNull(12);
                }
                long l4 = basketballEventSummary.getId();
                supportSQLiteStatement.bindLong(13, l4);
            }
        };
        this.__updateAdapterOfBasketballEventSummary = converters2;
        converters2 = entityDeletionOrUpdateAdapter3;
        entityDeletionOrUpdateAdapter3 = new EntityDeletionOrUpdateAdapter<BasketballBoxScore>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `BasketballBoxScore` SET `basketballBoxScoreId` = ?,`homePlayerScores` = ?,`awayPlayerScore` = ? WHERE `basketballBoxScoreId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballBoxScore basketballBoxScore) {
                long l = basketballBoxScore.getId();
                supportSQLiteStatement.bindLong(1, l);
                String string2 = object.SportEventsDao_Impl.this.__converters.playerScoresToString(basketballBoxScore.getHomePlayerScores());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, string2);
                }
                Object object = object.SportEventsDao_Impl.this.__converters.playerScoresToString(basketballBoxScore.getAwayPlayerScore());
                if (object == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, (String)object);
                }
                long l2 = basketballBoxScore.getId();
                supportSQLiteStatement.bindLong(4, l2);
            }
        };
        this.__updateAdapterOfBasketballBoxScore = converters2;
        converters2 = entityDeletionOrUpdateAdapter2;
        entityDeletionOrUpdateAdapter2 = new EntityDeletionOrUpdateAdapter<BasketballPlayByPlay>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `BasketballPlayByPlay` SET `basketballPlayByPlayId` = ?,`statistics` = ? WHERE `basketballPlayByPlayId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballPlayByPlay basketballPlayByPlay) {
                long l = basketballPlayByPlay.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.SportEventsDao_Impl.this.__converters.playByPlayStatisticsToString(basketballPlayByPlay.getStatistics());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
                long l2 = basketballPlayByPlay.getId();
                supportSQLiteStatement.bindLong(3, l2);
            }
        };
        this.__updateAdapterOfBasketballPlayByPlay = converters2;
        converters2 = entityDeletionOrUpdateAdapter;
        entityDeletionOrUpdateAdapter = new EntityDeletionOrUpdateAdapter<BasketballTeamStanding>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `BasketballTeamStanding` SET `id` = ?,`teamName` = ?,`teamIcon` = ?,`colors` = ?,`wins` = ?,`losses` = ?,`percentage` = ?,`gamesBehind` = ?,`division` = ?,`conference` = ?,`league` = ?,`streakkind` = ?,`streaklength` = ?,`rankdivision` = ?,`rankconference` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballTeamStanding basketballTeamStanding) {
                long l = basketballTeamStanding.getId();
                supportSQLiteStatement.bindLong(1, l);
                if (basketballTeamStanding.getTeamName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, basketballTeamStanding.getTeamName());
                }
                if (basketballTeamStanding.getTeamIcon() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, basketballTeamStanding.getTeamIcon());
                }
                Object object = object.SportEventsDao_Impl.this.__converters.stringListToString(basketballTeamStanding.getColors());
                if (object == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, (String)object);
                }
                l = basketballTeamStanding.getWins();
                supportSQLiteStatement.bindLong(5, l);
                l = basketballTeamStanding.getLosses();
                supportSQLiteStatement.bindLong(6, l);
                double d = basketballTeamStanding.getPercentage();
                supportSQLiteStatement.bindDouble(7, d);
                long l2 = basketballTeamStanding.getGamesBehind();
                supportSQLiteStatement.bindLong(8, l2);
                if (basketballTeamStanding.getDivision() == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, basketballTeamStanding.getDivision());
                }
                if (basketballTeamStanding.getConference() == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, basketballTeamStanding.getConference());
                }
                if (basketballTeamStanding.getLeague() == null) {
                    supportSQLiteStatement.bindNull(11);
                } else {
                    supportSQLiteStatement.bindString(11, basketballTeamStanding.getLeague());
                }
                object = basketballTeamStanding.getStreak();
                if (object != null) {
                    if (((BasketballTeamStreak)object).getKind() == null) {
                        supportSQLiteStatement.bindNull(12);
                    } else {
                        supportSQLiteStatement.bindString(12, ((BasketballTeamStreak)object).getKind());
                    }
                    l2 = ((BasketballTeamStreak)object).getLength();
                    supportSQLiteStatement.bindLong(13, l2);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(12);
                    supportSQLiteStatement2.bindNull(13);
                }
                object = basketballTeamStanding.getRank();
                if (object != null) {
                    l2 = ((BasketballTeamRank)object).getDivision();
                    supportSQLiteStatement.bindLong(14, l2);
                    l2 = ((BasketballTeamRank)object).getConference();
                    supportSQLiteStatement.bindLong(15, l2);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                    supportSQLiteStatement3.bindNull(14);
                    supportSQLiteStatement3.bindNull(15);
                }
                long l3 = basketballTeamStanding.getId();
                supportSQLiteStatement.bindLong(16, l3);
            }
        };
        this.__updateAdapterOfBasketballTeamStanding = converters2;
        converters2 = sharedSQLiteStatement3;
        sharedSQLiteStatement3 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM EventScheduleData WHERE type = ?";
            }
        };
        this.__preparedStmtOfDeleteEventSchedules = converters2;
        converters2 = sharedSQLiteStatement2;
        sharedSQLiteStatement2 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM LeagueScheduleDate WHERE scheduleLeague = ?";
            }
        };
        this.__preparedStmtOfDeleteScheduleDates = converters2;
        converters2 = sharedSQLiteStatement;
        sharedSQLiteStatement = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM BasketballTeamStanding WHERE BasketballTeamStanding.league = ?";
            }
        };
        this.__preparedStmtOfDeleteBasketballStandings = converters2;
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private void __fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam(LongSparseArray<EventTeam> longSparseArray) {
        int n;
        int n2;
        if (longSparseArray.isEmpty()) {
            return;
        }
        if (longSparseArray.size() > 999) {
            LongSparseArray longSparseArray2;
            LongSparseArray longSparseArray3 = longSparseArray2;
            longSparseArray2 = new LongSparseArray(999);
            int n3 = 0;
            int n4 = longSparseArray.size();
            for (int i = 0; i < n4; ++i) {
                LongSparseArray longSparseArray4;
                longSparseArray3.put(longSparseArray.keyAt(i), null);
                if (++n3 != 999) continue;
                this.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam((LongSparseArray<EventTeam>)longSparseArray3);
                longSparseArray.putAll(longSparseArray3);
                longSparseArray3 = longSparseArray4;
                longSparseArray4 = new LongSparseArray(999);
                n3 = 0;
            }
            if (n3 > 0) {
                this.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam((LongSparseArray<EventTeam>)longSparseArray3);
                longSparseArray.putAll(longSparseArray3);
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `EventTeam`.`eventTeamId` AS `eventTeamId`,`EventTeam`.`name` AS `name`,`EventTeam`.`alias` AS `alias`,`EventTeam`.`logo` AS `logo`,`EventTeam`.`colors` AS `colors`,`EventTeam`.`isWinner` AS `isWinner`,_junction.`eventSummaryId` FROM `EventSummaryHomeEventTeamCrossRef` AS _junction INNER JOIN `EventTeam` ON (_junction.`eventTeamId` = `EventTeam`.`eventTeamId`) WHERE _junction.`eventSummaryId` IN (");
        int n5 = longSparseArray.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n5);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n5 + 0));
        int n6 = 1;
        for (n2 = 0; n2 < longSparseArray.size(); ++n2) {
            roomSQLiteQuery.bindLong(n6, longSparseArray.keyAt(n2));
            ++n6;
        }
        roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        n6 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery, (String)"eventTeamId");
        n2 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery, (String)"name");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery, (String)"alias");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery, (String)"logo");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery, (String)"colors");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery, (String)"isWinner");
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        while (true) {
            Object object;
            String string2;
            String string3;
            String string4;
            long l;
            long l2;
            block35: {
                block34: {
                    block33: {
                        block32: {
                            block31: {
                                block30: {
                                    block29: {
                                        block28: {
                                            if (!roomSQLiteQuery.moveToNext()) break;
                                            LongSparseArray<EventTeam> longSparseArray5 = longSparseArray;
                                            l2 = roomSQLiteQuery.getLong(6);
                                            if (!longSparseArray5.containsKey(l2)) continue;
                                            RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
                                            int n10 = n2;
                                            l = roomSQLiteQuery.getLong(n6);
                                            if (!roomSQLiteQuery2.isNull(n10)) break block28;
                                            string4 = null;
                                            break block29;
                                        }
                                        string4 = roomSQLiteQuery.getString(n2);
                                    }
                                    if (!roomSQLiteQuery.isNull(n7)) break block30;
                                    string3 = null;
                                    break block31;
                                }
                                string3 = roomSQLiteQuery.getString(n7);
                            }
                            if (!roomSQLiteQuery.isNull(n8)) break block32;
                            string2 = null;
                            break block33;
                        }
                        string2 = roomSQLiteQuery.getString(n8);
                    }
                    if (!roomSQLiteQuery.isNull(n9)) break block34;
                    object = null;
                    break block35;
                }
                object = roomSQLiteQuery.getString(n9);
            }
            RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery;
            int n11 = n;
            object = this.__converters.stringToStringList((String)object);
            boolean bl = roomSQLiteQuery3.getInt(n11) != 0;
            longSparseArray.put(l2, (Object)new EventTeam(l, string4, string3, string2, (List<String>)object, bl));
            continue;
            break;
        }
        roomSQLiteQuery.close();
        return;
    }

    private void __fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam_1(LongSparseArray<EventTeam> longSparseArray) {
        int n;
        int n2;
        if (longSparseArray.isEmpty()) {
            return;
        }
        if (longSparseArray.size() > 999) {
            LongSparseArray longSparseArray2;
            LongSparseArray longSparseArray3 = longSparseArray2;
            longSparseArray2 = new LongSparseArray(999);
            int n3 = 0;
            int n4 = longSparseArray.size();
            for (int i = 0; i < n4; ++i) {
                LongSparseArray longSparseArray4;
                longSparseArray3.put(longSparseArray.keyAt(i), null);
                if (++n3 != 999) continue;
                this.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam_1((LongSparseArray<EventTeam>)longSparseArray3);
                longSparseArray.putAll(longSparseArray3);
                longSparseArray3 = longSparseArray4;
                longSparseArray4 = new LongSparseArray(999);
                n3 = 0;
            }
            if (n3 > 0) {
                this.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam_1((LongSparseArray<EventTeam>)longSparseArray3);
                longSparseArray.putAll(longSparseArray3);
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `EventTeam`.`eventTeamId` AS `eventTeamId`,`EventTeam`.`name` AS `name`,`EventTeam`.`alias` AS `alias`,`EventTeam`.`logo` AS `logo`,`EventTeam`.`colors` AS `colors`,`EventTeam`.`isWinner` AS `isWinner`,_junction.`eventSummaryId` FROM `EventSummaryAwayEventTeamCrossRef` AS _junction INNER JOIN `EventTeam` ON (_junction.`eventTeamId` = `EventTeam`.`eventTeamId`) WHERE _junction.`eventSummaryId` IN (");
        int n5 = longSparseArray.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n5);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n5 + 0));
        int n6 = 1;
        for (n2 = 0; n2 < longSparseArray.size(); ++n2) {
            roomSQLiteQuery.bindLong(n6, longSparseArray.keyAt(n2));
            ++n6;
        }
        roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        n6 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery, (String)"eventTeamId");
        n2 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery, (String)"name");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery, (String)"alias");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery, (String)"logo");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery, (String)"colors");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery, (String)"isWinner");
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        while (true) {
            Object object;
            String string2;
            String string3;
            String string4;
            long l;
            long l2;
            block35: {
                block34: {
                    block33: {
                        block32: {
                            block31: {
                                block30: {
                                    block29: {
                                        block28: {
                                            if (!roomSQLiteQuery.moveToNext()) break;
                                            LongSparseArray<EventTeam> longSparseArray5 = longSparseArray;
                                            l2 = roomSQLiteQuery.getLong(6);
                                            if (!longSparseArray5.containsKey(l2)) continue;
                                            RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
                                            int n10 = n2;
                                            l = roomSQLiteQuery.getLong(n6);
                                            if (!roomSQLiteQuery2.isNull(n10)) break block28;
                                            string4 = null;
                                            break block29;
                                        }
                                        string4 = roomSQLiteQuery.getString(n2);
                                    }
                                    if (!roomSQLiteQuery.isNull(n7)) break block30;
                                    string3 = null;
                                    break block31;
                                }
                                string3 = roomSQLiteQuery.getString(n7);
                            }
                            if (!roomSQLiteQuery.isNull(n8)) break block32;
                            string2 = null;
                            break block33;
                        }
                        string2 = roomSQLiteQuery.getString(n8);
                    }
                    if (!roomSQLiteQuery.isNull(n9)) break block34;
                    object = null;
                    break block35;
                }
                object = roomSQLiteQuery.getString(n9);
            }
            RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery;
            int n11 = n;
            object = this.__converters.stringToStringList((String)object);
            boolean bl = roomSQLiteQuery3.getInt(n11) != 0;
            longSparseArray.put(l2, (Object)new EventTeam(l, string4, string3, string2, (List<String>)object, bl));
            continue;
            break;
        }
        roomSQLiteQuery.close();
        return;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void __fetchRelationshipEventSummaryAsioStreamlayerSdkModelSportsEventSummaryRelation(LongSparseArray<EventSummaryRelation> var1_1) {
        block16: {
            if (var1_1.isEmpty()) {
                return;
            }
            if (var1_1.size() > 999) {
                var2_2 = v0;
                v0 = new LongSparseArray(999);
                var3_5 = 0;
                var5_9 = var1_1.size();
                for (var4_7 = 0; var4_7 < var5_9; ++var4_7) {
                    var2_2.put(var1_1.keyAt(var4_7), null);
                    if (++var3_5 != 999) continue;
                    this.__fetchRelationshipEventSummaryAsioStreamlayerSdkModelSportsEventSummaryRelation((LongSparseArray<EventSummaryRelation>)var2_2);
                    var1_1.putAll(var2_2);
                    var2_2 = v1;
                    v1 = new LongSparseArray(999);
                    var3_5 = 0;
                }
                if (var3_5 > 0) {
                    this.__fetchRelationshipEventSummaryAsioStreamlayerSdkModelSportsEventSummaryRelation((LongSparseArray<EventSummaryRelation>)var2_2);
                    var1_1.putAll(var2_2);
                }
                return;
            }
            v2 = StringUtil.newStringBuilder();
            v2.append("SELECT `scheduleDateString`,`scheduleDate`,`eventSummaryId`,`scheduled`,`league`,`homeScore`,`awayScore`,`homeTeamId`,`awayTeamId`,`status`,`periods`,`periodsCount`,`clock`,`period` FROM `EventSummary` WHERE `eventSummaryId` IN (");
            var2_3 = var1_1.size();
            StringUtil.appendPlaceholders((StringBuilder)v2, (int)var2_3);
            v2.append(")");
            var2_4 = RoomSQLiteQuery.acquire((String)v2.toString(), (int)(var2_3 + 0));
            var3_6 = 1;
            for (var4_8 = 0; var4_8 < var1_1.size(); ++var3_6, ++var4_8) {
                var2_4.bindLong(var3_6, var1_1.keyAt(var4_8));
            }
            var2_4 = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)var2_4, (boolean)true, null);
            var3_6 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"eventSummaryId");
            if (var3_6 != -1) break block16;
            var2_4.close();
            return;
        }
        v3 = var2_4;
        var4_8 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"scheduleDateString");
        var5_10 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"scheduleDate");
        var6_11 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"eventSummaryId");
        var7_12 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"scheduled");
        var8_13 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"league");
        var9_14 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"homeScore");
        var10_15 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"awayScore");
        var11_16 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"homeTeamId");
        var12_17 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"awayTeamId");
        var13_18 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"status");
        var14_19 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"periods");
        var15_20 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"periodsCount");
        var16_21 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"clock");
        var17_22 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"period");
        var18_23 = v4;
        v4 = new LongSparseArray();
        var19_24 = v5;
        v5 = new LongSparseArray();
        while (var2_4.moveToNext()) {
            var18_23.put(var2_4.getLong(var6_11), null);
            var19_24.put(var2_4.getLong(var6_11), null);
        }
        v6 = this;
        v7 = var19_24;
        v8 = this;
        v9 = var18_23;
        var2_4.moveToPosition(-1);
        try {
            v8.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam((LongSparseArray<EventTeam>)v9);
            v6.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam_1((LongSparseArray<EventTeam>)v7);
            while (var2_4.moveToNext()) {
                v10 = var1_1;
                var20_25 = var2_4.getLong(var3_6);
            }
        }
        catch (Throwable v11) {
            var2_4.close();
            throw v11;
        }
        {
            block18: {
                block17: {
                    if (!v10.containsKey(var20_25)) continue;
                    if (!var2_4.isNull(var4_8) || !var2_4.isNull(var5_10) || !var2_4.isNull(var6_11) || !var2_4.isNull(var7_12) || !var2_4.isNull(var8_13) || !var2_4.isNull(var9_14) || !var2_4.isNull(var10_15) || !var2_4.isNull(var11_16) || !var2_4.isNull(var12_17) || !var2_4.isNull(var13_18) || !var2_4.isNull(var14_19) || !var2_4.isNull(var15_20) || !var2_4.isNull(var16_21) || !var2_4.isNull(var17_22)) break block17;
                    var35_39 = var22_28 = null;
                    ** GOTO lbl116
                }
                var22_29 = var2_4.getLong(var6_11);
                var24_30 = var2_4.isNull(var7_12) != false ? null : var2_4.getString(var7_12);
                var25_31 = var2_4.isNull(var8_13) != false ? null : var2_4.getString(var8_13);
                var26_32 = var2_4.getInt(var9_14);
                var27_33 = var2_4.getInt(var10_15);
                var28_34 = var2_4.getLong(var11_16);
                var30_35 = var2_4.getLong(var12_17);
                var32_36 /* !! */  = var2_4.isNull(var13_18) != false ? null : var2_4.getString(var13_18);
                var32_36 /* !! */  = this.__converters.stringToEventStatus(var32_36 /* !! */ );
                var33_37 = var2_4.isNull(var14_19) != false ? null : var2_4.getString(var14_19);
                var33_37 = this.__converters.stringToEventPeriods((String)var33_37);
                var34_38 = var2_4.getInt(var15_20);
                if (!var2_4.isNull(var16_21) || !var2_4.isNull(var17_22)) break block18;
                var37_41 = var35_39 = null;
                ** GOTO lbl108
            }
            var35_39 = var2_4.isNull(var16_21) != false ? null : var2_4.getString(var16_21);
            var36_40 = var2_4.getInt(var17_22);
            var37_41 = v12;
            v12 = new EventTime((String)var35_39, var36_40);
lbl108:
            // 2 sources

            v13 = var2_4;
            v14 = var4_8;
            var35_39 = v15;
            v15 = new EventSummary(var22_29, var24_30, var25_31, var26_32, var27_33, (EventTime)var37_41, var28_34, var30_35, (EventStatus)var32_36 /* !! */ , (List<EventPeriod>)var33_37, var34_38);
            var35_39.scheduledDateString = v13.isNull(v14) != false ? null : var2_4.getString(var4_8);
            var22_28 = var2_4.isNull(var5_10) != false ? null : Long.valueOf(var2_4.getLong(var5_10));
            var35_39.scheduleDate = this.__converters.timestampToDate((Long)var22_28);
lbl116:
            // 2 sources

            var20_26 = (EventTeam)var18_23.get(var2_4.getLong(var6_11));
            var21_27 = (EventTeam)var19_24.get(var2_4.getLong(var6_11));
            var1_1.put(var20_25, (Object)new EventSummaryRelation((EventSummary)var35_39, var20_26, var21_27));
            continue;
        }
        var2_4.close();
    }

    /*
     * Unable to fully structure code
     */
    private void __fetchRelationshipBasketballEventSummaryAsioStreamlayerSdkModelSportsBasketballBasketballEventSummary(LongSparseArray<BasketballEventSummary> var1_1) {
        block61: {
            if (var1_1.isEmpty()) {
                return;
            }
            if (var1_1.size() > 999) {
                var2_2 = v0;
                v0 = new LongSparseArray(999);
                var3_5 = 0;
                var5_9 = var1_1.size();
                for (var4_7 = 0; var4_7 < var5_9; ++var4_7) {
                    var2_2.put(var1_1.keyAt(var4_7), null);
                    if (++var3_5 != 999) continue;
                    this.__fetchRelationshipBasketballEventSummaryAsioStreamlayerSdkModelSportsBasketballBasketballEventSummary((LongSparseArray<BasketballEventSummary>)var2_2);
                    var1_1.putAll(var2_2);
                    var2_2 = v1;
                    v1 = new LongSparseArray(999);
                    var3_5 = 0;
                }
                if (var3_5 > 0) {
                    this.__fetchRelationshipBasketballEventSummaryAsioStreamlayerSdkModelSportsBasketballBasketballEventSummary((LongSparseArray<BasketballEventSummary>)var2_2);
                    var1_1.putAll(var2_2);
                }
                return;
            }
            v2 = StringUtil.newStringBuilder();
            v2.append("SELECT `basketballEventSummaryId`,`performers`,`homeTeamfieldGoalPercentage`,`homeTeamthreePtsPercentage`,`homeTeamfreeThrowPercentage`,`homeTeamassists`,`homeTeamrebounds`,`awayTeamfieldGoalPercentage`,`awayTeamthreePtsPercentage`,`awayTeamfreeThrowPercentage`,`awayTeamassists`,`awayTeamrebounds` FROM `BasketballEventSummary` WHERE `basketballEventSummaryId` IN (");
            var2_3 = var1_1.size();
            StringUtil.appendPlaceholders((StringBuilder)v2, (int)var2_3);
            v2.append(")");
            var2_4 = RoomSQLiteQuery.acquire((String)v2.toString(), (int)(var2_3 + 0));
            var3_6 = 1;
            for (var4_8 = 0; var4_8 < var1_1.size(); ++var4_8) {
                var2_4.bindLong(var3_6, var1_1.keyAt(var4_8));
                ++var3_6;
            }
            var2_4 = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)var2_4, (boolean)false, null);
            var3_6 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"basketballEventSummaryId");
            if (var3_6 != -1) break block61;
            var2_4.close();
            return;
        }
        v3 = var2_4;
        v4 = v3;
        v5 = v3;
        v6 = v3;
        v7 = v3;
        v8 = v3;
        v9 = v3;
        v10 = v3;
        v11 = v3;
        v12 = v3;
        v13 = v3;
        v14 = v3;
        var4_8 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"basketballEventSummaryId");
        var5_10 = CursorUtil.getColumnIndexOrThrow((Cursor)v12, (String)"performers");
        var6_11 = CursorUtil.getColumnIndexOrThrow((Cursor)v13, (String)"homeTeamfieldGoalPercentage");
        var7_12 = CursorUtil.getColumnIndexOrThrow((Cursor)v14, (String)"homeTeamthreePtsPercentage");
        var8_13 = CursorUtil.getColumnIndexOrThrow((Cursor)v10, (String)"homeTeamfreeThrowPercentage");
        var9_14 = CursorUtil.getColumnIndexOrThrow((Cursor)v11, (String)"homeTeamassists");
        var10_15 = CursorUtil.getColumnIndexOrThrow((Cursor)v8, (String)"homeTeamrebounds");
        var11_16 = CursorUtil.getColumnIndexOrThrow((Cursor)v9, (String)"awayTeamfieldGoalPercentage");
        var12_17 = CursorUtil.getColumnIndexOrThrow((Cursor)v6, (String)"awayTeamthreePtsPercentage");
        var13_18 = CursorUtil.getColumnIndexOrThrow((Cursor)v7, (String)"awayTeamfreeThrowPercentage");
        var14_19 = CursorUtil.getColumnIndexOrThrow((Cursor)v4, (String)"awayTeamassists");
        try {
            var15_20 = CursorUtil.getColumnIndexOrThrow((Cursor)v5, (String)"awayTeamrebounds");
        }
        catch (Throwable v39) {
            var2_4.close();
            throw v39;
        }
        while (true) {
            block67: {
                block66: {
                    block65: {
                        block64: {
                            block63: {
                                block62: {
                                    if (!var2_4.moveToNext()) break;
                                    v15 = var1_1;
                                    var16_21 = var2_4.getLong(var3_6);
                                    if (!v15.containsKey(var16_21)) continue;
                                    v16 = var2_4;
                                    v17 = var5_10;
                                    var18_22 = var2_4.getLong(var4_8);
                                    if (!v16.isNull(v17)) break block62;
                                    var20_23 = null;
                                    break block63;
                                }
                                var20_23 = var2_4.getString(var5_10);
                            }
                            v18 = var2_4;
                            v19 = var6_11;
                            var20_23 = this.__converters.stringToBasketballPerformers((String)var20_23);
                            if (!v18.isNull(v19)) break block64;
                            if (!var2_4.isNull(var7_12)) break block64;
                            if (!var2_4.isNull(var8_13)) break block64;
                            if (!var2_4.isNull(var9_14)) break block64;
                            if (!var2_4.isNull(var10_15)) break block64;
                            if (!var2_4.isNull(var11_16)) break block64;
                            if (!var2_4.isNull(var12_17)) break block64;
                            if (!var2_4.isNull(var13_18)) break block64;
                            if (!var2_4.isNull(var14_19)) break block64;
                            if (!var2_4.isNull(var15_20)) break block64;
                            var21_24 = null;
                            ** GOTO lbl196
                        }
                        if (!var2_4.isNull(var6_11)) break block65;
                        if (!var2_4.isNull(var7_12)) break block65;
                        if (!var2_4.isNull(var8_13)) break block65;
                        if (!var2_4.isNull(var9_14)) break block65;
                        if (!var2_4.isNull(var10_15)) break block65;
                        var21_24 = null;
                        var29_33 = var21_24;
                        ** GOTO lbl159
                    }
                    v20 = var2_4;
                    v21 = var10_15;
                    v22 = var2_4;
                    v23 = var9_14;
                    v24 = var2_4;
                    v25 = var8_13;
                    v26 = var2_4;
                    v27 = var7_12;
                    var21_25 = var2_4.getDouble(var6_11);
                    var23_29 = v26.getDouble(v27);
                    var25_30 = v24.getDouble(v25);
                    var27_31 = v22.getInt(v23);
                    var28_32 = v20.getInt(v21);
                    var29_33 = v28;
                    v28 = new BasketballTeamSummary(var21_25, var23_29, var25_30, var27_31, var28_32);
lbl159:
                    // 2 sources

                    if (!var2_4.isNull(var11_16)) break block66;
                    if (!var2_4.isNull(var12_17)) break block66;
                    if (!var2_4.isNull(var13_18)) break block66;
                    if (!var2_4.isNull(var14_19)) break block66;
                    if (!var2_4.isNull(var15_20)) break block66;
                    var30_34 = var21_27 = null;
                    break block67;
                }
                v29 = var2_4;
                v30 = var15_20;
                v31 = var2_4;
                v32 = var14_19;
                v33 = var2_4;
                v34 = var13_18;
                v35 = var2_4;
                v36 = var12_17;
                var21_28 = var2_4.getDouble(var11_16);
                var23_29 = v35.getDouble(v36);
                var25_30 = v33.getDouble(v34);
                var27_31 = v31.getInt(v32);
                var28_32 = v29.getInt(v30);
                var30_34 = v37;
                v37 = new BasketballTeamSummary(var21_28, var23_29, var25_30, var27_31, var28_32);
            }
            var21_24 = v38;
            v38 = new BasketballSummary(var29_33, var30_34);
lbl196:
            // 2 sources

            var1_1.put(var16_21, (Object)new BasketballEventSummary(var18_22, (BasketballSummary)var21_24, (List<BasketballPerformers>)var20_23));
            continue;
            break;
        }
        var2_4.close();
        return;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void __fetchRelationshipEventScheduleAttributesAsioStreamlayerSdkModelSportsEventScheduleAttributesRelation(LongSparseArray<EventScheduleAttributesRelation> var1_1) {
        block18: {
            if (var1_1.isEmpty()) {
                return;
            }
            if (var1_1.size() > 999) {
                var2_2 = v0;
                v0 = new LongSparseArray(999);
                var3_5 = 0;
                var5_9 = var1_1.size();
                for (var4_7 = 0; var4_7 < var5_9; ++var4_7) {
                    var2_2.put(var1_1.keyAt(var4_7), null);
                    if (++var3_5 != 999) continue;
                    this.__fetchRelationshipEventScheduleAttributesAsioStreamlayerSdkModelSportsEventScheduleAttributesRelation((LongSparseArray<EventScheduleAttributesRelation>)var2_2);
                    var1_1.putAll(var2_2);
                    var2_2 = v1;
                    v1 = new LongSparseArray(999);
                    var3_5 = 0;
                }
                if (var3_5 > 0) {
                    this.__fetchRelationshipEventScheduleAttributesAsioStreamlayerSdkModelSportsEventScheduleAttributesRelation((LongSparseArray<EventScheduleAttributesRelation>)var2_2);
                    var1_1.putAll(var2_2);
                }
                return;
            }
            v2 = StringUtil.newStringBuilder();
            v2.append("SELECT `eventScheduleAttributesId`,`basketballhomeTeamRecord`,`basketballawayTeamRecord`,`baseballouts`,`baseballinning`,`baseballinningDivision`,`baseballdelayed`,`baseballreasonForDelay`,`baseballtakenBases`,`baseballhomeTeamRecord`,`baseballawayTeamRecord`,`hockeyhomeTeamRecord`,`hockeyawayTeamRecord` FROM `EventScheduleAttributes` WHERE `eventScheduleAttributesId` IN (");
            var2_3 = var1_1.size();
            StringUtil.appendPlaceholders((StringBuilder)v2, (int)var2_3);
            v2.append(")");
            var2_4 = RoomSQLiteQuery.acquire((String)v2.toString(), (int)(var2_3 + 0));
            var3_6 = 1;
            for (var4_8 = 0; var4_8 < var1_1.size(); ++var3_6, ++var4_8) {
                var2_4.bindLong(var3_6, var1_1.keyAt(var4_8));
            }
            var2_4 = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)var2_4, (boolean)true, null);
            var3_6 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"eventScheduleAttributesId");
            if (var3_6 != -1) break block18;
            var2_4.close();
            return;
        }
        v3 = var2_4;
        var4_8 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"eventScheduleAttributesId");
        var5_10 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"basketballhomeTeamRecord");
        var6_11 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"basketballawayTeamRecord");
        var7_12 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"baseballouts");
        var8_13 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"baseballinning");
        var9_14 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"baseballinningDivision");
        var10_15 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"baseballdelayed");
        var11_16 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"baseballreasonForDelay");
        var12_17 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"baseballtakenBases");
        var13_18 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"baseballhomeTeamRecord");
        var14_19 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"baseballawayTeamRecord");
        var15_20 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"hockeyhomeTeamRecord");
        var16_21 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"hockeyawayTeamRecord");
        var17_22 = v4;
        v4 = new LongSparseArray();
        while (var2_4.moveToNext()) {
            var17_22.put(var2_4.getLong(var4_8), null);
        }
        v5 = this;
        v6 = var17_22;
        var2_4.moveToPosition(-1);
        try {
            v5.__fetchRelationshipEventSummaryAsioStreamlayerSdkModelSportsEventSummaryRelation((LongSparseArray<EventSummaryRelation>)v6);
            while (var2_4.moveToNext()) {
                v7 = var1_1;
                var18_23 = var2_4.getLong(var3_6);
            }
        }
        catch (Throwable v8) {
            var2_4.close();
            throw v8;
        }
        {
            block19: {
                block22: {
                    block21: {
                        block20: {
                            if (!v7.containsKey(var18_23)) continue;
                            if (!var2_4.isNull(var4_8) || !var2_4.isNull(var5_10) || !var2_4.isNull(var6_11) || !var2_4.isNull(var7_12) || !var2_4.isNull(var8_13) || !var2_4.isNull(var9_14) || !var2_4.isNull(var10_15) || !var2_4.isNull(var11_16) || !var2_4.isNull(var12_17) || !var2_4.isNull(var13_18) || !var2_4.isNull(var14_19) || !var2_4.isNull(var15_20) || !var2_4.isNull(var16_21)) break block20;
                            var20_25 = null;
                            var22_27 = var20_25;
                            ** GOTO lbl123
                        }
                        var20_26 = var2_4.getLong(var4_8);
                        if (!var2_4.isNull(var5_10) || !var2_4.isNull(var6_11)) break block21;
                        var24_33 = var22_27 = null;
                        ** GOTO lbl92
                    }
                    var22_27 = var2_4.isNull(var5_10) != false ? null : var2_4.getString(var5_10);
                    var22_27 = this.__converters.stringToTeamRecord((String)var22_27);
                    var23_30 = var2_4.isNull(var6_11) != false ? null : var2_4.getString(var6_11);
                    var23_30 = this.__converters.stringToTeamRecord((String)var23_30);
                    var24_33 = v9;
                    v9 = new BasketballEventScore((TeamRecord)var22_27, (TeamRecord)var23_30);
lbl92:
                    // 2 sources

                    if (!var2_4.isNull(var7_12) || !var2_4.isNull(var8_13) || !var2_4.isNull(var9_14) || !var2_4.isNull(var10_15) || !var2_4.isNull(var11_16) || !var2_4.isNull(var12_17) || !var2_4.isNull(var13_18) || !var2_4.isNull(var14_19)) break block22;
                    var31_40 = var22_27 = null;
                    ** GOTO lbl109
                }
                var22_28 = var2_4.getInt(var7_12);
                var23_31 = var2_4.getInt(var8_13);
                var25_34 = var2_4.isNull(var9_14) != false ? null : var2_4.getString(var9_14);
                var26_35 = var2_4.getInt(var10_15) != 0;
                var27_36 = var2_4.isNull(var11_16) != false ? null : var2_4.getString(var11_16);
                var28_37 = var2_4.getInt(var12_17);
                var29_38 = var2_4.isNull(var13_18) != false ? null : var2_4.getString(var13_18);
                var29_38 = this.__converters.stringToTeamRecord((String)var29_38);
                var30_39 = var2_4.isNull(var14_19) != false ? null : var2_4.getString(var14_19);
                var30_39 = this.__converters.stringToTeamRecord((String)var30_39);
                var31_40 = v10;
                v10 = new BaseballEventScore(var22_28, var23_31, (String)var25_34, var26_35, var27_36, var28_37, (TeamRecord)var29_38, (TeamRecord)var30_39);
lbl109:
                // 2 sources

                if (var2_4.isNull(var15_20) && var2_4.isNull(var16_21)) {
                    var25_34 = var22_27 = null;
                    break block19;
                }
                var22_27 = var2_4.isNull(var15_20) != false ? null : var2_4.getString(var15_20);
                var22_27 = this.__converters.stringToTeamRecord((String)var22_27);
                var23_32 = var2_4.isNull(var16_21) != false ? null : var2_4.getString(var16_21);
                var23_32 = this.__converters.stringToTeamRecord((String)var23_32);
                var25_34 = v11;
                v11 = new HockeyEventScore((TeamRecord)var22_27, (TeamRecord)var23_32);
            }
            var22_27 = v12;
            v12 = new EventScheduleAttributes(var20_26, (BasketballEventScore)var24_33, (BaseballEventScore)var31_40, (HockeyEventScore)var25_34);
lbl123:
            // 2 sources

            var18_24 = (EventSummaryRelation)var17_22.get(var2_4.getLong(var4_8));
            var1_1.put(var18_23, (Object)new EventScheduleAttributesRelation((EventScheduleAttributes)var22_27, var18_24));
            continue;
        }
        var2_4.close();
    }

    static /* synthetic */ void access$200(SportEventsDao_Impl sportEventsDao_Impl, LongSparseArray longSparseArray) {
        sportEventsDao_Impl.__fetchRelationshipEventSummaryAsioStreamlayerSdkModelSportsEventSummaryRelation((LongSparseArray<EventSummaryRelation>)longSparseArray);
    }

    static /* synthetic */ void access$300(SportEventsDao_Impl sportEventsDao_Impl, LongSparseArray longSparseArray) {
        sportEventsDao_Impl.__fetchRelationshipBasketballEventSummaryAsioStreamlayerSdkModelSportsBasketballBasketballEventSummary((LongSparseArray<BasketballEventSummary>)longSparseArray);
    }

    static /* synthetic */ void access$400(SportEventsDao_Impl sportEventsDao_Impl, LongSparseArray longSparseArray) {
        sportEventsDao_Impl.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam((LongSparseArray<EventTeam>)longSparseArray);
    }

    static /* synthetic */ void access$500(SportEventsDao_Impl sportEventsDao_Impl, LongSparseArray longSparseArray) {
        sportEventsDao_Impl.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam_1((LongSparseArray<EventTeam>)longSparseArray);
    }

    static /* synthetic */ void access$600(SportEventsDao_Impl sportEventsDao_Impl, LongSparseArray longSparseArray) {
        sportEventsDao_Impl.__fetchRelationshipEventScheduleAttributesAsioStreamlayerSdkModelSportsEventScheduleAttributesRelation((LongSparseArray<EventScheduleAttributesRelation>)longSparseArray);
    }

    @Override
    public void weakSaveEventSummaryResponseData(EventSummaryResponseData eventSummaryResponseData) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventSummaryResponseData.insert((Object)eventSummaryResponseData);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventTeam(EventTeam eventTeam) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventTeam.insert((Object)eventTeam);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void weakSaveEventSummary(EventSummary eventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventSummary.insert((Object)eventSummary);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventSummaryHomeEventTeamCrossRef(EventSummaryHomeEventTeamCrossRef eventSummaryHomeEventTeamCrossRef) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventSummaryHomeEventTeamCrossRef.insert((Object)eventSummaryHomeEventTeamCrossRef);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventSummaryAwayEventTeamCrossRef(EventSummaryAwayEventTeamCrossRef eventSummaryAwayEventTeamCrossRef) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventSummaryAwayEventTeamCrossRef.insert((Object)eventSummaryAwayEventTeamCrossRef);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void weakSaveEventSchedules(List<EventScheduleData> list) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventScheduleData.insert(list);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void weakSaveEventScheduleAttributes(List<EventScheduleAttributes> list) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventScheduleAttributes.insert(list);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveScheduleDateStrings(List<LeagueScheduleDate> list) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfLeagueScheduleDate.insert(list);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveBasketballSummary(BasketballEventSummary basketballEventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfBasketballEventSummary.insert((Object)basketballEventSummary);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveBasketballBoxScore(BasketballBoxScore basketballBoxScore) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfBasketballBoxScore.insert((Object)basketballBoxScore);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveBasketballPlayByPlay(BasketballPlayByPlay basketballPlayByPlay) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfBasketballPlayByPlay.insert((Object)basketballPlayByPlay);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveBasketballTeamStandings(List<BasketballTeamStanding> list) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfBasketballTeamStanding.insert(list);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteEventSummaryResponseData(EventSummaryResponseData eventSummaryResponseData) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__deletionAdapterOfEventSummaryResponseData.handle((Object)eventSummaryResponseData);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteEventTeam(EventTeam eventTeam) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__deletionAdapterOfEventTeam.handle((Object)eventTeam);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteEventSummary(EventSummary eventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__deletionAdapterOfEventSummary.handle((Object)eventSummary);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteBasketballSummary(BasketballEventSummary basketballEventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__deletionAdapterOfBasketballEventSummary.handle((Object)basketballEventSummary);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteBasketballBoxScore(BasketballBoxScore basketballBoxScore) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__deletionAdapterOfBasketballBoxScore.handle((Object)basketballBoxScore);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteBasketballPlayByPlay(BasketballPlayByPlay basketballPlayByPlay) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__deletionAdapterOfBasketballPlayByPlay.handle((Object)basketballPlayByPlay);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateEventSummaryResponseData(EventSummaryResponseData eventSummaryResponseData) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfEventSummaryResponseData.handle((Object)eventSummaryResponseData);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateEventTeam(EventTeam eventTeam) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfEventTeam.handle((Object)eventTeam);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateEventSummary(EventSummary eventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfEventSummary.handle((Object)eventSummary);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateBasketballSummary(BasketballEventSummary basketballEventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfBasketballEventSummary.handle((Object)basketballEventSummary);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateBasketballBoxScore(BasketballBoxScore basketballBoxScore) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfBasketballBoxScore.handle((Object)basketballBoxScore);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateBasketballPlayByPlay(BasketballPlayByPlay basketballPlayByPlay) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfBasketballPlayByPlay.handle((Object)basketballPlayByPlay);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateBasketballTeamStandings(List<BasketballTeamStanding> list) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfBasketballTeamStanding.handleMultiple(list);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventSummaryResponseData(EventSummaryResponseData eventSummaryResponseData) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        this.__db.beginTransaction();
        try {
            SportEventsDao.DefaultImpls.saveEventSummaryResponseData(sportEventsDao_Impl, eventSummaryResponseData);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventSummary(EventSummary eventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        this.__db.beginTransaction();
        try {
            SportEventsDao.DefaultImpls.saveEventSummary(sportEventsDao_Impl, eventSummary);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventSchedules(List<EventScheduleData> list) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        this.__db.beginTransaction();
        try {
            SportEventsDao.DefaultImpls.saveEventSchedules(sportEventsDao_Impl, list);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventScheduleAttributes(List<EventScheduleAttributes> list) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        this.__db.beginTransaction();
        try {
            SportEventsDao.DefaultImpls.saveEventScheduleAttributes(sportEventsDao_Impl, list);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteEventSchedules(EventType object) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = sportEventsDao_Impl.__preparedStmtOfDeleteEventSchedules.acquire();
        int n = 1;
        object = sportEventsDao_Impl.__converters.eventTypeToString((EventType)((Object)object));
        if (object == null) {
            supportSQLiteStatement.bindNull(n);
        } else {
            supportSQLiteStatement.bindString(n, (String)object);
        }
        SportEventsDao_Impl sportEventsDao_Impl2 = this;
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            SportEventsDao_Impl sportEventsDao_Impl3 = this;
            sportEventsDao_Impl3.__db.endTransaction();
            sportEventsDao_Impl3.__preparedStmtOfDeleteEventSchedules.release(supportSQLiteStatement);
            throw throwable;
        }
        sportEventsDao_Impl2.__db.setTransactionSuccessful();
        sportEventsDao_Impl2.__db.endTransaction();
        sportEventsDao_Impl2.__preparedStmtOfDeleteEventSchedules.release(supportSQLiteStatement);
    }

    @Override
    public void deleteScheduleDates(String string2) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = sportEventsDao_Impl.__preparedStmtOfDeleteScheduleDates.acquire();
        int n = 1;
        if (string2 == null) {
            supportSQLiteStatement.bindNull(n);
        } else {
            supportSQLiteStatement.bindString(n, string2);
        }
        SportEventsDao_Impl sportEventsDao_Impl2 = this;
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            SportEventsDao_Impl sportEventsDao_Impl3 = this;
            sportEventsDao_Impl3.__db.endTransaction();
            sportEventsDao_Impl3.__preparedStmtOfDeleteScheduleDates.release(supportSQLiteStatement);
            throw throwable;
        }
        sportEventsDao_Impl2.__db.setTransactionSuccessful();
        sportEventsDao_Impl2.__db.endTransaction();
        sportEventsDao_Impl2.__preparedStmtOfDeleteScheduleDates.release(supportSQLiteStatement);
    }

    @Override
    public void deleteBasketballStandings(String string2) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = sportEventsDao_Impl.__preparedStmtOfDeleteBasketballStandings.acquire();
        int n = 1;
        if (string2 == null) {
            supportSQLiteStatement.bindNull(n);
        } else {
            supportSQLiteStatement.bindString(n, string2);
        }
        SportEventsDao_Impl sportEventsDao_Impl2 = this;
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            SportEventsDao_Impl sportEventsDao_Impl3 = this;
            sportEventsDao_Impl3.__db.endTransaction();
            sportEventsDao_Impl3.__preparedStmtOfDeleteBasketballStandings.release(supportSQLiteStatement);
            throw throwable;
        }
        sportEventsDao_Impl2.__db.setTransactionSuccessful();
        sportEventsDao_Impl2.__db.endTransaction();
        sportEventsDao_Impl2.__preparedStmtOfDeleteBasketballStandings.release(supportSQLiteStatement);
    }

    @Override
    public Flow<EventSummaryResponseDataRelation> getEventSummaryResponseDataRelation(long l) {
        Callable<EventSummaryResponseDataRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventSummaryResponseData WHERE EventSummaryResponseData.eventSummaryResponseDataId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        stringArray[0] = "EventSummaryHomeEventTeamCrossRef";
        stringArray[1] = "EventTeam";
        stringArray[2] = "EventSummaryAwayEventTeamCrossRef";
        stringArray[3] = "EventSummary";
        stringArray[4] = "BasketballEventSummary";
        stringArray[5] = "EventSummaryResponseData";
        Callable<EventSummaryResponseDataRelation> callable2 = callable;
        callable = new Callable<EventSummaryResponseDataRelation>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public EventSummaryResponseDataRelation call() throws Exception {
                v0 = this;
                SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                {
                    block13: {
                        block12: {
                            catch (Throwable v1) {
                                SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                                throw v1;
                            }
                            var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"eventSummaryResponseDataId");
                            var3_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                            var4_7 /* !! */  = v2;
                            v2 = new LongSparseArray();
                            var5_8 = v3;
                            v3 = new LongSparseArray();
                            while (var1_1.moveToNext()) {
                                var4_7 /* !! */ .put(var1_1.getLong(var2_2), null);
                                var5_8.put(var1_1.getLong(var2_2), null);
                            }
                            v4 = var1_1;
                            v5 = this;
                            v6 = v5;
                            v7 = v5;
                            var1_1.moveToPosition(-1);
                            SportEventsDao_Impl.access$200(v6.SportEventsDao_Impl.this, var4_7 /* !! */ );
                            SportEventsDao_Impl.access$300(v7.SportEventsDao_Impl.this, var5_8);
                            if (!v4.moveToFirst()) ** GOTO lbl52
                            if (!var1_1.isNull(var2_2) || !var1_1.isNull(var3_5)) break block12;
                            var3_6 /* !! */  = null;
                            var8_9 = var3_6 /* !! */ ;
                            ** GOTO lbl43
                        }
                        var6_10 = var1_1.getLong(var2_2);
                        var3_6 /* !! */  = var1_1.isNull(var3_5) != false ? null : var1_1.getString(var3_5);
                        var3_6 /* !! */  = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).stringToEventType(var3_6 /* !! */ );
                        var8_9 = v8;
                        try {
                            v8 = new EventSummaryResponseData(var6_10, (EventType)var3_6 /* !! */ );
lbl43:
                            // 2 sources

                            var2_3 = (EventSummaryRelation)var4_7 /* !! */ .get(var1_1.getLong(var2_2));
                            var3_6 /* !! */  = (BasketballEventSummary)var5_8.get(var1_1.getLong(var2_2));
                        }
                        catch (Throwable var2_4) {}
                        {
                            var1_1.close();
                            throw var2_4;
                        }
                        var4_7 /* !! */  = v9;
                        v9 = new EventSummaryResponseDataRelation((EventSummaryResponseData)var8_9, var2_3, (BasketballEventSummary)var3_6 /* !! */ );
                        break block13;
lbl52:
                        // 1 sources

                        var4_7 /* !! */  = null;
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).setTransactionSuccessful();
                    {
                        var1_1.close();
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                    return var4_7 /* !! */ ;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Flow<List<EventSummaryResponseDataRelation>> getEventSummaryResponseDataRelations() {
        Callable<List<EventSummaryResponseDataRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventSummaryResponseData", (int)0);
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        stringArray[0] = "EventSummaryHomeEventTeamCrossRef";
        stringArray[1] = "EventTeam";
        stringArray[2] = "EventSummaryAwayEventTeamCrossRef";
        stringArray[3] = "EventSummary";
        stringArray[4] = "BasketballEventSummary";
        stringArray[5] = "EventSummaryResponseData";
        Callable<List<EventSummaryResponseDataRelation>> callable2 = callable;
        callable = new Callable<List<EventSummaryResponseDataRelation>>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<EventSummaryResponseDataRelation> call() throws Exception {
                v0 = this;
                SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                {
                    catch (Throwable v1) {
                        SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                        throw v1;
                    }
                    var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"eventSummaryResponseDataId");
                    var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                    var4_5 = v2;
                    v2 = new LongSparseArray();
                    var5_6 = v3;
                    v3 = new LongSparseArray();
                    while (var1_1.moveToNext()) {
                        var4_5.put(var1_1.getLong(var2_2), null);
                        var5_6.put(var1_1.getLong(var2_2), null);
                    }
                    v4 = this;
                    v5 = v4;
                    v6 = v4;
                    var1_1.moveToPosition(-1);
                    SportEventsDao_Impl.access$200(v5.SportEventsDao_Impl.this, var4_5);
                    SportEventsDao_Impl.access$300(v6.SportEventsDao_Impl.this, var5_6);
                    var6_7 = v7;
                    try {
                        v7 = new ArrayList<EventSummaryResponseDataRelation>(var1_1.getCount());
                        while (var1_1.moveToNext()) {
                            block14: {
                                if (!var1_1.isNull(var2_2) || !var1_1.isNull(var3_4)) break block14;
                                var7_8 = null;
                                var10_12 = var7_8;
                                ** GOTO lbl48
                            }
                            var7_9 = var1_1.getLong(var2_2);
                            var9_11 /* !! */  = var1_1.isNull(var3_4) != false ? null : var1_1.getString(var3_4);
                            var9_11 /* !! */  = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).stringToEventType(var9_11 /* !! */ );
                        }
                    }
                    catch (Throwable var2_3) {}
                    {
                        var1_1.close();
                        throw var2_3;
                    }
                    {
                        var10_12 = v8;
                        v8 = new EventSummaryResponseData(var7_9, (EventType)var9_11 /* !! */ );
lbl48:
                        // 2 sources

                        var7_8 = (EventSummaryRelation)var4_5.get(var1_1.getLong(var2_2));
                        var8_10 = (BasketballEventSummary)var5_6.get(var1_1.getLong(var2_2));
                        var6_7.add(new EventSummaryResponseDataRelation((EventSummaryResponseData)var10_12, var7_8, var8_10));
                        continue;
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).setTransactionSuccessful();
                    {
                        var1_1.close();
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                    return var6_7;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Flow<EventTeam> getEventTeam(long l) {
        Callable<EventTeam> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventTeam WHERE EventTeam.eventTeamId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "EventTeam";
        Callable<EventTeam> callable2 = callable;
        callable = new Callable<EventTeam>(){

            @Override
            public EventTeam call() throws Exception {
                EventTeam eventTeam;
                Cursor cursor;
                block30: {
                    block21: {
                        EventTeam eventTeam2;
                        String string2;
                        String string3;
                        String string4;
                        String string5;
                        long l;
                        int n;
                        block29: {
                            int n2;
                            block28: {
                                block27: {
                                    int n3;
                                    block26: {
                                        block25: {
                                            int n4;
                                            block24: {
                                                block23: {
                                                    int n5;
                                                    block22: {
                                                        int n6;
                                                        cursor = DBUtil.query((RoomDatabase)list.SportEventsDao_Impl.this.__db, (SupportSQLiteQuery)list.roomSQLiteQuery, (boolean)false, null);
                                                        try {
                                                            n6 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"eventTeamId");
                                                        }
                                                        catch (Throwable throwable) {
                                                            cursor.close();
                                                            throw throwable;
                                                        }
                                                        n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"name");
                                                        n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"alias");
                                                        n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"logo");
                                                        n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"colors");
                                                        n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isWinner");
                                                        if (!cursor.moveToFirst()) break block21;
                                                        Cursor cursor2 = cursor;
                                                        int n7 = n5;
                                                        l = cursor.getLong(n6);
                                                        if (!cursor2.isNull(n7)) break block22;
                                                        string5 = null;
                                                        break block23;
                                                    }
                                                    string5 = cursor.getString(n5);
                                                }
                                                if (!cursor.isNull(n4)) break block24;
                                                string4 = null;
                                                break block25;
                                            }
                                            string4 = cursor.getString(n4);
                                        }
                                        if (!cursor.isNull(n3)) break block26;
                                        string3 = null;
                                        break block27;
                                    }
                                    string3 = cursor.getString(n3);
                                }
                                if (!cursor.isNull(n2)) break block28;
                                string2 = null;
                                break block29;
                            }
                            string2 = cursor.getString(n2);
                        }
                        Cursor cursor3 = cursor;
                        int n8 = n;
                        List<String> list = list.SportEventsDao_Impl.this.__converters.stringToStringList(string2);
                        boolean bl = cursor3.getInt(n8) != 0;
                        eventTeam = eventTeam2;
                        eventTeam2 = new EventTeam(l, string5, string4, string3, list, bl);
                        break block30;
                    }
                    eventTeam = null;
                }
                cursor.close();
                return eventTeam;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Flow<EventSummaryRelation> getEventSummaryRelation(long l) {
        Callable<EventSummaryRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventSummary WHERE EventSummary.eventSummaryId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        stringArray[0] = "EventSummaryHomeEventTeamCrossRef";
        stringArray[1] = "EventTeam";
        stringArray[2] = "EventSummaryAwayEventTeamCrossRef";
        stringArray[3] = "EventSummary";
        Callable<EventSummaryRelation> callable2 = callable;
        callable = new Callable<EventSummaryRelation>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public EventSummaryRelation call() throws Exception {
                v0 = this;
                SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                {
                    block15: {
                        block14: {
                            block13: {
                                catch (Throwable v1) {
                                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                                    throw v1;
                                }
                                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"scheduleDateString");
                                var3_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"scheduleDate");
                                var4_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"eventSummaryId");
                                var5_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"scheduled");
                                var6_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"league");
                                var7_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeScore");
                                var8_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayScore");
                                var9_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamId");
                                var10_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamId");
                                var11_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"status");
                                var12_20 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"periods");
                                var13_22 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"periodsCount");
                                var14_23 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"clock");
                                var15_25 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"period");
                                var16_26 = v2;
                                v2 = new LongSparseArray();
                                var17_27 = v3;
                                v3 = new LongSparseArray();
                                while (var1_1.moveToNext()) {
                                    var16_26.put(var1_1.getLong(var4_7), null);
                                    var17_27.put(var1_1.getLong(var4_7), null);
                                }
                                v4 = var1_1;
                                v5 = this;
                                v6 = v5;
                                v7 = v5;
                                var1_1.moveToPosition(-1);
                                SportEventsDao_Impl.access$400(v6.SportEventsDao_Impl.this, var16_26);
                                SportEventsDao_Impl.access$500(v7.SportEventsDao_Impl.this, var17_27);
                                if (!v4.moveToFirst()) ** GOTO lbl86
                                if (!var1_1.isNull(var2_2) || !var1_1.isNull(var3_5) || !var1_1.isNull(var4_7) || !var1_1.isNull(var5_9) || !var1_1.isNull(var6_11) || !var1_1.isNull(var7_13) || !var1_1.isNull(var8_14) || !var1_1.isNull(var9_15) || !var1_1.isNull(var10_17) || !var1_1.isNull(var11_18) || !var1_1.isNull(var12_20) || !var1_1.isNull(var13_22) || !var1_1.isNull(var14_23) || !var1_1.isNull(var15_25)) break block13;
                                var14_24 = var2_3 = null;
                                ** GOTO lbl77
                            }
                            var18_28 = var1_1.getLong(var4_7);
                            var5_10 = var1_1.isNull(var5_9) != false ? null : var1_1.getString(var5_9);
                            var6_12 = var1_1.isNull(var6_11) != false ? null : var1_1.getString(var6_11);
                            var7_13 = var1_1.getInt(var7_13);
                            var8_14 = var1_1.getInt(var8_14);
                            var9_16 = var1_1.getLong(var9_15);
                            var20_29 = var1_1.getLong(var10_17);
                            var11_19 /* !! */  = var1_1.isNull(var11_18) != false ? null : var1_1.getString(var11_18);
                            var11_19 /* !! */  = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).stringToEventStatus(var11_19 /* !! */ );
                            var12_21 = var1_1.isNull(var12_20) != false ? null : var1_1.getString(var12_20);
                            var12_21 = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).stringToEventPeriods((String)var12_21);
                            var13_22 = var1_1.getInt(var13_22);
                            if (!var1_1.isNull(var14_23) || !var1_1.isNull(var15_25)) break block14;
                            var22_30 = var14_24 = null;
                            ** GOTO lbl69
                        }
                        var14_24 = var1_1.isNull(var14_23) != false ? null : var1_1.getString(var14_23);
                        var15_25 = var1_1.getInt(var15_25);
                        var22_30 = v8;
                        v8 = new EventTime((String)var14_24, var15_25);
lbl69:
                        // 2 sources

                        v9 = var1_1;
                        v10 = var2_2;
                        var14_24 = v11;
                        try {
                            v11 = new EventSummary(var18_28, var5_10, var6_12, var7_13, var8_14, (EventTime)var22_30, var9_16, var20_29, (EventStatus)var11_19 /* !! */ , (List<EventPeriod>)var12_21, var13_22);
                            var14_24.scheduledDateString = v9.isNull(v10) != false ? null : var1_1.getString(var2_2);
                            var2_3 = var1_1.isNull(var3_5) != false ? null : Long.valueOf(var1_1.getLong(var3_5));
                            var14_24.scheduleDate = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).timestampToDate((Long)var2_3);
lbl77:
                            // 2 sources

                            var2_3 = (EventTeam)var16_26.get(var1_1.getLong(var4_7));
                            var3_6 = (EventTeam)var17_27.get(var1_1.getLong(var4_7));
                        }
                        catch (Throwable var2_4) {}
                        {
                            var1_1.close();
                            throw var2_4;
                        }
                        var4_8 = v12;
                        v12 = new EventSummaryRelation((EventSummary)var14_24, (EventTeam)var2_3, var3_6);
                        break block15;
lbl86:
                        // 1 sources

                        var4_8 = null;
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).setTransactionSuccessful();
                    {
                        var1_1.close();
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                    return var4_8;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Flow<List<EventScheduleDataRelation>> getEventSchedulesRelation(String string2, String object) {
        Callable<List<EventScheduleDataRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventScheduleData LEFT JOIN EventScheduleAttributes ON EventScheduleData.attributesId = EventScheduleAttributes.eventScheduleAttributesId LEFT JOIN EventSummary ON EventScheduleAttributes.eventScheduleAttributesId = EventSummary.eventSummaryId WHERE EventSummary.scheduleDateString = ? AND EventSummary.league = ? ORDER BY EventScheduleData.eventScheduleDataId ASC, datetime(EventSummary.scheduleDate) ASC", (int)2);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        int n2 = 2;
        if (object == null) {
            roomSQLiteQuery.bindNull(n2);
        } else {
            roomSQLiteQuery.bindString(n2, (String)object);
        }
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        stringArray[0] = "EventSummaryHomeEventTeamCrossRef";
        stringArray[1] = "EventTeam";
        stringArray[2] = "EventSummaryAwayEventTeamCrossRef";
        stringArray[3] = "EventSummary";
        stringArray[4] = "EventScheduleAttributes";
        stringArray[5] = "EventScheduleData";
        object = callable;
        callable = new Callable<List<EventScheduleDataRelation>>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<EventScheduleDataRelation> call() throws Exception {
                v0 = this;
                SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                {
                    catch (Throwable v1) {
                        SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                        throw v1;
                    }
                    var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"eventScheduleDataId");
                    var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                    var4_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"attributesId");
                    var5_6 = v2;
                    v2 = new LongSparseArray();
                    while (var1_1.moveToNext()) {
                        var5_6.put(var1_1.getLong(var2_2), null);
                    }
                    v3 = this;
                    var1_1.moveToPosition(-1);
                    SportEventsDao_Impl.access$600(v3.SportEventsDao_Impl.this, var5_6);
                    var6_7 = v4;
                    try {
                        v4 = new ArrayList<EventScheduleDataRelation>(var1_1.getCount());
                        while (var1_1.moveToNext()) {
                            block13: {
                                if (!var1_1.isNull(var2_2) || !var1_1.isNull(var3_4) || !var1_1.isNull(var4_5)) break block13;
                                var7_8 = null;
                                var12_12 = var7_8;
                                ** GOTO lbl43
                            }
                            var7_9 = var1_1.getLong(var2_2);
                            var9_10 /* !! */  = var1_1.isNull(var3_4) != false ? null : var1_1.getString(var3_4);
                            var9_10 /* !! */  = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).stringToEventType(var9_10 /* !! */ );
                            var10_11 = var1_1.getLong(var4_5);
                        }
                    }
                    catch (Throwable var2_3) {}
                    {
                        var1_1.close();
                        throw var2_3;
                    }
                    {
                        var12_12 = v5;
                        v5 = new EventScheduleData(var7_9, (EventType)var9_10 /* !! */ , var10_11);
lbl43:
                        // 2 sources

                        var7_8 = (EventScheduleAttributesRelation)var5_6.get(var1_1.getLong(var2_2));
                        var6_7.add(new EventScheduleDataRelation((EventScheduleData)var12_12, var7_8));
                        continue;
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).setTransactionSuccessful();
                    {
                        var1_1.close();
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                    return var6_7;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)object);
    }

    @Override
    public Flow<List<String>> getScheduleDateStrings(String stringArray) {
        Callable<List<String>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT DISTINCT scheduleDate FROM LeagueScheduleDate WHERE scheduleLeague = ? ORDER BY datetime(scheduleDate) ASC", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[1];
        stringArray = stringArray2;
        stringArray2[0] = "LeagueScheduleDate";
        Callable<List<String>> callable2 = callable;
        callable = new Callable<List<String>>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<String> call() throws Exception {
                ArrayList<String> arrayList;
                34 this_ = DBUtil.query((RoomDatabase)this_.SportEventsDao_Impl.this.__db, (SupportSQLiteQuery)this_.roomSQLiteQuery, (boolean)false, null);
                ArrayList<String> arrayList2 = arrayList;
                try {
                    arrayList = new ArrayList<String>(this_.getCount());
                }
                catch (Throwable throwable) {
                    this_.close();
                    throw throwable;
                }
                while (this_.moveToNext()) {
                    String string2 = this_.isNull(0) ? null : this_.getString(0);
                    arrayList2.add(string2);
                }
                this_.close();
                return arrayList2;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Flow<List<String>> getEventScheduleDates(String stringArray) {
        Callable<List<String>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT DISTINCT scheduleDate FROM LeagueScheduleDate WHERE scheduleLeague = ? ORDER BY datetime(scheduleDate) ASC", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[1];
        stringArray = stringArray2;
        stringArray2[0] = "LeagueScheduleDate";
        Callable<List<String>> callable2 = callable;
        callable = new Callable<List<String>>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<String> call() throws Exception {
                ArrayList<String> arrayList;
                35 this_ = DBUtil.query((RoomDatabase)this_.SportEventsDao_Impl.this.__db, (SupportSQLiteQuery)this_.roomSQLiteQuery, (boolean)false, null);
                ArrayList<String> arrayList2 = arrayList;
                try {
                    arrayList = new ArrayList<String>(this_.getCount());
                }
                catch (Throwable throwable) {
                    this_.close();
                    throw throwable;
                }
                while (this_.moveToNext()) {
                    String string2 = this_.isNull(0) ? null : this_.getString(0);
                    arrayList2.add(string2);
                }
                this_.close();
                return arrayList2;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Flow<BasketballEventSummary> getBasketballSummary(long l) {
        Callable<BasketballEventSummary> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM BasketballEventSummary WHERE BasketballEventSummary.basketballEventSummaryId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "BasketballEventSummary";
        Callable<BasketballEventSummary> callable2 = callable;
        callable = new Callable<BasketballEventSummary>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public BasketballEventSummary call() throws Exception {
                block61: {
                    block53: {
                        block57: {
                            block60: {
                                block59: {
                                    block58: {
                                        block56: {
                                            block55: {
                                                block54: {
                                                    var1_1 = DBUtil.query((RoomDatabase)SportEventsDao_Impl.access$100(SportEventsDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                                    try {
                                                        var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"basketballEventSummaryId");
                                                    }
                                                    catch (Throwable v0) {
                                                        var1_1.close();
                                                        throw v0;
                                                    }
                                                    var3_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"performers");
                                                    var4_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamfieldGoalPercentage");
                                                    var5_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamthreePtsPercentage");
                                                    var6_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamfreeThrowPercentage");
                                                    var7_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamassists");
                                                    var8_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamrebounds");
                                                    var9_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamfieldGoalPercentage");
                                                    var10_19 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamthreePtsPercentage");
                                                    var11_21 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamfreeThrowPercentage");
                                                    var12_22 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamassists");
                                                    var13_23 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamrebounds");
                                                    if (!var1_1.moveToFirst()) break block53;
                                                    v1 = var1_1;
                                                    v2 = var3_7;
                                                    var14_24 = var1_1.getLong(var2_2);
                                                    if (!v1.isNull(v2)) break block54;
                                                    var2_3 = null;
                                                    break block55;
                                                }
                                                var2_3 = var1_1.getString(var3_7);
                                            }
                                            v3 = var1_1;
                                            v4 = var4_9;
                                            this = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).stringToBasketballPerformers((String)var2_3);
                                            if (!v3.isNull(v4)) break block56;
                                            if (!var1_1.isNull(var5_12)) break block56;
                                            if (!var1_1.isNull(var6_13)) break block56;
                                            if (!var1_1.isNull(var7_16)) break block56;
                                            if (!var1_1.isNull(var8_17)) break block56;
                                            if (!var1_1.isNull(var9_18)) break block56;
                                            if (!var1_1.isNull(var10_19)) break block56;
                                            if (!var1_1.isNull(var11_21)) break block56;
                                            if (!var1_1.isNull(var12_22)) break block56;
                                            if (!var1_1.isNull(var13_23)) break block56;
                                            var2_3 = null;
                                            break block57;
                                        }
                                        if (!var1_1.isNull(var4_9)) break block58;
                                        if (!var1_1.isNull(var5_12)) break block58;
                                        if (!var1_1.isNull(var6_13)) break block58;
                                        if (!var1_1.isNull(var7_16)) break block58;
                                        if (!var1_1.isNull(var8_17)) break block58;
                                        var17_25 = var2_3 = null;
                                        ** GOTO lbl104
                                    }
                                    v5 = var1_1;
                                    v6 = var8_17;
                                    v7 = var1_1;
                                    v8 = var7_16;
                                    v9 = var1_1;
                                    v10 = var6_13;
                                    v11 = var1_1;
                                    v12 = var5_12;
                                    var2_4 = var1_1.getDouble(var4_9);
                                    var4_10 = v11.getDouble(v12);
                                    var6_14 = v9.getDouble(v10);
                                    var8_17 = v7.getInt(v8);
                                    var16_26 = v5.getInt(v6);
                                    var17_25 = v13;
                                    v13 = new BasketballTeamSummary(var2_4, var4_10, var6_14, var8_17, var16_26);
lbl104:
                                    // 2 sources

                                    if (!var1_1.isNull(var9_18)) break block59;
                                    if (!var1_1.isNull(var10_19)) break block59;
                                    if (!var1_1.isNull(var11_21)) break block59;
                                    if (!var1_1.isNull(var12_22)) break block59;
                                    if (!var1_1.isNull(var13_23)) break block59;
                                    var10_20 = var2_5 = null;
                                    break block60;
                                }
                                v14 = var1_1;
                                v15 = var13_23;
                                v16 = var1_1;
                                v17 = var12_22;
                                v18 = var1_1;
                                v19 = var11_21;
                                v20 = var1_1;
                                v21 = var10_19;
                                var2_6 = var1_1.getDouble(var9_18);
                                var4_11 = v20.getDouble(v21);
                                var6_15 = v18.getDouble(v19);
                                var8_17 = v16.getInt(v17);
                                var9_18 = v14.getInt(v15);
                                var10_20 = v22;
                                v22 = new BasketballTeamSummary(var2_6, var4_11, var6_15, var8_17, var9_18);
                            }
                            var2_3 = v23;
                            v23 = new BasketballSummary((BasketballTeamSummary)var17_25, var10_20);
                        }
                        var3_8 = v24;
                        v24 = new BasketballEventSummary(var14_24, (BasketballSummary)var2_3, this);
                        break block61;
                    }
                    var3_8 = null;
                }
                var1_1.close();
                return var3_8;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Flow<BasketballBoxScore> getBasketballBoxScore(long l) {
        Callable<BasketballBoxScore> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM BasketballBoxScore WHERE BasketballBoxScore.basketballBoxScoreId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "BasketballBoxScore";
        Callable<BasketballBoxScore> callable2 = callable;
        callable = new Callable<BasketballBoxScore>(){

            @Override
            public BasketballBoxScore call() throws Exception {
                Object object;
                Cursor cursor;
                block19: {
                    block14: {
                        BasketballBoxScore basketballBoxScore;
                        Object object2;
                        long l;
                        block18: {
                            int n;
                            block17: {
                                block16: {
                                    int n2;
                                    block15: {
                                        int n3;
                                        cursor = DBUtil.query((RoomDatabase)list.SportEventsDao_Impl.this.__db, (SupportSQLiteQuery)list.roomSQLiteQuery, (boolean)false, null);
                                        try {
                                            n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"basketballBoxScoreId");
                                        }
                                        catch (Throwable throwable) {
                                            cursor.close();
                                            throw throwable;
                                        }
                                        n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"homePlayerScores");
                                        n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"awayPlayerScore");
                                        if (!cursor.moveToFirst()) break block14;
                                        Cursor cursor2 = cursor;
                                        int n4 = n2;
                                        l = cursor.getLong(n3);
                                        if (!cursor2.isNull(n4)) break block15;
                                        object2 = null;
                                        break block16;
                                    }
                                    object2 = cursor.getString(n2);
                                }
                                Cursor cursor3 = cursor;
                                int n5 = n;
                                object2 = list.SportEventsDao_Impl.this.__converters.stringToPlayerScores((String)object2);
                                if (!cursor3.isNull(n5)) break block17;
                                object = null;
                                break block18;
                            }
                            object = cursor.getString(n);
                        }
                        List<PlayerScores> list = list.SportEventsDao_Impl.this.__converters.stringToPlayerScores((String)object);
                        object = basketballBoxScore;
                        basketballBoxScore = new BasketballBoxScore(l, (List<PlayerScores>)object2, list);
                        break block19;
                    }
                    object = null;
                }
                cursor.close();
                return object;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Flow<BasketballPlayByPlay> getBasketballPlayByPlay(long l) {
        Callable<BasketballPlayByPlay> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM BasketballPlayByPlay WHERE BasketballPlayByPlay.basketballPlayByPlayId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "BasketballPlayByPlay";
        Callable<BasketballPlayByPlay> callable2 = callable;
        callable = new Callable<BasketballPlayByPlay>(){

            @Override
            public BasketballPlayByPlay call() throws Exception {
                Object object;
                Cursor cursor;
                block13: {
                    block10: {
                        BasketballPlayByPlay basketballPlayByPlay;
                        long l;
                        block12: {
                            int n;
                            block11: {
                                int n2;
                                cursor = DBUtil.query((RoomDatabase)list.SportEventsDao_Impl.this.__db, (SupportSQLiteQuery)list.roomSQLiteQuery, (boolean)false, null);
                                try {
                                    n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"basketballPlayByPlayId");
                                }
                                catch (Throwable throwable) {
                                    cursor.close();
                                    throw throwable;
                                }
                                n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statistics");
                                if (!cursor.moveToFirst()) break block10;
                                Cursor cursor2 = cursor;
                                int n3 = n;
                                l = cursor.getLong(n2);
                                if (!cursor2.isNull(n3)) break block11;
                                object = null;
                                break block12;
                            }
                            object = cursor.getString(n);
                        }
                        List<BasketballPlayByPlayStatistics> list = list.SportEventsDao_Impl.this.__converters.stringToPlayByPlayStatistics((String)object);
                        object = basketballPlayByPlay;
                        basketballPlayByPlay = new BasketballPlayByPlay(l, list);
                        break block13;
                    }
                    object = null;
                }
                cursor.close();
                return object;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Flow<List<BasketballTeamStanding>> getBasketballTeamStandings(String stringArray) {
        Callable<List<BasketballTeamStanding>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM BasketballTeamStanding WHERE BasketballTeamStanding.league = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[1];
        stringArray = stringArray2;
        stringArray2[0] = "BasketballTeamStanding";
        Callable<List<BasketballTeamStanding>> callable2 = callable;
        callable = new Callable<List<BasketballTeamStanding>>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public List<BasketballTeamStanding> call() throws Exception {
                var1_1 = DBUtil.query((RoomDatabase)SportEventsDao_Impl.access$100(SportEventsDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"id");
                var3_3 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"teamName");
                var4_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"teamIcon");
                var5_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"colors");
                var6_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"wins");
                var7_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"losses");
                var8_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"percentage");
                var9_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"gamesBehind");
                var10_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"division");
                var11_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"conference");
                var12_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"league");
                var13_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"streakkind");
                var14_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"streaklength");
                var15_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"rankdivision");
                var16_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"rankconference");
                var17_17 = v0;
                try {
                    v0 = new ArrayList<BasketballTeamStanding>(var1_1.getCount());
                    ** while (var1_1.moveToNext())
                }
                catch (Throwable v1) {
                    var1_1.close();
                    throw v1;
                }
lbl-1000:
                // 1 sources

                {
                    block64: {
                        block63: {
                            block62: {
                                block61: {
                                    block60: {
                                        block59: {
                                            block58: {
                                                block57: {
                                                    block56: {
                                                        block55: {
                                                            block54: {
                                                                block53: {
                                                                    block52: {
                                                                        block51: {
                                                                            block50: {
                                                                                block49: {
                                                                                    v2 = var1_1;
                                                                                    v3 = var3_3;
                                                                                    var18_18 = var1_1.getLong(var2_2);
                                                                                    if (!v2.isNull(v3)) break block49;
                                                                                    var20_19 = null;
                                                                                    break block50;
                                                                                }
                                                                                var20_19 = var1_1.getString(var3_3);
                                                                            }
                                                                            if (!var1_1.isNull(var4_4)) break block51;
                                                                            var21_20 = null;
                                                                            break block52;
                                                                        }
                                                                        var21_20 = var1_1.getString(var4_4);
                                                                    }
                                                                    if (!var1_1.isNull(var5_5)) break block53;
                                                                    var22_21 = null;
                                                                    break block54;
                                                                }
                                                                var22_21 = var1_1.getString(var5_5);
                                                            }
                                                            v4 = var1_1;
                                                            v5 = var10_10;
                                                            v6 = var1_1;
                                                            v7 = var9_9;
                                                            v8 = var1_1;
                                                            v9 = var8_8;
                                                            v10 = var1_1;
                                                            v11 = var7_7;
                                                            v12 = var1_1;
                                                            v13 = var6_6;
                                                            var22_21 = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).stringToStringList((String)var22_21);
                                                            var23_22 = v12.getInt(v13);
                                                            var24_23 = v10.getInt(v11);
                                                            var25_24 = v8.getDouble(v9);
                                                            var27_25 = v6.getInt(v7);
                                                            if (!v4.isNull(v5)) break block55;
                                                            var28_26 = null;
                                                            break block56;
                                                        }
                                                        var28_26 = var1_1.getString(var10_10);
                                                    }
                                                    if (!var1_1.isNull(var11_11)) break block57;
                                                    var29_27 = null;
                                                    break block58;
                                                }
                                                var29_27 = var1_1.getString(var11_11);
                                            }
                                            if (!var1_1.isNull(var12_12)) break block59;
                                            var30_28 = null;
                                            break block60;
                                        }
                                        var30_28 = var1_1.getString(var12_12);
                                    }
                                    if (!var1_1.isNull(var13_13)) break block61;
                                    if (!var1_1.isNull(var14_14)) break block61;
                                    var31_29 = null;
                                    var33_32 = var31_29;
                                    ** GOTO lbl132
                                }
                                if (!var1_1.isNull(var13_13)) break block62;
                                var31_29 = null;
                                break block63;
                            }
                            var31_29 = var1_1.getString(var13_13);
                        }
                        var32_31 = var1_1.getInt(var14_14);
                        var33_32 = v14;
                        v14 = new BasketballTeamStreak(var31_29, var32_31);
lbl132:
                        // 2 sources

                        if (!var1_1.isNull(var15_15)) break block64;
                        if (!var1_1.isNull(var16_16)) break block64;
                        var31_29 = null;
                        var34_33 = var31_29;
                        ** GOTO lbl148
                    }
                    v15 = var1_1;
                    v16 = var16_16;
                    var31_30 = var1_1.getInt(var15_15);
                    var32_31 = v15.getInt(v16);
                    var34_33 = v17;
                    v17 = new BasketballTeamRank(var31_30, var32_31);
lbl148:
                    // 2 sources

                    var17_17.add(new BasketballTeamStanding(var18_18, var20_19, var21_20, (List<String>)var22_21, var23_22, var24_23, var25_24, var27_25, (BasketballTeamStreak)var33_32, (BasketballTeamRank)var34_33, var28_26, var29_27, var30_28));
                    continue;
                }
lbl151:
                // 1 sources

                var1_1.close();
                return var17_17;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Flow<EventSummaryResponseData> getEventSummaryResponseData(long l) {
        return SportEventsDao.DefaultImpls.getEventSummaryResponseData(this, l);
    }

    @Override
    public Flow<EventSummary> getEventSummary(long l) {
        return SportEventsDao.DefaultImpls.getEventSummary(this, l);
    }

    @Override
    public Flow<List<EventScheduleData>> getEventSchedules(String string2, String string3) {
        return SportEventsDao.DefaultImpls.getEventSchedules(this, string2, string3);
    }

    @Override
    public Flow<List<Date>> getScheduleDates(String string2) {
        return SportEventsDao.DefaultImpls.getScheduleDates(this, string2);
    }

    @Override
    public Flow<List<Date>> getScheduleDatesMap(String string2) {
        return SportEventsDao.DefaultImpls.getScheduleDatesMap(this, string2);
    }

    @Override
    public Flow<BasketballStandings> getBasketballStandings(String string2) {
        return SportEventsDao.DefaultImpls.getBasketballStandings(this, string2);
    }
}

