/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.soccer.models;

import androidx.collection.ArrayMap;
import com.streamlayer.sports.common.EventSummary;
import com.streamlayer.sports.common.EventTeam;
import com.streamlayer.sports.common.EventTime;
import com.streamlayer.sports.events.LineupResponse;
import com.streamlayer.sports.events.StandingsResponse;
import com.streamlayer.sports.events.SummaryResponse;
import com.streamlayer.sports.soccer.PlayByPlay;
import com.streamlayer.sports.soccer.SoccerMatchActivityType;
import com.streamlayer.sports.soccer.SoccerMatchFormationMatrix;
import com.streamlayer.sports.soccer.SoccerMatchFormationMatrixPlayer;
import com.streamlayer.sports.soccer.SoccerMatchLineup;
import com.streamlayer.sports.soccer.SoccerMatchLineups;
import com.streamlayer.sports.soccer.SoccerMatchPlayer;
import com.streamlayer.sports.soccer.SoccerPerformer;
import com.streamlayer.sports.soccer.SoccerPerformers;
import com.streamlayer.sports.soccer.SoccerPlayerAttackingStats;
import com.streamlayer.sports.soccer.SoccerPlayerDefenseStats;
import com.streamlayer.sports.soccer.SoccerPlayerMidfieldStats;
import com.streamlayer.sports.soccer.SoccerSummary;
import com.streamlayer.sports.soccer.SoccerTeamAttackingStats;
import com.streamlayer.sports.soccer.SoccerTeamDefenseStats;
import com.streamlayer.sports.soccer.SoccerTeamSummary;
import com.streamlayer.sports.soccer.Standings;
import com.streamlayer.sports.soccer.TeamStanding;
import io.streamlayer.sdk.model.sports.EventsKt;
import io.streamlayer.sdk.model.sports.TeamStandings;
import io.streamlayer.sdk.statistics.common.model.PlayByPlayStatistics;
import io.streamlayer.sdk.statistics.soccer.models.ModelsKt$WhenMappings;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGame;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameEvent;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameEventType;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGamePlayerStats;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameStats;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameStatsGroup;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameSummary;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameTopPlayerStats;
import io.streamlayer.sdk.statistics.soccer.models.SoccerPlayByPlayStatistics;
import io.streamlayer.sdk.statistics.soccer.models.SoccerTeam;
import io.streamlayer.sdk.statistics.soccer.models.SoccerTeamMember;
import io.streamlayer.sdk.statistics.soccer.models.SoccerTeamStandings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0013\u0010\u0006\u001a\u00020\u0002*\u00020\u0005H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\t0\u0001*\u00020\bH\u0000\u00a2\u0006\u0004\b\u0006\u0010\n\u001a+\u0010\r\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00010\u000b*\u00020\bH\u0000\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0013\u0010\u0010\u001a\u00020\f*\u00020\u000fH\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u0013\u0010\u0006\u001a\u00020\u0013*\u00020\u0012H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0014\u001a\u0013\u0010\u0006\u001a\u00020\t*\u00020\u000fH\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0015\u001a\u0013\u0010\u0006\u001a\u00020\u0017*\u00020\u0016H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0018\u001aA\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001e0\u001c*\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u00012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u0001H\u0002\u00a2\u0006\u0004\b\u001f\u0010 \u001a\u001f\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0\u000b*\u00020!H\u0000\u00a2\u0006\u0004\b#\u0010$\u001a\u0013\u0010\u0003\u001a\u00020&*\u00020%H\u0000\u00a2\u0006\u0004\b\u0003\u0010'\u00a8\u0006("}, d2={"Lcom/streamlayer/sports/events/StandingsResponse$ResponseData$StandingsResponseAttributes;", "", "Lio/streamlayer/sdk/model/sports/TeamStandings;", "toDomainSoccer", "(Lcom/streamlayer/sports/events/StandingsResponse$ResponseData$StandingsResponseAttributes;)Ljava/util/List;", "Lcom/streamlayer/sports/soccer/TeamStanding;", "toDomain", "(Lcom/streamlayer/sports/soccer/TeamStanding;)Lio/streamlayer/sdk/model/sports/TeamStandings;", "Lcom/streamlayer/sports/soccer/PlayByPlay;", "Lio/streamlayer/sdk/statistics/common/model/PlayByPlayStatistics;", "(Lcom/streamlayer/sports/soccer/PlayByPlay;)Ljava/util/List;", "Lkotlin/Pair;", "Lio/streamlayer/sdk/statistics/soccer/models/SoccerGameEvent;", "toDomainSoccerGameEvents", "(Lcom/streamlayer/sports/soccer/PlayByPlay;)Lkotlin/Pair;", "Lcom/streamlayer/sports/soccer/SoccerPlayByPlayStatistics;", "toDomainSoccerGameEvent", "(Lcom/streamlayer/sports/soccer/SoccerPlayByPlayStatistics;)Lio/streamlayer/sdk/statistics/soccer/models/SoccerGameEvent;", "Lcom/streamlayer/sports/soccer/SoccerMatchActivityType;", "Lio/streamlayer/sdk/statistics/soccer/models/SoccerGameEventType;", "(Lcom/streamlayer/sports/soccer/SoccerMatchActivityType;)Lio/streamlayer/sdk/statistics/soccer/models/SoccerGameEventType;", "(Lcom/streamlayer/sports/soccer/SoccerPlayByPlayStatistics;)Lio/streamlayer/sdk/statistics/common/model/PlayByPlayStatistics;", "Lcom/streamlayer/sports/soccer/SoccerMatchPlayer;", "Lio/streamlayer/sdk/statistics/soccer/models/SoccerTeamMember;", "(Lcom/streamlayer/sports/soccer/SoccerMatchPlayer;)Lio/streamlayer/sdk/statistics/soccer/models/SoccerTeamMember;", "Lcom/streamlayer/sports/soccer/SoccerMatchLineup;", "mainTeam", "subTeam", "Landroidx/collection/ArrayMap;", "", "", "soccerTeamFieldPositions", "(Lcom/streamlayer/sports/soccer/SoccerMatchLineup;Ljava/util/List;Ljava/util/List;)Landroidx/collection/ArrayMap;", "Lcom/streamlayer/sports/events/LineupResponse$ResponseData;", "Lio/streamlayer/sdk/statistics/soccer/models/SoccerTeam;", "toDomainSoccerLineUp", "(Lcom/streamlayer/sports/events/LineupResponse$ResponseData;)Lkotlin/Pair;", "Lcom/streamlayer/sports/events/SummaryResponse$ResponseData;", "Lio/streamlayer/sdk/statistics/soccer/models/SoccerGameSummary;", "(Lcom/streamlayer/sports/events/SummaryResponse$ResponseData;)Lio/streamlayer/sdk/statistics/soccer/models/SoccerGameSummary;", "sdk_originalRelease"})
public final class ModelsKt {
    @NotNull
    public static final List<TeamStandings> toDomainSoccer(@NotNull StandingsResponse.ResponseData.StandingsResponseAttributes object) {
        ArrayList<TeamStandings> arrayList;
        StandingsResponse.ResponseData.StandingsResponseAttributes standingsResponseAttributes = object;
        Intrinsics.checkNotNullParameter((Object)standingsResponseAttributes, (String)"$this$toDomainSoccer");
        Standings standings = standingsResponseAttributes.getSoccer();
        Intrinsics.checkNotNullExpressionValue((Object)standings, (String)"soccer");
        object = standings.getStandingsList();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"soccer.standingsList");
        ArrayList<TeamStandings> arrayList2 = arrayList;
        arrayList = new ArrayList<TeamStandings>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            TeamStanding teamStanding = (TeamStanding)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)teamStanding, (String)"it");
            arrayList2.add(ModelsKt.toDomain(teamStanding));
        }
        return arrayList2;
    }

    @NotNull
    public static final TeamStandings toDomain(@NotNull TeamStanding object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"$this$toDomain");
        TeamStanding teamStanding = object;
        long l = teamStanding.getId();
        object = teamStanding.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
        String string2 = teamStanding.getLogo();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"logo");
        int n = teamStanding.getWins();
        int n2 = teamStanding.getLosses();
        int n3 = teamStanding.getGamesBehind();
        List list = teamStanding.getColorsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"colorsList");
        int n4 = teamStanding.getTotalGoals();
        int n5 = teamStanding.getTotalGoalsReceived();
        int n6 = teamStanding.getPosition();
        String string3 = teamStanding.getAlias();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"alias");
        int n7 = teamStanding.getDraws();
        String string4 = teamStanding.getDivision();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"division");
        int n8 = teamStanding.getPoints();
        return new SoccerTeamStandings(l, (String)object, string2, n, n2, 0.0, n3, list, n4, n5, n6, string4, n7, string3, n8);
    }

    @NotNull
    public static final List<PlayByPlayStatistics> toDomain(@NotNull PlayByPlay object) {
        ArrayList<PlayByPlayStatistics> arrayList;
        PlayByPlay playByPlay = object;
        Intrinsics.checkNotNullParameter((Object)playByPlay, (String)"$this$toDomain");
        object = playByPlay.getStatisticsList();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"statisticsList");
        ArrayList<PlayByPlayStatistics> arrayList2 = arrayList;
        arrayList = new ArrayList<PlayByPlayStatistics>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = (com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayByPlayStatistics, (String)"it");
            arrayList2.add(ModelsKt.toDomain(soccerPlayByPlayStatistics));
        }
        return CollectionsKt.sortedWith(arrayList2, new Comparator<T>(){

            public final int compare(T t, T t2) {
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(Integer.parseInt((String)StringsKt.split$default((CharSequence)((PlayByPlayStatistics)t).getEventTime().getClock(), (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).get(0))), (Comparable)Integer.valueOf(Integer.parseInt((String)StringsKt.split$default((CharSequence)((PlayByPlayStatistics)t2).getEventTime().getClock(), (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).get(0))));
            }
        });
    }

    @NotNull
    public static final Pair<List<SoccerGameEvent>, List<SoccerGameEvent>> toDomainSoccerGameEvents(@NotNull PlayByPlay object) {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        ArrayList arrayList4;
        PlayByPlay playByPlay = object;
        Intrinsics.checkNotNullParameter((Object)playByPlay, (String)"$this$toDomainSoccerGameEvents");
        List list = playByPlay.getStatisticsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"statisticsList");
        Object object2 = arrayList4;
        arrayList4 = new ArrayList();
        for (Object t : list) {
            com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = (com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)t;
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayByPlayStatistics, (String)"it");
            EventTime eventTime = soccerPlayByPlayStatistics.getEventTime();
            Intrinsics.checkNotNullExpressionValue((Object)eventTime, (String)"it.eventTime");
            if (!(eventTime.getPeriod() == 1)) continue;
            object2.add(t);
        }
        object2 = CollectionsKt.sortedWith(object2, new Comparator<T>(){

            public final int compare(T t, T t2) {
                com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = (com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)t2;
                Intrinsics.checkNotNullExpressionValue((Object)soccerPlayByPlayStatistics, (String)"it");
                EventTime eventTime = soccerPlayByPlayStatistics.getEventTime();
                Intrinsics.checkNotNullExpressionValue((Object)eventTime, (String)"it.eventTime");
                String string2 = eventTime.getClock();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.eventTime.clock");
                Integer n = Integer.parseInt((String)StringsKt.split$default((CharSequence)string2, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).get(0));
                com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics2 = (com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)t;
                Intrinsics.checkNotNullExpressionValue((Object)soccerPlayByPlayStatistics2, (String)"it");
                EventTime eventTime2 = soccerPlayByPlayStatistics2.getEventTime();
                Intrinsics.checkNotNullExpressionValue((Object)eventTime2, (String)"it.eventTime");
                String string3 = eventTime2.getClock();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.eventTime.clock");
                return ComparisonsKt.compareValues((Comparable)n, (Comparable)Integer.valueOf(Integer.parseInt((String)StringsKt.split$default((CharSequence)string3, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).get(0))));
            }
        });
        ArrayList arrayList5 = arrayList3;
        arrayList3 = new ArrayList(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = (com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)object2.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayByPlayStatistics, (String)"it");
            arrayList5.add(ModelsKt.toDomainSoccerGameEvent(soccerPlayByPlayStatistics));
        }
        List list2 = object.getStatisticsList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"statisticsList");
        object = arrayList2;
        arrayList2 = new ArrayList();
        for (Object t : list2) {
            com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = (com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)t;
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayByPlayStatistics, (String)"it");
            EventTime eventTime = soccerPlayByPlayStatistics.getEventTime();
            Intrinsics.checkNotNullExpressionValue((Object)eventTime, (String)"it.eventTime");
            if (!(eventTime.getPeriod() == 2)) continue;
            object.add(t);
        }
        object = CollectionsKt.sortedWith((Iterable)object, new Comparator<T>(){

            public final int compare(T t, T t2) {
                com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = (com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)t2;
                Intrinsics.checkNotNullExpressionValue((Object)soccerPlayByPlayStatistics, (String)"it");
                EventTime eventTime = soccerPlayByPlayStatistics.getEventTime();
                Intrinsics.checkNotNullExpressionValue((Object)eventTime, (String)"it.eventTime");
                String string2 = eventTime.getClock();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.eventTime.clock");
                Integer n = Integer.parseInt((String)StringsKt.split$default((CharSequence)string2, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).get(0));
                com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics2 = (com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)t;
                Intrinsics.checkNotNullExpressionValue((Object)soccerPlayByPlayStatistics2, (String)"it");
                EventTime eventTime2 = soccerPlayByPlayStatistics2.getEventTime();
                Intrinsics.checkNotNullExpressionValue((Object)eventTime2, (String)"it.eventTime");
                String string3 = eventTime2.getClock();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.eventTime.clock");
                return ComparisonsKt.compareValues((Comparable)n, (Comparable)Integer.valueOf(Integer.parseInt((String)StringsKt.split$default((CharSequence)string3, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).get(0))));
            }
        });
        object2 = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = (com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayByPlayStatistics, (String)"it");
            object2.add(ModelsKt.toDomainSoccerGameEvent(soccerPlayByPlayStatistics));
        }
        return new Pair((Object)arrayList5, object2);
    }

    @NotNull
    public static final SoccerGameEvent toDomainSoccerGameEvent(@NotNull com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"$this$toDomainSoccerGameEvent");
        com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = object;
        EventTime eventTime = soccerPlayByPlayStatistics.getEventTime();
        Intrinsics.checkNotNullExpressionValue((Object)eventTime, (String)"eventTime");
        object = eventTime.getClock();
        EventTeam eventTeam = soccerPlayByPlayStatistics.getTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam, (String)"team");
        String string2 = eventTeam.getLogo();
        SoccerMatchActivityType soccerMatchActivityType = soccerPlayByPlayStatistics.getType();
        Intrinsics.checkNotNullExpressionValue((Object)soccerMatchActivityType, (String)"type");
        SoccerGameEventType soccerGameEventType = ModelsKt.toDomain(soccerMatchActivityType);
        String string3 = soccerPlayByPlayStatistics.getPlayText();
        return new SoccerGameEvent((String)object, string2, soccerGameEventType, string3);
    }

    @NotNull
    public static final SoccerGameEventType toDomain(@NotNull SoccerMatchActivityType soccerMatchActivityType) {
        SoccerGameEventType soccerGameEventType;
        Intrinsics.checkNotNullParameter((Object)soccerMatchActivityType, (String)"$this$toDomain");
        switch (ModelsKt$WhenMappings.$EnumSwitchMapping$0[soccerMatchActivityType.ordinal()]) {
            default: {
                throw new NoWhenBranchMatchedException();
            }
            case 7: 
            case 8: {
                soccerGameEventType = SoccerGameEventType.NONE;
                break;
            }
            case 6: {
                soccerGameEventType = SoccerGameEventType.FULL_TIME;
                break;
            }
            case 5: {
                soccerGameEventType = SoccerGameEventType.HALF_TIME;
                break;
            }
            case 4: {
                soccerGameEventType = SoccerGameEventType.SUBSTITUTION;
                break;
            }
            case 3: {
                soccerGameEventType = SoccerGameEventType.RED_CARD;
                break;
            }
            case 2: {
                soccerGameEventType = SoccerGameEventType.YELLOW_CARD;
                break;
            }
            case 1: {
                soccerGameEventType = SoccerGameEventType.GOAL;
            }
        }
        return soccerGameEventType;
    }

    @NotNull
    public static final PlayByPlayStatistics toDomain(@NotNull com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"$this$toDomain");
        com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = object;
        EventTeam eventTeam = soccerPlayByPlayStatistics.getTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam, (String)"team");
        object = EventsKt.toDomain(eventTeam);
        EventTime eventTime = soccerPlayByPlayStatistics.getEventTime();
        Intrinsics.checkNotNullExpressionValue((Object)eventTime, (String)"eventTime");
        io.streamlayer.sdk.model.sports.EventTime eventTime2 = EventsKt.toDomain(eventTime);
        int n = soccerPlayByPlayStatistics.getScoreHome();
        int n2 = soccerPlayByPlayStatistics.getScoreAway();
        String string2 = soccerPlayByPlayStatistics.getPlayText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"playText");
        boolean bl = soccerPlayByPlayStatistics.getScoring();
        return new SoccerPlayByPlayStatistics((io.streamlayer.sdk.model.sports.EventTeam)object, eventTime2, n, n2, string2, bl);
    }

    @NotNull
    public static final SoccerTeamMember toDomain(@NotNull SoccerMatchPlayer object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"$this$toDomain");
        SoccerMatchPlayer soccerMatchPlayer = object;
        object = soccerMatchPlayer.getLastName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lastName");
        String string2 = soccerMatchPlayer.getFirstName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"firstName");
        int n = soccerMatchPlayer.getJersey();
        String string3 = soccerMatchPlayer.getPhoto();
        String string4 = soccerMatchPlayer.getPosition();
        return new SoccerTeamMember(string2, (String)object, n, string4, string3);
    }

    private static final ArrayMap<Integer, Set<SoccerTeamMember>> soccerTeamFieldPositions(SoccerMatchLineup soccerMatchLineup, List<SoccerTeamMember> list, List<SoccerTeamMember> list2) {
        ArrayMap arrayMap;
        SoccerMatchLineup soccerMatchLineup2 = soccerMatchLineup;
        soccerMatchLineup = arrayMap;
        arrayMap = new ArrayMap();
        List list3 = soccerMatchLineup2.getFormationMatrixList();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"formationMatrixList");
        int n = 0;
        for (Object object : list3) {
            LinkedHashSet linkedHashSet;
            int n2 = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SoccerMatchFormationMatrix soccerMatchFormationMatrix = (SoccerMatchFormationMatrix)object;
            object = linkedHashSet;
            linkedHashSet = new LinkedHashSet();
            Intrinsics.checkNotNullExpressionValue((Object)soccerMatchFormationMatrix, (String)"soccerMatchFormationMatrix");
            List list4 = soccerMatchFormationMatrix.getRowPlayersList();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"soccerMatchFormationMatrix.rowPlayersList");
            for (Object object2 : list4) {
                SoccerTeamMember soccerTeamMember;
                String string2;
                block9: {
                    for (Object t : list) {
                        string2 = (String)t;
                        int n3 = ((SoccerTeamMember)t).getNumber();
                        SoccerMatchFormationMatrixPlayer soccerMatchFormationMatrixPlayer = object2;
                        Intrinsics.checkNotNullExpressionValue((Object)soccerMatchFormationMatrixPlayer, (String)"player");
                        if (!(n3 == soccerMatchFormationMatrixPlayer.getJerseyNumber())) continue;
                        break block9;
                    }
                    string2 = null;
                }
                Object object3 = (SoccerTeamMember)((Object)string2);
                if (object3 != null) {
                    object.add((Object)object3);
                } else {
                    block10: {
                        for (Object t : list2) {
                            string2 = (String)t;
                            int n4 = ((SoccerTeamMember)t).getNumber();
                            SoccerMatchFormationMatrixPlayer soccerMatchFormationMatrixPlayer = object2;
                            Intrinsics.checkNotNullExpressionValue((Object)soccerMatchFormationMatrixPlayer, (String)"player");
                            if (!(n4 == soccerMatchFormationMatrixPlayer.getJerseyNumber())) continue;
                            break block10;
                        }
                        string2 = null;
                    }
                    object3 = (SoccerTeamMember)((Object)string2);
                    if (object3 != null) {
                        object.add(object3);
                    } else {
                        object3 = null;
                    }
                }
                if (object3 != null) continue;
                object3 = soccerTeamMember;
                SoccerMatchFormationMatrixPlayer soccerMatchFormationMatrixPlayer = object2;
                Intrinsics.checkNotNullExpressionValue((Object)soccerMatchFormationMatrixPlayer, (String)"player");
                object2 = soccerMatchFormationMatrixPlayer.getPlayerName();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"player.playerName");
                string2 = soccerMatchFormationMatrixPlayer.getPlayerName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"player.playerName");
                int n5 = soccerMatchFormationMatrixPlayer.getJerseyNumber();
                String string3 = soccerMatchFormationMatrixPlayer.getPhoto();
                soccerTeamMember = new SoccerTeamMember(string2, (String)object2, n5, null, string3, 8, null);
                object.add(object3);
            }
            soccerMatchLineup.put(n, object);
            n = n2;
        }
        return soccerMatchLineup;
    }

    @NotNull
    public static final Pair<SoccerTeam, SoccerTeam> toDomainSoccerLineUp(@NotNull LineupResponse.ResponseData object) {
        SoccerTeam soccerTeam;
        SoccerTeam soccerTeam2;
        String string2;
        Object object22;
        ArrayList<SoccerTeamMember> arrayList;
        ArrayList<SoccerTeamMember> arrayList2;
        ArrayList<SoccerTeamMember> arrayList3;
        ArrayList<SoccerTeamMember> arrayList4;
        LineupResponse.ResponseData responseData = object;
        Intrinsics.checkNotNullParameter((Object)responseData, (String)"$this$toDomainSoccerLineUp");
        LineupResponse.ResponseData.LineupResponseAttributes lineupResponseAttributes = responseData.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)lineupResponseAttributes, (String)"attributes");
        SoccerMatchLineups soccerMatchLineups = lineupResponseAttributes.getSoccer();
        Intrinsics.checkNotNullExpressionValue((Object)soccerMatchLineups, (String)"attributes.soccer");
        Object object3 = soccerMatchLineups.getHomeTeam();
        LineupResponse.ResponseData.LineupResponseAttributes lineupResponseAttributes2 = object.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)lineupResponseAttributes2, (String)"attributes");
        SoccerMatchLineups soccerMatchLineups2 = lineupResponseAttributes2.getSoccer();
        Intrinsics.checkNotNullExpressionValue((Object)soccerMatchLineups2, (String)"attributes.soccer");
        Object object4 = soccerMatchLineups2.getAwayTeam();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"homeTeam");
        Iterator iterator = object3.getStartPlayersList();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"homeTeam.startPlayersList");
        List<SoccerTeamMember> list = arrayList4;
        arrayList4 = new ArrayList<SoccerTeamMember>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SoccerMatchPlayer soccerMatchPlayer = (SoccerMatchPlayer)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerMatchPlayer, (String)"it");
            list.add(ModelsKt.toDomain(soccerMatchPlayer));
        }
        iterator = object3.getSubstitutesList();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"homeTeam.substitutesList");
        ArrayList<SoccerTeamMember> arrayList5 = arrayList3;
        arrayList3 = new ArrayList<SoccerTeamMember>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SoccerMatchPlayer soccerMatchPlayer = (SoccerMatchPlayer)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerMatchPlayer, (String)"it");
            arrayList5.add(ModelsKt.toDomain(soccerMatchPlayer));
        }
        SoccerMatchLineup soccerMatchLineup = object4;
        Intrinsics.checkNotNullExpressionValue((Object)soccerMatchLineup, (String)"awayTeam");
        iterator = soccerMatchLineup.getStartPlayersList();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"awayTeam.startPlayersList");
        ArrayList<SoccerTeamMember> arrayList6 = arrayList2;
        arrayList2 = new ArrayList<SoccerTeamMember>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SoccerMatchPlayer soccerMatchPlayer = (SoccerMatchPlayer)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerMatchPlayer, (String)"it");
            arrayList6.add(ModelsKt.toDomain(soccerMatchPlayer));
        }
        iterator = object4.getSubstitutesList();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"awayTeam.substitutesList");
        ArrayList<SoccerTeamMember> arrayList7 = arrayList;
        arrayList = new ArrayList<SoccerTeamMember>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SoccerMatchPlayer soccerMatchPlayer = (SoccerMatchPlayer)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerMatchPlayer, (String)"it");
            arrayList7.add(ModelsKt.toDomain(soccerMatchPlayer));
        }
        iterator = ModelsKt.soccerTeamFieldPositions(object4, arrayList6, arrayList7);
        ArrayMap<Integer, Set<SoccerTeamMember>> arrayMap = ModelsKt.soccerTeamFieldPositions(object3, list, arrayList5);
        Object object5 = null;
        Object object6 = null;
        LineupResponse.ResponseData.LineupResponseAttributes lineupResponseAttributes3 = object.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)lineupResponseAttributes3, (String)"attributes");
        EventSummary eventSummary = lineupResponseAttributes3.getSummary();
        Intrinsics.checkNotNullExpressionValue((Object)eventSummary, (String)"attributes.summary");
        EventTeam eventTeam = eventSummary.getHomeTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam, (String)"attributes.summary.homeTeam");
        if (eventTeam.getColorsList() != null) {
            LineupResponse.ResponseData.LineupResponseAttributes lineupResponseAttributes4 = object.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)lineupResponseAttributes4, (String)"attributes");
            EventSummary eventSummary2 = lineupResponseAttributes4.getSummary();
            Intrinsics.checkNotNullExpressionValue((Object)eventSummary2, (String)"attributes.summary");
            EventTeam eventTeam2 = eventSummary2.getAwayTeam();
            Intrinsics.checkNotNullExpressionValue((Object)eventTeam2, (String)"attributes.summary.awayTeam");
            if (eventTeam2.getColorsList() != null) {
                block9: {
                    block8: {
                        LineupResponse.ResponseData.LineupResponseAttributes lineupResponseAttributes5 = object.getAttributes();
                        Intrinsics.checkNotNullExpressionValue((Object)lineupResponseAttributes5, (String)"attributes");
                        EventSummary eventSummary3 = lineupResponseAttributes5.getSummary();
                        Intrinsics.checkNotNullExpressionValue((Object)eventSummary3, (String)"attributes.summary");
                        EventTeam eventTeam3 = eventSummary3.getHomeTeam();
                        Intrinsics.checkNotNullExpressionValue((Object)eventTeam3, (String)"attributes.summary.homeTeam");
                        List list2 = eventTeam3.getColorsList();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"attributes.summary.homeTeam.colorsList");
                        for (Object t : list2) {
                            object6 = t;
                            object22 = (String)t;
                            LineupResponse.ResponseData.LineupResponseAttributes lineupResponseAttributes6 = object.getAttributes();
                            Intrinsics.checkNotNullExpressionValue((Object)lineupResponseAttributes6, (String)"attributes");
                            EventSummary eventSummary4 = lineupResponseAttributes6.getSummary();
                            Intrinsics.checkNotNullExpressionValue((Object)eventSummary4, (String)"attributes.summary");
                            EventTeam eventTeam4 = eventSummary4.getAwayTeam();
                            Intrinsics.checkNotNullExpressionValue((Object)eventTeam4, (String)"attributes.summary.awayTeam");
                            if (!(eventTeam4.getColorsList().contains(object22) ^ true)) continue;
                            break block8;
                        }
                        object6 = null;
                    }
                    object5 = (String)object6;
                    LineupResponse.ResponseData.LineupResponseAttributes lineupResponseAttributes7 = object.getAttributes();
                    Intrinsics.checkNotNullExpressionValue((Object)lineupResponseAttributes7, (String)"attributes");
                    EventSummary eventSummary5 = lineupResponseAttributes7.getSummary();
                    Intrinsics.checkNotNullExpressionValue((Object)eventSummary5, (String)"attributes.summary");
                    EventTeam eventTeam5 = eventSummary5.getAwayTeam();
                    Intrinsics.checkNotNullExpressionValue((Object)eventTeam5, (String)"attributes.summary.awayTeam");
                    List list3 = eventTeam5.getColorsList();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"attributes.summary.awayTeam.colorsList");
                    for (Object object22 : list3) {
                        string2 = (String)object22;
                        LineupResponse.ResponseData.LineupResponseAttributes lineupResponseAttributes8 = object.getAttributes();
                        Intrinsics.checkNotNullExpressionValue((Object)lineupResponseAttributes8, (String)"attributes");
                        EventSummary eventSummary6 = lineupResponseAttributes8.getSummary();
                        Intrinsics.checkNotNullExpressionValue((Object)eventSummary6, (String)"attributes.summary");
                        EventTeam eventTeam6 = eventSummary6.getHomeTeam();
                        Intrinsics.checkNotNullExpressionValue((Object)eventTeam6, (String)"attributes.summary.homeTeam");
                        if (!(eventTeam6.getColorsList().contains(string2) ^ true)) continue;
                        break block9;
                    }
                    object22 = null;
                }
                object6 = (String)object22;
            }
        }
        object22 = soccerTeam2;
        SoccerMatchLineup soccerMatchLineup2 = object3;
        LineupResponse.ResponseData.LineupResponseAttributes lineupResponseAttributes9 = object.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)lineupResponseAttributes9, (String)"attributes");
        EventSummary eventSummary7 = lineupResponseAttributes9.getSummary();
        Intrinsics.checkNotNullExpressionValue((Object)eventSummary7, (String)"attributes.summary");
        EventTeam eventTeam7 = eventSummary7.getHomeTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam7, (String)"attributes.summary.homeTeam");
        object3 = eventTeam7.getLogo();
        string2 = soccerMatchLineup2.getFormationString();
        LineupResponse.ResponseData.LineupResponseAttributes lineupResponseAttributes10 = object.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)lineupResponseAttributes10, (String)"attributes");
        EventSummary eventSummary8 = lineupResponseAttributes10.getSummary();
        Intrinsics.checkNotNullExpressionValue((Object)eventSummary8, (String)"attributes.summary");
        EventTeam eventTeam8 = eventSummary8.getHomeTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam8, (String)"attributes.summary.homeTeam");
        List list4 = eventTeam8.getColorsList();
        soccerTeam2 = new SoccerTeam((String)object3, string2, arrayMap, list, arrayList5, list4, (String)object5);
        object3 = soccerTeam;
        LineupResponse.ResponseData responseData2 = object;
        LineupResponse.ResponseData.LineupResponseAttributes lineupResponseAttributes11 = object.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)lineupResponseAttributes11, (String)"attributes");
        EventSummary eventSummary9 = lineupResponseAttributes11.getSummary();
        Intrinsics.checkNotNullExpressionValue((Object)eventSummary9, (String)"attributes.summary");
        EventTeam eventTeam9 = eventSummary9.getAwayTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam9, (String)"attributes.summary.awayTeam");
        object = eventTeam9.getLogo();
        object4 = object4.getFormationString();
        LineupResponse.ResponseData.LineupResponseAttributes lineupResponseAttributes12 = responseData2.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)lineupResponseAttributes12, (String)"attributes");
        EventSummary eventSummary10 = lineupResponseAttributes12.getSummary();
        Intrinsics.checkNotNullExpressionValue((Object)eventSummary10, (String)"attributes.summary");
        EventTeam eventTeam10 = eventSummary10.getAwayTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam10, (String)"attributes.summary.awayTeam");
        list = eventTeam10.getColorsList();
        soccerTeam = new SoccerTeam((String)object, (String)object4, (ArrayMap<Integer, Set<SoccerTeamMember>>)iterator, (List<SoccerTeamMember>)arrayList6, (List<SoccerTeamMember>)arrayList7, (List<String>)list, (String)object6);
        return new Pair(object22, object3);
    }

    @NotNull
    public static final SoccerGameSummary toDomainSoccer(@NotNull SummaryResponse.ResponseData object) {
        ArrayList arrayList;
        SoccerGameStats soccerGameStats;
        SoccerGameStats soccerGameStats2;
        SoccerGameStats soccerGameStats3;
        SoccerGameStats soccerGameStats4;
        SoccerGameStats soccerGameStats5;
        SoccerGameStats soccerGameStats6;
        SoccerGameStats soccerGameStats7;
        SoccerGameStats soccerGameStats8;
        SoccerGameStats soccerGameStats9;
        SoccerGameStats soccerGameStats10;
        SoccerGameStats soccerGameStats11;
        SoccerGameStats soccerGameStats12;
        SoccerGameStats soccerGameStats13;
        SoccerGameStats soccerGameStats14;
        SoccerGameStats soccerGameStats15;
        SoccerGameStats soccerGameStats16;
        SoccerGameStats soccerGameStats17;
        ArrayList arrayList2;
        SoccerGame soccerGame;
        SummaryResponse.ResponseData responseData = object;
        Intrinsics.checkNotNullParameter((Object)responseData, (String)"$this$toDomainSoccer");
        SummaryResponse.ResponseData.SummaryResponseAttributes summaryResponseAttributes = responseData.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)summaryResponseAttributes, (String)"attributes");
        object = summaryResponseAttributes.getSummary();
        SoccerGame soccerGame2 = soccerGame;
        SummaryResponse.ResponseData responseData2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)responseData2, (String)"summary");
        EventTeam eventTeam = responseData2.getHomeTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam, (String)"summary.homeTeam");
        object = eventTeam.getAlias();
        EventTeam eventTeam2 = responseData2.getHomeTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam2, (String)"summary.homeTeam");
        ArrayList arrayList3 = eventTeam2.getLogo();
        EventTeam eventTeam3 = responseData2.getAwayTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam3, (String)"summary.awayTeam");
        Object object2 = eventTeam3.getAlias();
        EventTeam eventTeam4 = responseData2.getAwayTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam4, (String)"summary.awayTeam");
        Object object3 = eventTeam4.getLogo();
        int n = responseData2.getScoreHome();
        int n2 = responseData2.getScoreAway();
        EventTime eventTime = responseData2.getEventTime();
        Intrinsics.checkNotNullExpressionValue((Object)eventTime, (String)"summary.eventTime");
        Object object4 = eventTime.getClock();
        EventTeam eventTeam5 = responseData2.getAwayTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam5, (String)"summary.awayTeam");
        Object object5 = eventTeam5.getColorsList();
        EventTeam eventTeam6 = responseData2.getHomeTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam6, (String)"summary.homeTeam");
        arrayList3 = eventTeam6.getColorsList();
        soccerGame = new SoccerGame((String)((Object)arrayList3), (String)object3, (String)object, (String)object2, n, n2, (String)object4, arrayList3, (List<String>)object5);
        SummaryResponse.ResponseData.SummaryResponseAttributes summaryResponseAttributes2 = responseData.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)summaryResponseAttributes2, (String)"attributes");
        com.streamlayer.sports.soccer.EventSummary eventSummary = summaryResponseAttributes2.getSoccer();
        Intrinsics.checkNotNullExpressionValue((Object)eventSummary, (String)"attributes.soccer");
        object = eventSummary.getStatistics();
        arrayList3 = arrayList2;
        Object object6 = object;
        arrayList3();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"statistics");
        SoccerTeamSummary soccerTeamSummary = object6.getHomeStatistics();
        Intrinsics.checkNotNullExpressionValue((Object)soccerTeamSummary, (String)"statistics.homeStatistics");
        object = soccerTeamSummary.getTopMatchStats();
        SoccerTeamSummary soccerTeamSummary2 = object6.getAwayStatistics();
        Intrinsics.checkNotNullExpressionValue((Object)soccerTeamSummary2, (String)"statistics.awayStatistics");
        object2 = soccerTeamSummary2.getTopMatchStats();
        SoccerTeamSummary soccerTeamSummary3 = object6.getHomeStatistics();
        Intrinsics.checkNotNullExpressionValue((Object)soccerTeamSummary3, (String)"statistics.homeStatistics");
        object3 = soccerTeamSummary3.getAttackingStats();
        SoccerTeamSummary soccerTeamSummary4 = object6.getAwayStatistics();
        Intrinsics.checkNotNullExpressionValue((Object)soccerTeamSummary4, (String)"statistics.awayStatistics");
        Object object7 = soccerTeamSummary4.getAttackingStats();
        SoccerTeamSummary soccerTeamSummary5 = object6.getHomeStatistics();
        Intrinsics.checkNotNullExpressionValue((Object)soccerTeamSummary5, (String)"statistics.homeStatistics");
        Object object8 = soccerTeamSummary5.getDefenseStats();
        SoccerTeamSummary soccerTeamSummary6 = object6.getAwayStatistics();
        Intrinsics.checkNotNullExpressionValue((Object)soccerTeamSummary6, (String)"statistics.awayStatistics");
        object4 = soccerTeamSummary6.getDefenseStats();
        Object[] objectArray = new SoccerGameStats[8];
        object5 = soccerGameStats17;
        String string2 = object2;
        Object object9 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"homeTopStats");
        Object object10 = object9.getPossession();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"awayTopStats");
        Number number = string2.getPossession();
        soccerGameStats17 = new SoccerGameStats("Possession", (Number)object10, number);
        objectArray[0] = object5;
        object5 = soccerGameStats16;
        object10 = object.getShots();
        number = object2.getShots();
        soccerGameStats16 = new SoccerGameStats("Shots", (Number)object10, number);
        objectArray[1] = object5;
        object5 = soccerGameStats15;
        object10 = object.getShotsOnTarget();
        number = object2.getShotsOnTarget();
        soccerGameStats15 = new SoccerGameStats("Shots on target", (Number)object10, number);
        objectArray[2] = object5;
        object5 = soccerGameStats14;
        object10 = object.getPasses();
        number = object2.getPasses();
        soccerGameStats14 = new SoccerGameStats("Passes", (Number)object10, number);
        objectArray[3] = object5;
        object5 = soccerGameStats13;
        object10 = object.getOffsides();
        number = object2.getOffsides();
        soccerGameStats13 = new SoccerGameStats("Offsides", (Number)object10, number);
        objectArray[4] = object5;
        object5 = soccerGameStats12;
        object10 = object.getYellowCards();
        number = object2.getYellowCards();
        soccerGameStats12 = new SoccerGameStats("Yellow cards", (Number)object10, number);
        objectArray[5] = object5;
        object5 = soccerGameStats11;
        object10 = object.getCornerKicks();
        number = object2.getCornerKicks();
        soccerGameStats11 = new SoccerGameStats("Corner kicks", (Number)object10, number);
        objectArray[6] = object5;
        object5 = soccerGameStats10;
        object = object.getFreeKicks();
        object2 = object2.getFreeKicks();
        soccerGameStats10 = new SoccerGameStats("Free kicks", (Number)object, (Number)object2);
        objectArray[7] = object5;
        arrayList2.add(new SoccerGameStatsGroup("Top Match Stats", CollectionsKt.listOf((Object[])objectArray)));
        Object[] objectArray2 = new SoccerGameStats[4];
        object = soccerGameStats9;
        SoccerTeamAttackingStats soccerTeamAttackingStats = object7;
        String string3 = object3;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"homeAttackStats");
        object2 = string3.getPossession();
        Intrinsics.checkNotNullExpressionValue((Object)soccerTeamAttackingStats, (String)"awayAttackStats");
        object5 = soccerTeamAttackingStats.getPossession();
        soccerGameStats9 = new SoccerGameStats("Possession", (Number)object2, (Number)object5);
        objectArray2[0] = object;
        object = soccerGameStats8;
        object2 = object3.getPassingAccuracy();
        object5 = object7.getPassingAccuracy();
        soccerGameStats8 = new SoccerGameStats("Passing accuracy", (Number)object2, (Number)object5);
        objectArray2[1] = object;
        object = soccerGameStats7;
        object2 = object3.getChancesCreated();
        object5 = object7.getChancesCreated();
        soccerGameStats7 = new SoccerGameStats("Chances created", (Number)object2, (Number)object5);
        objectArray2[2] = object;
        object = soccerGameStats6;
        object2 = object3.getSuccessfulCrosses();
        object3 = object7.getSuccessfulCrosses();
        soccerGameStats6 = new SoccerGameStats("Successful crosses", (Number)object2, (Number)object3);
        objectArray2[3] = object;
        arrayList2.add(new SoccerGameStatsGroup("Attacking stats", CollectionsKt.listOf((Object[])objectArray2)));
        Object[] objectArray3 = new SoccerGameStats[5];
        object = soccerGameStats5;
        String string4 = object4;
        SoccerTeamDefenseStats soccerTeamDefenseStats = object8;
        Intrinsics.checkNotNullExpressionValue((Object)soccerTeamDefenseStats, (String)"homeDefStats");
        object2 = soccerTeamDefenseStats.getTacklesMade();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"awayDefStats");
        object3 = string4.getTacklesMade();
        soccerGameStats5 = new SoccerGameStats("Tackles made", (Number)object2, (Number)object3);
        objectArray3[0] = object;
        object = soccerGameStats4;
        object2 = object8.getInterceptions();
        object3 = object4.getInterceptions();
        soccerGameStats4 = new SoccerGameStats("Interceptions", (Number)object2, (Number)object3);
        objectArray3[1] = object;
        object = soccerGameStats3;
        object2 = object8.getBlockedShots();
        object3 = object4.getBlockedShots();
        soccerGameStats3 = new SoccerGameStats("Blocked shots", (Number)object2, (Number)object3);
        objectArray3[2] = object;
        object = soccerGameStats2;
        object2 = object8.getClearances();
        object3 = object4.getClearances();
        soccerGameStats2 = new SoccerGameStats("Clearances", (Number)object2, (Number)object3);
        objectArray3[3] = object;
        object = soccerGameStats;
        object2 = object8.getDuelsWon();
        object3 = object4.getDuelsWon();
        soccerGameStats = new SoccerGameStats("Duels won", (Number)object2, (Number)object3);
        objectArray3[4] = object;
        arrayList2.add(new SoccerGameStatsGroup("Defence stats", CollectionsKt.listOf((Object[])objectArray3)));
        SummaryResponse.ResponseData.SummaryResponseAttributes summaryResponseAttributes3 = responseData.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)summaryResponseAttributes3, (String)"attributes");
        com.streamlayer.sports.soccer.EventSummary eventSummary2 = summaryResponseAttributes3.getSoccer();
        Intrinsics.checkNotNullExpressionValue((Object)eventSummary2, (String)"attributes.soccer");
        SoccerSummary soccerSummary = eventSummary2.getStatistics();
        Intrinsics.checkNotNullExpressionValue((Object)soccerSummary, (String)"attributes.soccer.statistics");
        SoccerPerformers soccerPerformers = soccerSummary.getPerfomers();
        Intrinsics.checkNotNullExpressionValue((Object)soccerPerformers, (String)"perfomers");
        object = soccerPerformers.getAttackPerformer();
        object2 = soccerPerformers.getMidfieldPerformer();
        object3 = soccerPerformers.getDefensePerformer();
        object7 = arrayList;
        arrayList = new ArrayList();
        if (object.hasPerfomer()) {
            SoccerGamePlayerStats soccerGamePlayerStats;
            SoccerGamePlayerStats soccerGamePlayerStats2;
            SoccerGamePlayerStats soccerGamePlayerStats3;
            SoccerGamePlayerStats soccerGamePlayerStats4;
            SoccerGamePlayerStats soccerGamePlayerStats5;
            SoccerGameTopPlayerStats soccerGameTopPlayerStats;
            object8 = soccerGameTopPlayerStats;
            Object object11 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object11, (String)"attackPerformer");
            SoccerPerformer soccerPerformer = object11.getPerfomer();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPerformer, (String)"attackPerformer.perfomer");
            object4 = soccerPerformer.getPhoto();
            SoccerPerformer soccerPerformer2 = object11.getPerfomer();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPerformer2, (String)"attackPerformer.perfomer");
            object5 = soccerPerformer2.getName();
            Object[] objectArray4 = new SoccerGamePlayerStats[5];
            object10 = soccerGamePlayerStats5;
            SoccerPlayerAttackingStats soccerPlayerAttackingStats = object.getAttackStats();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayerAttackingStats, (String)"attackPerformer.attackStats");
            soccerGamePlayerStats5 = new SoccerGamePlayerStats("G", soccerPlayerAttackingStats.getGoals());
            objectArray4[0] = object10;
            object10 = soccerGamePlayerStats4;
            SoccerPlayerAttackingStats soccerPlayerAttackingStats2 = object.getAttackStats();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayerAttackingStats2, (String)"attackPerformer.attackStats");
            soccerGamePlayerStats4 = new SoccerGamePlayerStats("A", soccerPlayerAttackingStats2.getAssists());
            objectArray4[1] = object10;
            object10 = soccerGamePlayerStats3;
            SoccerPlayerAttackingStats soccerPlayerAttackingStats3 = object.getAttackStats();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayerAttackingStats3, (String)"attackPerformer.attackStats");
            soccerGamePlayerStats3 = new SoccerGamePlayerStats("SH", soccerPlayerAttackingStats3.getShots());
            objectArray4[2] = object10;
            object10 = soccerGamePlayerStats2;
            SoccerPlayerAttackingStats soccerPlayerAttackingStats4 = object.getAttackStats();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayerAttackingStats4, (String)"attackPerformer.attackStats");
            soccerGamePlayerStats2 = new SoccerGamePlayerStats("PKG", soccerPlayerAttackingStats4.getPenaltyKickGoals());
            objectArray4[3] = object10;
            object10 = soccerGamePlayerStats;
            SoccerPlayerAttackingStats soccerPlayerAttackingStats5 = object.getAttackStats();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayerAttackingStats5, (String)"attackPerformer.attackStats");
            soccerGamePlayerStats = new SoccerGamePlayerStats("SHG", soccerPlayerAttackingStats5.getShotsOnGoal());
            objectArray4[4] = object10;
            object = CollectionsKt.listOf((Object[])objectArray4);
            soccerGameTopPlayerStats = new SoccerGameTopPlayerStats((String)object4, "Attack", (String)object5, null, (List<SoccerGamePlayerStats>)object);
            object7.add(object8);
        }
        if (object2.hasPerfomer()) {
            SoccerGamePlayerStats soccerGamePlayerStats;
            SoccerGamePlayerStats soccerGamePlayerStats6;
            SoccerGamePlayerStats soccerGamePlayerStats7;
            SoccerGamePlayerStats soccerGamePlayerStats8;
            SoccerGamePlayerStats soccerGamePlayerStats9;
            SoccerGameTopPlayerStats soccerGameTopPlayerStats;
            object = soccerGameTopPlayerStats;
            Object object12 = object2;
            Intrinsics.checkNotNullExpressionValue((Object)object12, (String)"midPerformer");
            SoccerPerformer soccerPerformer = object12.getPerfomer();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPerformer, (String)"midPerformer.perfomer");
            object8 = soccerPerformer.getPhoto();
            SoccerPerformer soccerPerformer3 = object12.getPerfomer();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPerformer3, (String)"midPerformer.perfomer");
            object4 = soccerPerformer3.getName();
            Object[] objectArray5 = new SoccerGamePlayerStats[5];
            object5 = soccerGamePlayerStats9;
            SoccerPlayerMidfieldStats soccerPlayerMidfieldStats = object2.getMidfieldStats();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayerMidfieldStats, (String)"midPerformer.midfieldStats");
            soccerGamePlayerStats9 = new SoccerGamePlayerStats("G", soccerPlayerMidfieldStats.getGoals());
            objectArray5[0] = object5;
            object5 = soccerGamePlayerStats8;
            SoccerPlayerMidfieldStats soccerPlayerMidfieldStats2 = object2.getMidfieldStats();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayerMidfieldStats2, (String)"midPerformer.midfieldStats");
            soccerGamePlayerStats8 = new SoccerGamePlayerStats("A", soccerPlayerMidfieldStats2.getAssists());
            objectArray5[1] = object5;
            object5 = soccerGamePlayerStats7;
            SoccerPlayerMidfieldStats soccerPlayerMidfieldStats3 = object2.getMidfieldStats();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayerMidfieldStats3, (String)"midPerformer.midfieldStats");
            soccerGamePlayerStats7 = new SoccerGamePlayerStats("KEY", soccerPlayerMidfieldStats3.getKeyPasses());
            objectArray5[2] = object5;
            object5 = soccerGamePlayerStats6;
            SoccerPlayerMidfieldStats soccerPlayerMidfieldStats4 = object2.getMidfieldStats();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayerMidfieldStats4, (String)"midPerformer.midfieldStats");
            soccerGamePlayerStats6 = new SoccerGamePlayerStats("CRS", soccerPlayerMidfieldStats4.getCrosses());
            objectArray5[3] = object5;
            object5 = soccerGamePlayerStats;
            SoccerPlayerMidfieldStats soccerPlayerMidfieldStats5 = object2.getMidfieldStats();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayerMidfieldStats5, (String)"midPerformer.midfieldStats");
            soccerGamePlayerStats = new SoccerGamePlayerStats("COR", soccerPlayerMidfieldStats5.getCorners());
            objectArray5[4] = object5;
            object2 = CollectionsKt.listOf((Object[])objectArray5);
            soccerGameTopPlayerStats = new SoccerGameTopPlayerStats((String)object8, "Midfield", (String)object4, null, (List<SoccerGamePlayerStats>)object2);
            object7.add(object);
        }
        if (object3.hasPerfomer()) {
            SoccerGamePlayerStats soccerGamePlayerStats;
            SoccerGamePlayerStats soccerGamePlayerStats10;
            SoccerGamePlayerStats soccerGamePlayerStats11;
            SoccerGamePlayerStats soccerGamePlayerStats12;
            SoccerGamePlayerStats soccerGamePlayerStats13;
            SoccerGameTopPlayerStats soccerGameTopPlayerStats;
            object = soccerGameTopPlayerStats;
            Object object13 = object3;
            Intrinsics.checkNotNullExpressionValue((Object)object13, (String)"defPerformer");
            SoccerPerformer soccerPerformer = object13.getPerfomer();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPerformer, (String)"defPerformer.perfomer");
            object2 = soccerPerformer.getPhoto();
            SoccerPerformer soccerPerformer4 = object13.getPerfomer();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPerformer4, (String)"defPerformer.perfomer");
            object8 = soccerPerformer4.getName();
            Object[] objectArray6 = new SoccerGamePlayerStats[5];
            object4 = soccerGamePlayerStats13;
            SoccerPlayerDefenseStats soccerPlayerDefenseStats = object3.getDefenseStats();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayerDefenseStats, (String)"defPerformer.defenseStats");
            soccerGamePlayerStats13 = new SoccerGamePlayerStats("G", soccerPlayerDefenseStats.getGoals());
            objectArray6[0] = object4;
            object4 = soccerGamePlayerStats12;
            SoccerPlayerDefenseStats soccerPlayerDefenseStats2 = object3.getDefenseStats();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayerDefenseStats2, (String)"defPerformer.defenseStats");
            soccerGamePlayerStats12 = new SoccerGamePlayerStats("A", soccerPlayerDefenseStats2.getAssists());
            objectArray6[1] = object4;
            object4 = soccerGamePlayerStats11;
            SoccerPlayerDefenseStats soccerPlayerDefenseStats3 = object3.getDefenseStats();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayerDefenseStats3, (String)"defPerformer.defenseStats");
            soccerGamePlayerStats11 = new SoccerGamePlayerStats("TCK", soccerPlayerDefenseStats3.getTacklesMade());
            objectArray6[2] = object4;
            object4 = soccerGamePlayerStats10;
            SoccerPlayerDefenseStats soccerPlayerDefenseStats4 = object3.getDefenseStats();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayerDefenseStats4, (String)"defPerformer.defenseStats");
            soccerGamePlayerStats10 = new SoccerGamePlayerStats("INT", soccerPlayerDefenseStats4.getInterceptions());
            objectArray6[3] = object4;
            object4 = soccerGamePlayerStats;
            SoccerPlayerDefenseStats soccerPlayerDefenseStats5 = object3.getDefenseStats();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayerDefenseStats5, (String)"defPerformer.defenseStats");
            soccerGamePlayerStats = new SoccerGamePlayerStats("BLK", soccerPlayerDefenseStats5.getBlockedShots());
            objectArray6[4] = object4;
            object3 = CollectionsKt.listOf((Object[])objectArray6);
            soccerGameTopPlayerStats = new SoccerGameTopPlayerStats((String)object2, "Defense", (String)object8, null, (List<SoccerGamePlayerStats>)object3);
            object7.add(object);
        }
        return new SoccerGameSummary(soccerGame2, arrayList3, (List)object7, null, 8, null);
    }
}

