/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.sdk.VideoPlayerView;
import io.streamlayer.sdk.databinding.SlrItemTweetBinding;
import io.streamlayer.sdk.model.analytics.InteractionActionType;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.twitter.TweetUI;
import io.streamlayer.sdk.twitter.view.internal.format.TweetFormatter;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideo;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideoController;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u000212Bc\u0012\u0006\u0010)\u001a\u00020(\u0012\u0006\u0010\u001e\u001a\u00020\u001d\u0012%\u0010.\u001a!\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020\r0 j\u0002`-\u0012#\u0010&\u001a\u001f\u0012\u0013\u0012\u00110!\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0006\u0012\u0004\u0018\u00010%0 \u00a2\u0006\u0004\b/\u00100J#\u0010\u0007\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ#\u0010\u000e\u001a\u00020\r2\n\u0010\u000b\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001b\u0010\u0010\u001a\u00020\r2\n\u0010\u000b\u001a\u00060\u0002R\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0015\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u001b8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u001d8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR3\u0010&\u001a\u001f\u0012\u0013\u0012\u00110!\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0006\u0012\u0004\u0018\u00010%0 8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0016\u0010)\u001a\u00020(8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R5\u0010.\u001a!\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020\r0 j\u0002`-8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010'\u00a8\u00063"}, d2={"Lio/streamlayer/sdk/twitter/TweetsAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lio/streamlayer/sdk/twitter/TweetsAdapter$ViewHolder;", "Landroid/view/ViewGroup;", "parent", "", "viewType", "onCreateViewHolder", "(Landroid/view/ViewGroup;I)Lio/streamlayer/sdk/twitter/TweetsAdapter$ViewHolder;", "getItemCount", "()I", "holder", "position", "", "onBindViewHolder", "(Lio/streamlayer/sdk/twitter/TweetsAdapter$ViewHolder;I)V", "onViewRecycled", "(Lio/streamlayer/sdk/twitter/TweetsAdapter$ViewHolder;)V", "", "Lio/streamlayer/sdk/twitter/TweetUI;", "items", "setItems", "(Ljava/util/List;)V", "startPosition", "endPosition", "getItems", "(II)Ljava/util/List;", "", "Ljava/util/List;", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoController;", "tweetVideoController", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoController;", "Lkotlin/Function1;", "Landroid/content/Context;", "Lkotlin/ParameterName;", "name", "context", "Lio/streamlayer/sdk/VideoPlayerView;", "videoPlayerViewBuilder", "Lkotlin/jvm/functions/Function1;", "Lio/streamlayer/sdk/twitter/view/internal/format/TweetFormatter;", "tweetFormatter", "Lio/streamlayer/sdk/twitter/view/internal/format/TweetFormatter;", "Lio/streamlayer/sdk/model/analytics/InteractionActionType;", "actionType", "Lio/streamlayer/sdk/repository/analytics/InteractionListener;", "interactionListener", "<init>", "(Lio/streamlayer/sdk/twitter/view/internal/format/TweetFormatter;Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoController;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "TweetsDiffUtil", "ViewHolder", "sdk_originalRelease"})
public final class TweetsAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final List<TweetUI> items;
    private final TweetFormatter tweetFormatter;
    private final TweetVideoController tweetVideoController;
    private final Function1<InteractionActionType, Unit> interactionListener;
    private final Function1<Context, VideoPlayerView> videoPlayerViewBuilder;

    public TweetsAdapter(@NotNull TweetFormatter tweetFormatter, @NotNull TweetVideoController tweetVideoController2, @NotNull Function1<? super InteractionActionType, Unit> function1, @NotNull Function1<? super Context, ? extends VideoPlayerView> function12) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter((Object)tweetFormatter, (String)"tweetFormatter");
        Intrinsics.checkNotNullParameter((Object)tweetVideoController2, (String)"tweetVideoController");
        Intrinsics.checkNotNullParameter(function1, (String)"interactionListener");
        Intrinsics.checkNotNullParameter(function12, (String)"videoPlayerViewBuilder");
        object.tweetFormatter = tweetFormatter;
        object.tweetVideoController = tweetVideoController2;
        object.interactionListener = function1;
        object.videoPlayerViewBuilder = function12;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.items = object;
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        TweetsAdapter tweetsAdapter2 = object;
        Object object = SlrItemTweetBinding.inflate(LayoutInflater.from((Context)viewGroup.getContext()), viewGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SlrItemTweetBinding.infl\u2026.context), parent, false)");
        return new ViewHolder(tweetsAdapter2, (SlrItemTweetBinding)object);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public void onBindViewHolder(@NotNull ViewHolder viewHolder, int n) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"holder");
        viewHolder.bind(this.items.get(n));
    }

    public void onViewRecycled(@NotNull ViewHolder viewHolder) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"holder");
        super.onViewRecycled((RecyclerView.ViewHolder)viewHolder);
        viewHolder.release();
    }

    public final void setItems(@NotNull List<TweetUI> list) {
        Intrinsics.checkNotNullParameter(list, (String)"items");
        TweetsAdapter tweetsAdapter2 = this;
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)tweetsAdapter2.new TweetsDiffUtil(tweetsAdapter2.items, list));
        TweetsAdapter tweetsAdapter3 = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"DiffUtil.calculateDiff(T\u2026fUtil(this.items, items))");
        tweetsAdapter3.items.clear();
        tweetsAdapter3.items.addAll(list);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)tweetsAdapter3);
    }

    @NotNull
    public final List<TweetUI> getItems(int n, int n2) {
        return n < this.items.size() && n2 <= this.items.size() ? this.items.subList(n, n2) : CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0016\u0010\n\u001a\u00020\t8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lio/streamlayer/sdk/twitter/TweetsAdapter$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lio/streamlayer/sdk/twitter/TweetUI;", "item", "", "bind", "(Lio/streamlayer/sdk/twitter/TweetUI;)V", "release", "()V", "Lio/streamlayer/sdk/databinding/SlrItemTweetBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemTweetBinding;", "<init>", "(Lio/streamlayer/sdk/twitter/TweetsAdapter;Lio/streamlayer/sdk/databinding/SlrItemTweetBinding;)V", "sdk_originalRelease"})
    public final class ViewHolder
    extends RecyclerView.ViewHolder {
        private final SlrItemTweetBinding binding;
        final /* synthetic */ TweetsAdapter this$0;

        public ViewHolder(@NotNull TweetsAdapter tweetsAdapter2, SlrItemTweetBinding slrItemTweetBinding) {
            SlrItemTweetBinding slrItemTweetBinding2 = slrItemTweetBinding;
            Intrinsics.checkNotNullParameter((Object)slrItemTweetBinding, (String)"binding");
            this.this$0 = tweetsAdapter2;
            super((View)slrItemTweetBinding.getRoot());
            this.binding = slrItemTweetBinding;
            slrItemTweetBinding2.getRoot().setInteractionListener((Function1<? super InteractionActionType, Unit>)tweetsAdapter2.interactionListener);
            slrItemTweetBinding2.getRoot().setVideoController(tweetsAdapter2.tweetVideoController);
            slrItemTweetBinding2.getRoot().setVideoPlayerViewBuilder((Function1<? super Context, ? extends VideoPlayerView>)tweetsAdapter2.videoPlayerViewBuilder);
        }

        public final void bind(@NotNull TweetUI object) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"item");
            TweetUI tweetUI = object;
            object = tweetUI.getTweet();
            TweetVideo tweetVideo = tweetUI.getVideo();
            this.binding.getRoot().showTweet((Tweet)object, tweetVideo, this.this$0.tweetFormatter);
        }

        public final void release() {
            this.binding.getRoot().release();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\u001f\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0007R\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lio/streamlayer/sdk/twitter/TweetsAdapter$TweetsDiffUtil;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "", "oldItemPosition", "newItemPosition", "", "areItemsTheSame", "(II)Z", "getOldListSize", "()I", "getNewListSize", "areContentsTheSame", "", "Lio/streamlayer/sdk/twitter/TweetUI;", "oldItems", "Ljava/util/List;", "newItems", "<init>", "(Lio/streamlayer/sdk/twitter/TweetsAdapter;Ljava/util/List;Ljava/util/List;)V", "sdk_originalRelease"})
    public final class TweetsDiffUtil
    extends DiffUtil.Callback {
        private final List<TweetUI> oldItems;
        private final List<TweetUI> newItems;

        public TweetsDiffUtil(@NotNull List<TweetUI> list, List<TweetUI> list2) {
            Intrinsics.checkNotNullParameter(list, (String)"oldItems");
            Intrinsics.checkNotNullParameter(list2, (String)"newItems");
            this.oldItems = list;
            this.newItems = list2;
        }

        public boolean areItemsTheSame(int n, int n2) {
            TweetUI tweetUI = ((TweetsDiffUtil)((Object)tweetUI)).newItems.get(n2);
            return Intrinsics.areEqual((Object)((TweetsDiffUtil)((Object)tweetUI)).oldItems.get(n).getTweet().getId(), (Object)tweetUI.getTweet().getId());
        }

        public int getOldListSize() {
            return this.oldItems.size();
        }

        public int getNewListSize() {
            return this.newItems.size();
        }

        public boolean areContentsTheSame(int n, int n2) {
            TweetUI tweetUI = ((TweetsDiffUtil)((Object)tweetUI2)).oldItems.get(n);
            TweetUI tweetUI2 = ((TweetsDiffUtil)((Object)tweetUI2)).newItems.get(n2);
            return Intrinsics.areEqual((Object)tweetUI.getTweet(), (Object)tweetUI2.getTweet()) && Intrinsics.areEqual((Object)tweetUI.getVideo(), (Object)tweetUI2.getVideo());
        }
    }
}

