/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view.internal.media;

import io.streamlayer.common.media.MediaProvider;
import io.streamlayer.sdk.VideoPlayer;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideo;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideoPlayerCache;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J!\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\"\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\u000e8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoComponent;", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoPlayerCache;", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;", "video", "", "forceCreate", "Lio/streamlayer/sdk/VideoPlayer;", "getPlayer", "(Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;Z)Lio/streamlayer/sdk/VideoPlayer;", "", "releasePlayer", "(Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;)V", "release", "()V", "", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo$Url;", "playersCache", "Ljava/util/Map;", "Lio/streamlayer/common/media/MediaProvider;", "mediaProvider", "Lio/streamlayer/common/media/MediaProvider;", "<init>", "(Lio/streamlayer/common/media/MediaProvider;)V", "sdk_originalRelease"})
public final class TweetVideoComponent
implements TweetVideoPlayerCache {
    private final Map<TweetVideo.Url, VideoPlayer> playersCache;
    private MediaProvider mediaProvider;

    public TweetVideoComponent(@NotNull MediaProvider mediaProvider) {
        LinkedHashMap linkedHashMap;
        Intrinsics.checkNotNullParameter((Object)mediaProvider, (String)"mediaProvider");
        ((TweetVideoComponent)((Object)linkedHashMap2)).mediaProvider = mediaProvider;
        LinkedHashMap linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        v1.playersCache = linkedHashMap2;
    }

    @Override
    @Nullable
    public VideoPlayer getPlayer(@NotNull TweetVideo tweetVideo, boolean bl) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)tweetVideo, (String)"video");
        Object object2 = tweetVideoComponent.playersCache.get(tweetVideo.getUrl());
        if (object2 != null) {
            object = object2;
        } else if (!bl) {
            TweetVideoComponent tweetVideoComponent = null;
            object = tweetVideoComponent;
        } else {
            object = tweetVideoComponent.mediaProvider.getVideoPlayerProvider();
            if (object != null) {
                TweetVideo tweetVideo2 = tweetVideo;
                object2 = tweetVideo2.getUrl().getValue();
                VideoPlayer.Type type2 = tweetVideo2.isHlsType() ? VideoPlayer.Type.HLS : VideoPlayer.Type.DEFAULT;
                VideoPlayer.RepeatMode repeatMode = tweetVideo.isLooping() ? VideoPlayer.RepeatMode.ONE : VideoPlayer.RepeatMode.OFF;
                object = object.getVideoPlayer((String)object2, type2, repeatMode);
            } else {
                object = null;
            }
            if (object != null) {
                tweetVideoComponent.playersCache.put(tweetVideo.getUrl(), (VideoPlayer)object);
            }
        }
        return object;
    }

    @Override
    public void releasePlayer(@NotNull TweetVideo tweetVideo) {
        Intrinsics.checkNotNullParameter((Object)tweetVideo, (String)"video");
        VideoPlayer videoPlayer = this.playersCache.get(tweetVideo.getUrl());
        if (videoPlayer != null) {
            videoPlayer.release();
        }
        this.playersCache.remove(tweetVideo.getUrl());
    }

    @Override
    public void release() {
        Iterator<Map.Entry<TweetVideo.Url, VideoPlayer>> iterator = this.playersCache.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next().getValue().release();
        }
        this.playersCache.clear();
    }
}

