/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.session;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.lifecycle.LiveData;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import com.google.gson.reflect.TypeToken;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.streamlayer.common.session.LiveDataSession;
import io.streamlayer.common.session.Session;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.model.auth.AuthByType;
import io.streamlayer.sdk.model.auth.User;
import io.streamlayer.sdk.model.auth.VoximplantUser;
import io.streamlayer.sdk.model.sdksettings.ClientSettings;
import io.streamlayer.sdk.model.sdksettings.OrganizationSettings;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.utils.GsonUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0000\u0018\u0000 \u0089\u00012\u00020\u0001:\u0002\u0089\u0001B\u0011\u0012\u0006\u0010=\u001a\u00020<\u00a2\u0006\u0006\b\u0087\u0001\u0010\u0088\u0001J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\r\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u001d\u0010\u0014\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0016H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u0015\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0018J\u000f\u0010\u001c\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0011\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b!\u0010\u0011J\u0017\u0010#\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b#\u0010$J\u001b\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020&0%H\u0016\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010*\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b*\u0010+J\u0015\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0%H\u0016\u00a2\u0006\u0004\b,\u0010(J\u0015\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00190%H\u0016\u00a2\u0006\u0004\b-\u0010(J\u0015\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0\u0016H\u0016\u00a2\u0006\u0004\b.\u0010\u0018J\u0017\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0016H\u0016\u00a2\u0006\u0004\b/\u0010\u0018J\u001f\u00102\u001a\u00020\f2\u0006\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b2\u00103J\u0017\u00104\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b4\u00105R$\u00106\u001a\u0004\u0018\u00010\b8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b6\u00107\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0016\u0010=\u001a\u00020<8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>R$\u0010B\u001a\u00020\b2\u0006\u0010?\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b@\u00109\"\u0004\bA\u0010;R(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010C\"\u0004\bD\u0010ER(\u0010H\u001a\u0004\u0018\u00010\b2\b\u0010?\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bF\u00109\"\u0004\bG\u0010;R(\u0010L\u001a\u0004\u0018\u00010\u00192\b\u0010?\u001a\u0004\u0018\u00010\u00198V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010I\"\u0004\bJ\u0010KR$\u0010O\u001a\u00020\u00022\u0006\u0010?\u001a\u00020\u00028V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bM\u0010\u0004\"\u0004\bN\u0010+R.\u0010Q\u001a\u0004\u0018\u00010P2\b\u0010?\u001a\u0004\u0018\u00010P8\u0016@VX\u0096\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010R\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR(\u0010Y\u001a\u0004\u0018\u00010\b2\b\u0010?\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bW\u00109\"\u0004\bX\u0010;R%\u0010_\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010P0Z8V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b[\u0010\\\u001a\u0004\b]\u0010^R$\u0010a\u001a\u0004\u0018\u00010`8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\ba\u0010b\u001a\u0004\bc\u0010d\"\u0004\be\u0010fR\u0016\u0010h\u001a\u00020g8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bh\u0010iR\u0018\u0010\t\u001a\u0004\u0018\u00010\b8V@\u0016X\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bj\u00109R(\u0010m\u001a\u0004\u0018\u00010\b2\b\u0010?\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bk\u00109\"\u0004\bl\u0010;R$\u0010n\u001a\u00020\u000f2\u0006\u0010?\u001a\u00020\u000f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bn\u0010\u0011\"\u0004\bo\u0010pR(\u0010v\u001a\u0004\u0018\u00010q2\b\u0010?\u001a\u0004\u0018\u00010q8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\br\u0010s\"\u0004\bt\u0010uR$\u0010|\u001a\u00020w2\u0006\u0010?\u001a\u00020w8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bx\u0010y\"\u0004\bz\u0010{R\u001e\u0010\u0080\u0001\u001a\u00020g8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b}\u0010\\\u001a\u0004\b~\u0010\u007fR+\u0010\u0083\u0001\u001a\u0004\u0018\u00010\b2\b\u0010?\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\u000e\u001a\u0005\b\u0081\u0001\u00109\"\u0005\b\u0082\u0001\u0010;R(\u0010\u0084\u0001\u001a\u0004\u0018\u00010\b8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0015\n\u0005\b\u0084\u0001\u00107\u001a\u0005\b\u0085\u0001\u00109\"\u0005\b\u0086\u0001\u0010;\u00a8\u0006\u008a\u0001"}, d2={"Lio/streamlayer/common/session/SessionPrefImpl;", "Lio/streamlayer/common/session/Session;", "", "incrementTotalUnreadMessagesCount", "()I", "count", "decreaseTotalUnreadMessagesCount", "(I)I", "", "token", "Lio/streamlayer/sdk/model/auth/User;", "user", "", "setLoggedIn", "(Ljava/lang/String;Lio/streamlayer/sdk/model/auth/User;)V", "", "isLoggedIn", "()Z", "canConnectToTinodeServer", "Lio/streamlayer/common/session/LiveDataSession;", "getUserLoggedInListener", "()Lio/streamlayer/common/session/LiveDataSession;", "Landroidx/lifecycle/LiveData;", "getUserListener", "()Landroidx/lifecycle/LiveData;", "Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "getClientSettingsListener", "getTotalUnreadMessagesCountListener", "logout", "()V", "Lio/streamlayer/sdk/model/sdksettings/OrganizationSettings;", "getOrganizationSettings", "()Lio/streamlayer/sdk/model/sdksettings/OrganizationSettings;", "hasTinodeHost", "settings", "saveOrganizationSettings", "(Lio/streamlayer/sdk/model/sdksettings/OrganizationSettings;)V", "Lio/reactivex/Observable;", "", "getInvitedContactIds", "()Lio/reactivex/Observable;", "contactId", "addInvitedContact", "(I)V", "getUser", "getClientSettings", "getSportsEventChangeListener", "getClientSettingsChangeListener", "muted", "topicId", "setTopicMuted", "(ZLjava/lang/String;)V", "isTopicMuted", "(Ljava/lang/String;)Z", "activeWpId", "Ljava/lang/String;", "getActiveWpId", "()Ljava/lang/String;", "setActiveWpId", "(Ljava/lang/String;)V", "Landroid/content/Context;", "context", "Landroid/content/Context;", "value", "getFirebaseToken", "setFirebaseToken", "firebaseToken", "()Lio/streamlayer/sdk/model/auth/User;", "setUser", "(Lio/streamlayer/sdk/model/auth/User;)V", "getSdkKey", "setSdkKey", "sdkKey", "()Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "setClientSettings", "(Lio/streamlayer/sdk/model/sdksettings/ClientSettings;)V", "clientSettings", "getTotalUnreadMessagesCount", "setTotalUnreadMessagesCount", "totalUnreadMessagesCount", "", "currentEventId", "Ljava/lang/Long;", "getCurrentEventId", "()Ljava/lang/Long;", "setCurrentEventId", "(Ljava/lang/Long;)V", "getCurrentSponsorAdUrl", "setCurrentSponsorAdUrl", "currentSponsorAdUrl", "Lkotlinx/coroutines/flow/StateFlow;", "currentEventIdListener$delegate", "Lkotlin/Lazy;", "getCurrentEventIdListener", "()Lkotlinx/coroutines/flow/StateFlow;", "currentEventIdListener", "Lio/streamlayer/sdk/model/sports/EventSummary;", "currentEvent", "Lio/streamlayer/sdk/model/sports/EventSummary;", "getCurrentEvent", "()Lio/streamlayer/sdk/model/sports/EventSummary;", "setCurrentEvent", "(Lio/streamlayer/sdk/model/sports/EventSummary;)V", "Landroid/content/SharedPreferences;", "mSharedPreferences", "Landroid/content/SharedPreferences;", "getToken", "getTinodeUserId", "setTinodeUserId", "tinodeUserId", "isFirebaseTokenChanged", "setFirebaseTokenChanged", "(Z)V", "Lio/streamlayer/sdk/model/auth/VoximplantUser;", "getVoximplantUser", "()Lio/streamlayer/sdk/model/auth/VoximplantUser;", "setVoximplantUser", "(Lio/streamlayer/sdk/model/auth/VoximplantUser;)V", "voximplantUser", "Lio/streamlayer/sdk/model/auth/AuthByType;", "getAuthByType", "()Lio/streamlayer/sdk/model/auth/AuthByType;", "setAuthByType", "(Lio/streamlayer/sdk/model/auth/AuthByType;)V", "authByType", "mEncryptedSharedPreferences$delegate", "getMEncryptedSharedPreferences", "()Landroid/content/SharedPreferences;", "mEncryptedSharedPreferences", "getPublicWatchPartyData", "setPublicWatchPartyData", "publicWatchPartyData", "currentOverlayIconUrl", "getCurrentOverlayIconUrl", "setCurrentOverlayIconUrl", "<init>", "(Landroid/content/Context;)V", "Companion", "sdk_originalRelease"})
public final class SessionPrefImpl
implements Session {
    private static final String KEY_SDK_KEY = "sdk_key";
    private static final String KEY_USER = "session_user";
    private static final String KEY_TINODE_USER_ID = "session_tinode_user_id";
    private static final String KEY_TOKEN = "session_token";
    private static final String KEY_CLIENT_SETTINGS = "session_client_settings";
    private static final String KEY_MUTED_TOPIC = "muted_topic_";
    private static final String KEY_TOTAL_UNREAD_MESSAGES = "total_unread_messages";
    private static final String KEY_VOXIMPLANT_USER = "slr_voximplant_user";
    private static final String KEY_ORGANIZATION_SETTINGS = "organization_settings";
    private static final String KEY_PUBLIC_WATCH_PARTY = "pubic_watch_party";
    private static final String KEY_AUTH_BY_SDK = "auth_by_type";
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final SharedPreferences mSharedPreferences;
    private final Lazy mEncryptedSharedPreferences$delegate;
    @Nullable
    private String currentOverlayIconUrl;
    @NotNull
    private final Lazy currentEventIdListener$delegate;
    @Nullable
    private Long currentEventId;
    @Nullable
    private EventSummary currentEvent;
    @Nullable
    private String activeWpId;
    private final Context context;

    private final SharedPreferences getMEncryptedSharedPreferences() {
        return (SharedPreferences)this.mEncryptedSharedPreferences$delegate.getValue();
    }

    public SessionPrefImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        SharedPreferences sharedPreferences = context.getSharedPreferences("io.streamlayer.sdk_session", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026xt.MODE_PRIVATE\n        )");
        this.mSharedPreferences = sharedPreferences;
        this.mEncryptedSharedPreferences$delegate = LazyKt.lazy((Function0)new Function0<SharedPreferences>(this){
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(0);
            }

            @NotNull
            public final SharedPreferences invoke() {
                mEncryptedSharedPreferences.2 this_ = EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV;
                EncryptedSharedPreferences.PrefValueEncryptionScheme prefValueEncryptionScheme = EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM;
                return EncryptedSharedPreferences.create((Context)SessionPrefImpl.access$getContext$p(this_.this$0), (String)"io.streamlayer.sdk_encrypted_session", (MasterKey)new MasterKey.Builder(SessionPrefImpl.access$getContext$p(this_.this$0), "_androidx_security_master_key_").setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build(), (EncryptedSharedPreferences.PrefKeyEncryptionScheme)this_, (EncryptedSharedPreferences.PrefValueEncryptionScheme)prefValueEncryptionScheme);
            }
        });
        this.currentEventIdListener$delegate = LazyKt.lazy((Function0)new Function0<MutableStateFlow<Long>>(this){
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(0);
            }

            @NotNull
            public final MutableStateFlow<Long> invoke() {
                return StateFlowKt.MutableStateFlow((Object)this.this$0.getCurrentEventId());
            }
        });
        this.setPublicWatchPartyData(null);
    }

    public static final /* synthetic */ SharedPreferences access$getMSharedPreferences$p(SessionPrefImpl sessionPrefImpl) {
        return sessionPrefImpl.mSharedPreferences;
    }

    public static final /* synthetic */ Context access$getContext$p(SessionPrefImpl sessionPrefImpl) {
        return sessionPrefImpl.context;
    }

    @Override
    @Nullable
    public String getCurrentOverlayIconUrl() {
        return this.currentOverlayIconUrl;
    }

    @Override
    public void setCurrentOverlayIconUrl(@Nullable String string2) {
        this.currentOverlayIconUrl = string2;
    }

    @Override
    @NotNull
    public AuthByType getAuthByType() {
        block3: {
            Object object;
            block2: {
                object = ((SessionPrefImpl)object).mSharedPreferences.getString(KEY_AUTH_BY_SDK, null);
                if (object == null) break block2;
                Object object2 = object;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"this");
                object = AuthByType.valueOf((String)object2);
                if (object != null) break block3;
            }
            object = AuthByType.INTERNAL;
        }
        return object;
    }

    @Override
    public void setAuthByType(@NotNull AuthByType authByType2) {
        Intrinsics.checkNotNullParameter((Object)((Object)authByType2), (String)"value");
        this.mSharedPreferences.edit().putString(KEY_AUTH_BY_SDK, authByType2.name()).apply();
    }

    @Override
    @Nullable
    public String getPublicWatchPartyData() {
        return this.mSharedPreferences.getString(KEY_PUBLIC_WATCH_PARTY, null);
    }

    @Override
    public void setPublicWatchPartyData(@Nullable String string2) {
        this.mSharedPreferences.edit().putString(KEY_PUBLIC_WATCH_PARTY, string2).apply();
    }

    @Override
    @Nullable
    public String getSdkKey() {
        return this.mSharedPreferences.getString(KEY_SDK_KEY, null);
    }

    @Override
    public void setSdkKey(@Nullable String string2) {
        this.mSharedPreferences.edit().putString(KEY_SDK_KEY, string2).apply();
    }

    @Override
    @Nullable
    public String getToken() {
        return this.mSharedPreferences.getString(KEY_TOKEN, null);
    }

    @Override
    @Nullable
    public User getUser() {
        return (User)GsonUtil.INSTANCE.getDefaultGson().fromJson(this.mSharedPreferences.getString(KEY_USER, null), User.class);
    }

    @Override
    public void setUser(@Nullable User user2) {
        this.mSharedPreferences.edit().putString(KEY_USER, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)user2)).apply();
    }

    @Override
    @Nullable
    public VoximplantUser getVoximplantUser() {
        return (VoximplantUser)GsonUtil.INSTANCE.getDefaultGson().fromJson(this.getMEncryptedSharedPreferences().getString(KEY_VOXIMPLANT_USER, null), VoximplantUser.class);
    }

    @Override
    public void setVoximplantUser(@Nullable VoximplantUser voximplantUser) {
        this.getMEncryptedSharedPreferences().edit().putString(KEY_VOXIMPLANT_USER, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)voximplantUser)).apply();
    }

    @Override
    @Nullable
    public String getTinodeUserId() {
        return this.mSharedPreferences.getString(KEY_TINODE_USER_ID, null);
    }

    @Override
    public void setTinodeUserId(@Nullable String string2) {
        this.mSharedPreferences.edit().putString(KEY_TINODE_USER_ID, string2).apply();
    }

    @Override
    @Nullable
    public ClientSettings getClientSettings() {
        return (ClientSettings)GsonUtil.INSTANCE.getDefaultGson().fromJson(this.mSharedPreferences.getString(KEY_CLIENT_SETTINGS, null), ClientSettings.class);
    }

    @Override
    public void setClientSettings(@Nullable ClientSettings clientSettings) {
        this.mSharedPreferences.edit().putString(KEY_CLIENT_SETTINGS, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)clientSettings)).apply();
    }

    @Override
    @NotNull
    public String getFirebaseToken() {
        Object object = ((SessionPrefImpl)object).mSharedPreferences.getString("firebase_token", "");
        if (object == null) {
            object = "";
        }
        return object;
    }

    @Override
    public void setFirebaseToken(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"value");
        this.mSharedPreferences.edit().putString("firebase_token", string2).apply();
    }

    @Override
    public boolean isFirebaseTokenChanged() {
        return this.mSharedPreferences.getBoolean("firebase_token_changed", true);
    }

    @Override
    public void setFirebaseTokenChanged(boolean bl) {
        this.mSharedPreferences.edit().putBoolean("firebase_token_changed", bl).apply();
    }

    @Override
    @Nullable
    public String getCurrentSponsorAdUrl() {
        return this.mSharedPreferences.getString("current_sponsor_ad_url", null);
    }

    @Override
    public void setCurrentSponsorAdUrl(@Nullable String string2) {
        this.mSharedPreferences.edit().putString("current_sponsor_ad_url", string2).apply();
    }

    @Override
    @NotNull
    public StateFlow<Long> getCurrentEventIdListener() {
        return (StateFlow)this.currentEventIdListener$delegate.getValue();
    }

    @Override
    @Nullable
    public Long getCurrentEventId() {
        return this.currentEventId;
    }

    @Override
    public void setCurrentEventId(@Nullable Long l) {
        this.currentEventId = l;
        if (this.getCurrentEventIdListener() instanceof MutableStateFlow) {
            if ((this = this.getCurrentEventIdListener()) != null) {
                ((MutableStateFlow)this).setValue((Object)l);
            } else {
                throw new NullPointerException("null cannot be cast to non-null type kotlinx.coroutines.flow.MutableStateFlow<kotlin.Long?>");
            }
        }
    }

    @Override
    @Nullable
    public EventSummary getCurrentEvent() {
        return this.currentEvent;
    }

    @Override
    public void setCurrentEvent(@Nullable EventSummary eventSummary) {
        this.currentEvent = eventSummary;
    }

    @Override
    public int getTotalUnreadMessagesCount() {
        return this.mSharedPreferences.getInt(KEY_TOTAL_UNREAD_MESSAGES, 0);
    }

    @Override
    public void setTotalUnreadMessagesCount(int n) {
        this.mSharedPreferences.edit().putInt(KEY_TOTAL_UNREAD_MESSAGES, n).apply();
    }

    @Override
    @Nullable
    public String getActiveWpId() {
        return this.activeWpId;
    }

    @Override
    public void setActiveWpId(@Nullable String string2) {
        this.activeWpId = string2;
    }

    @Override
    public int incrementTotalUnreadMessagesCount() {
        int n = this.getTotalUnreadMessagesCount() + 1;
        this.setTotalUnreadMessagesCount(n);
        return n;
    }

    @Override
    public int decreaseTotalUnreadMessagesCount(int n) {
        SessionPrefImpl sessionPrefImpl = this;
        sessionPrefImpl.setTotalUnreadMessagesCount(Math.max(0, sessionPrefImpl.getTotalUnreadMessagesCount() - n));
        return sessionPrefImpl.getTotalUnreadMessagesCount();
    }

    @Override
    public void setLoggedIn(@Nullable String string2, @Nullable User user2) {
        this.mSharedPreferences.edit().putString(KEY_TOKEN, string2).putString(KEY_USER, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)user2)).apply();
    }

    @Override
    public boolean isLoggedIn() {
        String string2 = this.getToken();
        return !(string2 == null || string2.length() == 0) && this.getUser() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canConnectToTinodeServer() {
        if (!((SessionPrefImpl)this).isLoggedIn()) return false;
        if (!((SessionPrefImpl)this).hasTinodeHost()) return false;
        if ((this = ((SessionPrefImpl)this).getSdkKey()) == null) return false;
        if (this.length() != 0) return true;
        return false;
    }

    @NotNull
    public LiveDataSession<String, Boolean> getUserLoggedInListener() {
        Object object = getUserLoggedInListener.1.INSTANCE;
        return new LiveDataSession<String, Boolean>(true, object.mSharedPreferences, KEY_TOKEN, (Function1<String, Boolean>)object);
    }

    @Override
    @NotNull
    public LiveData<User> getUserListener() {
        Object object = getUserListener.1.INSTANCE;
        return new LiveDataSession(true, object.mSharedPreferences, KEY_USER, object);
    }

    @Override
    @NotNull
    public LiveData<ClientSettings> getClientSettingsListener() {
        Object object = getClientSettingsListener.1.INSTANCE;
        return new LiveDataSession(true, object.mSharedPreferences, KEY_CLIENT_SETTINGS, object);
    }

    @Override
    @NotNull
    public LiveData<Integer> getTotalUnreadMessagesCountListener() {
        return new LiveDataSession(true, this.mSharedPreferences, KEY_TOTAL_UNREAD_MESSAGES, null, 8, null);
    }

    @Override
    public void logout() {
        SessionPrefImpl sessionPrefImpl = this;
        sessionPrefImpl.setLoggedIn(null, null);
        sessionPrefImpl.setTinodeUserId(null);
        sessionPrefImpl.setClientSettings(null);
        sessionPrefImpl.setFirebaseTokenChanged(true);
        sessionPrefImpl.setTotalUnreadMessagesCount(0);
        sessionPrefImpl.setVoximplantUser(null);
    }

    @Override
    @Nullable
    public OrganizationSettings getOrganizationSettings() {
        Object object;
        if (((SessionPrefImpl)object).mSharedPreferences.contains(KEY_ORGANIZATION_SETTINGS)) {
            try {
                object = (OrganizationSettings)GsonUtil.INSTANCE.getDefaultGson().fromJson(((SessionPrefImpl)object).mSharedPreferences.getString(KEY_ORGANIZATION_SETTINGS, "[]"), OrganizationSettings.class);
            }
            catch (Exception exception) {
                ((SessionPrefImpl)object).mSharedPreferences.edit().remove(KEY_ORGANIZATION_SETTINGS);
                object = null;
            }
        } else {
            object = null;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasTinodeHost() {
        if (!((SessionPrefImpl)((Object)string2)).mSharedPreferences.contains(KEY_ORGANIZATION_SETTINGS)) return false;
        String string2 = ((OrganizationSettings)GsonUtil.INSTANCE.getDefaultGson().fromJson(((SessionPrefImpl)((Object)string2)).mSharedPreferences.getString(KEY_ORGANIZATION_SETTINGS, "[]"), OrganizationSettings.class)).getTinodeHost();
        if (string2 == null) return false;
        if (string2.length() != 0) return true;
        return false;
    }

    @Override
    public void saveOrganizationSettings(@NotNull OrganizationSettings organizationSettings) {
        Intrinsics.checkNotNullParameter((Object)organizationSettings, (String)"settings");
        this.mSharedPreferences.edit().putString(KEY_ORGANIZATION_SETTINGS, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)organizationSettings)).apply();
    }

    @Override
    @NotNull
    public Observable<List<Integer>> getInvitedContactIds() {
        SessionPrefImpl sessionPrefImpl;
        if (sessionPrefImpl.mSharedPreferences.contains("invited_contact_ids")) {
            sessionPrefImpl = Observable.fromCallable(new Callable<List<? extends Integer>>(sessionPrefImpl){
                final /* synthetic */ SessionPrefImpl this$0;
                {
                    this.this$0 = sessionPrefImpl;
                }

                public final List<Integer> call() {
                    return (List)GsonUtil.INSTANCE.getDefaultGson().fromJson(SessionPrefImpl.access$getMSharedPreferences$p(this.this$0).getString("invited_contact_ids", "[]"), new TypeToken<ArrayList<Integer>>(){}.getType());
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)sessionPrefImpl, (String)"Observable.fromCallable<\u2026          )\n            }");
        } else {
            sessionPrefImpl = Observable.just((Object)CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue((Object)sessionPrefImpl, (String)"Observable.just(listOf())");
        }
        return sessionPrefImpl;
    }

    @Override
    public void addInvitedContact(int n) {
        ArrayList<Integer> arrayList;
        Object object = arrayList;
        arrayList = new ArrayList<Integer>();
        if (this.mSharedPreferences.contains("invited_contact_ids")) {
            object = new TypeToken<ArrayList<Integer>>(){}.getType();
            object = GsonUtil.INSTANCE.getDefaultGson().fromJson(this.mSharedPreferences.getString("invited_contact_ids", "[]"), (Type)object);
            if (object != null) {
                object = (ArrayList)object;
            } else {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.ArrayList<kotlin.Int> /* = java.util.ArrayList<kotlin.Int> */");
            }
        }
        ((ArrayList)object).add(n);
        this.mSharedPreferences.edit().putString("invited_contact_ids", GsonUtil.INSTANCE.getDefaultGson().toJson(object)).apply();
    }

    @Override
    @NotNull
    public Observable<User> getUser() {
        Observable observable = Observable.create(new ObservableOnSubscribe<User>(this){
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
            }

            public final void subscribe(@NotNull ObservableEmitter<User> observableEmitter) {
                Intrinsics.checkNotNullParameter(observableEmitter, (String)"it");
                User user2 = user2.this$0.getUser();
                if (user2 != null) {
                    observableEmitter.onNext((Object)user2);
                }
                observableEmitter.onComplete();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"Observable.create {\n    \u2026it.onComplete()\n        }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<ClientSettings> getClientSettings() {
        Observable observable = Observable.create(new ObservableOnSubscribe<ClientSettings>(this){
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
            }

            public final void subscribe(@NotNull ObservableEmitter<ClientSettings> observableEmitter) {
                Intrinsics.checkNotNullParameter(observableEmitter, (String)"it");
                ClientSettings clientSettings = clientSettings.this$0.getClientSettings();
                if (clientSettings != null) {
                    observableEmitter.onNext((Object)clientSettings);
                }
                observableEmitter.onComplete();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"Observable.create {\n    \u2026it.onComplete()\n        }");
        return observable;
    }

    @Override
    @NotNull
    public LiveData<String> getSportsEventChangeListener() {
        return new LiveDataSession(true, this.mSharedPreferences, KEY_TOKEN, null, 8, null);
    }

    @Override
    @NotNull
    public LiveData<ClientSettings> getClientSettingsChangeListener() {
        Object object = getClientSettingsChangeListener.1.INSTANCE;
        return new LiveDataSession(false, object.mSharedPreferences, KEY_CLIENT_SETTINGS, object);
    }

    @Override
    public void setTopicMuted(boolean bl, @NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        this.mSharedPreferences.edit().putBoolean(KEY_MUTED_TOPIC + string2, bl).apply();
    }

    @Override
    public boolean isTopicMuted(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        return this.mSharedPreferences.getBoolean(KEY_MUTED_TOPIC + string2, false);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0016\u0010\u0005\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0004R\u0016\u0010\u0006\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0004R\u0016\u0010\u0007\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0004R\u0016\u0010\b\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0004R\u0016\u0010\t\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0004R\u0016\u0010\n\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0004R\u0016\u0010\u000b\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0004R\u0016\u0010\f\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0004R\u0016\u0010\r\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0004R\u0016\u0010\u000e\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0004\u00a8\u0006\u0011"}, d2={"Lio/streamlayer/common/session/SessionPrefImpl$Companion;", "", "", "KEY_AUTH_BY_SDK", "Ljava/lang/String;", "KEY_CLIENT_SETTINGS", "KEY_MUTED_TOPIC", "KEY_ORGANIZATION_SETTINGS", "KEY_PUBLIC_WATCH_PARTY", "KEY_SDK_KEY", "KEY_TINODE_USER_ID", "KEY_TOKEN", "KEY_TOTAL_UNREAD_MESSAGES", "KEY_USER", "KEY_VOXIMPLANT_USER", "<init>", "()V", "sdk_originalRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

