/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.notifications;

import android.content.Context;
import android.content.res.ColorStateList;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.bornfight.utils.adapters.GenericAdapter;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.main.notifications.NotificationsAdapter$NotificationCallViewHolder$WhenMappings;
import io.streamlayer.sdk.main.notifications.NotificationsAdapter$NotificationViewHolder$WhenMappings;
import io.streamlayer.sdk.main.notifications.NotificationsAdapter$WhenMappings;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationBuilder;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.notifications.NotificationKt;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005!\"#$%B\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010\u0006\u001a\u00020\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\r\u001a\u00020\f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0010J%\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017R$\u0010\u0019\u001a\u0004\u0018\u00010\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006&"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;", "Lcom/bornfight/utils/adapters/GenericAdapter;", "Lio/streamlayer/sdk/model/notifications/Notification;", "", "listItems", "", "setItems", "(Ljava/util/List;)V", "", "position", "getItemAndRemove", "(I)Lio/streamlayer/sdk/model/notifications/Notification;", "", "updateItems", "(Ljava/util/List;)Z", "getItemViewType", "(I)I", "viewType", "getLayoutId", "Landroid/view/View;", "view", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "getViewHolder", "(Landroid/view/View;I)Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$OnItemInteractionListener;", "listener", "Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$OnItemInteractionListener;", "getListener", "()Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$OnItemInteractionListener;", "setListener", "(Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$OnItemInteractionListener;)V", "<init>", "()V", "NotificationCallViewHolder", "NotificationCustomViewHolder", "NotificationDiffUtilCallback", "NotificationViewHolder", "OnItemInteractionListener", "sdk_originalRelease"})
public final class NotificationsAdapter
extends GenericAdapter<Notification> {
    @Nullable
    private OnItemInteractionListener listener;

    @Nullable
    public final OnItemInteractionListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable OnItemInteractionListener onItemInteractionListener) {
        this.listener = onItemInteractionListener;
    }

    public void setItems(@NotNull List<Notification> list) {
        Intrinsics.checkNotNullParameter(list, (String)"listItems");
        if (!this.getListItems().containsAll(list)) {
            super.setItems(list);
        }
    }

    @NotNull
    public final Notification getItemAndRemove(int n) {
        Notification notification = (Notification)this.getListItems().remove(n);
        this.notifyItemRemoved(n);
        return notification;
    }

    public final boolean updateItems(@NotNull List<Notification> list) {
        Intrinsics.checkNotNullParameter(list, (String)"listItems");
        if (this.getItemCount() == 0) {
            super.setItems(CollectionsKt.sortedWith(list, new Comparator<T>(){

                public final int compare(T t, T t2) {
                    return ComparisonsKt.compareValues((Comparable)Boolean.valueOf(NotificationKt.isCallType(((Notification)t).getType()) ^ true), (Comparable)Boolean.valueOf(NotificationKt.isCallType(((Notification)t2).getType()) ^ true));
                }
            }));
            return true;
        }
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new NotificationDiffUtilCallback(this.getListItems(), list));
        NotificationsAdapter notificationsAdapter = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"DiffUtil.calculateDiff(N\u2026is.listItems, listItems))");
        notificationsAdapter.setItems(CollectionsKt.sortedWith(list, new Comparator<T>(){

            public final int compare(T t, T t2) {
                return ComparisonsKt.compareValues((Comparable)Boolean.valueOf(NotificationKt.isCallType(((Notification)t).getType()) ^ true), (Comparable)Boolean.valueOf(NotificationKt.isCallType(((Notification)t2).getType()) ^ true));
            }
        }));
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)notificationsAdapter);
        return false;
    }

    public int getItemViewType(int n) {
        int n2 = NotificationsAdapter$WhenMappings.$EnumSwitchMapping$0[((Notification)this.getItem(n)).getType().ordinal()];
        return n2 != 1 ? (n2 != 2 ? 1 : 3) : 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getLayoutId(int n) {
        int n2;
        if (n != 1) {
            if (n != 2) {
                if (n != 3) throw new RuntimeException("Invalid ViewHolder type: " + n);
                n2 = R.layout.slr_item_notification_custom;
                return n2;
            } else {
                n2 = R.layout.slr_item_notification_call;
            }
            return n2;
        } else {
            n2 = R.layout.slr_item_notification;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected GenericAdapter.GenericViewHolder<Notification> getViewHolder(@NotNull View view2, int n) {
        GenericAdapter.GenericViewHolder genericViewHolder;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        if (n != 1) {
            if (n != 2) {
                NotificationCustomViewHolder notificationCustomViewHolder;
                if (n != 3) throw new RuntimeException("Invalid ViewHolder type: " + n);
                genericViewHolder = notificationCustomViewHolder;
                notificationCustomViewHolder = new NotificationCustomViewHolder(view2);
                return genericViewHolder;
            } else {
                NotificationCallViewHolder notificationCallViewHolder;
                genericViewHolder = notificationCallViewHolder;
                notificationCallViewHolder = new NotificationCallViewHolder(view2);
            }
            return genericViewHolder;
        } else {
            NotificationViewHolder notificationViewHolder;
            genericViewHolder = notificationViewHolder;
            notificationViewHolder = new NotificationViewHolder(view2);
        }
        return genericViewHolder;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\u001f\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0007R\u001f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$NotificationDiffUtilCallback;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "", "oldItemPosition", "newItemPosition", "", "areItemsTheSame", "(II)Z", "getOldListSize", "()I", "getNewListSize", "areContentsTheSame", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "newList", "Ljava/util/List;", "getNewList", "()Ljava/util/List;", "oldList", "getOldList", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "sdk_originalRelease"})
    public static final class NotificationDiffUtilCallback
    extends DiffUtil.Callback {
        @NotNull
        private final List<Notification> oldList;
        @NotNull
        private final List<Notification> newList;

        public NotificationDiffUtilCallback(@NotNull List<Notification> list, @NotNull List<Notification> list2) {
            Intrinsics.checkNotNullParameter(list, (String)"oldList");
            Intrinsics.checkNotNullParameter(list2, (String)"newList");
            this.oldList = list;
            this.newList = list2;
        }

        public boolean areItemsTheSame(int n, int n2) {
            return Intrinsics.areEqual((Object)this.oldList.get(n).getSourceUniqueId(), (Object)this.newList.get(n2).getSourceUniqueId());
        }

        public int getOldListSize() {
            return this.oldList.size();
        }

        public int getNewListSize() {
            return this.newList.size();
        }

        public boolean areContentsTheSame(int n, int n2) {
            Notification notification = object.oldList.get(n);
            Object object = object.newList.get(n2);
            return notification.getType() == notification.getType() && Intrinsics.areEqual((Object)notification, (Object)object);
        }

        @NotNull
        public final List<Notification> getOldList() {
            return this.oldList;
        }

        @NotNull
        public final List<Notification> getNewList() {
            return this.newList;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$OnItemInteractionListener;", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "notification", "", "onNotificationClick", "(Lio/streamlayer/sdk/model/notifications/Notification;)V", "sdk_originalRelease"})
    public static interface OnItemInteractionListener {
        public void onNotificationClick(@NotNull Notification var1);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$NotificationCustomViewHolder;", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "(Lio/streamlayer/sdk/model/notifications/Notification;)V", "Landroid/view/View;", "itemView", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;Landroid/view/View;)V", "sdk_originalRelease"})
    public final class NotificationCustomViewHolder
    extends GenericAdapter.GenericViewHolder<Notification> {
        public NotificationCustomViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void bind(@NotNull Notification notification) {
            LayoutInflater layoutInflater;
            Notification notification2 = notification;
            Intrinsics.checkNotNullParameter((Object)notification2, (String)"data");
            NotificationBuilder notificationBuilder = notification2.getCustomBuilder();
            if (notificationBuilder == null) return;
            if (notificationBuilder.getLayoutId() != null) {
                View view2 = notificationCustomViewHolder.itemView;
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"itemView");
                layoutInflater = LayoutInflater.from((Context)view2.getContext());
                Integer n = notificationBuilder.getLayoutId();
                Intrinsics.checkNotNull((Object)n);
                int n2 = n;
                View view3 = notificationCustomViewHolder.itemView;
                if (view3 == null) throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
                layoutInflater = layoutInflater.inflate(n2, (ViewGroup)view3, false);
            } else {
                String string2;
                NotificationCustomViewHolder notificationCustomViewHolder = notificationCustomViewHolder;
                View view4 = notificationCustomViewHolder.itemView;
                Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"itemView");
                layoutInflater = LayoutInflater.from((Context)view4.getContext());
                int n = R.layout.slr_item_notification;
                View view5 = notificationCustomViewHolder.itemView;
                if (view5 == null) throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
                layoutInflater = layoutInflater.inflate(n, (ViewGroup)view5, false);
                Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"this");
                TextView textView = (TextView)layoutInflater.findViewById(R.id.slNotifTitleTV);
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"this.slNotifTitleTV");
                textView.setText((CharSequence)notificationBuilder.getTitle());
                TextView textView2 = (TextView)layoutInflater.findViewById(R.id.slNotifDescriptionTV);
                Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"this.slNotifDescriptionTV");
                textView2.setText((CharSequence)notificationBuilder.getDescription());
                Integer n3 = notificationBuilder.getIconBackgroundColor();
                if (n3 != null) {
                    int n4 = n3;
                    ImageView imageView = (ImageView)layoutInflater.findViewById(R.id.slNotifIconIV);
                    Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"slNotifIconIV");
                    View view6 = notificationCustomViewHolder.itemView;
                    Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"itemView");
                    imageView.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)((ViewGroup)view6).getContext(), (int)n4)));
                }
                if ((string2 = notificationBuilder.getIconUrl()) != null) {
                    ImageView imageView = (ImageView)layoutInflater.findViewById(R.id.slNotifIconIV);
                    Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"slNotifIconIV");
                    ExtensionsKt.loadUrl$default(imageView, string2, false, null, null, 14, null);
                }
            }
            View view7 = notificationCustomViewHolder.itemView;
            if (view7 == null) throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout");
            LayoutInflater layoutInflater2 = layoutInflater;
            ((FrameLayout)view7).addView((View)layoutInflater);
            layoutInflater2.setOnClickListener(new View.OnClickListener(notificationCustomViewHolder, notification){
                final /* synthetic */ NotificationCustomViewHolder this$0;
                final /* synthetic */ Notification $data$inlined;
                {
                    this.this$0 = notificationCustomViewHolder;
                    this.$data$inlined = notification;
                }

                public final void onClick(View object) {
                    object = this.this$0.NotificationsAdapter.this.getListener();
                    if (object != null) {
                        object.onNotificationClick(this.$data$inlined);
                    }
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)layoutInflater2, (String)"view");
            NotificationCustomViewHolder notificationCustomViewHolder = layoutInflater2.getLayoutParams();
            if (notificationCustomViewHolder == null) throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
            notificationCustomViewHolder = (FrameLayout.LayoutParams)notificationCustomViewHolder;
            v11.gravity = 80;
            layoutInflater.setLayoutParams((ViewGroup.LayoutParams)notificationCustomViewHolder);
            notificationBuilder.bindView((View)layoutInflater);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0096\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0003\u00a2\u0006\u0004\b\b\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$NotificationViewHolder;", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/notifications/Notification;", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "type", "", "getIcon", "(Lio/streamlayer/sdk/model/notifications/NotificationType;)I", "getColor", "data", "", "bind", "(Lio/streamlayer/sdk/model/notifications/Notification;)V", "Landroid/view/View;", "itemView", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;Landroid/view/View;)V", "sdk_originalRelease"})
    public class NotificationViewHolder
    extends GenericAdapter.GenericViewHolder<Notification> {
        @DrawableRes
        private final int getIcon(NotificationType notificationType) {
            int n;
            switch (NotificationsAdapter$NotificationViewHolder$WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 9: {
                    n = 0;
                    break;
                }
                case 7: 
                case 8: {
                    n = R.drawable.slr_ic_profile;
                    break;
                }
                case 6: {
                    n = R.drawable.slr_ic_chat;
                    break;
                }
                case 5: {
                    n = R.drawable.slr_ic_twitter;
                    break;
                }
                case 4: {
                    n = R.drawable.slr_ic_chat;
                    break;
                }
                case 3: {
                    n = R.drawable.slr_ic_betting;
                    break;
                }
                case 2: {
                    n = R.drawable.slr_ic_watch_party_centered;
                    break;
                }
                case 1: {
                    n = R.drawable.slr_ic_chat;
                }
            }
            return n;
        }

        @ColorRes
        private final int getColor(NotificationType notificationType) {
            int n;
            switch (NotificationsAdapter$NotificationViewHolder$WhenMappings.$EnumSwitchMapping$1[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 9: {
                    n = 0;
                    break;
                }
                case 7: 
                case 8: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 6: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 5: {
                    n = R.color.slr_twitter;
                    break;
                }
                case 4: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 3: {
                    n = R.color.slr_orange;
                    break;
                }
                case 2: {
                    n = 17170445;
                    break;
                }
                case 1: {
                    n = R.color.slr_primaryBlue;
                }
            }
            return n;
        }

        public NotificationViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
            ((FrameLayout)view2.findViewById(R.id.slNotificationHolder)).setOnTouchListener((View.OnTouchListener)1.INSTANCE);
        }

        public void bind(@NotNull Notification notification) {
            NotificationViewHolder notificationViewHolder = this;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            View view2 = notificationViewHolder.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"itemView");
            TextView textView = (TextView)view2.findViewById(R.id.slNotifTitleTV);
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"itemView.slNotifTitleTV");
            textView.setText((CharSequence)notification.getTitle());
            View view3 = notificationViewHolder.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"itemView");
            Object object = (TextView)view3.findViewById(R.id.slNotifTitleTV);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"itemView.slNotifTitleTV");
            String string2 = notification.getTitle();
            boolean bl = string2 == null || string2.length() == 0;
            NotificationViewHolder notificationViewHolder2 = this;
            ExtensionsKt.visibleIf((View)object, bl ^ true);
            View view4 = notificationViewHolder2.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"itemView");
            TextView textView2 = (TextView)view4.findViewById(R.id.slNotifDescriptionTV);
            Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"itemView.slNotifDescriptionTV");
            textView2.setText((CharSequence)notification.getDescription());
            View view5 = notificationViewHolder2.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"itemView");
            object = (TextView)view5.findViewById(R.id.slNotifDescriptionTV);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"itemView.slNotifDescriptionTV");
            String string3 = notification.getDescription();
            boolean bl2 = string3 == null || string3.length() == 0;
            ExtensionsKt.visibleIf((View)object, bl2 ^ true);
            object = notification.getNotificationIcon();
            if (object != null) {
                if (((NotificationIcon)object).getAvatarName() != null) {
                    View view6 = this.itemView;
                    Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"itemView");
                    ImageView imageView = (ImageView)view6.findViewById(R.id.slNotifIconIV);
                    Object object2 = object;
                    Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"itemView.slNotifIconIV");
                    object = ((NotificationIcon)object2).getAvatarUrl();
                    ProfileExtensionsKt.loadUserAvatar$default(imageView, (String)object, ((NotificationIcon)object2).getAvatarName(), null, 4, null);
                } else if (((NotificationIcon)object).getAvatarUrl() != null) {
                    View view7 = this.itemView;
                    Intrinsics.checkNotNullExpressionValue((Object)view7, (String)"itemView");
                    ImageView imageView = (ImageView)view7.findViewById(R.id.slNotifIconIV);
                    Object object3 = imageView;
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"itemView.slNotifIconIV");
                    object = ((NotificationIcon)object).getAvatarUrl();
                    Intrinsics.checkNotNull((Object)object);
                    object3 = this.getIcon(notification.getType());
                    ExtensionsKt.loadUrl$default(imageView, (String)object, false, (Integer)object3, null, 10, null);
                }
                View view8 = this.itemView;
                Intrinsics.checkNotNullExpressionValue((Object)view8, (String)"itemView");
                ImageView imageView = (ImageView)view8.findViewById(R.id.slNotifIconIV);
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"itemView.slNotifIconIV");
                imageView.setBackgroundTintList(null);
            } else {
                NotificationViewHolder notificationViewHolder3 = this;
                View view9 = notificationViewHolder3.itemView;
                Intrinsics.checkNotNullExpressionValue((Object)view9, (String)"itemView");
                ((ImageView)view9.findViewById(R.id.slNotifIconIV)).setImageResource(this.getIcon(notification.getType()));
                View view10 = notificationViewHolder3.itemView;
                Intrinsics.checkNotNullExpressionValue((Object)view10, (String)"itemView");
                ImageView imageView = (ImageView)view10.findViewById(R.id.slNotifIconIV);
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"itemView.slNotifIconIV");
                View view11 = this.itemView;
                Intrinsics.checkNotNullExpressionValue((Object)view11, (String)"itemView");
                imageView.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)view11.getContext(), (int)this.getColor(notification.getType()))));
            }
            View view12 = this.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view12, (String)"itemView");
            ((ConstraintLayout)view12.findViewById(R.id.slNotification)).setOnClickListener(new View.OnClickListener(this, notification){
                final /* synthetic */ NotificationViewHolder this$0;
                final /* synthetic */ Notification $data;
                {
                    this.this$0 = notificationViewHolder;
                    this.$data = notification;
                }

                public final void onClick(View object) {
                    object = this.this$0.NotificationsAdapter.this.getListener();
                    if (object != null) {
                        object.onNotificationClick(this.$data);
                    }
                }
            });
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$NotificationCallViewHolder;", "Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$NotificationViewHolder;", "Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "(Lio/streamlayer/sdk/model/notifications/Notification;)V", "Landroid/view/View;", "itemView", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;Landroid/view/View;)V", "sdk_originalRelease"})
    public final class NotificationCallViewHolder
    extends NotificationViewHolder {
        public NotificationCallViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
        }

        @Override
        public void bind(@NotNull Notification notification) {
            NotificationCallViewHolder notificationCallViewHolder = this;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            View view2 = notificationCallViewHolder.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"itemView");
            TextView textView = (TextView)view2.findViewById(R.id.slNotifTitleTV);
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"itemView.slNotifTitleTV");
            textView.setText((CharSequence)notification.getTitle());
            View view3 = notificationCallViewHolder.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"itemView");
            TextView textView2 = (TextView)view3.findViewById(R.id.slNotifDescriptionTV);
            Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"itemView.slNotifDescriptionTV");
            textView2.setText((CharSequence)notification.getDescription());
            View view4 = notificationCallViewHolder.itemView;
            if (NotificationsAdapter$NotificationCallViewHolder$WhenMappings.$EnumSwitchMapping$0[notification.getType().ordinal()] != 1) {
                ((ImageView)view4.findViewById(R.id.slNotifIconIV)).setImageResource(R.drawable.slr_ic_watch_party_centered);
            } else {
                view4 = (ImageView)view4.findViewById(R.id.slNotifIconIV);
                Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"slNotifIconIV");
                Object object = notification.getNotificationIcon();
                object = object != null ? ((NotificationIcon)object).getAvatarUrl() : null;
                Object object2 = notification.getNotificationIcon();
                object2 = object2 != null ? ((NotificationIcon)object2).getAvatarName() : null;
                ProfileExtensionsKt.loadUserAvatar$default((ImageView)view4, (String)object, (String)object2, null, 4, null);
            }
            View view5 = this.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"itemView");
            ((ConstraintLayout)view5.findViewById(R.id.slNotification)).setOnClickListener(new View.OnClickListener(this, notification){
                final /* synthetic */ NotificationCallViewHolder this$0;
                final /* synthetic */ Notification $data;
                {
                    this.this$0 = notificationCallViewHolder;
                    this.$data = notification;
                }

                public final void onClick(View object) {
                    object = this.this$0.NotificationsAdapter.this.getListener();
                    if (object != null) {
                        object.onNotificationClick(this.$data);
                    }
                }
            });
        }
    }
}

