/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.notifications;

import io.reactivex.Completable;
import io.streamlayer.common.data.database.AppDatabase;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.repository.notifications.NotificationRepo;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001d\u0010\u0006\u001a\u00020\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001b\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0007J\u0017\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0017R\u0016\u0010\u001c\u001a\u00020\u001b8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"Lio/streamlayer/sdk/repository/notifications/NotificationRepoImpl;", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "items", "", "saveNotifications", "(Ljava/util/List;)V", "Lkotlinx/coroutines/flow/Flow;", "getNotifications", "()Lkotlinx/coroutines/flow/Flow;", "", "notificationId", "Lio/reactivex/Completable;", "deleteNotification", "(J)Lio/reactivex/Completable;", "notification", "(Lio/streamlayer/sdk/model/notifications/Notification;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteAllNotifications", "()V", "deleteNotifications", "item", "saveNotification", "(Lio/streamlayer/sdk/model/notifications/Notification;)V", "saveNotificationGetId", "(Lio/streamlayer/sdk/model/notifications/Notification;)J", "upsertNotificationBySourceId", "Lio/streamlayer/common/data/database/AppDatabase;", "database", "Lio/streamlayer/common/data/database/AppDatabase;", "<init>", "(Lio/streamlayer/common/data/database/AppDatabase;)V", "sdk_originalRelease"})
public final class NotificationRepoImpl
implements NotificationRepo {
    private final AppDatabase database;

    private final void saveNotifications(List<Notification> list) {
        this.database.notificationDao().saveNotifications(list);
    }

    @Inject
    public NotificationRepoImpl(@NotNull AppDatabase appDatabase) {
        Intrinsics.checkNotNullParameter((Object)((Object)appDatabase), (String)"database");
        this.database = appDatabase;
    }

    @Override
    @NotNull
    public Flow<List<Notification>> getNotifications() {
        return this.database.notificationDao().getNotifications();
    }

    @Override
    @NotNull
    public Completable deleteNotification(long l) {
        return this.database.notificationDao().deleteNotification(l);
    }

    @Override
    @Nullable
    public Object deleteNotification(@NotNull Notification notification, @NotNull Continuation<? super Unit> continuation) {
        Object object = ((NotificationRepoImpl)object).database.notificationDao().deleteNotification(notification, continuation);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void deleteAllNotifications() {
        this.database.notificationDao().deleteAllNotifications();
    }

    @Override
    public void deleteNotifications(@NotNull List<Notification> list) {
        Intrinsics.checkNotNullParameter(list, (String)"items");
        this.database.notificationDao().deleteNotifications(list);
    }

    @Override
    public void saveNotification(@NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"item");
        this.database.notificationDao().saveNotifications(CollectionsKt.listOf((Object)notification));
    }

    @Override
    public long saveNotificationGetId(@NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"item");
        return this.database.notificationDao().saveNotification(notification);
    }

    @Override
    public void upsertNotificationBySourceId(@NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"item");
        Notification notification2 = this.database.notificationDao().getNotification(notification.getSourceUniqueId());
        if (notification2 != null) {
            notification.setId(notification2.getId());
            this.database.notificationDao().updateNotifications(CollectionsKt.listOf((Object)notification));
        } else {
            this.database.notificationDao().saveNotification(notification);
        }
    }
}

