/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.watchparty;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.calls.WatchPartyParticipantStatus;
import io.streamlayer.sdk.model.calls.WatchPartyRelation;
import io.streamlayer.sdk.model.calls.WatchPartyStatus;
import io.streamlayer.sdk.model.calls.WatchPartyType;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatRelation;
import io.streamlayer.sdk.model.messaging.Topic;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.watchparty.WatchPartyDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;

public final class WatchPartyDao_Impl
implements WatchPartyDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<WatchPartyStatus> __insertionAdapterOfWatchPartyStatus;
    private final Converters __converters;
    private final SharedSQLiteStatement __preparedStmtOfUpdateWatchPartyStatusParticipated;
    private final SharedSQLiteStatement __preparedStmtOfDeleteWatchPartyStatus;
    private final SharedSQLiteStatement __preparedStmtOfDeleteTopic;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChatParticipantCrossRef;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChatOwnerCrossRef;
    private final SharedSQLiteStatement __preparedStmtOfSetWatchPartyPrivate;
    private final SharedSQLiteStatement __preparedStmtOfHidePublicWatchParties;

    public WatchPartyDao_Impl(RoomDatabase roomDatabase) {
        SharedSQLiteStatement sharedSQLiteStatement;
        SharedSQLiteStatement sharedSQLiteStatement2;
        SharedSQLiteStatement sharedSQLiteStatement3;
        SharedSQLiteStatement sharedSQLiteStatement4;
        SharedSQLiteStatement sharedSQLiteStatement5;
        SharedSQLiteStatement sharedSQLiteStatement6;
        SharedSQLiteStatement sharedSQLiteStatement7;
        EntityInsertionAdapter<WatchPartyStatus> entityInsertionAdapter;
        Converters converters;
        Converters converters2 = converters;
        converters = new Converters();
        this.__converters = converters2;
        this.__db = roomDatabase;
        converters2 = entityInsertionAdapter;
        entityInsertionAdapter = new EntityInsertionAdapter<WatchPartyStatus>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `WatchPartyStatus` (`chatId`,`participantStatuses`,`isPrivate`,`isParticipated`,`type`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WatchPartyStatus watchPartyStatus) {
                if (watchPartyStatus.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, watchPartyStatus.getChatId());
                }
                String string2 = WatchPartyDao_Impl.this.__converters.participantStatusesToString(watchPartyStatus.getParticipantStatuses());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, string2);
                }
                long l = (long)watchPartyStatus.isPrivate();
                supportSQLiteStatement.bindLong(3, l);
                l = (long)watchPartyStatus.isParticipated();
                supportSQLiteStatement.bindLong(4, l);
                if (watchPartyStatus.getType() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, WatchPartyDao_Impl.this.__WatchPartyType_enumToString(watchPartyStatus.getType()));
                }
            }
        };
        this.__insertionAdapterOfWatchPartyStatus = converters2;
        converters2 = sharedSQLiteStatement7;
        sharedSQLiteStatement7 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE WatchPartyStatus SET isParticipated=1 WHERE WatchPartyStatus.chatId = ?";
            }
        };
        this.__preparedStmtOfUpdateWatchPartyStatusParticipated = converters2;
        converters2 = sharedSQLiteStatement6;
        sharedSQLiteStatement6 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM WatchPartyStatus WHERE chatId=?";
            }
        };
        this.__preparedStmtOfDeleteWatchPartyStatus = converters2;
        converters2 = sharedSQLiteStatement5;
        sharedSQLiteStatement5 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Topic WHERE chatId=?";
            }
        };
        this.__preparedStmtOfDeleteTopic = converters2;
        converters2 = sharedSQLiteStatement4;
        sharedSQLiteStatement4 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatParticipantCrossRef WHERE chatId=?";
            }
        };
        this.__preparedStmtOfDeleteChatParticipantCrossRef = converters2;
        converters2 = sharedSQLiteStatement3;
        sharedSQLiteStatement3 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatOwnerCrossRef WHERE chatId=?";
            }
        };
        this.__preparedStmtOfDeleteChatOwnerCrossRef = converters2;
        converters2 = sharedSQLiteStatement2;
        sharedSQLiteStatement2 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE WatchPartyStatus SET isPrivate=? WHERE chatId = ?";
            }
        };
        this.__preparedStmtOfSetWatchPartyPrivate = converters2;
        converters2 = sharedSQLiteStatement;
        sharedSQLiteStatement = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE WatchPartyStatus SET isPrivate=1 WHERE type =? AND isParticipated=0";
            }
        };
        this.__preparedStmtOfHidePublicWatchParties = converters2;
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private String __WatchPartyType_enumToString(WatchPartyType watchPartyType) {
        if (watchPartyType == null) {
            return null;
        }
        int n = 23.$SwitchMap$io$streamlayer$sdk$model$calls$WatchPartyType[watchPartyType.ordinal()];
        if (n != 1) {
            if (n == 2) {
                return "REGULAR";
            }
            throw new IllegalArgumentException("Can't convert enum to string, unknown enum value: " + (Object)((Object)watchPartyType));
        }
        return "PUBLIC";
    }

    private WatchPartyType __WatchPartyType_stringToEnum(String string2) {
        if (string2 == null) {
            return null;
        }
        if (!string2.equals("PUBLIC")) {
            if (!string2.equals("REGULAR")) {
                throw new IllegalArgumentException("Can't convert value to enum, unknown value: " + string2);
            }
            return WatchPartyType.REGULAR;
        }
        return WatchPartyType.PUBLIC;
    }

    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact(ArrayMap<String, TinodeContact> arrayMap) {
        int n;
        Set set = arrayMap.keySet();
        if (set.isEmpty()) {
            return;
        }
        if (arrayMap.size() > 999) {
            ArrayMap arrayMap2;
            set = arrayMap2;
            arrayMap2 = new ArrayMap(999);
            int n2 = 0;
            int n3 = arrayMap.size();
            for (int i = 0; i < n3; ++i) {
                ArrayMap arrayMap3;
                set.put(arrayMap.keyAt(i), null);
                if (++n2 != 999) continue;
                watchPartyDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)set);
                arrayMap.putAll((Map)((Object)set));
                set = arrayMap3;
                arrayMap3 = new ArrayMap(999);
                n2 = 0;
            }
            if (n2 > 0) {
                watchPartyDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)set);
                arrayMap.putAll((Map)((Object)set));
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`externalId` AS `externalId`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`photoData` AS `photoData`,`TinodeContact`.`privateData` AS `privateData`,_junction.`chatId` FROM `ChatOwnerCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        int n4 = set.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n4);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n4 + 0));
        int n5 = 1;
        for (String string2 : set) {
            if (string2 == null) {
                roomSQLiteQuery.bindNull(n5);
            } else {
                roomSQLiteQuery.bindString(n5, string2);
            }
            ++n5;
        }
        WatchPartyDao_Impl watchPartyDao_Impl = DBUtil.query((RoomDatabase)watchPartyDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"chatUserId");
        n5 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"externalId");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"chatName");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"online");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"photoData");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"privateData");
        }
        catch (Throwable throwable) {
            watchPartyDao_Impl.close();
            throw throwable;
        }
        while (true) {
            String string3;
            String string4;
            boolean bl;
            String string5;
            String string6;
            String string7;
            String string8;
            block39: {
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    block33: {
                                        block32: {
                                            block31: {
                                                block30: {
                                                    if (!watchPartyDao_Impl.moveToNext()) break;
                                                    ArrayMap<String, TinodeContact> arrayMap4 = arrayMap;
                                                    string8 = watchPartyDao_Impl.getString(6);
                                                    if (!arrayMap4.containsKey((Object)string8)) continue;
                                                    if (!watchPartyDao_Impl.isNull(n6)) break block30;
                                                    string7 = null;
                                                    break block31;
                                                }
                                                string7 = watchPartyDao_Impl.getString(n6);
                                            }
                                            if (!watchPartyDao_Impl.isNull(n5)) break block32;
                                            string6 = null;
                                            break block33;
                                        }
                                        string6 = watchPartyDao_Impl.getString(n5);
                                    }
                                    if (!watchPartyDao_Impl.isNull(n7)) break block34;
                                    string5 = null;
                                    break block35;
                                }
                                string5 = watchPartyDao_Impl.getString(n7);
                            }
                            bl = watchPartyDao_Impl.getInt(n8) != 0;
                            if (!watchPartyDao_Impl.isNull(n9)) break block36;
                            string4 = null;
                            break block37;
                        }
                        string4 = watchPartyDao_Impl.getString(n9);
                    }
                    if (!watchPartyDao_Impl.isNull(n)) break block38;
                    string3 = null;
                    break block39;
                }
                string3 = watchPartyDao_Impl.getString(n);
            }
            arrayMap.put((Object)string8, (Object)new TinodeContact(string7, string6, string5, bl, string4, string3));
        }
        watchPartyDao_Impl.close();
        return;
    }

    private void __fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus(ArrayMap<String, WatchPartyStatus> arrayMap) {
        int n;
        int n2;
        RoomSQLiteQuery roomSQLiteQuery;
        block27: {
            Set set = arrayMap.keySet();
            if (set.isEmpty()) {
                return;
            }
            if (arrayMap.size() > 999) {
                ArrayMap arrayMap2;
                set = arrayMap2;
                arrayMap2 = new ArrayMap(999);
                int n3 = 0;
                int n4 = arrayMap.size();
                for (int i = 0; i < n4; ++i) {
                    ArrayMap arrayMap3;
                    set.put(arrayMap.keyAt(i), null);
                    if (++n3 != 999) continue;
                    this.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)set);
                    arrayMap.putAll((Map)((Object)set));
                    set = arrayMap3;
                    arrayMap3 = new ArrayMap(999);
                    n3 = 0;
                }
                if (n3 > 0) {
                    this.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)set);
                    arrayMap.putAll((Map)((Object)set));
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `chatId`,`participantStatuses`,`isPrivate`,`isParticipated`,`type` FROM `WatchPartyStatus` WHERE `chatId` IN (");
            int n5 = set.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n5);
            stringBuilder.append(")");
            roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n5 + 0));
            n2 = 1;
            for (String string2 : set) {
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, string2);
                }
                ++n2;
            }
            roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n2 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatId");
            if (n2 != -1) break block27;
            roomSQLiteQuery.close();
            return;
        }
        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
        RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery4 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery5 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery6 = roomSQLiteQuery2;
        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery2, (String)"chatId");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery4, (String)"participantStatuses");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery5, (String)"isPrivate");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery6, (String)"isParticipated");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery3, (String)"type");
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        while (true) {
            Object object;
            String string3;
            Object object2;
            block31: {
                block30: {
                    block29: {
                        block28: {
                            if (!roomSQLiteQuery.moveToNext()) break;
                            ArrayMap<String, WatchPartyStatus> arrayMap4 = arrayMap;
                            object2 = roomSQLiteQuery.getString(n2);
                            if (!arrayMap4.containsKey(object2)) continue;
                            if (!roomSQLiteQuery.isNull(n6)) break block28;
                            string3 = null;
                            break block29;
                        }
                        string3 = roomSQLiteQuery.getString(n6);
                    }
                    if (!roomSQLiteQuery.isNull(n7)) break block30;
                    object = null;
                    break block31;
                }
                object = roomSQLiteQuery.getString(n7);
            }
            RoomSQLiteQuery roomSQLiteQuery7 = roomSQLiteQuery;
            int n10 = n8;
            object = this.__converters.stringToParticipantStatuses((String)object);
            boolean bl = roomSQLiteQuery7.getInt(n10) != 0;
            boolean bl2 = roomSQLiteQuery.getInt(n9) != 0;
            ArrayMap<String, WatchPartyStatus> arrayMap5 = arrayMap;
            String string4 = object2;
            object2 = this.__WatchPartyType_stringToEnum(roomSQLiteQuery.getString(n));
            arrayMap5.put((Object)string4, (Object)new WatchPartyStatus(string3, (List<WatchPartyParticipantStatus>)object, bl, bl2, (WatchPartyType)((Object)object2)));
        }
        roomSQLiteQuery.close();
        return;
    }

    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1(ArrayMap<String, ArrayList<TinodeContact>> arrayMap) {
        int n;
        Set set = arrayMap.keySet();
        if (set.isEmpty()) {
            return;
        }
        if (arrayMap.size() > 999) {
            ArrayMap arrayMap2;
            set = arrayMap2;
            arrayMap2 = new ArrayMap(999);
            int n2 = 0;
            int n3 = arrayMap.size();
            for (int i = 0; i < n3; ++i) {
                ArrayMap arrayMap3;
                ArrayMap<String, ArrayList<TinodeContact>> arrayMap4 = arrayMap;
                Object object = arrayMap4.keyAt(i);
                set.put(object, arrayMap4.valueAt(i));
                if (++n2 != 999) continue;
                watchPartyDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)set);
                set = arrayMap3;
                arrayMap3 = new ArrayMap(999);
                n2 = 0;
            }
            if (n2 > 0) {
                watchPartyDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)set);
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`externalId` AS `externalId`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`photoData` AS `photoData`,`TinodeContact`.`privateData` AS `privateData`,_junction.`chatId` FROM `ChatParticipantCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        int n4 = set.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n4);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n4 + 0));
        int n5 = 1;
        for (String string2 : set) {
            if (string2 == null) {
                roomSQLiteQuery.bindNull(n5);
            } else {
                roomSQLiteQuery.bindString(n5, string2);
            }
            ++n5;
        }
        WatchPartyDao_Impl watchPartyDao_Impl = DBUtil.query((RoomDatabase)watchPartyDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"chatUserId");
        n5 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"externalId");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"chatName");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"online");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"photoData");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"privateData");
        }
        catch (Throwable throwable) {
            watchPartyDao_Impl.close();
            throw throwable;
        }
        while (true) {
            String string3;
            String string4;
            boolean bl;
            String string5;
            String string6;
            String string7;
            ArrayList arrayList;
            block38: {
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    block32: {
                                        block31: {
                                            block30: {
                                                block29: {
                                                    if (!watchPartyDao_Impl.moveToNext()) break;
                                                    arrayList = (ArrayList)arrayMap.get((Object)watchPartyDao_Impl.getString(6));
                                                    if (arrayList == null) continue;
                                                    if (!watchPartyDao_Impl.isNull(n6)) break block29;
                                                    string7 = null;
                                                    break block30;
                                                }
                                                string7 = watchPartyDao_Impl.getString(n6);
                                            }
                                            if (!watchPartyDao_Impl.isNull(n5)) break block31;
                                            string6 = null;
                                            break block32;
                                        }
                                        string6 = watchPartyDao_Impl.getString(n5);
                                    }
                                    if (!watchPartyDao_Impl.isNull(n7)) break block33;
                                    string5 = null;
                                    break block34;
                                }
                                string5 = watchPartyDao_Impl.getString(n7);
                            }
                            bl = watchPartyDao_Impl.getInt(n8) != 0;
                            if (!watchPartyDao_Impl.isNull(n9)) break block35;
                            string4 = null;
                            break block36;
                        }
                        string4 = watchPartyDao_Impl.getString(n9);
                    }
                    if (!watchPartyDao_Impl.isNull(n)) break block37;
                    string3 = null;
                    break block38;
                }
                string3 = watchPartyDao_Impl.getString(n);
            }
            arrayList.add(new TinodeContact(string7, string6, string5, bl, string4, string3));
        }
        watchPartyDao_Impl.close();
        return;
    }

    private void __fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage(ArrayMap<String, ArrayList<ChatMessage>> arrayMap) {
        int n;
        int n2;
        RoomSQLiteQuery roomSQLiteQuery;
        block45: {
            Set set = arrayMap.keySet();
            if (set.isEmpty()) {
                return;
            }
            if (arrayMap.size() > 999) {
                ArrayMap arrayMap2;
                set = arrayMap2;
                arrayMap2 = new ArrayMap(999);
                int n3 = 0;
                int n4 = arrayMap.size();
                for (int i = 0; i < n4; ++i) {
                    ArrayMap arrayMap3;
                    ArrayMap<String, ArrayList<ChatMessage>> arrayMap4 = arrayMap;
                    Object object = arrayMap4.keyAt(i);
                    set.put(object, arrayMap4.valueAt(i));
                    if (++n3 != 999) continue;
                    this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set);
                    set = arrayMap3;
                    arrayMap3 = new ArrayMap(999);
                    n3 = 0;
                }
                if (n3 > 0) {
                    this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set);
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `uuid`,`chatMessageTopicId`,`senderUserId`,`remoteSeqId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status` FROM `ChatMessage` WHERE `chatMessageTopicId` IN (");
            int n5 = set.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n5);
            stringBuilder.append(")");
            roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n5 + 0));
            n2 = 1;
            for (String string2 : set) {
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, string2);
                }
                ++n2;
            }
            roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n2 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatMessageTopicId");
            if (n2 != -1) break block45;
            roomSQLiteQuery.close();
            return;
        }
        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
        RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery4 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery5 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery6 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery7 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery8 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery9 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery10 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery11 = roomSQLiteQuery2;
        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery2, (String)"uuid");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery9, (String)"chatMessageTopicId");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery10, (String)"senderUserId");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery11, (String)"remoteSeqId");
        int n10 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery7, (String)"date");
        int n11 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery8, (String)"text");
        int n12 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery5, (String)"type");
        int n13 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery6, (String)"subtype");
        int n14 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery3, (String)"replyTo");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery4, (String)"status");
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        while (true) {
            ChatMessage chatMessage;
            String string3;
            ArrayList arrayList;
            block63: {
                block62: {
                    ChatMessage chatMessage2;
                    Object object;
                    String string4;
                    String string5;
                    String string6;
                    String string7;
                    Comparable<Long> comparable;
                    int n15;
                    String string8;
                    block61: {
                        block60: {
                            block59: {
                                block58: {
                                    block57: {
                                        block56: {
                                            block55: {
                                                block54: {
                                                    block53: {
                                                        block52: {
                                                            block51: {
                                                                block50: {
                                                                    block49: {
                                                                        block48: {
                                                                            block47: {
                                                                                block46: {
                                                                                    if (!roomSQLiteQuery.moveToNext()) break;
                                                                                    arrayList = (ArrayList)arrayMap.get((Object)roomSQLiteQuery.getString(n2));
                                                                                    if (arrayList == null) continue;
                                                                                    if (!roomSQLiteQuery.isNull(n7)) break block46;
                                                                                    string3 = null;
                                                                                    break block47;
                                                                                }
                                                                                string3 = roomSQLiteQuery.getString(n7);
                                                                            }
                                                                            if (!roomSQLiteQuery.isNull(n8)) break block48;
                                                                            string8 = null;
                                                                            break block49;
                                                                        }
                                                                        string8 = roomSQLiteQuery.getString(n8);
                                                                    }
                                                                    RoomSQLiteQuery roomSQLiteQuery12 = roomSQLiteQuery;
                                                                    int n16 = n10;
                                                                    n15 = roomSQLiteQuery.getInt(n9);
                                                                    if (!roomSQLiteQuery12.isNull(n16)) break block50;
                                                                    comparable = null;
                                                                    break block51;
                                                                }
                                                                comparable = roomSQLiteQuery.getLong(n10);
                                                            }
                                                            RoomSQLiteQuery roomSQLiteQuery13 = roomSQLiteQuery;
                                                            int n17 = n11;
                                                            comparable = this.__converters.timestampToDate((Long)comparable);
                                                            if (!roomSQLiteQuery13.isNull(n17)) break block52;
                                                            string7 = null;
                                                            break block53;
                                                        }
                                                        string7 = roomSQLiteQuery.getString(n11);
                                                    }
                                                    if (!roomSQLiteQuery.isNull(n12)) break block54;
                                                    string6 = null;
                                                    break block55;
                                                }
                                                string6 = roomSQLiteQuery.getString(n12);
                                            }
                                            if (!roomSQLiteQuery.isNull(n13)) break block56;
                                            string5 = null;
                                            break block57;
                                        }
                                        string5 = roomSQLiteQuery.getString(n13);
                                    }
                                    if (!roomSQLiteQuery.isNull(n14)) break block58;
                                    string4 = null;
                                    break block59;
                                }
                                string4 = roomSQLiteQuery.getString(n14);
                            }
                            if (!roomSQLiteQuery.isNull(n)) break block60;
                            object = null;
                            break block61;
                        }
                        object = roomSQLiteQuery.getString(n);
                    }
                    RoomSQLiteQuery roomSQLiteQuery14 = roomSQLiteQuery;
                    int n18 = n6;
                    object = this.__converters.stringToChatStatus((String)object);
                    chatMessage = chatMessage2;
                    chatMessage2 = new ChatMessage(string3, string8, n15, (Date)comparable, string7, string6, string5, string4, (ChatMessageStatus)((Object)object));
                    if (!roomSQLiteQuery14.isNull(n18)) break block62;
                    string3 = null;
                    break block63;
                }
                string3 = roomSQLiteQuery.getString(n6);
            }
            ChatMessage chatMessage3 = chatMessage;
            chatMessage3.setId(string3);
            arrayList.add(chatMessage3);
        }
        roomSQLiteQuery.close();
        return;
    }

    static /* synthetic */ void access$1200(WatchPartyDao_Impl watchPartyDao_Impl, ArrayMap arrayMap) {
        watchPartyDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)arrayMap);
    }

    static /* synthetic */ void access$1300(WatchPartyDao_Impl watchPartyDao_Impl, ArrayMap arrayMap) {
        watchPartyDao_Impl.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)arrayMap);
    }

    static /* synthetic */ void access$1400(WatchPartyDao_Impl watchPartyDao_Impl, ArrayMap arrayMap) {
        watchPartyDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)arrayMap);
    }

    static /* synthetic */ void access$1500(WatchPartyDao_Impl watchPartyDao_Impl, ArrayMap arrayMap) {
        watchPartyDao_Impl.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)arrayMap);
    }

    @Override
    public Object saveWatchPartyStatus(final WatchPartyStatus watchPartyStatus, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                Unit unit;
                9 v0 = this;
                v0.WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    v0.WatchPartyDao_Impl.this.__insertionAdapterOfWatchPartyStatus.insert((Object)watchPartyStatus);
                    v0.WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                    unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    WatchPartyDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.endTransaction();
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteWatchParty(final String string2, Continuation<? super Unit> continuation) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> continuation) {
                return WatchPartyDao.DefaultImpls.deleteWatchParty(WatchPartyDao_Impl.this, string2, continuation);
            }
        }, continuation);
    }

    @Override
    public Object updateWatchPartyStatusParticipated(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                11 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfUpdateWatchPartyStatusParticipated.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    11 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfUpdateWatchPartyStatusParticipated.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                11 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfUpdateWatchPartyStatusParticipated.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteWatchPartyStatus(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                12 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteWatchPartyStatus.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    12 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteWatchPartyStatus.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                12 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteWatchPartyStatus.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteTopic(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                13 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteTopic.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    13 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteTopic.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                13 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteTopic.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteChatParticipantCrossRef(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                14 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantCrossRef.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    14 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantCrossRef.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                14 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantCrossRef.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteChatOwnerCrossRef(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                15 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatOwnerCrossRef.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    15 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatOwnerCrossRef.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                15 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatOwnerCrossRef.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object setWatchPartyPrivate(final String string2, final boolean bl, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                16 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfSetWatchPartyPrivate.acquire();
                supportSQLiteStatement.bindLong(1, (long)bl);
                int n = 2;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    16 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfSetWatchPartyPrivate.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                16 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfSetWatchPartyPrivate.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object hidePublicWatchParties(final WatchPartyType watchPartyType, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                17 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfHidePublicWatchParties.acquire();
                int n = 1;
                WatchPartyType watchPartyType2 = v0.watchPartyType;
                if (watchPartyType2 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, WatchPartyDao_Impl.this.__WatchPartyType_enumToString(watchPartyType2));
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    17 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfHidePublicWatchParties.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                17 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfHidePublicWatchParties.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Flow<WatchPartyStatus> observeWatchPartyStatus(String stringArray) {
        Callable<WatchPartyStatus> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM WatchPartyStatus WHERE WatchPartyStatus.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[1];
        stringArray = stringArray2;
        stringArray2[0] = "WatchPartyStatus";
        Callable<WatchPartyStatus> callable2 = callable;
        callable = new Callable<WatchPartyStatus>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public WatchPartyStatus call() throws Exception {
                WatchPartyStatus watchPartyStatus;
                Cursor cursor;
                block26: {
                    block19: {
                        void var5_13;
                        void var4_9;
                        WatchPartyStatus watchPartyStatus2;
                        Object object;
                        String string2;
                        int n;
                        Object object2;
                        block25: {
                            int n2;
                            block24: {
                                int bl2;
                                block23: {
                                    int n22;
                                    block22: {
                                        block21: {
                                            int n3;
                                            block20: {
                                                cursor = DBUtil.query((RoomDatabase)object2.WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)object2.roomSQLiteQuery, (boolean)false, null);
                                                try {
                                                    n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatId");
                                                }
                                                catch (Throwable throwable) {
                                                    cursor.close();
                                                    throw throwable;
                                                }
                                                n22 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"participantStatuses");
                                                bl2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isPrivate");
                                                n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isParticipated");
                                                n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"type");
                                                if (!cursor.moveToFirst()) break block19;
                                                if (!cursor.isNull(n3)) break block20;
                                                string2 = null;
                                                break block21;
                                            }
                                            string2 = cursor.getString(n3);
                                        }
                                        if (!cursor.isNull(n22)) break block22;
                                        object = null;
                                        break block23;
                                    }
                                    object = cursor.getString(n22);
                                }
                                Cursor cursor2 = cursor;
                                int n3 = bl2;
                                object = object2.WatchPartyDao_Impl.this.__converters.stringToParticipantStatuses((String)object);
                                if (cursor2.getInt(n3) != 0) {
                                    boolean bl = true;
                                    break block24;
                                }
                                boolean bl = false;
                            }
                            if (cursor.getInt(n2) != 0) {
                                boolean bl = true;
                                break block25;
                            }
                            boolean bl = false;
                        }
                        object2 = object2.WatchPartyDao_Impl.this.__WatchPartyType_stringToEnum(cursor.getString(n));
                        watchPartyStatus = watchPartyStatus2;
                        watchPartyStatus2 = new WatchPartyStatus(string2, (List<WatchPartyParticipantStatus>)object, (boolean)var4_9, (boolean)var5_13, (WatchPartyType)((Object)object2));
                        break block26;
                    }
                    watchPartyStatus = null;
                }
                cursor.close();
                return watchPartyStatus;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Object getWatchPartyStatus(String string2, Continuation<? super WatchPartyStatus> continuation) {
        Callable<WatchPartyStatus> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM WatchPartyStatus WHERE WatchPartyStatus.chatId = ?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<WatchPartyStatus> callable2 = callable;
        callable = new Callable<WatchPartyStatus>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public WatchPartyStatus call() throws Exception {
                WatchPartyStatus watchPartyStatus;
                Cursor cursor;
                block26: {
                    block19: {
                        void var5_13;
                        void var4_9;
                        WatchPartyStatus watchPartyStatus2;
                        Object object;
                        String string2;
                        int n;
                        block25: {
                            int n2;
                            block24: {
                                int bl2;
                                block23: {
                                    int n22;
                                    block22: {
                                        block21: {
                                            int n3;
                                            block20: {
                                                cursor = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                                try {
                                                    n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatId");
                                                }
                                                catch (Throwable throwable) {
                                                    cursor.close();
                                                    roomSQLiteQuery.release();
                                                    throw throwable;
                                                }
                                                n22 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"participantStatuses");
                                                bl2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isPrivate");
                                                n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isParticipated");
                                                n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"type");
                                                if (!cursor.moveToFirst()) break block19;
                                                if (!cursor.isNull(n3)) break block20;
                                                string2 = null;
                                                break block21;
                                            }
                                            string2 = cursor.getString(n3);
                                        }
                                        if (!cursor.isNull(n22)) break block22;
                                        object = null;
                                        break block23;
                                    }
                                    object = cursor.getString(n22);
                                }
                                Cursor cursor2 = cursor;
                                int n3 = bl2;
                                object = WatchPartyDao_Impl.this.__converters.stringToParticipantStatuses((String)object);
                                if (cursor2.getInt(n3) != 0) {
                                    boolean bl = true;
                                    break block24;
                                }
                                boolean bl = false;
                            }
                            if (cursor.getInt(n2) != 0) {
                                boolean bl = true;
                                break block25;
                            }
                            boolean bl = false;
                        }
                        WatchPartyType watchPartyType = WatchPartyDao_Impl.this.__WatchPartyType_stringToEnum(cursor.getString(n));
                        watchPartyStatus = watchPartyStatus2;
                        watchPartyStatus2 = new WatchPartyStatus(string2, (List<WatchPartyParticipantStatus>)object, (boolean)var4_9, (boolean)var5_13, watchPartyType);
                        break block26;
                    }
                    watchPartyStatus = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return watchPartyStatus;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object getWatchPartyRelation(String string2, Continuation<? super WatchPartyRelation> continuation) {
        Callable<WatchPartyRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE Topic.chatId = ?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<WatchPartyRelation> callable2 = callable;
        callable = new Callable<WatchPartyRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public WatchPartyRelation call() throws Exception {
                block103: {
                    block84: {
                        block102: {
                            block101: {
                                block100: {
                                    block99: {
                                        block98: {
                                            block97: {
                                                block96: {
                                                    block95: {
                                                        block94: {
                                                            block93: {
                                                                block92: {
                                                                    block91: {
                                                                        block90: {
                                                                            block89: {
                                                                                block88: {
                                                                                    block87: {
                                                                                        block86: {
                                                                                            block85: {
                                                                                                var1_1 = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.access$200(WatchPartyDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                                                                                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                                                                                                var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                                                                                var4_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                                                                                var5_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                                                                                var6_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                                                                                var7_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                                                                                var8_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                                                                                var9_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                                                                                                var10_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"isWPTopic");
                                                                                                var11_19 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                                                                                                var12_21 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                                                                                                var13_23 = v0;
                                                                                                v0 = new ArrayMap();
                                                                                                var14_24 = v1;
                                                                                                v1 = new ArrayMap();
                                                                                                var15_25 = v2;
                                                                                                v2 = new ArrayMap();
                                                                                                var16_26 = v3;
                                                                                                try {
                                                                                                    v3 = new ArrayMap();
                                                                                                    ** while (var1_1.moveToNext())
                                                                                                }
                                                                                                catch (Throwable v4) {
                                                                                                    var1_1.close();
                                                                                                    roomSQLiteQuery.release();
                                                                                                    throw v4;
                                                                                                }
lbl-1000:
                                                                                                // 1 sources

                                                                                                {
                                                                                                    block83: {
                                                                                                        v5 = var15_25;
                                                                                                        v6 = var1_1;
                                                                                                        v7 = var3_4;
                                                                                                        v8 = var14_24;
                                                                                                        v9 = var1_1;
                                                                                                        v10 = var3_4;
                                                                                                        var13_23.put((Object)var1_1.getString(var3_4), null);
                                                                                                        v8.put((Object)v9.getString(v10), null);
                                                                                                        var17_27 = v6.getString(v7);
                                                                                                        if ((ArrayList)v5.get((Object)var17_27) != null) break block83;
                                                                                                        var15_25.put((Object)var17_27, new ArrayList<E>());
                                                                                                    }
                                                                                                    v11 = var16_26;
                                                                                                    var17_27 = var1_1.getString(var3_4);
                                                                                                    if ((ArrayList)v11.get((Object)var17_27) != null) continue;
                                                                                                    var16_26.put((Object)var17_27, new ArrayList<E>());
                                                                                                    continue;
                                                                                                }
lbl71:
                                                                                                // 2 sources

                                                                                                v12 = var1_1;
                                                                                                v13 = this;
                                                                                                v14 = v13;
                                                                                                v15 = v13;
                                                                                                v16 = v13;
                                                                                                v17 = v13;
                                                                                                var1_1.moveToPosition(-1);
                                                                                                WatchPartyDao_Impl.access$1200(v14.WatchPartyDao_Impl.this, var13_23);
                                                                                                WatchPartyDao_Impl.access$1300(v15.WatchPartyDao_Impl.this, var14_24);
                                                                                                WatchPartyDao_Impl.access$1400(v16.WatchPartyDao_Impl.this, var15_25);
                                                                                                WatchPartyDao_Impl.access$1500(v17.WatchPartyDao_Impl.this, var16_26);
                                                                                                if (!v12.moveToFirst()) break block84;
                                                                                                if (!var1_1.isNull(var2_2)) break block85;
                                                                                                if (!var1_1.isNull(var3_4)) break block85;
                                                                                                if (!var1_1.isNull(var4_6)) break block85;
                                                                                                if (!var1_1.isNull(var5_10)) break block85;
                                                                                                if (!var1_1.isNull(var6_12)) break block85;
                                                                                                if (!var1_1.isNull(var7_13)) break block85;
                                                                                                if (!var1_1.isNull(var8_14)) break block85;
                                                                                                if (!var1_1.isNull(var9_16)) break block85;
                                                                                                if (!var1_1.isNull((int)var10_18)) break block85;
                                                                                                if (!var1_1.isNull(var11_19)) break block85;
                                                                                                if (!var1_1.isNull(var12_21)) break block85;
                                                                                                var5_11 = var2_3 = null;
                                                                                                ** GOTO lbl242
                                                                                            }
                                                                                            if (!var1_1.isNull(var2_2)) break block86;
                                                                                            if (!var1_1.isNull(var3_4)) break block86;
                                                                                            if (!var1_1.isNull(var4_6)) break block86;
                                                                                            if (!var1_1.isNull(var5_10)) break block86;
                                                                                            if (!var1_1.isNull(var6_12)) break block86;
                                                                                            if (!var1_1.isNull(var7_13)) break block86;
                                                                                            if (!var1_1.isNull(var8_14)) break block86;
                                                                                            if (!var1_1.isNull(var9_16)) break block86;
                                                                                            if (!var1_1.isNull((int)var10_18)) break block86;
                                                                                            if (!var1_1.isNull(var11_19)) break block86;
                                                                                            if (!var1_1.isNull(var12_21)) break block86;
                                                                                            var11_20 = var2_3 = null;
                                                                                            ** GOTO lbl229
                                                                                        }
                                                                                        if (!var1_1.isNull(var3_4)) break block87;
                                                                                        var17_27 = null;
                                                                                        break block88;
                                                                                    }
                                                                                    var17_27 = var1_1.getString(var3_4);
                                                                                }
                                                                                if (!var1_1.isNull(var4_6)) break block89;
                                                                                var4_7 = null;
                                                                                break block90;
                                                                            }
                                                                            var4_7 = var1_1.getString(var4_6);
                                                                        }
                                                                        v18 = var1_1;
                                                                        v19 = var8_14;
                                                                        v20 = var1_1;
                                                                        v21 = var7_13;
                                                                        v22 = var1_1;
                                                                        v23 = var6_12;
                                                                        var5_10 = var1_1.getInt(var5_10);
                                                                        var6_12 = v22.getInt(v23);
                                                                        var7_13 = v20.getInt(v21);
                                                                        if (!v18.isNull(v19)) break block91;
                                                                        var8_15 /* !! */  = null;
                                                                        break block92;
                                                                    }
                                                                    var8_15 /* !! */  = var1_1.getLong(var8_14);
                                                                }
                                                                v24 = var1_1;
                                                                v25 = var9_16;
                                                                var8_15 /* !! */  = WatchPartyDao_Impl.access$000(WatchPartyDao_Impl.this).timestampToDate(var8_15 /* !! */ );
                                                                if (!v24.isNull(v25)) break block93;
                                                                var9_17 /* !! */  = null;
                                                                break block94;
                                                            }
                                                            var9_17 /* !! */  = var1_1.getLong(var9_16);
                                                        }
                                                        v26 = var1_1;
                                                        v27 = var10_18;
                                                        var9_17 /* !! */  = WatchPartyDao_Impl.access$000(WatchPartyDao_Impl.this).timestampToDate(var9_17 /* !! */ );
                                                        var10_18 = v26.getInt((int)v27) != 0;
                                                        if (!var1_1.isNull(var11_19)) break block95;
                                                        if (!var1_1.isNull(var12_21)) break block95;
                                                        var18_28 = var11_20 = null;
                                                        ** GOTO lbl215
                                                    }
                                                    if (!var1_1.isNull(var11_19)) break block96;
                                                    var11_20 = null;
                                                    break block97;
                                                }
                                                var11_20 = var1_1.getString(var11_19);
                                            }
                                            if (!var1_1.isNull(var12_21)) break block98;
                                            var12_22 = null;
                                            break block99;
                                        }
                                        var12_22 = var1_1.getString(var12_21);
                                    }
                                    var18_28 = v28;
                                    v28 = new Access((String)var11_20, var12_22);
lbl215:
                                    // 2 sources

                                    v29 = var1_1;
                                    v30 = var2_2;
                                    var11_20 = v31;
                                    v31 = new Topic(var17_27, var4_7, var5_10, var6_12, var7_13, (Date)var8_15 /* !! */ , (Date)var9_17 /* !! */ , var10_18, (Access)var18_28);
                                    if (!v29.isNull(v30)) break block100;
                                    var2_3 = null;
                                    break block101;
                                }
                                var2_3 = var1_1.getString(var2_2);
                            }
                            var11_20.setWatchPartyStreamId((String)var2_3);
lbl229:
                            // 2 sources

                            var2_3 = (ArrayList)var15_25.get((Object)var1_1.getString(var3_4));
                            if (var2_3 != null) ** GOTO lbl234
                            var2_3 = v32;
                            v32 = new ArrayList<E>();
lbl234:
                            // 2 sources

                            if ((var4_8 = (ArrayList)var16_26.get((Object)var1_1.getString(var3_4))) != null) break block102;
                            var4_8 = v33;
                            v33 = new ArrayList<E>();
                        }
                        var5_11 = v34;
                        v34 = new ChatRelation((Topic)var11_20, (List<TinodeContact>)var2_3, var4_8);
lbl242:
                        // 2 sources

                        v35 = var14_24;
                        v36 = var1_1;
                        v37 = var3_4;
                        var2_3 = (TinodeContact)var13_23.get((Object)var1_1.getString(var3_4));
                        var3_5 = (WatchPartyStatus)v35.get((Object)v36.getString(v37));
                        var4_9 = v38;
                        v38 = new WatchPartyRelation((ChatRelation)var5_11, (TinodeContact)var2_3, var3_5);
                        break block103;
                    }
                    var4_9 = null;
                }
                var1_1.close();
                roomSQLiteQuery.release();
                return var4_9;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object getWatchPartyOwner(String string2, Continuation<? super String> continuation) {
        Callable<String> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT ChatOwnerCrossRef.chatUserId FROM ChatOwnerCrossRef WHERE ChatOwnerCrossRef.chatId = ?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<String> callable2 = callable;
        callable = new Callable<String>(){

            @Override
            public String call() throws Exception {
                String string2;
                Cursor cursor;
                block5: {
                    block4: {
                        cursor = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                        try {
                            if (!cursor.moveToFirst()) break block4;
                        }
                        catch (Throwable throwable) {
                            cursor.close();
                            roomSQLiteQuery.release();
                            throw throwable;
                        }
                        if (cursor.isNull(0)) break block4;
                        string2 = cursor.getString(0);
                        break block5;
                    }
                    string2 = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return string2;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object isParticipatedInPublicParty(String string2, Continuation<? super Boolean> continuation) {
        Callable<Boolean> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT WatchPartyStatus.isParticipated FROM WatchPartyStatus WHERE WatchPartyStatus.chatId =?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<Boolean> callable2 = callable;
        callable = new Callable<Boolean>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public Boolean call() throws Exception {
                void var2_10;
                Cursor cursor;
                block12: {
                    block8: {
                        void var2_4;
                        block10: {
                            block9: {
                                cursor = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                try {
                                    if (!cursor.moveToFirst()) break block8;
                                }
                                catch (Throwable throwable) {
                                    cursor.close();
                                    roomSQLiteQuery.release();
                                    throw throwable;
                                }
                                if (!cursor.isNull(0)) break block9;
                                Object var2_2 = null;
                                break block10;
                            }
                            Integer n = cursor.getInt(0);
                        }
                        if (var2_4 != null) {
                            void var2_7;
                            block11: {
                                if (var2_4.intValue() != 0) {
                                    boolean bl = true;
                                    break block11;
                                }
                                boolean bl = false;
                            }
                            Boolean bl = (boolean)var2_7;
                            break block12;
                        }
                    }
                    Object var2_9 = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return var2_10;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }
}

