/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.dagger.modules;

import com.google.gson.Gson;
import dagger.Module;
import dagger.Provides;
import io.streamlayer.common.dagger.modules.NetworkModule;
import io.streamlayer.common.data.environment.Environment;
import io.streamlayer.common.data.environment.EnvironmentManager;
import io.streamlayer.common.data.retrofit.CDNService;
import io.streamlayer.utils.GsonUtil;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Module(includes={NetworkModule.class})
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fR\u0016\u0010\u000e\u001a\u00020\r8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lio/streamlayer/common/dagger/modules/ApiServiceModule;", "", "Lio/streamlayer/common/data/environment/EnvironmentManager;", "environmentManager", "()Lio/streamlayer/common/data/environment/EnvironmentManager;", "Lokhttp3/OkHttpClient;", "client", "Lretrofit2/Retrofit;", "retrofit", "(Lokhttp3/OkHttpClient;)Lretrofit2/Retrofit;", "Lio/streamlayer/common/data/retrofit/CDNService;", "cdnService", "(Lretrofit2/Retrofit;)Lio/streamlayer/common/data/retrofit/CDNService;", "Lio/streamlayer/common/data/environment/Environment;", "environment", "Lio/streamlayer/common/data/environment/Environment;", "<init>", "(Lio/streamlayer/common/data/environment/Environment;)V", "sdk_originalRelease"})
public final class ApiServiceModule {
    private final Environment environment;

    public ApiServiceModule(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.environment = environment;
    }

    @Provides
    @Singleton
    @NotNull
    public final EnvironmentManager environmentManager() {
        return new EnvironmentManager(this.environment);
    }

    @Provides
    @Singleton
    @NotNull
    public final Retrofit retrofit(@NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"client");
        Retrofit retrofit = new Retrofit.Builder().client(okHttpClient).baseUrl("https://api.openweathermap.org/data/2.5/").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)GsonUtil.INSTANCE.getDefaultGson())).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"Retrofit.Builder()\n     \u2026on))\n            .build()");
        return retrofit;
    }

    @Provides
    @Singleton
    @NotNull
    public final CDNService cdnService(@NotNull Retrofit retrofit) {
        Retrofit retrofit2 = retrofit;
        Intrinsics.checkNotNullParameter((Object)retrofit2, (String)"retrofit");
        Object object = retrofit2.create(CDNService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"retrofit.create(CDNService::class.java)");
        return (CDNService)object;
    }
}

