/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import androidx.annotation.RequiresApi;
import io.streamlayer.common.data.notifications.NotificationChannelsHelper$WhenMappings;
import io.streamlayer.sdk.R;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\t\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lio/streamlayer/common/data/notifications/NotificationChannelsHelper;", "", "Landroid/content/Context;", "context", "Lio/streamlayer/common/data/notifications/NotificationChannelsHelper$Channel;", "channel", "", "getChannelName", "(Landroid/content/Context;Lio/streamlayer/common/data/notifications/NotificationChannelsHelper$Channel;)Ljava/lang/String;", "getChannelDescription", "", "getChannelPriority", "(Lio/streamlayer/common/data/notifications/NotificationChannelsHelper$Channel;)I", "", "initChannels", "(Landroid/content/Context;)V", "<init>", "()V", "Channel", "sdk_originalRelease"})
public final class NotificationChannelsHelper {
    @NotNull
    public static final NotificationChannelsHelper INSTANCE = new NotificationChannelsHelper();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getChannelName(Context context, Channel channel) {
        String string2;
        int n = NotificationChannelsHelper$WhenMappings.$EnumSwitchMapping$0[channel.ordinal()];
        if (n != 1) {
            if (n != 2) throw new NoWhenBranchMatchedException();
            string2 = context.getString(R.string.slr_notif_channel_low_importance);
        } else {
            string2 = context.getString(R.string.slr_notif_channel_high_importance);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when (channel) {\n       \u2026nel_low_importance)\n    }");
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getChannelDescription(Context context, Channel channel) {
        String string2;
        int n = NotificationChannelsHelper$WhenMappings.$EnumSwitchMapping$1[channel.ordinal()];
        if (n != 1) {
            if (n != 2) throw new NoWhenBranchMatchedException();
            string2 = context.getString(R.string.slr_notif_channel_low_importance_info);
        } else {
            string2 = context.getString(R.string.slr_notif_channel_high_importance_info);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when (channel) {\n       \u2026ow_importance_info)\n    }");
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresApi(api=26)
    private final int getChannelPriority(Channel channel) {
        int n = NotificationChannelsHelper$WhenMappings.$EnumSwitchMapping$2[channel.ordinal()];
        if (n == 1) return 4;
        if (n != 2) throw new NoWhenBranchMatchedException();
        return 2;
    }

    private NotificationChannelsHelper() {
    }

    public final void initChannels(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 26) {
            Object object = context.getSystemService("notification");
            if (object != null) {
                object = (NotificationManager)object;
                for (Channel channel : Channel.values()) {
                    NotificationChannel notificationChannel;
                    Object object2;
                    if (object.getNotificationChannel(channel.name()) != null) continue;
                    NotificationChannel notificationChannel2 = object2 = notificationChannel;
                    object2 = channel.name();
                    String string2 = this.getChannelName(context, channel);
                    int n = this.getChannelPriority(channel);
                    notificationChannel2((String)object2, (CharSequence)string2, n);
                    notificationChannel.setDescription(this.getChannelDescription(context, channel));
                    object.createNotificationChannel(notificationChannel);
                }
            } else {
                throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/streamlayer/common/data/notifications/NotificationChannelsHelper$Channel;", "", "<init>", "(Ljava/lang/String;I)V", "streamlayer_high", "streamlayer_low", "sdk_originalRelease"})
    public static final class Channel
    extends Enum<Channel> {
        public static final /* enum */ Channel streamlayer_high;
        public static final /* enum */ Channel streamlayer_low;
        private static final /* synthetic */ Channel[] $VALUES;

        static {
            Channel channel;
            Channel channel2;
            Channel[] channelArray = new Channel[2];
            Channel channel3 = channel2;
            streamlayer_high = new Channel();
            channelArray[0] = channel3;
            channel3 = channel;
            streamlayer_low = new Channel();
            channelArray[1] = channel3;
            $VALUES = channelArray;
        }

        public static Channel[] values() {
            return (Channel[])$VALUES.clone();
        }

        public static Channel valueOf(String string2) {
            return Enum.valueOf(Channel.class, string2);
        }
    }
}

