/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.lite;

import android.content.Context;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import io.streamlayer.common.eventbus.SLREventBus;
import io.streamlayer.common.mvvm.BaseViewModel;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.network.NetworkConnectionLiveData;
import io.streamlayer.common.scheduler.SchedulerProvider;
import io.streamlayer.common.session.Session;
import io.streamlayer.sdk.StreamLayerEvents;
import io.streamlayer.sdk.model.advertising.AdvertisingData;
import io.streamlayer.sdk.model.advertising.AdvertisingImage;
import io.streamlayer.sdk.repository.advertising.AdvertisingRepo;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B1\b\u0007\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u0012\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u001f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0016\u0010\f\u001a\u00020\u000b8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0016\u0010\u000f\u001a\u00020\u000e8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0012\u001a\u00020\u00118\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lio/streamlayer/sdk/lite/StreamLayerLiteViewModel;", "Lio/streamlayer/common/mvvm/BaseViewModel;", "", "loadAdvertisingData", "()V", "Landroidx/lifecycle/LiveData;", "", "networkConnectionLiveData", "Landroidx/lifecycle/LiveData;", "getNetworkConnectionLiveData", "()Landroidx/lifecycle/LiveData;", "Lio/streamlayer/common/network/NetworkConnectionLiveData;", "_networkConnectionLiveData", "Lio/streamlayer/common/network/NetworkConnectionLiveData;", "Lio/streamlayer/common/session/Session;", "session", "Lio/streamlayer/common/session/Session;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "overlayShown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getOverlayShown", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "Lio/streamlayer/sdk/repository/advertising/AdvertisingRepo;", "advertisingRepo", "Lio/streamlayer/sdk/repository/advertising/AdvertisingRepo;", "Lio/streamlayer/common/eventbus/SLREventBus;", "eventBus", "Lio/streamlayer/common/scheduler/SchedulerProvider;", "schedulers", "Landroid/content/Context;", "context", "<init>", "(Lio/streamlayer/sdk/repository/advertising/AdvertisingRepo;Lio/streamlayer/common/session/Session;Lio/streamlayer/common/eventbus/SLREventBus;Lio/streamlayer/common/scheduler/SchedulerProvider;Landroid/content/Context;)V", "sdk_originalRelease"})
public final class StreamLayerLiteViewModel
extends BaseViewModel {
    @NotNull
    private final AdvertisingRepo advertisingRepo;
    @NotNull
    private final Session session;
    @NotNull
    private final NetworkConnectionLiveData _networkConnectionLiveData;
    @NotNull
    private final LiveData<Boolean> networkConnectionLiveData;
    @NotNull
    private final AtomicBoolean overlayShown;

    @Inject
    public StreamLayerLiteViewModel(@NotNull AdvertisingRepo advertisingRepo, @NotNull Session session, @NotNull SLREventBus sLREventBus, @NotNull SchedulerProvider schedulerProvider, @NotNull Context context) {
        StreamLayerLiteViewModel streamLayerLiteViewModel = this;
        Intrinsics.checkNotNullParameter((Object)advertisingRepo, (String)"advertisingRepo");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)sLREventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)schedulerProvider, (String)"schedulers");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(schedulerProvider);
        this.advertisingRepo = advertisingRepo;
        streamLayerLiteViewModel.session = session;
        this._networkConnectionLiveData = new NetworkConnectionLiveData(context);
        LiveData liveData = Transformations.distinctUntilChanged((LiveData)this._networkConnectionLiveData);
        Intrinsics.checkNotNullExpressionValue((Object)liveData, (String)"Transformations.distinctUntilChanged(this)");
        streamLayerLiteViewModel.networkConnectionLiveData = liveData;
        streamLayerLiteViewModel.overlayShown = new AtomicBoolean(false);
        if (!session.isLoggedIn()) {
            sLREventBus.produceEvent(StreamLayerEvents.LoginRequiredLiteOverlay.INSTANCE);
        }
        this.loadAdvertisingData();
    }

    private final void loadAdvertisingData() {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ StreamLayerLiteViewModel this$0;
            {
                this.this$0 = streamLayerLiteViewModel;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2;
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    ResultKt.throwOnFailure((Object)object2);
                } else {
                    ResultKt.throwOnFailure((Object)object2);
                    this.label = 1;
                    object2 = FlowKt.firstOrNull(StreamLayerLiteViewModel.access$getAdvertisingRepo$p(this.this$0).fetchAdvertisingData(), (Continuation)this);
                    if (object2 == object3) {
                        return object3;
                    }
                }
                object2 = (ResourceState)object2;
                if (object2 == null || (object2 = (List)((ResourceState)object2).getData()) == null) return Unit.INSTANCE;
                StreamLayerLiteViewModel streamLayerLiteViewModel = this.this$0;
                if ((object2 = (AdvertisingData)CollectionsKt.firstOrNull((List)object2)) == null || (object2 = (AdvertisingImage)CollectionsKt.randomOrNull(((AdvertisingData)object2).getImages(), (Random)Random.Default)) == null || (object2 = ((AdvertisingImage)object2).getFileUrl()) == null) return Unit.INSTANCE;
                StreamLayerLiteViewModel.access$getSession$p(streamLayerLiteViewModel).setCurrentSponsorAdUrl((String)object2);
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)function22, (int)3, null);
    }

    public static final /* synthetic */ AdvertisingRepo access$getAdvertisingRepo$p(StreamLayerLiteViewModel streamLayerLiteViewModel) {
        return streamLayerLiteViewModel.advertisingRepo;
    }

    public static final /* synthetic */ Session access$getSession$p(StreamLayerLiteViewModel streamLayerLiteViewModel) {
        return streamLayerLiteViewModel.session;
    }

    @NotNull
    public final LiveData<Boolean> getNetworkConnectionLiveData() {
        return this.networkConnectionLiveData;
    }

    @NotNull
    public final AtomicBoolean getOverlayShown() {
        return this.overlayShown;
    }
}

