/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.notifications;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import androidx.recyclerview.widget.RecyclerView;
import com.yuyakaido.android.cardstackview.CardStackLayoutManager;
import com.yuyakaido.android.cardstackview.CardStackListener;
import com.yuyakaido.android.cardstackview.CardStackView;
import com.yuyakaido.android.cardstackview.Direction;
import com.yuyakaido.android.cardstackview.Duration;
import com.yuyakaido.android.cardstackview.StackFrom;
import com.yuyakaido.android.cardstackview.SwipeAnimationSetting;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.main.notifications.NotificationsAdapter;
import io.streamlayer.sdk.main.notifications.NotificationsView;
import io.streamlayer.sdk.model.notifications.Notification;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000]\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005*\u0001\u001e\b\u0000\u0018\u00002\u00020\u0001:\u00015B'\b\u0007\u0012\u0006\u0010.\u001a\u00020-\u0012\n\b\u0002\u00100\u001a\u0004\u0018\u00010/\u0012\b\b\u0002\u00102\u001a\u000201\u00a2\u0006\u0004\b3\u00104J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0019\u0010\t\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0004J\u001b\u0010\u000f\u001a\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0004R\u0016\u0010\u0015\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R$\u0010\u0018\u001a\u0004\u0018\u00010\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\u001e8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\"\u0010!\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\u0016\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010\u0013R\u0016\u0010%\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010\u0016R\u0018\u0010'\u001a\u0004\u0018\u00010&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0016\u0010*\u001a\u00020)8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010,\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010\u0016\u00a8\u00066"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsView;", "Lcom/yuyakaido/android/cardstackview/CardStackView;", "", "startDismissTimer", "()V", "stopDismissTimer", "Landroid/view/MotionEvent;", "motionEvent", "", "onTouchEvent", "(Landroid/view/MotionEvent;)Z", "clearNotifications", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "notifications", "setNotifications", "(Ljava/util/List;)V", "show", "visible", "(Z)V", "onDetachedFromWindow", "touchDragging", "Z", "Lio/streamlayer/sdk/main/notifications/NotificationsView$NotificationsInteractionListener;", "listener", "Lio/streamlayer/sdk/main/notifications/NotificationsView$NotificationsInteractionListener;", "getListener", "()Lio/streamlayer/sdk/main/notifications/NotificationsView$NotificationsInteractionListener;", "setListener", "(Lio/streamlayer/sdk/main/notifications/NotificationsView$NotificationsInteractionListener;)V", "io/streamlayer/sdk/main/notifications/NotificationsView$notificationStackListener$1", "notificationStackListener", "Lio/streamlayer/sdk/main/notifications/NotificationsView$notificationStackListener$1;", "onScreen", "getOnScreen", "()Z", "setOnScreen", "dismissedAll", "Ljava/util/Timer;", "dismissTimer", "Ljava/util/Timer;", "Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;", "notificationsAdapter", "Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;", "animateAppearingCard", "Landroid/content/Context;", "context", "Landroid/util/AttributeSet;", "attrs", "", "defStyleAttr", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "NotificationsInteractionListener", "sdk_originalRelease"})
public final class NotificationsView
extends CardStackView {
    @Nullable
    private NotificationsInteractionListener listener;
    private boolean onScreen;
    @Nullable
    private Timer dismissTimer;
    private boolean animateAppearingCard;
    private boolean touchDragging;
    private boolean dismissedAll;
    @NotNull
    private final NotificationsAdapter notificationsAdapter;
    @NotNull
    private final notificationStackListener.1 notificationStackListener;

    @JvmOverloads
    public NotificationsView(@NotNull Context context, @Nullable AttributeSet object, int n) {
        CardStackListener cardStackListener;
        NotificationsAdapter notificationsAdapter;
        NotificationsView notificationsView = notificationsView4;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, object, n);
        notificationsView.onScreen = true;
        notificationsView.animateAppearingCard = true;
        Object object2 = object = notificationsAdapter;
        NotificationsView notificationsView2 = notificationsView4;
        Object object3 = object;
        super();
        notificationsView2.notificationsAdapter = object3;
        object = cardStackListener;
        notificationsView2.notificationStackListener = new CardStackListener(notificationsView4){
            final /* synthetic */ NotificationsView this$0;
            {
                this.this$0 = notificationsView;
            }

            public void onCardDisappeared(@Nullable View object, int n) {
                if (!NotificationsView.access$getDismissedAll$p(notification.this$0)) {
                    if (NotificationsView.access$getNotificationsAdapter$p(notification.this$0).getItemCount() > 0) {
                        notificationStackListener.1 v0 = notification;
                        Notification notification = (Notification)NotificationsView.access$getNotificationsAdapter$p(v0.this$0).getItem(0);
                        object = v0.this$0.getListener();
                        if (object != null) {
                            object.onNotificationDismissed(notification);
                        }
                    }
                } else {
                    object = notification.this$0.getListener();
                    if (object != null) {
                        object.onAllNotificationsDismissed(NotificationsView.access$getNotificationsAdapter$p(notification.this$0).getItemsList());
                    }
                }
            }

            public void onCardDragging(@Nullable Direction direction, float f) {
                if (direction == Direction.Bottom) {
                    notificationStackListener.1 v0 = this;
                    NotificationsView.access$setDismissedAll$p(v0.this$0, true);
                    v0.this$0.animate().translationY((float)this.this$0.getHeight() * f).start();
                } else {
                    NotificationsView.access$setDismissedAll$p(this.this$0, false);
                }
            }

            public void onCardSwiped(@Nullable Direction object) {
                if (object == Direction.Bottom) {
                    notificationStackListener.1 v0 = this;
                    NotificationsView.access$setDismissedAll$p(v0.this$0, true);
                    object = v0.this$0.getListener();
                    if (object != null) {
                        object.onAllNotificationsDismissed(NotificationsView.access$getNotificationsAdapter$p(this.this$0).getItemsList());
                    }
                } else if (object == Direction.Top) {
                    notificationStackListener.1 v1 = this;
                    NotificationsView.access$setDismissedAll$p(v1.this$0, false);
                    NotificationsView.access$setAnimateAppearingCard$p(v1.this$0, false);
                    NotificationsView.access$getNotificationsAdapter$p(v1.this$0).getItemAndRemove(0);
                }
                this.this$0.animate().translationY(0.0f).start();
            }

            public void onCardCanceled() {
                this.this$0.animate().translationY(0.0f).start();
            }

            public void onCardAppeared(@Nullable View view2, int n) {
                if (NotificationsView.access$getAnimateAppearingCard$p(this.this$0)) {
                    TranslateAnimation translateAnimation;
                    AnimationSet animationSet;
                    AnimationSet animationSet2 = animationSet;
                    TranslateAnimation translateAnimation2 = translateAnimation;
                    translateAnimation = new TranslateAnimation((float)this.this$0.getWidth(), 0.0f, 0.0f, 0.0f);
                    new AnimationSet(true).addAnimation((Animation)new AlphaAnimation(0.0f, 1.0f));
                    animationSet2.addAnimation((Animation)translateAnimation2);
                    animationSet2.setDuration(300L);
                    if (view2 != null) {
                        view2.startAnimation((Animation)animationSet2);
                    }
                }
            }

            public void onCardRewound() {
            }
        };
        NotificationsView notificationsView3 = notificationsView4;
        n = notificationsView3.getResources().getDimensionPixelSize(R.dimen.slr_activity_vertical_margin);
        int n2 = notificationsView3.getResources().getDimensionPixelSize(R.dimen.slr_activity_horizontal_margin_small);
        int n3 = notificationsView3.getResources().getDimensionPixelSize(R.dimen.slr_activity_vertical_margin);
        notificationsView2.setPadding(notificationsView2.getResources().getDimensionPixelSize(R.dimen.slr_activity_horizontal_margin_small), n, n2, n3);
        notificationsView4.setAdapter((RecyclerView.Adapter)object2);
        notificationsAdapter.setListener(new NotificationsAdapter.OnItemInteractionListener(){

            private static final void onNotificationClick$lambda-0(NotificationsView object, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"$notification");
                object = ((NotificationsView)((Object)object)).getListener();
                if (object != null) {
                    object.onNotificationClick(notification);
                }
            }

            @Override
            public void onNotificationClick(@NotNull Notification notification) {
                1 v0 = this;
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                v0.notificationsView4.dismissedAll = false;
                v0.notificationsView4.swipe();
                NotificationsView notificationsView = v0.notificationsView4;
                notificationsView.postDelayed(() -> 1.onNotificationClick$lambda-0(notificationsView, notification), 300L);
            }
        });
        final NotificationsView notificationsView4 = new SwipeAnimationSetting.Builder().setDirection(Direction.Right).setDuration(Duration.Normal.duration).setInterpolator((Interpolator)new AccelerateInterpolator()).build();
        CardStackLayoutManager cardStackLayoutManager = new CardStackLayoutManager(context, (CardStackListener)object);
        cardStackLayoutManager.setCanScrollHorizontal(false);
        cardStackLayoutManager.setStackFrom(StackFrom.Bottom);
        cardStackLayoutManager.setDirections(Direction.VERTICAL);
        cardStackLayoutManager.setTranslationInterval(4.0f);
        cardStackLayoutManager.setScaleInterval(0.98f);
        cardStackLayoutManager.setSwipeThreshold(0.05f);
        cardStackLayoutManager.setSwipeAnimationSetting((SwipeAnimationSetting)notificationsView4);
        notificationsView.setLayoutManager((RecyclerView.LayoutManager)cardStackLayoutManager);
    }

    public /* synthetic */ NotificationsView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final void startDismissTimer() {
        TimerTask timerTask;
        Timer timer;
        Timer timer2 = this.dismissTimer;
        if (timer2 != null) {
            timer2.cancel();
        }
        timer2 = timer;
        TimerTask timerTask2 = timerTask;
        timerTask = new TimerTask(this){
            final /* synthetic */ NotificationsView this$0;
            {
                this.this$0 = notificationsView;
            }

            private static final void run$lambda-0(NotificationsView notificationsView) {
                NotificationsView notificationsView2 = notificationsView;
                Intrinsics.checkNotNullParameter((Object)((Object)notificationsView2), (String)"this$0");
                notificationsView2.swipe();
                if (NotificationsView.access$getNotificationsAdapter$p(notificationsView2).getItemCount() > 0) {
                    NotificationsView notificationsView3 = notificationsView;
                    Object object = NotificationsView.access$getNotificationsAdapter$p(notificationsView3).getItemAndRemove(0);
                    NotificationsInteractionListener notificationsInteractionListener = notificationsView3.getListener();
                    if (notificationsInteractionListener != null) {
                        notificationsInteractionListener.onNotificationDismissed((Notification)object);
                    }
                    if (NotificationsView.access$getNotificationsAdapter$p(notificationsView).getItemCount() == 0) {
                        object = notificationsView.getListener();
                        if (object != null) {
                            object.onAllNotificationsDismissed(CollectionsKt.emptyList());
                        }
                        NotificationsView.access$setDismissedAll$p(notificationsView, true);
                    }
                }
            }

            public void run() {
                if (NotificationsView.access$getNotificationsAdapter$p(this.this$0).getItemCount() == 0) {
                    NotificationsView.access$stopDismissTimer(this.this$0);
                } else {
                    startDismissTimer.1.1 v0 = this;
                    NotificationsView.access$setDismissedAll$p(v0.this$0, false);
                    NotificationsView notificationsView = v0.this$0;
                    notificationsView.post(() -> startDismissTimer.1.1.run$lambda-0(notificationsView));
                }
            }
        };
        new Timer().scheduleAtFixedRate(timerTask2, 8000L, 8000L);
        this.dismissTimer = timer2;
    }

    private final void stopDismissTimer() {
        Timer timer = ((NotificationsView)((Object)timer)).dismissTimer;
        if (timer != null) {
            timer.cancel();
        }
    }

    @JvmOverloads
    public NotificationsView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public NotificationsView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ NotificationsAdapter access$getNotificationsAdapter$p(NotificationsView notificationsView) {
        return notificationsView.notificationsAdapter;
    }

    public static final /* synthetic */ void access$stopDismissTimer(NotificationsView notificationsView) {
        notificationsView.stopDismissTimer();
    }

    public static final /* synthetic */ boolean access$getDismissedAll$p(NotificationsView notificationsView) {
        return notificationsView.dismissedAll;
    }

    public static final /* synthetic */ void access$setAnimateAppearingCard$p(NotificationsView notificationsView, boolean bl) {
        notificationsView.animateAppearingCard = bl;
    }

    public static final /* synthetic */ boolean access$getAnimateAppearingCard$p(NotificationsView notificationsView) {
        return notificationsView.animateAppearingCard;
    }

    @Nullable
    public final NotificationsInteractionListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable NotificationsInteractionListener notificationsInteractionListener) {
        this.listener = notificationsInteractionListener;
    }

    public final boolean getOnScreen() {
        return this.onScreen;
    }

    public final void setOnScreen(boolean bl) {
        this.onScreen = bl;
    }

    public boolean onTouchEvent(@Nullable MotionEvent motionEvent) {
        if (motionEvent == null) {
            return false;
        }
        if (!(motionEvent.getY() > (float)(this.getHeight() - ExtensionsKt.getDp(80.0f))) && !this.touchDragging) {
            return false;
        }
        super.onTouchEvent(motionEvent);
        if (motionEvent.getActionMasked() != 0 && motionEvent.getActionMasked() != 2) {
            if (motionEvent.getActionMasked() == 1) {
                this.touchDragging = false;
            }
        } else {
            this.touchDragging = true;
        }
        return true;
    }

    public final void clearNotifications() {
        this.notificationsAdapter.clearItems();
    }

    public final void setNotifications(@NotNull List<Notification> list) {
        NotificationsView notificationsView = this;
        Intrinsics.checkNotNullParameter(list, (String)"notifications");
        notificationsView.animateAppearingCard = notificationsView.notificationsAdapter.updateItems(list);
        notificationsView.animate().translationY((float)(3 - RangesKt.coerceAtMost((int)list.size(), (int)3)) * (float)ExtensionsKt.getDp(4.0f)).start();
        if (list.isEmpty() ^ true) {
            this.startDismissTimer();
        } else {
            this.stopDismissTimer();
        }
    }

    public final void visible(boolean bl) {
        this.onScreen = bl;
        ExtensionsKt.visibleIf((View)this, bl);
    }

    protected void onDetachedFromWindow() {
        NotificationsView notificationsView = timer;
        super.onDetachedFromWindow();
        Timer timer = notificationsView.dismissTimer;
        if (timer != null) {
            timer.cancel();
        }
    }

    public void _$_clearFindViewByIdCache() {
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u001d\u0010\n\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\bH&\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsView$NotificationsInteractionListener;", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "notification", "", "onNotificationClick", "(Lio/streamlayer/sdk/model/notifications/Notification;)V", "onNotificationDismissed", "", "notifications", "onAllNotificationsDismissed", "(Ljava/util/List;)V", "sdk_originalRelease"})
    public static interface NotificationsInteractionListener {
        public void onNotificationClick(@NotNull Notification var1);

        public void onNotificationDismissed(@NotNull Notification var1);

        public void onAllNotificationsDismissed(@NotNull List<Notification> var1);
    }
}

