/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.sports;

import com.streamlayer.sports.events.SummaryResponse;
import io.streamlayer.sdk.model.sports.Event;
import io.streamlayer.sdk.model.sports.EventData;
import io.streamlayer.sdk.model.sports.EventPeriod;
import io.streamlayer.sdk.model.sports.EventStatus;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.sdk.model.sports.EventSummaryRelation;
import io.streamlayer.sdk.model.sports.EventSummaryResponseData;
import io.streamlayer.sdk.model.sports.EventSummaryResponseDataRelation;
import io.streamlayer.sdk.model.sports.EventTeam;
import io.streamlayer.sdk.model.sports.EventTime;
import io.streamlayer.sdk.model.sports.EventType;
import io.streamlayer.sdk.model.sports.basketball.BasketballEventSummary;
import io.streamlayer.sdk.model.sports.basketball.BasketballSummaryKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0013\u0010\u0002\u001a\u00020\u0005*\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0006\u001a\u0017\u0010\u0002\u001a\u00020\t*\u00060\u0007j\u0002`\bH\u0000\u00a2\u0006\u0004\b\u0002\u0010\n\u001a\u0017\u0010\u0002\u001a\u00020\r*\u00060\u000bj\u0002`\fH\u0000\u00a2\u0006\u0004\b\u0002\u0010\u000e\u001a\u0017\u0010\u0002\u001a\u00020\u0011*\u00060\u000fj\u0002`\u0010H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0012\u001a\u0017\u0010\u0002\u001a\u00020\u0015*\u00060\u0013j\u0002`\u0014H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0016\u001a\u0017\u0010\u0002\u001a\u00020\u0019*\u00060\u0017j\u0002`\u0018H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u001a\u001a\u0017\u0010\u0002\u001a\u00020\u0001*\u00060\u001bj\u0002`\u001cH\u0000\u00a2\u0006\u0004\b\u0002\u0010\u001d\u001a\u0017\u0010\u0002\u001a\u00020 *\u00060\u001ej\u0002`\u001fH\u0000\u00a2\u0006\u0004\b\u0002\u0010!\u001a\u0017\u0010\u0002\u001a\u00020$*\u00060\"j\u0002`#H\u0000\u00a2\u0006\u0004\b\u0002\u0010%\u001a\u0017\u0010\u0002\u001a\u00020\u0005*\u00060&j\u0002`'H\u0000\u00a2\u0006\u0004\b\u0002\u0010(*\f\b\u0000\u0010)\"\u00020\u00072\u00020\u0007*\f\b\u0000\u0010*\"\u00020\u00132\u00020\u0013*\f\b\u0000\u0010+\"\u00020\u00172\u00020\u0017*\f\b\u0000\u0010,\"\u00020\u001e2\u00020\u001e*\f\b\u0000\u0010-\"\u00020\u001b2\u00020\u001b*\f\b\u0000\u0010.\"\u00020&2\u00020&*\f\b\u0000\u0010/\"\u00020\u000b2\u00020\u000b*\f\b\u0000\u00100\"\u00020\"2\u00020\"*\f\b\u0000\u00101\"\u00020\u000f2\u00020\u000f\u00a8\u00062"}, d2={"Lio/streamlayer/sdk/model/sports/EventSummaryRelation;", "Lio/streamlayer/sdk/model/sports/EventSummary;", "toDomain", "(Lio/streamlayer/sdk/model/sports/EventSummaryRelation;)Lio/streamlayer/sdk/model/sports/EventSummary;", "Lio/streamlayer/sdk/model/sports/EventSummaryResponseDataRelation;", "Lio/streamlayer/sdk/model/sports/EventSummaryResponseData;", "(Lio/streamlayer/sdk/model/sports/EventSummaryResponseDataRelation;)Lio/streamlayer/sdk/model/sports/EventSummaryResponseData;", "Lcom/streamlayer/sports/common/EventData;", "Lio/streamlayer/sdk/model/sports/EventDataProto;", "Lio/streamlayer/sdk/model/sports/EventData;", "(Lcom/streamlayer/sports/common/EventData;)Lio/streamlayer/sdk/model/sports/EventData;", "Lcom/streamlayer/sports/common/EventTeam;", "Lio/streamlayer/sdk/model/sports/EventTeamProto;", "Lio/streamlayer/sdk/model/sports/EventTeam;", "(Lcom/streamlayer/sports/common/EventTeam;)Lio/streamlayer/sdk/model/sports/EventTeam;", "Lcom/streamlayer/sports/events/EventType;", "Lio/streamlayer/sdk/model/sports/EventTypeProto;", "Lio/streamlayer/sdk/model/sports/EventType;", "(Lcom/streamlayer/sports/events/EventType;)Lio/streamlayer/sdk/model/sports/EventType;", "Lcom/streamlayer/sports/common/EventPeriod;", "Lio/streamlayer/sdk/model/sports/EventPeriodProto;", "Lio/streamlayer/sdk/model/sports/EventPeriod;", "(Lcom/streamlayer/sports/common/EventPeriod;)Lio/streamlayer/sdk/model/sports/EventPeriod;", "Lcom/streamlayer/sports/common/Event;", "Lio/streamlayer/sdk/model/sports/EventProto;", "Lio/streamlayer/sdk/model/sports/Event;", "(Lcom/streamlayer/sports/common/Event;)Lio/streamlayer/sdk/model/sports/Event;", "Lcom/streamlayer/sports/common/EventSummary;", "Lio/streamlayer/sdk/model/sports/EventSummaryProto;", "(Lcom/streamlayer/sports/common/EventSummary;)Lio/streamlayer/sdk/model/sports/EventSummary;", "Lcom/streamlayer/sports/common/EventStatus;", "Lio/streamlayer/sdk/model/sports/EventStatusProto;", "Lio/streamlayer/sdk/model/sports/EventStatus;", "(Lcom/streamlayer/sports/common/EventStatus;)Lio/streamlayer/sdk/model/sports/EventStatus;", "Lcom/streamlayer/sports/common/EventTime;", "Lio/streamlayer/sdk/model/sports/EventTimeProto;", "Lio/streamlayer/sdk/model/sports/EventTime;", "(Lcom/streamlayer/sports/common/EventTime;)Lio/streamlayer/sdk/model/sports/EventTime;", "Lcom/streamlayer/sports/events/SummaryResponse$ResponseData;", "Lio/streamlayer/sdk/model/sports/EventSummaryResponseDataProto;", "(Lcom/streamlayer/sports/events/SummaryResponse$ResponseData;)Lio/streamlayer/sdk/model/sports/EventSummaryResponseData;", "EventDataProto", "EventPeriodProto", "EventProto", "EventStatusProto", "EventSummaryProto", "EventSummaryResponseDataProto", "EventTeamProto", "EventTimeProto", "EventTypeProto", "sdk_originalRelease"})
public final class EventsKt {
    @NotNull
    public static final EventSummary toDomain(@NotNull EventSummaryRelation eventSummaryRelation) {
        EventSummaryRelation eventSummaryRelation2 = eventSummaryRelation;
        Intrinsics.checkNotNullParameter((Object)eventSummaryRelation2, (String)"<this>");
        EventSummary eventSummary = eventSummaryRelation2.getData();
        eventSummary.setHomeTeam(eventSummaryRelation.getHomeTeam());
        eventSummary.setAwayTeam(eventSummaryRelation.getAwayTeam());
        return eventSummary;
    }

    @NotNull
    public static final EventSummaryResponseData toDomain(@NotNull EventSummaryResponseDataRelation eventSummaryResponseDataRelation) {
        EventSummaryResponseDataRelation eventSummaryResponseDataRelation2 = eventSummaryResponseDataRelation;
        Intrinsics.checkNotNullParameter((Object)eventSummaryResponseDataRelation2, (String)"<this>");
        EventSummaryResponseData eventSummaryResponseData = eventSummaryResponseDataRelation2.getData();
        EventSummaryResponseDataRelation eventSummaryResponseDataRelation3 = eventSummaryResponseDataRelation;
        eventSummaryResponseDataRelation3.getData().setEventSummary(EventsKt.toDomain(eventSummaryResponseDataRelation.getEventSummary()));
        eventSummaryResponseDataRelation3.getData().setBasketballEventSummary(eventSummaryResponseDataRelation.getBasketballEventSummary());
        return eventSummaryResponseData;
    }

    @NotNull
    public static final EventData toDomain(@NotNull com.streamlayer.sports.common.EventData object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.sports.common.EventData eventData = object;
        long l = eventData.getId();
        object = eventData.getSport();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sport");
        String string2 = eventData.getLeague();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"league");
        String string3 = eventData.getScheduled();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"scheduled");
        com.streamlayer.sports.common.EventTeam eventTeam = eventData.getHome();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam, (String)"home");
        EventTeam eventTeam2 = EventsKt.toDomain(eventTeam);
        com.streamlayer.sports.common.EventTeam eventTeam3 = eventData.getAway();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam3, (String)"away");
        EventTeam eventTeam4 = EventsKt.toDomain(eventTeam3);
        return new EventData(l, (String)object, string2, string3, eventTeam2, eventTeam4);
    }

    @NotNull
    public static final EventTeam toDomain(@NotNull com.streamlayer.sports.common.EventTeam object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.sports.common.EventTeam eventTeam = object;
        long l = eventTeam.getId();
        object = eventTeam.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
        String string2 = eventTeam.getAlias();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"alias");
        String string3 = eventTeam.getLogo();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"logo");
        List list = eventTeam.getColorsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"colorsList");
        List list2 = CollectionsKt.toList((Iterable)list);
        boolean bl = eventTeam.getIsWinner();
        return new EventTeam(l, (String)object, string2, string3, list2, bl);
    }

    @NotNull
    public static final EventType toDomain(@NotNull com.streamlayer.sports.events.EventType eventType) {
        EventType eventType2;
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[eventType.ordinal()]) {
            default: {
                throw new NoWhenBranchMatchedException();
            }
            case 6: {
                eventType2 = EventType.Soccer;
                break;
            }
            case 5: {
                eventType2 = EventType.Unrecognized;
                break;
            }
            case 4: {
                eventType2 = EventType.Unset;
                break;
            }
            case 3: {
                eventType2 = EventType.Hockey;
                break;
            }
            case 2: {
                eventType2 = EventType.Basketball;
                break;
            }
            case 1: {
                eventType2 = EventType.Baseball;
            }
        }
        return eventType2;
    }

    @NotNull
    public static final EventPeriod toDomain(@NotNull com.streamlayer.sports.common.EventPeriod eventPeriod) {
        Intrinsics.checkNotNullParameter((Object)eventPeriod, (String)"<this>");
        com.streamlayer.sports.common.EventPeriod eventPeriod2 = eventPeriod;
        int n = eventPeriod2.getNumber();
        int n2 = eventPeriod2.getScoreHome();
        int n3 = eventPeriod2.getScoreAway();
        return new EventPeriod(n, n2, n3);
    }

    @NotNull
    public static final Event toDomain(@NotNull com.streamlayer.sports.common.Event event) {
        ArrayList<EventPeriod> arrayList;
        com.streamlayer.sports.common.Event event2 = event;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"<this>");
        long l = event2.getId();
        long l2 = event2.getLeagueId();
        long l3 = event2.getHomeTeamId();
        long l4 = event2.getAwayTeamId();
        int n = event2.getScoreHome();
        int n2 = event2.getScoreAway();
        Object object = event2.getPeriodsList();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"periodsList");
        ArrayList<EventPeriod> arrayList2 = arrayList;
        arrayList = new ArrayList<EventPeriod>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            com.streamlayer.sports.common.EventPeriod eventPeriod = (com.streamlayer.sports.common.EventPeriod)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)eventPeriod, (String)"it");
            arrayList2.add(EventsKt.toDomain(eventPeriod));
        }
        com.streamlayer.sports.common.Event event3 = event;
        int n3 = event3.getPeriodsCount();
        long l5 = event3.getWinnerTeamId();
        object = l5;
        return new Event(l, l2, l3, l4, (Long)object, n, n2, arrayList2, n3);
    }

    @NotNull
    public static final EventSummary toDomain(@NotNull com.streamlayer.sports.common.EventSummary eventSummary) {
        ArrayList<EventPeriod> arrayList;
        com.streamlayer.sports.common.EventSummary eventSummary2 = eventSummary;
        Intrinsics.checkNotNullParameter((Object)eventSummary2, (String)"<this>");
        long l = eventSummary2.getId();
        String string2 = eventSummary2.getScheduled();
        String string3 = eventSummary2.getLeague();
        int n = eventSummary2.getScoreHome();
        int n2 = eventSummary2.getScoreAway();
        com.streamlayer.sports.common.EventTeam eventTeam = eventSummary2.getHomeTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam, (String)"homeTeam");
        EventTeam eventTeam2 = EventsKt.toDomain(eventTeam);
        com.streamlayer.sports.common.EventTeam eventTeam3 = eventSummary2.getAwayTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam3, (String)"awayTeam");
        EventTeam eventTeam4 = EventsKt.toDomain(eventTeam3);
        com.streamlayer.sports.common.EventStatus eventStatus = eventSummary2.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)eventStatus, (String)"status");
        EventStatus eventStatus2 = EventsKt.toDomain(eventStatus);
        com.streamlayer.sports.common.EventTime eventTime = eventSummary2.getEventTime();
        Intrinsics.checkNotNullExpressionValue((Object)eventTime, (String)"eventTime");
        EventTime eventTime2 = EventsKt.toDomain(eventTime);
        Object object = eventSummary2.getPeriodsList();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"periodsList");
        ArrayList<EventPeriod> arrayList2 = arrayList;
        arrayList = new ArrayList<EventPeriod>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            com.streamlayer.sports.common.EventPeriod eventPeriod = (com.streamlayer.sports.common.EventPeriod)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)eventPeriod, (String)"it");
            arrayList2.add(EventsKt.toDomain(eventPeriod));
        }
        int n3 = eventSummary.getPeriodsCount();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"scheduled");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"league");
        return new EventSummary(l, string2, string3, n, n2, eventTime2, eventTeam2, eventTeam4, eventStatus2, arrayList2, n3);
    }

    @NotNull
    public static final EventStatus toDomain(@NotNull com.streamlayer.sports.common.EventStatus eventStatus) {
        EventStatus eventStatus2;
        Intrinsics.checkNotNullParameter((Object)eventStatus, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[eventStatus.ordinal()]) {
            default: {
                eventStatus2 = EventStatus.Unset;
                break;
            }
            case 7: {
                eventStatus2 = EventStatus.Shootouts;
                break;
            }
            case 6: {
                eventStatus2 = EventStatus.Pregame;
                break;
            }
            case 5: {
                eventStatus2 = EventStatus.Postgame;
                break;
            }
            case 4: {
                eventStatus2 = EventStatus.Overtime;
                break;
            }
            case 3: {
                eventStatus2 = EventStatus.Cancelled;
                break;
            }
            case 2: {
                eventStatus2 = EventStatus.Break;
                break;
            }
            case 1: {
                eventStatus2 = EventStatus.Active;
            }
        }
        return eventStatus2;
    }

    @NotNull
    public static final EventTime toDomain(@NotNull com.streamlayer.sports.common.EventTime object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.sports.common.EventTime eventTime = object;
        object = eventTime.getClock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clock");
        return new EventTime((String)object, eventTime.getPeriod());
    }

    @NotNull
    public static final EventSummaryResponseData toDomain(@NotNull SummaryResponse.ResponseData object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        SummaryResponse.ResponseData responseData = object;
        long l = responseData.getId();
        com.streamlayer.sports.events.EventType eventType = responseData.getType();
        SummaryResponse.ResponseData responseData2 = object;
        com.streamlayer.sports.events.EventType eventType2 = eventType;
        Intrinsics.checkNotNullExpressionValue((Object)eventType2, (String)"type");
        EventType eventType3 = EventsKt.toDomain(eventType2);
        com.streamlayer.sports.common.EventSummary eventSummary = responseData2.getAttributes().getSummary();
        Intrinsics.checkNotNullExpressionValue((Object)eventSummary, (String)"attributes.summary");
        EventSummary eventSummary2 = EventsKt.toDomain(eventSummary);
        com.streamlayer.sports.basketball.EventSummary eventSummary3 = responseData2.getAttributes().getBasketball();
        Intrinsics.checkNotNullExpressionValue((Object)eventSummary3, (String)"attributes.basketball");
        object = BasketballSummaryKt.toDomain(eventSummary3, object.getId());
        return new EventSummaryResponseData(l, eventType3, eventSummary2, (BasketballEventSummary)object);
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[com.streamlayer.sports.events.EventType.values().length];
            nArray[com.streamlayer.sports.events.EventType.EVENT_TYPE_BASEBALL.ordinal()] = 1;
            nArray[com.streamlayer.sports.events.EventType.EVENT_TYPE_BASKETBALL.ordinal()] = 2;
            nArray[com.streamlayer.sports.events.EventType.EVENT_TYPE_HOCKEY.ordinal()] = 3;
            nArray[com.streamlayer.sports.events.EventType.EVENT_TYPE_UNSET.ordinal()] = 4;
            nArray[com.streamlayer.sports.events.EventType.UNRECOGNIZED.ordinal()] = 5;
            nArray[com.streamlayer.sports.events.EventType.EVENT_TYPE_SOCCER.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
            int[] nArray2 = new int[com.streamlayer.sports.common.EventStatus.values().length];
            nArray2[com.streamlayer.sports.common.EventStatus.EVENT_STATUS_ACTIVE.ordinal()] = 1;
            nArray2[com.streamlayer.sports.common.EventStatus.EVENT_STATUS_BREAK.ordinal()] = 2;
            nArray2[com.streamlayer.sports.common.EventStatus.EVENT_STATUS_CANCELLED.ordinal()] = 3;
            nArray2[com.streamlayer.sports.common.EventStatus.EVENT_STATUS_OVERTIME.ordinal()] = 4;
            nArray2[com.streamlayer.sports.common.EventStatus.EVENT_STATUS_POSTGAME.ordinal()] = 5;
            nArray2[com.streamlayer.sports.common.EventStatus.EVENT_STATUS_PREGAME.ordinal()] = 6;
            nArray2[com.streamlayer.sports.common.EventStatus.EVENT_STATUS_SHOOTOUTS.ordinal()] = 7;
            $EnumSwitchMapping$1 = nArray2;
        }
    }
}

