/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.basketball;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import io.reactivex.disposables.Disposable;
import io.streamlayer.common.mvvm.BaseViewModel;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.mvvm.basemodels.ResourceStateKt;
import io.streamlayer.common.scheduler.SchedulerProvider;
import io.streamlayer.common.session.Session;
import io.streamlayer.sdk.model.sports.EventScheduleData;
import io.streamlayer.sdk.model.sports.EventSummaryResponseData;
import io.streamlayer.sdk.model.sports.EventType;
import io.streamlayer.sdk.model.sports.basketball.BasketballBoxScore;
import io.streamlayer.sdk.model.sports.basketball.BasketballConference;
import io.streamlayer.sdk.model.sports.basketball.BasketballStandings;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamStanding;
import io.streamlayer.sdk.model.sports.basketball.GroupedBasketballStandings;
import io.streamlayer.sdk.repository.sports.basketball.BasketballRepo;
import io.streamlayer.sdk.repository.sports.events.SportEventsRepo;
import io.streamlayer.sdk.statistics.basketball.BasketballStatisticsViewModel;
import io.streamlayer.sdk.statistics.common.model.PlayByPlayStatistics;
import io.streamlayer.sdk.usecases.StatisticsUseCase;
import io.streamlayer.utils.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B1\b\u0007\u0012\u0006\u0010M\u001a\u00020L\u0012\u0006\u0010?\u001a\u00020>\u0012\u0006\u0010P\u001a\u00020O\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010J\u001a\u00020I\u00a2\u0006\u0004\bS\u0010TJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\b\u0010\u0006J\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0012\u0010\fJ\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0013\u0010\fJ\u0015\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\t\u00a2\u0006\u0004\b\u0015\u0010\fR\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R%\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u001a0\u00198\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u000b\u0010\u001dR\"\u0010\u001f\u001a\u00020\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\"\u0010%\u001a\u00020\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010 \u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R+\u0010)\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0(0\u001a0\u00198\u0006@\u0006\u00a2\u0006\f\n\u0004\b)\u0010\u001c\u001a\u0004\b*\u0010\u001dR+\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0(0\u001a0\u00198\u0006@\u0006\u00a2\u0006\f\n\u0004\b,\u0010\u001c\u001a\u0004\b\u0012\u0010\u001dR\u0018\u0010-\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\"\u0010/\u001a\u00020\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u0010 \u001a\u0004\b0\u0010\"\"\u0004\b1\u0010$R\u0018\u00103\u001a\u0004\u0018\u0001028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\"\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002060\u001a058\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R\"\u00109\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u001a058\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u00108R(\u0010:\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0(0\u001a058\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u00108R(\u0010;\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0(0\u001a058\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u00108R\"\u0010=\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0\u001a058\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u00108R\u0016\u0010?\u001a\u00020>8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@R%\u0010A\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002060\u001a0\u00198\u0006@\u0006\u00a2\u0006\f\n\u0004\bA\u0010\u001c\u001a\u0004\b\u0007\u0010\u001dR+\u0010C\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020B0(0\u001a0\u00198\u0006@\u0006\u00a2\u0006\f\n\u0004\bC\u0010\u001c\u001a\u0004\b\b\u0010\u001dR(\u0010D\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020B0(0\u001a058\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u00108R\"\u0010E\u001a\u00020\t8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\bE\u0010.\u001a\u0004\bF\u0010G\"\u0004\bH\u0010\fR\u0016\u0010J\u001a\u00020I8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0016\u0010M\u001a\u00020L8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u0016\u0010P\u001a\u00020O8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bP\u0010QR%\u0010R\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0\u001a0\u00198\u0006@\u0006\u00a2\u0006\f\n\u0004\bR\u0010\u001c\u001a\u0004\b\u0005\u0010\u001d\u00a8\u0006U"}, d2={"Lio/streamlayer/sdk/statistics/basketball/BasketballStatisticsViewModel;", "Lio/streamlayer/common/mvvm/BaseViewModel;", "", "id", "", "getSummaryData", "(J)V", "getBoxScoreData", "getPlayByPlayData", "", "league", "getStandings", "(Ljava/lang/String;)V", "Lio/streamlayer/sdk/model/sports/basketball/BasketballStandings;", "data", "Lio/streamlayer/sdk/model/sports/basketball/GroupedBasketballStandings;", "groupStandings", "(Lio/streamlayer/sdk/model/sports/basketball/BasketballStandings;)Lio/streamlayer/sdk/model/sports/basketball/GroupedBasketballStandings;", "getScheduleData", "getDates", "date", "getSchedule", "Lio/streamlayer/common/scheduler/SchedulerProvider;", "schedulers", "Lio/streamlayer/common/scheduler/SchedulerProvider;", "Landroidx/lifecycle/LiveData;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "standings", "Landroidx/lifecycle/LiveData;", "()Landroidx/lifecycle/LiveData;", "", "easternStandingsSelected", "Z", "getEasternStandingsSelected", "()Z", "setEasternStandingsSelected", "(Z)V", "playByPlayAllPlaysFilter", "getPlayByPlayAllPlaysFilter", "setPlayByPlayAllPlaysFilter", "", "scheduleDates", "getScheduleDates", "Lio/streamlayer/sdk/model/sports/EventScheduleData;", "scheduleData", "eventLeague", "Ljava/lang/String;", "boxScoreHomeSelected", "getBoxScoreHomeSelected", "setBoxScoreHomeSelected", "Lio/reactivex/disposables/Disposable;", "scheduleDisposable", "Lio/reactivex/disposables/Disposable;", "Landroidx/lifecycle/MutableLiveData;", "Lio/streamlayer/sdk/model/sports/basketball/BasketballBoxScore;", "_boxScoreData", "Landroidx/lifecycle/MutableLiveData;", "_standings", "_scheduleDates", "_scheduleData", "Lio/streamlayer/sdk/model/sports/EventSummaryResponseData;", "_summaryData", "Lio/streamlayer/sdk/repository/sports/basketball/BasketballRepo;", "basketballRepo", "Lio/streamlayer/sdk/repository/sports/basketball/BasketballRepo;", "boxScoreData", "Lio/streamlayer/sdk/statistics/common/model/PlayByPlayStatistics;", "playByPlayData", "_playByPlayData", "selectedDate", "getSelectedDate", "()Ljava/lang/String;", "setSelectedDate", "Lio/streamlayer/sdk/usecases/StatisticsUseCase;", "uc", "Lio/streamlayer/sdk/usecases/StatisticsUseCase;", "Lio/streamlayer/sdk/repository/sports/events/SportEventsRepo;", "eventsRepo", "Lio/streamlayer/sdk/repository/sports/events/SportEventsRepo;", "Lio/streamlayer/common/session/Session;", "session", "Lio/streamlayer/common/session/Session;", "summaryData", "<init>", "(Lio/streamlayer/sdk/repository/sports/events/SportEventsRepo;Lio/streamlayer/sdk/repository/sports/basketball/BasketballRepo;Lio/streamlayer/common/session/Session;Lio/streamlayer/common/scheduler/SchedulerProvider;Lio/streamlayer/sdk/usecases/StatisticsUseCase;)V", "sdk_originalRelease"})
public final class BasketballStatisticsViewModel
extends BaseViewModel {
    @NotNull
    private final SportEventsRepo eventsRepo;
    @NotNull
    private final BasketballRepo basketballRepo;
    @NotNull
    private final Session session;
    @NotNull
    private final SchedulerProvider schedulers;
    @NotNull
    private final StatisticsUseCase uc;
    @Nullable
    private String eventLeague;
    @NotNull
    private final MutableLiveData<ResourceState<EventSummaryResponseData>> _summaryData;
    @NotNull
    private final LiveData<ResourceState<EventSummaryResponseData>> summaryData;
    @NotNull
    private final MutableLiveData<ResourceState<BasketballBoxScore>> _boxScoreData;
    @NotNull
    private final LiveData<ResourceState<BasketballBoxScore>> boxScoreData;
    private boolean boxScoreHomeSelected;
    @NotNull
    private final MutableLiveData<ResourceState<GroupedBasketballStandings>> _standings;
    @NotNull
    private final LiveData<ResourceState<GroupedBasketballStandings>> standings;
    private boolean easternStandingsSelected;
    @NotNull
    private final MutableLiveData<ResourceState<List<PlayByPlayStatistics>>> _playByPlayData;
    @NotNull
    private final LiveData<ResourceState<List<PlayByPlayStatistics>>> playByPlayData;
    private boolean playByPlayAllPlaysFilter;
    @NotNull
    private final MutableLiveData<ResourceState<List<EventScheduleData>>> _scheduleData;
    @NotNull
    private final LiveData<ResourceState<List<EventScheduleData>>> scheduleData;
    @Nullable
    private Disposable scheduleDisposable;
    @NotNull
    private final MutableLiveData<ResourceState<List<String>>> _scheduleDates;
    @NotNull
    private final LiveData<ResourceState<List<String>>> scheduleDates;
    public String selectedDate;

    @Inject
    public BasketballStatisticsViewModel(@NotNull SportEventsRepo object, @NotNull BasketballRepo basketballRepo, @NotNull Session session, @NotNull SchedulerProvider schedulerProvider, @NotNull StatisticsUseCase statisticsUseCase) {
        MutableLiveData mutableLiveData;
        MutableLiveData mutableLiveData2;
        MutableLiveData mutableLiveData3;
        MutableLiveData mutableLiveData4;
        MutableLiveData mutableLiveData5;
        MutableLiveData mutableLiveData6;
        Intrinsics.checkNotNullParameter((Object)object, (String)"eventsRepo");
        Intrinsics.checkNotNullParameter((Object)basketballRepo, (String)"basketballRepo");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)schedulerProvider, (String)"schedulers");
        Intrinsics.checkNotNullParameter((Object)statisticsUseCase, (String)"uc");
        super(schedulerProvider);
        this.eventsRepo = object;
        this.basketballRepo = basketballRepo;
        this.session = session;
        this.schedulers = schedulerProvider;
        this.uc = statisticsUseCase;
        object = mutableLiveData6;
        super();
        this._summaryData = object;
        object = Transformations.distinctUntilChanged((LiveData)mutableLiveData6);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Transformations.distinctUntilChanged(this)");
        this.summaryData = object;
        object = mutableLiveData5;
        super();
        this._boxScoreData = object;
        object = Transformations.distinctUntilChanged((LiveData)mutableLiveData5);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Transformations.distinctUntilChanged(this)");
        this.boxScoreData = object;
        object = mutableLiveData4;
        super();
        this._standings = object;
        object = Transformations.distinctUntilChanged((LiveData)mutableLiveData4);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Transformations.distinctUntilChanged(this)");
        this.standings = object;
        this.easternStandingsSelected = true;
        object = mutableLiveData3;
        super();
        this._playByPlayData = object;
        object = Transformations.distinctUntilChanged((LiveData)mutableLiveData3);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Transformations.distinctUntilChanged(this)");
        this.playByPlayData = object;
        this.playByPlayAllPlaysFilter = true;
        object = mutableLiveData2;
        super();
        this._scheduleData = object;
        object = Transformations.distinctUntilChanged((LiveData)mutableLiveData2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Transformations.distinctUntilChanged(this)");
        this.scheduleData = object;
        object = mutableLiveData;
        super();
        this._scheduleDates = object;
        object = Transformations.distinctUntilChanged((LiveData)mutableLiveData);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Transformations.distinctUntilChanged(this)");
        this.scheduleDates = object;
        object = session.getCurrentEventId();
        if (object != null) {
            BasketballStatisticsViewModel basketballStatisticsViewModel = this;
            long l = ((Number)object).longValue();
            basketballStatisticsViewModel.getSummaryData(l);
            basketballStatisticsViewModel.getBoxScoreData(l);
            basketballStatisticsViewModel.getPlayByPlayData(l);
            String string2 = basketballStatisticsViewModel.eventLeague;
            if (string2 != null) {
                this.getStandings(string2);
            }
            string2 = this.eventLeague;
            if (string2 != null) {
                this.getDates(string2);
            }
            string2 = this.eventLeague;
            if (string2 != null) {
                this.getScheduleData(string2);
            }
        }
    }

    private final void getSummaryData(long l) {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, l, null){
            int label;
            final /* synthetic */ BasketballStatisticsViewModel this$0;
            final /* synthetic */ long $id;
            {
                this.this$0 = basketballStatisticsViewModel;
                this.$id = l;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2;
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    ResultKt.throwOnFailure((Object)object2);
                } else {
                    ResultKt.throwOnFailure((Object)object2);
                    this.label = 1;
                    object2 = FlowKt.first(BasketballStatisticsViewModel.access$getEventsRepo$p(this.this$0).getEventSummaryResponseData(this.$id), (Continuation)this);
                    if (object2 == object3) {
                        return object3;
                    }
                }
                BasketballStatisticsViewModel basketballStatisticsViewModel = this.this$0;
                ResourceState resourceState = (ResourceState)object2;
                BasketballStatisticsViewModel.access$get_summaryData$p(basketballStatisticsViewModel).postValue((Object)resourceState);
                object2 = (EventSummaryResponseData)resourceState.getData();
                if (object2 == null) return Unit.INSTANCE;
                object2 = ((EventSummaryResponseData)object2).getEventSummary().getLeague();
                if (Intrinsics.areEqual((Object)BasketballStatisticsViewModel.access$getEventLeague$p(basketballStatisticsViewModel), (Object)object2)) return Unit.INSTANCE;
                BasketballStatisticsViewModel basketballStatisticsViewModel2 = basketballStatisticsViewModel;
                BasketballStatisticsViewModel.access$setEventLeague$p(basketballStatisticsViewModel2, (String)object2);
                BasketballStatisticsViewModel.access$getStandings(basketballStatisticsViewModel2, (String)object2);
                BasketballStatisticsViewModel.access$getDates(basketballStatisticsViewModel2, (String)object2);
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                getSummaryData.1 v0 = object2;
                Object object2 = v0.this$0;
                long l = v0.$id;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)function22, (int)3, null);
    }

    private final void getBoxScoreData(long l) {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, l, null){
            Object L$0;
            int label;
            final /* synthetic */ BasketballStatisticsViewModel this$0;
            final /* synthetic */ long $id;
            {
                this.this$0 = basketballStatisticsViewModel;
                this.$id = l;
                super(2, continuation);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                void var0_4;
                void var1_8;
                void var1_5;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    MutableLiveData mutableLiveData = (MutableLiveData)this.L$0;
                    ResultKt.throwOnFailure((Object)var1_5);
                    MutableLiveData mutableLiveData2 = mutableLiveData;
                    void var0_2 = var1_5;
                } else {
                    getBoxScoreData.1 v0 = this;
                    ResultKt.throwOnFailure((Object)var1_5);
                    MutableLiveData mutableLiveData = BasketballStatisticsViewModel.access$get_boxScoreData$p(v0.this$0);
                    this.L$0 = mutableLiveData;
                    this.label = 1;
                    Object object3 = FlowKt.first(BasketballStatisticsViewModel.access$getBasketballRepo$p(v0.this$0).getBasketballBoxScore(this.$id), (Continuation)this);
                    if (object3 == object2) {
                        return object2;
                    }
                }
                var1_8.postValue((Object)var0_4);
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                getBoxScoreData.1 v0 = object2;
                Object object2 = v0.this$0;
                long l = v0.$id;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)function22, (int)3, null);
    }

    private final void getPlayByPlayData(long l) {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, l, null){
            Object L$0;
            int label;
            final /* synthetic */ BasketballStatisticsViewModel this$0;
            final /* synthetic */ long $id;
            {
                this.this$0 = basketballStatisticsViewModel;
                this.$id = l;
                super(2, continuation);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                void var0_4;
                void var1_8;
                void var1_5;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    MutableLiveData mutableLiveData = (MutableLiveData)this.L$0;
                    ResultKt.throwOnFailure((Object)var1_5);
                    MutableLiveData mutableLiveData2 = mutableLiveData;
                    void var0_2 = var1_5;
                } else {
                    getPlayByPlayData.1 v0 = this;
                    ResultKt.throwOnFailure((Object)var1_5);
                    MutableLiveData mutableLiveData = BasketballStatisticsViewModel.access$get_playByPlayData$p(v0.this$0);
                    this.L$0 = mutableLiveData;
                    this.label = 1;
                    Object object3 = FlowKt.first(BasketballStatisticsViewModel.access$getUc$p(v0.this$0).fetchPlayByPlay(this.$id, EventType.Soccer), (Continuation)this);
                    if (object3 == object2) {
                        return object2;
                    }
                }
                var1_8.postValue((Object)var0_4);
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                getPlayByPlayData.1 v0 = object2;
                Object object2 = v0.this$0;
                long l = v0.$id;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)function22, (int)3, null);
    }

    private final void getStandings(String string2) {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, string2, null){
            Object L$0;
            int label;
            final /* synthetic */ BasketballStatisticsViewModel this$0;
            final /* synthetic */ String $league;
            {
                this.this$0 = basketballStatisticsViewModel;
                this.$league = string2;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2;
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    object3 = (MutableLiveData)this.L$0;
                    ResultKt.throwOnFailure((Object)object);
                    Object object4 = object;
                    object = object3;
                    object2 = object4;
                } else {
                    getStandings.1 v1 = this;
                    ResultKt.throwOnFailure((Object)object);
                    this.L$0 = object = BasketballStatisticsViewModel.access$get_standings$p(v1.this$0);
                    this.label = 1;
                    object2 = FlowKt.first(BasketballStatisticsViewModel.access$getBasketballRepo$p(v1.this$0).getBasketballStandings(this.$league), (Continuation)this);
                    if (object2 == object3) {
                        return object3;
                    }
                }
                object.postValue(ResourceStateKt.mapValue((ResourceState)object2, new Function1<BasketballStandings, GroupedBasketballStandings>(this.this$0){
                    final /* synthetic */ BasketballStatisticsViewModel this$0;
                    {
                        this.this$0 = basketballStatisticsViewModel;
                        super(1);
                    }

                    @Nullable
                    public final GroupedBasketballStandings invoke(@Nullable BasketballStandings basketballStandings) {
                        return basketballStandings == null ? null : BasketballStatisticsViewModel.access$groupStandings(this.this$0, basketballStandings);
                    }
                }));
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                getStandings.1 v0 = object2;
                Object object2 = v0.this$0;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)function22, (int)3, null);
    }

    private final GroupedBasketballStandings groupStandings(BasketballStandings object) {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3 = arrayList2;
        arrayList2 = new ArrayList();
        for (Object t : ((BasketballStandings)object).getStandings()) {
            if (!Intrinsics.areEqual((Object)((BasketballTeamStanding)t).getConference(), (Object)BasketballConference.Eastern.name())) continue;
            arrayList3.add(t);
        }
        List<BasketballTeamStanding> list = ((BasketballStandings)object).getStandings();
        object = arrayList;
        arrayList = new ArrayList();
        for (Object t : list) {
            if (!Intrinsics.areEqual((Object)((BasketballTeamStanding)t).getConference(), (Object)BasketballConference.Western.name())) continue;
            object.add(t);
        }
        return new GroupedBasketballStandings(arrayList3, (List<BasketballTeamStanding>)object);
    }

    private final void getScheduleData(String string2) {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, string2, null){
            Object L$0;
            int label;
            final /* synthetic */ BasketballStatisticsViewModel this$0;
            final /* synthetic */ String $league;
            {
                this.this$0 = basketballStatisticsViewModel;
                this.$league = string2;
                super(2, continuation);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                void var0_4;
                void var1_8;
                void var1_5;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    MutableLiveData mutableLiveData = (MutableLiveData)this.L$0;
                    ResultKt.throwOnFailure((Object)var1_5);
                    MutableLiveData mutableLiveData2 = mutableLiveData;
                    void var0_2 = var1_5;
                } else {
                    getScheduleData.1 v0 = this;
                    ResultKt.throwOnFailure((Object)var1_5);
                    MutableLiveData mutableLiveData = BasketballStatisticsViewModel.access$get_scheduleData$p(v0.this$0);
                    getScheduleData.1 v1 = this;
                    String string2 = v1.this$0.getSelectedDate();
                    String string3 = v1.$league;
                    this.L$0 = mutableLiveData;
                    this.label = 1;
                    Object object3 = FlowKt.first(BasketballStatisticsViewModel.access$getEventsRepo$p(v0.this$0).getEventSchedules(string2, string3, EventType.Baseball), (Continuation)this);
                    if (object3 == object2) {
                        return object2;
                    }
                }
                var1_8.postValue((Object)var0_4);
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                getScheduleData.1 v0 = object2;
                Object object2 = v0.this$0;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)function22, (int)3, null);
    }

    private final void getDates(String string2) {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, string2, null){
            int label;
            final /* synthetic */ BasketballStatisticsViewModel this$0;
            final /* synthetic */ String $league;
            {
                this.this$0 = basketballStatisticsViewModel;
                this.$league = string2;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    ResultKt.throwOnFailure((Object)object);
                } else {
                    ResultKt.throwOnFailure((Object)object);
                    this.label = 1;
                    object = FlowKt.first(BasketballStatisticsViewModel.access$getEventsRepo$p(this.this$0).fetchSchedulesDates(this.$league), (Continuation)this);
                    if (object == object2) {
                        return object2;
                    }
                }
                getDates.1 v0 = this;
                object = ResourceStateKt.mapValue((ResourceState)object, getDates.res.1.INSTANCE);
                BasketballStatisticsViewModel.access$get_scheduleDates$p(v0.this$0).postValue(object);
                object2 = v0.this$0;
                if (((BasketballStatisticsViewModel)((Object)object2)).selectedDate == null) {
                    if ((object = (object = (List)((ResourceState)object).getData()) == null ? null : (String)CollectionsKt.firstOrNull((List)object)) == null) {
                        object = DateUtil.INSTANCE.toDateString(new Date());
                    }
                    ((BasketballStatisticsViewModel)((Object)object2)).setSelectedDate((String)object);
                }
                BasketballStatisticsViewModel.access$getScheduleData(this.this$0, this.$league);
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                getDates.1 v0 = object2;
                Object object2 = v0.this$0;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)function22, (int)3, null);
    }

    public static final /* synthetic */ SportEventsRepo access$getEventsRepo$p(BasketballStatisticsViewModel basketballStatisticsViewModel) {
        return basketballStatisticsViewModel.eventsRepo;
    }

    public static final /* synthetic */ String access$getEventLeague$p(BasketballStatisticsViewModel basketballStatisticsViewModel) {
        return basketballStatisticsViewModel.eventLeague;
    }

    public static final /* synthetic */ void access$setEventLeague$p(BasketballStatisticsViewModel basketballStatisticsViewModel, String string2) {
        basketballStatisticsViewModel.eventLeague = string2;
    }

    public static final /* synthetic */ void access$getStandings(BasketballStatisticsViewModel basketballStatisticsViewModel, String string2) {
        basketballStatisticsViewModel.getStandings(string2);
    }

    public static final /* synthetic */ void access$getDates(BasketballStatisticsViewModel basketballStatisticsViewModel, String string2) {
        basketballStatisticsViewModel.getDates(string2);
    }

    public static final /* synthetic */ MutableLiveData access$get_summaryData$p(BasketballStatisticsViewModel basketballStatisticsViewModel) {
        return basketballStatisticsViewModel._summaryData;
    }

    public static final /* synthetic */ MutableLiveData access$get_boxScoreData$p(BasketballStatisticsViewModel basketballStatisticsViewModel) {
        return basketballStatisticsViewModel._boxScoreData;
    }

    public static final /* synthetic */ BasketballRepo access$getBasketballRepo$p(BasketballStatisticsViewModel basketballStatisticsViewModel) {
        return basketballStatisticsViewModel.basketballRepo;
    }

    public static final /* synthetic */ MutableLiveData access$get_playByPlayData$p(BasketballStatisticsViewModel basketballStatisticsViewModel) {
        return basketballStatisticsViewModel._playByPlayData;
    }

    public static final /* synthetic */ StatisticsUseCase access$getUc$p(BasketballStatisticsViewModel basketballStatisticsViewModel) {
        return basketballStatisticsViewModel.uc;
    }

    public static final /* synthetic */ MutableLiveData access$get_standings$p(BasketballStatisticsViewModel basketballStatisticsViewModel) {
        return basketballStatisticsViewModel._standings;
    }

    public static final /* synthetic */ GroupedBasketballStandings access$groupStandings(BasketballStatisticsViewModel basketballStatisticsViewModel, BasketballStandings basketballStandings) {
        return basketballStatisticsViewModel.groupStandings(basketballStandings);
    }

    public static final /* synthetic */ MutableLiveData access$get_scheduleData$p(BasketballStatisticsViewModel basketballStatisticsViewModel) {
        return basketballStatisticsViewModel._scheduleData;
    }

    public static final /* synthetic */ MutableLiveData access$get_scheduleDates$p(BasketballStatisticsViewModel basketballStatisticsViewModel) {
        return basketballStatisticsViewModel._scheduleDates;
    }

    public static final /* synthetic */ void access$getScheduleData(BasketballStatisticsViewModel basketballStatisticsViewModel, String string2) {
        basketballStatisticsViewModel.getScheduleData(string2);
    }

    @NotNull
    public final LiveData<ResourceState<EventSummaryResponseData>> getSummaryData() {
        return this.summaryData;
    }

    @NotNull
    public final LiveData<ResourceState<BasketballBoxScore>> getBoxScoreData() {
        return this.boxScoreData;
    }

    public final boolean getBoxScoreHomeSelected() {
        return this.boxScoreHomeSelected;
    }

    public final void setBoxScoreHomeSelected(boolean bl) {
        this.boxScoreHomeSelected = bl;
    }

    @NotNull
    public final LiveData<ResourceState<GroupedBasketballStandings>> getStandings() {
        return this.standings;
    }

    public final boolean getEasternStandingsSelected() {
        return this.easternStandingsSelected;
    }

    public final void setEasternStandingsSelected(boolean bl) {
        this.easternStandingsSelected = bl;
    }

    @NotNull
    public final LiveData<ResourceState<List<PlayByPlayStatistics>>> getPlayByPlayData() {
        return this.playByPlayData;
    }

    public final boolean getPlayByPlayAllPlaysFilter() {
        return this.playByPlayAllPlaysFilter;
    }

    public final void setPlayByPlayAllPlaysFilter(boolean bl) {
        this.playByPlayAllPlaysFilter = bl;
    }

    @NotNull
    public final LiveData<ResourceState<List<EventScheduleData>>> getScheduleData() {
        return this.scheduleData;
    }

    @NotNull
    public final LiveData<ResourceState<List<String>>> getScheduleDates() {
        return this.scheduleDates;
    }

    @NotNull
    public final String getSelectedDate() {
        Object object = object.selectedDate;
        if (object != null) {
            return object;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"selectedDate");
        throw null;
    }

    public final void setSelectedDate(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.selectedDate = string2;
    }

    public final void getSchedule(@NotNull String string2) {
        BasketballStatisticsViewModel basketballStatisticsViewModel = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"date");
        basketballStatisticsViewModel.setSelectedDate(string2);
        string2 = basketballStatisticsViewModel.eventLeague;
        if (string2 != null) {
            this.getScheduleData(string2);
        }
    }
}

