/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.common.model;

import com.streamlayer.sports.events.ScheduleResponseData;
import io.streamlayer.sdk.model.sports.EventStatus;
import io.streamlayer.sdk.model.sports.EventsKt;
import io.streamlayer.sdk.statistics.common.model.GameStatus;
import io.streamlayer.sdk.statistics.common.model.ScoreGame;
import io.streamlayer.sdk.statistics.common.model.ScoreGameStatus;
import io.streamlayer.sdk.statistics.common.model.ScoresScheduleDate;
import io.streamlayer.utils.DateUtil;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0017\u0010\u0007\u001a\u00020\u0006*\u00060\u0004j\u0002`\u0005H\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0015\u0010\u000b\u001a\u0004\u0018\u00010\n*\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ljava/util/Date;", "Lio/streamlayer/sdk/statistics/common/model/ScoresScheduleDate;", "toScoresScheduleDate", "(Ljava/util/Date;)Lio/streamlayer/sdk/statistics/common/model/ScoresScheduleDate;", "Lcom/streamlayer/sports/events/ScheduleResponseData;", "Lio/streamlayer/sdk/model/sports/EventScheduleDataProto;", "Lio/streamlayer/sdk/statistics/common/model/ScoreGame;", "toDomainScore", "(Lcom/streamlayer/sports/events/ScheduleResponseData;)Lio/streamlayer/sdk/statistics/common/model/ScoreGame;", "Lio/streamlayer/sdk/model/sports/EventStatus;", "Lio/streamlayer/sdk/statistics/common/model/ScoreGameStatus;", "toGameStatus", "(Lio/streamlayer/sdk/model/sports/EventStatus;)Lio/streamlayer/sdk/statistics/common/model/ScoreGameStatus;", "sdk_originalRelease"})
public final class ModelsKt {
    @NotNull
    public static final ScoresScheduleDate toScoresScheduleDate(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"<this>");
        String string2 = ScoresScheduleDate.Companion.getScoresGameSDF().format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ScoresScheduleDate.scoresGameSDF.format(this)");
        Object object = StringsKt.split$default((CharSequence)string2, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
        List list = object;
        object = (String)list.get(0);
        String string3 = (String)list.get(1);
        long l = date.getTime();
        Object object2 = object;
        object = DateUtil.INSTANCE.getRequestDateFormat().format(date).toString();
        return new ScoresScheduleDate((String)object2, string3, l, (String)object, date, false);
    }

    @NotNull
    public static final ScoreGame toDomainScore(@NotNull ScheduleResponseData object) {
        ScheduleResponseData scheduleResponseData = object;
        Intrinsics.checkNotNullParameter((Object)scheduleResponseData, (String)"<this>");
        String string2 = scheduleResponseData.getAttributes().getSummary().getLeague();
        String string3 = scheduleResponseData.getAttributes().getSummary().getHomeTeam().getName();
        String string4 = scheduleResponseData.getAttributes().getSummary().getHomeTeam().getLogo();
        String string5 = scheduleResponseData.getAttributes().getSummary().getAwayTeam().getName();
        String string6 = scheduleResponseData.getAttributes().getSummary().getAwayTeam().getLogo();
        int n = scheduleResponseData.getAttributes().getSummary().getScoreHome();
        int n2 = scheduleResponseData.getAttributes().getSummary().getScoreAway();
        com.streamlayer.sports.common.EventStatus eventStatus = scheduleResponseData.getAttributes().getSummary().getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)eventStatus, (String)"attributes.summary.status");
        ScoreGameStatus scoreGameStatus = ModelsKt.toGameStatus(EventsKt.toDomain(eventStatus));
        String string7 = null;
        DateUtil dateUtil = DateUtil.INSTANCE;
        String string8 = object.getAttributes().getSummary().getScheduled();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"attributes.summary.scheduled");
        object = dateUtil.fromString(string8);
        if (object == null) {
            Date date;
            object = date;
            date = new Date(0L);
        }
        object = dateUtil.toShort((Date)object);
        GameStatus gameStatus = new GameStatus(scoreGameStatus, string7, (String)object);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"league");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"name");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"logo");
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"logo");
        return new ScoreGame(string2, string3, string5, string4, string6, n, n2, gameStatus);
    }

    private static final ScoreGameStatus toGameStatus(EventStatus eventStatus) {
        ScoreGameStatus scoreGameStatus;
        switch (WhenMappings.$EnumSwitchMapping$0[eventStatus.ordinal()]) {
            default: {
                throw new NoWhenBranchMatchedException();
            }
            case 8: {
                scoreGameStatus = null;
                break;
            }
            case 6: 
            case 7: {
                scoreGameStatus = ScoreGameStatus.PASSED;
                break;
            }
            case 4: 
            case 5: {
                scoreGameStatus = ScoreGameStatus.INCOMING;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                scoreGameStatus = ScoreGameStatus.LIVE;
            }
        }
        return scoreGameStatus;
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EventStatus.values().length];
            nArray[EventStatus.Shootouts.ordinal()] = 1;
            nArray[EventStatus.Overtime.ordinal()] = 2;
            nArray[EventStatus.Active.ordinal()] = 3;
            nArray[EventStatus.Break.ordinal()] = 4;
            nArray[EventStatus.Pregame.ordinal()] = 5;
            nArray[EventStatus.Postgame.ordinal()] = 6;
            nArray[EventStatus.Cancelled.ordinal()] = 7;
            nArray[EventStatus.Unset.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

