/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.extensions;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.SystemClock;
import android.widget.Chronometer;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.utils.SLRLog;
import java.io.File;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0013\u0010\u0005\u001a\u00020\u0001*\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0013\u0010\b\u001a\u00020\u0001*\u00020\u0007H\u0000\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0013\u0010\u000b\u001a\u00020\u0001*\u00020\nH\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u001d\u0010\u0011\u001a\u00020\u0010*\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a/\u0010\u0017\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u00028\u00000\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a!\u0010\u0017\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0019\u001a9\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a\"\u0004\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u00028\u00000\u001a2\u0006\u0010\u001b\u001a\u00020\u00012\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a\u0013\u0010 \u001a\u00020\u001f*\u00020\nH\u0000\u00a2\u0006\u0004\b \u0010!\u00a8\u0006\""}, d2={"", "", "toHex", "([B)Ljava/lang/String;", "Ljava/io/File;", "md5", "(Ljava/io/File;)Ljava/lang/String;", "", "toOrdinalString", "(I)Ljava/lang/String;", "Landroid/content/Context;", "getAppName", "(Landroid/content/Context;)Ljava/lang/String;", "Landroid/widget/Chronometer;", "", "startedAt", "", "startTimer", "(Landroid/widget/Chronometer;Ljava/lang/Long;)V", "T", "", "", "probabilities", "randomOrNull", "(Ljava/util/List;Ljava/util/List;)Ljava/lang/Object;", "(Ljava/util/List;)Ljava/lang/Object;", "Lkotlinx/coroutines/flow/Flow;", "tag", "message", "catchDefault", "(Lkotlinx/coroutines/flow/Flow;Ljava/lang/String;Ljava/lang/String;)Lkotlinx/coroutines/flow/Flow;", "", "isScreenPortrait", "(Landroid/content/Context;)Z", "sdk_originalRelease"})
public final class OtherExtensionsKt {
    @NotNull
    public static final String toHex(@NotNull byte[] object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        object = (Object)toHex.1.INSTANCE;
        return ArraysKt.joinToString$default((byte[])object, (CharSequence)"", null, null, (int)0, null, (Function1)object, (int)30, null);
    }

    @NotNull
    public static final String md5(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<this>");
        byte[] byArray = MessageDigest.getInstance("MD5").digest(FilesKt.readBytes((File)file));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bytes");
        return OtherExtensionsKt.toHex(byArray);
    }

    @NotNull
    public static final String toOrdinalString(int n) {
        String string2;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        stringArray[0] = "th";
        stringArray[1] = "st";
        stringArray[2] = "nd";
        stringArray[3] = "rd";
        stringArray[4] = "th";
        stringArray[5] = "th";
        stringArray[6] = "th";
        stringArray[7] = "th";
        stringArray[8] = "th";
        stringArray[9] = "th";
        switch (n % 100) {
            default: {
                string2 = n + stringArray2[n % 10];
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                string2 = String.format("%dth", Arrays.copyOf(new Object[]{n}, 1));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
            }
        }
        return string2;
    }

    @NotNull
    public static final String getAppName(@NotNull Context object) {
        Context context = object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"<this>");
        PackageManager packageManager = context.getPackageManager();
        try {
            Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"this.packageManager");
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(object.getPackageName(), 0);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"pm.getApplicationInfo(this.packageName, 0)");
            object = ((Object)packageManager.getApplicationLabel(applicationInfo)).toString();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = "";
        }
        return object;
    }

    public static final void startTimer(@NotNull Chronometer chronometer, @Nullable Long l) {
        long l2;
        Intrinsics.checkNotNullParameter((Object)chronometer, (String)"<this>");
        if (l == null) {
            l2 = 0L;
        } else {
            l2 = l;
            l2 = System.currentTimeMillis() - l2;
        }
        Chronometer chronometer2 = chronometer;
        chronometer2.setBase(SystemClock.elapsedRealtime() - l2);
        chronometer2.start();
    }

    @Nullable
    public static final <T> T randomOrNull(@NotNull List<? extends T> list, @NotNull List<Double> list2) {
        Intrinsics.checkNotNullParameter(list, (String)"<this>");
        Intrinsics.checkNotNullParameter(list2, (String)"probabilities");
        if (list.isEmpty()) {
            return null;
        }
        Iterator iterator = list2.iterator();
        if (iterator.hasNext()) {
            Object object = iterator.next();
            while (iterator.hasNext()) {
                double d = ((Number)iterator.next()).doubleValue();
                object = ((Number)object).doubleValue() + d;
            }
            double d = ((Number)object).doubleValue();
            d = Random.Default.nextDouble(d);
            double d2 = 0.0;
            int n = 0;
            for (Object t : list2) {
                double d3;
                int n2 = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                d2 += ((Number)t).doubleValue();
                if (d < d3) {
                    return list.get(n);
                }
                n = n2;
            }
            List<T> list3 = list;
            return list3.get(list3.size() - 1);
        }
        throw new UnsupportedOperationException("Empty collection can't be reduced.");
    }

    @Nullable
    public static final <T> T randomOrNull(@NotNull List<? extends T> list) {
        List<T> list2 = list;
        Intrinsics.checkNotNullParameter(list2, (String)"<this>");
        return (T)(list2.isEmpty() ? null : CollectionsKt.random(list, (Random)Random.Default));
    }

    @NotNull
    public static final <T> Flow<T> catchDefault(@NotNull Flow<? extends T> flow, @NotNull String string2, @Nullable String string3) {
        Intrinsics.checkNotNullParameter(flow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"tag");
        return FlowKt.catch(flow, (Function3)new Function3<FlowCollector<? super T>, Throwable, Continuation<? super Unit>, Object>(string2, string3, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ String $tag;
            final /* synthetic */ String $message;
            {
                this.$tag = string2;
                this.$message = string3;
                super(3, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.label == 0) {
                    ResultKt.throwOnFailure((Object)object);
                    object = (Throwable)object2.L$0;
                    catchDefault.1 v0 = object2;
                    Object object2 = v0.$tag;
                    SLRLog.INSTANCE.e((String)object2, v0.$message, (Throwable)object);
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super T> flowCollector, @NotNull Throwable throwable, @Nullable Continuation<? super Unit> continuation) {
                catchDefault.1 v0 = object;
                Object object = v0.$tag;
                new /* invalid duplicate definition of identical inner class */.L$0 = throwable;
                return new /* invalid duplicate definition of identical inner class */.invokeSuspend((Object)Unit.INSTANCE);
            }
        });
    }

    public static /* synthetic */ Flow catchDefault$default(Flow flow, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        return OtherExtensionsKt.catchDefault(flow, string2, string3);
    }

    public static final boolean isScreenPortrait(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"<this>");
        return context2.getResources().getConfiguration().orientation == 1;
    }
}

