/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.lite;

import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import io.streamlayer.common.eventbus.SLREventBus;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.routes.OverlayRoutesProvider;
import io.streamlayer.common.session.Session;
import io.streamlayer.sdk.StreamLayerEvents;
import io.streamlayer.sdk.model.advertising.AdvertisingData;
import io.streamlayer.sdk.model.advertising.AdvertisingImage;
import io.streamlayer.sdk.model.analytics.CommonCategory;
import io.streamlayer.sdk.model.analytics.CommonKind;
import io.streamlayer.sdk.model.analytics.InteractionActionType;
import io.streamlayer.sdk.model.analytics.InvitationCategory;
import io.streamlayer.sdk.model.analytics.NotificationKind;
import io.streamlayer.sdk.model.analytics.NotificationType;
import io.streamlayer.sdk.model.analytics.PermissionType;
import io.streamlayer.sdk.model.analytics.WaveCategory;
import io.streamlayer.sdk.repository.advertising.AdvertisingRepo;
import io.streamlayer.sdk.repository.analytics.AnalyticsRepo;
import io.streamlayer.sdk.usecases.NetworkConnectionUseCase;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B9\b\u0007\u0012\u0006\u0010G\u001a\u00020F\u0012\u0006\u0010>\u001a\u00020\u0002\u0012\u0006\u00107\u001a\u000206\u0012\u0006\u00104\u001a\u000203\u0012\u0006\u0010:\u001a\u000209\u0012\u0006\u0010J\u001a\u00020I\u00a2\u0006\u0004\bK\u0010LJ\u000f\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0006H\u0096\u0001\u00a2\u0006\u0004\b\b\u0010\tJ8\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0096\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J8\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0096\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0011J&\u0010\u0015\u001a\u00020\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u00132\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0096\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J0\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0018H\u0096\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u0003H\u0096\u0001\u00a2\u0006\u0004\b\u001b\u0010\u0005J\u0010\u0010\u001c\u001a\u00020\u0003H\u0096\u0001\u00a2\u0006\u0004\b\u001c\u0010\u0005J@\u0010!\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0096\u0001\u00a2\u0006\u0004\b!\u0010\"J \u0010%\u001a\u00020\u00032\u0006\u0010$\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\u0006H\u0096\u0001\u00a2\u0006\u0004\b%\u0010&J,\u0010'\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0096\u0001\u00a2\u0006\u0004\b'\u0010(J\u001a\u0010)\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0096\u0001\u00a2\u0006\u0004\b)\u0010*J,\u0010,\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010+H\u0096\u0001\u00a2\u0006\u0004\b,\u0010-R\u0019\u0010/\u001a\u00020.8\u0006@\u0006\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u0016\u00104\u001a\u0002038\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0016\u00107\u001a\u0002068\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0019\u0010:\u001a\u0002098\u0006@\u0006\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=R\u0016\u0010>\u001a\u00020\u00028\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u001f\u0010B\u001a\b\u0012\u0004\u0012\u00020A0@8\u0006@\u0006\u00a2\u0006\f\n\u0004\bB\u0010C\u001a\u0004\bD\u0010ER\u0016\u0010G\u001a\u00020F8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bG\u0010H\u00a8\u0006M"}, d2={"Lio/streamlayer/sdk/lite/StreamLayerLiteViewModel;", "Landroidx/lifecycle/ViewModel;", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "", "loadAdvertisingData", "()V", "Lio/streamlayer/sdk/model/analytics/CommonKind;", "kind", "triggerAuthenticationEvent", "(Lio/streamlayer/sdk/model/analytics/CommonKind;)V", "", "topicId", "", "participantsCount", "Lio/streamlayer/sdk/model/analytics/CommonCategory;", "category", "triggerCallEvent", "(Ljava/lang/String;Lio/streamlayer/sdk/model/analytics/CommonKind;Ljava/lang/Integer;Lio/streamlayer/sdk/model/analytics/CommonCategory;)V", "triggerConversationEvent", "Lio/streamlayer/sdk/model/analytics/InteractionActionType;", "actionType", "triggerInteractionEvent", "(Lio/streamlayer/sdk/model/analytics/InteractionActionType;Lio/streamlayer/sdk/model/analytics/CommonCategory;)V", "eventId", "Lio/streamlayer/sdk/model/analytics/InvitationCategory;", "triggerInvitationEvent", "(Lio/streamlayer/sdk/model/analytics/CommonKind;Ljava/lang/String;Lio/streamlayer/sdk/model/analytics/InvitationCategory;)V", "triggerLaunchButtonInitEvent", "triggerLaunchButtonTappedEvent", "Lio/streamlayer/sdk/model/analytics/NotificationType;", "type", "Lio/streamlayer/sdk/model/analytics/NotificationKind;", "commonKind", "triggerNotificationEvent", "(Lio/streamlayer/sdk/model/analytics/NotificationType;Lio/streamlayer/sdk/model/analytics/NotificationKind;Lio/streamlayer/sdk/model/analytics/CommonKind;Lio/streamlayer/sdk/model/analytics/CommonCategory;Ljava/lang/String;)V", "Lio/streamlayer/sdk/model/analytics/PermissionType;", "permission", "triggerPermissionEvent", "(Lio/streamlayer/sdk/model/analytics/PermissionType;Lio/streamlayer/sdk/model/analytics/CommonKind;)V", "triggerPollEvent", "(Ljava/lang/String;Lio/streamlayer/sdk/model/analytics/CommonKind;Lio/streamlayer/sdk/model/analytics/CommonCategory;)V", "triggerSessionHeartbeat", "(Ljava/lang/String;)V", "Lio/streamlayer/sdk/model/analytics/WaveCategory;", "triggerWaveEvent", "(Lio/streamlayer/sdk/model/analytics/CommonKind;Ljava/lang/String;Lio/streamlayer/sdk/model/analytics/WaveCategory;)V", "Ljava/util/concurrent/atomic/AtomicBoolean;", "overlayShown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getOverlayShown", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "Lio/streamlayer/sdk/usecases/NetworkConnectionUseCase;", "networkConnectionUseCase", "Lio/streamlayer/sdk/usecases/NetworkConnectionUseCase;", "Lio/streamlayer/common/session/Session;", "session", "Lio/streamlayer/common/session/Session;", "Lio/streamlayer/common/routes/OverlayRoutesProvider;", "overlayRoutesProvider", "Lio/streamlayer/common/routes/OverlayRoutesProvider;", "getOverlayRoutesProvider", "()Lio/streamlayer/common/routes/OverlayRoutesProvider;", "analyticsRepo", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "Lkotlinx/coroutines/flow/Flow;", "", "networkConnection", "Lkotlinx/coroutines/flow/Flow;", "getNetworkConnection", "()Lkotlinx/coroutines/flow/Flow;", "Lio/streamlayer/sdk/repository/advertising/AdvertisingRepo;", "advertisingRepo", "Lio/streamlayer/sdk/repository/advertising/AdvertisingRepo;", "Lio/streamlayer/common/eventbus/SLREventBus;", "eventBus", "<init>", "(Lio/streamlayer/sdk/repository/advertising/AdvertisingRepo;Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;Lio/streamlayer/common/session/Session;Lio/streamlayer/sdk/usecases/NetworkConnectionUseCase;Lio/streamlayer/common/routes/OverlayRoutesProvider;Lio/streamlayer/common/eventbus/SLREventBus;)V", "sdk_originalRelease"})
public final class StreamLayerLiteViewModel
extends ViewModel
implements AnalyticsRepo {
    @NotNull
    private final AdvertisingRepo advertisingRepo;
    @NotNull
    private final AnalyticsRepo analyticsRepo;
    @NotNull
    private final Session session;
    @NotNull
    private final NetworkConnectionUseCase networkConnectionUseCase;
    @NotNull
    private final OverlayRoutesProvider overlayRoutesProvider;
    @NotNull
    private final Flow<Boolean> networkConnection;
    @NotNull
    private final AtomicBoolean overlayShown;

    @Inject
    public StreamLayerLiteViewModel(@NotNull AdvertisingRepo advertisingRepo, @NotNull AnalyticsRepo analyticsRepo, @NotNull Session session, @NotNull NetworkConnectionUseCase networkConnectionUseCase, @NotNull OverlayRoutesProvider overlayRoutesProvider, @NotNull SLREventBus sLREventBus) {
        StreamLayerLiteViewModel streamLayerLiteViewModel = this;
        Intrinsics.checkNotNullParameter((Object)advertisingRepo, (String)"advertisingRepo");
        Intrinsics.checkNotNullParameter((Object)analyticsRepo, (String)"analyticsRepo");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)networkConnectionUseCase, (String)"networkConnectionUseCase");
        Intrinsics.checkNotNullParameter((Object)overlayRoutesProvider, (String)"overlayRoutesProvider");
        Intrinsics.checkNotNullParameter((Object)sLREventBus, (String)"eventBus");
        this.advertisingRepo = advertisingRepo;
        this.analyticsRepo = analyticsRepo;
        this.session = session;
        this.networkConnectionUseCase = networkConnectionUseCase;
        this.overlayRoutesProvider = overlayRoutesProvider;
        streamLayerLiteViewModel.networkConnection = networkConnectionUseCase.getState();
        streamLayerLiteViewModel.overlayShown = new AtomicBoolean(false);
        if (!session.isLoggedIn()) {
            sLREventBus.produceEvent(StreamLayerEvents.LoginRequiredLiteOverlay.INSTANCE);
        }
        this.loadAdvertisingData();
    }

    private final void loadAdvertisingData() {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ StreamLayerLiteViewModel this$0;
            {
                this.this$0 = streamLayerLiteViewModel;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2;
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    ResultKt.throwOnFailure((Object)object2);
                } else {
                    ResultKt.throwOnFailure((Object)object2);
                    this.label = 1;
                    object2 = FlowKt.firstOrNull(StreamLayerLiteViewModel.access$getAdvertisingRepo$p(this.this$0).fetchAdvertisingData(), (Continuation)this);
                    if (object2 == object3) {
                        return object3;
                    }
                }
                object2 = (ResourceState)object2;
                if (object2 == null || (object2 = (List)((ResourceState)object2).getData()) == null) return Unit.INSTANCE;
                StreamLayerLiteViewModel streamLayerLiteViewModel = this.this$0;
                if ((object2 = (AdvertisingData)CollectionsKt.firstOrNull((List)object2)) == null || (object2 = (AdvertisingImage)CollectionsKt.randomOrNull(((AdvertisingData)object2).getImages(), (Random)Random.Default)) == null || (object2 = ((AdvertisingImage)object2).getFileUrl()) == null) return Unit.INSTANCE;
                StreamLayerLiteViewModel.access$getSession$p(streamLayerLiteViewModel).setCurrentSponsorAdUrl((String)object2);
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)function22, (int)3, null);
    }

    public static final /* synthetic */ AdvertisingRepo access$getAdvertisingRepo$p(StreamLayerLiteViewModel streamLayerLiteViewModel) {
        return streamLayerLiteViewModel.advertisingRepo;
    }

    public static final /* synthetic */ Session access$getSession$p(StreamLayerLiteViewModel streamLayerLiteViewModel) {
        return streamLayerLiteViewModel.session;
    }

    @NotNull
    public final OverlayRoutesProvider getOverlayRoutesProvider() {
        return this.overlayRoutesProvider;
    }

    @Override
    public void triggerAuthenticationEvent(@NotNull CommonKind commonKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        this.analyticsRepo.triggerAuthenticationEvent(commonKind);
    }

    @Override
    public void triggerCallEvent(@NotNull String string2, @NotNull CommonKind commonKind, @Nullable Integer n, @Nullable CommonCategory commonCategory) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        this.analyticsRepo.triggerCallEvent(string2, commonKind, n, commonCategory);
    }

    @Override
    public void triggerConversationEvent(@NotNull String string2, @NotNull CommonKind commonKind, @Nullable Integer n, @Nullable CommonCategory commonCategory) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        this.analyticsRepo.triggerConversationEvent(string2, commonKind, n, commonCategory);
    }

    @Override
    public void triggerInteractionEvent(@NotNull InteractionActionType interactionActionType, @Nullable CommonCategory commonCategory) {
        Intrinsics.checkNotNullParameter((Object)((Object)interactionActionType), (String)"actionType");
        this.analyticsRepo.triggerInteractionEvent(interactionActionType, commonCategory);
    }

    @Override
    public void triggerInvitationEvent(@NotNull CommonKind commonKind, @Nullable String string2, @Nullable InvitationCategory invitationCategory) {
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        this.analyticsRepo.triggerInvitationEvent(commonKind, string2, invitationCategory);
    }

    @Override
    public void triggerLaunchButtonInitEvent() {
        this.analyticsRepo.triggerLaunchButtonInitEvent();
    }

    @Override
    public void triggerLaunchButtonTappedEvent() {
        this.analyticsRepo.triggerLaunchButtonTappedEvent();
    }

    @Override
    public void triggerNotificationEvent(@NotNull NotificationType notificationType, @NotNull NotificationKind notificationKind, @NotNull CommonKind commonKind, @Nullable CommonCategory commonCategory, @Nullable String string2) {
        Intrinsics.checkNotNullParameter((Object)((Object)notificationType), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)notificationKind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"commonKind");
        this.analyticsRepo.triggerNotificationEvent(notificationType, notificationKind, commonKind, commonCategory, string2);
    }

    @Override
    public void triggerPermissionEvent(@NotNull PermissionType permissionType, @NotNull CommonKind commonKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)permissionType), (String)"permission");
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        this.analyticsRepo.triggerPermissionEvent(permissionType, commonKind);
    }

    @Override
    public void triggerPollEvent(@NotNull String string2, @NotNull CommonKind commonKind, @Nullable CommonCategory commonCategory) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"commonKind");
        this.analyticsRepo.triggerPollEvent(string2, commonKind, commonCategory);
    }

    @Override
    public void triggerSessionHeartbeat(@Nullable String string2) {
        this.analyticsRepo.triggerSessionHeartbeat(string2);
    }

    @Override
    public void triggerWaveEvent(@NotNull CommonKind commonKind, @NotNull String string2, @Nullable WaveCategory waveCategory) {
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"eventId");
        this.analyticsRepo.triggerWaveEvent(commonKind, string2, waveCategory);
    }

    @NotNull
    public final Flow<Boolean> getNetworkConnection() {
        return this.networkConnection;
    }

    @NotNull
    public final AtomicBoolean getOverlayShown() {
        return this.overlayShown;
    }
}

