/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.notifications;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import androidx.recyclerview.widget.RecyclerView;
import com.yuyakaido.android.cardstackview.CardStackLayoutManager;
import com.yuyakaido.android.cardstackview.CardStackListener;
import com.yuyakaido.android.cardstackview.CardStackView;
import com.yuyakaido.android.cardstackview.Direction;
import com.yuyakaido.android.cardstackview.Duration;
import com.yuyakaido.android.cardstackview.StackFrom;
import com.yuyakaido.android.cardstackview.SwipeAnimationSetting;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.main.notifications.NotificationsAdapter;
import io.streamlayer.sdk.main.notifications.NotificationsView;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.predictions.view.ExtensionsKt;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000o\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006*\u00017\b\u0000\u0018\u00002\u00020\u0001:\u0001HB'\b\u0007\u0012\u0006\u0010B\u001a\u00020A\u0012\n\b\u0002\u0010D\u001a\u0004\u0018\u00010C\u0012\b\b\u0002\u0010E\u001a\u00020\u0018\u00a2\u0006\u0004\bF\u0010GJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\tJ\u0019\u0010\r\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0011\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001b\u0010\u0013\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b\u001e\u0010\tR\"\u0010\u001f\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010\u0017R\u0016\u0010%\u001a\u00020$8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0018\u0010'\u001a\u0004\u0018\u00010\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020*0)8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0018\u0010.\u001a\u0004\u0018\u00010-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R$\u00101\u001a\u0004\u0018\u0001008\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u0016\u00108\u001a\u0002078\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0016\u0010:\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010 R\"\u0010;\u001a\u00020\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b;\u0010<\u001a\u0004\b=\u0010\u001a\"\u0004\b>\u0010?R\u0016\u0010@\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010 \u00a8\u0006I"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsView;", "Lcom/yuyakaido/android/cardstackview/CardStackView;", "Lio/streamlayer/sdk/model/notifications/Notification;", "notification", "", "shouldAnimatePrediction", "(Lio/streamlayer/sdk/model/notifications/Notification;)Z", "", "startDismissTimer", "()V", "stopDismissTimer", "Landroid/view/MotionEvent;", "motionEvent", "onTouchEvent", "(Landroid/view/MotionEvent;)Z", "", "notifications", "clearNotifications", "(Ljava/util/List;)Z", "setNotifications", "(Ljava/util/List;)V", "show", "visible", "(Z)V", "", "getTooltipBottomMargin", "()I", "bubbleWidth", "getTooltipRightMargin", "(I)I", "onDetachedFromWindow", "onScreen", "Z", "getOnScreen", "()Z", "setOnScreen", "Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;", "notificationsAdapter", "Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;", "clickedNotification", "Lio/streamlayer/sdk/model/notifications/Notification;", "", "", "animatedPredictionNotifications", "Ljava/util/Set;", "Ljava/util/Timer;", "dismissTimer", "Ljava/util/Timer;", "Lio/streamlayer/sdk/main/notifications/NotificationsView$NotificationsInteractionListener;", "listener", "Lio/streamlayer/sdk/main/notifications/NotificationsView$NotificationsInteractionListener;", "getListener", "()Lio/streamlayer/sdk/main/notifications/NotificationsView$NotificationsInteractionListener;", "setListener", "(Lio/streamlayer/sdk/main/notifications/NotificationsView$NotificationsInteractionListener;)V", "io/streamlayer/sdk/main/notifications/NotificationsView$notificationStackListener$1", "notificationStackListener", "Lio/streamlayer/sdk/main/notifications/NotificationsView$notificationStackListener$1;", "dismissedAll", "overlayHeight", "I", "getOverlayHeight", "setOverlayHeight", "(I)V", "animateAppearingCard", "Landroid/content/Context;", "context", "Landroid/util/AttributeSet;", "attrs", "defStyleAttr", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "NotificationsInteractionListener", "sdk_originalRelease"})
public final class NotificationsView
extends CardStackView {
    @Nullable
    private NotificationsInteractionListener listener;
    private boolean onScreen;
    private int overlayHeight;
    @Nullable
    private Timer dismissTimer;
    private boolean animateAppearingCard;
    private boolean dismissedAll;
    @NotNull
    private final NotificationsAdapter notificationsAdapter;
    @Nullable
    private Notification clickedNotification;
    @NotNull
    private final notificationStackListener.1 notificationStackListener;
    @NotNull
    private final Set<String> animatedPredictionNotifications;

    @JvmOverloads
    public NotificationsView(@NotNull Context context, @Nullable AttributeSet object, int n) {
        CardStackListener cardStackListener;
        NotificationsAdapter notificationsAdapter2;
        NotificationsView notificationsView = notificationsView4;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, object, n);
        notificationsView.onScreen = true;
        notificationsView.animateAppearingCard = true;
        Object object2 = object = notificationsAdapter2;
        NotificationsView notificationsView2 = notificationsView4;
        Object object3 = object;
        super(new Function0<Integer>(notificationsView4){
            final /* synthetic */ NotificationsView this$0;
            {
                this.this$0 = notificationsView;
                super(0);
            }

            public final int invoke() {
                return this.this$0.getOverlayHeight();
            }
        });
        notificationsView2.notificationsAdapter = object3;
        object = cardStackListener;
        notificationsView2.notificationStackListener = new CardStackListener(notificationsView4, context){
            final /* synthetic */ NotificationsView this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = notificationsView;
                this.$context = context;
            }

            public void onCardDisappeared(@Nullable View object, int n) {
                if (!NotificationsView.access$getDismissedAll$p(this.this$0)) {
                    if (NotificationsView.access$getNotificationsAdapter$p(this.this$0).getItemCount() > 0) {
                        object = NotificationsView.access$getClickedNotification$p(this.this$0);
                        if (object == null) {
                            object = NotificationsView.access$getNotificationsAdapter$p(this.this$0).getItem(0);
                        }
                        if ((this = this.this$0.getListener()) != null) {
                            this.onNotificationDismissed((Notification)object);
                        }
                    }
                } else {
                    object = this.this$0.getListener();
                    if (object != null) {
                        object.onAllNotificationsDismissed(NotificationsView.access$getNotificationsAdapter$p(this.this$0).getItemsList());
                    }
                }
            }

            public void onCardDragging(@Nullable Direction direction, float f) {
                if (direction == Direction.Bottom) {
                    notificationStackListener.1 v0 = this;
                    NotificationsView.access$setDismissedAll$p(v0.this$0, true);
                    v0.this$0.animate().translationY((float)this.this$0.getHeight() * f).start();
                } else {
                    NotificationsView.access$setDismissedAll$p(this.this$0, false);
                }
            }

            public void onCardSwiped(@Nullable Direction object) {
                if (object == Direction.Bottom) {
                    notificationStackListener.1 v0 = this;
                    NotificationsView.access$setDismissedAll$p(v0.this$0, true);
                    object = v0.this$0.getListener();
                    if (object != null) {
                        object.onAllNotificationsDismissed(NotificationsView.access$getNotificationsAdapter$p(this.this$0).getItemsList());
                    }
                } else if (object == Direction.Top || object == Direction.Right) {
                    notificationStackListener.1 v1 = this;
                    NotificationsView.access$setDismissedAll$p(v1.this$0, false);
                    NotificationsView.access$setAnimateAppearingCard$p(v1.this$0, false);
                    object = NotificationsView.access$getClickedNotification$p(v1.this$0);
                    int n = object == null ? 0 : NotificationsView.access$getNotificationsAdapter$p(this.this$0).getItemsList().indexOf(object);
                    if (n != -1) {
                        NotificationsView.access$getNotificationsAdapter$p(this.this$0).getItemAndRemove(n);
                    }
                }
                notificationStackListener.1 v2 = this;
                v2.this$0.animate().translationY(0.0f).start();
                NotificationsView.access$setClickedNotification$p(v2.this$0, null);
            }

            public void onCardCanceled() {
                this.this$0.animate().translationY(0.0f).start();
            }

            public void onCardAppeared(@Nullable View view2, int n) {
                Notification notification = (Notification)CollectionsKt.first(NotificationsView.access$getNotificationsAdapter$p(this.this$0).getItemsList());
                NotificationType notificationType = NotificationType.Prediction;
                if (!(notification.getType() == notificationType) ? NotificationsView.access$getAnimateAppearingCard$p(this.this$0) : NotificationsView.access$shouldAnimatePrediction(this.this$0, notification)) {
                    TranslateAnimation translateAnimation;
                    AlphaAnimation alphaAnimation2;
                    AnimationSet animationSet;
                    AnimationSet animationSet2 = animationSet;
                    animationSet = new AnimationSet(true);
                    AlphaAnimation alphaAnimation3 = alphaAnimation2;
                    alphaAnimation2 = new AlphaAnimation(0.0f, 1.0f);
                    if (notificationStackListener.WhenMappings.$EnumSwitchMapping$0[notification.getType().ordinal()] == 1) {
                        TranslateAnimation translateAnimation2;
                        translateAnimation = translateAnimation2;
                        float f = this.this$0.getHeight();
                        translateAnimation2 = new TranslateAnimation(0.0f, 0.0f, f, 0.0f);
                    } else {
                        TranslateAnimation translateAnimation3;
                        translateAnimation = translateAnimation3;
                        translateAnimation3 = new TranslateAnimation((float)this.this$0.getWidth(), 0.0f, 0.0f, 0.0f);
                    }
                    animationSet2.addAnimation((Animation)alphaAnimation3);
                    animationSet2.addAnimation((Animation)translateAnimation);
                    long l = notification.getType() == notificationType && OtherExtensionsKt.isScreenPortrait(this.$context) ? 500L : 300L;
                    animationSet2.setDuration(l);
                    if (view2 != null) {
                        view2.startAnimation((Animation)animationSet2);
                    }
                }
            }

            public void onCardRewound() {
            }
        };
        notificationsView2.animatedPredictionNotifications = new LinkedHashSet<String>();
        NotificationsView notificationsView3 = notificationsView4;
        n = notificationsView3.getResources().getDimensionPixelSize(R.dimen.slr_activity_vertical_margin);
        int n2 = notificationsView3.getResources().getDimensionPixelSize(R.dimen.slr_activity_horizontal_margin_small);
        int n3 = notificationsView3.getResources().getDimensionPixelSize(R.dimen.slr_activity_vertical_margin);
        notificationsView2.setPadding(notificationsView2.getResources().getDimensionPixelSize(R.dimen.slr_activity_horizontal_margin_small), n, n2, n3);
        notificationsView4.setAdapter((RecyclerView.Adapter)object2);
        notificationsAdapter2.setListener(new NotificationsAdapter.OnItemInteractionListener(){

            private static final void onNotificationClick$lambda-0(NotificationsView object, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"$notification");
                object = ((NotificationsView)((Object)object)).getListener();
                if (object != null) {
                    object.onNotificationClick(notification);
                }
            }

            @Override
            public void onNotificationClick(@NotNull Notification notification) {
                1 v0 = notificationsInteractionListener;
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                v0.notificationsView4.clickedNotification = notification;
                v0.notificationsView4.dismissedAll = false;
                v0.notificationsView4.swipe();
                if (notification.getType() == NotificationType.Prediction) {
                    NotificationsInteractionListener notificationsInteractionListener = notificationsInteractionListener.notificationsView4.getListener();
                    if (notificationsInteractionListener != null) {
                        notificationsInteractionListener.onNotificationClick(notification);
                    }
                } else {
                    NotificationsView notificationsView = notificationsInteractionListener.notificationsView4;
                    notificationsView.postDelayed(() -> 1.onNotificationClick$lambda-0(notificationsView, notification), 300L);
                }
            }
        });
        final NotificationsView notificationsView4 = new SwipeAnimationSetting.Builder().setDirection(Direction.Right).setDuration(Duration.Normal.duration).setInterpolator((Interpolator)new AccelerateInterpolator()).build();
        CardStackLayoutManager cardStackLayoutManager = new CardStackLayoutManager(context, (CardStackListener)object);
        cardStackLayoutManager.setCanScrollHorizontal(false);
        cardStackLayoutManager.setStackFrom(StackFrom.Bottom);
        cardStackLayoutManager.setDirections(Direction.VERTICAL);
        cardStackLayoutManager.setTranslationInterval(4.0f);
        cardStackLayoutManager.setScaleInterval(0.98f);
        cardStackLayoutManager.setSwipeThreshold(0.05f);
        cardStackLayoutManager.setSwipeAnimationSetting((SwipeAnimationSetting)notificationsView4);
        notificationsView.setLayoutManager((RecyclerView.LayoutManager)cardStackLayoutManager);
    }

    public /* synthetic */ NotificationsView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final boolean shouldAnimatePrediction(Notification notification) {
        boolean bl;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        if (OtherExtensionsKt.isScreenPortrait(context) && !this.animatedPredictionNotifications.contains(notification.getSourceUniqueId())) {
            this.animatedPredictionNotifications.add(notification.getSourceUniqueId());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void startDismissTimer() {
        TimerTask timerTask;
        Timer timer;
        Timer timer2 = this.dismissTimer;
        if (timer2 != null) {
            timer2.cancel();
        }
        timer2 = timer;
        TimerTask timerTask2 = timerTask;
        timerTask = new TimerTask(this){
            final /* synthetic */ NotificationsView this$0;
            {
                this.this$0 = notificationsView;
            }

            private static final void run$lambda-0(NotificationsView notificationsView) {
                NotificationsView notificationsView2 = notificationsView;
                Intrinsics.checkNotNullParameter((Object)((Object)notificationsView2), (String)"this$0");
                notificationsView2.swipe();
                if (NotificationsView.access$getNotificationsAdapter$p(notificationsView2).getItemCount() > 0) {
                    NotificationsView notificationsView3 = notificationsView;
                    Object object = NotificationsView.access$getNotificationsAdapter$p(notificationsView3).getItemAndRemove(0);
                    NotificationsInteractionListener notificationsInteractionListener = notificationsView3.getListener();
                    if (notificationsInteractionListener != null) {
                        notificationsInteractionListener.onNotificationDismissed((Notification)object);
                    }
                    if (NotificationsView.access$getNotificationsAdapter$p(notificationsView).getItemCount() == 0) {
                        object = notificationsView.getListener();
                        if (object != null) {
                            object.onAllNotificationsDismissed(CollectionsKt.emptyList());
                        }
                        NotificationsView.access$setDismissedAll$p(notificationsView, true);
                    }
                }
            }

            public void run() {
                if (NotificationsView.access$getNotificationsAdapter$p(this.this$0).getItemCount() == 0) {
                    NotificationsView.access$stopDismissTimer(this.this$0);
                } else {
                    startDismissTimer.1.1 v0 = this;
                    NotificationsView.access$setDismissedAll$p(v0.this$0, false);
                    NotificationsView notificationsView = v0.this$0;
                    notificationsView.post(() -> startDismissTimer.1.1.run$lambda-0(notificationsView));
                }
            }
        };
        new Timer().scheduleAtFixedRate(timerTask2, 8000L, 8000L);
        this.dismissTimer = timer2;
    }

    private final void stopDismissTimer() {
        Timer timer = ((NotificationsView)((Object)timer)).dismissTimer;
        if (timer != null) {
            timer.cancel();
        }
    }

    @JvmOverloads
    public NotificationsView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public NotificationsView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ NotificationsAdapter access$getNotificationsAdapter$p(NotificationsView notificationsView) {
        return notificationsView.notificationsAdapter;
    }

    public static final /* synthetic */ void access$stopDismissTimer(NotificationsView notificationsView) {
        notificationsView.stopDismissTimer();
    }

    public static final /* synthetic */ boolean access$getDismissedAll$p(NotificationsView notificationsView) {
        return notificationsView.dismissedAll;
    }

    public static final /* synthetic */ Notification access$getClickedNotification$p(NotificationsView notificationsView) {
        return notificationsView.clickedNotification;
    }

    public static final /* synthetic */ void access$setAnimateAppearingCard$p(NotificationsView notificationsView, boolean bl) {
        notificationsView.animateAppearingCard = bl;
    }

    public static final /* synthetic */ boolean access$getAnimateAppearingCard$p(NotificationsView notificationsView) {
        return notificationsView.animateAppearingCard;
    }

    public static final /* synthetic */ boolean access$shouldAnimatePrediction(NotificationsView notificationsView, Notification notification) {
        return notificationsView.shouldAnimatePrediction(notification);
    }

    @Nullable
    public final NotificationsInteractionListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable NotificationsInteractionListener notificationsInteractionListener) {
        this.listener = notificationsInteractionListener;
    }

    public final boolean getOnScreen() {
        return this.onScreen;
    }

    public final void setOnScreen(boolean bl) {
        this.onScreen = bl;
    }

    public final int getOverlayHeight() {
        return this.overlayHeight;
    }

    public final void setOverlayHeight(int n) {
        this.overlayHeight = n;
    }

    public boolean onTouchEvent(@Nullable MotionEvent motionEvent) {
        super.onTouchEvent(motionEvent);
        return false;
    }

    public final boolean clearNotifications(@NotNull List<Notification> list) {
        Intrinsics.checkNotNullParameter(list, (String)"notifications");
        return this.notificationsAdapter.clearItems(list);
    }

    public final void setNotifications(@NotNull List<Notification> list) {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList<Notification> arrayList3;
        List<Notification> list2 = list;
        Intrinsics.checkNotNullParameter(list2, (String)"notifications");
        ArrayList<Notification> arrayList4 = arrayList3;
        arrayList3 = new ArrayList<Notification>();
        ArrayList arrayList5 = arrayList2;
        arrayList2 = new ArrayList();
        for (Object t : list2) {
            if (!(((Notification)t).getType() == NotificationType.Prediction)) continue;
            arrayList5.add(t);
        }
        arrayList4.addAll(arrayList5);
        arrayList5 = arrayList;
        arrayList = new ArrayList();
        for (Object t : list) {
            if (!(((Notification)t).getType() != NotificationType.Prediction)) continue;
            arrayList5.add(t);
        }
        NotificationsView notificationsView = this;
        arrayList4.addAll(arrayList5);
        notificationsView.animateAppearingCard = notificationsView.notificationsAdapter.updateItems(arrayList4);
        notificationsView.animate().translationY((float)(3 - RangesKt.coerceAtMost((int)list.size(), (int)3)) * (float)ViewExtensionsKt.getDp(4.0f)).start();
        if (list.isEmpty() ^ true) {
            this.startDismissTimer();
        } else {
            this.stopDismissTimer();
        }
    }

    public final void visible(boolean bl) {
        this.onScreen = bl;
        ViewExtensionsKt.visibleIf((View)this, bl);
    }

    public final int getTooltipBottomMargin() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        return OtherExtensionsKt.isScreenPortrait(context) && ExtensionsKt.hasSinglePredictionNotification(this.notificationsAdapter.getItemsList()) ? this.overlayHeight - this.getResources().getDimensionPixelSize(R.dimen.slr_prediction_notification_top_margin) + this.getResources().getDimensionPixelSize(R.dimen.slr_notification_height) + this.getResources().getDimensionPixelSize(R.dimen.slr_prediction_tooltip_distance_between_view) : this.getResources().getDimensionPixelSize(R.dimen.slr_notification_height) + this.getResources().getDimensionPixelSize(R.dimen.slr_notification_padding) + this.getResources().getDimensionPixelSize(R.dimen.slr_view_tooltip_distance_between_view);
    }

    public final int getTooltipRightMargin(int n) {
        return ExtensionsKt.hasSinglePredictionNotification(this.notificationsAdapter.getItemsList()) ? (int)((float)this.getWidth() - this.getContext().getResources().getDimension(R.dimen.slr_predictions_notification_landscape_width) + (this.getContext().getResources().getDimension(R.dimen.slr_predictions_notification_landscape_width) - (float)n) / (float)2) : (int)((this.getContext().getResources().getDimension(R.dimen.slr_notification_landscape_width) - (float)n) / (float)2);
    }

    protected void onDetachedFromWindow() {
        NotificationsView notificationsView = timer;
        super.onDetachedFromWindow();
        Timer timer = notificationsView.dismissTimer;
        if (timer != null) {
            timer.cancel();
        }
    }

    public void _$_clearFindViewByIdCache() {
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u001d\u0010\n\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\bH&\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsView$NotificationsInteractionListener;", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "notification", "", "onNotificationClick", "(Lio/streamlayer/sdk/model/notifications/Notification;)V", "onNotificationDismissed", "", "notifications", "onAllNotificationsDismissed", "(Ljava/util/List;)V", "sdk_originalRelease"})
    public static interface NotificationsInteractionListener {
        public void onNotificationClick(@NotNull Notification var1);

        public void onNotificationDismissed(@NotNull Notification var1);

        public void onAllNotificationsDismissed(@NotNull List<Notification> var1);
    }
}

