/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.sports;

import com.streamlayer.sports.events.SummaryResponse;
import io.streamlayer.common.utils.DateUtil;
import io.streamlayer.sdk.model.sports.EventPeriod;
import io.streamlayer.sdk.model.sports.EventStatus;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.sdk.model.sports.EventTeam;
import io.streamlayer.sdk.model.sports.EventTime;
import io.streamlayer.sdk.model.sports.EventType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=2, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0017\u0010\u0003\u001a\u00020\u0002*\u00060\u0000j\u0002`\u0001H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0017\u0010\u0003\u001a\u00020\u0007*\u00060\u0005j\u0002`\u0006H\u0000\u00a2\u0006\u0004\b\u0003\u0010\b\u001a\u0017\u0010\u0003\u001a\u00020\u000b*\u00060\tj\u0002`\nH\u0000\u00a2\u0006\u0004\b\u0003\u0010\f\u001a\u0017\u0010\u0003\u001a\u00020\u000f*\u00060\rj\u0002`\u000eH\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0010\u001a\u001f\u0010\u0003\u001a\u00020\u000f*\u00060\u0011j\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0014\u001a\u0017\u0010\u0003\u001a\u00020\u0017*\u00060\u0015j\u0002`\u0016H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0018\u001a\u0017\u0010\u0003\u001a\u00020\u001b*\u00060\u0019j\u0002`\u001aH\u0000\u00a2\u0006\u0004\b\u0003\u0010\u001c*\f\b\u0000\u0010\u001d\"\u00020\t2\u00020\t*\f\b\u0000\u0010\u001e\"\u00020\u00152\u00020\u0015*\f\b\u0000\u0010\u001f\"\u00020\u00112\u00020\u0011*\f\b\u0000\u0010 \"\u00020\r2\u00020\r*\f\b\u0000\u0010!\"\u00020\u00002\u00020\u0000*\f\b\u0000\u0010\"\"\u00020\u00192\u00020\u0019*\f\b\u0000\u0010#\"\u00020\u00052\u00020\u0005\u00a8\u0006$"}, d2={"Lcom/streamlayer/sports/common/EventTeam;", "Lio/streamlayer/sdk/model/sports/EventTeamProto;", "Lio/streamlayer/sdk/model/sports/EventTeam;", "toDomain", "(Lcom/streamlayer/sports/common/EventTeam;)Lio/streamlayer/sdk/model/sports/EventTeam;", "Lcom/streamlayer/sports/events/EventType;", "Lio/streamlayer/sdk/model/sports/EventTypeProto;", "Lio/streamlayer/sdk/model/sports/EventType;", "(Lcom/streamlayer/sports/events/EventType;)Lio/streamlayer/sdk/model/sports/EventType;", "Lcom/streamlayer/sports/common/EventPeriod;", "Lio/streamlayer/sdk/model/sports/EventPeriodProto;", "Lio/streamlayer/sdk/model/sports/EventPeriod;", "(Lcom/streamlayer/sports/common/EventPeriod;)Lio/streamlayer/sdk/model/sports/EventPeriod;", "Lcom/streamlayer/sports/events/SummaryResponse$ResponseData;", "Lio/streamlayer/sdk/model/sports/EventSummaryResponseProto;", "Lio/streamlayer/sdk/model/sports/EventSummary;", "(Lcom/streamlayer/sports/events/SummaryResponse$ResponseData;)Lio/streamlayer/sdk/model/sports/EventSummary;", "Lcom/streamlayer/sports/common/EventSummary;", "Lio/streamlayer/sdk/model/sports/EventSummaryProto;", "type", "(Lcom/streamlayer/sports/common/EventSummary;Lio/streamlayer/sdk/model/sports/EventType;)Lio/streamlayer/sdk/model/sports/EventSummary;", "Lcom/streamlayer/sports/common/EventStatus;", "Lio/streamlayer/sdk/model/sports/EventStatusProto;", "Lio/streamlayer/sdk/model/sports/EventStatus;", "(Lcom/streamlayer/sports/common/EventStatus;)Lio/streamlayer/sdk/model/sports/EventStatus;", "Lcom/streamlayer/sports/common/EventTime;", "Lio/streamlayer/sdk/model/sports/EventTimeProto;", "Lio/streamlayer/sdk/model/sports/EventTime;", "(Lcom/streamlayer/sports/common/EventTime;)Lio/streamlayer/sdk/model/sports/EventTime;", "EventPeriodProto", "EventStatusProto", "EventSummaryProto", "EventSummaryResponseProto", "EventTeamProto", "EventTimeProto", "EventTypeProto", "sdk_originalRelease"})
public final class EventsKt {
    @NotNull
    public static final EventTeam toDomain(@NotNull com.streamlayer.sports.common.EventTeam object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.sports.common.EventTeam eventTeam = object;
        long l = eventTeam.getId();
        object = eventTeam.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
        String string2 = eventTeam.getAlias();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"alias");
        String string3 = eventTeam.getLogo();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"logo");
        List list = eventTeam.getColorsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"colorsList");
        List list2 = CollectionsKt.toList((Iterable)list);
        boolean bl = eventTeam.getIsWinner();
        return new EventTeam(l, (String)object, string2, string3, list2, bl);
    }

    @NotNull
    public static final EventType toDomain(@NotNull com.streamlayer.sports.events.EventType eventType) {
        EventType eventType2;
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[eventType.ordinal()]) {
            default: {
                throw new NoWhenBranchMatchedException();
            }
            case 6: {
                eventType2 = EventType.Soccer;
                break;
            }
            case 5: {
                eventType2 = EventType.Unrecognized;
                break;
            }
            case 4: {
                eventType2 = EventType.Unset;
                break;
            }
            case 3: {
                eventType2 = EventType.Hockey;
                break;
            }
            case 2: {
                eventType2 = EventType.Basketball;
                break;
            }
            case 1: {
                eventType2 = EventType.Baseball;
            }
        }
        return eventType2;
    }

    @NotNull
    public static final EventPeriod toDomain(@NotNull com.streamlayer.sports.common.EventPeriod eventPeriod) {
        Intrinsics.checkNotNullParameter((Object)eventPeriod, (String)"<this>");
        com.streamlayer.sports.common.EventPeriod eventPeriod2 = eventPeriod;
        int n = eventPeriod2.getNumber();
        int n2 = eventPeriod2.getScoreHome();
        int n3 = eventPeriod2.getScoreAway();
        return new EventPeriod(n, n2, n3);
    }

    @NotNull
    public static final EventSummary toDomain(@NotNull SummaryResponse.ResponseData object) {
        SummaryResponse.ResponseData responseData = object;
        Intrinsics.checkNotNullParameter((Object)responseData, (String)"<this>");
        com.streamlayer.sports.events.EventType eventType = responseData.getType();
        Intrinsics.checkNotNullExpressionValue((Object)eventType, (String)"type");
        object = EventsKt.toDomain(eventType);
        com.streamlayer.sports.common.EventSummary eventSummary2 = responseData.getAttributes().getSummary();
        Intrinsics.checkNotNullExpressionValue((Object)eventSummary2, (String)"attributes.summary");
        return EventsKt.toDomain(eventSummary2, (EventType)((Object)object));
    }

    @NotNull
    public static final EventSummary toDomain(@NotNull com.streamlayer.sports.common.EventSummary eventSummary2, @NotNull EventType eventType) {
        ArrayList<EventPeriod> arrayList;
        Intrinsics.checkNotNullParameter((Object)eventSummary2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"type");
        long l = eventSummary2.getId();
        String string2 = eventSummary2.getScheduled();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"scheduled");
        Date date = DateUtil.INSTANCE.fromString(string2);
        if (date == null) {
            Date date2;
            date = date2;
            date2 = new Date(0L);
        }
        com.streamlayer.sports.common.EventSummary eventSummary3 = eventSummary2;
        String string3 = eventSummary3.getLeague();
        int n = eventSummary3.getScoreHome();
        int n2 = eventSummary3.getScoreAway();
        com.streamlayer.sports.common.EventTeam eventTeam = eventSummary3.getHomeTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam, (String)"homeTeam");
        EventTeam eventTeam2 = EventsKt.toDomain(eventTeam);
        com.streamlayer.sports.common.EventTeam eventTeam3 = eventSummary3.getAwayTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam3, (String)"awayTeam");
        EventTeam eventTeam4 = EventsKt.toDomain(eventTeam3);
        com.streamlayer.sports.common.EventStatus eventStatus = eventSummary3.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)eventStatus, (String)"status");
        EventStatus eventStatus2 = EventsKt.toDomain(eventStatus);
        com.streamlayer.sports.common.EventTime eventTime = eventSummary3.getEventTime();
        Intrinsics.checkNotNullExpressionValue((Object)eventTime, (String)"eventTime");
        EventTime eventTime2 = EventsKt.toDomain(eventTime);
        Object object = eventSummary3.getPeriodsList();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"periodsList");
        ArrayList<EventPeriod> arrayList2 = arrayList;
        arrayList = new ArrayList<EventPeriod>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            com.streamlayer.sports.common.EventPeriod eventPeriod = (com.streamlayer.sports.common.EventPeriod)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)eventPeriod, (String)"it");
            arrayList2.add(EventsKt.toDomain(eventPeriod));
        }
        int n3 = eventSummary2.getPeriodsCount();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"league");
        return new EventSummary(l, eventType, date, string3, n, n2, eventTime2, eventTeam2, eventTeam4, eventStatus2, arrayList2, n3);
    }

    @NotNull
    public static final EventStatus toDomain(@NotNull com.streamlayer.sports.common.EventStatus eventStatus) {
        EventStatus eventStatus2;
        Intrinsics.checkNotNullParameter((Object)eventStatus, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[eventStatus.ordinal()]) {
            default: {
                eventStatus2 = EventStatus.Unset;
                break;
            }
            case 7: {
                eventStatus2 = EventStatus.Shootouts;
                break;
            }
            case 6: {
                eventStatus2 = EventStatus.Pregame;
                break;
            }
            case 5: {
                eventStatus2 = EventStatus.Postgame;
                break;
            }
            case 4: {
                eventStatus2 = EventStatus.Overtime;
                break;
            }
            case 3: {
                eventStatus2 = EventStatus.Cancelled;
                break;
            }
            case 2: {
                eventStatus2 = EventStatus.Break;
                break;
            }
            case 1: {
                eventStatus2 = EventStatus.Active;
            }
        }
        return eventStatus2;
    }

    @NotNull
    public static final EventTime toDomain(@NotNull com.streamlayer.sports.common.EventTime object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.sports.common.EventTime eventTime = object;
        object = eventTime.getClock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clock");
        return new EventTime((String)object, eventTime.getPeriod());
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[com.streamlayer.sports.events.EventType.values().length];
            nArray[com.streamlayer.sports.events.EventType.EVENT_TYPE_BASEBALL.ordinal()] = 1;
            nArray[com.streamlayer.sports.events.EventType.EVENT_TYPE_BASKETBALL.ordinal()] = 2;
            nArray[com.streamlayer.sports.events.EventType.EVENT_TYPE_HOCKEY.ordinal()] = 3;
            nArray[com.streamlayer.sports.events.EventType.EVENT_TYPE_UNSET.ordinal()] = 4;
            nArray[com.streamlayer.sports.events.EventType.UNRECOGNIZED.ordinal()] = 5;
            nArray[com.streamlayer.sports.events.EventType.EVENT_TYPE_SOCCER.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
            int[] nArray2 = new int[com.streamlayer.sports.common.EventStatus.values().length];
            nArray2[com.streamlayer.sports.common.EventStatus.EVENT_STATUS_ACTIVE.ordinal()] = 1;
            nArray2[com.streamlayer.sports.common.EventStatus.EVENT_STATUS_BREAK.ordinal()] = 2;
            nArray2[com.streamlayer.sports.common.EventStatus.EVENT_STATUS_CANCELLED.ordinal()] = 3;
            nArray2[com.streamlayer.sports.common.EventStatus.EVENT_STATUS_OVERTIME.ordinal()] = 4;
            nArray2[com.streamlayer.sports.common.EventStatus.EVENT_STATUS_POSTGAME.ordinal()] = 5;
            nArray2[com.streamlayer.sports.common.EventStatus.EVENT_STATUS_PREGAME.ordinal()] = 6;
            nArray2[com.streamlayer.sports.common.EventStatus.EVENT_STATUS_SHOOTOUTS.ordinal()] = 7;
            $EnumSwitchMapping$1 = nArray2;
        }
    }
}

