/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.notifications;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import io.streamlayer.sdk.model.notifications.Notification;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0007\ba\u0018\u00002\u00020\u0001J\u001d\u0010\u0006\u001a\u00020\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H'\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0003H'\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\f\u001a\u00020\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H'\u00a2\u0006\u0004\b\f\u0010\u0007J\u001b\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\rH'\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0010\u001a\u00020\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0012\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0003H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0005H'\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0017\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0017H'\u00a2\u0006\u0004\b\u0012\u0010\u0019J\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0017H'\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0017H'\u00a2\u0006\u0004\b\u001d\u0010\u0019\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lio/streamlayer/sdk/repository/notifications/NotificationDao;", "", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "items", "", "saveNotifications", "(Ljava/util/List;)V", "item", "", "saveNotification", "(Lio/streamlayer/sdk/model/notifications/Notification;)J", "updateNotifications", "Lkotlinx/coroutines/flow/Flow;", "getNotifications", "()Lkotlinx/coroutines/flow/Flow;", "deleteNotifications", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteNotification", "(Lio/streamlayer/sdk/model/notifications/Notification;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteAllNotifications", "()V", "safeDeleteAllNotifications", "", "sourceUniqueId", "(Ljava/lang/String;)V", "getNotification", "(Ljava/lang/String;)Lio/streamlayer/sdk/model/notifications/Notification;", "type", "deleteNotificationsByType", "sdk_originalRelease"})
@Dao
public interface NotificationDao {
    @Insert(onConflict=5)
    public void saveNotifications(@NotNull List<Notification> var1);

    @Insert(onConflict=1)
    public long saveNotification(@NotNull Notification var1);

    @Update
    public void updateNotifications(@NotNull List<Notification> var1);

    @Query(value="SELECT * FROM Notification ORDER BY Notification.id DESC, Notification.date DESC")
    @NotNull
    public Flow<List<Notification>> getNotifications();

    @Delete
    @Nullable
    public Object deleteNotifications(@NotNull List<Notification> var1, @NotNull Continuation<? super Unit> var2);

    @Delete
    @Nullable
    public Object deleteNotification(@NotNull Notification var1, @NotNull Continuation<? super Unit> var2);

    public void deleteAllNotifications();

    @Query(value="DELETE FROM Notification")
    public void safeDeleteAllNotifications();

    @Query(value="DELETE FROM Notification WHERE sourceUniqueId = :sourceUniqueId")
    public void deleteNotification(@NotNull String var1);

    @Query(value="SELECT * FROM Notification WHERE sourceUniqueId = :sourceUniqueId")
    @Nullable
    public Notification getNotification(@NotNull String var1);

    @Query(value="DELETE FROM Notification WHERE _type = :type")
    public void deleteNotificationsByType(@NotNull String var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
    public static final class DefaultImpls {
        public static void deleteAllNotifications(@NotNull NotificationDao notificationDao) {
            Intrinsics.checkNotNullParameter((Object)notificationDao, (String)"this");
            new Thread(() -> DefaultImpls.deleteAllNotifications$lambda-0(notificationDao)).start();
        }

        private static void deleteAllNotifications$lambda-0(NotificationDao notificationDao) {
            NotificationDao notificationDao2 = notificationDao;
            Intrinsics.checkNotNullParameter((Object)notificationDao2, (String)"this$0");
            notificationDao2.safeDeleteAllNotifications();
        }
    }
}

