/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.baseball;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.recyclerview.GenericAdapter;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.sports.EventSchedule;
import io.streamlayer.sdk.model.sports.EventStatus;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.sdk.model.sports.EventTeam;
import io.streamlayer.sdk.model.sports.TeamRecord;
import io.streamlayer.sdk.model.sports.baseball.BaseballEventScore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0014\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0003H\u0014\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballScoresAdapter;", "Lio/streamlayer/common/recyclerview/GenericAdapter;", "Lio/streamlayer/sdk/model/sports/EventSchedule;", "", "viewType", "getLayoutId", "(I)I", "Landroid/view/View;", "view", "Lio/streamlayer/common/recyclerview/GenericAdapter$GenericViewHolder;", "getViewHolder", "(Landroid/view/View;I)Lio/streamlayer/common/recyclerview/GenericAdapter$GenericViewHolder;", "<init>", "()V", "ViewHolder", "sdk_originalRelease"})
public final class BaseballScoresAdapter
extends GenericAdapter<EventSchedule> {
    @Override
    protected int getLayoutId(int n) {
        return R.layout.slr_item_statistics_schedule;
    }

    @Override
    @NotNull
    protected GenericAdapter.GenericViewHolder<EventSchedule> getViewHolder(@NotNull View view2, int n) {
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        return new ViewHolder(view2);
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballScoresAdapter$ViewHolder;", "Lio/streamlayer/common/recyclerview/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/sports/EventSchedule;", "data", "", "bind", "(Lio/streamlayer/sdk/model/sports/EventSchedule;)V", "Landroid/view/View;", "itemView", "<init>", "(Lio/streamlayer/sdk/statistics/baseball/BaseballScoresAdapter;Landroid/view/View;)V", "sdk_originalRelease"})
    private final class ViewHolder
    extends GenericAdapter.GenericViewHolder<EventSchedule> {
        public ViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)BaseballScoresAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
        }

        @Override
        public void bind(@NotNull EventSchedule object) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"data");
            ViewHolder viewHolder = viewHolder.itemView;
            EventTeam eventTeam = ((EventSchedule)object).getEventSummary().getHomeTeam();
            ImageView imageView = (ImageView)viewHolder.findViewById(R.id.slScheduleTeamHomeLogo);
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"slScheduleTeamHomeLogo");
            ViewExtensionsKt.loadUrl$default(imageView, eventTeam.getLogo(), false, null, null, 12, null);
            ((TextView)viewHolder.findViewById(R.id.slScheduleTeamHomeName)).setText((CharSequence)eventTeam.getName());
            Object object2 = (ImageView)viewHolder.findViewById(R.id.slScheduleTeamHomePointer);
            int n = eventTeam.isWinner() ? 0 : 4;
            ViewHolder viewHolder2 = viewHolder;
            object2.setVisibility(n);
            EventTeam eventTeam2 = ((EventSchedule)object).getEventSummary().getAwayTeam();
            ImageView imageView2 = (ImageView)viewHolder2.findViewById(R.id.slScheduleTeamAwayLogo);
            Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"slScheduleTeamAwayLogo");
            ViewExtensionsKt.loadUrl$default(imageView2, eventTeam2.getLogo(), false, null, null, 12, null);
            ((TextView)viewHolder2.findViewById(R.id.slScheduleTeamAwayName)).setText((CharSequence)eventTeam2.getName());
            object2 = (ImageView)viewHolder2.findViewById(R.id.slScheduleTeamAwayPointer);
            int n2 = eventTeam2.isWinner() ? 0 : 4;
            object2.setVisibility(n2);
            Object object3 = ((EventSchedule)object).getEventSummary();
            object2 = EventStatus.Overtime;
            if (((EventSummary)object3).getStatus() == object2) {
                ViewHolder viewHolder3 = viewHolder;
                ((TextView)viewHolder3.findViewById(R.id.slScheduleExtraBottom)).setVisibility(8);
                ((TextView)viewHolder3.findViewById(R.id.slScheduleExtraTop)).setText(R.string.slr_statistics_scores_final);
            } else {
                ((TextView)viewHolder.findViewById(R.id.slScheduleExtraBottom)).setVisibility(0);
            }
            TextView textView = (TextView)viewHolder.findViewById(R.id.slScheduleExtraBottom);
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"slScheduleExtraBottom");
            boolean bl = ((EventSummary)object3).getStatus() != object2;
            ViewExtensionsKt.visibleIf((View)textView, bl);
            if (((EventSummary)object3).getStatus() == EventStatus.Postgame) {
                object3 = ((EventSchedule)object).getBaseballEventScore();
                if (object3 != null) {
                    Object object4 = object3;
                    object3 = ((BaseballEventScore)object3).getHomeTeamRecord();
                    object3 = "" + ((TeamRecord)object3).getWins() + '-' + ((TeamRecord)object3).getLosses();
                    TextView textView2 = (TextView)viewHolder.findViewById(R.id.slScheduleTeamHomePoints);
                    Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"slScheduleTeamHomePoints");
                    textView2.setText((CharSequence)object3);
                    object3 = ((BaseballEventScore)object4).getAwayTeamRecord();
                    object3 = "" + ((TeamRecord)object3).getWins() + '-' + ((TeamRecord)object3).getLosses();
                    TextView textView3 = (TextView)viewHolder.findViewById(R.id.slScheduleTeamAwayPoints);
                    Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"slScheduleTeamAwayPoints");
                    textView3.setText((CharSequence)object3);
                }
            } else {
                ViewHolder viewHolder4 = viewHolder;
                ((TextView)viewHolder4.findViewById(R.id.slScheduleTeamHomePoints)).setText((CharSequence)String.valueOf(((EventSummary)object3).getHomeScore()));
                ((TextView)viewHolder4.findViewById(R.id.slScheduleTeamAwayPoints)).setText((CharSequence)String.valueOf(((EventSummary)object3).getAwayScore()));
            }
            object3 = ((EventSchedule)object).getBaseballEventScore();
            if (object3 != null) {
                if (((BaseballEventScore)object3).getDelayed()) {
                    ViewHolder viewHolder5 = viewHolder;
                    ((TextView)viewHolder5.findViewById(R.id.slScheduleExtraTop)).setText((CharSequence)((BaseballEventScore)object3).getReasonForDelay());
                    ((TextView)viewHolder5.findViewById(R.id.slScheduleExtraTop)).setBackgroundResource(R.drawable.slr_shape_rect_rounded_2);
                    ((TextView)viewHolder5.findViewById(R.id.slScheduleExtraTop)).setBackgroundTintList(ContextCompat.getColorStateList((Context)viewHolder.getContext(), (int)R.color.slr_red700));
                } else {
                    ViewHolder viewHolder6 = viewHolder;
                    ((TextView)viewHolder6.findViewById(R.id.slScheduleExtraTop)).setBackground(null);
                    object = ((BaseballEventScore)object3).getInningDivision() + ' ' + ((EventSchedule)object).getEventSummary().getEventTime().getPeriod();
                    TextView textView4 = (TextView)viewHolder6.findViewById(R.id.slScheduleExtraTop);
                    Intrinsics.checkNotNullExpressionValue((Object)textView4, (String)"slScheduleExtraTop");
                    textView4.setText((CharSequence)object);
                }
                ((TextView)viewHolder.findViewById(R.id.slScheduleExtraBottom)).setText((CharSequence)viewHolder.getContext().getString(R.string.slr_statistics_scores_outs, new Object[]{((BaseballEventScore)object3).getOuts()}));
                if (((BaseballEventScore)object3).getTakenBases() >= 3) {
                    ((ImageView)viewHolder.findViewById(R.id.slScheduleSportIcon)).setImageResource(R.drawable.slr_ic_baseball_bases_3);
                } else if (((BaseballEventScore)object3).getTakenBases() == 2) {
                    ((ImageView)viewHolder.findViewById(R.id.slScheduleSportIcon)).setImageResource(R.drawable.slr_ic_baseball_bases_2);
                } else if (((BaseballEventScore)object3).getTakenBases() == 1) {
                    ((ImageView)viewHolder.findViewById(R.id.slScheduleSportIcon)).setImageResource(R.drawable.slr_ic_baseball_bases_1);
                } else {
                    ((ImageView)viewHolder.findViewById(R.id.slScheduleSportIcon)).setImageDrawable(null);
                }
            }
        }
    }
}

