/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.voximplant;

import com.voximplant.sdk.call.CallSettings;
import com.voximplant.sdk.call.ICall;
import com.voximplant.sdk.call.ICallListener;
import com.voximplant.sdk.call.IQualityIssueListener;
import com.voximplant.sdk.call.VideoCodec;
import com.voximplant.sdk.call.VideoFlags;
import com.voximplant.sdk.client.AuthParams;
import com.voximplant.sdk.client.ClientState;
import com.voximplant.sdk.client.IClient;
import com.voximplant.sdk.client.IClientLoginListener;
import com.voximplant.sdk.client.IClientSessionListener;
import com.voximplant.sdk.client.LoginError;
import io.streamlayer.common.data.voximplant.AuthError;
import io.streamlayer.common.data.voximplant.VoxClientManagerKt;
import io.streamlayer.common.data.voximplant.VoximplantClientListener;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.model.auth.VoximplantUser;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u00100\u001a\u00020/\u00a2\u0006\u0004\b:\u0010;J\b\u0010\u0004\u001a\u00020\u0003H\u0002J\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\b\u001a\u00020\u0003J \u0010\f\u001a\u00020\u00032\u0018\b\u0002\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\tJ\b\u0010\r\u001a\u00020\u0003H\u0016J\u0012\u0010\u0010\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u001a\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J,\u0010%\u001a\u0004\u0018\u00010$2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u001e2\b\u0010!\u001a\u0004\u0018\u00010 2\b\u0010#\u001a\u0004\u0018\u00010\"J\u0018\u0010'\u001a\u00020\u00032\u0006\u0010&\u001a\u00020$2\b\u0010!\u001a\u0004\u0018\u00010 R&\u0010(\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0018\u0010*\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0,8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0019\u00100\u001a\u00020/8\u0006@\u0006\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R$\u0010!\u001a\u0004\u0018\u0001048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u00105\u001a\u0004\b6\u00107\"\u0004\b8\u00109\u00a8\u0006<"}, d2={"Lio/streamlayer/common/data/voximplant/VoximplantClientManager;", "Lcom/voximplant/sdk/client/IClientSessionListener;", "Lcom/voximplant/sdk/client/IClientLoginListener;", "", "internalLogin", "Lio/streamlayer/sdk/model/auth/VoximplantUser;", "user", "login", "logout", "Lkotlin/Function1;", "Lio/streamlayer/common/data/voximplant/AuthError;", "completion", "connect", "onConnectionEstablished", "", "p0", "onConnectionFailed", "onConnectionClosed", "displayName", "Lcom/voximplant/sdk/client/AuthParams;", "authParams", "onLoginSuccessful", "Lcom/voximplant/sdk/client/LoginError;", "reason", "onLoginFailed", "key", "onOneTimeKeyGenerated", "onRefreshTokenFailed", "onRefreshTokenSuccess", "topicId", "", "isVideoEnabled", "Lcom/voximplant/sdk/call/ICallListener;", "listener", "Lcom/voximplant/sdk/call/IQualityIssueListener;", "qualityListener", "Lcom/voximplant/sdk/call/ICall;", "createCall", "call", "endCall", "reconnectCompletion", "Lkotlin/jvm/functions/Function1;", "voximplantUser", "Lio/streamlayer/sdk/model/auth/VoximplantUser;", "", "servers", "Ljava/util/List;", "Lcom/voximplant/sdk/client/IClient;", "client", "Lcom/voximplant/sdk/client/IClient;", "getClient", "()Lcom/voximplant/sdk/client/IClient;", "Lio/streamlayer/common/data/voximplant/VoximplantClientListener;", "Lio/streamlayer/common/data/voximplant/VoximplantClientListener;", "getListener", "()Lio/streamlayer/common/data/voximplant/VoximplantClientListener;", "setListener", "(Lio/streamlayer/common/data/voximplant/VoximplantClientListener;)V", "<init>", "(Lcom/voximplant/sdk/client/IClient;)V", "sdk_originalRelease"})
public final class VoximplantClientManager
implements IClientSessionListener,
IClientLoginListener {
    @NotNull
    private final IClient client;
    @Nullable
    private VoximplantUser voximplantUser;
    @NotNull
    private final List<String> servers;
    @Nullable
    private Function1<? super AuthError, Unit> reconnectCompletion;
    @Nullable
    private VoximplantClientListener listener;

    public VoximplantClientManager(@NotNull IClient object) {
        ArrayList arrayList;
        IClient iClient = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"client");
        this.client = object;
        object = arrayList;
        arrayList = new ArrayList();
        this.servers = object;
        iClient.setClientLoginListener((IClientLoginListener)this);
        iClient.setClientSessionListener((IClientSessionListener)this);
    }

    public static /* synthetic */ void connect$default(VoximplantClientManager voximplantClientManager, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        voximplantClientManager.connect((Function1<? super AuthError, Unit>)function1);
    }

    private final void internalLogin() {
        block8: {
            SLRLog.INSTANCE.i("VoximplantClientManager", Intrinsics.stringPlus((String)"internalLogin ", (Object)((VoximplantClientManager)this).client.getClientState()));
            if (((VoximplantClientManager)this).client.getClientState() == ClientState.DISCONNECTED) {
                IClient iClient = ((VoximplantClientManager)this).client;
                boolean bl = false;
                try {
                    iClient.connect(bl, ((VoximplantClientManager)this).servers);
                }
                catch (IllegalStateException illegalStateException) {
                    VoximplantClientListener voximplantClientListener = ((VoximplantClientManager)this).listener;
                    if (voximplantClientListener == null) break block8;
                    voximplantClientListener.onConnectionFailed(AuthError.NetworkIssues);
                }
            }
        }
        if (((VoximplantClientManager)this).client.getClientState() == ClientState.CONNECTED) {
            Unit unit;
            Object object = ((VoximplantClientManager)this).voximplantUser;
            if (object == null) {
                unit = null;
            } else {
                VoximplantUser voximplantUser = object;
                object = voximplantUser.getUsername();
                ((VoximplantClientManager)this).getClient().login((String)object, voximplantUser.getPassword());
                unit = Unit.INSTANCE;
            }
            if (unit == null && (this = ((VoximplantClientManager)this).getListener()) != null) {
                this.onLoginFailed(AuthError.InvalidUsername);
            }
        }
    }

    @NotNull
    public final IClient getClient() {
        return this.client;
    }

    @Nullable
    public final VoximplantClientListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable VoximplantClientListener voximplantClientListener) {
        this.listener = voximplantClientListener;
    }

    public final void login(@NotNull VoximplantUser voximplantUser) {
        VoximplantUser voximplantUser2 = voximplantUser;
        Intrinsics.checkNotNullParameter((Object)voximplantUser2, (String)"user");
        SLRLog.INSTANCE.i("VoximplantClientManager", Intrinsics.stringPlus((String)"login ", (Object)this.client.getClientState()));
        this.voximplantUser = voximplantUser2;
        this.internalLogin();
    }

    public final void logout() {
        SLRLog.INSTANCE.i("VoximplantClientManager", Intrinsics.stringPlus((String)"logout ", (Object)this.client.getClientState()));
        if (this.client.getClientState() == ClientState.LOGGED_IN) {
            this.client.disconnect();
        }
        this.voximplantUser = null;
    }

    public final void connect(@Nullable Function1<? super AuthError, Unit> function1) {
        SLRLog.INSTANCE.i("VoximplantClientManager", Intrinsics.stringPlus((String)"connect ", (Object)this.client.getClientState()));
        if (this.client.getClientState() == ClientState.LOGGED_IN) {
            if (function1 != null) {
                function1.invoke(null);
            }
            return;
        }
        this.reconnectCompletion = function1;
        this.internalLogin();
    }

    public void onConnectionEstablished() {
        this.internalLogin();
    }

    public void onConnectionFailed(@Nullable String function1) {
        SLRLog.INSTANCE.i("VoximplantClientManager", Intrinsics.stringPlus((String)"onConnectionFailed ", (Object)function1));
        function1 = this.listener;
        if (function1 != null) {
            function1.onConnectionFailed(AuthError.NetworkIssues);
        }
        function1 = this.reconnectCompletion;
        if (function1 != null) {
            function1.invoke((Object)AuthError.NetworkIssues);
        }
        this.reconnectCompletion = null;
    }

    public void onConnectionClosed() {
        SLRLog.INSTANCE.i("VoximplantClientManager", "onConnectionClosed");
        Function1<? super AuthError, Unit> function1 = this.listener;
        if (function1 != null) {
            function1.onConnectionClosed();
        }
        function1 = this.reconnectCompletion;
        if (function1 != null) {
            function1.invoke((Object)AuthError.NetworkIssues);
        }
        this.reconnectCompletion = null;
    }

    public void onLoginSuccessful(@NotNull String function1, @Nullable AuthParams object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"displayName");
        SLRLog.INSTANCE.i("VoximplantClientManager", Intrinsics.stringPlus((String)"onLoginSuccessful ", (Object)function1));
        object = this.listener;
        if (object != null) {
            object.onLoginSuccess((String)function1);
        }
        function1 = this.reconnectCompletion;
        if (function1 != null) {
            function1.invoke(null);
        }
        this.reconnectCompletion = null;
    }

    public void onLoginFailed(@NotNull LoginError object) {
        LoginError loginError = object;
        Intrinsics.checkNotNullParameter((Object)loginError, (String)"reason");
        object = VoxClientManagerKt.access$makeAuthError(loginError);
        SLRLog.INSTANCE.i("VoximplantClientManager", Intrinsics.stringPlus((String)"onLoginFailed ", (Object)object));
        Function1<? super AuthError, Unit> function1 = this.listener;
        if (function1 != null) {
            function1.onLoginFailed((AuthError)((Object)object));
        }
        function1 = this.reconnectCompletion;
        if (function1 != null) {
            function1.invoke(object);
        }
        this.reconnectCompletion = null;
    }

    public void onOneTimeKeyGenerated(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"key");
    }

    public void onRefreshTokenFailed(@NotNull LoginError loginError) {
        Intrinsics.checkNotNullParameter((Object)loginError, (String)"reason");
    }

    public void onRefreshTokenSuccess(@NotNull AuthParams authParams) {
        Intrinsics.checkNotNullParameter((Object)authParams, (String)"authParams");
    }

    @Nullable
    public final ICall createCall(@NotNull String string2, boolean bl, @Nullable ICallListener iCallListener, @Nullable IQualityIssueListener iQualityIssueListener) {
        CallSettings callSettings;
        VoximplantClientManager voximplantClientManager = voximplantClientManager2;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        SLRLog.INSTANCE.i("VoximplantClientManager", Intrinsics.stringPlus((String)"createCall ", (Object)string2));
        VoximplantClientManager voximplantClientManager2 = callSettings;
        new CallSettings().videoFlags = new VideoFlags(true, bl);
        new CallSettings().preferredVideoCodec = VideoCodec.AUTO;
        voximplantClientManager2 = voximplantClientManager.client.callConference(Intrinsics.stringPlus((String)"conf_", (Object)string2), (CallSettings)voximplantClientManager2);
        if (voximplantClientManager2 != null) {
            VoximplantClientManager voximplantClientManager3 = voximplantClientManager2;
            voximplantClientManager3.addCallListener(iCallListener);
            voximplantClientManager3.setQualityIssueListener(iQualityIssueListener);
            voximplantClientManager3.start();
        }
        return voximplantClientManager2;
    }

    public final void endCall(@NotNull ICall iCall, @Nullable ICallListener iCallListener) {
        Intrinsics.checkNotNullParameter((Object)iCall, (String)"call");
        if (iCallListener != null) {
            iCall.removeCallListener(iCallListener);
        }
        ICall iCall2 = iCall;
        iCall2.setQualityIssueListener(null);
        iCall2.hangup(null);
    }
}

