/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.utils;

import com.github.marlonlom.utilities.timeago.TimeAgo;
import io.streamlayer.common.utils.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b%\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b8\u00109J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u0016\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002R\u001d\u0010\u001a\u001a\u00020\u00158B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001d\u001a\u00020\u00158B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0017\u001a\u0004\b\u001c\u0010\u0019R\u001d\u0010 \u001a\u00020\u00158B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0017\u001a\u0004\b\u001f\u0010\u0019R\u001d\u0010#\u001a\u00020\u00158B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0017\u001a\u0004\b\"\u0010\u0019R\u001d\u0010&\u001a\u00020\u00158F@\u0006X\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0017\u001a\u0004\b%\u0010\u0019R\"\u0010'\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010(\u001a\u0004\b'\u0010)\"\u0004\b*\u0010+R\u001d\u0010.\u001a\u00020\u00158B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u0017\u001a\u0004\b-\u0010\u0019R\u001d\u00101\u001a\u00020\u00158B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\u0017\u001a\u0004\b0\u0010\u0019R\u001d\u00104\u001a\u00020\u00158B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\u0017\u001a\u0004\b3\u0010\u0019R\u001d\u00107\u001a\u00020\u00158B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\u0017\u001a\u0004\b6\u0010\u0019\u00a8\u0006:"}, d2={"Lio/streamlayer/common/utils/DateUtil;", "", "Ljava/util/Date;", "value", "", "toWeekDayMonthDay", "fromString", "toDateTimeString", "toDateString", "dateFromString", "toShort", "toWeekDay", "toDayMonth", "date1", "date2", "", "isSameDay", "toRelativeTimeString", "fromTwitterStringToDate", "date", "fromDateToTwitterString", "Ljava/text/SimpleDateFormat;", "twitterDateFormat$delegate", "Lkotlin/Lazy;", "getTwitterDateFormat", "()Ljava/text/SimpleDateFormat;", "twitterDateFormat", "fullDateFormat$delegate", "getFullDateFormat", "fullDateFormat", "shortDateFormat$delegate", "getShortDateFormat", "shortDateFormat", "dateFormat$delegate", "getDateFormat", "dateFormat", "requestDateFormat$delegate", "getRequestDateFormat", "requestDateFormat", "is24HourFormat", "Z", "()Z", "set24HourFormat", "(Z)V", "dayMonthFormat$delegate", "getDayMonthFormat", "dayMonthFormat", "shortDate24Format$delegate", "getShortDate24Format", "shortDate24Format", "weekDayMonthDayFormat$delegate", "getWeekDayMonthDayFormat", "weekDayMonthDayFormat", "weekDayFormat$delegate", "getWeekDayFormat", "weekDayFormat", "<init>", "()V", "sdk_originalRelease"})
public final class DateUtil {
    @NotNull
    public static final DateUtil INSTANCE = new DateUtil();
    private static boolean is24HourFormat;
    @NotNull
    private static final Lazy fullDateFormat$delegate;
    @NotNull
    private static final Lazy twitterDateFormat$delegate;
    @NotNull
    private static final Lazy dateFormat$delegate;
    @NotNull
    private static final Lazy shortDate24Format$delegate;
    @NotNull
    private static final Lazy shortDateFormat$delegate;
    @NotNull
    private static final Lazy weekDayFormat$delegate;
    @NotNull
    private static final Lazy dayMonthFormat$delegate;
    @NotNull
    private static final Lazy weekDayMonthDayFormat$delegate;
    @NotNull
    private static final Lazy requestDateFormat$delegate;

    private DateUtil() {
    }

    private final SimpleDateFormat getFullDateFormat() {
        return (SimpleDateFormat)fullDateFormat$delegate.getValue();
    }

    private final SimpleDateFormat getTwitterDateFormat() {
        return (SimpleDateFormat)twitterDateFormat$delegate.getValue();
    }

    private final SimpleDateFormat getDateFormat() {
        return (SimpleDateFormat)dateFormat$delegate.getValue();
    }

    private final SimpleDateFormat getShortDate24Format() {
        return (SimpleDateFormat)shortDate24Format$delegate.getValue();
    }

    private final SimpleDateFormat getShortDateFormat() {
        return (SimpleDateFormat)shortDateFormat$delegate.getValue();
    }

    private final SimpleDateFormat getWeekDayFormat() {
        return (SimpleDateFormat)weekDayFormat$delegate.getValue();
    }

    private final SimpleDateFormat getDayMonthFormat() {
        return (SimpleDateFormat)dayMonthFormat$delegate.getValue();
    }

    private final SimpleDateFormat getWeekDayMonthDayFormat() {
        return (SimpleDateFormat)weekDayMonthDayFormat$delegate.getValue();
    }

    static {
        fullDateFormat$delegate = LazyKt.lazy((Function0)fullDateFormat.2.INSTANCE);
        twitterDateFormat$delegate = LazyKt.lazy((Function0)twitterDateFormat.2.INSTANCE);
        dateFormat$delegate = LazyKt.lazy((Function0)dateFormat.2.INSTANCE);
        shortDate24Format$delegate = LazyKt.lazy((Function0)shortDate24Format.2.INSTANCE);
        shortDateFormat$delegate = LazyKt.lazy((Function0)shortDateFormat.2.INSTANCE);
        weekDayFormat$delegate = LazyKt.lazy((Function0)weekDayFormat.2.INSTANCE);
        dayMonthFormat$delegate = LazyKt.lazy((Function0)dayMonthFormat.2.INSTANCE);
        weekDayMonthDayFormat$delegate = LazyKt.lazy((Function0)weekDayMonthDayFormat.2.INSTANCE);
        requestDateFormat$delegate = LazyKt.lazy((Function0)requestDateFormat.2.INSTANCE);
    }

    public final boolean is24HourFormat() {
        return is24HourFormat;
    }

    public final void set24HourFormat(boolean bl) {
        is24HourFormat = bl;
    }

    @NotNull
    public final SimpleDateFormat getRequestDateFormat() {
        return (SimpleDateFormat)requestDateFormat$delegate.getValue();
    }

    @NotNull
    public final String toWeekDayMonthDay(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        String string2 = this.getWeekDayMonthDayFormat().format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"weekDayMonthDayFormat.format(value)");
        return string2;
    }

    @Nullable
    public final Date fromString(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"value");
        return this.getFullDateFormat().parse(string2);
    }

    @Nullable
    public final String toDateTimeString(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        return this.getFullDateFormat().format(date);
    }

    @NotNull
    public final String toDateString(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        String string2 = this.getDateFormat().format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dateFormat.format(value)");
        return string2;
    }

    @Nullable
    public final Date dateFromString(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"value");
        return this.getDateFormat().parse(string2);
    }

    @Nullable
    public final String toShort(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        return is24HourFormat ? this.getShortDate24Format().format(date) : this.getShortDateFormat().format(date);
    }

    @Nullable
    public final String toWeekDay(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        return this.getWeekDayFormat().format(date);
    }

    @Nullable
    public final String toDayMonth(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        return this.getDayMonthFormat().format(date);
    }

    public final boolean isSameDay(@NotNull Date date, @NotNull Date date2) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date1");
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date2");
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTime(date);
        calendar2.setTime(date2);
        return calendar.get(6) == calendar2.get(6) && calendar.get(1) == calendar2.get(1);
    }

    @NotNull
    public final String toRelativeTimeString(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        return TimeAgo.Companion.using$default((TimeAgo.Companion)TimeAgo.Companion, (long)date.getTime(), null, (int)2, null);
    }

    @Nullable
    public final Date fromTwitterStringToDate(@Nullable String string2) {
        if (string2 == null) {
            return null;
        }
        return this.getTwitterDateFormat().parse(string2);
    }

    @Nullable
    public final String fromDateToTwitterString(@Nullable Date date) {
        if (date == null) {
            return null;
        }
        return this.getTwitterDateFormat().format(date);
    }
}

