/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.common;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.sports.TeamStandings;
import io.streamlayer.sdk.model.sports.baseball.BaseballTeamStanding;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamStanding;
import io.streamlayer.sdk.model.sports.hockey.HockeyTeamStanding;
import io.streamlayer.sdk.statistics.common.SectionViewHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u001c\u001d\u001eB\u000f\u0012\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ \u0010\t\u001a\u00020\b2\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\nH\u0016R\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lio/streamlayer/sdk/statistics/common/StandingsAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "", "", "", "Lio/streamlayer/sdk/model/sports/TeamStandings;", "map", "", "setData", "", "getItemCount", "position", "getItemViewType", "Landroid/view/ViewGroup;", "parent", "viewType", "onCreateViewHolder", "holder", "onBindViewHolder", "", "data", "Ljava/util/List;", "Lio/streamlayer/sdk/statistics/common/StandingsAdapter$Type;", "type", "Lio/streamlayer/sdk/statistics/common/StandingsAdapter$Type;", "<init>", "(Lio/streamlayer/sdk/statistics/common/StandingsAdapter$Type;)V", "Companion", "StandingViewHolder", "Type", "sdk_originalRelease"})
public final class StandingsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int TYPE_SECTION = 0;
    private static final int TYPE_ITEM = 1;
    @NotNull
    private final Type type;
    @NotNull
    private List<? extends Object> data;

    public StandingsAdapter(@NotNull Type type2) {
        StandingsAdapter standingsAdapter = this;
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        standingsAdapter.type = type2;
        standingsAdapter.data = CollectionsKt.emptyList();
    }

    public final void setData(@NotNull Map<String, ? extends List<? extends TeamStandings>> object) {
        ArrayList arrayList;
        Map<String, ? extends List<? extends TeamStandings>> map2 = object;
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        object = arrayList;
        arrayList = new ArrayList();
        Iterator<Map.Entry<String, ? extends List<? extends TeamStandings>>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object;
            Map.Entry<String, ? extends List<? extends TeamStandings>> entry = iterator.next();
            Object object3 = entry;
            object3 = object3.getValue();
            object2.add(entry.getKey());
            object2.addAll(object3);
        }
        this.data = object;
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        return this.data.size();
    }

    public int getItemViewType(int n) {
        block4: {
            int n2;
            block3: {
                block2: {
                    Object object = object.data.get(n);
                    if (!(object instanceof String)) break block2;
                    n2 = 0;
                    break block3;
                }
                if (!(object instanceof TeamStandings)) break block4;
                n2 = 1;
            }
            return n2;
        }
        throw new RuntimeException("Unsupported item type at data[" + n + ']');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        if (n != 0) {
            StandingViewHolder standingViewHolder;
            if (n != 1) throw new RuntimeException(Intrinsics.stringPlus((String)"Unsupported viewType: ", (Object)n));
            viewHolder = standingViewHolder;
            standingViewHolder = new StandingViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_statistics_standing_values));
            return viewHolder;
        } else {
            SectionViewHolder sectionViewHolder;
            viewHolder = sectionViewHolder;
            sectionViewHolder = new SectionViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_statistics_standing_labels));
        }
        return viewHolder;
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"holder");
        Object object = object.data.get(n);
        if (viewHolder instanceof SectionViewHolder && object instanceof String) {
            ((SectionViewHolder)viewHolder).bind((String)object);
        } else if (viewHolder instanceof StandingViewHolder && object instanceof TeamStandings) {
            ((StandingViewHolder)viewHolder).bind((TeamStandings)object);
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/streamlayer/sdk/statistics/common/StandingsAdapter$Type;", "", "<init>", "(Ljava/lang/String;I)V", "Baseball", "Basketball", "sdk_originalRelease"})
    public static enum Type {
        Baseball,
        Basketball;

    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0016\u0010\u0005\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0004\u00a8\u0006\b"}, d2={"Lio/streamlayer/sdk/statistics/common/StandingsAdapter$Companion;", "", "", "TYPE_ITEM", "I", "TYPE_SECTION", "<init>", "()V", "sdk_originalRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006R\u0016\u0010\n\u001a\u00020\u00048\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lio/streamlayer/sdk/statistics/common/StandingsAdapter$StandingViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "", "percentage", "", "formatPercentage", "Lio/streamlayer/sdk/model/sports/TeamStandings;", "standings", "", "bind", "percentageFormat", "Ljava/lang/String;", "Landroid/view/View;", "itemView", "<init>", "(Lio/streamlayer/sdk/statistics/common/StandingsAdapter;Landroid/view/View;)V", "sdk_originalRelease"})
    public final class StandingViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final String percentageFormat;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public StandingViewHolder(View view2) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)((Object)StandingsAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
            int n = WhenMappings.$EnumSwitchMapping$0[StandingsAdapter.this.type.ordinal()];
            if (n != 1) {
                if (n != 2) throw new NoWhenBranchMatchedException();
                string2 = "%.1f";
            } else {
                string2 = "%.3f";
            }
            this.percentageFormat = string2;
        }

        private final String formatPercentage(double d) {
            Object object = String.format(object.percentageFormat, Arrays.copyOf(new Object[]{d}, 1));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"java.lang.String.format(this, *args)");
            int n = d < 1.0 ? 1 : 0;
            return StringsKt.drop((String)object, (int)n);
        }

        public final void bind(@NotNull TeamStandings object) {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)object, (String)"standings");
            View view2 = ((RecyclerView.ViewHolder)object2).itemView;
            ((AppCompatTextView)view2.findViewById(R.id.slStandingsTeamName)).setText((CharSequence)object.getTeamName());
            ImageView imageView = (ImageView)view2.findViewById(R.id.slStandingsTeamIcon);
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"slStandingsTeamIcon");
            ViewExtensionsKt.loadUrl$default(imageView, object.getTeamIcon(), false, R.drawable.slr_ic_team_placeholder, null, 8, null);
            ((AppCompatTextView)view2.findViewById(R.id.slStandingsValueWins)).setText((CharSequence)String.valueOf(object.getWins()));
            ((AppCompatTextView)view2.findViewById(R.id.slStandingsValueLosses)).setText((CharSequence)String.valueOf(object.getLosses()));
            ((AppCompatTextView)view2.findViewById(R.id.slStandingsValuePercentage)).setText((CharSequence)((StandingViewHolder)((Object)object2)).formatPercentage(object.getPercentage()));
            ((AppCompatTextView)view2.findViewById(R.id.slStandingsValueGamesBehind)).setText((CharSequence)String.valueOf(object.getGamesBehind()));
            if (object instanceof BasketballTeamStanding) {
                TeamStandings teamStandings = object;
                object2 = (AppCompatTextView)view2.findViewById(R.id.slStandingsValueStreak);
                object = "%s%d";
                int n = 2;
                Object[] objectArray = new Object[2];
                int n2 = 0;
                BasketballTeamStanding basketballTeamStanding = (BasketballTeamStanding)teamStandings;
                Object object3 = StringsKt.firstOrNull((CharSequence)basketballTeamStanding.getStreak().getKind());
                object3 = object3 == null ? "" : Character.valueOf(Character.toUpperCase(((Character)object3).charValue()));
                objectArray[n2] = object3;
                objectArray[1] = basketballTeamStanding.getStreak().getLength();
                String string2 = String.format((String)object, Arrays.copyOf(objectArray, n));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
                object2.setText((CharSequence)string2);
            } else if (object instanceof BaseballTeamStanding) {
                AppCompatTextView appCompatTextView = (AppCompatTextView)view2.findViewById(R.id.slStandingsValueStreak);
                Object[] objectArray = new Object[2];
                object2 = (BaseballTeamStanding)object;
                objectArray[0] = ((BaseballTeamStanding)object2).getStreak().getWins();
                objectArray[1] = ((BaseballTeamStanding)object2).getStreak().getLosses();
                String string3 = String.format("%d - %d", Arrays.copyOf(objectArray, 2));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(this, *args)");
                appCompatTextView.setText((CharSequence)string3);
            } else if (object instanceof HockeyTeamStanding) {
                TeamStandings teamStandings = object;
                object2 = (AppCompatTextView)view2.findViewById(R.id.slStandingsValueStreak);
                object = "%s%d";
                int n = 2;
                Object[] objectArray = new Object[2];
                int n3 = 0;
                HockeyTeamStanding hockeyTeamStanding = (HockeyTeamStanding)teamStandings;
                Object object4 = StringsKt.firstOrNull((CharSequence)hockeyTeamStanding.getStreak().getKind());
                object4 = object4 == null ? "" : Character.valueOf(Character.toUpperCase(((Character)object4).charValue()));
                objectArray[n3] = object4;
                objectArray[1] = hockeyTeamStanding.getStreak().getLength();
                String string4 = String.format((String)object, Arrays.copyOf(objectArray, n));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(this, *args)");
                object2.setText((CharSequence)string4);
            }
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Type.values().length];
                nArray[Type.Basketball.ordinal()] = 1;
                nArray[Type.Baseball.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

