/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.SoundPool;
import io.streamlayer.common.data.notifications.NotificationUtil;
import io.streamlayer.common.data.notifications.NotificationUtilKt;
import io.streamlayer.common.session.Session;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.analytics.AnalyticsDataKt;
import io.streamlayer.sdk.model.analytics.CommonKind;
import io.streamlayer.sdk.model.analytics.NotificationKind;
import io.streamlayer.sdk.model.analytics.NotificationType;
import io.streamlayer.sdk.model.calls.WatchParty;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.Topic;
import io.streamlayer.sdk.model.messaging.WaveMessage;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.notifications.NotificationKt;
import io.streamlayer.sdk.model.predictions.QuestionNotification;
import io.streamlayer.sdk.model.sdksettings.ClientSettings;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.analytics.AnalyticsRepo;
import io.streamlayer.sdk.repository.notifications.NotificationRepo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B)\b\u0007\u0012\u0006\u0010+\u001a\u00020*\u0012\u0006\u0010<\u001a\u00020;\u0012\u0006\u00102\u001a\u000201\u0012\u0006\u00109\u001a\u000208\u00a2\u0006\u0004\bE\u0010FJ\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fJ\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011J\u0016\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0019J\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001cJ\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010 \u001a\u00020\u0004J\u0016\u0010#\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u0016R\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00160$8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0016\u0010(\u001a\u00020'8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010+\u001a\u00020*8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0016\u0010-\u001a\u00020'8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010)R\u0016\u0010/\u001a\u00020.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0016\u00102\u001a\u0002018\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u001e\u00106\u001a\n 5*\u0004\u0018\u000104048\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0016\u00109\u001a\u0002088\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0016\u0010<\u001a\u00020;8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0018\u0010@\u001a\u0004\u0018\u00010\u00168B@\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0018\u0010D\u001a\u0004\u0018\u00010A8B@\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010C\u00a8\u0006G"}, d2={"Lio/streamlayer/common/data/notifications/InAppNotificationsService;", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "notification", "", "showNotification", "showInAppNotification", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "type", "", "isSoundEnabled", "playNotificationSound", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "chatMessage", "notifyChatMessage", "Lio/streamlayer/sdk/model/calls/WatchParty;", "watchParty", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "inviterContact", "notifyWatchParty", "Lio/streamlayer/sdk/model/predictions/QuestionNotification;", "questionNotification", "", "questionId", "notifyPrediction", "Lio/streamlayer/sdk/model/social/Tweet;", "tweet", "notifyTweet", "Lio/streamlayer/sdk/model/messaging/WaveMessage;", "waveMessage", "notifyWaveMessage", "playSound", "disconnect", "pause", "chatId", "pauseNotifications", "", "pausedTopicsNotifications", "Ljava/util/List;", "", "messageSound", "I", "Landroid/content/Context;", "context", "Landroid/content/Context;", "generalSound", "", "lastTimestampSoundPlayed", "J", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "notificationsRepo", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "Landroid/media/SoundPool;", "kotlin.jvm.PlatformType", "soundPool", "Landroid/media/SoundPool;", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "analyticsRepo", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "Lio/streamlayer/common/session/Session;", "session", "Lio/streamlayer/common/session/Session;", "getTinodeUserId", "()Ljava/lang/String;", "tinodeUserId", "Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "getSettings", "()Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "settings", "<init>", "(Landroid/content/Context;Lio/streamlayer/common/session/Session;Lio/streamlayer/sdk/repository/notifications/NotificationRepo;Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;)V", "sdk_originalRelease"})
public final class InAppNotificationsService {
    @NotNull
    private final Context context;
    @NotNull
    private final Session session;
    @NotNull
    private final NotificationRepo notificationsRepo;
    @NotNull
    private final AnalyticsRepo analyticsRepo;
    @NotNull
    private final List<String> pausedTopicsNotifications;
    private long lastTimestampSoundPlayed;
    private final SoundPool soundPool;
    private final int generalSound;
    private final int messageSound;

    @Inject
    public InAppNotificationsService(@NotNull Context context, @NotNull Session session, @NotNull NotificationRepo notificationRepo, @NotNull AnalyticsRepo analyticsRepo) {
        InAppNotificationsService inAppNotificationsService = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)notificationRepo, (String)"notificationsRepo");
        Intrinsics.checkNotNullParameter((Object)analyticsRepo, (String)"analyticsRepo");
        this.context = context;
        this.session = session;
        this.notificationsRepo = notificationRepo;
        inAppNotificationsService.analyticsRepo = analyticsRepo;
        inAppNotificationsService.pausedTopicsNotifications = new ArrayList<String>();
        session = new SoundPool.Builder().setMaxStreams(2).setAudioAttributes(new AudioAttributes.Builder().setUsage(5).setContentType(4).build()).build();
        this.soundPool = session;
        this.generalSound = session.load(context, R.raw.slr_general_notification, 1);
        inAppNotificationsService.messageSound = session.load(context, R.raw.slr_message_notification, 1);
    }

    private final String getTinodeUserId() {
        return this.session.getTinodeUserId();
    }

    private final ClientSettings getSettings() {
        return this.session.getClientSettings();
    }

    private final void showNotification(Notification notification) {
        NotificationUtil notificationUtil = NotificationUtil.INSTANCE;
        if (notificationUtil.isNotificationEnabled$sdk_originalRelease(this.session, notification) && notificationUtil.isAppInForeground()) {
            this.showInAppNotification(notification);
        }
    }

    private final void showInAppNotification(Notification object) {
        if (ArraysKt.contains((Object[])new io.streamlayer.sdk.model.notifications.NotificationType[]{io.streamlayer.sdk.model.notifications.NotificationType.WatchParty, io.streamlayer.sdk.model.notifications.NotificationType.WaveReply}, (Object)((Object)object.getType()))) {
            object2.notificationsRepo.upsertNotificationBySourceId((Notification)object);
        } else {
            object2.notificationsRepo.saveNotification((Notification)object);
        }
        InAppNotificationsService inAppNotificationsService = object2;
        inAppNotificationsService.playSound(object.getType());
        Notification notification = object;
        Object object2 = NotificationType.IN_APP;
        object = AnalyticsDataKt.toKind(notification.getType());
        CommonKind commonKind = CommonKind.NOTIFICATION_RECEIVED;
        String string = NotificationKt.getTopicId(notification);
        AnalyticsRepo.DefaultImpls.triggerNotificationEvent$default(inAppNotificationsService.analyticsRepo, (NotificationType)((Object)object2), (NotificationKind)((Object)object), commonKind, null, string, 8, null);
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isSoundEnabled(io.streamlayer.sdk.model.notifications.NotificationType var1_1) {
        switch (WhenMappings.$EnumSwitchMapping$0[var1_1.ordinal()]) lbl-1000:
        // 4 sources

        {
            default: {
                v0 = true;
                break;
            }
lbl5:
            // 4 sources

            case 4: {
                v0 = false;
                break;
            }
            case 3: {
                if ((this = this.getSettings()) == null || !this.getFriendsSound()) ** GOTO lbl5
                ** GOTO lbl-1000
            }
            case 2: {
                if ((this = this.getSettings()) == null || !this.getCallsSound()) ** GOTO lbl5
                ** GOTO lbl-1000
            }
            case 1: {
                if ((this = this.getSettings()) == null || !this.getMessagesSound()) ** GOTO lbl5
                ** GOTO lbl-1000
            }
        }
        return v0;
    }

    private final void playNotificationSound(io.streamlayer.sdk.model.notifications.NotificationType notificationType) {
        long l = System.currentTimeMillis();
        if (l > this.lastTimestampSoundPlayed + (long)1200) {
            this.lastTimestampSoundPlayed = l;
            int n = WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()] == 1 ? this.messageSound : this.generalSound;
            this.soundPool.play(n, 1.0f, 1.0f, 0, 0, 1.0f);
        }
    }

    public final void notifyChatMessage(@NotNull ChatMessage object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"chatMessage");
        if (!NotificationUtil.INSTANCE.isAppInForeground()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)((ChatMessage)object).getSenderUserId(), (Object)this.getTinodeUserId()) && !StringsKt.isBlank((CharSequence)((ChatMessage)object).getText())) {
            ChatMessage chatMessage = object;
            object = chatMessage.getTopicId();
            Notification notification = NotificationUtilKt.toNotification$default(chatMessage, null, 1, null);
            if (!this.pausedTopicsNotifications.contains(object)) {
                this.session.incrementTotalUnreadMessagesCount();
                this.showNotification(notification);
            }
            return;
        }
    }

    public final void notifyWatchParty(@NotNull WatchParty object, @Nullable TinodeContact object2) {
        Notification notification;
        Date date;
        WatchParty watchParty = object;
        Intrinsics.checkNotNullParameter((Object)watchParty, (String)"watchParty");
        Topic topic2 = watchParty.getData();
        String string2 = topic2.getChatId();
        Long l = null;
        Object object3 = this.context;
        int n = R.string.slr_s_is_having_a_watch_party;
        Object object4 = new Object[1];
        int n2 = 0;
        Object object5 = object2 == null ? null : ((TinodeContact)object2).getChatName();
        WatchParty watchParty2 = object;
        object4[n2] = object5;
        object = object3.getString(n, object4);
        object3 = watchParty2.getStreamTitle();
        String string3 = io.streamlayer.sdk.model.notifications.NotificationType.WatchParty.name();
        object4 = date;
        date = new Date();
        String string4 = Intrinsics.stringPlus((String)"topic_", (Object)topic2.getChatId());
        if (object2 == null) {
            object2 = null;
        } else {
            TinodeContact tinodeContact = object2;
            object2 = NotificationIcon.Companion;
            object5 = tinodeContact.getPhotoData();
            String string5 = tinodeContact.getChatName();
            if (string5 == null) {
                string5 = "";
            }
            object2 = ((NotificationIcon.Companion)object2).buildAvatarIcon((String)object5, string5);
        }
        object5 = notification;
        notification = new Notification(l, (String)object, (String)object3, string3, (Date)object4, string4, topic2, (NotificationIcon)object2);
        if (!this.pausedTopicsNotifications.contains(string2)) {
            this.showNotification((Notification)object5);
        }
    }

    public final void notifyPrediction(@NotNull QuestionNotification questionNotification, @NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)questionNotification, (String)"questionNotification");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"questionId");
        this.showNotification(NotificationUtilKt.toNotification(questionNotification, string3));
    }

    public final void notifyTweet(@NotNull Tweet tweet) {
        Tweet tweet2 = tweet;
        Intrinsics.checkNotNullParameter((Object)tweet2, (String)"tweet");
        this.showNotification(NotificationUtilKt.toNotification(tweet2));
    }

    public final void notifyWaveMessage(@NotNull WaveMessage waveMessage) {
        Intrinsics.checkNotNullParameter((Object)waveMessage, (String)"waveMessage");
        String string2 = this.context.getString(R.string.slr_wave_reply_message, new Object[]{waveMessage.getUserName()});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.string.slr_wave_reply_message, waveMessage.userName)");
        this.showNotification(NotificationUtilKt.toNotification(waveMessage, string2));
    }

    public final void playSound(@NotNull io.streamlayer.sdk.model.notifications.NotificationType notificationType) {
        io.streamlayer.sdk.model.notifications.NotificationType notificationType2 = notificationType;
        Intrinsics.checkNotNullParameter((Object)((Object)notificationType2), (String)"type");
        if (!this.isSoundEnabled(notificationType2)) {
            return;
        }
        this.playNotificationSound(notificationType);
    }

    public final void disconnect() {
        this.notificationsRepo.deleteAllNotifications();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void pauseNotifications(boolean bl, @NotNull String string2) {
        InAppNotificationsService inAppNotificationsService;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"chatId");
        if (bl) {
            this.pausedTopicsNotifications.add(string2);
            return;
        }
        try {
            inAppNotificationsService = this;
        }
        catch (Throwable throwable) {
            Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return;
        }
        {
            Result.constructor-impl((Object)inAppNotificationsService.pausedTopicsNotifications.remove(string2));
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[io.streamlayer.sdk.model.notifications.NotificationType.values().length];
            nArray[io.streamlayer.sdk.model.notifications.NotificationType.Chat.ordinal()] = 1;
            nArray[io.streamlayer.sdk.model.notifications.NotificationType.WatchParty.ordinal()] = 2;
            nArray[io.streamlayer.sdk.model.notifications.NotificationType.ArrivingFriend.ordinal()] = 3;
            nArray[io.streamlayer.sdk.model.notifications.NotificationType.WaveReply.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

