/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.notifications;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.drawable.LayerDrawable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemNotificationBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationCustomBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationPredictionsBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationWatchPartyBinding;
import io.streamlayer.sdk.main.notifications.NotificationsAdapter;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationBuilder;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.notifications.NotificationKt;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.predictions.view.ExtensionsKt;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006)*+,-.B\u0015\u0012\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\"\u00a2\u0006\u0004\b'\u0010(J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0003J\u0014\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\u0014\u0010\u0016\u001a\u00020\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0003J\u0014\u0010\u0018\u001a\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010R\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u001aR$\u0010\u001c\u001a\u0004\u0018\u00010\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\"8\u0006@\u0006\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\u00a8\u0006/"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "", "position", "getItemViewType", "Landroid/view/ViewGroup;", "parent", "viewType", "onCreateViewHolder", "holder", "", "onBindViewHolder", "getItemCount", "Lio/streamlayer/sdk/model/notifications/Notification;", "getItem", "", "listItems", "setItems", "getItemsList", "notifications", "", "clearItems", "getItemAndRemove", "updateItems", "", "Ljava/util/List;", "Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$OnItemInteractionListener;", "listener", "Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$OnItemInteractionListener;", "getListener", "()Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$OnItemInteractionListener;", "setListener", "(Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$OnItemInteractionListener;)V", "Lkotlin/Function0;", "getOverlayHeight", "Lkotlin/jvm/functions/Function0;", "getGetOverlayHeight", "()Lkotlin/jvm/functions/Function0;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "NotificationCallViewHolder", "NotificationCustomViewHolder", "NotificationDiffUtilCallback", "NotificationPredictionsViewHolder", "NotificationViewHolder", "OnItemInteractionListener", "sdk_originalRelease"})
public final class NotificationsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    private final Function0<Integer> getOverlayHeight;
    @NotNull
    private List<Notification> listItems;
    @Nullable
    private OnItemInteractionListener listener;

    public NotificationsAdapter(@NotNull Function0<Integer> function0) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(function0, (String)"getOverlayHeight");
        object.getOverlayHeight = function0;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.listItems = object;
    }

    @NotNull
    public final Function0<Integer> getGetOverlayHeight() {
        return this.getOverlayHeight;
    }

    @Nullable
    public final OnItemInteractionListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable OnItemInteractionListener onItemInteractionListener) {
        this.listener = onItemInteractionListener;
    }

    public int getItemViewType(int n) {
        int n2 = WhenMappings.$EnumSwitchMapping$0[this.getItem(n).getType().ordinal()];
        return n2 != 1 ? (n2 != 2 ? (n2 != 3 ? 1 : 3) : 4) : 2;
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup object, int n) {
        RecyclerView.ViewHolder viewHolder;
        ViewGroup viewGroup = object;
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        LayoutInflater layoutInflater = LayoutInflater.from((Context)viewGroup.getContext());
        switch (n) {
            default: {
                throw new RuntimeException(Intrinsics.stringPlus((String)"Invalid ViewHolder type: ", (Object)n));
            }
            case 4: {
                NotificationPredictionsViewHolder notificationPredictionsViewHolder;
                viewHolder = notificationPredictionsViewHolder;
                object = SlrItemNotificationPredictionsBinding.inflate(layoutInflater, object, false);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                notificationPredictionsViewHolder = new NotificationPredictionsViewHolder(notificationsAdapter2, (SlrItemNotificationPredictionsBinding)object);
                break;
            }
            case 3: {
                NotificationCustomViewHolder notificationCustomViewHolder;
                viewHolder = notificationCustomViewHolder;
                object = SlrItemNotificationCustomBinding.inflate(layoutInflater, object, false);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                notificationCustomViewHolder = notificationsAdapter2.new NotificationCustomViewHolder((SlrItemNotificationCustomBinding)object);
                break;
            }
            case 2: {
                NotificationCallViewHolder notificationCallViewHolder;
                viewHolder = notificationCallViewHolder;
                object = SlrItemNotificationWatchPartyBinding.inflate(layoutInflater, object, false);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                notificationCallViewHolder = notificationsAdapter2.new NotificationCallViewHolder((SlrItemNotificationWatchPartyBinding)object);
                break;
            }
            case 1: {
                NotificationViewHolder notificationViewHolder;
                viewHolder = notificationViewHolder;
                object = SlrItemNotificationBinding.inflate(layoutInflater, object, false);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                notificationViewHolder = notificationsAdapter2.new NotificationViewHolder((SlrItemNotificationBinding)object);
            }
        }
        Context context = viewHolder.itemView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"it.itemView.context");
        if (!OtherExtensionsKt.isScreenPortrait(context) && n != 4) {
            NotificationsAdapter notificationsAdapter2 = viewHolder.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)notificationsAdapter2), (String)"it.itemView");
            object = notificationsAdapter2.getLayoutParams();
            if (object != null) {
                object.width = (int)viewHolder.itemView.getContext().getResources().getDimension(R.dimen.slr_notification_landscape_width);
                notificationsAdapter2.setLayoutParams((ViewGroup.LayoutParams)object);
            } else {
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
            }
        }
        return viewHolder;
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"holder");
        Object object = object.listItems.get(n);
        if (viewHolder instanceof NotificationViewHolder) {
            ((NotificationViewHolder)viewHolder).bind((Notification)object);
        }
        if (viewHolder instanceof NotificationCallViewHolder) {
            ((NotificationCallViewHolder)viewHolder).bind((Notification)object);
        }
        if (viewHolder instanceof NotificationPredictionsViewHolder) {
            ((NotificationPredictionsViewHolder)viewHolder).bind((Notification)object);
        }
        if (viewHolder instanceof NotificationCustomViewHolder) {
            ((NotificationCustomViewHolder)viewHolder).bind((Notification)object);
        }
    }

    public int getItemCount() {
        return this.listItems.size();
    }

    @NotNull
    public final Notification getItem(int n) {
        return this.listItems.get(n);
    }

    public final void setItems(@NotNull List<Notification> list) {
        Intrinsics.checkNotNullParameter(list, (String)"listItems");
        if (!this.listItems.containsAll(list)) {
            NotificationsAdapter notificationsAdapter2 = this;
            notificationsAdapter2.listItems.clear();
            notificationsAdapter2.listItems.addAll(list);
            notificationsAdapter2.notifyDataSetChanged();
        }
    }

    @NotNull
    public final List<Notification> getItemsList() {
        return this.listItems;
    }

    public final boolean clearItems(@NotNull List<Notification> list) {
        Intrinsics.checkNotNullParameter(list, (String)"notifications");
        boolean bl = this.listItems.removeAll(list);
        this.notifyDataSetChanged();
        return bl;
    }

    @NotNull
    public final Notification getItemAndRemove(int n) {
        this.notifyItemRemoved(n);
        return this.listItems.remove(n);
    }

    public final boolean updateItems(@NotNull List<Notification> list) {
        Intrinsics.checkNotNullParameter(list, (String)"listItems");
        if (this.getItemCount() == 0) {
            this.setItems(CollectionsKt.sortedWith(list, new Comparator<T>(){

                public final int compare(T t, T t2) {
                    return ComparisonsKt.compareValues((Comparable)Boolean.valueOf(NotificationKt.isCallType(((Notification)t).getType()) ^ true), (Comparable)Boolean.valueOf(NotificationKt.isCallType(((Notification)t2).getType()) ^ true));
                }
            }));
            return true;
        }
        NotificationsAdapter notificationsAdapter2 = this;
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)notificationsAdapter2.new NotificationDiffUtilCallback(notificationsAdapter2.listItems, list));
        NotificationsAdapter notificationsAdapter3 = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(NotificationDiffUtilCallback(this.listItems, listItems))");
        notificationsAdapter3.setItems(CollectionsKt.sortedWith(list, new Comparator<T>(){

            public final int compare(T t, T t2) {
                return ComparisonsKt.compareValues((Comparable)Boolean.valueOf(NotificationKt.isCallType(((Notification)t).getType()) ^ true), (Comparable)Boolean.valueOf(NotificationKt.isCallType(((Notification)t2).getType()) ^ true));
            }
        }));
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)notificationsAdapter3);
        return false;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002R\u0019\u0010\u0007\u001a\u00020\u00068\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$NotificationCustomViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;)V", "sdk_originalRelease"})
    public final class NotificationCustomViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemNotificationCustomBinding binding;

        public NotificationCustomViewHolder(SlrItemNotificationCustomBinding slrItemNotificationCustomBinding) {
            Intrinsics.checkNotNullParameter((Object)((Object)NotificationsAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationCustomBinding, (String)"binding");
            super((View)slrItemNotificationCustomBinding.getRoot());
            this.binding = slrItemNotificationCustomBinding;
        }

        private static final void bind$lambda-4$lambda-3(NotificationsAdapter object, Notification notification, View view2) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"$data");
            object = ((NotificationsAdapter)((Object)object)).getListener();
            if (object != null) {
                object.onNotificationClick(notification);
            }
        }

        @NotNull
        public final SlrItemNotificationCustomBinding getBinding() {
            return this.binding;
        }

        public final void bind(@NotNull Notification notification) {
            block8: {
                block7: {
                    Notification notification2 = notification;
                    Intrinsics.checkNotNullParameter((Object)notification2, (String)"data");
                    NotificationBuilder notificationBuilder = notification2.getCustomBuilder();
                    if (notificationBuilder == null) break block7;
                    NotificationCustomViewHolder notificationCustomViewHolder = notificationCustomViewHolder2;
                    NotificationsAdapter notificationsAdapter2 = notificationCustomViewHolder.NotificationsAdapter.this;
                    Object object = LayoutInflater.from((Context)notificationCustomViewHolder.itemView.getContext());
                    if (notificationBuilder.getLayoutId() != null) {
                        Integer n = notificationBuilder.getLayoutId();
                        Intrinsics.checkNotNull((Object)n);
                        object = object.inflate(n.intValue(), (ViewGroup)notificationCustomViewHolder2.getBinding().getRoot(), false);
                    } else {
                        object = SlrItemNotificationBinding.inflate(object, (ViewGroup)notificationCustomViewHolder2.getBinding().getRoot(), false);
                        object.slNotifTitleTV.setText((CharSequence)notificationBuilder.getTitle());
                        object.slNotifDescriptionTV.setText((CharSequence)notificationBuilder.getDescription());
                        Object object2 = notificationBuilder.getIconBackgroundColor();
                        if (object2 != null) {
                            int n = ((Number)object2).intValue();
                            object.slNotifIconIV.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)notificationCustomViewHolder2.itemView.getContext(), (int)n)));
                        }
                        object2 = notificationBuilder.getIconUrl();
                        if (object2 != null) {
                            AppCompatImageView appCompatImageView = object.slNotifIconIV;
                            Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                            ViewExtensionsKt.loadUrl$default((ImageView)appCompatImageView, (String)object2, false, null, null, 14, null);
                        }
                        object = notificationCustomViewHolder2.getBinding().getRoot();
                    }
                    Object object3 = object;
                    notificationCustomViewHolder2.getBinding().getRoot().addView((View)object);
                    object3.setOnClickListener(arg_0 -> NotificationCustomViewHolder.bind$lambda-4$lambda-3(notificationsAdapter2, notification, arg_0));
                    NotificationCustomViewHolder notificationCustomViewHolder2 = object3.getLayoutParams();
                    if (notificationCustomViewHolder2 == null) break block8;
                    Object object4 = object;
                    notificationCustomViewHolder2 = (FrameLayout.LayoutParams)notificationCustomViewHolder2;
                    v6.gravity = 80;
                    object4.setLayoutParams((ViewGroup.LayoutParams)notificationCustomViewHolder2);
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"view");
                    notificationBuilder.bindView((View)object);
                }
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0087\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0003J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0003J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007R\u0019\u0010\f\u001a\u00020\u000b8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$NotificationViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "type", "", "getIcon", "getColor", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;)V", "sdk_originalRelease"})
    @SuppressLint(value={"ClickableViewAccessibility"})
    public final class NotificationViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemNotificationBinding binding;

        public NotificationViewHolder(SlrItemNotificationBinding slrItemNotificationBinding) {
            Intrinsics.checkNotNullParameter((Object)((Object)NotificationsAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationBinding, (String)"binding");
            super((View)slrItemNotificationBinding.getRoot());
            this.binding = slrItemNotificationBinding;
            slrItemNotificationBinding.getRoot().setOnTouchListener(NotificationViewHolder::_init_$lambda-0);
        }

        @DrawableRes
        private final int getIcon(NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 9: 
                case 10: {
                    n = 0;
                    break;
                }
                case 7: 
                case 8: {
                    n = R.drawable.slr_ic_profile;
                    break;
                }
                case 6: {
                    n = R.drawable.slr_ic_chat;
                    break;
                }
                case 5: {
                    n = R.drawable.slr_ic_twitter;
                    break;
                }
                case 4: {
                    n = R.drawable.slr_ic_chat;
                    break;
                }
                case 3: {
                    n = R.drawable.slr_ic_betting;
                    break;
                }
                case 2: {
                    n = R.drawable.slr_ic_watch_party_centered;
                    break;
                }
                case 1: {
                    n = R.drawable.slr_ic_chat;
                }
            }
            return n;
        }

        @ColorRes
        private final int getColor(NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 10: {
                    n = 0;
                    break;
                }
                case 7: 
                case 8: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 6: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 5: {
                    n = R.color.slr_twitter;
                    break;
                }
                case 4: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 3: {
                    n = R.color.slr_orange;
                    break;
                }
                case 2: 
                case 9: {
                    n = 17170445;
                    break;
                }
                case 1: {
                    n = R.color.slr_primaryBlue;
                }
            }
            return n;
        }

        private static final boolean _init_$lambda-0(View view2, MotionEvent motionEvent) {
            return false;
        }

        private static final void bind$lambda-4$lambda-3(NotificationsAdapter object, Notification notification, View view2) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"$data");
            object = ((NotificationsAdapter)((Object)object)).getListener();
            if (object != null) {
                object.onNotificationClick(notification);
            }
        }

        @NotNull
        public final SlrItemNotificationBinding getBinding() {
            return this.binding;
        }

        public final void bind(@NotNull Notification notification) {
            Unit unit;
            ConstraintSet constraintSet;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationBinding slrItemNotificationBinding = this.binding;
            NotificationsAdapter notificationsAdapter2 = NotificationsAdapter.this;
            slrItemNotificationBinding.slNotifTitleTV.setText((CharSequence)notification.getTitle());
            Object object = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"slNotifTitleTV");
            String string2 = notification.getTitle();
            boolean bl = string2 == null || string2.length() == 0;
            ViewExtensionsKt.visibleIf((View)object, bl ^ true);
            slrItemNotificationBinding.slNotifDescriptionTV.setText((CharSequence)notification.getDescription());
            object = constraintSet;
            object();
            constraintSet.clone(slrItemNotificationBinding.slNotification);
            String string3 = notification.getDescription();
            boolean bl2 = string3 == null || string3.length() == 0;
            if (bl2) {
                object.connect(slrItemNotificationBinding.slNotifTitleTV.getId(), 3, slrItemNotificationBinding.slNotifIconIV.getId(), 3);
                object.connect(slrItemNotificationBinding.slNotifTitleTV.getId(), 4, slrItemNotificationBinding.slNotifIconIV.getId(), 4);
            } else {
                int n = ViewExtensionsKt.getDp(4.0f);
                object.connect(slrItemNotificationBinding.slNotifTitleTV.getId(), 3, 0, 3, n);
            }
            object.applyTo(slrItemNotificationBinding.slNotification);
            object = slrItemNotificationBinding.slNotifDescriptionTV;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"slNotifDescriptionTV");
            String string4 = notification.getDescription();
            boolean bl3 = string4 == null || string4.length() == 0;
            ViewExtensionsKt.visibleIf((View)object, bl3 ^ true);
            object = notification.getNotificationIcon();
            if (object == null) {
                unit = null;
            } else {
                if (((NotificationIcon)object).getAvatarName() != null) {
                    AppCompatImageView appCompatImageView = slrItemNotificationBinding.slNotifIconIV;
                    Object object2 = object;
                    Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                    object = ((NotificationIcon)object2).getAvatarUrl();
                    ProfileExtensionsKt.loadUserAvatar$default((ImageView)appCompatImageView, (String)object, ((NotificationIcon)object2).getAvatarName(), null, 4, null);
                } else if (((NotificationIcon)object).getAvatarUrl() != null) {
                    AppCompatImageView appCompatImageView = slrItemNotificationBinding.slNotifIconIV;
                    Object object3 = appCompatImageView;
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"slNotifIconIV");
                    object = ((NotificationIcon)object).getAvatarUrl();
                    Intrinsics.checkNotNull((Object)object);
                    object3 = this.getIcon(notification.getType());
                    ViewExtensionsKt.loadUrl$default((ImageView)appCompatImageView, (String)object, false, (Integer)object3, null, 10, null);
                }
                slrItemNotificationBinding.slNotifIconIV.setBackgroundTintList(null);
                unit = Unit.INSTANCE;
            }
            if (unit == null) {
                SlrItemNotificationBinding slrItemNotificationBinding2 = slrItemNotificationBinding;
                slrItemNotificationBinding2.slNotifIconIV.setImageResource(this.getIcon(notification.getType()));
                slrItemNotificationBinding2.slNotifIconIV.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)this.itemView.getContext(), (int)this.getColor(notification.getType()))));
            }
            slrItemNotificationBinding.slNotification.setOnClickListener(arg_0 -> NotificationViewHolder.bind$lambda-4$lambda-3(notificationsAdapter2, notification, arg_0));
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NotificationType.values().length];
                nArray[NotificationType.Chat.ordinal()] = 1;
                nArray[NotificationType.WatchParty.ordinal()] = 2;
                nArray[NotificationType.Inplay.ordinal()] = 3;
                nArray[NotificationType.Universal.ordinal()] = 4;
                nArray[NotificationType.Twitter.ordinal()] = 5;
                nArray[NotificationType.Alert.ordinal()] = 6;
                nArray[NotificationType.WaveReply.ordinal()] = 7;
                nArray[NotificationType.ArrivingFriend.ordinal()] = 8;
                nArray[NotificationType.Prediction.ordinal()] = 9;
                nArray[NotificationType.Custom.ordinal()] = 10;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0087\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002R\u0019\u0010\u0007\u001a\u00020\u00068\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$NotificationCallViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;)V", "sdk_originalRelease"})
    @SuppressLint(value={"ClickableViewAccessibility"})
    public final class NotificationCallViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemNotificationWatchPartyBinding binding;

        public NotificationCallViewHolder(SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding) {
            Intrinsics.checkNotNullParameter((Object)((Object)NotificationsAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationWatchPartyBinding, (String)"binding");
            super((View)slrItemNotificationWatchPartyBinding.getRoot());
            this.binding = slrItemNotificationWatchPartyBinding;
            slrItemNotificationWatchPartyBinding.getRoot().setOnTouchListener(NotificationCallViewHolder::_init_$lambda-0);
        }

        private static final boolean _init_$lambda-0(View view2, MotionEvent motionEvent) {
            return false;
        }

        private static final void bind$lambda-2$lambda-1(NotificationsAdapter object, Notification notification, View view2) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"$data");
            object = ((NotificationsAdapter)((Object)object)).getListener();
            if (object != null) {
                object.onNotificationClick(notification);
            }
        }

        @NotNull
        public final SlrItemNotificationWatchPartyBinding getBinding() {
            return this.binding;
        }

        public final void bind(@NotNull Notification notification) {
            NotificationCallViewHolder notificationCallViewHolder = slrItemNotificationWatchPartyBinding;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding = notificationCallViewHolder.binding;
            NotificationsAdapter notificationsAdapter2 = notificationCallViewHolder.NotificationsAdapter.this;
            SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding2 = slrItemNotificationWatchPartyBinding;
            slrItemNotificationWatchPartyBinding2.slNotifTitleTV.setText((CharSequence)notification.getTitle());
            slrItemNotificationWatchPartyBinding2.slNotifDescriptionTV.setText((CharSequence)notification.getDescription());
            if (WhenMappings.$EnumSwitchMapping$0[notification.getType().ordinal()] == 1) {
                AppCompatImageView appCompatImageView = slrItemNotificationWatchPartyBinding.slNotifIconIV;
                Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                Object object = notification.getNotificationIcon();
                object = object == null ? null : ((NotificationIcon)object).getAvatarUrl();
                Object object2 = notification.getNotificationIcon();
                object2 = object2 == null ? null : ((NotificationIcon)object2).getAvatarName();
                ProfileExtensionsKt.loadUserAvatar$default((ImageView)appCompatImageView, (String)object, (String)object2, null, 4, null);
            } else {
                slrItemNotificationWatchPartyBinding.slNotifIconIV.setImageResource(R.drawable.slr_ic_watch_party_centered);
            }
            slrItemNotificationWatchPartyBinding.getRoot().setOnClickListener(arg_0 -> NotificationCallViewHolder.bind$lambda-2$lambda-1(notificationsAdapter2, notification, arg_0));
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NotificationType.values().length];
                nArray[NotificationType.WatchParty.ordinal()] = 1;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0016J\b\u0010\u0007\u001a\u00020\u0002H\u0016J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0016R\u001f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$NotificationDiffUtilCallback;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "", "oldItemPosition", "newItemPosition", "", "areItemsTheSame", "getOldListSize", "getNewListSize", "areContentsTheSame", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "newList", "Ljava/util/List;", "getNewList", "()Ljava/util/List;", "oldList", "getOldList", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;Ljava/util/List;Ljava/util/List;)V", "sdk_originalRelease"})
    public final class NotificationDiffUtilCallback
    extends DiffUtil.Callback {
        @NotNull
        private final List<Notification> oldList;
        @NotNull
        private final List<Notification> newList;

        public NotificationDiffUtilCallback(@NotNull List<Notification> list, List<Notification> list2) {
            Intrinsics.checkNotNullParameter((Object)((Object)NotificationsAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter(list, (String)"oldList");
            Intrinsics.checkNotNullParameter(list2, (String)"newList");
            this.oldList = list;
            this.newList = list2;
        }

        @NotNull
        public final List<Notification> getOldList() {
            return this.oldList;
        }

        @NotNull
        public final List<Notification> getNewList() {
            return this.newList;
        }

        public boolean areItemsTheSame(int n, int n2) {
            return Intrinsics.areEqual((Object)this.oldList.get(n).getSourceUniqueId(), (Object)this.newList.get(n2).getSourceUniqueId());
        }

        public int getOldListSize() {
            return this.oldList.size();
        }

        public int getNewListSize() {
            return this.newList.size();
        }

        public boolean areContentsTheSame(int n, int n2) {
            Notification notification = object.oldList.get(n);
            Object object = object.newList.get(n2);
            return notification.getType() == notification.getType() && Intrinsics.areEqual((Object)notification, (Object)object);
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a8\u0006\u0006"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$OnItemInteractionListener;", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "notification", "", "onNotificationClick", "sdk_originalRelease"})
    public static interface OnItemInteractionListener {
        public void onNotificationClick(@NotNull Notification var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007R\u0016\u0010\u000b\u001a\u00020\n8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$NotificationPredictionsViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "", "visible", "", "setNotificationVisible", "setPadding", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "bind", "Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsBinding;)V", "sdk_originalRelease"})
    public final class NotificationPredictionsViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemNotificationPredictionsBinding binding;
        final /* synthetic */ NotificationsAdapter this$0;

        public NotificationPredictionsViewHolder(@NotNull NotificationsAdapter notificationsAdapter2, SlrItemNotificationPredictionsBinding slrItemNotificationPredictionsBinding) {
            block7: {
                block6: {
                    block5: {
                        NotificationPredictionsViewHolder notificationPredictionsViewHolder = this;
                        Intrinsics.checkNotNullParameter((Object)((Object)notificationsAdapter2), (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)slrItemNotificationPredictionsBinding, (String)"binding");
                        this.this$0 = notificationsAdapter2;
                        super((View)slrItemNotificationPredictionsBinding.getRoot());
                        SlrItemNotificationPredictionsBinding slrItemNotificationPredictionsBinding2 = SlrItemNotificationPredictionsBinding.bind(notificationPredictionsViewHolder.itemView);
                        Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationPredictionsBinding2, (String)"bind(itemView)");
                        notificationPredictionsViewHolder.binding = slrItemNotificationPredictionsBinding2;
                        Context context = notificationPredictionsViewHolder.itemView.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"itemView.context");
                        if (!OtherExtensionsKt.isScreenPortrait(context)) break block5;
                        if (((Number)notificationsAdapter2.getGetOverlayHeight().invoke()).intValue() > 0) {
                            NotificationPredictionsViewHolder notificationPredictionsViewHolder2 = this;
                            notificationPredictionsViewHolder2.setPadding();
                            notificationPredictionsViewHolder2.setNotificationVisible(true);
                        } else {
                            NotificationPredictionsViewHolder notificationPredictionsViewHolder3 = this;
                            notificationPredictionsViewHolder3.setNotificationVisible(false);
                            notificationPredictionsViewHolder3.itemView.postDelayed(() -> NotificationPredictionsViewHolder._init_$lambda-0(this), 100L);
                        }
                        break block6;
                    }
                    notificationsAdapter2 = slrItemNotificationPredictionsBinding.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)notificationsAdapter2), (String)"binding.root");
                    slrItemNotificationPredictionsBinding = notificationsAdapter2.getLayoutParams();
                    if (slrItemNotificationPredictionsBinding == null) break block7;
                    ((ViewGroup.LayoutParams)slrItemNotificationPredictionsBinding).width = this.itemView.getResources().getDimensionPixelSize(R.dimen.slr_predictions_notification_landscape_width);
                    notificationsAdapter2.setLayoutParams((ViewGroup.LayoutParams)slrItemNotificationPredictionsBinding);
                    this.setNotificationVisible(true);
                }
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }

        private final void setNotificationVisible(boolean bl) {
            NotificationPredictionsViewHolder notificationPredictionsViewHolder = this;
            ConstraintLayout constraintLayout = notificationPredictionsViewHolder.binding.slNotification;
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.slNotification");
            ViewExtensionsKt.visibleIf((View)constraintLayout, bl);
            ImageView imageView = notificationPredictionsViewHolder.binding.slrNotificationIcon;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slrNotificationIcon");
            ViewExtensionsKt.visibleIf((View)imageView, bl);
            ImageView imageView2 = notificationPredictionsViewHolder.binding.slrLeftSide;
            Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"binding.slrLeftSide");
            ViewExtensionsKt.visibleIf((View)imageView2, bl);
        }

        private final void setPadding() {
            int n = ((Number)this.this$0.getGetOverlayHeight().invoke()).intValue() - this.itemView.getResources().getDimensionPixelSize(R.dimen.slr_prediction_notification_top_margin);
            this.binding.getRoot().setPadding(0, 0, 0, n);
        }

        private static final void _init_$lambda-0(NotificationPredictionsViewHolder notificationPredictionsViewHolder) {
            NotificationPredictionsViewHolder notificationPredictionsViewHolder2 = notificationPredictionsViewHolder;
            Intrinsics.checkNotNullParameter((Object)((Object)notificationPredictionsViewHolder2), (String)"this$0");
            notificationPredictionsViewHolder2.setPadding();
            notificationPredictionsViewHolder2.setNotificationVisible(true);
        }

        private static final void bind$lambda-4(NotificationsAdapter object, Notification notification, View view2) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"$data");
            object = ((NotificationsAdapter)((Object)object)).getListener();
            if (object != null) {
                object.onNotificationClick(notification);
            }
        }

        private static final void bind$lambda-8$lambda-7$lambda-6(ValueAnimator object, NotificationPredictionsViewHolder notificationPredictionsViewHolder, ValueAnimator valueAnimator) {
            Intrinsics.checkNotNullParameter((Object)((Object)notificationPredictionsViewHolder), (String)"this$0");
            object = object.getAnimatedValue();
            if (object != null) {
                int n = (Integer)object;
                valueAnimator = notificationPredictionsViewHolder.binding.slrNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"binding.slrNotificationIcon");
                boolean bl = n > ViewExtensionsKt.getDp(73.0f);
                ViewExtensionsKt.visibleIf((View)valueAnimator, bl);
                notificationPredictionsViewHolder = notificationPredictionsViewHolder.binding.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)notificationPredictionsViewHolder), (String)"binding.root");
                valueAnimator = notificationPredictionsViewHolder.getLayoutParams();
                if (valueAnimator != null) {
                    valueAnimator.width = n;
                    notificationPredictionsViewHolder.setLayoutParams((ViewGroup.LayoutParams)valueAnimator);
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }

        private static final void bind$lambda-8(NotificationPredictionsViewHolder notificationPredictionsViewHolder) {
            NotificationPredictionsViewHolder notificationPredictionsViewHolder2 = notificationPredictionsViewHolder;
            Intrinsics.checkNotNullParameter((Object)((Object)notificationPredictionsViewHolder2), (String)"this$0");
            int n = (int)notificationPredictionsViewHolder2.binding.getRoot().getContext().getResources().getDimension(R.dimen.slr_notification_landscape_width);
            int n2 = notificationPredictionsViewHolder2.binding.slrQuestionText.getWidth();
            ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, n});
            valueAnimator.setDuration(300L);
            valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(notificationPredictionsViewHolder, n2){
                final /* synthetic */ NotificationPredictionsViewHolder this$0;
                final /* synthetic */ int $textWidth;
                {
                    this.this$0 = notificationPredictionsViewHolder;
                    this.$textWidth = n;
                }

                public void onAnimationStart(@NotNull Animator animator) {
                    bind.4.1.1 v0 = this;
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"var1");
                    ConstraintLayout constraintLayout = NotificationPredictionsViewHolder.access$getBinding$p((NotificationPredictionsViewHolder)v0.this$0).slNotification;
                    Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.slNotification");
                    ViewExtensionsKt.visible((View)constraintLayout);
                    ImageView imageView = NotificationPredictionsViewHolder.access$getBinding$p((NotificationPredictionsViewHolder)v0.this$0).slrLeftSide;
                    Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slrLeftSide");
                    ViewExtensionsKt.visible((View)imageView);
                    animator = NotificationPredictionsViewHolder.access$getBinding$p((NotificationPredictionsViewHolder)v0.this$0).slrQuestionText;
                    Intrinsics.checkNotNullExpressionValue((Object)animator, (String)"binding.slrQuestionText");
                    int n = this.$textWidth;
                    ViewGroup.LayoutParams layoutParams = animator.getLayoutParams();
                    if (layoutParams != null) {
                        Animator animator2 = animator;
                        animator = (ConstraintLayout.LayoutParams)layoutParams;
                        ((ConstraintLayout.LayoutParams)layoutParams).width = n;
                        ((ConstraintLayout.LayoutParams)layoutParams).startToStart = -1;
                        animator2.setLayoutParams((ViewGroup.LayoutParams)animator);
                        return;
                    }
                    throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                }
            });
            valueAnimator.addUpdateListener(arg_0 -> NotificationPredictionsViewHolder.bind$lambda-8$lambda-7$lambda-6(valueAnimator, notificationPredictionsViewHolder, arg_0));
            valueAnimator.start();
        }

        public static final /* synthetic */ SlrItemNotificationPredictionsBinding access$getBinding$p(NotificationPredictionsViewHolder notificationPredictionsViewHolder) {
            return notificationPredictionsViewHolder.binding;
        }

        /*
         * Unable to fully structure code
         */
        public final void bind(@NotNull Notification var1_1) {
            block16: {
                block17: {
                    block15: {
                        block14: {
                            block13: {
                                v0 = this;
                                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"data");
                                v0.binding.slrQuestionText.setText((CharSequence)var1_1.getTitle());
                                var2_2 = v0.binding.slrNotificationIcon;
                                Intrinsics.checkNotNullExpressionValue((Object)var2_2, (String)"binding.slrNotificationIcon");
                                var3_4 = var1_1.getNotificationIcon();
                                if (var3_4 == null) {
                                    while (true) {
                                        var3_4 = "";
                                        break;
                                    }
                                } else if ((var3_4 = var3_4.getMeta()) == null || (var3_4 = var3_4.get("icon")) == null) ** continue;
                                ExtensionsKt.load((ImageView)var2_2, var3_4);
                                ** try [egrp 0[TRYBLOCK] [0 : 89->92)] { 
lbl14:
                                // 1 sources

                                var2_2 = var1_1.getDataJson();
                                if (var2_2 != null) break block13;
                                var2_2 = null;
                                break block14;
                            }
                            var2_2 = StringsKt.replace$default((String)var2_2, (String)"\"", (String)"", (boolean)false, (int)4, null);
                        }
                        try {
                            var2_2 = Result.constructor-impl((Object)Color.parseColor((String)var2_2));
                        }
lbl27:
                        // 4 sources

                        catch (Throwable v1) {
                            var2_2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)v1));
                        }
                        if (Result.isFailure-impl((Object)var2_2)) {
                            var2_2 = null;
                        }
                        if ((var2_2 = (Integer)var2_2) == null) break block15;
                        var2_3 = var2_2.intValue();
                        var3_4 = this.binding.slNotification.getBackground();
                        if (var3_4 == null) break block16;
                        ((LayerDrawable)var3_4).getDrawable(0).setTint(var2_3);
                        var3_4 = this.binding.slrLeftSide.getBackground();
                        if (var3_4 == null) break block17;
                        ((LayerDrawable)var3_4).getDrawable(0).setTint(var2_3);
                    }
                    v2 = this;
                    v2.binding.slNotification.setOnClickListener((View.OnClickListener)LambdaMetafactory.metafactory(null, null, null, (Landroid/view/View;)V, bind$lambda-4(io.streamlayer.sdk.main.notifications.NotificationsAdapter io.streamlayer.sdk.model.notifications.Notification android.view.View ), (Landroid/view/View;)V)((NotificationsAdapter)this.this$0, (Notification)var1_1));
                    v3 = v2.itemView.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"itemView.context");
                    if (!OtherExtensionsKt.isScreenPortrait(v3)) {
                        v4 = this;
                        v5 = v4.binding.slNotification;
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"binding.slNotification");
                        ViewExtensionsKt.invisible((View)v5);
                        v6 = v4.binding.slrNotificationIcon;
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"binding.slrNotificationIcon");
                        ViewExtensionsKt.invisible((View)v6);
                        v7 = v4.binding.slrLeftSide;
                        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"binding.slrLeftSide");
                        ViewExtensionsKt.invisible((View)v7);
                        v4.itemView.post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, bind$lambda-8(io.streamlayer.sdk.main.notifications.NotificationsAdapter$NotificationPredictionsViewHolder ), ()V)((NotificationPredictionsViewHolder)this));
                    }
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.LayerDrawable");
            }
            throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.LayerDrawable");
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationType.values().length];
            nArray[NotificationType.WatchParty.ordinal()] = 1;
            nArray[NotificationType.Prediction.ordinal()] = 2;
            nArray[NotificationType.Custom.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

