/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.predictions;

import androidx.fragment.app.Fragment;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.NavDirections;
import androidx.navigation.NavOptions;
import io.streamlayer.common.extensions.FragmentExtensionsKt;
import io.streamlayer.sdk.MainNavGraphDirections;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.base.OverlaySheetHandler;
import io.streamlayer.sdk.predictions.PredictionsRouter;
import io.streamlayer.sdk.predictions.PredictionsRouterState;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\b\u0010\u0003\u001a\u00020\u0002H\u0002J\u001a\u0010\b\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0002H\u0016R\u0016\u0010\u0012\u001a\u00020\u00118\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0019\u001a\u00020\u00188\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lio/streamlayer/sdk/predictions/PortraitPredictionsRouter;", "Lio/streamlayer/sdk/predictions/PredictionsRouter;", "", "closeUI", "", "predictionId", "Landroidx/navigation/NavOptions;", "navOptions", "openPredictions", "", "isUIOpened", "Landroidx/navigation/NavDestination;", "destination", "overlayNavChanged", "saveAndResetOverlayState", "closePredictions", "resetState", "Landroidx/fragment/app/Fragment;", "fragment", "Landroidx/fragment/app/Fragment;", "Lkotlin/Function0;", "Landroidx/navigation/NavController;", "getOverlayNavController", "Lkotlin/jvm/functions/Function0;", "Lio/streamlayer/sdk/base/OverlaySheetHandler;", "overlaySheetHandler", "Lio/streamlayer/sdk/base/OverlaySheetHandler;", "Lio/streamlayer/sdk/predictions/PredictionsRouterState;", "state", "<init>", "(Lio/streamlayer/sdk/predictions/PredictionsRouterState;Landroidx/fragment/app/Fragment;Lkotlin/jvm/functions/Function0;Lio/streamlayer/sdk/base/OverlaySheetHandler;)V", "sdk_originalRelease"})
public final class PortraitPredictionsRouter
extends PredictionsRouter {
    @NotNull
    private final Fragment fragment;
    @NotNull
    private final Function0<NavController> getOverlayNavController;
    @NotNull
    private final OverlaySheetHandler overlaySheetHandler;

    public PortraitPredictionsRouter(@NotNull PredictionsRouterState predictionsRouterState, @NotNull Fragment fragment, @NotNull Function0<? extends NavController> function0, @NotNull OverlaySheetHandler overlaySheetHandler) {
        Intrinsics.checkNotNullParameter((Object)predictionsRouterState, (String)"state");
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(function0, (String)"getOverlayNavController");
        Intrinsics.checkNotNullParameter((Object)overlaySheetHandler, (String)"overlaySheetHandler");
        super(predictionsRouterState);
        this.fragment = fragment;
        this.getOverlayNavController = function0;
        this.overlaySheetHandler = overlaySheetHandler;
    }

    private final void closeUI() {
        try {
            ((NavController)this.getOverlayNavController.invoke()).popBackStack(R.id.fragmentPredictions, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ((NavController)this.getOverlayNavController.invoke()).popBackStack(R.id.fragmentHome, false);
        }
    }

    @Override
    public void openPredictions(@NotNull String string2, @Nullable NavOptions navOptions) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"predictionId");
        if (Intrinsics.areEqual((Object)portraitPredictionsRouter2.getState().getPredictionId(), (Object)string2) && portraitPredictionsRouter2.isUIOpened()) {
            return;
        }
        PortraitPredictionsRouter portraitPredictionsRouter = portraitPredictionsRouter2;
        portraitPredictionsRouter.getState().setPredictionId(string2);
        portraitPredictionsRouter.overlaySheetHandler.showSheet(true);
        PortraitPredictionsRouter portraitPredictionsRouter2 = (NavController)portraitPredictionsRouter.getOverlayNavController.invoke();
        string2 = MainNavGraphDirections.Companion.actionPredictions(string2);
        if (navOptions == null) {
            navOptions = new NavOptions.Builder().setPopUpTo(R.id.fragmentHome, false).build();
            Intrinsics.checkNotNullExpressionValue((Object)navOptions, (String)"Builder().setPopUpTo(R.id.fragmentHome, false).build()");
        }
        portraitPredictionsRouter2.navigate((NavDirections)string2, navOptions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isUIOpened() {
        if (this.getState().getPredictionId() == null) return false;
        NavDestination navDestination = ((NavController)this.getOverlayNavController.invoke()).getCurrentDestination();
        if (navDestination == null) {
            return false;
        }
        if (navDestination.getId() != R.id.fragmentPredictions) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!this.overlaySheetHandler.isOverlayShown()) return false;
        return true;
    }

    @Override
    public void overlayNavChanged(@NotNull NavDestination navDestination) {
        Intrinsics.checkNotNullParameter((Object)navDestination, (String)"destination");
        if (this.getState().getPredictionId() != null && navDestination.getId() != R.id.fragmentHome && navDestination.getId() != R.id.fragmentPredictions && !this.getState().isUIOpened()) {
            this.closePredictions();
        }
    }

    @Override
    public boolean saveAndResetOverlayState() {
        boolean bl = this.isUIOpened();
        this.getState().setUIOpened(bl);
        if (bl) {
            PortraitPredictionsRouter portraitPredictionsRouter = this;
            portraitPredictionsRouter.closeUI();
            if (FragmentExtensionsKt.canUseBinding(portraitPredictionsRouter.fragment)) {
                this.overlaySheetHandler.showSheet(false);
            }
        }
        return bl;
    }

    @Override
    public void closePredictions(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"predictionId");
        ((NavController)this.getOverlayNavController.invoke()).navigateUp();
    }

    @Override
    public void resetState() {
        if (this.getState().getPredictionId() != null && this.getState().isUIOpened()) {
            PortraitPredictionsRouter portraitPredictionsRouter = this;
            portraitPredictionsRouter.getState().setUIOpened(false);
            String string2 = portraitPredictionsRouter.getState().getPredictionId();
            Intrinsics.checkNotNull((Object)string2);
            PredictionsRouter.openPredictions$default(portraitPredictionsRouter, string2, null, 2, null);
        }
    }
}

