/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.social.TweetMedia;
import io.streamlayer.sdk.twitter.Input;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001CB'\b\u0007\u0012\u0006\u0010=\u001a\u00020<\u0012\n\b\u0002\u0010?\u001a\u0004\u0018\u00010>\u0012\b\b\u0002\u0010@\u001a\u00020\u0003\u00a2\u0006\u0004\bA\u0010BJ\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002J \u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002J\b\u0010\r\u001a\u00020\u000bH\u0002J0\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u00020\u000bH\u0002J\u0016\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u001a\u0010!\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u001cH\u0002J0\u0010$\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J\u0018\u0010%\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0014J\u0010\u0010(\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020&H\u0016J\u0014\u0010)\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014R\u0016\u0010*\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R?\u00101\u001a\u001f\u0012\u0013\u0012\u00110-\u00a2\u0006\f\b.\u0012\b\b/\u0012\u0004\b\b(0\u0012\u0004\u0012\u00020\u000b\u0018\u00010,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001e\u00108\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0019078\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010:R\u0016\u0010;\u001a\u00020\u00038\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010+\u00a8\u0006D"}, d2={"Lio/streamlayer/sdk/twitter/view/TweetPhotoView;", "Landroid/view/ViewGroup;", "Landroid/view/View$OnClickListener;", "", "widthMeasureSpec", "heightMeasureSpec", "Lio/streamlayer/sdk/twitter/view/TweetPhotoView$Size;", "measureImages", "i", "width", "height", "", "measureImageView", "layoutImages", "left", "top", "right", "bottom", "layoutImage", "clearImageViews", "", "Lio/streamlayer/sdk/model/social/TweetMedia;", "mediaEntities", "initializeImageViews", "index", "Landroidx/appcompat/widget/AppCompatImageView;", "getOrCreateImageView", "mediaEntity", "", "getSizedImagePath", "Landroid/widget/ImageView;", "imageView", "imagePath", "setMediaImage", "", "changed", "onLayout", "onMeasure", "Landroid/view/View;", "view", "onClick", "setMedia", "imageCount", "I", "Lkotlin/Function1;", "Lio/streamlayer/sdk/twitter/Input;", "Lkotlin/ParameterName;", "name", "input", "onPhotoClicked", "Lkotlin/jvm/functions/Function1;", "getOnPhotoClicked", "()Lkotlin/jvm/functions/Function1;", "setOnPhotoClicked", "(Lkotlin/jvm/functions/Function1;)V", "", "imageViews", "[Landroidx/appcompat/widget/AppCompatImageView;", "Ljava/util/List;", "mediaDividerSize", "Landroid/content/Context;", "context", "Landroid/util/AttributeSet;", "attrs", "defStyleAttr", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "Size", "sdk_originalRelease"})
final class TweetPhotoView
extends ViewGroup
implements View.OnClickListener {
    @NotNull
    private final AppCompatImageView[] imageViews;
    @NotNull
    private List<TweetMedia> mediaEntities;
    private final int mediaDividerSize;
    private int imageCount;
    @Nullable
    private Function1<? super Input, Unit> onPhotoClicked;

    @JvmOverloads
    public TweetPhotoView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n);
        this.imageViews = new AppCompatImageView[4];
        this.mediaEntities = CollectionsKt.emptyList();
        this.mediaDividerSize = ViewExtensionsKt.getDp(1.0f);
    }

    public /* synthetic */ TweetPhotoView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final Size measureImages(int n, int n2) {
        n = View.MeasureSpec.getSize((int)n);
        n2 = View.MeasureSpec.getSize((int)n2);
        int n3 = this.mediaDividerSize;
        int n4 = (n - n3) / 2;
        n3 = (n2 - n3) / 2;
        switch (this.imageCount) {
            default: {
                break;
            }
            case 4: {
                TweetPhotoView tweetPhotoView = this;
                tweetPhotoView.measureImageView(0, n4, n3);
                tweetPhotoView.measureImageView(1, n4, n3);
                tweetPhotoView.measureImageView(2, n4, n3);
                tweetPhotoView.measureImageView(3, n4, n3);
                break;
            }
            case 3: {
                TweetPhotoView tweetPhotoView = this;
                tweetPhotoView.measureImageView(0, n4, n2);
                tweetPhotoView.measureImageView(1, n4, n3);
                tweetPhotoView.measureImageView(2, n4, n3);
                break;
            }
            case 2: {
                TweetPhotoView tweetPhotoView = this;
                tweetPhotoView.measureImageView(0, n4, n2);
                tweetPhotoView.measureImageView(1, n4, n2);
                break;
            }
            case 1: {
                this.measureImageView(0, n, n2);
            }
        }
        return Size.Companion.fromSize(n, n2);
    }

    private final void measureImageView(int n, int n2, int n3) {
        TweetPhotoView tweetPhotoView = tweetPhotoView.imageViews[n];
        if (tweetPhotoView != null) {
            int n4 = View.MeasureSpec.makeMeasureSpec((int)n2, (int)0x40000000);
            tweetPhotoView.measure(n4, View.MeasureSpec.makeMeasureSpec((int)n3, (int)0x40000000));
        }
    }

    private final void layoutImages() {
        TweetPhotoView tweetPhotoView = this;
        int n = tweetPhotoView.getMeasuredWidth();
        TweetPhotoView tweetPhotoView2 = this;
        int n2 = tweetPhotoView2.getMeasuredHeight();
        int n3 = tweetPhotoView2.mediaDividerSize;
        int n4 = (n - n3) / 2;
        int n5 = n3;
        n3 = (n2 - n3) / 2;
        int n6 = n4 + n5;
        switch (tweetPhotoView.imageCount) {
            default: {
                break;
            }
            case 4: {
                TweetPhotoView tweetPhotoView3 = this;
                TweetPhotoView tweetPhotoView4 = this;
                tweetPhotoView4.layoutImage(0, 0, 0, n4, n3);
                int n7 = n3 + tweetPhotoView4.mediaDividerSize;
                tweetPhotoView3.layoutImage(2, 0, n7, n4, n2);
                tweetPhotoView3.layoutImage(1, n6, 0, n, n3);
                n7 = n3 + tweetPhotoView3.mediaDividerSize;
                this.layoutImage(3, n6, n7, n, n2);
                break;
            }
            case 3: {
                TweetPhotoView tweetPhotoView5 = this;
                tweetPhotoView5.layoutImage(0, 0, 0, n4, n2);
                tweetPhotoView5.layoutImage(1, n6, 0, n, n3);
                int n8 = n3 + tweetPhotoView5.mediaDividerSize;
                this.layoutImage(2, n6, n8, n, n2);
                break;
            }
            case 2: {
                TweetPhotoView tweetPhotoView6 = this;
                tweetPhotoView6.layoutImage(0, 0, 0, n4, n2);
                this.layoutImage(1, n4 + tweetPhotoView6.mediaDividerSize, 0, n, n2);
                break;
            }
            case 1: {
                this.layoutImage(0, 0, 0, n, n2);
            }
        }
    }

    private final void layoutImage(int n, int n2, int n3, int n4, int n5) {
        TweetPhotoView tweetPhotoView = tweetPhotoView.imageViews[n];
        if (tweetPhotoView != null) {
            if (tweetPhotoView.getLeft() == n2 && tweetPhotoView.getTop() == n3 && tweetPhotoView.getRight() == n4 && tweetPhotoView.getBottom() == n5) {
                return;
            }
            tweetPhotoView.layout(n2, n3, n4, n5);
        }
    }

    private final void clearImageViews() {
        AppCompatImageView[] appCompatImageViewArray = this.imageViews;
        int n = this.imageViews.length;
        for (int i = 0; i < n; ++i) {
            AppCompatImageView appCompatImageView = appCompatImageViewArray[i];
            if (appCompatImageView == null) continue;
            ViewExtensionsKt.gone((View)appCompatImageView);
        }
        this.imageCount = 0;
    }

    private final void initializeImageViews(List<TweetMedia> list) {
        int n;
        this.imageCount = n = Math.min(4, list.size());
        int n2 = 0;
        if (n > 0) {
            while (true) {
                int n3 = n2 + 1;
                TweetPhotoView tweetPhotoView = this;
                AppCompatImageView appCompatImageView = this.getOrCreateImageView(n2);
                tweetPhotoView.setMediaImage((ImageView)appCompatImageView, tweetPhotoView.getSizedImagePath(list.get(n2)));
                if (n3 >= n) break;
                n2 = n3;
            }
        }
    }

    private final AppCompatImageView getOrCreateImageView(int n) {
        AppCompatImageView appCompatImageView = this.imageViews[n];
        if (appCompatImageView == null) {
            AppCompatImageView appCompatImageView2;
            appCompatImageView = appCompatImageView2;
            appCompatImageView(this.getContext());
            appCompatImageView.setLayoutParams(this.generateDefaultLayoutParams());
            appCompatImageView.setOnClickListener((View.OnClickListener)this);
            this.imageViews[n] = appCompatImageView;
            this.addView((View)appCompatImageView2, n);
        } else {
            TweetPhotoView tweetPhotoView = this;
            tweetPhotoView.measureImageView(n, 0, 0);
            tweetPhotoView.layoutImage(n, 0, 0, 0, 0);
        }
        AppCompatImageView appCompatImageView3 = appCompatImageView;
        appCompatImageView.setVisibility(0);
        appCompatImageView3.setTag((Object)n);
        return appCompatImageView3;
    }

    private final String getSizedImagePath(TweetMedia tweetMedia) {
        return this.imageCount > 1 ? Intrinsics.stringPlus((String)tweetMedia.getMediaUrlHttps(), (Object)":small") : tweetMedia.getMediaUrlHttps();
    }

    private final void setMediaImage(ImageView imageView, String string2) {
        ((RequestBuilder)((RequestBuilder)Glide.with((Context)imageView.getContext()).load(string2).centerCrop()).error(R.drawable.slr_ic_tw_photo_error_dark)).into(imageView);
    }

    @JvmOverloads
    public TweetPhotoView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public TweetPhotoView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Nullable
    public final Function1<Input, Unit> getOnPhotoClicked() {
        return this.onPhotoClicked;
    }

    public final void setOnPhotoClicked(@Nullable Function1<? super Input, Unit> function1) {
        this.onPhotoClicked = function1;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.imageCount > 0) {
            this.layoutImages();
        }
    }

    protected void onMeasure(int n, int n2) {
        Size size = this.imageCount > 0 ? this.measureImages(n, n2) : Size.Companion.getEMPTY();
        Size size2 = size;
        int n3 = size2.getWidth();
        this.setMeasuredDimension(n3, size2.getHeight());
    }

    public void onClick(@NotNull View object) {
        View view2 = object;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        object = view2.getTag();
        if (object != null) {
            int n = (Integer)object;
            Function1<? super Input, Unit> function1 = ((TweetPhotoView)((Object)object2)).onPhotoClicked;
            if (function1 != null) {
                Input input;
                ArrayList<String> arrayList;
                Object object2 = ((TweetPhotoView)((Object)object2)).mediaEntities;
                ArrayList<String> arrayList2 = arrayList;
                arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    arrayList2.add(((TweetMedia)object2.next()).getMediaUrlHttps());
                }
                object2 = input;
                input = new Input(n, arrayList2);
                function1.invoke(object2);
            }
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
    }

    public final void setMedia(@NotNull List<TweetMedia> list) {
        List<TweetMedia> list2 = list;
        Intrinsics.checkNotNullParameter(list2, (String)"mediaEntities");
        if (!list2.isEmpty() && !Intrinsics.areEqual(list, this.mediaEntities)) {
            TweetPhotoView tweetPhotoView = this;
            tweetPhotoView.mediaEntities = list;
            tweetPhotoView.clearImageViews();
            tweetPhotoView.initializeImageViews(list);
            tweetPhotoView.requestLayout();
            return;
        }
    }

    public void _$_clearFindViewByIdCache() {
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u001d\b\u0002\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u0019\u0010\u0003\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0004\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\f"}, d2={"Lio/streamlayer/sdk/twitter/view/TweetPhotoView$Size;", "", "", "width", "I", "getWidth", "()I", "height", "getHeight", "<init>", "(II)V", "Companion", "sdk_originalRelease"})
    private static final class Size {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final Size EMPTY = new Size(0, 0, 3, null);
        private final int width;
        private final int height;

        private Size(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        /* synthetic */ Size(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            this(n, n2);
        }

        public /* synthetic */ Size(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            this(n, n2);
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002R\u0019\u0010\u0007\u001a\u00020\u00058\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lio/streamlayer/sdk/twitter/view/TweetPhotoView$Size$Companion;", "", "", "w", "h", "Lio/streamlayer/sdk/twitter/view/TweetPhotoView$Size;", "fromSize", "EMPTY", "Lio/streamlayer/sdk/twitter/view/TweetPhotoView$Size;", "getEMPTY", "()Lio/streamlayer/sdk/twitter/view/TweetPhotoView$Size;", "<init>", "()V", "sdk_originalRelease"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }

            @NotNull
            public final Size getEMPTY() {
                return EMPTY;
            }

            @NotNull
            public final Size fromSize(int n, int n2) {
                Object object;
                n = Math.max(n, 0);
                n2 = Math.max(n2, 0);
                if (n == 0 && n2 == 0) {
                    object = ((Companion)object).getEMPTY();
                } else {
                    Size size;
                    object = size;
                    size = new Size(n, n2, null);
                }
                return object;
            }
        }
    }
}

