/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.grpc;

import android.content.Context;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.android.AndroidChannelBuilder;
import io.streamlayer.common.data.grpc.GrpcInterceptor;
import io.streamlayer.common.session.Session;
import io.streamlayer.sdk.model.sdksettings.OrganizationSettings;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0006\u0010\u0003\u001a\u00020\u0002R\u0016\u0010\u0005\u001a\u00020\u00048\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0016\u0010\b\u001a\u00020\u00078\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0013\u0010\r\u001a\u00020\n8F@\u0006\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u000f\u001a\u00020\u000e8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lio/streamlayer/common/data/grpc/ChatGrpcService;", "", "", "shutDownChannel", "Landroid/content/Context;", "context", "Landroid/content/Context;", "Lio/streamlayer/common/data/grpc/GrpcInterceptor;", "interceptor", "Lio/streamlayer/common/data/grpc/GrpcInterceptor;", "Lio/grpc/ManagedChannel;", "getManagedChannel", "()Lio/grpc/ManagedChannel;", "managedChannel", "Lio/streamlayer/common/session/Session;", "session", "Lio/streamlayer/common/session/Session;", "_managedChannel", "Lio/grpc/ManagedChannel;", "<init>", "(Lio/streamlayer/common/data/grpc/GrpcInterceptor;Lio/streamlayer/common/session/Session;Landroid/content/Context;)V", "sdk_originalRelease"})
public final class ChatGrpcService {
    @NotNull
    private final GrpcInterceptor interceptor;
    @NotNull
    private final Session session;
    @NotNull
    private final Context context;
    @Nullable
    private ManagedChannel _managedChannel;

    public ChatGrpcService(@NotNull GrpcInterceptor grpcInterceptor, @NotNull Session session, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)grpcInterceptor, (String)"interceptor");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.interceptor = grpcInterceptor;
        this.session = session;
        this.context = context;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final ManagedChannel getManagedChannel() {
        void var1_6;
        ManagedChannel managedChannel2 = this._managedChannel;
        if (managedChannel2 == null) {
            OrganizationSettings organizationSettings2 = this.session.getOrganizationSettings();
            if (organizationSettings2 == null) throw new RuntimeException("Organization Settings null");
            String string = organizationSettings2.getTinodeHost();
            if (string == null) throw new RuntimeException("Tinode host null");
            int n = 443;
            if (StringsKt.contains$default((CharSequence)organizationSettings2.getTinodeHost(), (CharSequence)":", (boolean)false, (int)2, null)) {
                List list = StringsKt.split$default((CharSequence)organizationSettings2.getTinodeHost(), (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                string = (String)list.get(0);
                n = Integer.parseInt((String)list.get(1));
            }
            TimeUnit timeUnit2 = TimeUnit.SECONDS;
            timeUnit2 = TimeUnit.HOURS;
            ManagedChannel managedChannel3 = ((AndroidChannelBuilder)((AndroidChannelBuilder)((AndroidChannelBuilder)((AndroidChannelBuilder)((AndroidChannelBuilder)((AndroidChannelBuilder)AndroidChannelBuilder.forAddress((String)string, (int)n).context(this.context).keepAliveWithoutCalls(true)).keepAliveTime(5L, timeUnit)).keepAliveTimeout(10L, timeUnit)).idleTimeout(24L, timeUnit2)).intercept(new ClientInterceptor[]{this.interceptor})).enableRetry()).build();
            Intrinsics.checkNotNullExpressionValue((Object)managedChannel3, (String)"run {\n                val organizationSettings: OrganizationSettings =\n                    session.organizationSettings ?: throw RuntimeException(\"Organization Settings null\")\n                var host: String = organizationSettings.tinodeHost ?: throw RuntimeException(\"Tinode host null\")\n                var port = 443\n                if (organizationSettings.tinodeHost.contains(\":\")) {\n                    val split = organizationSettings.tinodeHost.split(\":\")\n                    host = split[0]\n                    port = split[1].toInt()\n                }\n                AndroidChannelBuilder\n                    .forAddress(host, port)\n                    .context(context)\n                    .keepAliveWithoutCalls(true)\n                    .keepAliveTime(5, TimeUnit.SECONDS)\n                    .keepAliveTimeout(10, TimeUnit.SECONDS)\n                    .idleTimeout(24, TimeUnit.HOURS)\n                    .intercept(interceptor)\n                    .enableRetry()\n                    .build()\n            }");
        }
        this._managedChannel = var1_6;
        return var1_6;
    }

    public final void shutDownChannel() {
        ManagedChannel managedChannel2 = this._managedChannel;
        if (managedChannel2 != null) {
            managedChannel2.shutdown();
        }
        this._managedChannel = null;
    }
}

