/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.auth.verifyphone;

import android.telephony.PhoneNumberUtils;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import com.google.i18n.phonenumbers.AsYouTypeFormatter;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import io.streamlayer.common.utils.SLRLog;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b \u0010!J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J(\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J(\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0016H\u0016R\u0016\u0010\u0018\u001a\u00020\u00068\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001b\u001a\u00020\u001a8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001e\u00a8\u0006\""}, d2={"Lio/streamlayer/sdk/auth/verifyphone/PhoneNumberFormattingTextWatcher;", "Landroid/text/TextWatcher;", "", "s", "", "cursor", "", "reformat", "", "lastNonSeparator", "", "hasCursor", "getFormattedNumber", "", "stopFormatting", "start", "count", "hasSeparator", "after", "beforeTextChanged", "before", "onTextChanged", "Landroid/text/Editable;", "afterTextChanged", "countryCode", "Ljava/lang/String;", "Lcom/google/i18n/phonenumbers/AsYouTypeFormatter;", "mFormatter", "Lcom/google/i18n/phonenumbers/AsYouTypeFormatter;", "mStopFormatting", "Z", "mSelfChange", "<init>", "(Ljava/lang/String;)V", "sdk_originalRelease"})
public final class PhoneNumberFormattingTextWatcher
implements TextWatcher {
    private boolean mSelfChange;
    private boolean mStopFormatting;
    @NotNull
    private final AsYouTypeFormatter mFormatter;
    @NotNull
    private final String countryCode;

    public PhoneNumberFormattingTextWatcher(@Nullable String string2) {
        if (string2 != null) {
            AsYouTypeFormatter asYouTypeFormatter = PhoneNumberUtil.getInstance().getAsYouTypeFormatter(string2);
            Intrinsics.checkNotNullExpressionValue((Object)asYouTypeFormatter, (String)"getInstance().getAsYouTypeFormatter(countryCode)");
            this.mFormatter = asYouTypeFormatter;
            this.countryCode = string2;
            return;
        }
        throw new IllegalArgumentException("Required value was null.".toString());
    }

    private final String reformat(CharSequence charSequence, int n) {
        --n;
        ((PhoneNumberFormattingTextWatcher)((Object)string2)).mFormatter.clear();
        char c = '\u0000';
        boolean bl = false;
        int n2 = charSequence.length();
        int n3 = 0;
        if (n2 > 0) {
            while (true) {
                int n4 = n3;
                int n5 = n4 + 1;
                char c2 = charSequence.charAt(n4);
                if (PhoneNumberUtils.isNonSeparator((char)c2)) {
                    if (c != '\u0000') {
                        ((PhoneNumberFormattingTextWatcher)((Object)string2)).getFormattedNumber(c, bl);
                        bl = false;
                    }
                    c = c2;
                }
                if (n3 == n) {
                    bl = true;
                }
                if (n5 >= n2) break;
                n3 = n5;
            }
        }
        SLRLog.INSTANCE.d("lastNonSeparator", Intrinsics.stringPlus((String)"", (Object)Character.valueOf(c)));
        String string2 = ((PhoneNumberFormattingTextWatcher)((Object)string2)).getFormattedNumber(c, bl);
        String string3 = string2 == null ? null : new Regex("\\s").replace((CharSequence)string2, "");
        Intrinsics.checkNotNull(string3);
        return string3;
    }

    private final String getFormattedNumber(char c, boolean bl) {
        Object object;
        if (bl) {
            object = ((PhoneNumberFormattingTextWatcher)object).mFormatter.inputDigitAndRememberPosition(c);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mFormatter.inputDigitAndRememberPosition(lastNonSeparator)");
        } else {
            object = ((PhoneNumberFormattingTextWatcher)object).mFormatter.inputDigit(c);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mFormatter.inputDigit(\n            lastNonSeparator\n        )");
        }
        return object;
    }

    private final void stopFormatting() {
        this.mStopFormatting = true;
        this.mFormatter.clear();
    }

    private final boolean hasSeparator(CharSequence charSequence, int n, int n2) {
        int n3 = n;
        int n4 = n3 + n2;
        if (n3 < n4) {
            do {
                if (PhoneNumberUtils.isNonSeparator((char)charSequence.charAt(n++))) continue;
                return true;
            } while (n < n4);
        }
        return false;
    }

    public void beforeTextChanged(@NotNull CharSequence charSequence, int n, int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"s");
        if (!this.mSelfChange && !this.mStopFormatting) {
            if (n2 > 0 && this.hasSeparator(charSequence, n, n2)) {
                this.stopFormatting();
            }
            return;
        }
    }

    public void onTextChanged(@NotNull CharSequence charSequence, int n, int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"s");
        if (!this.mSelfChange && !this.mStopFormatting) {
            if (n3 > 0 && this.hasSeparator(charSequence, n, n3)) {
                this.stopFormatting();
            }
            return;
        }
    }

    public synchronized void afterTextChanged(@NotNull Editable editable) {
        Intrinsics.checkNotNullParameter((Object)editable, (String)"s");
        if (this.mStopFormatting) {
            boolean bl = editable.length() != 0;
            this.mStopFormatting = bl;
            return;
        }
        if (this.mSelfChange) {
            return;
        }
        String string2 = this.reformat((CharSequence)editable, Selection.getSelectionEnd((CharSequence)editable));
        if (string2 != null) {
            Editable editable2 = editable;
            this.mSelfChange = true;
            int n = editable.length();
            int n2 = string2.length();
            editable2.replace(0, n, (CharSequence)string2, 0, n2);
            Selection.setSelection((Spannable)editable2, (int)Selection.getSelectionEnd((CharSequence)editable2));
            this.mSelfChange = false;
        }
    }
}

