/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.messaging.chat;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.format.DateUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.mvvm.pagination.GenericPagedListAdapter;
import io.streamlayer.common.utils.DateUtil;
import io.streamlayer.common.utils.EmojiUtil;
import io.streamlayer.common.utils.UserUtil;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemChatReceiverBinding;
import io.streamlayer.sdk.messaging.chat.MessagingAdapterKt;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatType;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import java.util.Date;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u001d\u001e\u001fB%\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0014J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0003H\u0014J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u0016\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR$\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R*\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00138\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;", "Lio/streamlayer/common/mvvm/pagination/GenericPagedListAdapter;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "", "viewType", "getLayoutId", "Landroid/view/View;", "view", "Lio/streamlayer/common/mvvm/pagination/GenericPagedListAdapter$GenericViewHolder;", "getViewHolder", "position", "getItemViewType", "", "userId", "Ljava/lang/String;", "Lkotlin/Function1;", "", "alertClickHandle", "Lkotlin/jvm/functions/Function1;", "Lio/streamlayer/sdk/model/messaging/ChatType;", "value", "mode", "Lio/streamlayer/sdk/model/messaging/ChatType;", "getMode", "()Lio/streamlayer/sdk/model/messaging/ChatType;", "setMode", "(Lio/streamlayer/sdk/model/messaging/ChatType;)V", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "MessageReceiverViewHolder", "MessageSenderViewHolder", "MessageViewHolder", "sdk_originalRelease"})
public final class MessagingAdapter
extends GenericPagedListAdapter<ChatMessage> {
    @NotNull
    private final String userId;
    @NotNull
    private final Function1<ChatMessage, Unit> alertClickHandle;
    @NotNull
    private ChatType mode;

    public MessagingAdapter(@NotNull String string2, @NotNull Function1<? super ChatMessage, Unit> function1) {
        MessagingAdapter messagingAdapter = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"userId");
        Intrinsics.checkNotNullParameter(function1, (String)"alertClickHandle");
        super(MessagingAdapterKt.access$getDiffItemCallback$p());
        this.userId = string2;
        messagingAdapter.alertClickHandle = function1;
        messagingAdapter.mode = ChatType.P2P;
    }

    public static final /* synthetic */ ChatMessage access$getItem(MessagingAdapter messagingAdapter, int n) {
        return (ChatMessage)messagingAdapter.getItem(n);
    }

    @NotNull
    public final ChatType getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull ChatType chatType) {
        Intrinsics.checkNotNullParameter((Object)((Object)chatType), (String)"value");
        if (this.mode != chatType) {
            this.mode = chatType;
            this.notifyDataSetChanged();
        }
    }

    @Override
    protected int getLayoutId(int n) {
        return n != 0 ? (n != 1 ? (n != 2 ? 0 : R.layout.slr_item_chat_receiver) : R.layout.slr_item_chat_receiver) : R.layout.slr_item_chat_sender;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected GenericPagedListAdapter.GenericViewHolder<ChatMessage> getViewHolder(@NotNull View view2, int n) {
        void var4_11;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        if (n != 0) {
            if (n != 1) {
                MessageReceiverViewHolder messageReceiverViewHolder;
                if (n != 2) throw new RuntimeException(Intrinsics.stringPlus((String)"Unsupported item view type: ", (Object)n));
                Function1<ChatMessage, Unit> function1 = this.alertClickHandle;
                int n2 = R.drawable.slr_shape_chat_bubble_contact;
                MessageReceiverViewHolder messageReceiverViewHolder2 = messageReceiverViewHolder;
                messageReceiverViewHolder = new MessageReceiverViewHolder(this, view2, true, function1, n2);
                return var4_11;
            } else {
                MessageReceiverViewHolder messageReceiverViewHolder;
                Function1<ChatMessage, Unit> function1 = this.alertClickHandle;
                int n3 = R.drawable.slr_shape_chat_bubble_contact_p2p;
                MessageReceiverViewHolder messageReceiverViewHolder3 = messageReceiverViewHolder;
                messageReceiverViewHolder = new MessageReceiverViewHolder(this, view2, false, function1, n3);
            }
            return var4_11;
        } else {
            MessageSenderViewHolder messageSenderViewHolder;
            MessageSenderViewHolder messageSenderViewHolder2 = messageSenderViewHolder;
            Function1<ChatMessage, Unit> function1 = this.alertClickHandle;
            messageSenderViewHolder = new MessageSenderViewHolder(view2, function1);
        }
        return var4_11;
    }

    public int getItemViewType(int n) {
        block7: {
            int n2;
            block5: {
                block6: {
                    block4: {
                        ChatMessage chatMessage = (ChatMessage)this.getItem(n);
                        if (chatMessage == null) {
                            return super.getItemViewType(n);
                        }
                        boolean bl = Intrinsics.areEqual((Object)chatMessage.getSenderUserId(), (Object)this.userId);
                        n = bl ? 1 : 0;
                        if (!bl) break block4;
                        n2 = 0;
                        break block5;
                    }
                    if (n != 0 || this.mode != ChatType.Group) break block6;
                    n2 = 2;
                    break block5;
                }
                if (n != 0 || this.mode != ChatType.P2P) break block7;
                n2 = 1;
            }
            return n2;
        }
        throw new RuntimeException("Unsupported state. isCurrentUser: " + (n != 0) + "; mode: " + (Object)((Object)this.mode));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u00a6\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010,\u001a\u00020\u000b\u0012\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0011\u00a2\u0006\u0004\b-\u0010.J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0004J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0002H\u0004J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016R\u0016\u0010\t\u001a\u00020\b8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u001d\u0010\u0010\u001a\u00020\u000b8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR'\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00118\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u000b8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\r\u001a\u0004\b\u0017\u0010\u000fR\u0016\u0010\u001a\u001a\u00020\u00198\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u001d\u0010 \u001a\u00020\u001c8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\r\u001a\u0004\b\u001e\u0010\u001fR\u001d\u0010#\u001a\u00020\u001c8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\r\u001a\u0004\b\"\u0010\u001fR%\u0010'\u001a\n $*\u0004\u0018\u00010\u000b0\u000b8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\r\u001a\u0004\b&\u0010\u000fR\u0016\u0010(\u001a\u00020\u00198\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010\u001bR\u001f\u0010+\u001a\u0004\u0018\u00010\u000b8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\r\u001a\u0004\b*\u0010\u000f\u00a8\u0006/"}, d2={"Lio/streamlayer/sdk/messaging/chat/MessagingAdapter$MessageViewHolder;", "Lio/streamlayer/common/mvvm/pagination/GenericPagedListAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "getPreviousMessage", "getNextMessage", "message", "", "bind", "Landroid/graphics/drawable/Drawable;", "defaultBackground", "Landroid/graphics/drawable/Drawable;", "Landroid/view/View;", "chatMessageContainer$delegate", "Lkotlin/Lazy;", "getChatMessageContainer", "()Landroid/view/View;", "chatMessageContainer", "Lkotlin/Function1;", "alertClickHandle", "Lkotlin/jvm/functions/Function1;", "getAlertClickHandle", "()Lkotlin/jvm/functions/Function1;", "chatMessageLayout$delegate", "getChatMessageLayout", "chatMessageLayout", "", "largeVerticalMargin", "I", "Landroid/widget/TextView;", "chatMessageContent$delegate", "getChatMessageContent", "()Landroid/widget/TextView;", "chatMessageContent", "chatTimestamp$delegate", "getChatTimestamp", "chatTimestamp", "kotlin.jvm.PlatformType", "sendingFailedText$delegate", "getSendingFailedText", "sendingFailedText", "smallVerticalMargin", "chatAlertImage$delegate", "getChatAlertImage", "chatAlertImage", "itemView", "<init>", "(Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;Landroid/view/View;Lkotlin/jvm/functions/Function1;)V", "sdk_originalRelease"})
    public abstract class MessageViewHolder
    extends GenericPagedListAdapter.GenericViewHolder<ChatMessage> {
        @NotNull
        private final Function1<ChatMessage, Unit> alertClickHandle;
        @NotNull
        private final Lazy chatTimestamp$delegate;
        @NotNull
        private final Lazy chatMessageContent$delegate;
        @NotNull
        private final Lazy chatMessageContainer$delegate;
        @NotNull
        private final Lazy chatMessageLayout$delegate;
        @NotNull
        private final Lazy chatAlertImage$delegate;
        @NotNull
        private final Lazy sendingFailedText$delegate;
        @NotNull
        private final Drawable defaultBackground;
        private final int largeVerticalMargin;
        private final int smallVerticalMargin;

        public MessageViewHolder(@NotNull View view2, Function1<? super ChatMessage, Unit> function1) {
            Intrinsics.checkNotNullParameter((Object)((Object)MessagingAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            Intrinsics.checkNotNullParameter(function1, (String)"alertClickHandle");
            super(view2);
            this.alertClickHandle = function1;
            this.chatTimestamp$delegate = LazyKt.lazy((Function0)new Function0<TextView>(view2){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view2;
                    super(0);
                }

                public final TextView invoke() {
                    return (TextView)this.$itemView.findViewById(R.id.chatTimestamp);
                }
            });
            this.chatMessageContent$delegate = LazyKt.lazy((Function0)new Function0<TextView>(view2){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view2;
                    super(0);
                }

                public final TextView invoke() {
                    return (TextView)this.$itemView.findViewById(R.id.chatMessageContent);
                }
            });
            this.chatMessageContainer$delegate = LazyKt.lazy((Function0)new Function0<View>(view2){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view2;
                    super(0);
                }

                public final View invoke() {
                    return this.$itemView.findViewById(R.id.chatMessageContainer);
                }
            });
            this.chatMessageLayout$delegate = LazyKt.lazy((Function0)new Function0<View>(view2){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view2;
                    super(0);
                }

                public final View invoke() {
                    return this.$itemView.findViewById(R.id.chatMessageLayout);
                }
            });
            this.chatAlertImage$delegate = LazyKt.lazy((Function0)new Function0<View>(view2){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view2;
                    super(0);
                }

                public final View invoke() {
                    return this.$itemView.findViewById(R.id.alert);
                }
            });
            this.sendingFailedText$delegate = LazyKt.lazy((Function0)new Function0<View>(view2){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view2;
                    super(0);
                }

                public final View invoke() {
                    return this.$itemView.findViewById(R.id.sendingFailedMessage);
                }
            });
            Drawable drawable2 = this.getChatMessageContainer().getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"chatMessageContainer.background");
            this.defaultBackground = drawable2;
            this.largeVerticalMargin = (int)view2.getContext().getResources().getDimension(R.dimen.slr_chat_message_margin);
            this.smallVerticalMargin = (int)view2.getContext().getResources().getDimension(R.dimen.slr_chat_message_margin_small);
        }

        private final TextView getChatTimestamp() {
            Object object = this.chatTimestamp$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-chatTimestamp>(...)");
            return (TextView)object;
        }

        private final TextView getChatMessageContent() {
            Object object = this.chatMessageContent$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-chatMessageContent>(...)");
            return (TextView)object;
        }

        private final View getChatMessageContainer() {
            Object object = this.chatMessageContainer$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-chatMessageContainer>(...)");
            return (View)object;
        }

        private final View getChatMessageLayout() {
            return (View)this.chatMessageLayout$delegate.getValue();
        }

        private final View getChatAlertImage() {
            return (View)this.chatAlertImage$delegate.getValue();
        }

        private final View getSendingFailedText() {
            return (View)this.sendingFailedText$delegate.getValue();
        }

        private static final void bind$lambda-3(MessageViewHolder messageViewHolder, ChatMessage chatMessage, View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)messageViewHolder), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"$message");
            messageViewHolder.getAlertClickHandle().invoke((Object)chatMessage);
        }

        @NotNull
        public final Function1<ChatMessage, Unit> getAlertClickHandle() {
            return this.alertClickHandle;
        }

        @Nullable
        protected final ChatMessage getPreviousMessage() {
            Object object;
            MessageViewHolder messageViewHolder = object;
            int n = messageViewHolder.getLayoutPosition();
            try {
                object = Result.constructor-impl((Object)MessagingAdapter.access$getItem(object.MessagingAdapter.this, n + 1));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isFailure-impl((Object)object)) {
                object = null;
            }
            return (ChatMessage)object;
        }

        @Nullable
        protected final ChatMessage getNextMessage() {
            Object object;
            MessageViewHolder messageViewHolder = object;
            int n = messageViewHolder.getLayoutPosition();
            try {
                object = Result.constructor-impl((Object)MessagingAdapter.access$getItem(object.MessagingAdapter.this, n - 1));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isFailure-impl((Object)object)) {
                object = null;
            }
            return (ChatMessage)object;
        }

        @Override
        public void bind(@NotNull ChatMessage chatMessage) {
            block33: {
                block29: {
                    block32: {
                        ViewGroup.LayoutParams layoutParams;
                        ChatMessage chatMessage2;
                        block30: {
                            block31: {
                                ViewGroup.LayoutParams layoutParams2;
                                block28: {
                                    Object object;
                                    Object object2;
                                    ChatMessage chatMessage3 = chatMessage;
                                    Intrinsics.checkNotNullParameter((Object)chatMessage3, (String)"message");
                                    if (chatMessage3.getDate() != null) {
                                        this.getChatTimestamp().setText(DateUtils.getRelativeDateTimeString((Context)this.itemView.getContext(), (long)chatMessage.getDate().getTime(), (long)86400000L, (long)86400000L, (int)0));
                                    }
                                    MessageViewHolder messageViewHolder = this;
                                    int n = messageViewHolder.getLayoutPosition();
                                    try {
                                        object2 = Result.constructor-impl((Object)MessagingAdapter.access$getItem(MessagingAdapter.this, n + 1));
                                    }
                                    catch (Throwable throwable) {
                                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                    }
                                    if (Result.isFailure-impl((Object)object2)) {
                                        object2 = null;
                                    }
                                    object2 = (ChatMessage)object2;
                                    int n2 = chatMessage.getDate() != null && ((object2 == null ? null : ((ChatMessage)object2).getDate()) == null || !DateUtil.INSTANCE.isSameDay((Date)(object2 = ((ChatMessage)object2).getDate()), chatMessage.getDate())) ? 1 : 0;
                                    ViewExtensionsKt.visibleIf((View)this.getChatTimestamp(), n2 != 0);
                                    n2 = WhenMappings.$EnumSwitchMapping$0[chatMessage.getStatus().ordinal()];
                                    if (n2 != 1) {
                                        if (n2 != 2) {
                                            if (n2 != 3) {
                                                MessageViewHolder messageViewHolder2 = this;
                                                messageViewHolder2.itemView.setAlpha(1.0f);
                                                object = messageViewHolder2.getChatAlertImage();
                                                if (object != null) {
                                                    object.setVisibility(8);
                                                }
                                                object = this.getSendingFailedText();
                                                if (object != null) {
                                                    object.setVisibility(8);
                                                }
                                            } else {
                                                object = this.getChatAlertImage();
                                                if (object != null) {
                                                    object.setVisibility(8);
                                                }
                                                object = this.getSendingFailedText();
                                                if (object != null) {
                                                    object.setVisibility(8);
                                                }
                                            }
                                        } else {
                                            object = this.getChatAlertImage();
                                            if (object != null) {
                                                object.setVisibility(0);
                                            }
                                            object = this.getSendingFailedText();
                                            if (object != null) {
                                                object.setVisibility(0);
                                            }
                                            object = this.getChatAlertImage();
                                            if (object != null) {
                                                object.setOnClickListener(arg_0 -> MessageViewHolder.bind$lambda-3(this, chatMessage, arg_0));
                                            }
                                        }
                                    } else {
                                        MessageViewHolder messageViewHolder3 = this;
                                        messageViewHolder3.itemView.setAlpha(0.7f);
                                        object = messageViewHolder3.getChatAlertImage();
                                        if (object != null) {
                                            object.setVisibility(8);
                                        }
                                        object = this.getSendingFailedText();
                                        if (object != null) {
                                            object.setVisibility(8);
                                        }
                                    }
                                    object = EmojiUtil.INSTANCE;
                                    if (!((EmojiUtil)object).isEmojiOnly(chatMessage.getText())) break block28;
                                    int n3 = ((EmojiUtil)object).getEmojiCount(chatMessage.getText());
                                    float f = n3 == 1 ? 60.0f : (n3 <= 3 ? 30.0f : 14.0f);
                                    MessageViewHolder messageViewHolder4 = this;
                                    messageViewHolder4.getChatMessageContent().setTextSize(1, f);
                                    View view2 = messageViewHolder4.getChatMessageContainer();
                                    Drawable drawable2 = n3 <= 3 ? null : this.defaultBackground;
                                    view2.setBackground(drawable2);
                                    int n4 = n3 <= 3 ? 0 : ViewExtensionsKt.getDp(16.0f);
                                    if (n3 <= 3) {
                                        View view3 = this.getChatMessageContainer();
                                        n3 = view3.getPaddingTop();
                                        int n5 = view3.getPaddingBottom();
                                        view3.setPadding(n4, n3, n4, n5);
                                    }
                                    break block29;
                                }
                                MessageViewHolder messageViewHolder = this;
                                View view4 = messageViewHolder.getChatMessageContainer();
                                view4.setBackground(this.defaultBackground);
                                int n = ViewExtensionsKt.getDp(16.0f);
                                int n6 = view4.getPaddingTop();
                                int n7 = ViewExtensionsKt.getDp(16.0f);
                                int n8 = view4.getPaddingBottom();
                                view4.setPadding(n, n6, n7, n8);
                                chatMessage2 = messageViewHolder.getPreviousMessage();
                                if (Intrinsics.areEqual((Object)(chatMessage2 == null ? null : chatMessage2.getSenderUserId()), (Object)chatMessage.getSenderUserId())) break block30;
                                chatMessage2 = this.getChatMessageLayout();
                                if (chatMessage2 == null) {
                                    chatMessage2 = this.getChatMessageContainer();
                                }
                                if ((layoutParams2 = chatMessage2.getLayoutParams()) == null) break block31;
                                ChatMessage chatMessage4 = chatMessage2;
                                chatMessage2 = (ConstraintLayout.LayoutParams)layoutParams2;
                                chatMessage2.setMargins(0, this.largeVerticalMargin, 0, 0);
                                chatMessage4.setLayoutParams((ViewGroup.LayoutParams)chatMessage2);
                                break block32;
                            }
                            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                        }
                        chatMessage2 = this.getChatMessageLayout();
                        if (chatMessage2 == null) {
                            chatMessage2 = this.getChatMessageContainer();
                        }
                        if ((layoutParams = chatMessage2.getLayoutParams()) == null) break block33;
                        ChatMessage chatMessage5 = chatMessage2;
                        chatMessage2 = (ConstraintLayout.LayoutParams)layoutParams;
                        int n = this.smallVerticalMargin;
                        chatMessage2.setMargins(0, n, 0, n);
                        chatMessage5.setLayoutParams((ViewGroup.LayoutParams)chatMessage2);
                    }
                    this.getChatMessageContent().setTextSize(2, 14.0f);
                }
                this.getChatMessageContent().setText((CharSequence)chatMessage.getText());
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ChatMessageStatus.values().length];
                nArray[ChatMessageStatus.Sending.ordinal()] = 1;
                nArray[ChatMessageStatus.Failed.ordinal()] = 2;
                nArray[ChatMessageStatus.Success.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/streamlayer/sdk/messaging/chat/MessagingAdapter$MessageSenderViewHolder;", "Lio/streamlayer/sdk/messaging/chat/MessagingAdapter$MessageViewHolder;", "Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;", "Landroid/view/View;", "itemView", "Lkotlin/Function1;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "", "alertClickHandle", "<init>", "(Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;Landroid/view/View;Lkotlin/jvm/functions/Function1;)V", "sdk_originalRelease"})
    public final class MessageSenderViewHolder
    extends MessageViewHolder {
        public MessageSenderViewHolder(@NotNull View view2, Function1<? super ChatMessage, Unit> function1) {
            Intrinsics.checkNotNullParameter((Object)((Object)MessagingAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            Intrinsics.checkNotNullParameter(function1, (String)"alertClickHandle");
            super(view2, function1);
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B5\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016R\u0016\u0010\b\u001a\u00020\u00078\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0016\u0010\u000b\u001a\u00020\n8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lio/streamlayer/sdk/messaging/chat/MessagingAdapter$MessageReceiverViewHolder;", "Lio/streamlayer/sdk/messaging/chat/MessagingAdapter$MessageViewHolder;", "Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "message", "", "bind", "", "isGroup", "Z", "Lio/streamlayer/sdk/databinding/SlrItemChatReceiverBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemChatReceiverBinding;", "Landroid/view/View;", "itemView", "Lkotlin/Function1;", "alertClickHandle", "", "backgroundRes", "<init>", "(Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;Landroid/view/View;ZLkotlin/jvm/functions/Function1;I)V", "sdk_originalRelease"})
    public final class MessageReceiverViewHolder
    extends MessageViewHolder {
        private final boolean isGroup;
        @NotNull
        private final SlrItemChatReceiverBinding binding;
        final /* synthetic */ MessagingAdapter this$0;

        public MessageReceiverViewHolder(@NotNull MessagingAdapter messagingAdapter, View view2, @NotNull boolean bl, Function1<? super ChatMessage, Unit> function1, int n) {
            MessageReceiverViewHolder messageReceiverViewHolder = object;
            Intrinsics.checkNotNullParameter((Object)((Object)messagingAdapter), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            Intrinsics.checkNotNullParameter(function1, (String)"alertClickHandle");
            object.this$0 = messagingAdapter;
            super(view2, function1);
            object.isGroup = bl;
            Object object = SlrItemChatReceiverBinding.bind(view2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bind(itemView)");
            messageReceiverViewHolder.binding = object;
            ((SlrItemChatReceiverBinding)object).chatMessageContainer.setBackgroundResource(n);
        }

        @Override
        public void bind(@NotNull ChatMessage object) {
            MessageReceiverViewHolder messageReceiverViewHolder = this;
            ChatMessage chatMessage = object;
            Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"message");
            super.bind(chatMessage);
            TinodeContact tinodeContact = ((ChatMessage)object).getSender();
            SlrItemChatReceiverBinding slrItemChatReceiverBinding = messageReceiverViewHolder.binding;
            if (messageReceiverViewHolder.isGroup && tinodeContact != null) {
                Object object2 = this.getPreviousMessage();
                object2 = object2 == null ? null : ((ChatMessage)object2).getSenderUserId();
                boolean bl = Intrinsics.areEqual((Object)object2, (Object)((ChatMessage)object).getSenderUserId());
                object2 = this.getNextMessage();
                if (!Intrinsics.areEqual((Object)(object2 == null ? null : ((ChatMessage)object2).getSenderUserId()), (Object)((ChatMessage)object).getSenderUserId())) {
                    SlrItemChatReceiverBinding slrItemChatReceiverBinding2 = slrItemChatReceiverBinding;
                    ImageView imageView = slrItemChatReceiverBinding2.chatMessageAuthorAvatar;
                    Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"chatMessageAuthorAvatar");
                    ProfileExtensionsKt.loadContactAvatar(imageView, tinodeContact);
                    ImageView imageView2 = slrItemChatReceiverBinding2.chatMessageAuthorAvatar;
                    Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"chatMessageAuthorAvatar");
                    ViewExtensionsKt.visible((View)imageView2);
                } else {
                    ImageView imageView = slrItemChatReceiverBinding.chatMessageAuthorAvatar;
                    Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"chatMessageAuthorAvatar");
                    ViewExtensionsKt.invisible((View)imageView);
                }
                if (!bl) {
                    SlrItemChatReceiverBinding slrItemChatReceiverBinding3 = slrItemChatReceiverBinding;
                    slrItemChatReceiverBinding3.chatMessageAuthorName.setText((CharSequence)tinodeContact.getChatName());
                    TextView textView = slrItemChatReceiverBinding3.chatMessageAuthorName;
                    object = tinodeContact.getChatName();
                    int n = object == null ? -1 : UserUtil.INSTANCE.getColorFromName((String)object);
                    textView.setTextColor(n);
                    TextView textView2 = slrItemChatReceiverBinding.chatMessageAuthorName;
                    Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"chatMessageAuthorName");
                    ViewExtensionsKt.visible((View)textView2);
                } else {
                    TextView textView = slrItemChatReceiverBinding.chatMessageAuthorName;
                    Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"chatMessageAuthorName");
                    ViewExtensionsKt.gone((View)textView);
                }
            } else {
                SlrItemChatReceiverBinding slrItemChatReceiverBinding4 = slrItemChatReceiverBinding;
                ImageView imageView = slrItemChatReceiverBinding4.chatMessageAuthorAvatar;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"chatMessageAuthorAvatar");
                ViewExtensionsKt.gone((View)imageView);
                TextView textView = slrItemChatReceiverBinding4.chatMessageAuthorName;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"chatMessageAuthorName");
                ViewExtensionsKt.gone((View)textView);
            }
        }
    }
}

